/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.certificate;

import java.security.cert.CertificateParsingException;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.GeneralName;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.io.Base64Utilities;
import org.openspcoop2.utils.io.HexBinaryUtilities;

public class AuthorityKeyIdentifier {
    private org.bouncycastle.asn1.x509.AuthorityKeyIdentifier authorityKeyIdentifierBC;
    private long certSerialNumber;
    private byte[] keyIdentifier;
    private List<GeneralName> certIssuers = new ArrayList<GeneralName>();

    public org.bouncycastle.asn1.x509.AuthorityKeyIdentifier getAuthorityKeyIdentifier() {
        return this.authorityKeyIdentifierBC;
    }

    public long getCertSerialNumber() {
        return this.certSerialNumber;
    }

    public byte[] getKeyIdentifier() {
        return this.keyIdentifier;
    }

    public String getBase64KeyIdentifier() {
        return this.keyIdentifier != null ? Base64Utilities.encodeAsString(this.keyIdentifier) : null;
    }

    public String getHexKeyIdentifier() throws UtilsException {
        return this.keyIdentifier != null ? HexBinaryUtilities.encodeAsString(this.keyIdentifier) : null;
    }

    public List<GeneralName> getObjectCertIssuers() {
        return this.certIssuers;
    }

    public GeneralName getObjectCertIssuer(int index) {
        return this.certIssuers != null && this.certIssuers.size() > index ? this.certIssuers.get(index) : null;
    }

    public List<String> getCertIssuers() {
        ArrayList<String> s = new ArrayList<String>();
        if (this.certIssuers != null && !this.certIssuers.isEmpty()) {
            for (GeneralName o : this.certIssuers) {
                if (o.getName() == null) continue;
                s.add(o.getName().toString());
            }
        }
        return s;
    }

    public String getCertIssuer(int index) {
        if (this.certIssuers != null && this.certIssuers.size() > index) {
            return this.certIssuers.get(index) != null && this.certIssuers.get(index).getName() != null ? this.certIssuers.get(index).getName().toString() : null;
        }
        return null;
    }

    public boolean containsCertIssuer(String name) throws CertificateParsingException {
        return this.containsCertIssuerEngine(null, name);
    }

    public boolean containsCertIssuer(int tagNum, String name) throws CertificateParsingException {
        return this.containsCertIssuerEngine(tagNum, name);
    }

    private boolean containsCertIssuerEngine(Integer tagNum, String name) throws CertificateParsingException {
        if (name == null) {
            throw new CertificateParsingException("Param name undefined");
        }
        if (this.certIssuers != null && !this.certIssuers.isEmpty()) {
            for (GeneralName o : this.certIssuers) {
                if (!this.isEquals(o, tagNum, name)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isEquals(GeneralName o, Integer tagNum, String name) {
        if (o.getName() != null && name.equals(o.getName().toString())) {
            if (tagNum == null) {
                return true;
            }
            if (tagNum.intValue() == o.getTagNo()) {
                return true;
            }
        }
        return false;
    }

    public static AuthorityKeyIdentifier getAuthorityKeyIdentifier(byte[] encoded) {
        org.bouncycastle.asn1.x509.AuthorityKeyIdentifier authorityKeyIdentifier;
        Certificate c = Certificate.getInstance((Object)encoded);
        Extensions exts = c.getTBSCertificate().getExtensions();
        if (exts != null && (authorityKeyIdentifier = org.bouncycastle.asn1.x509.AuthorityKeyIdentifier.fromExtensions((Extensions)exts)) != null) {
            AuthorityKeyIdentifier aki = new AuthorityKeyIdentifier();
            aki.authorityKeyIdentifierBC = authorityKeyIdentifier;
            if (authorityKeyIdentifier.getAuthorityCertSerialNumber() != null) {
                aki.certSerialNumber = authorityKeyIdentifier.getAuthorityCertSerialNumber().longValue();
            }
            aki.keyIdentifier = authorityKeyIdentifier.getKeyIdentifier();
            if (authorityKeyIdentifier.getAuthorityCertIssuer() != null && authorityKeyIdentifier.getAuthorityCertIssuer().getNames() != null && authorityKeyIdentifier.getAuthorityCertIssuer().getNames().length > 0) {
                for (GeneralName gn : authorityKeyIdentifier.getAuthorityCertIssuer().getNames()) {
                    aki.certIssuers.add(gn);
                }
            }
            return aki;
        }
        return null;
    }
}

