/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.cache;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.cache.CacheAlgorithm;
import org.openspcoop2.utils.cache.CacheResponse;
import org.openspcoop2.utils.cache.CacheType;
import org.openspcoop2.utils.cache.EHCacheImpl;
import org.openspcoop2.utils.cache.ICacheImpl;
import org.openspcoop2.utils.cache.JCS3CacheImpl;
import org.openspcoop2.utils.cache.LimitedHashMapCacheImpl;
import org.slf4j.Logger;

public class Cache {
    public static boolean DEBUG_CACHE = false;
    private static Map<String, ICacheImpl> caches = new HashMap<String, ICacheImpl>();
    private ICacheImpl cache = null;
    public static boolean DEFAULT_DISABLE_SYNCRONIZED_GET = false;
    public static boolean DISABLE_SYNCRONIZED_GET = true;

    public static void setLog4jSystem() {
        JCS3CacheImpl.setLog4jSystem();
    }

    public static boolean initialize(Logger logConsole, Logger logCore, String cachePropertiesName, String rootDirectory, Properties objectProperties, String OPENSPCOOP2_LOCAL_HOME, String OPENSPCOOP2_CACHE_PROPERTIES, String OPENSPCOOP2_CACHE_LOCAL_PATH) {
        return JCS3CacheImpl.initialize(logConsole, logCore, cachePropertiesName, rootDirectory, objectProperties, OPENSPCOOP2_LOCAL_HOME, OPENSPCOOP2_CACHE_PROPERTIES, OPENSPCOOP2_CACHE_LOCAL_PATH);
    }

    public static String printStatistics(String separatorStat, String separatorCache) throws UtilsException {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            Cache.printStatistics(bout, separatorStat, separatorCache);
            bout.flush();
            bout.close();
            return bout.toString();
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public static void printStatistics(OutputStream out, String separatorStat, String separatorCache) throws UtilsException {
        try {
            if (caches != null && !caches.isEmpty()) {
                ArrayList<String> keys = new ArrayList<String>();
                keys.addAll(caches.keySet());
                Collections.sort(keys);
                for (String key : keys) {
                    try {
                        ICacheImpl cache = caches.get(key);
                        if (cache == null) continue;
                        String s = cache.printStats(separatorStat);
                        out.write(s.getBytes());
                        out.write(separatorCache.getBytes());
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public Cache(CacheType cacheType, String name) throws UtilsException {
        switch (cacheType) {
            case JCS: {
                this.cache = new JCS3CacheImpl(name);
                break;
            }
            case LimitedHashMap: {
                this.cache = new LimitedHashMapCacheImpl(name);
                break;
            }
            case EH: {
                this.cache = new EHCacheImpl(name);
            }
        }
    }

    public static void disableSyncronizedGetAsDefault() {
        DEFAULT_DISABLE_SYNCRONIZED_GET = DISABLE_SYNCRONIZED_GET;
    }

    public static boolean isDisableSyncronizedGetAsDefault() {
        return DEFAULT_DISABLE_SYNCRONIZED_GET;
    }

    @Deprecated
    public void disableSyncronizedGet() throws UtilsException {
        if (this.cache == null) {
            throw new UtilsException("Cache disabled");
        }
        this.cache.disableSyncronizedGet();
    }

    @Deprecated
    public boolean isDisableSyncronizedGet() throws UtilsException {
        if (this.cache == null) {
            throw new UtilsException("Cache disabled");
        }
        return this.cache.isDisableSyncronizedGet();
    }

    @Deprecated
    public void enableDebugSystemOut() throws UtilsException {
        if (this.cache == null) {
            throw new UtilsException("Cache disabled");
        }
        this.cache.enableDebugSystemOut();
    }

    @Deprecated
    boolean isEnableDebugSystemOut() throws UtilsException {
        if (this.cache == null) {
            throw new UtilsException("Cache disabled");
        }
        return this.cache.isEnableDebugSystemOut();
    }

    public int getCacheSize() {
        if (this.cache == null) {
            throw new RuntimeException("Cache not initialized");
        }
        return this.cache.getCacheSize();
    }

    public void setCacheSize(int cacheSize) {
        if (this.cache == null) {
            throw new RuntimeException("Cache not initialized");
        }
        this.cache.setCacheSize(cacheSize);
    }

    public CacheAlgorithm getCacheAlgoritm() {
        if (this.cache == null) {
            throw new RuntimeException("Cache not initialized");
        }
        return this.cache.getCacheAlgoritm();
    }

    public void setCacheAlgoritm(CacheAlgorithm cacheAlgoritm) {
        if (this.cache == null) {
            throw new RuntimeException("Cache not initialized");
        }
        this.cache.setCacheAlgoritm(cacheAlgoritm);
    }

    public long getItemIdleTime() throws UtilsException {
        if (this.cache == null) {
            throw new RuntimeException("Cache not initialized");
        }
        return this.cache.getItemIdleTime();
    }

    public void setItemIdleTime(long itemIdleTimeCache) throws UtilsException {
        if (this.cache == null) {
            throw new RuntimeException("Cache not initialized");
        }
        this.cache.setItemIdleTime(itemIdleTimeCache);
    }

    public long getItemLifeTime() throws UtilsException {
        if (this.cache == null) {
            throw new RuntimeException("Cache not initialized");
        }
        return this.cache.getItemLifeTime();
    }

    public boolean isEternal() throws UtilsException {
        if (this.cache == null) {
            throw new RuntimeException("Cache not initialized");
        }
        return this.cache.isEternal();
    }

    public void setItemLifeTime(long itemLifeTimeCache) throws UtilsException {
        if (this.cache == null) {
            throw new RuntimeException("Cache not initialized");
        }
        this.cache.setItemLifeTime(itemLifeTimeCache);
    }

    public void build() throws UtilsException {
        if (this.cache == null) {
            throw new RuntimeException("Cache not initialized");
        }
        this.cache.build();
        caches.put(this.cache.getName(), this.cache);
    }

    public void clear() throws UtilsException {
        if (this.cache != null) {
            try {
                this.cache.clear();
            }
            catch (Exception e) {
                throw new UtilsException(e.getMessage(), e);
            }
        }
    }

    public Object get(String key) {
        if (this.cache == null) {
            throw new RuntimeException("Cache not initialized");
        }
        if (DEBUG_CACHE) {
            System.out.println("GET @" + this.cache.getName() + " [" + key + "]");
        }
        return this.cache.get(key);
    }

    public void remove(String key) throws UtilsException {
        if (this.cache == null) {
            throw new RuntimeException("Cache not initialized");
        }
        try {
            this.cache.remove(key);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public void put(String key, CacheResponse value) throws UtilsException {
        if (this.cache == null) {
            throw new RuntimeException("Cache not initialized");
        }
        try {
            this.cache.put(key, value);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public void put(String key, Serializable value) throws UtilsException {
        if (this.cache == null) {
            throw new RuntimeException("Cache not initialized");
        }
        try {
            this.cache.put(key, value);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public int getItemCount() throws UtilsException {
        if (this.cache == null) {
            throw new RuntimeException("Cache not initialized");
        }
        return this.cache.getItemCount();
    }

    public List<String> keys() throws UtilsException {
        if (this.cache == null) {
            throw new RuntimeException("Cache not initialized");
        }
        return this.cache.keys();
    }

    public String printStats(String separator) throws UtilsException {
        if (this.cache == null) {
            throw new RuntimeException("Cache not initialized");
        }
        return this.cache.printStats(separator);
    }

    public void printStats(OutputStream out, String separator) throws UtilsException {
        if (this.cache == null) {
            throw new RuntimeException("Cache not initialized");
        }
        this.cache.printStats(out, separator);
    }

    public String toString() {
        if (this.cache == null) {
            return "NonDisponibile";
        }
        return this.cache.toString();
    }

    public String printKeys(String separator) throws UtilsException {
        if (this.cache == null) {
            throw new RuntimeException("Cache not initialized");
        }
        return this.cache.printKeys(separator);
    }
}

