/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.openspcoop2.utils.Semaphore;

public class SemaphoreLock {
    private static ScheduledExecutorService scheduler = null;
    private Semaphore semaphore;
    private boolean released = false;
    private ScheduledFuture<?> future;

    public static void initScheduledExecutorService() {
        scheduler = Executors.newScheduledThreadPool(1);
    }

    public static boolean isInitializedScheduledExecutorService() {
        return scheduler != null;
    }

    public static void releaseScheduledExecutorService() {
        if (scheduler != null) {
            scheduler.shutdown();
        }
    }

    public SemaphoreLock(Semaphore semaphore, String methodName, String idTransazione) {
        this.semaphore = semaphore;
        if (scheduler != null && this.semaphore.getInstanceLockHoldTimeoutMs() > 0L) {
            this.initScheduler(this.semaphore.getInstanceLockHoldTimeoutMs(), this.semaphore.isInstanceDebug(), methodName, idTransazione);
        }
    }

    private void initScheduler(long ms, boolean debug, String methodName, String idTransazione) {
        String logPrefix = " schedule lock hold timeout(" + ms + "ms) ";
        if (debug) {
            this.semaphore.debug(this.semaphore.getPrefix(methodName, idTransazione) + logPrefix + "...");
        }
        this.future = scheduler.schedule(() -> {
            if (!this.released) {
                this.logReleaseLockStart(debug, methodName, idTransazione, logPrefix);
                this.semaphore.release(null, methodName, idTransazione);
                this.released = true;
                this.logReleaseLockEnd(debug, methodName, idTransazione, logPrefix);
            }
        }, ms, TimeUnit.MILLISECONDS);
    }

    private void logReleaseLockStart(boolean debug, String methodName, String idTransazione, String logPrefix) {
        String msg = this.semaphore.getPrefix(methodName, idTransazione) + logPrefix + "expired; release lock ...";
        if (Semaphore.getLogDebug() != null) {
            Semaphore.getLogDebug().error(msg);
        }
        if (debug) {
            this.semaphore.debug(msg);
        }
    }

    private void logReleaseLockEnd(boolean debug, String methodName, String idTransazione, String logPrefix) {
        String msg = this.semaphore.getPrefix(methodName, idTransazione) + logPrefix + "expired; lock released";
        if (Semaphore.getLogDebug() != null) {
            Semaphore.getLogDebug().error(msg);
        }
        if (debug) {
            this.semaphore.debug(msg);
        }
    }

    public void release(String methodName, String idTransazione) {
        if (methodName == null || idTransazione != null) {
            // empty if block
        }
        if (!this.released && scheduler != null) {
            this.future.cancel(false);
            this.released = true;
        }
    }
}

