/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.spcoop.validator;

import java.util.ArrayList;
import java.util.List;
import org.openspcoop2.core.constants.Costanti;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziException;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziNotFound;
import org.openspcoop2.core.registry.driver.IDServizioFactory;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.protocol.basic.BasicStateComponentFactory;
import org.openspcoop2.protocol.registry.RegistroServiziManager;
import org.openspcoop2.protocol.registry.RegistroServiziReader;
import org.openspcoop2.protocol.registry.RisultatoValidazione;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.Context;
import org.openspcoop2.protocol.sdk.Eccezione;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.Riscontro;
import org.openspcoop2.protocol.sdk.SecurityInfo;
import org.openspcoop2.protocol.sdk.Servizio;
import org.openspcoop2.protocol.sdk.Trasmissione;
import org.openspcoop2.protocol.sdk.config.ITraduttore;
import org.openspcoop2.protocol.sdk.constants.CodiceErroreCooperazione;
import org.openspcoop2.protocol.sdk.constants.ContestoCodificaEccezione;
import org.openspcoop2.protocol.sdk.constants.Inoltro;
import org.openspcoop2.protocol.sdk.constants.LivelloRilevanza;
import org.openspcoop2.protocol.sdk.constants.ProfiloDiCollaborazione;
import org.openspcoop2.protocol.sdk.constants.RuoloBusta;
import org.openspcoop2.protocol.sdk.constants.TipoOraRegistrazione;
import org.openspcoop2.protocol.sdk.state.IState;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.openspcoop2.protocol.sdk.validator.IValidazioneSemantica;
import org.openspcoop2.protocol.sdk.validator.ProprietaValidazione;
import org.openspcoop2.protocol.sdk.validator.ValidazioneSemanticaResult;
import org.openspcoop2.protocol.spcoop.constants.SPCoopCostantiPosizioneEccezione;
import org.openspcoop2.utils.digest.IDigestReader;

public class SPCoopValidazioneSemantica
extends BasicStateComponentFactory
implements IValidazioneSemantica {
    private List<Eccezione> erroriValidazione;
    private List<Eccezione> erroriProcessamento;
    private Busta busta;
    private boolean validazioneIDEGovCompleta = false;
    private String servizioCorrelato;
    private String tipoServizioCorrelato;
    private Integer versioneServizioCorrelato = 1;
    private String azioneCorrelata;
    private RegistroServiziManager registroServiziReader;
    private Servizio infoServizio = null;
    private Context context;

    public SPCoopValidazioneSemantica(IProtocolFactory<?> protocolFactory, IState state) throws ProtocolException {
        super(protocolFactory, state);
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public void valida(ProprietaValidazione tipoValidazione, RuoloBusta tipoBusta, String profiloGestione) {
        try {
            int i;
            Eccezione ecc;
            Eccezione ecc2;
            RequestInfo requestInfo = null;
            if (this.context != null && this.context.containsKey(Costanti.REQUEST_INFO)) {
                requestInfo = (RequestInfo)this.context.getObject(Costanti.REQUEST_INFO);
            }
            this.erroriValidazione = new ArrayList<Eccezione>();
            this.erroriProcessamento = new ArrayList<Eccezione>();
            if (!RegistroServiziReader.isInitialize() || this.registroServiziReader == null) {
                this.log.error("Registro dei Servizi non inizializzato.");
                Eccezione ecc3 = new Eccezione();
                ecc3.setContestoCodifica(ContestoCodificaEccezione.PROCESSAMENTO);
                ecc3.setCodiceEccezione(CodiceErroreCooperazione.ERRORE_GENERICO_PROCESSAMENTO_MESSAGGIO);
                ecc3.setRilevanza(LivelloRilevanza.ERROR);
                ecc3.setDescrizione("Registro dei Servizi non disponibile");
                this.erroriProcessamento.add(ecc3);
                return;
            }
            IDSoggetto soggMitt = new IDSoggetto(this.busta.getTipoMittente(), this.busta.getMittente());
            String dominioMittente = null;
            boolean mittenteSconosciuto = false;
            try {
                dominioMittente = this.registroServiziReader.getDominio(soggMitt, null, this.protocolFactory, requestInfo);
                if (dominioMittente == null) {
                    throw new Exception("Dominio non definito");
                }
                this.busta.setIdentificativoPortaMittente(dominioMittente);
            }
            catch (DriverRegistroServiziNotFound es) {
                ecc2 = new Eccezione();
                ecc2.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                ecc2.setCodiceEccezione(CodiceErroreCooperazione.MITTENTE_SCONOSCIUTO);
                ecc2.setRilevanza(LivelloRilevanza.ERROR);
                ecc2.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_MITTENTE_SCONOSCIUTO_POSIZIONE_IDENTIFICATIVO_PARTE.toString());
                this.log.debug("Identificazione mittente fallita:" + es.getMessage());
                this.erroriValidazione.add(ecc2);
                mittenteSconosciuto = true;
            }
            catch (Exception es) {
                ecc2 = new Eccezione();
                ecc2.setContestoCodifica(ContestoCodificaEccezione.PROCESSAMENTO);
                ecc2.setCodiceEccezione(CodiceErroreCooperazione.ERRORE_GENERICO_PROCESSAMENTO_MESSAGGIO);
                ecc2.setRilevanza(LivelloRilevanza.ERROR);
                ecc2.setDescrizione("Identificazione mittente non riuscita: errore di processamento");
                this.log.error("Identificazione mittente non riuscita", (Throwable)es);
                this.erroriProcessamento.add(ecc2);
                mittenteSconosciuto = true;
            }
            IDSoggetto soggDest = new IDSoggetto(this.busta.getTipoDestinatario(), this.busta.getDestinatario());
            String dominioDestinatario = null;
            boolean destinatarioSconosciuto = false;
            try {
                dominioDestinatario = this.registroServiziReader.getDominio(soggDest, null, this.protocolFactory, requestInfo);
                if (dominioDestinatario == null) {
                    throw new Exception("Dominio non definito");
                }
                this.busta.setIdentificativoPortaDestinatario(dominioDestinatario);
            }
            catch (DriverRegistroServiziNotFound es) {
                ecc = new Eccezione();
                ecc.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                ecc.setCodiceEccezione(CodiceErroreCooperazione.DESTINATARIO_SCONOSCIUTO);
                ecc.setRilevanza(LivelloRilevanza.ERROR);
                ecc.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_DESTINATARIO_SCONOSCIUTO_POSIZIONE_IDENTIFICATIVO_PARTE.toString());
                this.log.debug("Identificazione destinatario fallita: " + es.getMessage());
                this.erroriValidazione.add(ecc);
                destinatarioSconosciuto = true;
            }
            catch (Exception es) {
                ecc = new Eccezione();
                ecc.setContestoCodifica(ContestoCodificaEccezione.PROCESSAMENTO);
                ecc.setCodiceEccezione(CodiceErroreCooperazione.ERRORE_GENERICO_PROCESSAMENTO_MESSAGGIO);
                ecc.setRilevanza(LivelloRilevanza.ERROR);
                ecc.setDescrizione("Identificazione destinatario non riuscita: errore di processamento");
                this.log.error("Identificazione destinatario non riuscita", (Throwable)es);
                this.erroriProcessamento.add(ecc);
                destinatarioSconosciuto = true;
            }
            RisultatoValidazione risultatoValidazioneServizio = null;
            if (!RuoloBusta.BUSTA_DI_SERVIZIO.equals(tipoBusta.toString())) {
                risultatoValidazioneServizio = this.riconoscimentoServizioAzione(tipoBusta, mittenteSconosciuto, destinatarioSconosciuto);
            }
            boolean servizioBustaValido = false;
            if (!(RuoloBusta.BUSTA_DI_SERVIZIO.equals(tipoBusta.toString()) || destinatarioSconosciuto || mittenteSconosciuto)) {
                if (risultatoValidazioneServizio != null && risultatoValidazioneServizio.getServizioRegistrato()) {
                    if (this.busta.getAzione() == null && risultatoValidazioneServizio.getAccessoSenzaAzione()) {
                        servizioBustaValido = true;
                    } else if (this.busta.getAzione() != null && risultatoValidazioneServizio.getAzioni() != null) {
                        for (int j = 0; j < risultatoValidazioneServizio.sizeAzioni(); ++j) {
                            if (!this.busta.getAzione().equals(risultatoValidazioneServizio.getAzioni()[j])) continue;
                            servizioBustaValido = true;
                            break;
                        }
                    }
                }
                if (servizioBustaValido) {
                    IDSoggetto idSoggettoFruitore = new IDSoggetto();
                    IDSoggetto idSoggettoErogatore = new IDSoggetto();
                    this.impostaFruitoreErogatoreRealiServizio(idSoggettoFruitore, idSoggettoErogatore, tipoBusta);
                    IDServizio idServizio = IDServizioFactory.getInstance().getIDServizioFromValues(this.busta.getTipoServizio(), this.busta.getServizio(), idSoggettoErogatore, this.busta.getVersioneServizio().intValue());
                    idServizio.setAzione(this.busta.getAzione());
                    try {
                        this.infoServizio = this.registroServiziReader.getInfoServizio(idSoggettoFruitore, idServizio, null, false, true, requestInfo);
                    }
                    catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
                        // empty catch block
                    }
                    if (this.infoServizio == null) {
                        try {
                            this.infoServizio = this.registroServiziReader.getInfoServizioCorrelato(soggMitt, idServizio, null, true, requestInfo);
                        }
                        catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
                            // empty catch block
                        }
                    }
                    if (this.infoServizio == null) {
                        Eccezione ecc4 = new Eccezione();
                        ecc4.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                        ecc4.setCodiceEccezione(CodiceErroreCooperazione.ERRORE_GENERICO_PROCESSAMENTO_MESSAGGIO);
                        ecc4.setRilevanza(LivelloRilevanza.ERROR);
                        ecc4.setDescrizione("Raccolta informazioni servizio: servizio sconosciuto");
                        this.erroriValidazione.add(ecc4);
                        servizioBustaValido = false;
                    }
                }
            }
            if (servizioBustaValido && tipoValidazione.isValidazioneProfiloCollaborazione() && RuoloBusta.RICHIESTA.equals(tipoBusta.toString())) {
                this.riconoscimentoProfiloCollaborazione(tipoBusta);
            }
            if (!mittenteSconosciuto && !this.validazioneID_engine(this.busta.getID(), this.busta.getMittente(), dominioMittente)) {
                Eccezione ecc5 = new Eccezione();
                ecc5.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                ecc5.setCodiceEccezione(CodiceErroreCooperazione.IDENTIFICATIVO_MESSAGGIO_NON_VALIDO);
                ecc5.setRilevanza(LivelloRilevanza.ERROR);
                ecc5.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_ID_MESSAGGIO_NON_VALIDO_POSIZIONE.toString());
                this.erroriValidazione.add(ecc5);
            }
            if (this.busta.getRiferimentoMessaggio() != null) {
                boolean validazioneIDRiferimentoMessaggio = true;
                if (ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO.equals((Object)this.busta.getProfiloDiCollaborazione()) && RuoloBusta.RISPOSTA.equals(tipoBusta.toString())) {
                    if (!mittenteSconosciuto) {
                        validazioneIDRiferimentoMessaggio = this.validazioneID_engine(this.busta.getRiferimentoMessaggio(), this.busta.getMittente(), dominioMittente);
                    }
                } else if (!destinatarioSconosciuto) {
                    validazioneIDRiferimentoMessaggio = this.validazioneID_engine(this.busta.getRiferimentoMessaggio(), this.busta.getDestinatario(), dominioDestinatario);
                }
                if (!validazioneIDRiferimentoMessaggio) {
                    Eccezione ecc6 = new Eccezione();
                    ecc6.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                    ecc6.setCodiceEccezione(CodiceErroreCooperazione.RIFERIMENTO_MESSAGGIO_NON_VALIDO);
                    ecc6.setRilevanza(LivelloRilevanza.ERROR);
                    ecc6.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_RIFERIMENTO_MESSAGGIO_NON_VALIDO_POSIZIONE.toString());
                    this.erroriValidazione.add(ecc6);
                }
            }
            if (!RuoloBusta.BUSTA_DI_SERVIZIO.equals(tipoBusta.toString())) {
                this.validazioneCollaborazione(tipoBusta, dominioMittente, dominioDestinatario);
            }
            if (!"eGov1.1-lineeGuida1.1".equals(profiloGestione) && this.busta.getSequenza() != -1L) {
                if (this.busta.getCollaborazione() == null || this.busta.getInoltro() == null) {
                    Eccezione ecc7 = new Eccezione();
                    ecc7.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                    ecc7.setCodiceEccezione(CodiceErroreCooperazione.CONSEGNA_IN_ORDINE_NON_VALIDA);
                    ecc7.setRilevanza(LivelloRilevanza.ERROR);
                    if (this.busta.getCollaborazione() == null && this.busta.getInoltro() == null) {
                        ecc7.setDescrizione("Sequenza non gestibile, elementi Collaborazione e ProfiloTrasmissione non presenti");
                    } else if (this.busta.getCollaborazione() == null) {
                        ecc7.setDescrizione("Sequenza non gestibile, elemento Collaborazione non presente");
                    } else {
                        ecc7.setDescrizione("Sequenza non gestibile, elemento ProfiloTrasmissione non presente");
                    }
                    this.erroriValidazione.add(ecc7);
                } else if (!Inoltro.SENZA_DUPLICATI.equals((Object)this.busta.getInoltro()) || !this.busta.isConfermaRicezione()) {
                    Eccezione ecc8 = new Eccezione();
                    ecc8.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                    ecc8.setCodiceEccezione(CodiceErroreCooperazione.CONSEGNA_IN_ORDINE_NON_GESTIBILE);
                    ecc8.setRilevanza(LivelloRilevanza.ERROR);
                    if (!Inoltro.SENZA_DUPLICATI.equals((Object)this.busta.getInoltro()) && !this.busta.isConfermaRicezione()) {
                        ecc8.setDescrizione("Sequenza non gestibile, attributi dell'elemento ProfiloTrasmissione non validi con la sequenza");
                    } else if (!this.busta.isConfermaRicezione()) {
                        ecc8.setDescrizione("Sequenza non gestibile, attributo confermaRicezione dell'elemento ProfiloTrasmissione non valido con la sequenza");
                    } else {
                        ecc8.setDescrizione("Sequenza non gestibile, attributo inoltro dell'elemento ProfiloTrasmissione non valido con la sequenza");
                    }
                    this.erroriValidazione.add(ecc8);
                }
            }
            for (i = 0; i < this.busta.sizeListaRiscontri(); ++i) {
                Riscontro r = this.busta.getRiscontro(i);
                if (this.validazioneID_engine(r.getID())) continue;
                Eccezione ecc9 = new Eccezione();
                ecc9.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                ecc9.setCodiceEccezione(CodiceErroreCooperazione.RISCONTRO_IDENTIFICATIVO_MESSAGGIO_NON_VALIDO);
                ecc9.setRilevanza(LivelloRilevanza.ERROR);
                ecc9.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_LISTA_RISCONTRI_NON_VALIDA_POSIZIONE_RISCONTRO_IDENTIFICATORE.toString());
                this.erroriValidazione.add(ecc9);
            }
            for (i = 0; i < this.busta.sizeListaTrasmissioni(); ++i) {
                Eccezione ecc10;
                Eccezione ecc11;
                Trasmissione t = this.busta.getTrasmissione(i);
                IDSoggetto soggOrig = new IDSoggetto(t.getTipoOrigine(), t.getOrigine());
                String dominioOrig = null;
                try {
                    dominioOrig = this.registroServiziReader.getDominio(soggOrig, null, this.protocolFactory, requestInfo);
                    if (dominioOrig == null) {
                        throw new Exception("Dominio non definito");
                    }
                    t.setIdentificativoPortaOrigine(dominioOrig);
                }
                catch (DriverRegistroServiziNotFound es) {
                    ecc11 = new Eccezione();
                    ecc11.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                    ecc11.setCodiceEccezione(CodiceErroreCooperazione.TRASMISSIONE_ORIGINE_NON_VALIDA);
                    ecc11.setRilevanza(LivelloRilevanza.ERROR);
                    ecc11.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_LISTA_TRASMISSIONI_NON_VALIDA_POSIZIONE_TRASMISSIONE_ORIGINE_IDENTIFICATIVO_PARTE.toString());
                    this.log.debug("Identificazione origine trasmissione fallita:" + es.getMessage());
                    this.erroriValidazione.add(ecc11);
                }
                catch (Exception es) {
                    ecc11 = new Eccezione();
                    ecc11.setContestoCodifica(ContestoCodificaEccezione.PROCESSAMENTO);
                    ecc11.setCodiceEccezione(CodiceErroreCooperazione.ERRORE_GENERICO_PROCESSAMENTO_MESSAGGIO);
                    ecc11.setRilevanza(LivelloRilevanza.ERROR);
                    ecc11.setDescrizione("Identificazione origine della trasmissione non riuscita: errore di processamento");
                    this.log.error("Identificazione origine trasmissione non riuscita", (Throwable)es);
                    this.erroriProcessamento.add(ecc11);
                }
                IDSoggetto soggDestTr = new IDSoggetto(t.getTipoDestinazione(), t.getDestinazione());
                String dominioDestinatarioTr = null;
                try {
                    dominioDestinatarioTr = this.registroServiziReader.getDominio(soggDestTr, null, this.protocolFactory, requestInfo);
                    if (dominioDestinatarioTr == null) {
                        throw new Exception("Dominio non definito");
                    }
                    t.setIdentificativoPortaDestinazione(dominioDestinatarioTr);
                    continue;
                }
                catch (DriverRegistroServiziNotFound es) {
                    ecc10 = new Eccezione();
                    ecc10.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                    ecc10.setCodiceEccezione(CodiceErroreCooperazione.TRASMISSIONE_DESTINAZIONE_NON_VALIDA);
                    ecc10.setRilevanza(LivelloRilevanza.ERROR);
                    ecc10.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_LISTA_TRASMISSIONI_NON_VALIDA_POSIZIONE_TRASMISSIONE_DESTINAZIONE_IDENTIFICATIVO_PARTE.toString());
                    this.log.debug("Identificazione destinazione trasmissione fallita:" + es.getMessage());
                    this.erroriValidazione.add(ecc10);
                    continue;
                }
                catch (Exception es) {
                    ecc10 = new Eccezione();
                    ecc10.setContestoCodifica(ContestoCodificaEccezione.PROCESSAMENTO);
                    ecc10.setCodiceEccezione(CodiceErroreCooperazione.ERRORE_GENERICO_PROCESSAMENTO_MESSAGGIO);
                    ecc10.setRilevanza(LivelloRilevanza.ERROR);
                    ecc10.setDescrizione("Identificazione destinazione della trasmissione non riuscita: errore di processamento");
                    this.log.error("Identificazione destinazione trasmissione non riuscita", (Throwable)es);
                    this.erroriProcessamento.add(ecc10);
                }
            }
            if ("eGov1.1-lineeGuida1.1".equals(profiloGestione)) {
                this.validazioneLineeGuida11();
            }
        }
        catch (Exception e) {
            this.log.error("ValidazioneSemantica: riscontrato errore durante la validazione", (Throwable)e);
            Eccezione ecc = new Eccezione();
            ecc.setContestoCodifica(ContestoCodificaEccezione.PROCESSAMENTO);
            ecc.setCodiceEccezione(CodiceErroreCooperazione.ERRORE_GENERICO_PROCESSAMENTO_MESSAGGIO);
            ecc.setRilevanza(LivelloRilevanza.ERROR);
            ecc.setDescrizione("Errore di processamento durante la validazione semantica.");
            this.erroriProcessamento.add(ecc);
        }
    }

    private void validazioneCollaborazione(RuoloBusta tipoBusta, String dominioMittente, String dominioDestinatario) throws ProtocolException {
        if (this.busta.getCollaborazione() != null && !this.validazioneID_engine(this.busta.getCollaborazione(), this.busta.getMittente(), dominioMittente) && !this.validazioneID_engine(this.busta.getCollaborazione(), this.busta.getDestinatario(), dominioDestinatario)) {
            Eccezione ecc = new Eccezione();
            ecc.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
            ecc.setCodiceEccezione(CodiceErroreCooperazione.COLLABORAZIONE_SCONOSCIUTA);
            ecc.setRilevanza(LivelloRilevanza.ERROR);
            ecc.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_COLLABORAZIONE_SCONOSCIUTA_POSIZIONE.toString());
            this.erroriValidazione.add(ecc);
            return;
        }
    }

    private void impostaFruitoreErogatoreRealiServizio(IDSoggetto fruitore, IDSoggetto erogatore, RuoloBusta tipoBusta) {
        if (RuoloBusta.RICHIESTA.equals(tipoBusta.toString()) || RuoloBusta.RISPOSTA.equals(tipoBusta.toString()) && ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO.equals((Object)this.busta.getProfiloDiCollaborazione()) || RuoloBusta.RISPOSTA.equals(tipoBusta.toString()) && ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO.equals((Object)this.busta.getProfiloDiCollaborazione())) {
            if (erogatore != null) {
                erogatore.setTipo(this.busta.getTipoDestinatario());
                erogatore.setNome(this.busta.getDestinatario());
            }
            if (fruitore != null) {
                fruitore.setTipo(this.busta.getTipoMittente());
                fruitore.setNome(this.busta.getMittente());
            }
        } else if (RuoloBusta.RISPOSTA.equals(tipoBusta.toString()) || RuoloBusta.RICEVUTA_RICHIESTA.equals(tipoBusta.toString()) || RuoloBusta.RICEVUTA_RISPOSTA.equals(tipoBusta.toString())) {
            if (erogatore != null) {
                erogatore.setTipo(this.busta.getTipoMittente());
                erogatore.setNome(this.busta.getMittente());
            }
            if (fruitore != null) {
                fruitore.setTipo(this.busta.getTipoDestinatario());
                fruitore.setNome(this.busta.getDestinatario());
            }
        }
    }

    private RisultatoValidazione riconoscimentoServizioAzione(RuoloBusta tipoBusta, boolean mittenteSconosciuto, boolean destinatarioSconosciuto) throws ProtocolException, DriverRegistroServiziException {
        Eccezione ecc;
        if (mittenteSconosciuto) {
            return null;
        }
        if (destinatarioSconosciuto) {
            return null;
        }
        IDSoggetto idSoggettoErogatore = new IDSoggetto();
        IDSoggetto idSoggettoFruitore = null;
        if (ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO.equals((Object)this.busta.getProfiloDiCollaborazione()) && RuoloBusta.RICHIESTA.equals(tipoBusta.toString())) {
            idSoggettoFruitore = new IDSoggetto();
        } else if (ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO.equals((Object)this.busta.getProfiloDiCollaborazione())) {
            idSoggettoFruitore = new IDSoggetto();
        }
        this.impostaFruitoreErogatoreRealiServizio(idSoggettoFruitore, idSoggettoErogatore, tipoBusta);
        RisultatoValidazione validazione = null;
        if (this.busta.getServizio() != null && this.busta.getTipoServizio() != null) {
            IDServizio idService = IDServizioFactory.getInstance().getIDServizioFromValues(this.busta.getTipoServizio(), this.busta.getServizio(), idSoggettoErogatore, this.busta.getVersioneServizio().intValue());
            idService.setAzione(this.busta.getAzione());
            try {
                validazione = this.registroServiziReader.validaServizio(idSoggettoFruitore, idService, null);
            }
            catch (Exception e) {
                this.log.error("Errore durante l'accesso al registro per la validazione del servizio e dell'azione", (Throwable)e);
                Eccezione ecc2 = new Eccezione();
                ecc2.setContestoCodifica(ContestoCodificaEccezione.PROCESSAMENTO);
                ecc2.setCodiceEccezione(CodiceErroreCooperazione.ERRORE_GENERICO_PROCESSAMENTO_MESSAGGIO);
                ecc2.setRilevanza(LivelloRilevanza.ERROR);
                ecc2.setDescrizione("Riconoscimento Servizio/Azione: errore di processamento");
                this.erroriProcessamento.add(ecc2);
                return null;
            }
            if (!validazione.getServizioRegistrato()) {
                Eccezione ecc3 = new Eccezione();
                ecc3.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                ecc3.setCodiceEccezione(CodiceErroreCooperazione.SERVIZIO_SCONOSCIUTO);
                ecc3.setRilevanza(LivelloRilevanza.ERROR);
                ecc3.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_SERVIZIO_SCONOSCIUTO_POSIZIONE.toString());
                this.erroriValidazione.add(ecc3);
                return validazione;
            }
            this.servizioCorrelato = validazione.getServizioCorrelato();
            this.tipoServizioCorrelato = validazione.getTipoServizioCorrelato();
            this.versioneServizioCorrelato = validazione.getVersioneServizioCorrelato();
            this.azioneCorrelata = validazione.getAzioneCorrelata();
        }
        if (this.busta.getServizio() != null && this.busta.getTipoServizio() != null) {
            if (validazione == null) {
                this.log.error("Errore durante l'accesso al registro per la validazione del servizio e dell'azione: validazione is null");
                ecc = new Eccezione();
                ecc.setContestoCodifica(ContestoCodificaEccezione.PROCESSAMENTO);
                ecc.setCodiceEccezione(CodiceErroreCooperazione.ERRORE_GENERICO_PROCESSAMENTO_MESSAGGIO);
                ecc.setRilevanza(LivelloRilevanza.ERROR);
                ecc.setDescrizione("Riconoscimento Azione: errore di processamento");
                this.erroriProcessamento.add(ecc);
                return null;
            }
            if (this.busta.getAzione() == null) {
                if (!validazione.getAccessoSenzaAzione()) {
                    ecc = new Eccezione();
                    ecc.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                    ecc.setCodiceEccezione(CodiceErroreCooperazione.INVOCAZIONE_SENZA_AZIONE_NON_PERMESSA);
                    ecc.setRilevanza(LivelloRilevanza.ERROR);
                    ecc.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_AZIONE_SCONOSCIUTA_POSIZIONE.toString());
                    this.erroriValidazione.add(ecc);
                    return validazione;
                }
            } else {
                String[] azioni = validazione.getAzioni();
                boolean azioneTrovata = false;
                if (azioni != null) {
                    for (int i = 0; i < azioni.length; ++i) {
                        if (!this.busta.getAzione().equals(azioni[i])) continue;
                        azioneTrovata = true;
                        break;
                    }
                }
                if (!azioneTrovata) {
                    Eccezione ecc4 = new Eccezione();
                    ecc4.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                    ecc4.setCodiceEccezione(CodiceErroreCooperazione.AZIONE_SCONOSCIUTA);
                    ecc4.setRilevanza(LivelloRilevanza.ERROR);
                    ecc4.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_AZIONE_SCONOSCIUTA_POSIZIONE.toString());
                    this.erroriValidazione.add(ecc4);
                    return validazione;
                }
            }
        }
        if (ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO.equals((Object)this.busta.getProfiloDiCollaborazione()) && RuoloBusta.RICHIESTA.equals(tipoBusta.toString())) {
            if (this.busta.getServizioCorrelato() != null && validazione != null && !this.busta.getServizioCorrelato().equals(validazione.getServizioCorrelato())) {
                ecc = new Eccezione();
                ecc.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                ecc.setCodiceEccezione(CodiceErroreCooperazione.SERVIZIO_CORRELATO_NON_VALIDO);
                ecc.setRilevanza(LivelloRilevanza.ERROR);
                ecc.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_PROFILO_COLLABORAZIONE_SCONOSCIUTO_POSIZIONE_SERVIZIO_CORRELATO + " diverso da quello atteso (richiesta asincrona simmetrica)");
                this.erroriValidazione.add(ecc);
                return validazione;
            }
            if (this.busta.getTipoServizioCorrelato() != null && validazione != null && !this.busta.getTipoServizioCorrelato().equals(validazione.getTipoServizioCorrelato())) {
                ecc = new Eccezione();
                ecc.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                ecc.setCodiceEccezione(CodiceErroreCooperazione.TIPO_SERVIZIO_CORRELATO_NON_VALIDO);
                ecc.setRilevanza(LivelloRilevanza.ERROR);
                ecc.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_PROFILO_COLLABORAZIONE_SCONOSCIUTO_POSIZIONE_TIPO_SERVIZIO_CORRELATO + " diverso da quello atteso (richiesta asincrona simmetrica)");
                this.erroriValidazione.add(ecc);
                return validazione;
            }
        }
        if (ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO.equals((Object)this.busta.getProfiloDiCollaborazione()) && RuoloBusta.RICEVUTA_RICHIESTA.equals(tipoBusta.toString())) {
            if (this.busta.getServizioCorrelato() != null && validazione != null && !this.busta.getServizioCorrelato().equals(validazione.getServizioCorrelato())) {
                ecc = new Eccezione();
                ecc.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                ecc.setCodiceEccezione(CodiceErroreCooperazione.SERVIZIO_CORRELATO_NON_VALIDO);
                ecc.setRilevanza(LivelloRilevanza.ERROR);
                ecc.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_PROFILO_COLLABORAZIONE_SCONOSCIUTO_POSIZIONE_SERVIZIO_CORRELATO + " diverso da quello atteso (ricevuta della richiesta asincrona simmetrica)");
                this.erroriValidazione.add(ecc);
                return validazione;
            }
            if (this.busta.getTipoServizioCorrelato() != null && validazione != null && !this.busta.getTipoServizioCorrelato().equals(validazione.getTipoServizioCorrelato())) {
                ecc = new Eccezione();
                ecc.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                ecc.setCodiceEccezione(CodiceErroreCooperazione.TIPO_SERVIZIO_CORRELATO_NON_VALIDO);
                ecc.setRilevanza(LivelloRilevanza.ERROR);
                ecc.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_PROFILO_COLLABORAZIONE_SCONOSCIUTO_POSIZIONE_TIPO_SERVIZIO_CORRELATO + " diverso da quello atteso (ricevuta della richiesta asincrona simmetrica)");
                this.erroriValidazione.add(ecc);
                return validazione;
            }
        }
        return validazione;
    }

    private void riconoscimentoProfiloCollaborazione(RuoloBusta tipoBusta) {
        try {
            if (!this.infoServizio.getProfiloDiCollaborazione().equals((Object)this.busta.getProfiloDiCollaborazione())) {
                Eccezione ecc = new Eccezione();
                ecc.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                ecc.setCodiceEccezione(CodiceErroreCooperazione.PROFILO_COLLABORAZIONE_NON_VALIDO);
                ecc.setRilevanza(LivelloRilevanza.ERROR);
                ecc.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_PROFILO_COLLABORAZIONE_SCONOSCIUTO_POSIZIONE + " diverso da quanto specificato nel registro");
                this.erroriValidazione.add(ecc);
            }
        }
        catch (Exception e) {
            this.log.error("Errore durante l'accesso al registro per la validazione del profilo di collaborazione", (Throwable)e);
            Eccezione ecc = new Eccezione();
            ecc.setContestoCodifica(ContestoCodificaEccezione.PROCESSAMENTO);
            ecc.setCodiceEccezione(CodiceErroreCooperazione.ERRORE_GENERICO_PROCESSAMENTO_MESSAGGIO);
            ecc.setRilevanza(LivelloRilevanza.ERROR);
            ecc.setDescrizione("Riconoscimento Profilo di Collaborazione: errore di processamento");
            this.erroriProcessamento.add(ecc);
        }
    }

    public boolean validazioneID_engine(String id) {
        return this.validazioneID_engine(id, null, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean validazioneID_engine(String id, String codAmm, String codDominio) {
        try {
            Integer test;
            int j;
            String[] split = id.split("_");
            if (split == null) {
                return false;
            }
            if (split.length != 5) {
                return false;
            }
            if (codAmm != null && this.validazioneIDEGovCompleta) {
                if (!split[0].equals(codAmm)) {
                    return false;
                }
                byte[] checkID = split[0].getBytes();
                for (j = 0; j < checkID.length; ++j) {
                    if (Character.isLetterOrDigit((char)checkID[j])) continue;
                    return false;
                }
            }
            if (codDominio != null && this.validazioneIDEGovCompleta) {
                if (!split[1].equalsIgnoreCase(codDominio)) {
                    return false;
                }
                byte[] checkPDD = split[1].getBytes();
                for (j = 0; j < checkPDD.length; ++j) {
                    if (Character.isLetterOrDigit((char)checkPDD[j])) continue;
                    return false;
                }
            }
            if (split[2].length() != 7) {
                return false;
            }
            try {
                Integer test2 = Integer.valueOf(split[2]);
                if (test2 >= 0) {
                    // empty if block
                }
            }
            catch (Exception e) {
                return false;
            }
            String[] date = split[3].split("-");
            if (date == null) {
                return false;
            }
            if (date.length != 3) {
                return false;
            }
            if (date[0].length() != 4) {
                return false;
            }
            try {
                Integer test3 = Integer.valueOf(date[0]);
                if (test3 > 2100) {
                    return false;
                }
            }
            catch (Exception e) {
                return false;
            }
            if (date[1].length() != 2) {
                return false;
            }
            if (date[2].length() != 2) {
                return false;
            }
            try {
                Integer mese = Integer.valueOf(date[1]);
                if (mese > 12) return false;
                if (mese < 0) {
                    return false;
                }
                Integer giorno = Integer.valueOf(date[2]);
                if (giorno < 0) {
                    return false;
                }
                if (giorno > 29 && mese == 2) {
                    return false;
                }
                if (giorno > 30) {
                    if (mese == 4) return false;
                    if (mese == 6) return false;
                    if (mese == 9) return false;
                    if (mese == 11) {
                        return false;
                    }
                }
                if (giorno > 31) {
                    return false;
                }
            }
            catch (Exception e) {
                return false;
            }
            String[] ora = split[4].split(":");
            if (ora == null) {
                return false;
            }
            if (ora.length != 2) {
                return false;
            }
            if (ora[0].length() != 2) {
                return false;
            }
            try {
                test = Integer.valueOf(ora[0]);
                if (test > 23) return false;
                if (test < 0) {
                    return false;
                }
            }
            catch (Exception e) {
                return false;
            }
            if (ora[1].length() != 2) {
                return false;
            }
            try {
                test = Integer.valueOf(ora[1]);
                if (test > 59) return false;
                if (test >= 0) return true;
                return false;
            }
            catch (Exception e) {
                return false;
            }
        }
        catch (Exception error) {
            return false;
        }
    }

    private void validazioneLineeGuida11() throws ProtocolException {
        Eccezione ecc;
        Trasmissione tr;
        int i;
        Eccezione ecc2;
        ITraduttore traduttore = this.protocolFactory.createTraduttore();
        String valoreEngine = traduttore.toRegistryOrganizationType("SPC");
        if (!valoreEngine.equals(this.busta.getTipoMittente())) {
            ecc2 = new Eccezione();
            ecc2.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
            ecc2.setCodiceEccezione(CodiceErroreCooperazione.TIPO_MITTENTE_NON_VALIDO);
            ecc2.setRilevanza(LivelloRilevanza.ERROR);
            ecc2.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_MITTENTE_SCONOSCIUTO_POSIZIONE_IDENTIFICATIVO_PARTE_TIPO.toString());
            this.erroriValidazione.add(ecc2);
        }
        if (!valoreEngine.equals(this.busta.getTipoDestinatario())) {
            ecc2 = new Eccezione();
            ecc2.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
            ecc2.setCodiceEccezione(CodiceErroreCooperazione.TIPO_DESTINATARIO_NON_VALIDO);
            ecc2.setRilevanza(LivelloRilevanza.ERROR);
            ecc2.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_DESTINATARIO_SCONOSCIUTO_POSIZIONE_IDENTIFICATIVO_PARTE_TIPO.toString());
            this.erroriValidazione.add(ecc2);
        }
        if (this.busta.getTipoServizio() == null) {
            ecc2 = new Eccezione();
            ecc2.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
            ecc2.setCodiceEccezione(CodiceErroreCooperazione.TIPO_SERVIZIO_NON_PRESENTE);
            ecc2.setRilevanza(LivelloRilevanza.ERROR);
            ecc2.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_SERVIZIO_SCONOSCIUTO_POSIZIONE_TIPO.toString());
            this.erroriValidazione.add(ecc2);
        }
        if (this.busta.getServizio() == null) {
            ecc2 = new Eccezione();
            ecc2.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
            ecc2.setCodiceEccezione(CodiceErroreCooperazione.SERVIZIO_NON_PRESENTE);
            ecc2.setRilevanza(LivelloRilevanza.ERROR);
            ecc2.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_SERVIZIO_SCONOSCIUTO_POSIZIONE.toString());
            this.erroriValidazione.add(ecc2);
        }
        if (!valoreEngine.equals(this.busta.getTipoServizio())) {
            ecc2 = new Eccezione();
            ecc2.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
            ecc2.setCodiceEccezione(CodiceErroreCooperazione.TIPO_SERVIZIO_NON_VALIDO);
            ecc2.setRilevanza(LivelloRilevanza.ERROR);
            ecc2.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_SERVIZIO_SCONOSCIUTO_POSIZIONE_TIPO.toString());
            this.erroriValidazione.add(ecc2);
        }
        if (this.busta.getAzione() == null) {
            ecc2 = new Eccezione();
            ecc2.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
            ecc2.setCodiceEccezione(CodiceErroreCooperazione.AZIONE_NON_PRESENTE);
            ecc2.setRilevanza(LivelloRilevanza.ERROR);
            ecc2.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_AZIONE_SCONOSCIUTA_POSIZIONE.toString());
            this.erroriValidazione.add(ecc2);
        }
        if (this.busta.getProfiloDiCollaborazione() == null) {
            ecc2 = new Eccezione();
            ecc2.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
            ecc2.setCodiceEccezione(CodiceErroreCooperazione.PROFILO_COLLABORAZIONE_NON_PRESENTE);
            ecc2.setRilevanza(LivelloRilevanza.ERROR);
            ecc2.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_PROFILO_COLLABORAZIONE_SCONOSCIUTO_POSIZIONE.toString());
            this.erroriValidazione.add(ecc2);
        }
        if ((ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO.equals((Object)this.busta.getProfiloDiCollaborazione()) || ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO.equals((Object)this.busta.getProfiloDiCollaborazione())) && this.busta.getCollaborazione() == null) {
            ecc2 = new Eccezione();
            ecc2.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
            ecc2.setCodiceEccezione(CodiceErroreCooperazione.COLLABORAZIONE_NON_VALIDA);
            ecc2.setRilevanza(LivelloRilevanza.ERROR);
            ecc2.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_COLLABORAZIONE_SCONOSCIUTA_POSIZIONE.toString());
            this.erroriValidazione.add(ecc2);
        }
        if (!TipoOraRegistrazione.SINCRONIZZATO.equals((Object)this.busta.getTipoOraRegistrazione())) {
            ecc2 = new Eccezione();
            ecc2.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
            ecc2.setCodiceEccezione(CodiceErroreCooperazione.TIPO_ORA_REGISTRAZIONE_NON_VALIDA);
            ecc2.setRilevanza(LivelloRilevanza.ERROR);
            ecc2.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_ORA_REGISTRAZIONE_NON_VALIDA_POSIZIONE_TEMPO.toString());
            this.erroriValidazione.add(ecc2);
        }
        if (this.busta.isConfermaRicezione()) {
            ecc2 = new Eccezione();
            ecc2.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
            ecc2.setCodiceEccezione(CodiceErroreCooperazione.PROFILO_TRASMISSIONE_CONFERMA_RICEZIONE_NON_VALIDO);
            ecc2.setRilevanza(LivelloRilevanza.ERROR);
            ecc2.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_PROFILO_TRASMISSIONE_NON_VALIDO_POSIZIONE_CONFERMA_RICEZIONE.toString());
            this.erroriValidazione.add(ecc2);
        }
        if (Inoltro.CON_DUPLICATI.equals((Object)this.busta.getInoltro())) {
            ecc2 = new Eccezione();
            ecc2.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
            ecc2.setCodiceEccezione(CodiceErroreCooperazione.PROFILO_TRASMISSIONE_FILTRO_DUPLICATI_NON_VALIDO);
            ecc2.setRilevanza(LivelloRilevanza.ERROR);
            ecc2.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_PROFILO_TRASMISSIONE_NON_VALIDO_POSIZIONE_INOLTRO.toString());
            this.erroriValidazione.add(ecc2);
        }
        for (i = 0; i < this.busta.sizeListaTrasmissioni(); ++i) {
            tr = this.busta.getTrasmissione(i);
            if (!valoreEngine.equals(tr.getTipoOrigine())) {
                ecc = new Eccezione();
                ecc.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                ecc.setCodiceEccezione(CodiceErroreCooperazione.TRASMISSIONE_TIPO_ORIGINE_NON_VALIDA);
                ecc.setRilevanza(LivelloRilevanza.ERROR);
                ecc.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_LISTA_TRASMISSIONI_NON_VALIDA_POSIZIONE_TRASMISSIONE_ORIGINE_IDENTIFICATIVO_PARTE_TIPO.toString());
                this.erroriValidazione.add(ecc);
            }
            if (!valoreEngine.equals(tr.getTipoDestinazione())) {
                ecc = new Eccezione();
                ecc.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                ecc.setCodiceEccezione(CodiceErroreCooperazione.TRASMISSIONE_TIPO_DESTINAZIONE_NON_VALIDA);
                ecc.setRilevanza(LivelloRilevanza.ERROR);
                ecc.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_LISTA_TRASMISSIONI_NON_VALIDA_POSIZIONE_TRASMISSIONE_DESTINAZIONE_IDENTIFICATIVO_PARTE_TIPO.toString());
                this.erroriValidazione.add(ecc);
            }
            if (TipoOraRegistrazione.SINCRONIZZATO.equals((Object)tr.getTempo())) continue;
            ecc = new Eccezione();
            ecc.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
            ecc.setCodiceEccezione(CodiceErroreCooperazione.TRASMISSIONE_TIPO_ORA_REGISTRAZIONE_NON_VALIDA);
            ecc.setRilevanza(LivelloRilevanza.ERROR);
            ecc.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_LISTA_TRASMISSIONI_NON_VALIDA_POSIZIONE_TRASMISSIONE_ORA_REGISTRAZIONE_TEMPO.toString());
            this.erroriValidazione.add(ecc);
        }
        for (i = 0; i < this.busta.sizeListaRiscontri(); ++i) {
            Riscontro r = this.busta.getRiscontro(i);
            if (TipoOraRegistrazione.SINCRONIZZATO.equals((Object)r.getTipoOraRegistrazione())) continue;
            ecc = new Eccezione();
            ecc.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
            ecc.setCodiceEccezione(CodiceErroreCooperazione.RISCONTRO_TIPO_ORA_REGISTRAZIONE_NON_VALIDO);
            ecc.setRilevanza(LivelloRilevanza.ERROR);
            ecc.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_LISTA_RISCONTRI_NON_VALIDA_POSIZIONE_RISCONTRO_ORA_REGISTRAZIONE_TEMPO.toString());
            this.erroriValidazione.add(ecc);
        }
        if (this.erroriValidazione.size() == 0) {
            if (this.busta.getIndirizzoMittente() != null) {
                Eccezione ecc3 = new Eccezione();
                ecc3.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                ecc3.setCodiceEccezione(CodiceErroreCooperazione.INDIRIZZO_MITTENTE_NON_VALIDO);
                ecc3.setRilevanza(LivelloRilevanza.INFO);
                ecc3.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_MITTENTE_SCONOSCIUTO_POSIZIONE_IDENTIFICATIVO_PARTE_IND_TELEMATICO.toString());
                this.erroriValidazione.add(ecc3);
            }
            if (this.busta.getIndirizzoDestinatario() != null) {
                Eccezione ecc4 = new Eccezione();
                ecc4.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                ecc4.setCodiceEccezione(CodiceErroreCooperazione.INDIRIZZO_DESTINATARIO_NON_VALIDO);
                ecc4.setRilevanza(LivelloRilevanza.INFO);
                ecc4.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_DESTINATARIO_SCONOSCIUTO_POSIZIONE_IDENTIFICATIVO_PARTE_IND_TELEMATICO.toString());
                this.erroriValidazione.add(ecc4);
            }
            if (this.busta.getTipoServizioCorrelato() != null) {
                Eccezione ecc5 = new Eccezione();
                ecc5.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                ecc5.setCodiceEccezione(CodiceErroreCooperazione.TIPO_SERVIZIO_CORRELATO_NON_VALIDO);
                ecc5.setRilevanza(LivelloRilevanza.INFO);
                ecc5.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_PROFILO_COLLABORAZIONE_SCONOSCIUTO_POSIZIONE_TIPO_SERVIZIO_CORRELATO.toString());
                this.erroriValidazione.add(ecc5);
            }
            if (this.busta.getServizioCorrelato() != null) {
                Eccezione ecc6 = new Eccezione();
                ecc6.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                ecc6.setCodiceEccezione(CodiceErroreCooperazione.SERVIZIO_CORRELATO_NON_VALIDO);
                ecc6.setRilevanza(LivelloRilevanza.INFO);
                ecc6.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_PROFILO_COLLABORAZIONE_SCONOSCIUTO_POSIZIONE_SERVIZIO_CORRELATO.toString());
                this.erroriValidazione.add(ecc6);
            }
            if (!ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO.equals((Object)this.busta.getProfiloDiCollaborazione()) && !ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO.equals((Object)this.busta.getProfiloDiCollaborazione()) && this.busta.getCollaborazione() != null) {
                Eccezione ecc7 = new Eccezione();
                ecc7.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                ecc7.setCodiceEccezione(CodiceErroreCooperazione.COLLABORAZIONE_NON_VALIDA);
                ecc7.setRilevanza(LivelloRilevanza.INFO);
                ecc7.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_COLLABORAZIONE_SCONOSCIUTA_POSIZIONE.toString());
                this.erroriValidazione.add(ecc7);
            }
            if (this.busta.getSequenza() != -1L) {
                Eccezione ecc8 = new Eccezione();
                ecc8.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                ecc8.setCodiceEccezione(CodiceErroreCooperazione.CONSEGNA_IN_ORDINE_NON_SUPPORTATA);
                ecc8.setRilevanza(LivelloRilevanza.INFO);
                ecc8.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_TRASPARENZA_TEMPORALE_NON_SUPPORTATA_POSIZIONE.toString());
                this.erroriValidazione.add(ecc8);
            }
            for (int i2 = 0; i2 < this.busta.sizeListaTrasmissioni(); ++i2) {
                tr = this.busta.getTrasmissione(i2);
                if (tr.getIndirizzoOrigine() != null) {
                    ecc = new Eccezione();
                    ecc.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                    ecc.setCodiceEccezione(CodiceErroreCooperazione.TRASMISSIONE_INDIRIZZO_ORIGINE_NON_VALIDA);
                    ecc.setRilevanza(LivelloRilevanza.INFO);
                    ecc.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_LISTA_TRASMISSIONI_NON_VALIDA_POSIZIONE_TRASMISSIONE_ORIGINE_IDENTIFICATIVO_PARTE_IND_TELEMATICO.toString());
                    this.erroriValidazione.add(ecc);
                }
                if (tr.getIndirizzoDestinazione() == null) continue;
                ecc = new Eccezione();
                ecc.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                ecc.setCodiceEccezione(CodiceErroreCooperazione.TRASMISSIONE_INDIRIZZO_DESTINAZIONE_NON_VALIDA);
                ecc.setRilevanza(LivelloRilevanza.INFO);
                ecc.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_LISTA_TRASMISSIONI_NON_VALIDA_POSIZIONE_TRASMISSIONE_DESTINAZIONE_IDENTIFICATIVO_PARTE_IND_TELEMATICO.toString());
                this.erroriValidazione.add(ecc);
            }
            if (this.busta.sizeListaRiscontri() > 0) {
                Eccezione ecc9 = new Eccezione();
                ecc9.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                ecc9.setCodiceEccezione(CodiceErroreCooperazione.LISTA_RISCONTRI_NON_VALIDA);
                ecc9.setRilevanza(LivelloRilevanza.INFO);
                ecc9.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_LISTA_RISCONTRI_NON_VALIDA_POSIZIONE.toString());
                this.erroriValidazione.add(ecc9);
            }
        }
    }

    public String getAzioneCorrelata() {
        return this.azioneCorrelata;
    }

    public void setAzioneCorrelata(String azioneCorrelata) {
        this.azioneCorrelata = azioneCorrelata;
    }

    public IProtocolFactory<?> getProtocolFactory() {
        return this.protocolFactory;
    }

    public boolean validazioneID(String id, IDSoggetto dominio, ProprietaValidazione proprietaValidazione) {
        this.validazioneIDEGovCompleta = proprietaValidazione.isValidazioneIDCompleta();
        if (dominio != null) {
            return this.validazioneID_engine(id, dominio.getNome(), dominio.getCodicePorta());
        }
        return this.validazioneID_engine(id, null, null);
    }

    public ValidazioneSemanticaResult valida(OpenSPCoop2Message msg, Busta busta, ProprietaValidazione proprietaValidazione, RuoloBusta tipoBusta) throws ProtocolException {
        this.busta = busta;
        this.registroServiziReader = RegistroServiziManager.getInstance((IState)this.state);
        this.validazioneIDEGovCompleta = proprietaValidazione.isValidazioneIDCompleta();
        this.valida(proprietaValidazione, tipoBusta, proprietaValidazione.getVersioneProtocollo());
        ValidazioneSemanticaResult result = new ValidazioneSemanticaResult(this.erroriValidazione, this.erroriProcessamento, this.servizioCorrelato, this.tipoServizioCorrelato, this.versioneServizioCorrelato, this.infoServizio);
        return result;
    }

    public SecurityInfo readSecurityInformation(IDigestReader digestReader, OpenSPCoop2Message msg) throws ProtocolException {
        return null;
    }
}

