/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.spcoop.archive;

import it.gov.spcoop.sica.wsbl.ConceptualBehavior;
import it.gov.spcoop.sica.wsbl.driver.XMLUtils;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.id.IDAccordoCooperazione;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.registry.AccordoServizioParteComune;
import org.openspcoop2.core.registry.Operation;
import org.openspcoop2.core.registry.PortType;
import org.openspcoop2.core.registry.constants.CostantiRegistroServizi;
import org.openspcoop2.protocol.basic.Costanti;
import org.openspcoop2.protocol.basic.archive.BasicArchive;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.archive.Archive;
import org.openspcoop2.protocol.sdk.archive.ArchiveAccordoCooperazione;
import org.openspcoop2.protocol.sdk.archive.ArchiveAccordoServizioComposto;
import org.openspcoop2.protocol.sdk.archive.ArchiveAccordoServizioParteComune;
import org.openspcoop2.protocol.sdk.archive.ArchiveAccordoServizioParteSpecifica;
import org.openspcoop2.protocol.sdk.archive.ArchiveEsitoDelete;
import org.openspcoop2.protocol.sdk.archive.ArchiveEsitoImport;
import org.openspcoop2.protocol.sdk.archive.ArchiveEsitoImportDetail;
import org.openspcoop2.protocol.sdk.archive.ArchiveMode;
import org.openspcoop2.protocol.sdk.archive.ArchiveModeType;
import org.openspcoop2.protocol.sdk.archive.ExportMode;
import org.openspcoop2.protocol.sdk.archive.ImportMode;
import org.openspcoop2.protocol.sdk.archive.MapPlaceholder;
import org.openspcoop2.protocol.sdk.archive.MappingModeTypesExtensions;
import org.openspcoop2.protocol.sdk.constants.ArchiveStatoImport;
import org.openspcoop2.protocol.sdk.constants.ArchiveType;
import org.openspcoop2.protocol.sdk.registry.IConfigIntegrationReader;
import org.openspcoop2.protocol.sdk.registry.IRegistryReader;
import org.openspcoop2.protocol.spcoop.archive.SPCoopArchiveExport;
import org.openspcoop2.protocol.spcoop.archive.SPCoopArchiveImport;
import org.openspcoop2.protocol.spcoop.archive.SPCoopConvertToPackageCNIPAException;
import org.openspcoop2.protocol.spcoop.config.SPCoopProperties;
import org.openspcoop2.protocol.spcoop.constants.SPCoopCostantiArchivi;
import org.openspcoop2.utils.Utilities;
import org.slf4j.Logger;

public class SPCoopArchive
extends BasicArchive {
    private SPCoopArchiveImport importEngine = null;
    private SPCoopArchiveExport exportEngine = null;
    private SPCoopProperties spcoopProperties = null;

    public SPCoopArchive(Logger log, IProtocolFactory<?> protocolFactory) throws ProtocolException {
        super(protocolFactory);
        this.importEngine = new SPCoopArchiveImport(protocolFactory);
        this.exportEngine = new SPCoopArchiveExport(protocolFactory);
        this.spcoopProperties = SPCoopProperties.getInstance(log);
    }

    public MappingModeTypesExtensions getMappingTypesExtensions(ArchiveMode mode) throws ProtocolException {
        if (this.spcoopProperties.isGestionePackageSICA().booleanValue() && SPCoopCostantiArchivi.CNIPA_MODE.equals((Object)mode) || SPCoopCostantiArchivi.EXPORT_MODE_COMPATIBILITA_CLIENT_SICA.equals((Object)mode) || SPCoopCostantiArchivi.EXPORT_MODE_INFORMAZIONI_COMPLETE.equals((Object)mode)) {
            MappingModeTypesExtensions m = new MappingModeTypesExtensions();
            m.add("zip", new ArchiveModeType[]{SPCoopCostantiArchivi.TYPE_ALL, SPCoopCostantiArchivi.TYPE_APC, SPCoopCostantiArchivi.TYPE_APS, SPCoopCostantiArchivi.TYPE_ADC, SPCoopCostantiArchivi.TYPE_ASC});
            m.add("apc", ArchiveType.ACCORDO_SERVIZIO_PARTE_COMUNE, new ArchiveModeType[]{SPCoopCostantiArchivi.TYPE_APC, SPCoopCostantiArchivi.TYPE_ALL});
            m.add("aps", ArchiveType.ACCORDO_SERVIZIO_PARTE_SPECIFICA, new ArchiveModeType[]{SPCoopCostantiArchivi.TYPE_APS, SPCoopCostantiArchivi.TYPE_ALL});
            m.add("adc", ArchiveType.ACCORDO_COOPERAZIONE, new ArchiveModeType[]{SPCoopCostantiArchivi.TYPE_ADC, SPCoopCostantiArchivi.TYPE_ALL});
            m.add("asc", ArchiveType.ACCORDO_SERVIZIO_COMPOSTO, new ArchiveModeType[]{SPCoopCostantiArchivi.TYPE_ASC, SPCoopCostantiArchivi.TYPE_ALL});
            return m;
        }
        return super.getMappingTypesExtensions(mode);
    }

    public void setProtocolInfo(AccordoServizioParteComune accordoServizioParteComune) throws ProtocolException {
        block16: {
            super.setProtocolInfo(accordoServizioParteComune);
            try {
                String operationAsincronaRichiesta = null;
                String operationAsincronaRisposta = null;
                boolean presenzaWSBLLogicoFruitore = false;
                if (accordoServizioParteComune.getByteSpecificaConversazioneConcettuale() == null) break block16;
                byte[] wsbl = accordoServizioParteComune.getByteSpecificaConversazioneConcettuale();
                if (!XMLUtils.isConceptualBehavior(wsbl)) {
                    if (XMLUtils.isMessageBehavior(wsbl)) {
                        throw new Exception("La specifica di conversazione concettuale non e' un documento WSBL ConceptualBehavior, ma erroneamente un documento WSBL MessageBehavior");
                    }
                    throw new Exception("La specifica di conversazione concettuale non e' un documento WSBL ConceptualBehavior");
                }
                ConceptualBehavior wsblConcettuale = XMLUtils.getConceptualBehavior(this.getProtocolFactory().getLogger(), wsbl);
                String[] operazioniAsincrone = XMLUtils.getOperazioniAsincrone(wsblConcettuale);
                operationAsincronaRichiesta = operazioniAsincrone[0];
                operationAsincronaRisposta = operazioniAsincrone[1];
                if (accordoServizioParteComune.getByteSpecificaConversazioneFruitore() != null) {
                    presenzaWSBLLogicoFruitore = XMLUtils.isMessageBehavior(wsbl);
                }
                for (PortType ptOpenSPCoop : accordoServizioParteComune.getPortTypeList()) {
                    block3: for (Operation opOpenSPCoop : ptOpenSPCoop.getAzioneList()) {
                        boolean risposta;
                        String tmp = opOpenSPCoop.getNome();
                        if (tmp.equals(operationAsincronaRichiesta) || tmp.equals(operationAsincronaRisposta)) {
                            if (presenzaWSBLLogicoFruitore) {
                                opOpenSPCoop.setProfiloCollaborazione(CostantiRegistroServizi.ASINCRONO_SIMMETRICO);
                            } else {
                                opOpenSPCoop.setProfiloCollaborazione(CostantiRegistroServizi.ASINCRONO_ASIMMETRICO);
                            }
                            opOpenSPCoop.setProfAzione("ridefinito");
                            if (!tmp.equals(operationAsincronaRisposta)) continue;
                            opOpenSPCoop.setCorrelata(operationAsincronaRichiesta);
                            for (PortType ptSearch : accordoServizioParteComune.getPortTypeList()) {
                                boolean found = false;
                                for (Operation opSearch : ptSearch.getAzioneList()) {
                                    if (opSearch == null || !opSearch.getNome().equals(operationAsincronaRichiesta)) continue;
                                    opOpenSPCoop.setCorrelataServizio(ptSearch.getNome());
                                    found = true;
                                    break;
                                }
                                if (!found) continue;
                                continue block3;
                            }
                            continue;
                        }
                        int lengthServizioAzione = ptOpenSPCoop.getNome().length() + 1 + opOpenSPCoop.getNome().length();
                        boolean richiesta = operationAsincronaRichiesta != null && operationAsincronaRichiesta.length() == lengthServizioAzione && operationAsincronaRichiesta.startsWith(ptOpenSPCoop.getNome()) && operationAsincronaRichiesta.endsWith(opOpenSPCoop.getNome());
                        boolean bl = risposta = operationAsincronaRisposta != null && operationAsincronaRisposta.length() == lengthServizioAzione && operationAsincronaRisposta.startsWith(ptOpenSPCoop.getNome()) && operationAsincronaRisposta.endsWith(opOpenSPCoop.getNome());
                        if (!richiesta && !risposta) continue;
                        if (presenzaWSBLLogicoFruitore) {
                            opOpenSPCoop.setProfiloCollaborazione(CostantiRegistroServizi.ASINCRONO_SIMMETRICO);
                        } else {
                            opOpenSPCoop.setProfiloCollaborazione(CostantiRegistroServizi.ASINCRONO_ASIMMETRICO);
                        }
                        opOpenSPCoop.setProfAzione("ridefinito");
                        if (!risposta) continue;
                        for (PortType ptSearch : accordoServizioParteComune.getPortTypeList()) {
                            boolean found = false;
                            for (Operation opSearch : ptSearch.getAzioneList()) {
                                int lengthServizioAzioneSearch = ptSearch.getNome().length() + 1 + opSearch.getNome().length();
                                boolean richiestaSearch = operationAsincronaRichiesta.length() == lengthServizioAzioneSearch && operationAsincronaRichiesta.startsWith(ptSearch.getNome()) && operationAsincronaRichiesta.endsWith(opSearch.getNome());
                                if (!richiestaSearch) continue;
                                opOpenSPCoop.setCorrelata(opSearch.getNome());
                                opOpenSPCoop.setCorrelataServizio(ptSearch.getNome());
                                found = true;
                                break;
                            }
                            if (!found) continue;
                            continue block3;
                        }
                    }
                }
            }
            catch (Exception e) {
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
        }
    }

    private String toString(ArchiveEsitoImport archive, boolean importOperation) {
        IDServizio idServizio;
        ArchiveEsitoImportDetail archiveAccordoServizioParteSpecifica;
        String uriAccordo;
        StringBuilder bfEsito;
        block21: {
            IDAccordo idAccordo;
            bfEsito = new StringBuilder();
            if (archive.getAccordiCooperazione().size() > 0) {
                bfEsito.append("Accordo di Cooperazione\n");
                try {
                    ArchiveEsitoImportDetail archiveAccordoCooperazione = (ArchiveEsitoImportDetail)archive.getAccordiCooperazione().get(0);
                    IDAccordoCooperazione idAccordoCooperazione = ((ArchiveAccordoCooperazione)archiveAccordoCooperazione.getArchiveObject()).getIdAccordoCooperazione();
                    uriAccordo = this.idAccordoCooperazioneFactory.getUriFromIDAccordo(idAccordoCooperazione);
                    bfEsito.append("\t- [").append(uriAccordo).append("] ");
                    this.esitoUtils.serializeStato(archiveAccordoCooperazione, bfEsito, importOperation);
                }
                catch (Exception e) {
                    bfEsito.append("\t- non importato: ").append(e.getMessage());
                }
            } else if (archive.getAccordiServizioParteComune().size() > 0) {
                bfEsito.append("Accordi di Servizio Parte Comune\n");
                try {
                    ArchiveEsitoImportDetail archiveAccordoServizioParteComune = (ArchiveEsitoImportDetail)archive.getAccordiServizioParteComune().get(0);
                    idAccordo = ((ArchiveAccordoServizioParteComune)archiveAccordoServizioParteComune.getArchiveObject()).getIdAccordoServizioParteComune();
                    uriAccordo = this.idAccordoFactory.getUriFromIDAccordo(idAccordo);
                    bfEsito.append("\t- [").append(uriAccordo).append("] ");
                    this.esitoUtils.serializeStato(archiveAccordoServizioParteComune, bfEsito, importOperation);
                }
                catch (Exception e) {
                    bfEsito.append("\t- non importato: ").append(e.getMessage());
                }
            } else if (archive.getAccordiServizioParteSpecifica().size() > 0) {
                bfEsito.append("Accordi di Servizio Parte Specifica\n");
                try {
                    archiveAccordoServizioParteSpecifica = (ArchiveEsitoImportDetail)archive.getAccordiServizioParteSpecifica().get(0);
                    idServizio = ((ArchiveAccordoServizioParteSpecifica)archiveAccordoServizioParteSpecifica.getArchiveObject()).getIdAccordoServizioParteSpecifica();
                    uriAccordo = this.idServizioFactory.getUriFromIDServizio(idServizio);
                    bfEsito.append("\t- [").append(uriAccordo).append("] ");
                    this.esitoUtils.serializeStato(archiveAccordoServizioParteSpecifica, bfEsito, importOperation);
                    if ((archiveAccordoServizioParteSpecifica.getState() == null || !ArchiveStatoImport.CREATED.equals((Object)archiveAccordoServizioParteSpecifica.getState())) && !ArchiveStatoImport.UPDATED.equals((Object)archiveAccordoServizioParteSpecifica.getState())) break block21;
                    if (archive.getPorteApplicative().size() > 0) {
                        bfEsito.append("\n\n!!Attenzione!!: E' stata creata un'erogazione con stato disabilitato.\n\tDefinire correttamente il connettore ed abilitare l'erogazione per renderla operativa");
                    } else if (archive.getPorteDelegate().size() > 0) {
                        bfEsito.append("\n\n!!Attenzione!!: E' stata creata una fruizione con stato disabilitato.\n\tDefinire correttamente il connettore ed abilitare la fruizione per renderla operativa");
                    }
                }
                catch (Exception e) {
                    bfEsito.append("\t- non importato: ").append(e.getMessage());
                }
            } else if (archive.getAccordiServizioComposto().size() > 0) {
                bfEsito.append("Accordi di Servizio Composto\n");
                try {
                    ArchiveEsitoImportDetail archiveAccordoServizioComposto = (ArchiveEsitoImportDetail)archive.getAccordiServizioComposto().get(0);
                    idAccordo = ((ArchiveAccordoServizioComposto)archiveAccordoServizioComposto.getArchiveObject()).getIdAccordoServizioParteComune();
                    uriAccordo = this.idAccordoFactory.getUriFromIDAccordo(idAccordo);
                    bfEsito.append("\t- [").append(uriAccordo).append("] ");
                    this.esitoUtils.serializeStato(archiveAccordoServizioComposto, bfEsito, importOperation);
                }
                catch (Exception e) {
                    bfEsito.append("\t- non importato: ").append(e.getMessage());
                }
            }
        }
        if (archive.getAccordiServizioParteSpecificaServiziComposti().size() > 0) {
            bfEsito.append("Accordi di Servizio Composto Parte Specifica\n");
            try {
                archiveAccordoServizioParteSpecifica = (ArchiveEsitoImportDetail)archive.getAccordiServizioParteSpecificaServiziComposti().get(0);
                idServizio = ((ArchiveAccordoServizioParteSpecifica)archiveAccordoServizioParteSpecifica.getArchiveObject()).getIdAccordoServizioParteSpecifica();
                uriAccordo = this.idServizioFactory.getUriFromIDServizio(idServizio);
                bfEsito.append("\t- [").append(uriAccordo).append("] ");
                this.esitoUtils.serializeStato(archiveAccordoServizioParteSpecifica, bfEsito, importOperation);
            }
            catch (Exception e) {
                bfEsito.append("\t- non importato: ").append(e.getMessage());
            }
        }
        return bfEsito.toString();
    }

    public List<ImportMode> getImportModes() throws ProtocolException {
        List list = super.getImportModes();
        if (this.spcoopProperties.isGestionePackageSICA().booleanValue()) {
            list.add(new ImportMode(SPCoopCostantiArchivi.CNIPA_MODE));
        }
        return list;
    }

    public Archive importArchive(byte[] archive, ArchiveMode mode, ArchiveModeType type, IRegistryReader registryReader, IConfigIntegrationReader configIntegrationReader, boolean validationDocuments, MapPlaceholder placeholder) throws ProtocolException {
        if (Costanti.OPENSPCOOP_IMPORT_ARCHIVE_MODE.equals((Object)mode)) {
            return super.importArchive(archive, mode, type, registryReader, configIntegrationReader, validationDocuments, placeholder);
        }
        if (SPCoopCostantiArchivi.CNIPA_MODE.equals((Object)mode)) {
            if (SPCoopCostantiArchivi.TYPE_APC.equals((Object)type)) {
                try {
                    return this.importEngine.buildAccordoServizioParteComune(archive, registryReader, validationDocuments);
                }
                catch (SPCoopConvertToPackageCNIPAException e) {
                    throw new ProtocolException(e.getMessage(), (Throwable)e);
                }
            }
            if (SPCoopCostantiArchivi.TYPE_ASC.equals((Object)type)) {
                try {
                    return this.importEngine.buildAccordoServizioComposto(archive, registryReader, validationDocuments);
                }
                catch (SPCoopConvertToPackageCNIPAException e) {
                    throw new ProtocolException(e.getMessage(), (Throwable)e);
                }
            }
            if (SPCoopCostantiArchivi.TYPE_APS.equals((Object)type)) {
                try {
                    return this.importEngine.buildAccordoServizioParteSpecifica(archive, registryReader, validationDocuments);
                }
                catch (SPCoopConvertToPackageCNIPAException e) {
                    throw new ProtocolException(e.getMessage(), (Throwable)e);
                }
            }
            if (SPCoopCostantiArchivi.TYPE_ADC.equals((Object)type)) {
                try {
                    return this.importEngine.buildAccordoCooperazione(archive, registryReader);
                }
                catch (SPCoopConvertToPackageCNIPAException e) {
                    throw new ProtocolException(e.getMessage(), (Throwable)e);
                }
            }
            if (SPCoopCostantiArchivi.TYPE_ALL.equals((Object)type)) {
                try {
                    return this.importEngine.buildAccordoServizioParteComune(archive, registryReader, validationDocuments);
                }
                catch (SPCoopConvertToPackageCNIPAException eAPC) {
                    try {
                        return this.importEngine.buildAccordoServizioComposto(archive, registryReader, validationDocuments);
                    }
                    catch (SPCoopConvertToPackageCNIPAException eAComposto) {
                        try {
                            return this.importEngine.buildAccordoServizioParteSpecifica(archive, registryReader, validationDocuments);
                        }
                        catch (SPCoopConvertToPackageCNIPAException eAPS) {
                            try {
                                return this.importEngine.buildAccordoCooperazione(archive, registryReader);
                            }
                            catch (SPCoopConvertToPackageCNIPAException eADC) {
                                throw new ProtocolException("L'archivio fornito non e' stato possibile interpretarlo come nessuno dei package supportati (per ottenere maggiori dettagli re-importarlo indicando un tipo specifico): " + SPCoopCostantiArchivi.TYPE_APC + "," + SPCoopCostantiArchivi.TYPE_APS + "," + SPCoopCostantiArchivi.TYPE_ASC + "," + SPCoopCostantiArchivi.TYPE_ADC);
                            }
                        }
                    }
                }
            }
            throw new ProtocolException("Type [" + type + "] unknown");
        }
        throw new ProtocolException("Mode [" + mode + "] unknown");
    }

    public Archive importArchive(InputStream archive, ArchiveMode mode, ArchiveModeType type, IRegistryReader registryReader, IConfigIntegrationReader configIntegrationReader, boolean validationDocuments, MapPlaceholder placeholder) throws ProtocolException {
        byte[] bytes = null;
        try {
            bytes = Utilities.getAsByteArray((InputStream)archive);
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (archive != null) {
                    archive.close();
                }
            }
            catch (Exception exception) {}
        }
        return this.importArchive(bytes, mode, type, registryReader, configIntegrationReader, validationDocuments, placeholder);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void finalizeImportArchive(Archive archive, ArchiveMode mode, ArchiveModeType type, IRegistryReader registryReader, IConfigIntegrationReader configIntegrationReader, boolean validationDocuments, MapPlaceholder placeholder) throws ProtocolException {
        if (Costanti.OPENSPCOOP_IMPORT_ARCHIVE_MODE.equals((Object)mode)) {
            super.finalizeImportArchive(archive, mode, type, registryReader, configIntegrationReader, validationDocuments, placeholder);
            return;
        }
        if (!SPCoopCostantiArchivi.CNIPA_MODE.equals((Object)mode)) throw new ProtocolException("Mode [" + mode + "] unknown");
        if (SPCoopCostantiArchivi.TYPE_APC.equals((Object)type) || SPCoopCostantiArchivi.TYPE_ASC.equals((Object)type)) return;
        if (SPCoopCostantiArchivi.TYPE_APS.equals((Object)type)) {
            try {
                this.importEngine.finalizeAccordoServizioParteSpecifica(archive, registryReader, validationDocuments);
                return;
            }
            catch (SPCoopConvertToPackageCNIPAException e) {
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
        }
        if (SPCoopCostantiArchivi.TYPE_ADC.equals((Object)type)) return;
        if (!SPCoopCostantiArchivi.TYPE_ALL.equals((Object)type)) throw new ProtocolException("Type [" + type + "] unknown");
        try {
            this.importEngine.finalizeAccordoServizioParteSpecifica(archive, registryReader, validationDocuments);
            return;
        }
        catch (SPCoopConvertToPackageCNIPAException e) {
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
    }

    public String toString(ArchiveEsitoImport esito, ArchiveMode archiveMode) throws ProtocolException {
        if (Costanti.OPENSPCOOP_IMPORT_ARCHIVE_MODE.equals((Object)archiveMode)) {
            return super.toString(esito, archiveMode);
        }
        if (SPCoopCostantiArchivi.CNIPA_MODE.equals((Object)archiveMode)) {
            return this.toString(esito, true);
        }
        throw new ProtocolException("Mode [" + archiveMode + "] unknown");
    }

    public String toString(ArchiveEsitoDelete esito, ArchiveMode archiveMode) throws ProtocolException {
        if (Costanti.OPENSPCOOP_IMPORT_ARCHIVE_MODE.equals((Object)archiveMode)) {
            return super.toString(esito, archiveMode);
        }
        if (SPCoopCostantiArchivi.CNIPA_MODE.equals((Object)archiveMode)) {
            return this.toString((ArchiveEsitoImport)esito, false);
        }
        throw new ProtocolException("Mode [" + archiveMode + "] unknown");
    }

    public List<ExportMode> getExportModes(ArchiveType archiveType) throws ProtocolException {
        List list = super.getExportModes(archiveType);
        if (this.spcoopProperties.isGestionePackageSICA().booleanValue()) {
            switch (archiveType) {
                case ACCORDO_SERVIZIO_PARTE_COMUNE: 
                case ACCORDO_SERVIZIO_PARTE_SPECIFICA: 
                case ACCORDO_SERVIZIO_COMPOSTO: 
                case ACCORDO_COOPERAZIONE: {
                    ExportMode exportSICA = new ExportMode(SPCoopCostantiArchivi.EXPORT_MODE_COMPATIBILITA_CLIENT_SICA);
                    ExportMode exportComplete = new ExportMode(SPCoopCostantiArchivi.EXPORT_MODE_INFORMAZIONI_COMPLETE);
                    list.add(exportSICA);
                    list.add(exportComplete);
                    break;
                }
            }
        }
        return list;
    }

    public byte[] exportArchive(Archive archive, ArchiveMode mode, IRegistryReader registroReader, IConfigIntegrationReader configIntegrationReader) throws ProtocolException {
        if (Costanti.OPENSPCOOP_EXPORT_ARCHIVE_MODE.equals((Object)mode)) {
            return super.exportArchive(archive, mode, registroReader, configIntegrationReader);
        }
        if (SPCoopCostantiArchivi.EXPORT_MODE_COMPATIBILITA_CLIENT_SICA.equals((Object)mode) || SPCoopCostantiArchivi.EXPORT_MODE_INFORMAZIONI_COMPLETE.equals((Object)mode)) {
            try {
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                this.exportEngine.exportArchive(archive, mode, registroReader, bout);
                bout.flush();
                bout.close();
                return bout.toByteArray();
            }
            catch (Exception e) {
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
        }
        throw new ProtocolException("Mode [" + mode + "] unknown");
    }

    public void exportArchive(Archive archive, OutputStream out, ArchiveMode mode, IRegistryReader registroReader, IConfigIntegrationReader configIntegrationReader) throws ProtocolException {
        if (Costanti.OPENSPCOOP_EXPORT_ARCHIVE_MODE.equals((Object)mode)) {
            super.exportArchive(archive, out, mode, registroReader, configIntegrationReader);
        } else if (SPCoopCostantiArchivi.EXPORT_MODE_COMPATIBILITA_CLIENT_SICA.equals((Object)mode) || SPCoopCostantiArchivi.EXPORT_MODE_INFORMAZIONI_COMPLETE.equals((Object)mode)) {
            this.exportEngine.exportArchive(archive, mode, registroReader, out);
        } else {
            throw new ProtocolException("Mode [" + mode + "] unknown");
        }
    }
}

