/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.trasparente.config;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.ProtocolException;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.trasparente.config.TrasparenteInstanceProperties;
import it.link.pdd.tools.migrazione_govway.utils.LoggerWrapperFactory;
import it.link.pdd.tools.migrazione_govway.utils.resources.Loader;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;

public class TrasparenteProperties {
    private Logger log = null;
    private static TrasparenteProperties trasparenteProperties = null;
    private TrasparenteInstanceProperties reader;
    private static Boolean generateIDasUUID = null;
    private static Boolean isPortaApplicativaBustaErrore_personalizzaElementiFault = null;
    private static Boolean isPortaApplicativaBustaErrore_personalizzaElementiFaultRead = null;
    private static Boolean isPortaApplicativaBustaErrore_aggiungiErroreApplicativo = null;
    private static Boolean isPortaApplicativaBustaErrore_aggiungiErroreApplicativoRead = null;
    private static Boolean isGenerazioneDetailsSOAPFaultProtocolValidazione = null;
    private static Boolean isGenerazioneDetailsSOAPFaultProtocolProcessamento = null;
    private static Boolean isGenerazioneDetailsSOAPFaultProtocolWithStackTrace = null;
    private static Boolean isGenerazioneDetailsSOAPFaultProtocolConInformazioniGeneriche = null;
    private static Boolean isGenerazioneDetailsSOAPFaultIntegrationServerError = null;
    private static Boolean isGenerazioneDetailsSOAPFaultIntegrationClientError = null;
    private static Boolean isGenerazioneDetailsSOAPFaultIntegrationWithStackTrace = null;
    private static Boolean isGenerazioneDetailsSOAPFaultIntegrationConInformazioniGeneriche = null;
    private static Boolean isGenerazioneDetailsSOAPFaultIntegrationConInformazioniGenericheRead = null;
    private static Boolean isAggiungiDetailErroreApplicativo_SoapFaultApplicativo = null;
    private static Boolean isAggiungiDetailErroreApplicativo_SoapFaultApplicativoRead = null;
    private static Boolean isAggiungiDetailErroreApplicativo_SoapFaultPdD = null;
    private static Boolean isAggiungiDetailErroreApplicativo_SoapFaultPdDRead = null;

    public TrasparenteProperties(String confDir, Logger log) throws ProtocolException {
        this.log = log != null ? log : LoggerWrapperFactory.getLogger((String)"TrasparenteProperties");
        Properties propertiesReader = new Properties();
        InputStream properties = null;
        try {
            properties = TrasparenteProperties.class.getResourceAsStream("/trasparente.properties");
            if (properties == null) {
                throw new Exception("File '/trasparente.properties' not found");
            }
            propertiesReader.load(properties);
        }
        catch (Exception e) {
            this.log.error("Riscontrato errore durante la lettura del file 'trasparente.properties': " + e.getMessage());
            throw new ProtocolException("TrasparenteProperties initialize error: " + e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (properties != null) {
                    properties.close();
                }
            }
            catch (Exception exception) {}
        }
        try {
            this.reader = new TrasparenteInstanceProperties(propertiesReader, this.log);
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
    }

    public static synchronized void initialize(String confDir, Logger log) throws ProtocolException {
        if (trasparenteProperties == null) {
            trasparenteProperties = new TrasparenteProperties(confDir, log);
        }
    }

    public static TrasparenteProperties getInstance(Logger log) throws ProtocolException {
        if (trasparenteProperties == null) {
            throw new ProtocolException("TrasparenteProperties not initialized (use init method in factory)");
        }
        return trasparenteProperties;
    }

    public void validaConfigurazione(Loader loader) throws ProtocolException {
        try {
            this.generateIDasUUID();
            this.isAggiungiDetailErroreApplicativo_SoapFaultApplicativo();
            this.isAggiungiDetailErroreApplicativo_SoapFaultPdD();
            this.isGenerazioneDetailsSOAPFaultProtocolValidazione();
            this.isGenerazioneDetailsSOAPFaultProtocolProcessamento();
            this.isGenerazioneDetailsSOAPFaultProtocolWithStackTrace();
            this.isGenerazioneDetailsSOAPFaultProtocolConInformazioniGeneriche();
            this.isGenerazioneDetailsSOAPFaultIntegrationServerError();
            this.isGenerazioneDetailsSOAPFaultIntegrationClientError();
            this.isGenerazioneDetailsSOAPFaultIntegrationWithStackTrace();
            this.isGenerazioneDetailsSOAPFaultIntegrazionConInformazioniGeneriche();
            this.isPortaApplicativaBustaErrore_personalizzaElementiFault();
            this.isPortaApplicativaBustaErrore_aggiungiErroreApplicativo();
        }
        catch (Exception e) {
            String msg = "Riscontrato errore durante la validazione della proprieta' del protocollo trasparente, " + e.getMessage();
            this.log.error(msg, (Throwable)e);
            throw new ProtocolException(msg, (Throwable)e);
        }
    }

    public Boolean generateIDasUUID() {
        if (generateIDasUUID == null) {
            Boolean defaultValue = true;
            String propertyName = "it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.trasparente.id.uuid";
            try {
                String value = this.reader.getValue_convertEnvProperties(propertyName);
                if (value != null) {
                    value = value.trim();
                    generateIDasUUID = Boolean.parseBoolean(value);
                } else {
                    this.log.warn("Proprieta' di openspcoop '" + propertyName + "' non impostata, viene utilizzato il default=" + defaultValue);
                    generateIDasUUID = defaultValue;
                }
            }
            catch (Exception e) {
                this.log.warn("Proprieta' di openspcoop '" + propertyName + "' non impostata, viene utilizzato il default=" + defaultValue + ", errore:" + e.getMessage());
                generateIDasUUID = defaultValue;
            }
        }
        return generateIDasUUID;
    }

    public Boolean isPortaApplicativaBustaErrore_personalizzaElementiFault() {
        if (isPortaApplicativaBustaErrore_personalizzaElementiFaultRead == null) {
            try {
                String value = this.reader.getValue_convertEnvProperties("it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.trasparente.pa.bustaErrore.personalizzaElementiFault");
                if (value != null) {
                    value = value.trim();
                    isPortaApplicativaBustaErrore_personalizzaElementiFault = Boolean.parseBoolean(value);
                } else {
                    this.log.debug("Proprieta' di openspcoop 'it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.trasparente.pa.bustaErrore.personalizzaElementiFault' non impostata, viene utilizzato il default associato al Servizio Applicativo (faultApplicativo.enrichDetails)");
                    isPortaApplicativaBustaErrore_personalizzaElementiFault = null;
                }
                isPortaApplicativaBustaErrore_personalizzaElementiFaultRead = true;
            }
            catch (Exception e) {
                this.log.warn("Proprieta' di openspcoop 'it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.trasparente.pa.bustaErrore.personalizzaElementiFault' non impostata, viene utilizzato il default associato al Servizio Applicativo (faultApplicativo.enrichDetails), errore:" + e.getMessage());
                isPortaApplicativaBustaErrore_personalizzaElementiFault = null;
                isPortaApplicativaBustaErrore_personalizzaElementiFaultRead = true;
            }
        }
        return isPortaApplicativaBustaErrore_personalizzaElementiFault;
    }

    public Boolean isPortaApplicativaBustaErrore_aggiungiErroreApplicativo() {
        if (isPortaApplicativaBustaErrore_aggiungiErroreApplicativoRead == null) {
            try {
                String value = this.reader.getValue_convertEnvProperties("it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.trasparente.pa.bustaErrore.aggiungiErroreApplicativo");
                if (value != null) {
                    value = value.trim();
                    isPortaApplicativaBustaErrore_aggiungiErroreApplicativo = Boolean.parseBoolean(value);
                } else {
                    this.log.debug("Proprieta' di openspcoop 'it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.trasparente.pa.bustaErrore.aggiungiErroreApplicativo' non impostata, viene utilizzato il default associato al Servizio Applicativo (faultApplicativo.enrichDetails)");
                    isPortaApplicativaBustaErrore_aggiungiErroreApplicativo = null;
                }
                isPortaApplicativaBustaErrore_aggiungiErroreApplicativoRead = true;
            }
            catch (Exception e) {
                this.log.warn("Proprieta' di openspcoop 'it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.trasparente.pa.bustaErrore.aggiungiErroreApplicativo' non impostata, viene utilizzato il default associato al Servizio Applicativo (faultApplicativo.enrichDetails), errore:" + e.getMessage());
                isPortaApplicativaBustaErrore_aggiungiErroreApplicativo = null;
                isPortaApplicativaBustaErrore_aggiungiErroreApplicativoRead = true;
            }
        }
        return isPortaApplicativaBustaErrore_aggiungiErroreApplicativo;
    }

    public boolean isGenerazioneDetailsSOAPFaultProtocolValidazione() {
        if (isGenerazioneDetailsSOAPFaultProtocolValidazione == null) {
            try {
                String value = this.reader.getValue_convertEnvProperties("it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.trasparente.generazioneDetailsSoapFault.protocol.eccezioneIntestazione");
                if (value != null) {
                    value = value.trim();
                    isGenerazioneDetailsSOAPFaultProtocolValidazione = Boolean.parseBoolean(value);
                } else {
                    this.log.warn("Proprieta' di openspcoop 'it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.trasparente.generazioneDetailsSoapFault.protocol.eccezioneIntestazione' non impostata, viene utilizzato il default=false");
                    isGenerazioneDetailsSOAPFaultProtocolValidazione = false;
                }
            }
            catch (Exception e) {
                this.log.warn("Proprieta' di openspcoop 'it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.trasparente.generazioneDetailsSoapFault.protocol.eccezioneIntestazione' non impostata, viene utilizzato il default=false, errore:" + e.getMessage());
                isGenerazioneDetailsSOAPFaultProtocolValidazione = false;
            }
        }
        return isGenerazioneDetailsSOAPFaultProtocolValidazione;
    }

    public boolean isGenerazioneDetailsSOAPFaultProtocolProcessamento() {
        if (isGenerazioneDetailsSOAPFaultProtocolProcessamento == null) {
            try {
                String value = this.reader.getValue_convertEnvProperties("it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.trasparente.generazioneDetailsSoapFault.protocol.eccezioneProcessamento");
                if (value != null) {
                    value = value.trim();
                    isGenerazioneDetailsSOAPFaultProtocolProcessamento = Boolean.parseBoolean(value);
                } else {
                    this.log.warn("Proprieta' di openspcoop 'it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.trasparente.generazioneDetailsSoapFault.protocol.eccezioneProcessamento' non impostata, viene utilizzato il default=true");
                    isGenerazioneDetailsSOAPFaultProtocolProcessamento = true;
                }
            }
            catch (Exception e) {
                this.log.warn("Proprieta' di openspcoop 'it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.trasparente.generazioneDetailsSoapFault.protocol.eccezioneProcessamento' non impostata, viene utilizzato il default=true, errore:" + e.getMessage());
                isGenerazioneDetailsSOAPFaultProtocolProcessamento = true;
            }
        }
        return isGenerazioneDetailsSOAPFaultProtocolProcessamento;
    }

    public boolean isGenerazioneDetailsSOAPFaultProtocolWithStackTrace() {
        if (isGenerazioneDetailsSOAPFaultProtocolWithStackTrace == null) {
            try {
                String value = this.reader.getValue_convertEnvProperties("it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.trasparente.generazioneDetailsSoapFault.protocol.stackTrace");
                if (value != null) {
                    value = value.trim();
                    isGenerazioneDetailsSOAPFaultProtocolWithStackTrace = Boolean.parseBoolean(value);
                } else {
                    this.log.warn("Proprieta' di openspcoop 'it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.trasparente.generazioneDetailsSoapFault.protocol.stackTrace' non impostata, viene utilizzato il default=false");
                    isGenerazioneDetailsSOAPFaultProtocolWithStackTrace = false;
                }
            }
            catch (Exception e) {
                this.log.warn("Proprieta' di openspcoop 'it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.trasparente.generazioneDetailsSoapFault.protocol.stackTrace' non impostata, viene utilizzato il default=false, errore:" + e.getMessage());
                isGenerazioneDetailsSOAPFaultProtocolWithStackTrace = false;
            }
        }
        return isGenerazioneDetailsSOAPFaultProtocolWithStackTrace;
    }

    public boolean isGenerazioneDetailsSOAPFaultProtocolConInformazioniGeneriche() {
        if (isGenerazioneDetailsSOAPFaultProtocolConInformazioniGeneriche == null) {
            try {
                String value = this.reader.getValue_convertEnvProperties("it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.trasparente.generazioneDetailsSoapFault.protocol.informazioniGeneriche");
                if (value != null) {
                    value = value.trim();
                    isGenerazioneDetailsSOAPFaultProtocolConInformazioniGeneriche = Boolean.parseBoolean(value);
                } else {
                    this.log.warn("Proprieta' di openspcoop 'it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.trasparente.generazioneDetailsSoapFault.protocol.informazioniGeneriche' non impostata, viene utilizzato il default=true");
                    isGenerazioneDetailsSOAPFaultProtocolConInformazioniGeneriche = true;
                }
            }
            catch (Exception e) {
                this.log.warn("Proprieta' di openspcoop 'it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.trasparente.generazioneDetailsSoapFault.protocol.informazioniGeneriche' non impostata, viene utilizzato il default=true, errore:" + e.getMessage());
                isGenerazioneDetailsSOAPFaultProtocolConInformazioniGeneriche = true;
            }
        }
        return isGenerazioneDetailsSOAPFaultProtocolConInformazioniGeneriche;
    }

    public boolean isGenerazioneDetailsSOAPFaultIntegrationServerError() {
        if (isGenerazioneDetailsSOAPFaultIntegrationServerError == null) {
            try {
                String value = this.reader.getValue_convertEnvProperties("it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.trasparente.generazioneDetailsSoapFault.integration.serverError");
                if (value != null) {
                    value = value.trim();
                    isGenerazioneDetailsSOAPFaultIntegrationServerError = Boolean.parseBoolean(value);
                } else {
                    this.log.warn("Proprieta' di openspcoop 'it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.trasparente.generazioneDetailsSoapFault.integration.serverError' non impostata, viene utilizzato il default=true");
                    isGenerazioneDetailsSOAPFaultIntegrationServerError = true;
                }
            }
            catch (Exception e) {
                this.log.warn("Proprieta' di openspcoop 'it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.trasparente.generazioneDetailsSoapFault.integration.serverError' non impostata, viene utilizzato il default=true, errore:" + e.getMessage());
                isGenerazioneDetailsSOAPFaultIntegrationServerError = true;
            }
        }
        return isGenerazioneDetailsSOAPFaultIntegrationServerError;
    }

    public boolean isGenerazioneDetailsSOAPFaultIntegrationClientError() {
        if (isGenerazioneDetailsSOAPFaultIntegrationClientError == null) {
            try {
                String value = this.reader.getValue_convertEnvProperties("it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.trasparente.generazioneDetailsSoapFault.integration.clientError");
                if (value != null) {
                    value = value.trim();
                    isGenerazioneDetailsSOAPFaultIntegrationClientError = Boolean.parseBoolean(value);
                } else {
                    this.log.warn("Proprieta' di openspcoop 'it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.trasparente.generazioneDetailsSoapFault.integration.clientError' non impostata, viene utilizzato il default=false");
                    isGenerazioneDetailsSOAPFaultIntegrationClientError = false;
                }
            }
            catch (Exception e) {
                this.log.warn("Proprieta' di openspcoop 'it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.trasparente.generazioneDetailsSoapFault.integration.clientError' non impostata, viene utilizzato il default=false, errore:" + e.getMessage());
                isGenerazioneDetailsSOAPFaultIntegrationClientError = false;
            }
        }
        return isGenerazioneDetailsSOAPFaultIntegrationClientError;
    }

    public boolean isGenerazioneDetailsSOAPFaultIntegrationWithStackTrace() {
        if (isGenerazioneDetailsSOAPFaultIntegrationWithStackTrace == null) {
            try {
                String value = this.reader.getValue_convertEnvProperties("it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.trasparente.generazioneDetailsSoapFault.integration.stackTrace");
                if (value != null) {
                    value = value.trim();
                    isGenerazioneDetailsSOAPFaultIntegrationWithStackTrace = Boolean.parseBoolean(value);
                } else {
                    this.log.warn("Proprieta' di openspcoop 'it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.trasparente.generazioneDetailsSoapFault.integration.stackTrace' non impostata, viene utilizzato il default=false");
                    isGenerazioneDetailsSOAPFaultIntegrationWithStackTrace = false;
                }
            }
            catch (Exception e) {
                this.log.warn("Proprieta' di openspcoop 'it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.trasparente.generazioneDetailsSoapFault.integration.stackTrace' non impostata, viene utilizzato il default=false, errore:" + e.getMessage());
                isGenerazioneDetailsSOAPFaultIntegrationWithStackTrace = false;
            }
        }
        return isGenerazioneDetailsSOAPFaultIntegrationWithStackTrace;
    }

    public Boolean isGenerazioneDetailsSOAPFaultIntegrazionConInformazioniGeneriche() {
        if (isGenerazioneDetailsSOAPFaultIntegrationConInformazioniGenericheRead == null) {
            try {
                String value = this.reader.getValue_convertEnvProperties("it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.trasparente.generazioneDetailsSoapFault.integration.informazioniGeneriche");
                if (value != null) {
                    value = value.trim();
                    isGenerazioneDetailsSOAPFaultIntegrationConInformazioniGeneriche = Boolean.parseBoolean(value);
                } else {
                    this.log.debug("Proprieta' di openspcoop 'it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.trasparente.generazioneDetailsSoapFault.integration.informazioniGeneriche' non impostata, viene utilizzato il default associato al Servizio Applicativo (faultAsGenericCode)");
                    isGenerazioneDetailsSOAPFaultIntegrationConInformazioniGeneriche = null;
                }
                isGenerazioneDetailsSOAPFaultIntegrationConInformazioniGenericheRead = true;
            }
            catch (Exception e) {
                this.log.warn("Proprieta' di openspcoop 'it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.trasparente.generazioneDetailsSoapFault.integration.informazioniGeneriche' non impostata, viene utilizzato il default associato al Servizio Applicativo (faultAsGenericCode), errore:" + e.getMessage());
                isGenerazioneDetailsSOAPFaultIntegrationConInformazioniGeneriche = null;
                isGenerazioneDetailsSOAPFaultIntegrationConInformazioniGenericheRead = true;
            }
        }
        return isGenerazioneDetailsSOAPFaultIntegrationConInformazioniGeneriche;
    }

    public Boolean isAggiungiDetailErroreApplicativo_SoapFaultApplicativo() {
        if (isAggiungiDetailErroreApplicativo_SoapFaultApplicativoRead == null) {
            try {
                String value = this.reader.getValue_convertEnvProperties("it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.trasparente.erroreApplicativo.faultApplicativo.enrichDetails");
                if (value != null) {
                    value = value.trim();
                    isAggiungiDetailErroreApplicativo_SoapFaultApplicativo = Boolean.parseBoolean(value);
                } else {
                    this.log.debug("Proprieta' di openspcoop 'it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.trasparente.erroreApplicativo.faultApplicativo.enrichDetails' non impostata, viene utilizzato il default associato al Servizio Applicativo (faultApplicativo.enrichDetails)");
                    isAggiungiDetailErroreApplicativo_SoapFaultApplicativo = null;
                }
                isAggiungiDetailErroreApplicativo_SoapFaultApplicativoRead = true;
            }
            catch (Exception e) {
                this.log.warn("Proprieta' di openspcoop 'it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.trasparente.erroreApplicativo.faultApplicativo.enrichDetails' non impostata, viene utilizzato il default associato al Servizio Applicativo (faultApplicativo.enrichDetails), errore:" + e.getMessage());
                isAggiungiDetailErroreApplicativo_SoapFaultApplicativo = null;
                isAggiungiDetailErroreApplicativo_SoapFaultApplicativoRead = true;
            }
        }
        return isAggiungiDetailErroreApplicativo_SoapFaultApplicativo;
    }

    public Boolean isAggiungiDetailErroreApplicativo_SoapFaultPdD() {
        if (isAggiungiDetailErroreApplicativo_SoapFaultPdDRead == null) {
            try {
                String value = this.reader.getValue_convertEnvProperties("it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.trasparente.erroreApplicativo.faultPdD.enrichDetails");
                if (value != null) {
                    value = value.trim();
                    isAggiungiDetailErroreApplicativo_SoapFaultPdD = Boolean.parseBoolean(value);
                } else {
                    this.log.debug("Proprieta' di openspcoop 'it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.trasparente.erroreApplicativo.faultPdD.enrichDetails' non impostata, viene utilizzato il default associato al Servizio Applicativo (faultPdD.enrichDetails)");
                    isAggiungiDetailErroreApplicativo_SoapFaultPdD = null;
                }
                isAggiungiDetailErroreApplicativo_SoapFaultPdDRead = true;
            }
            catch (Exception e) {
                this.log.warn("Proprieta' di openspcoop 'it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.trasparente.erroreApplicativo.faultPdD.enrichDetails' non impostata, viene utilizzato il default associato al Servizio Applicativo (faultPdD.enrichDetails), errore:" + e.getMessage());
                isAggiungiDetailErroreApplicativo_SoapFaultPdD = null;
                isAggiungiDetailErroreApplicativo_SoapFaultPdDRead = true;
            }
        }
        return isAggiungiDetailErroreApplicativo_SoapFaultPdD;
    }
}

