/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.monitor.sdk.transaction;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.openspcoop2.core.commons.dao.DAOFactory;
import org.openspcoop2.core.transazioni.Transazione;
import org.openspcoop2.monitor.sdk.constants.TransactionExceptionCode;
import org.openspcoop2.monitor.sdk.exceptions.TransactionException;
import org.openspcoop2.monitor.sdk.transaction.AbstractContentResource;
import org.openspcoop2.monitor.sdk.transaction.SLATrace;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.builder.EsitoTransazione;
import org.openspcoop2.protocol.sdk.diagnostica.MsgDiagnostico;
import org.openspcoop2.protocol.sdk.tracciamento.Traccia;
import org.openspcoop2.protocol.utils.EsitiProperties;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.slf4j.Logger;

public class Transaction {
    private Logger log = LoggerWrapperFactory.getLogger(Transaction.class);
    private DAOFactory daoFactory = null;
    private Transazione transaction;
    private String idTransazione;
    private EsitoTransazione transactionResult;
    private List<MsgDiagnostico> msgdiagnosticiList = new ArrayList<MsgDiagnostico>();
    private Traccia requestTrace;
    private Traccia responseTrace;
    private List<AbstractContentResource> risorseContenuto = new ArrayList<AbstractContentResource>();
    private SLATrace slaTrace;

    public Transaction(Logger log, DAOFactory daoFactory, Transazione transaction) throws ProtocolException {
        this(log, daoFactory, transaction, null, null, null);
    }

    public Transaction(Logger log, DAOFactory daoFactory, Transazione transaction, Traccia requestTrace, Traccia responseTrace, List<MsgDiagnostico> msgdiagnosticiList) throws ProtocolException {
        this.log = log;
        this.daoFactory = daoFactory;
        this.idTransazione = transaction.getIdTransazione();
        this.transactionResult = EsitiProperties.getInstanceFromProtocolName((Logger)this.log, (String)transaction.getProtocollo()).convertToEsitoTransazione(Integer.valueOf(transaction.getEsito()), transaction.getEsitoContesto());
        this.transaction = transaction;
        this.requestTrace = requestTrace;
        this.responseTrace = responseTrace;
        this.msgdiagnosticiList = msgdiagnosticiList;
    }

    public Logger getLogger() {
        return this.log;
    }

    public DAOFactory getDAOFactory() {
        return this.daoFactory;
    }

    public String getIdTransazione() {
        return this.idTransazione;
    }

    public EsitoTransazione getTransactionResult() {
        return this.transactionResult;
    }

    public Transazione getTransaction() {
        return this.transaction;
    }

    public void setMsgdiagnosticiList(List<MsgDiagnostico> msgdiagnosticiList) {
        this.msgdiagnosticiList = msgdiagnosticiList;
    }

    public List<MsgDiagnostico> getMsgDiagnostici() {
        return this.msgdiagnosticiList;
    }

    public void addMsgDiagnostico(MsgDiagnostico msgDiag) {
        this.msgdiagnosticiList.add(msgDiag);
    }

    public void removeDiagnosticMessages() {
        this.msgdiagnosticiList.clear();
    }

    public MsgDiagnostico getDiagnosticMessage(int index) {
        return this.msgdiagnosticiList.get(index);
    }

    public void removeDiagnosticMessage(int index) {
        this.msgdiagnosticiList.remove(index);
    }

    public int countDiagnosticMessages() {
        return this.msgdiagnosticiList.size();
    }

    public Traccia getRequestTrace() {
        return this.requestTrace;
    }

    public void setRequestTrace(Traccia requestTrace) {
        this.requestTrace = requestTrace;
    }

    public Traccia getResponseTrace() {
        return this.responseTrace;
    }

    public void setResponseTrace(Traccia responseTrace) {
        this.responseTrace = responseTrace;
    }

    public List<AbstractContentResource> getContentResources() {
        return this.risorseContenuto;
    }

    public <ContentResourceType> List<ContentResourceType> getContentResourcesByType(Class<ContentResourceType> type) {
        LinkedList<AbstractContentResource> retList = new LinkedList<AbstractContentResource>();
        if (this.risorseContenuto != null) {
            for (int i = 0; i < this.risorseContenuto.size(); ++i) {
                if (!type.equals(this.risorseContenuto.get(i).getClass())) continue;
                retList.add(this.risorseContenuto.get(i));
            }
        }
        return retList;
    }

    public AbstractContentResource getContentResourceByName(String name) {
        AbstractContentResource retResource = null;
        if (this.risorseContenuto != null) {
            for (int i = 0; i < this.risorseContenuto.size(); ++i) {
                if (!name.equals(this.risorseContenuto.get(i).getName())) continue;
                retResource = this.risorseContenuto.get(i);
            }
        }
        return retResource;
    }

    public void addContentResource(AbstractContentResource resource) throws TransactionException {
        for (int i = 0; i < this.risorseContenuto.size(); ++i) {
            if (!resource.getName().equals(this.risorseContenuto.get(i).getName())) continue;
            throw new TransactionException(TransactionExceptionCode.ADD_RES_EXIST);
        }
        this.risorseContenuto.add(resource);
    }

    public void updateContentResource(AbstractContentResource resource) throws TransactionException {
        int index = 0;
        boolean found = false;
        while (!found && this.risorseContenuto != null && index < this.risorseContenuto.size()) {
            if (resource.getName().equals(this.risorseContenuto.get(index).getName())) {
                found = true;
                continue;
            }
            ++index;
        }
        if (!found) {
            throw new TransactionException(TransactionExceptionCode.UPD_RES_NOT_EXIST);
        }
        this.risorseContenuto.set(index, resource);
    }

    public void removeContentResource(AbstractContentResource resource) throws TransactionException {
        int index = 0;
        boolean found = false;
        while (!found && this.risorseContenuto != null && index < this.risorseContenuto.size()) {
            if (resource.getName().equals(this.risorseContenuto.get(index).getName())) {
                found = true;
                continue;
            }
            ++index;
        }
        if (!found) {
            throw new TransactionException(TransactionExceptionCode.DEL_RES_NOT_EXIST);
        }
        this.risorseContenuto.remove(index);
    }

    public SLATrace getSlaTrace() {
        return this.slaTrace;
    }

    public void setSlaTrace(SLATrace slaTrace) {
        this.slaTrace = slaTrace;
    }
}

