/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.wssecurity;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPPart;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.message.PrefixedQName;
import org.apache.axis.message.SOAPBody;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.message.SOAPHeader;
import org.apache.axis.message.SOAPHeaderElement;
import org.apache.ws.axis.security.WSDoAllReceiver;
import org.apache.ws.security.SOAP11Constants;
import org.apache.ws.security.SOAPConstants;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.handler.WSHandlerResult;
import org.apache.ws.security.util.WSSecurityUtil;
import org.openspcoop.egov.Busta;
import org.openspcoop.utils.Loader;
import org.openspcoop.wssecurity.Authorization;
import org.openspcoop.wssecurity.WSDoAllReceiverNoActionOrderCheck;
import org.openspcoop.wssecurity.WSSBaseUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSSReceiver {
    private String msgErrore;
    private String codiceErrore;
    private WSSBaseUtils baseUtilsWSS;
    private String subject;

    public WSSReceiver(Hashtable<?, ?> wssProperties, WSSBaseUtils baseWSS) {
        this.baseUtilsWSS = baseWSS;
        this.baseUtilsWSS.setMessageContext(wssProperties);
    }

    public boolean process(Message axisMessage, Busta busta) {
        block13: {
            try {
                if (this.baseUtilsWSS.getMessageContext() == null) break block13;
                this.baseUtilsWSS.getMessageContext().setCurrentMessage(axisMessage);
                String authClass = (String)this.baseUtilsWSS.getMessageContext().getProperty("authorizationClass");
                String actor = (String)this.baseUtilsWSS.getMessageContext().getProperty("actor");
                String mustUnderstand = (String)this.baseUtilsWSS.getMessageContext().getProperty("mustUnderstand");
                boolean mustUnderstandValue = Boolean.parseBoolean(mustUnderstand);
                String actionOrderCheck = (String)this.baseUtilsWSS.getMessageContext().getProperty("actionOrderCheck");
                WSDoAllReceiverNoActionOrderCheck recever = null;
                recever = actionOrderCheck != null && actionOrderCheck.equalsIgnoreCase("true") ? new WSDoAllReceiver() : new WSDoAllReceiverNoActionOrderCheck();
                if (actor != null) {
                    recever.setOption("actor", actor);
                }
                List<WSSReference> elementsToClean = this.getWSSDirtyElements(axisMessage, actor, mustUnderstandValue);
                recever.invoke(this.baseUtilsWSS.getMessageContext());
                try {
                    this.subject = this.getPrincipal(actor);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (authClass != null) {
                    try {
                        Authorization auth = (Authorization)Loader.getInstance().newInstance(authClass);
                        boolean status = auth.authorize(this.subject, busta);
                        if (!status) {
                            this.msgErrore = auth.getMessaggioErrore() != null ? auth.getMessaggioErrore() : "Mittente della busta [" + busta.getTipoMittente() + busta.getMittente() + "] (subject:" + this.subject + ") non autorizzato ad invocare il servizio [" + busta.getServizio() + "] erogato dal soggetto [" + busta.getTipoDestinatario() + busta.getDestinatario() + "]";
                            this.codiceErrore = "EGOV_IT_201";
                            return false;
                        }
                    }
                    catch (Exception e) {
                        this.baseUtilsWSS.getLog().error((Object)("Errore di Processamento durante l'autorizzazione: " + e.getMessage()), (Throwable)e);
                        throw new AxisFault("Errore di Processamento durante l'autorizzazione: " + e.getMessage());
                    }
                }
                String actorDaPulire = actor;
                if ("".equals(actor)) {
                    actorDaPulire = null;
                }
                try {
                    this.cleanWSSDirtyElements(axisMessage, actorDaPulire, mustUnderstandValue, elementsToClean);
                }
                catch (SOAPException e) {
                    throw new Exception("Errore durante la cleanWSSDirtyElements: " + e.getMessage());
                }
            }
            catch (AxisFault af) {
                this.msgErrore = "Generatosi errore durante il processamento WS-Security(Receiver) [code: " + af.getFaultCode() + "]\n" + af.getFaultString();
                this.codiceErrore = af.getFaultString() != null && af.getFaultString().contains("The signature or decryption was invalid") ? "EGOV_IT_202" : "EGOV_IT_200";
                this.baseUtilsWSS.getLog().error((Object)this.msgErrore, (Throwable)af);
                return false;
            }
            catch (Exception e) {
                this.msgErrore = "Generatosi errore durante il processamento WS-Security(Receiver): " + e.getMessage();
                this.codiceErrore = "EGOV_IT_200";
                this.baseUtilsWSS.getLog().error((Object)this.msgErrore, (Throwable)e);
                return false;
            }
        }
        return true;
    }

    public String getMsgErrore() {
        return this.msgErrore;
    }

    public String getCodiceErrore() {
        return this.codiceErrore;
    }

    public String getActor() {
        return this.baseUtilsWSS.getActor();
    }

    @Deprecated
    public void clean(SOAPEnvelope envelope, String actor, boolean mustUnderstand) throws AxisFault {
        try {
            SOAPHeader header = (SOAPHeader)envelope.getHeader();
            Iterator it = header.getChildElements();
            SOAPHeaderElement elementWSS = null;
            int countWSSHeader = 0;
            while (it.hasNext()) {
                SOAPHeaderElement elementInVerifica = (SOAPHeaderElement)it.next();
                if (!"Security".equals(elementInVerifica.getLocalName()) || !"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd".equals(elementInVerifica.getNamespaceURI())) continue;
                ++countWSSHeader;
                if (actor == null) {
                    if (elementInVerifica.getActor() != null || mustUnderstand != elementInVerifica.getMustUnderstand()) continue;
                    elementWSS = elementInVerifica;
                    continue;
                }
                if (!actor.equals(elementInVerifica.getActor()) || mustUnderstand != elementInVerifica.getMustUnderstand()) continue;
                elementWSS = elementInVerifica;
            }
            if (elementWSS == null) {
                throw new AxisFault("cleanWSS: header WSS gestito non trovato.");
            }
            header.removeChild(elementWSS);
            if (countWSSHeader == 1) {
                SOAPBody body = (SOAPBody)envelope.getBody();
                body.removeAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
                body.removeNamespaceDeclaration("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new AxisFault("Errore di Processamento: " + e.getMessage());
        }
    }

    public String getPrincipal(String actor) {
        MessageContext msgContext = this.baseUtilsWSS.getMessageContext();
        String principal = null;
        Vector results = (Vector)msgContext.getProperty("RECV_RESULTS");
        for (int i = 0; results != null && i < results.size(); ++i) {
            int actionGet;
            WSSecurityEngineResult eResult;
            int j;
            Vector hResults;
            WSHandlerResult hResult = (WSHandlerResult)results.get(i);
            if (actor != null) {
                if (hResult.getActor().compareTo(actor) != 0) continue;
                hResults = hResult.getResults();
                for (j = 0; j < hResults.size(); ++j) {
                    eResult = (WSSecurityEngineResult)hResults.get(j);
                    actionGet = (Integer)eResult.get((Object)"action");
                    if (actionGet != 2 && actionGet != 1) continue;
                    principal = ((Principal)eResult.get((Object)"principal")).getName();
                }
                continue;
            }
            hResults = hResult.getResults();
            for (j = 0; j < hResults.size(); ++j) {
                eResult = (WSSecurityEngineResult)hResults.get(j);
                actionGet = (Integer)eResult.get((Object)"action");
                if (actionGet != 2 && actionGet != 1) continue;
                principal = ((Principal)eResult.get((Object)"principal")).getName();
            }
        }
        return principal;
    }

    public String getSubject() {
        return this.subject;
    }

    public List<WSSReference> getWSSDirtyElements(Message message, String actor, boolean mustUnderstand) throws SOAPException {
        ArrayList<WSSReference> references = new ArrayList<WSSReference>();
        SOAPPart soapPart = message.getSOAPPart();
        SOAPElement security = (SOAPElement)WSSReceiver.getSecurityHeader((Document)soapPart, actor, (SOAPConstants)new SOAP11Constants());
        this.saveWSSDirtyEncryptElements(security, soapPart, references);
        this.saveWSSDirtySignatureElements(security, soapPart, references);
        return references;
    }

    public void saveWSSDirtyEncryptElements(SOAPElement security, SOAPPart soapPart, List<WSSReference> references) throws SOAPException {
        Iterator it = security.getChildElements((Name)new PrefixedQName(new QName("http://www.w3.org/2001/04/xmlenc#", "EncryptedKey")));
        if (it.hasNext()) {
            SOAPElement encryptedKey = (SOAPElement)it.next();
            SOAPElement referenceList = (SOAPElement)encryptedKey.getChildElements((Name)new PrefixedQName(new QName("http://www.w3.org/2001/04/xmlenc#", "ReferenceList"))).next();
            Iterator referenceListIterator = referenceList.getChildElements();
            while (referenceListIterator.hasNext()) {
                String referenceWithSharp = ((SOAPElement)referenceListIterator.next()).getAttributeValue((Name)new PrefixedQName(new QName("URI")));
                String reference = referenceWithSharp.substring(1);
                SOAPElement encryptedElement = (SOAPElement)WSSecurityUtil.findElementById((Node)soapPart.getEnvelope(), (String)reference, null);
                if (encryptedElement == null) {
                    throw new SOAPException("Multiple elements with the same 'Id' attribute value (" + referenceWithSharp + ") [EncryptSearch]?");
                }
                if (encryptedElement.getAttributeNS(null, "Type").equals("http://www.w3.org/2001/04/xmlenc#Content")) {
                    references.add(new WSSReference(encryptedElement.getParentElement(), 1, reference));
                    continue;
                }
                references.add(new WSSReference(encryptedElement.getParentElement(), 2, reference));
            }
        }
    }

    public void saveWSSDirtySignatureElements(SOAPElement security, SOAPPart soapPart, List<WSSReference> references) throws SOAPException {
        Iterator it = security.getChildElements((Name)new PrefixedQName(new QName("http://www.w3.org/2000/09/xmldsig#", "Signature")));
        if (it.hasNext()) {
            SOAPElement signature = (SOAPElement)it.next();
            SOAPElement signatureInfo = (SOAPElement)signature.getChildElements((Name)new PrefixedQName(new QName("http://www.w3.org/2000/09/xmldsig#", "SignedInfo"))).next();
            Iterator referenceIterator = signatureInfo.getChildElements((Name)new PrefixedQName(new QName("http://www.w3.org/2000/09/xmldsig#", "Reference")));
            while (referenceIterator.hasNext()) {
                String referenceWithSharp = ((SOAPElement)referenceIterator.next()).getAttributeValue((Name)new PrefixedQName(new QName("URI")));
                String reference = referenceWithSharp.substring(1);
                SOAPElement signedElement = (SOAPElement)WSSecurityUtil.findElementById((Node)soapPart.getEnvelope(), (String)reference, (String)"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
                if (signedElement == null) {
                    throw new SOAPException("Multiple elements with the same 'Id' attribute value (" + referenceWithSharp + ") [SignatureSearch]?");
                }
                references.add(new WSSReference(signedElement, 3, reference));
            }
        }
    }

    public static Element getSecurityHeader(Document doc, String actor, SOAPConstants sc) {
        Element soapHeaderElement = (Element)WSSecurityUtil.getDirectChild((Node)doc.getDocumentElement(), (String)sc.getHeaderQName().getLocalPart(), (String)sc.getEnvelopeURI());
        if (soapHeaderElement == null) {
            return null;
        }
        NodeList list = soapHeaderElement.getElementsByTagNameNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Security");
        if (list == null) {
            return null;
        }
        for (int i = 0; i < list.getLength(); ++i) {
            SOAPHeaderElement h;
            String hActor;
            Element elem = (Element)list.item(i);
            if (!(elem instanceof SOAPHeaderElement) || !WSSecurityUtil.isActorEqual((String)actor, (String)(hActor = (h = (SOAPHeaderElement)elem).getActor()))) continue;
            return elem;
        }
        return null;
    }

    public void cleanWSSDirtyElements(Message message, String actor, boolean mustUnderstand, List<WSSReference> references) throws SOAPException {
        SOAPPart soapPart = message.getSOAPPart();
        javax.xml.soap.SOAPHeader soapHeader = message.getSOAPHeader();
        SOAPElement security = (SOAPElement)WSSReceiver.getSecurityHeader((Document)soapPart, actor, (SOAPConstants)new SOAP11Constants());
        this.saveWSSDirtySignatureElements(security, soapPart, references);
        security.detachNode();
        block5: for (int i = 0; i < references.size(); ++i) {
            WSSReference reference = references.get(i);
            SOAPElement elementToClean = reference.getElement();
            switch (reference.getType()) {
                case 3: {
                    boolean found = false;
                    NodeList securities = soapHeader.getElementsByTagNameNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Security");
                    for (int s = 0; s < securities.getLength(); ++s) {
                        security = (SOAPElement)securities.item(s);
                        Iterator it = security.getChildElements((Name)new PrefixedQName(new QName("http://www.w3.org/2000/09/xmldsig#", "Signature")));
                        if (!it.hasNext()) continue;
                        SOAPElement signature = (SOAPElement)it.next();
                        SOAPElement signatureInfo = (SOAPElement)signature.getChildElements((Name)new PrefixedQName(new QName("http://www.w3.org/2000/09/xmldsig#", "SignedInfo"))).next();
                        Iterator referenceIterator = signatureInfo.getChildElements((Name)new PrefixedQName(new QName("http://www.w3.org/2000/09/xmldsig#", "Reference")));
                        while (referenceIterator.hasNext()) {
                            String referenceWithSharp = ((SOAPElement)referenceIterator.next()).getAttributeValue((Name)new PrefixedQName(new QName("URI")));
                            if (!reference.getReference().equals(referenceWithSharp.substring(1))) continue;
                            found = true;
                        }
                    }
                    if (found) continue block5;
                    elementToClean.removeAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
                    Iterator prefixes = elementToClean.getNamespacePrefixes();
                    while (prefixes.hasNext()) {
                        String prefix = (String)prefixes.next();
                        String namespace = elementToClean.getNamespaceURI(prefix);
                        if (!namespace.equals("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd")) continue;
                        elementToClean.removeNamespaceDeclaration(prefix);
                    }
                    prefixes = elementToClean.getAllAttributes();
                    while (prefixes.hasNext()) {
                        Object o = prefixes.next();
                        PrefixedQName attr = (PrefixedQName)o;
                        String prefix = attr.getPrefix();
                        String namespace = elementToClean.getNamespaceURI(prefix);
                        if (!namespace.equals("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd")) continue;
                        elementToClean.removeNamespaceDeclaration(prefix);
                    }
                    continue block5;
                }
                case 1: {
                    boolean found = false;
                    Iterator childrenToClean = elementToClean.getChildElements();
                    while (childrenToClean.hasNext() && !found) {
                        Object next = childrenToClean.next();
                        if (!(next instanceof SOAPElement)) continue;
                        SOAPElement childToClean = (SOAPElement)next;
                        ArrayList<String> prefixesToRemove = new ArrayList<String>();
                        Iterator prefixes = childToClean.getNamespacePrefixes();
                        while (prefixes.hasNext()) {
                            String prefix = (String)prefixes.next();
                            String namespace = childToClean.getNamespaceURI(prefix);
                            if (!namespace.equals("http://www.w3.org/2001/04/xmlenc#") && !namespace.equals(elementToClean.getNamespaceURI(prefix))) continue;
                            prefixesToRemove.add(prefix);
                        }
                        prefixes = elementToClean.getAllAttributes();
                        while (prefixes.hasNext()) {
                            Object o = prefixes.next();
                            PrefixedQName attr = (PrefixedQName)o;
                            String prefix = attr.getPrefix();
                            String namespace = childToClean.getNamespaceURI(prefix);
                            if (!namespace.equals("http://www.w3.org/2001/04/xmlenc#") && !namespace.equals(elementToClean.getNamespaceURI(prefix))) continue;
                            prefixesToRemove.add(prefix);
                        }
                        for (int y = 0; y < prefixesToRemove.size(); ++y) {
                            childToClean.removeNamespaceDeclaration((String)prefixesToRemove.get(y));
                        }
                        found = true;
                    }
                    continue block5;
                }
                case 2: {
                    continue block5;
                }
            }
        }
    }

    private class WSSReference {
        private String reference;
        private int type;
        private SOAPElement element;
        public static final int TYPE_ENCRYPT_CONTENT = 1;
        public static final int TYPE_ENCRYPT_ELEMENT = 2;
        public static final int TYPE_SIGNATURE = 3;

        public WSSReference(SOAPElement element, int type, String reference) {
            this.element = element;
            this.reference = reference;
            this.type = type;
        }

        public String getReference() {
            return this.reference;
        }

        public int getType() {
            return this.type;
        }

        public SOAPElement getElement() {
            return this.element;
        }
    }
}

