/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.registry;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.wsdl.Definition;
import org.apache.jcs.JCS;
import org.apache.jcs.access.exception.CacheException;
import org.apache.jcs.engine.behavior.ICompositeCacheAttributes;
import org.apache.jcs.engine.behavior.IElementAttributes;
import org.apache.log4j.Logger;
import org.openspcoop.dao.commons.IDSoggetto;
import org.openspcoop.dao.config.AccessoRegistro;
import org.openspcoop.dao.config.AccessoRegistroCache;
import org.openspcoop.dao.config.AccessoRegistroRegistro;
import org.openspcoop.dao.registry.AccordoCooperazione;
import org.openspcoop.dao.registry.AccordoServizio;
import org.openspcoop.dao.registry.Fruitore;
import org.openspcoop.dao.registry.PortaDominio;
import org.openspcoop.dao.registry.ServizioSpcoop;
import org.openspcoop.dao.registry.SoggettoSpcoop;
import org.openspcoop.dao.registry.driver.DriverRegistroServiziDB;
import org.openspcoop.dao.registry.driver.DriverRegistroServiziException;
import org.openspcoop.dao.registry.driver.DriverRegistroServiziNotFound;
import org.openspcoop.dao.registry.driver.DriverRegistroServiziUDDI;
import org.openspcoop.dao.registry.driver.DriverRegistroServiziWEB;
import org.openspcoop.dao.registry.driver.DriverRegistroServiziWS;
import org.openspcoop.dao.registry.driver.DriverRegistroServiziXML;
import org.openspcoop.dao.registry.driver.IDAccordo;
import org.openspcoop.dao.registry.driver.IDServizio;
import org.openspcoop.dao.registry.driver.IDriverRegistroServiziGet;
import org.openspcoop.dao.registry.driver.StatiAccordo;
import org.openspcoop.dao.registry.wsdl.AccordoServizioWrapper;
import org.openspcoop.dao.registry.wsdl.AccordoServizioWrapperUtilities;
import org.openspcoop.utils.CacheResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegistroServizi {
    private JCS cache = null;
    private Hashtable<String, IDriverRegistroServiziGet> driverRegistroServizi;
    private Vector<DriverRegistroServiziXML> registriXML;
    private Logger log = null;
    private boolean raggiungibilitaTotale = false;
    private boolean readObjectStatoBozza = false;

    public boolean isReadObjectStatoBozza() {
        return this.readObjectStatoBozza;
    }

    public void resetCache() throws DriverRegistroServiziException {
        if (this.cache != null) {
            try {
                this.cache.clear();
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void abilitaCache() throws DriverRegistroServiziException {
        if (this.cache != null) {
            throw new DriverRegistroServiziException("Cache gia' abilitata");
        }
        try {
            this.cache = JCS.getInstance((String)"registroServizi");
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(e.getMessage(), (Throwable)e);
        }
    }

    public void abilitaCache(long dimensioneCache, boolean algoritmoCacheLRU, long itemIdleTime, long itemLifeSecond) throws DriverRegistroServiziException {
        if (this.cache != null) {
            throw new DriverRegistroServiziException("Cache gia' abilitata");
        }
        try {
            AccessoRegistroCache configurazioneCache = new AccessoRegistroCache();
            configurazioneCache.setDimensione(dimensioneCache + "");
            if (algoritmoCacheLRU) {
                configurazioneCache.setAlgoritmo("lru");
            } else {
                configurazioneCache.setAlgoritmo("mru");
            }
            configurazioneCache.setItemIdleTime(itemIdleTime + "");
            configurazioneCache.setItemLifeSecond(itemLifeSecond + "");
            this.initCacheRegistriServizi(configurazioneCache, null);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(e.getMessage(), (Throwable)e);
        }
    }

    public void disabilitaCache() throws DriverRegistroServiziException {
        if (this.cache == null) {
            throw new DriverRegistroServiziException("Cache gia' disabilitata");
        }
        try {
            this.cache.clear();
            this.cache = null;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(e.getMessage(), (Throwable)e);
        }
    }

    public RegistroServizi(AccessoRegistro accessoRegistro, Logger alog, Logger alogConsole, boolean raggiungibilitaTotale, boolean readObjectStatoBozza) throws DriverRegistroServiziException {
        try {
            this.driverRegistroServizi = new Hashtable();
            this.registriXML = new Vector();
            this.log = alog != null ? alog : Logger.getLogger((String)"Registro dei Servizi di OpenSPCoop");
            this.raggiungibilitaTotale = raggiungibilitaTotale;
            this.readObjectStatoBozza = readObjectStatoBozza;
            for (int i = 0; i < accessoRegistro.sizeRegistroList(); ++i) {
                DriverRegistroServiziXML driver = null;
                AccessoRegistroRegistro registro = accessoRegistro.getRegistro(i);
                String nomeRegistro = registro.getNome();
                if (nomeRegistro == null) {
                    nomeRegistro = "Registro" + i + registro.getTipo();
                }
                String path = registro.getLocation();
                if ("xml".equalsIgnoreCase(registro.getTipo()) && path.indexOf("${") != -1) {
                    while (path.indexOf("${") != -1) {
                        int indexStart = path.indexOf("${");
                        int indexEnd = path.indexOf("}");
                        if (indexEnd == -1) {
                            this.log.error((Object)("errore durante l'interpretazione del path [" + path + "]: ${ utilizzato senza la rispettiva chiusura }"));
                            continue;
                        }
                        String nameSystemProperty = path.substring(indexStart + "${".length(), indexEnd);
                        String valueSystemProperty = System.getProperty(nameSystemProperty);
                        if (valueSystemProperty == null) {
                            this.log.error((Object)("errore durante l'interpretazione del path [" + path + "]: variabile di sistema ${" + nameSystemProperty + "} non esistente"));
                            continue;
                        }
                        path = path.replace("${" + nameSystemProperty + "}", valueSystemProperty);
                    }
                }
                String msg = "carico registro " + nomeRegistro + " di tipo[" + registro.getTipo() + "]   location[" + path + "]";
                this.log.info((Object)msg);
                if (alogConsole != null) {
                    alogConsole.info((Object)msg);
                }
                if ("xml".equalsIgnoreCase(registro.getTipo())) {
                    driver = new DriverRegistroServiziXML(path, this.log);
                    if (driver.create) {
                        this.driverRegistroServizi.put(nomeRegistro, (IDriverRegistroServiziGet)driver);
                        this.registriXML.add(driver);
                        continue;
                    }
                    msg = "Riscontrato errore durante l'inizializzazione del registro di tipo " + registro.getTipo() + " con location: " + registro.getLocation();
                    this.log.error((Object)msg);
                    if (alogConsole == null) continue;
                    alogConsole.info((Object)msg);
                    continue;
                }
                if ("uddi".equalsIgnoreCase(registro.getTipo())) {
                    driver = registro.getUser() != null && registro.getPassword() != null ? new DriverRegistroServiziUDDI(path, registro.getUser(), registro.getPassword(), this.log) : new DriverRegistroServiziUDDI(registro.getLocation(), this.log);
                    if (((DriverRegistroServiziUDDI)driver).create) {
                        this.driverRegistroServizi.put(nomeRegistro, (IDriverRegistroServiziGet)driver);
                        continue;
                    }
                    msg = "Riscontrato errore durante l'inizializzazione del registro di tipo " + registro.getTipo() + " con location: " + registro.getLocation();
                    this.log.error((Object)msg);
                    if (alogConsole == null) continue;
                    alogConsole.info((Object)msg);
                    continue;
                }
                if ("web".equalsIgnoreCase(registro.getTipo())) {
                    driver = new DriverRegistroServiziWEB(path, this.log);
                    if (((DriverRegistroServiziWEB)driver).create) {
                        this.driverRegistroServizi.put(nomeRegistro, (IDriverRegistroServiziGet)driver);
                        continue;
                    }
                    msg = "Riscontrato errore durante l'inizializzazione del registro di tipo " + registro.getTipo() + " con location: " + registro.getLocation();
                    this.log.error((Object)msg);
                    if (alogConsole == null) continue;
                    alogConsole.info((Object)msg);
                    continue;
                }
                if ("db".equalsIgnoreCase(registro.getTipo())) {
                    driver = new DriverRegistroServiziDB(path, null, this.log, registro.getTipoDatabase());
                    if (((DriverRegistroServiziDB)driver).create) {
                        this.driverRegistroServizi.put(nomeRegistro, (IDriverRegistroServiziGet)driver);
                        continue;
                    }
                    msg = "Riscontrato errore durante l'inizializzazione del registro di tipo " + registro.getTipo() + " con location: " + registro.getLocation();
                    this.log.error((Object)msg);
                    if (alogConsole == null) continue;
                    alogConsole.info((Object)msg);
                    continue;
                }
                if ("ws".equalsIgnoreCase(registro.getTipo())) {
                    driver = registro.getUser() != null && registro.getPassword() != null ? new DriverRegistroServiziWS(path, registro.getUser(), registro.getPassword(), this.log) : new DriverRegistroServiziWS(registro.getLocation(), this.log);
                    if (((DriverRegistroServiziWS)driver).create) {
                        this.driverRegistroServizi.put(nomeRegistro, (IDriverRegistroServiziGet)driver);
                        continue;
                    }
                    msg = "Riscontrato errore durante l'inizializzazione del registro di tipo " + registro.getTipo() + " con location: " + registro.getLocation();
                    this.log.error((Object)msg);
                    if (alogConsole == null) continue;
                    alogConsole.info((Object)msg);
                    continue;
                }
                msg = "Riscontrato errore durante l'inizializzazione del registro di tipo sconosciuto " + registro.getTipo() + " con location: " + registro.getLocation();
                this.log.error((Object)msg);
                if (alogConsole == null) continue;
                alogConsole.info((Object)msg);
            }
            if (accessoRegistro.getCache() != null) {
                this.initCacheRegistriServizi(accessoRegistro.getCache(), alogConsole);
            }
        }
        catch (Exception e) {
            String msg = "Riscontrato errore durante l'inizializzazione del registro: " + e.getMessage();
            this.log.error((Object)msg);
            if (alogConsole != null) {
                alogConsole.info((Object)msg);
            }
            throw new DriverRegistroServiziException("Riscontrato errore durante l'inizializzazione del registro: " + e.getMessage());
        }
        if (this.driverRegistroServizi.size() == 0) {
            throw new DriverRegistroServiziException("Non e' stato possibile inizializzare nessuna sorgente di lettura per un Registro dei Servizi");
        }
    }

    private void initCacheRegistriServizi(AccessoRegistroCache configurazioneCache, Logger alogConsole) throws Exception {
        String msg;
        String msg2;
        this.cache = JCS.getInstance((String)"registroServizi");
        if (configurazioneCache.getDimensione() != null || configurazioneCache.getAlgoritmo() != null) {
            ICompositeCacheAttributes cacheAttr;
            block18: {
                cacheAttr = this.cache.getCacheAttributes();
                if (configurazioneCache.getDimensione() != null) {
                    int dimensione = -1;
                    try {
                        dimensione = Integer.parseInt(configurazioneCache.getDimensione());
                        msg2 = "Dimensione della cache (RegistroServizi) impostata al valore: " + dimensione;
                        this.log.info((Object)msg2);
                        if (alogConsole != null) {
                            alogConsole.info((Object)msg2);
                        }
                        cacheAttr.setMaxObjects(dimensione);
                    }
                    catch (Exception error) {
                        msg = "Parametro errato per la dimensione della cache (RegistroServizi): " + error.getMessage();
                        this.log.error((Object)msg);
                        if (alogConsole == null) break block18;
                        alogConsole.info((Object)msg);
                    }
                }
            }
            if (configurazioneCache.getAlgoritmo() != null) {
                String msg3 = "Algoritmo di cache (RegistroServizi) impostato al valore: " + configurazioneCache.getAlgoritmo();
                this.log.info((Object)msg3);
                if (alogConsole != null) {
                    alogConsole.info((Object)msg3);
                }
                if ("mru".equalsIgnoreCase(configurazioneCache.getAlgoritmo())) {
                    cacheAttr.setCacheName("org.apache.jcs.engine.memory.mru.MRUMemoryCache");
                } else {
                    cacheAttr.setCacheName("org.apache.jcs.engine.memory.lru.LRUMemoryCache");
                }
            }
            this.cache.setCacheAttributes(cacheAttr);
        }
        if (configurazioneCache.getItemIdleTime() != null || configurazioneCache.getItemLifeSecond() != null) {
            IElementAttributes elemAttr;
            block20: {
                block19: {
                    elemAttr = this.cache.getDefaultElementAttributes();
                    if (configurazioneCache.getItemIdleTime() != null) {
                        int itemIdleTime = -1;
                        try {
                            itemIdleTime = Integer.parseInt(configurazioneCache.getItemIdleTime());
                            msg2 = "Attributo 'IdleTime' (RegistroServizi) impostato al valore: " + itemIdleTime;
                            this.log.info((Object)msg2);
                            if (alogConsole != null) {
                                alogConsole.info((Object)msg2);
                            }
                            elemAttr.setIdleTime((long)itemIdleTime);
                        }
                        catch (Exception error) {
                            msg = "Parametro errato per l'attributo 'IdleTime' (RegistroServizi): " + error.getMessage();
                            this.log.error((Object)msg);
                            if (alogConsole == null) break block19;
                            alogConsole.info((Object)msg);
                        }
                    }
                }
                if (configurazioneCache.getItemLifeSecond() != null) {
                    int itemLifeSecond = -1;
                    try {
                        itemLifeSecond = Integer.parseInt(configurazioneCache.getItemLifeSecond());
                        msg2 = "Attributo 'MaxLifeSecond' (RegistroServizi) impostato al valore: " + itemLifeSecond;
                        this.log.info((Object)msg2);
                        if (alogConsole != null) {
                            alogConsole.info((Object)msg2);
                        }
                        elemAttr.setMaxLifeSeconds((long)itemLifeSecond);
                    }
                    catch (Exception error) {
                        msg = "Parametro errato per l'attributo 'MaxLifeSecond' (RegistroServizi): " + error.getMessage();
                        this.log.error((Object)msg);
                        if (alogConsole == null) break block20;
                        alogConsole.info((Object)msg);
                    }
                }
            }
            this.cache.setDefaultElementAttributes(elemAttr);
        }
    }

    protected Hashtable<String, IDriverRegistroServiziGet> getDriverRegistroServizi() {
        return this.driverRegistroServizi;
    }

    public synchronized Object getObjectCache(String keyCache, String methodName, String nomeRegistro, Object ... arguments) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        DriverRegistroServiziNotFound dNotFound = null;
        Object obj = null;
        try {
            CacheResponse response;
            if (keyCache == null) {
                throw new DriverRegistroServiziException("[" + methodName + "]: KeyCache non definita");
            }
            if (this.cache != null && (response = (CacheResponse)this.cache.get((Object)keyCache)) != null) {
                if (response.getObject() != null) {
                    this.log.debug((Object)("Oggetto (tipo:" + response.getObject().getClass().getName() + ") con chiave [" + keyCache + "] (methodo:" + methodName + ") nel registro[" + nomeRegistro + "] in cache."));
                    return response.getObject();
                }
                if (response.getException() != null) {
                    this.log.debug((Object)("Eccezione (tipo:" + response.getException().getClass().getName() + ") con chiave [" + keyCache + "] (methodo:" + methodName + ") nel registro[" + nomeRegistro + "] in cache."));
                    throw (Exception)response.getException();
                }
                this.log.error((Object)"In cache non e' presente ne un oggetto ne un'eccezione.");
            }
            this.log.debug((Object)("oggetto con chiave [" + keyCache + "] (methodo:" + methodName + ") nel registro[" + nomeRegistro + "] non in cache, ricerco nel registro..."));
            try {
                obj = this.getObject(methodName, nomeRegistro, arguments);
            }
            catch (DriverRegistroServiziNotFound e) {
                dNotFound = e;
            }
            if (this.cache != null) {
                if (dNotFound != null) {
                    this.log.info((Object)("Aggiungo eccezione [" + keyCache + "] in cache"));
                } else if (obj != null) {
                    this.log.info((Object)("Aggiungo oggetto [" + keyCache + "] in cache"));
                } else {
                    throw new Exception("Metodo (" + methodName + ") nel registro[" + nomeRegistro + "] ha ritornato un valore null");
                }
                try {
                    CacheResponse responseCache = new CacheResponse();
                    if (dNotFound != null) {
                        responseCache.setException((Serializable)((Object)dNotFound));
                    } else {
                        responseCache.setObject((Serializable)obj);
                    }
                    this.cache.put((Object)keyCache, (Object)responseCache);
                }
                catch (CacheException e) {
                    this.log.error((Object)("Errore durante l'inserimento in cache [" + keyCache + "]: " + e.getMessage()));
                }
            }
        }
        catch (DriverRegistroServiziException e) {
            throw e;
        }
        catch (DriverRegistroServiziNotFound e) {
            throw e;
        }
        catch (Exception e) {
            if (DriverRegistroServiziNotFound.class.getName().equals(e.getClass().getName())) {
                throw (DriverRegistroServiziNotFound)((Object)e);
            }
            throw new DriverRegistroServiziException("RegistroServizi, Algoritmo di Cache fallito: " + e.getMessage(), (Throwable)e);
        }
        if (dNotFound != null) {
            throw dNotFound;
        }
        return obj;
    }

    public Object getObject(String methodName, String nomeRegistro, Object ... arguments) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        Object obj = null;
        if (nomeRegistro != null) {
            this.log.debug((Object)("Cerco nel registro [" + nomeRegistro + "]"));
            try {
                Method method;
                IDriverRegistroServiziGet driver = this.driverRegistroServizi.get(nomeRegistro);
                this.log.debug((Object)("invocazione metodo [" + methodName + "]..."));
                if (arguments.length == 0) {
                    method = driver.getClass().getMethod(methodName, new Class[0]);
                    obj = method.invoke((Object)driver, new Object[0]);
                } else if (arguments.length == 1) {
                    method = driver.getClass().getMethod(methodName, arguments[0].getClass());
                    obj = method.invoke((Object)driver, arguments[0]);
                } else if (arguments.length == 2) {
                    method = driver.getClass().getMethod(methodName, arguments[0].getClass(), arguments[1].getClass());
                    obj = method.invoke((Object)driver, arguments[0], arguments[1]);
                } else {
                    throw new Exception("Troppi argomenti per gestire la chiamata del metodo");
                }
                if (!this.readObjectStatoBozza && driver instanceof DriverRegistroServiziDB) {
                    if (obj instanceof AccordoCooperazione) {
                        AccordoCooperazione ac = (AccordoCooperazione)obj;
                        if (StatiAccordo.bozza.equals((Object)ac.getStatoPackage())) {
                            obj = null;
                            throw new DriverRegistroServiziNotFound("non presente in uno stato operativo o finale");
                        }
                    } else if (obj instanceof AccordoServizio) {
                        AccordoServizio as = (AccordoServizio)obj;
                        if (StatiAccordo.bozza.equals((Object)as.getStatoPackage())) {
                            obj = null;
                            throw new DriverRegistroServiziNotFound("non presente in uno stato operativo o finale");
                        }
                    } else if (obj instanceof ServizioSpcoop) {
                        ServizioSpcoop s = (ServizioSpcoop)obj;
                        if (StatiAccordo.bozza.equals((Object)s.getStatoPackage())) {
                            obj = null;
                            throw new DriverRegistroServiziNotFound("non presente in uno stato operativo o finale");
                        }
                        Vector<Fruitore> fruitoriConStatoNonBozza = new Vector<Fruitore>();
                        while (s.sizeFruitoreList() > 0) {
                            Fruitore tmpF = s.removeFruitore(0);
                            if (StatiAccordo.bozza.equals((Object)tmpF.getStatoPackage())) continue;
                            fruitoriConStatoNonBozza.add(tmpF);
                        }
                        while (fruitoriConStatoNonBozza.size() > 0) {
                            s.addFruitore((Fruitore)fruitoriConStatoNonBozza.remove(0));
                        }
                    }
                }
            }
            catch (DriverRegistroServiziNotFound e) {
                this.log.debug((Object)("Ricerca nel registro non riuscita (metodo [" + methodName + "]): " + e.getMessage()));
                throw e;
            }
            catch (InvocationTargetException e) {
                if (e.getTargetException() != null) {
                    if (DriverRegistroServiziNotFound.class.getName().equals(e.getTargetException().getClass().getName())) {
                        this.log.debug((Object)("Ricerca nel registro [" + nomeRegistro + "] non riuscita [NotFound] (metodo [" + methodName + "]): " + e.getTargetException().getMessage()));
                        throw new DriverRegistroServiziNotFound(e.getTargetException().getMessage(), e.getTargetException());
                    }
                    if (DriverRegistroServiziException.class.getName().equals(e.getTargetException().getClass().getName())) {
                        this.log.debug((Object)("Ricerca nel registro [" + nomeRegistro + "] non riuscita [DriverException] (metodo [" + methodName + "]): " + e.getTargetException().getMessage()), e.getTargetException());
                        throw new DriverRegistroServiziException(e.getTargetException().getMessage(), e.getTargetException());
                    }
                    this.log.debug((Object)("Ricerca nel registro [" + nomeRegistro + "] non riuscita [InvTargetExcp.getTarget] (metodo [" + methodName + "]), " + e.getTargetException().getMessage()), e.getTargetException());
                    throw new DriverRegistroServiziException(e.getTargetException().getMessage(), e.getTargetException());
                }
                this.log.debug((Object)("Ricerca nel registro [" + nomeRegistro + "] non riuscita [InvTargetExcp] (metodo [" + methodName + "]), " + e.getMessage()), (Throwable)e);
                throw new DriverRegistroServiziException(e.getMessage(), (Throwable)e);
            }
            catch (Exception e) {
                this.log.debug((Object)("Ricerca nel registro [" + nomeRegistro + "] non riuscita, " + e.getMessage()), (Throwable)e);
                throw new DriverRegistroServiziException(e.getMessage(), (Throwable)e);
            }
            this.log.debug((Object)("invocazione metodo [" + methodName + "] completata."));
            return obj;
        }
        this.log.debug((Object)"Cerco nella mia gerarchia di registri");
        StringBuffer notFoundProblem = new StringBuffer();
        StringBuffer exceptionProblem = new StringBuffer();
        boolean find = false;
        Enumeration<String> en = this.driverRegistroServizi.keys();
        while (en.hasMoreElements()) {
            String nomeRegInLista = en.nextElement();
            this.log.debug((Object)("Cerco nel registro con nome[" + nomeRegInLista + "]"));
            try {
                Method method;
                IDriverRegistroServiziGet driver = this.driverRegistroServizi.get(nomeRegInLista);
                this.log.debug((Object)("invocazione metodo [" + methodName + "] nel registro[" + nomeRegInLista + "]..."));
                if (arguments.length == 0) {
                    method = driver.getClass().getMethod(methodName, new Class[0]);
                    obj = method.invoke((Object)driver, new Object[0]);
                    find = true;
                } else if (arguments.length == 1) {
                    method = driver.getClass().getMethod(methodName, arguments[0].getClass());
                    obj = method.invoke((Object)driver, arguments[0]);
                    find = true;
                } else if (arguments.length == 2) {
                    method = driver.getClass().getMethod(methodName, arguments[0].getClass(), arguments[1].getClass());
                    obj = method.invoke((Object)driver, arguments[0], arguments[1]);
                    find = true;
                } else {
                    throw new Exception("Troppi argomenti per gestire la chiamata del metodo");
                }
                if (!this.readObjectStatoBozza && driver instanceof DriverRegistroServiziDB) {
                    ServizioSpcoop s;
                    if (obj instanceof AccordoCooperazione) {
                        AccordoCooperazione ac = (AccordoCooperazione)obj;
                        if (StatiAccordo.bozza.equals((Object)ac.getStatoPackage())) {
                            obj = null;
                            find = false;
                            throw new DriverRegistroServiziNotFound("non presente in uno stato operativo o finale");
                        }
                    } else if (obj instanceof AccordoServizio) {
                        AccordoServizio as = (AccordoServizio)obj;
                        if (StatiAccordo.bozza.equals((Object)as.getStatoPackage())) {
                            obj = null;
                            find = false;
                            throw new DriverRegistroServiziNotFound("non presente in uno stato operativo o finale");
                        }
                    } else if (obj instanceof ServizioSpcoop && StatiAccordo.bozza.equals((Object)(s = (ServizioSpcoop)obj).getStatoPackage())) {
                        obj = null;
                        find = false;
                        throw new DriverRegistroServiziNotFound("non presente in uno stato operativo o finale");
                    }
                }
            }
            catch (DriverRegistroServiziNotFound ed) {
                this.log.debug((Object)("Ricerca nel registro [" + nomeRegInLista + "] non riuscita (metodo [" + methodName + "]): " + ed.getMessage()));
                notFoundProblem.append("\nRegistro[" + nomeRegInLista + "], ricerca fallita: " + ed.getMessage());
            }
            catch (InvocationTargetException e) {
                if (e.getTargetException() != null) {
                    if (DriverRegistroServiziNotFound.class.getName().equals(e.getTargetException().getClass().getName())) {
                        this.log.debug((Object)("Ricerca nel registro [" + nomeRegInLista + "] non riuscita [NotFound] (metodo [" + methodName + "]): " + e.getTargetException().getMessage()));
                        notFoundProblem.append("\nRegistro[" + nomeRegInLista + "], ricerca fallita: " + e.getTargetException().getMessage());
                    } else if (DriverRegistroServiziException.class.getName().equals(e.getTargetException().getClass().getName())) {
                        this.log.debug((Object)("Ricerca nel registro [" + nomeRegInLista + "] non riuscita [DriverException] (metodo [" + methodName + "]): " + e.getTargetException().getMessage()), e.getTargetException());
                        if (this.raggiungibilitaTotale) {
                            throw new DriverRegistroServiziException(e.getTargetException().getMessage(), e.getTargetException());
                        }
                        exceptionProblem.append("\nRegistro[" + nomeRegInLista + "], accesso non riuscito: " + e.getTargetException().getMessage());
                    } else {
                        this.log.debug((Object)("Ricerca nel registro [" + nomeRegInLista + "] non riuscita [InvTargetExcp.getTarget] (metodo [" + methodName + "]), " + e.getTargetException().getMessage()), e.getTargetException());
                        if (this.raggiungibilitaTotale) {
                            throw new DriverRegistroServiziException(e.getTargetException().getMessage(), e.getTargetException());
                        }
                        exceptionProblem.append("\nRegistro[" + nomeRegInLista + "], accesso non riuscito: " + e.getTargetException().getMessage());
                    }
                } else {
                    this.log.debug((Object)("Ricerca nel registro [" + nomeRegInLista + "] non riuscita [InvTargetExcp] (metodo [" + methodName + "]), " + e.getMessage()), (Throwable)e);
                    if (this.raggiungibilitaTotale) {
                        throw new DriverRegistroServiziException(e.getMessage(), (Throwable)e);
                    }
                    exceptionProblem.append("\nRegistro[" + nomeRegInLista + "], accesso non riuscito: " + e.getMessage());
                }
            }
            catch (Exception e) {
                this.log.debug((Object)("Ricerca nel registro [" + nomeRegInLista + "] non riuscita, " + e.getMessage()), (Throwable)e);
                if (this.raggiungibilitaTotale) {
                    throw new DriverRegistroServiziException(e.getMessage(), (Throwable)e);
                }
                exceptionProblem.append("\nRegistro[" + nomeRegInLista + "], accesso non riuscito: " + e.getMessage());
            }
            if (!find) continue;
            break;
        }
        this.log.debug((Object)("invocazione metodo [" + methodName + "] completata."));
        if (find) {
            return obj;
        }
        if (exceptionProblem.length() > 0 && notFoundProblem.length() > 0) {
            throw new DriverRegistroServiziException("[" + methodName + "]:" + exceptionProblem.toString() + notFoundProblem.toString());
        }
        if (exceptionProblem.length() > 0) {
            throw new DriverRegistroServiziException("[" + methodName + "]:" + exceptionProblem.toString());
        }
        if (notFoundProblem.length() > 0) {
            throw new DriverRegistroServiziNotFound("[" + methodName + "]:" + notFoundProblem.toString());
        }
        throw new DriverRegistroServiziException("[" + methodName + "]: ricerca non riuscita in tutti i registri");
    }

    public AccordoServizio getAccordoServizio(String nomeRegistro, IDAccordo idAccordo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        CacheResponse response;
        if (idAccordo == null) {
            throw new DriverRegistroServiziException("[getAccordoServizio]: Parametro non definito");
        }
        if (idAccordo.getNome() == null) {
            throw new DriverRegistroServiziException("[getAccordoServizio]: Nome accordo di servizio non definito");
        }
        String uriAccordoServizio = IDAccordo.getUriFromIDAccordo((IDAccordo)idAccordo);
        String key = null;
        if (this.cache != null && (response = (CacheResponse)this.cache.get((Object)(key = "getAccordoServizio_" + uriAccordoServizio))) != null) {
            if (response.getException() != null) {
                if (DriverRegistroServiziNotFound.class.getName().equals(response.getException().getClass().getName())) {
                    throw (DriverRegistroServiziNotFound)((Object)response.getException());
                }
                throw (DriverRegistroServiziException)((Object)response.getException());
            }
            return (AccordoServizio)response.getObject();
        }
        AccordoServizio as = null;
        as = this.cache != null ? (AccordoServizio)this.getObjectCache(key, "getAccordoServizio", nomeRegistro, idAccordo) : (AccordoServizio)this.getObject("getAccordoServizio", nomeRegistro, idAccordo);
        if (as != null) {
            return as;
        }
        throw new DriverRegistroServiziNotFound("[getAccordoServizio] Accordo di Servizio [" + idAccordo + "] non Trovato");
    }

    public PortaDominio getPortaDominio(String nomeRegistro, String nomePdD) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        CacheResponse response;
        if (nomePdD == null) {
            throw new DriverRegistroServiziException("[getPortaDominio]: Parametro non definito");
        }
        String key = null;
        if (this.cache != null && (response = (CacheResponse)this.cache.get((Object)(key = "getPortaDominio" + nomePdD))) != null) {
            if (response.getException() != null) {
                if (DriverRegistroServiziNotFound.class.getName().equals(response.getException().getClass().getName())) {
                    throw (DriverRegistroServiziNotFound)((Object)response.getException());
                }
                throw (DriverRegistroServiziException)((Object)response.getException());
            }
            return (PortaDominio)response.getObject();
        }
        PortaDominio pd = null;
        pd = this.cache != null ? (PortaDominio)this.getObjectCache(key, "getPortaDominio", nomeRegistro, nomePdD) : (PortaDominio)this.getObject("getPortaDominio", nomeRegistro, nomePdD);
        if (pd != null) {
            return pd;
        }
        throw new DriverRegistroServiziNotFound("[getPortaDominio] Porta di dominio [" + nomePdD + "] non Trovata");
    }

    public SoggettoSpcoop getSoggetto(String nomeRegistro, IDSoggetto idSoggetto) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        CacheResponse response;
        if (idSoggetto == null) {
            throw new DriverRegistroServiziException("[getSoggetto] Parametro Non Valido");
        }
        String tipoSP = idSoggetto.getTipo();
        String codiceSP = idSoggetto.getNome();
        if (tipoSP == null || codiceSP == null) {
            throw new DriverRegistroServiziException("[getSoggetto] Parametri Non Validi");
        }
        String key = null;
        if (this.cache != null && (response = (CacheResponse)this.cache.get((Object)(key = "getSoggetto_" + tipoSP + "/" + codiceSP))) != null) {
            if (response.getException() != null) {
                if (DriverRegistroServiziNotFound.class.getName().equals(response.getException().getClass().getName())) {
                    throw (DriverRegistroServiziNotFound)((Object)response.getException());
                }
                throw (DriverRegistroServiziException)((Object)response.getException());
            }
            return (SoggettoSpcoop)response.getObject();
        }
        SoggettoSpcoop soggetto = null;
        soggetto = this.cache != null ? (SoggettoSpcoop)this.getObjectCache(key, "getSoggettoRegistro", nomeRegistro, idSoggetto) : (SoggettoSpcoop)this.getObject("getSoggettoRegistro", nomeRegistro, idSoggetto);
        if (soggetto != null) {
            return soggetto;
        }
        throw new DriverRegistroServiziNotFound("[getSoggetto] Soggetto non Trovato");
    }

    public ServizioSpcoop getServizio(String nomeRegistro, IDServizio idService) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (idService == null) {
            throw new DriverRegistroServiziException("[getServizio] Parametro Non Valido");
        }
        String servizio = idService.getServizio();
        String tipoServizio = idService.getTipoServizio();
        String azione = idService.getAzione();
        if (servizio == null || tipoServizio == null) {
            throw new DriverRegistroServiziException("[getServizio] Parametri (Servizio) Non Validi");
        }
        String tipoSogg = idService.getSoggettoErogatore().getTipo();
        String nomeSogg = idService.getSoggettoErogatore().getNome();
        if (tipoSogg == null || nomeSogg == null) {
            throw new DriverRegistroServiziException("[getServizio] Parametri (Soggetto) Non Validi");
        }
        String key = null;
        if (this.cache != null) {
            CacheResponse response;
            key = "getServizio_" + tipoSogg + "/" + nomeSogg + "_" + tipoServizio + "/" + servizio;
            if (azione != null) {
                key = key + "_" + azione;
            }
            if ((response = (CacheResponse)this.cache.get((Object)key)) != null) {
                if (response.getException() != null) {
                    if (DriverRegistroServiziNotFound.class.getName().equals(response.getException().getClass().getName())) {
                        throw (DriverRegistroServiziNotFound)((Object)response.getException());
                    }
                    throw (DriverRegistroServiziException)((Object)response.getException());
                }
                return (ServizioSpcoop)response.getObject();
            }
        }
        ServizioSpcoop serv = null;
        serv = this.cache != null ? (ServizioSpcoop)this.getObjectCache(key, "getServizio", nomeRegistro, idService) : (ServizioSpcoop)this.getObject("getServizio", nomeRegistro, idService);
        if (serv != null) {
            return serv;
        }
        throw new DriverRegistroServiziNotFound("[getServizio] Servizio non Trovato");
    }

    public ServizioSpcoop getServizioCorrelato(String nomeRegistro, IDServizio idService) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (idService == null) {
            throw new DriverRegistroServiziException("[getServizioCorrelato] Parametro Non Valido");
        }
        String servizio = idService.getServizio();
        String tipoServizio = idService.getTipoServizio();
        String azione = idService.getAzione();
        if (servizio == null || tipoServizio == null) {
            throw new DriverRegistroServiziException("[getServizioCorrelato] Parametri (Servizio) Non Validi");
        }
        String tipoSogg = idService.getSoggettoErogatore().getTipo();
        String nomeSogg = idService.getSoggettoErogatore().getNome();
        if (tipoSogg == null || nomeSogg == null) {
            throw new DriverRegistroServiziException("[getServizioCorrelato] Parametri (Soggetto) Non Validi");
        }
        String key = null;
        if (this.cache != null) {
            CacheResponse response;
            key = "getServizioCorrelato_" + tipoSogg + "/" + nomeSogg + "_" + tipoServizio + "/" + servizio;
            if (azione != null) {
                key = key + "_" + azione;
            }
            if ((response = (CacheResponse)this.cache.get((Object)key)) != null) {
                if (response.getException() != null) {
                    if (DriverRegistroServiziNotFound.class.getName().equals(response.getException().getClass().getName())) {
                        throw (DriverRegistroServiziNotFound)((Object)response.getException());
                    }
                    throw (DriverRegistroServiziException)((Object)response.getException());
                }
                return (ServizioSpcoop)response.getObject();
            }
        }
        ServizioSpcoop servCorrelato = null;
        servCorrelato = this.cache != null ? (ServizioSpcoop)this.getObjectCache(key, "getServizioCorrelato", nomeRegistro, idService) : (ServizioSpcoop)this.getObject("getServizioCorrelato", nomeRegistro, idService);
        if (servCorrelato != null) {
            return servCorrelato;
        }
        throw new DriverRegistroServiziNotFound("[getServizioCorrelato] ServizioCorrelato non Trovato");
    }

    public ServizioSpcoop getServizioCorrelato(String nomeRegistro, IDSoggetto idSoggetto, IDAccordo idAccordo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        CacheResponse response;
        if (idSoggetto == null) {
            throw new DriverRegistroServiziException("[getServizioCorrelato] Parametro Non Valido");
        }
        String nome = idSoggetto.getNome();
        String tipo = idSoggetto.getTipo();
        if (tipo == null || nome == null || idAccordo == null) {
            throw new DriverRegistroServiziException("[getServizioCorrelato] Parametri Non Validi");
        }
        String uriAccordo = IDAccordo.getUriFromIDAccordo((IDAccordo)idAccordo);
        String key = null;
        if (this.cache != null && (response = (CacheResponse)this.cache.get((Object)(key = "getServizioCorrelato(RicercaPerAccordo)_" + tipo + "/" + nome + "_" + uriAccordo))) != null) {
            if (response.getException() != null) {
                if (DriverRegistroServiziNotFound.class.getName().equals(response.getException().getClass().getName())) {
                    throw (DriverRegistroServiziNotFound)((Object)response.getException());
                }
                throw (DriverRegistroServiziException)((Object)response.getException());
            }
            return (ServizioSpcoop)response.getObject();
        }
        ServizioSpcoop servCorrelato = null;
        servCorrelato = this.cache != null ? (ServizioSpcoop)this.getObjectCache(key, "getServizioCorrelato", nomeRegistro, idSoggetto, idAccordo) : (ServizioSpcoop)this.getObject("getServizioCorrelato", nomeRegistro, idSoggetto, idAccordo);
        if (servCorrelato != null) {
            return servCorrelato;
        }
        throw new DriverRegistroServiziNotFound("[getServizioCorrelato] ServizioCorrelato non Trovato");
    }

    public org.openspcoop.dao.registry.RegistroServizi[] getRegistriServiziXML() {
        if (this.registriXML.size() > 0) {
            org.openspcoop.dao.registry.RegistroServizi[] r = new org.openspcoop.dao.registry.RegistroServizi[this.registriXML.size()];
            for (int i = 0; i < this.registriXML.size(); ++i) {
                r[i] = this.registriXML.get(i).getRegistroXML();
            }
            return r;
        }
        return null;
    }

    public AccordoServizioWrapper getWsdlAccordoServizio(String nomeRegistro, IDServizio idService, boolean readWSDLAccordoServizio) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        CacheResponse response;
        if (idService == null) {
            throw new DriverRegistroServiziException("[getWsdlAccordoServizio] Parametro Non Valido");
        }
        String servizio = idService.getServizio();
        String tipoServizio = idService.getTipoServizio();
        if (servizio == null || tipoServizio == null) {
            throw new DriverRegistroServiziException("[getWsdlAccordoServizio] Parametri (Servizio) Non Validi");
        }
        String tipoSogg = idService.getSoggettoErogatore().getTipo();
        String nomeSogg = idService.getSoggettoErogatore().getNome();
        if (tipoSogg == null || nomeSogg == null) {
            throw new DriverRegistroServiziException("[getWsdlAccordoServizio] Parametri (Soggetto) Non Validi");
        }
        String key = null;
        if (this.cache != null && (response = (CacheResponse)this.cache.get((Object)(key = "getWsdlAccordoServizio_" + tipoSogg + "/" + nomeSogg + "_" + tipoServizio + "/" + servizio))) != null) {
            if (response.getException() != null) {
                if (DriverRegistroServiziNotFound.class.getName().equals(response.getException().getClass().getName())) {
                    throw (DriverRegistroServiziNotFound)((Object)response.getException());
                }
                throw (DriverRegistroServiziException)((Object)response.getException());
            }
            return (AccordoServizioWrapper)response.getObject();
        }
        AccordoServizioWrapper wsdlAS = null;
        wsdlAS = this.cache != null ? this.getAccordoServizioCache(key, idService, readWSDLAccordoServizio, nomeRegistro) : this.getAccordoServizioEngine(idService, readWSDLAccordoServizio, nomeRegistro);
        if (wsdlAS != null) {
            return wsdlAS;
        }
        throw new DriverRegistroServiziNotFound("[getWsdlAccordoServizio] WSDLAccordoServizio non Trovato");
    }

    private synchronized AccordoServizioWrapper getAccordoServizioCache(String keyCache, IDServizio idService, boolean readWSDLAccordoServizio, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        DriverRegistroServiziNotFound dNotFound = null;
        AccordoServizioWrapper obj = null;
        try {
            CacheResponse response;
            if (keyCache == null) {
                throw new DriverRegistroServiziException("[getWSDLAccordoServizio]: KeyCache non definita");
            }
            if (this.cache != null && (response = (CacheResponse)this.cache.get((Object)keyCache)) != null) {
                if (response.getObject() != null) {
                    this.log.debug((Object)("Oggetto (tipo:" + response.getObject().getClass().getName() + ") con chiave [" + keyCache + "] (methodo:getWSDLAccordoServizio) nel registro[" + nomeRegistro + "] in cache."));
                    return (AccordoServizioWrapper)response.getObject();
                }
                if (response.getException() != null) {
                    this.log.debug((Object)("Eccezione (tipo:" + response.getException().getClass().getName() + ") con chiave [" + keyCache + "] (methodo:getWSDLAccordoServizio) nel registro[" + nomeRegistro + "] in cache."));
                    throw (Exception)response.getException();
                }
                this.log.error((Object)"In cache non e' presente ne un oggetto ne un'eccezione.");
            }
            this.log.debug((Object)("oggetto con chiave [" + keyCache + "] (methodo:WSDLAccordoServizio) nel registro[" + nomeRegistro + "] non in cache, ricerco nel registro..."));
            try {
                obj = this.getAccordoServizioEngine(idService, readWSDLAccordoServizio, nomeRegistro);
            }
            catch (DriverRegistroServiziNotFound e) {
                dNotFound = e;
            }
            if (this.cache != null) {
                if (dNotFound != null) {
                    this.log.info((Object)("Aggiungo eccezione [" + keyCache + "] in cache"));
                } else if (obj != null) {
                    this.log.info((Object)("Aggiungo oggetto [" + keyCache + "] in cache"));
                } else {
                    throw new Exception("Metodo (WSDLAccordoServizio) nel registro[" + nomeRegistro + "] ha ritornato un valore null");
                }
                try {
                    CacheResponse responseCache = new CacheResponse();
                    if (dNotFound != null) {
                        responseCache.setException((Serializable)((Object)dNotFound));
                    } else {
                        responseCache.setObject((Serializable)obj);
                    }
                    this.cache.put((Object)keyCache, (Object)responseCache);
                }
                catch (CacheException e) {
                    this.log.error((Object)("Errore durante l'inserimento in cache [" + keyCache + "]: " + e.getMessage()));
                }
            }
        }
        catch (DriverRegistroServiziException e) {
            throw e;
        }
        catch (DriverRegistroServiziNotFound e) {
            throw e;
        }
        catch (Exception e) {
            if (DriverRegistroServiziNotFound.class.getName().equals(e.getClass().getName())) {
                throw (DriverRegistroServiziNotFound)((Object)e);
            }
            throw new DriverRegistroServiziException("RegistroServizi, Algoritmo di Cache fallito: " + e.getMessage(), (Throwable)e);
        }
        if (dNotFound != null) {
            throw dNotFound;
        }
        return obj;
    }

    private AccordoServizioWrapper getAccordoServizioEngine(IDServizio idService, boolean readWSDLAccordoServizio, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        IDAccordo idAccordo;
        ServizioSpcoop servizio = null;
        AccordoServizio as = null;
        boolean registroServiziDB = false;
        if (nomeRegistro != null) {
            this.log.debug((Object)("Cerco wsdl nel registro [" + nomeRegistro + "]"));
            try {
                IDriverRegistroServiziGet driver = this.driverRegistroServizi.get(nomeRegistro);
                this.log.debug((Object)"invocazione metodo getWSDLAccordoServizio (search servizio)...");
                try {
                    servizio = driver instanceof DriverRegistroServiziDB ? ((DriverRegistroServiziDB)driver).getServizio(idService, true) : driver.getServizio(idService);
                }
                catch (DriverRegistroServiziNotFound e) {
                    // empty catch block
                }
                if (servizio == null) {
                    this.log.debug((Object)"invocazione metodo getWSDLAccordoServizio (search servizio correlato)...");
                    try {
                        servizio = driver instanceof DriverRegistroServiziDB ? ((DriverRegistroServiziDB)driver).getServizioCorrelato(idService, true) : driver.getServizioCorrelato(idService);
                    }
                    catch (DriverRegistroServiziNotFound e) {
                        // empty catch block
                    }
                }
                if (servizio == null) {
                    throw new DriverRegistroServiziNotFound("Servizio [" + idService.getTipoServizio() + idService.getServizio() + "] non definito");
                }
                idAccordo = IDAccordo.getIDAccordoFromUri((String)servizio.getAccordoServizio());
                this.log.debug((Object)"invocazione metodo getWSDLAccordoServizio (search accordo)...");
                as = driver instanceof DriverRegistroServiziDB ? ((DriverRegistroServiziDB)driver).getAccordoServizio(idAccordo, true) : driver.getAccordoServizio(idAccordo);
                if (as == null) {
                    throw new DriverRegistroServiziNotFound("Accordo di servizio [" + idAccordo + "] associato al servizio [" + idService.getTipoServizio() + idService.getServizio() + "] non presente nel registro");
                }
                if (servizio.getPortType() != null && !"".equals(servizio.getPortType())) {
                    boolean findPortType = false;
                    for (int l = 0; l < as.sizePortTypeList(); ++l) {
                        if (!servizio.getPortType().equals(as.getPortType(l).getNome())) continue;
                        findPortType = true;
                        break;
                    }
                    if (!findPortType) {
                        throw new DriverRegistroServiziNotFound("PortType[" + servizio.getPortType() + "] associato al servizio [" + idService.getTipoServizio() + idService.getServizio() + "] non presente nell'Accordo di servizio [" + idAccordo + "]");
                    }
                }
                registroServiziDB = driver instanceof DriverRegistroServiziDB;
            }
            catch (DriverRegistroServiziNotFound e) {
                this.log.debug((Object)("Ricerca nel registro non riuscita (metodo getWSDLAccordoServizio): " + e.getMessage()));
                throw e;
            }
            catch (Exception e) {
                this.log.debug((Object)("Ricerca nel registro [" + nomeRegistro + "] non riuscita, " + e.getMessage()), (Throwable)e);
                throw new DriverRegistroServiziException(e.getMessage(), (Throwable)e);
            }
        }
        this.log.debug((Object)"Cerco nella mia gerarchia di registri");
        StringBuffer notFoundProblem = new StringBuffer();
        StringBuffer exceptionProblem = new StringBuffer();
        boolean find = false;
        Enumeration<String> en = this.driverRegistroServizi.keys();
        while (en.hasMoreElements()) {
            String nomeRegInLista = en.nextElement();
            this.log.debug((Object)("Cerco nel registro con nome[" + nomeRegInLista + "]"));
            try {
                IDriverRegistroServiziGet driver = this.driverRegistroServizi.get(nomeRegInLista);
                this.log.debug((Object)("invocazione metodo getWSDLAccordoServizio (search servizio) nel registro[" + nomeRegInLista + "]..."));
                try {
                    servizio = driver instanceof DriverRegistroServiziDB ? ((DriverRegistroServiziDB)driver).getServizio(idService, true) : driver.getServizio(idService);
                }
                catch (DriverRegistroServiziNotFound e) {
                    // empty catch block
                }
                if (servizio == null) {
                    this.log.debug((Object)("invocazione metodo getWSDLAccordoServizio (search servizio correlato) nel registro[" + nomeRegInLista + "]..."));
                    try {
                        servizio = driver instanceof DriverRegistroServiziDB ? ((DriverRegistroServiziDB)driver).getServizioCorrelato(idService, true) : driver.getServizioCorrelato(idService);
                    }
                    catch (DriverRegistroServiziNotFound e) {
                        // empty catch block
                    }
                }
                if (servizio == null) {
                    throw new DriverRegistroServiziNotFound("Servizio [" + idService.getTipoServizio() + idService.getServizio() + "] non definito");
                }
                IDAccordo idAccordo2 = IDAccordo.getIDAccordoFromUri((String)servizio.getAccordoServizio());
                this.log.debug((Object)("invocazione metodo getWSDLAccordoServizio (search accordo) nel registro[" + nomeRegInLista + "]..."));
                as = driver instanceof DriverRegistroServiziDB ? ((DriverRegistroServiziDB)driver).getAccordoServizio(idAccordo2, true) : driver.getAccordoServizio(idAccordo2);
                if (as == null) {
                    throw new DriverRegistroServiziNotFound("Accordo di servizio [" + idAccordo2 + "] associato al servizio [" + idService.getTipoServizio() + idService.getServizio() + "] non presente nel registro");
                }
                if (servizio.getPortType() != null && !"".equals(servizio.getPortType())) {
                    boolean findPortType = false;
                    for (int l = 0; l < as.sizePortTypeList(); ++l) {
                        if (!servizio.getPortType().equals(as.getPortType(l).getNome())) continue;
                        findPortType = true;
                        break;
                    }
                    if (!findPortType) {
                        throw new DriverRegistroServiziNotFound("PortType[" + servizio.getPortType() + "] associato al servizio [" + idService.getTipoServizio() + idService.getServizio() + "] non presente nell'Accordo di servizio [" + idAccordo2 + "]");
                    }
                }
                registroServiziDB = driver instanceof DriverRegistroServiziDB;
                find = true;
            }
            catch (DriverRegistroServiziNotFound ed) {
                this.log.debug((Object)("Ricerca nel registro [" + nomeRegInLista + "] non riuscita (metodo getWSDLAccordoServizio): " + ed.getMessage()));
                notFoundProblem.append("\nRegistro[" + nomeRegInLista + "], ricerca fallita: " + ed.getMessage());
            }
            catch (Exception e) {
                this.log.debug((Object)("Ricerca nel registro [" + nomeRegInLista + "] non riuscita, " + e.getMessage()), (Throwable)e);
                if (this.raggiungibilitaTotale) {
                    throw new DriverRegistroServiziException(e.getMessage(), (Throwable)e);
                }
                exceptionProblem.append("\nRegistro[" + nomeRegInLista + "], accesso non riuscito: " + e.getMessage());
            }
            if (!find) continue;
            break;
        }
        this.log.debug((Object)"invocazione metodo getWSDLAccordoServizio completata.");
        if (!find) {
            if (exceptionProblem.length() > 0 && notFoundProblem.length() > 0) {
                throw new DriverRegistroServiziException("getWSDLAccordoServizio:" + exceptionProblem.toString() + notFoundProblem.toString());
            }
            if (exceptionProblem.length() > 0) {
                throw new DriverRegistroServiziException("getWSDLAccordoServizio:" + exceptionProblem.toString());
            }
            if (notFoundProblem.length() > 0) {
                throw new DriverRegistroServiziNotFound("getWSDLAccordoServizio:" + notFoundProblem.toString());
            }
            throw new DriverRegistroServiziException("getWSDLAccordoServizio: ricerca non riuscita in tutti i registri");
        }
        AccordoServizioWrapper accordoServizioWrapper = new AccordoServizioWrapper();
        idAccordo = IDAccordo.getIDAccordoFromAccordo(as);
        accordoServizioWrapper.setIdAccordoServizio(idAccordo);
        accordoServizioWrapper.setNomePortType(servizio.getPortType());
        accordoServizioWrapper.setCorrelato(servizio.getServizioCorrelato());
        accordoServizioWrapper.setAccordoServizio(as);
        accordoServizioWrapper.setLocationWsdlImplementativoErogatore(servizio.getWsdlImplementativoErogatore());
        accordoServizioWrapper.setLocationWsdlImplementativoFruitore(servizio.getWsdlImplementativoFruitore());
        accordoServizioWrapper.setBytesWsdlImplementativoErogatore(servizio.getByteWsdlImplementativoErogatore());
        accordoServizioWrapper.setBytesWsdlImplementativoFruitore(servizio.getByteWsdlImplementativoFruitore());
        AccordoServizioWrapperUtilities wsdlWrapperUtilities = new AccordoServizioWrapperUtilities(this.log);
        wsdlWrapperUtilities.setAccordoServizio(accordoServizioWrapper);
        try {
            boolean buildFromBytes = registroServiziDB;
            wsdlWrapperUtilities.buildSchema(buildFromBytes);
        }
        catch (DriverRegistroServiziException e) {
            throw new DriverRegistroServiziException("[SchemaXSD] " + e.getMessage(), (Throwable)e);
        }
        try {
            if (readWSDLAccordoServizio) {
                this.log.debug((Object)"Costruisco WSDLAccordoServizio from WSDL...");
                if (servizio.getServizioCorrelato()) {
                    Definition wsdlFruitore = null;
                    wsdlFruitore = registroServiziDB ? wsdlWrapperUtilities.buildWsdlFruitoreFromBytes() : wsdlWrapperUtilities.buildWsdlFruitore();
                    boolean readParteImplementativa = servizio.getWsdlImplementativoFruitore() != null && !"".equals(servizio.getWsdlImplementativoFruitore()) || servizio.getByteWsdlImplementativoFruitore() != null;
                    wsdlWrapperUtilities.buildAccordoServizioWrapperFromWsdl(wsdlFruitore, readParteImplementativa);
                } else {
                    Definition wsdlErogatore = null;
                    wsdlErogatore = registroServiziDB ? wsdlWrapperUtilities.buildWsdlErogatoreFromBytes() : wsdlWrapperUtilities.buildWsdlErogatore();
                    boolean readParteImplementativa = servizio.getWsdlImplementativoErogatore() != null && !"".equals(servizio.getWsdlImplementativoErogatore()) || servizio.getByteWsdlImplementativoErogatore() != null;
                    wsdlWrapperUtilities.buildAccordoServizioWrapperFromWsdl(wsdlErogatore, readParteImplementativa);
                }
            } else {
                this.log.debug((Object)"Costruisco WSDLAccordoServizio from AccordoServizio...");
                wsdlWrapperUtilities.buildAccordoServizioWrapperFromOpenSPCoopAS(as);
            }
        }
        catch (DriverRegistroServiziException e) {
            if (servizio.getServizioCorrelato()) {
                throw new DriverRegistroServiziException("[WSDL-FRUITORE] " + e.getMessage(), (Throwable)e);
            }
            throw new DriverRegistroServiziException("[WSDL-EROGATORE] " + e.getMessage(), (Throwable)e);
        }
        this.log.debug((Object)"invocazione metodo getWSDLAccordoServizio completata.");
        return accordoServizioWrapper;
    }
}

