/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.egov;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPFactory;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.message.Detail;
import org.apache.axis.message.InputStreamBody;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.PrefixedQName;
import org.apache.axis.message.SOAPBody;
import org.apache.axis.message.SOAPFault;
import org.apache.axis.soap.MessageFactoryImpl;
import org.apache.log4j.Logger;
import org.openspcoop.dao.commons.IDSoggetto;
import org.openspcoop.dao.eccezione.DettaglioEccezione;
import org.openspcoop.egov.Busta;
import org.openspcoop.egov.Configurazione;
import org.openspcoop.egov.EGovException;
import org.openspcoop.egov.Eccezione;
import org.openspcoop.egov.Imbustamento;
import org.openspcoop.egov.ProprietaErroreApplicativo;
import org.openspcoop.utils.SoapUtils;
import org.openspcoop.utils.date.DateManager;
import org.openspcoop.utils.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XMLBuilder {
    private Logger log = null;

    public XMLBuilder() {
        this(Configurazione.getLibraryLog());
    }

    public XMLBuilder(Logger aLog) {
        this.log = aLog != null ? aLog : Logger.getLogger((String)"XMLBuilder");
    }

    public Element buildElement_Diagnostico(String idPorta, String idFunzione, int livello, String text, Date gdo) throws EGovException {
        try {
            Document doc = XMLUtils.newDocument();
            Element diagnostico = doc.createElementNS("http://www.ctrupa.it/schemas/2003/eGovIT/Diag1_0/", "eGov_IT_Diag:MessaggioDiagnostico");
            diagnostico.setAttribute("xmlns:xsd", "http://www.w3.org/2001/XMLSchema");
            diagnostico.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            Element gdoMsgDiag = doc.createElementNS("http://www.ctrupa.it/schemas/2003/eGovIT/Diag1_0/", "eGov_IT_Diag:OraRegistrazione");
            Date gdoD = null;
            gdoD = gdo == null ? new Date(DateManager.getTimeMillis()) : new Date(gdo.getTime());
            SimpleDateFormat dateformat = new SimpleDateFormat("yyyy-MM-dd_HH:mm:ss.SSS");
            gdoMsgDiag.setTextContent(dateformat.format(gdoD).replace('_', 'T'));
            diagnostico.appendChild(gdoMsgDiag);
            Element identificativoPorta = doc.createElementNS("http://www.ctrupa.it/schemas/2003/eGovIT/Diag1_0/", "eGov_IT_Diag:IdentificativoPorta");
            identificativoPorta.setTextContent(idPorta);
            diagnostico.appendChild(identificativoPorta);
            Element identificativoFunzione = doc.createElementNS("http://www.ctrupa.it/schemas/2003/eGovIT/Diag1_0/", "eGov_IT_Diag:IdentificativoFunzione");
            identificativoFunzione.setTextContent(idFunzione);
            diagnostico.appendChild(identificativoFunzione);
            Element livelloSev = doc.createElementNS("http://www.ctrupa.it/schemas/2003/eGovIT/Diag1_0/", "eGov_IT_Diag:LivelloDiSeverita");
            String liv = "" + livello;
            String livDefault = "0";
            if (livello < 10) {
                livelloSev.setTextContent(liv);
            } else {
                livelloSev.setTextContent(livDefault);
            }
            diagnostico.appendChild(livelloSev);
            Element testo = doc.createElementNS("http://www.ctrupa.it/schemas/2003/eGovIT/Diag1_0/", "eGov_IT_Diag:TestoDiagnostico");
            testo.setTextContent(text);
            diagnostico.appendChild(testo);
            return diagnostico;
        }
        catch (Exception e) {
            this.log.error((Object)("XMLBuilder.buildElement_Diagnostico error: " + e.getMessage()), (Throwable)e);
            throw new EGovException("XMLBuilder.buildElement_Diagnostico error: " + e.getMessage(), e);
        }
    }

    public Element buildElement_Diagnostico(String idPorta, String idFunzione, int livello, String text) throws EGovException {
        try {
            return this.buildElement_Diagnostico(idPorta, idFunzione, livello, text, null);
        }
        catch (Exception e) {
            this.log.error((Object)("XMLBuilder.buildElement_Diagnostico error: " + e.getMessage()), (Throwable)e);
            throw new EGovException("XMLBuilder.buildElement_Diagnostico error: " + e.getMessage(), e);
        }
    }

    public byte[] buildBytes_Diagnostico(String idPorta, String idFunzione, int livello, String text) throws EGovException {
        try {
            Element diagnostico = this.buildElement_Diagnostico(idPorta, idFunzione, livello, text);
            if (diagnostico == null) {
                throw new EGovException("XMLBuilder.buildBytes_Diagnostico fallito");
            }
            return XMLUtils.toByteArray((Element)diagnostico, (boolean)true);
        }
        catch (Exception e) {
            this.log.error((Object)("XMLBuilder.buildBytes_Diagnostico error: " + e.getMessage()), (Throwable)e);
            throw new EGovException("XMLBuilder.buildBytes_Diagnostico error: " + e.getMessage(), e);
        }
    }

    public String buildString_Diagnostico(String idPorta, String idFunzione, int livello, String text) throws EGovException {
        try {
            Element diagnostico = this.buildElement_Diagnostico(idPorta, idFunzione, livello, text);
            if (diagnostico == null) {
                throw new EGovException("XMLBuilder.buildString_Diagnostico fallito");
            }
            return XMLUtils.toString((Element)diagnostico, (boolean)true);
        }
        catch (Exception e) {
            this.log.error((Object)("XMLBuilder.buildString_Diagnostico error: " + e.getMessage()), (Throwable)e);
            throw new EGovException("XMLBuilder.buildString_Diagnostico error: " + e.getMessage(), e);
        }
    }

    public SOAPElement buildElement_Tracciamento(Busta busta, String idPorta, String tipoMsg, Date gdo) throws EGovException {
        return this.buildElement_Tracciamento(busta, null, null, idPorta, tipoMsg, gdo);
    }

    public SOAPElement buildElement_Tracciamento(Busta busta, String idPorta, String tipoMsg) throws EGovException {
        return this.buildElement_Tracciamento(busta, null, null, idPorta, tipoMsg, null);
    }

    public SOAPElement buildElement_Tracciamento(byte[] bustaInByte, String idPorta, String tipoMsg, Date gdo) throws EGovException {
        return this.buildElement_Tracciamento(null, bustaInByte, null, idPorta, tipoMsg, gdo);
    }

    public SOAPElement buildElement_Tracciamento(byte[] bustaInByte, String idPorta, String tipoMsg) throws EGovException {
        return this.buildElement_Tracciamento(null, bustaInByte, null, idPorta, tipoMsg, null);
    }

    public SOAPElement buildElement_Tracciamento(SOAPElement bustaInDom, String idPorta, String tipoMsg, Date gdo) throws EGovException {
        return this.buildElement_Tracciamento(null, null, bustaInDom, idPorta, tipoMsg, gdo);
    }

    public SOAPElement buildElement_Tracciamento(SOAPElement bustaInDom, String idPorta, String tipoMsg) throws EGovException {
        return this.buildElement_Tracciamento(null, null, bustaInDom, idPorta, tipoMsg, null);
    }

    public byte[] buildBytes_Tracciamento(Busta busta, String idPorta, String tipoMsg) throws EGovException {
        try {
            SOAPElement tracciamento = this.buildElement_Tracciamento(busta, idPorta, tipoMsg);
            if (tracciamento == null) {
                throw new EGovException("XMLBuilder.buildBytes_Tracciamento fallito");
            }
            return SoapUtils.getAsString((MessageElement)((MessageElement)tracciamento)).getBytes();
        }
        catch (Exception e) {
            this.log.error((Object)("XMLBuilder.buildBytes_Tracciamento error: " + e.getMessage()), (Throwable)e);
            throw new EGovException("XMLBuilder.buildBytes_Tracciamento error: " + e.getMessage(), e);
        }
    }

    public byte[] buildBytes_Tracciamento(byte[] bustaInByte, String idPorta, String tipoMsg) throws EGovException {
        try {
            SOAPElement tracciamento = this.buildElement_Tracciamento(bustaInByte, idPorta, tipoMsg);
            if (tracciamento == null) {
                throw new EGovException("XMLBuilder.buildBytes_Tracciamento fallito");
            }
            return SoapUtils.getAsString((MessageElement)((MessageElement)tracciamento)).getBytes();
        }
        catch (Exception e) {
            this.log.error((Object)("XMLBuilder.buildBytes_Tracciamento error: " + e.getMessage()), (Throwable)e);
            throw new EGovException("XMLBuilder.buildBytes_Tracciamento error: " + e.getMessage(), e);
        }
    }

    public byte[] buildBytes_Tracciamento(SOAPElement bustaInDom, String idPorta, String tipoMsg) throws EGovException {
        try {
            SOAPElement tracciamento = this.buildElement_Tracciamento(bustaInDom, idPorta, tipoMsg);
            if (tracciamento == null) {
                throw new EGovException("XMLBuilder.buildBytes_Tracciamento fallito");
            }
            return SoapUtils.getAsString((MessageElement)((MessageElement)tracciamento)).getBytes();
        }
        catch (Exception e) {
            this.log.error((Object)("XMLBuilder.buildBytes_Tracciamento error: " + e.getMessage()), (Throwable)e);
            throw new EGovException("XMLBuilder.buildBytes_Tracciamento error: " + e.getMessage(), e);
        }
    }

    public String buildString_Tracciamento(Busta busta, String idPorta, String tipoMsg) throws EGovException {
        try {
            SOAPElement tracciamento = this.buildElement_Tracciamento(busta, idPorta, tipoMsg);
            if (tracciamento == null) {
                throw new EGovException("XMLBuilder.buildString_Tracciamento fallito");
            }
            return SoapUtils.getAsString((MessageElement)((MessageElement)tracciamento));
        }
        catch (Exception e) {
            this.log.error((Object)("XMLBuilder.buildString_Tracciamento error: " + e.getMessage()), (Throwable)e);
            throw new EGovException("XMLBuilder.buildString_Tracciamento error: " + e.getMessage(), e);
        }
    }

    public String buildString_Tracciamento(byte[] bustaInByte, String idPorta, String tipoMsg) throws EGovException {
        try {
            SOAPElement tracciamento = this.buildElement_Tracciamento(bustaInByte, idPorta, tipoMsg);
            if (tracciamento == null) {
                throw new EGovException("XMLBuilder.buildString_Tracciamento fallito");
            }
            return SoapUtils.getAsString((MessageElement)((MessageElement)tracciamento));
        }
        catch (Exception e) {
            this.log.error((Object)("XMLBuilder.buildString_Tracciamento error: " + e.getMessage()), (Throwable)e);
            throw new EGovException("XMLBuilder.buildString_Tracciamento error: " + e.getMessage(), e);
        }
    }

    public String buildString_Tracciamento(SOAPElement bustaInDom, String idPorta, String tipoMsg) throws EGovException {
        try {
            SOAPElement tracciamento = this.buildElement_Tracciamento(bustaInDom, idPorta, tipoMsg);
            if (tracciamento == null) {
                throw new EGovException("XMLBuilder.buildString_Tracciamento fallito");
            }
            return SoapUtils.getAsString((MessageElement)((MessageElement)tracciamento));
        }
        catch (Exception e) {
            this.log.error((Object)("XMLBuilder.buildString_Tracciamento error: " + e.getMessage()), (Throwable)e);
            throw new EGovException("XMLBuilder.buildString_Tracciamento error: " + e.getMessage(), e);
        }
    }

    private SOAPElement buildElement_Tracciamento(Busta busta, byte[] bustaInByte, SOAPElement bustaInDom, String idPorta, String tipoMsg, Date gdo) throws EGovException {
        try {
            SOAPFactory sf = SoapUtils.getSoapFactory();
            SOAPElement traccia = sf.createElement("traccia", "eGov_IT_Trac", "http://www.cnipa.it/schemas/2003/eGovIT/Tracciamento1_0/");
            traccia.addNamespaceDeclaration("xsd", "http://www.w3.org/2001/XMLSchema");
            traccia.addNamespaceDeclaration("xsi", "http://www.w3.org/2001/XMLSchema-instance");
            SOAPElement GDO = traccia.addChildElement("GDO");
            if (gdo == null) {
                GDO.setValue(Imbustamento.getDate_eGovFormat());
            } else {
                GDO.setValue(Imbustamento.getDate_eGovFormat(gdo));
            }
            SOAPElement IdentificativoPorta = traccia.addChildElement("IdentificativoPorta");
            IdentificativoPorta.setValue(idPorta);
            SOAPElement TipoMessaggio = traccia.addChildElement("TipoMessaggio");
            TipoMessaggio.setValue(tipoMsg);
            MessageElement hdrEGov = null;
            if (busta != null) {
                Imbustamento imbustamento = new Imbustamento(this.log);
                hdrEGov = (MessageElement)imbustamento.build_eGovHeader(busta, false);
            } else if (bustaInDom != null) {
                Document document = XMLUtils.newDocument((byte[])SoapUtils.getAsString((MessageElement)((MessageElement)bustaInDom)).getBytes());
                hdrEGov = new MessageElement(document.getDocumentElement());
            } else {
                Document document = XMLUtils.newDocument((byte[])bustaInByte);
                hdrEGov = new MessageElement(document.getDocumentElement());
            }
            if (hdrEGov == null) {
                throw new EGovException("XMLBuilder.buildElement_Tracciamento fallito");
            }
            traccia.addChildElement((SOAPElement)hdrEGov);
            return traccia;
        }
        catch (Exception e) {
            this.log.error((Object)("XMLBuilder.buildElement_Tracciamento error: " + e.getMessage()), (Throwable)e);
            throw new EGovException("XMLBuilder.buildElement_Tracciamento error: " + e.getMessage(), e);
        }
    }

    public Element buildElement_Eccezione(String idPorta, String idFunzione, String codiceEccezione, String descrizioneEccezione, String tipoEccezione) throws EGovException {
        try {
            Document doc = XMLUtils.newDocument();
            Element eccezione = doc.createElementNS("http://www.cnipa.it/schemas/2003/eGovIT/Exception1_0/", "eGov_IT_Ecc:MessaggioDiErroreApplicativo");
            eccezione.setAttribute("xmlns:xsd", "http://www.w3.org/2001/XMLSchema");
            eccezione.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            Element oraRec = doc.createElementNS("http://www.cnipa.it/schemas/2003/eGovIT/Exception1_0/", "eGov_IT_Ecc:OraRegistrazione");
            oraRec.setTextContent(Imbustamento.getDate_eGovFormat());
            eccezione.appendChild(oraRec);
            Element identificativoPorta = doc.createElementNS("http://www.cnipa.it/schemas/2003/eGovIT/Exception1_0/", "eGov_IT_Ecc:IdentificativoPorta");
            identificativoPorta.setTextContent(idPorta);
            eccezione.appendChild(identificativoPorta);
            Element identificativoFunzione = doc.createElementNS("http://www.cnipa.it/schemas/2003/eGovIT/Exception1_0/", "eGov_IT_Ecc:IdentificativoFunzione");
            identificativoFunzione.setTextContent(idFunzione);
            eccezione.appendChild(identificativoFunzione);
            Element EccNode = doc.createElementNS("http://www.cnipa.it/schemas/2003/eGovIT/Exception1_0/", "eGov_IT_Ecc:Eccezione");
            eccezione.appendChild(EccNode);
            String tipo = "EccezioneProcessamento";
            if (tipoEccezione.equals("EccezioneBusta")) {
                tipo = "EccezioneBusta";
            }
            Element EccNodeInterno = doc.createElementNS("http://www.cnipa.it/schemas/2003/eGovIT/Exception1_0/", "eGov_IT_Ecc:" + tipo);
            EccNodeInterno.setAttribute("codiceEccezione", codiceEccezione);
            EccNodeInterno.setAttribute("descrizioneEccezione", descrizioneEccezione);
            EccNode.appendChild(EccNodeInterno);
            return eccezione;
        }
        catch (Exception e) {
            this.log.error((Object)("XMLBuilder.buildElement_Eccezione error: " + e.getMessage()), (Throwable)e);
            throw new EGovException("XMLBuilder.buildElement_Eccezione error: " + e.getMessage(), e);
        }
    }

    public Element buildElement_Eccezione(String idPorta, String idFunzione, Eccezione ecc) throws EGovException {
        return this.buildElement_Eccezione(idPorta, idFunzione, ecc.getCodiceEccezione(), ecc.getPosizione(), "EccezioneBusta");
    }

    public byte[] buildBytes_Eccezione(String idPorta, String idFunzione, String codiceEccezione, String descrizioneEccezione, String tipoEccezione) throws EGovException {
        try {
            Element eccezione = this.buildElement_Eccezione(idPorta, idFunzione, codiceEccezione, descrizioneEccezione, tipoEccezione);
            if (eccezione == null) {
                throw new EGovException("XMLBuilder.buildBytes_Eccezione fallito");
            }
            return XMLUtils.toByteArray((Element)eccezione, (boolean)true);
        }
        catch (Exception e) {
            this.log.error((Object)("XMLBuilder.buildBytes_Eccezione error: " + e.getMessage()), (Throwable)e);
            throw new EGovException("XMLBuilder.buildBytes_Eccezione error: " + e.getMessage(), e);
        }
    }

    public byte[] buildBytes_Eccezione(String idPorta, String idFunzione, Eccezione ecc) throws EGovException {
        return this.buildBytes_Eccezione(idPorta, idFunzione, ecc.getCodiceEccezione(), ecc.getPosizione(), "EccezioneBusta");
    }

    public String buildString_Eccezione(String idPorta, String idFunzione, String codiceEccezione, String descrizioneEccezione, String tipoEccezione) throws EGovException {
        try {
            Element eccezione = this.buildElement_Eccezione(idPorta, idFunzione, codiceEccezione, descrizioneEccezione, tipoEccezione);
            if (eccezione == null) {
                throw new EGovException("XMLBuilder.buildBytes_Eccezione fallito");
            }
            return XMLUtils.toString((Element)eccezione, (boolean)true);
        }
        catch (Exception e) {
            this.log.error((Object)("XMLBuilder.buildString_Eccezione error: " + e.getMessage()), (Throwable)e);
            throw new EGovException("XMLBuilder.buildString_Eccezione error: " + e.getMessage(), e);
        }
    }

    public String buildString_Eccezione(String idPorta, String idFunzione, Eccezione ecc) throws EGovException {
        return this.buildString_Eccezione(idPorta, idFunzione, ecc.getCodiceEccezione(), ecc.getPosizione(), "EccezioneBusta");
    }

    public void insertErroreApplicativoProcessamentoIntoSOAPFault(ProprietaErroreApplicativo proprieta, String codErrore, String msgErrore, Message msg) throws EGovException {
        this.insertErroreApplicativoIntoSOAPFault(proprieta, codErrore, msgErrore, null, null, msg);
    }

    public void insertErroreApplicativoEccezioneIntoSOAPFault(ProprietaErroreApplicativo proprieta, Eccezione eccezione, IDSoggetto soggettoProduttoreEccezione, Message msg) throws EGovException {
        this.insertErroreApplicativoIntoSOAPFault(proprieta, null, null, eccezione, soggettoProduttoreEccezione, msg);
    }

    private void insertErroreApplicativoIntoSOAPFault(ProprietaErroreApplicativo proprieta, String codErrore, String msgErrore, Eccezione eccezione, IDSoggetto soggettoProduttoreEccezione, Message msg) throws EGovException {
        try {
            Element erroreApplicativo = null;
            if (eccezione != null) {
                if (eccezione.getPosizione() != null) {
                    String msgPortaDiDominioNonDisponibile = "Porta di Dominio del soggetto @NOMEPDD@ non disponibile".replace("@NOMEPDD@", soggettoProduttoreEccezione.getTipo() + soggettoProduttoreEccezione.getNome());
                    if (eccezione.getPosizione().indexOf(msgPortaDiDominioNonDisponibile) == -1) {
                        eccezione.setPosizione(soggettoProduttoreEccezione.toString() + " ha rilevato le seguenti eccezioni:\n" + eccezione.getPosizione());
                    }
                }
                erroreApplicativo = this.buildElement_Eccezione(proprieta.getDominio(), proprieta.getIdModulo(), eccezione);
            } else {
                String msgErroreTrasformato = proprieta.transformFaultMsg(codErrore, msgErrore);
                String codiceErroreTrasformato = proprieta.transformFaultCode(codErrore);
                erroreApplicativo = this.buildElement_Eccezione(proprieta.getDominio(), proprieta.getIdModulo(), codiceErroreTrasformato, msgErroreTrasformato, "EccezioneProcessamento");
            }
            this.insertErroreApplicativoIntoSOAPFault(erroreApplicativo, msg);
        }
        catch (Exception e) {
            this.log.error((Object)"Errore durante la costruzione del messaggio di errore", (Throwable)e);
            throw new EGovException("Errore durante la costruzione del messaggio di errore", e);
        }
    }

    public void insertRoutingErrorIntoSOAPFault(IDSoggetto identitaRouter, Message msg) throws EGovException {
        try {
            PrefixedQName name = new PrefixedQName("http://www.openspcoop.org/routing", "routing", "Routing");
            MessageElement eccezione = new MessageElement((Name)name);
            eccezione.addNamespaceDeclaration("xsd", "http://www.w3.org/2001/XMLSchema");
            eccezione.addNamespaceDeclaration("xsi", "http://www.w3.org/2001/XMLSchema-instance");
            MessageElement esito = (MessageElement)eccezione.addChildElement("Esito");
            esito.setObjectValue((Object)"KO");
            MessageElement IdentificativoPorta = (MessageElement)eccezione.addChildElement("IdentificativoRouter");
            IdentificativoPorta.setObjectValue((Object)identitaRouter.toString());
            this.insertErroreApplicativoIntoSOAPFault((Element)eccezione, msg);
        }
        catch (Exception e) {
            this.log.error((Object)"Errore durante la costruzione del messaggio di errore", (Throwable)e);
            throw new EGovException("Errore durante la costruzione del messaggio di errore", e);
        }
    }

    private void insertErroreApplicativoIntoSOAPFault(Element erroreApplicativo, Message msg) throws EGovException {
        try {
            if (msg == null) {
                throw new EGovException("Messaggio non presente");
            }
            SOAPBody soapBody = (SOAPBody)msg.getSOAPBody();
            if (soapBody == null) {
                throw new EGovException("SOAPBody non presente");
            }
            SOAPFault faultOriginale = null;
            if (!soapBody.hasFault()) {
                throw new EGovException("SOAPFault non presente");
            }
            faultOriginale = (SOAPFault)soapBody.getFault();
            if (faultOriginale == null) {
                throw new EGovException("SOAPFault is null");
            }
            byte[] bin = XMLUtils.toByteArray((Element)erroreApplicativo, (boolean)true);
            Document de = XMLUtils.newDocument((byte[])bin);
            MessageElement eccezioneEGov = new MessageElement(de.getDocumentElement());
            QName nameDetail = new QName("detail");
            MessageElement detailsFaultOriginale = faultOriginale.getChildElement(nameDetail);
            msg.saveChanges();
            msg.getSOAPBody().removeChild((Node)msg.getSOAPBody().getFault());
            msg.saveChanges();
            SOAPFault faultPulito = (SOAPFault)msg.getSOAPBody().addFault();
            faultPulito.setFaultActor(faultOriginale.getFaultActor());
            faultPulito.setFaultCode(faultOriginale.getFaultCode());
            faultPulito.setFaultString(faultOriginale.getFaultString());
            Detail detailFaultPulito = (Detail)faultPulito.addDetail();
            detailFaultPulito = (Detail)faultPulito.getDetail();
            if (detailsFaultOriginale != null) {
                Iterator it = detailsFaultOriginale.getChildElements();
                while (it.hasNext()) {
                    Object o = it.next();
                    if (!(o instanceof SOAPElement)) continue;
                    SOAPElement elem = (SOAPElement)o;
                    detailFaultPulito.addChildElement(elem);
                }
            }
            detailFaultPulito.addChildElement((SOAPElement)eccezioneEGov);
            msg.saveChanges();
        }
        catch (Exception e) {
            this.log.error((Object)"Errore durante la costruzione del messaggio di errore", (Throwable)e);
            throw new EGovException("Errore durante la costruzione del messaggio di errore", e);
        }
    }

    public Message msgErroreApplicativo_Processamento(ProprietaErroreApplicativo proprieta, String codErrore, String msgErrore, IDSoggetto identitaPdD, String modulo) {
        return this.msgErroreApplicativo_Processamento(proprieta, codErrore, msgErrore, identitaPdD, modulo, null);
    }

    public Message msgErroreApplicativo_Processamento(ProprietaErroreApplicativo proprieta, String codErrore, String msgErrore, IDSoggetto identitaPdD, String modulo, Exception eProcessamento) {
        try {
            boolean produciDettaglioEccezione = false;
            produciDettaglioEccezione = codErrore.startsWith("OPENSPCOOP_ORG_4") ? Configurazione.isGenerazioneSOAPFaultIntegrazioneClientErrorWithDetails() : Configurazione.isGenerazioneSOAPFaultIntegrazioneServerErrorWithDetails();
            String msgErroreTrasformato = proprieta.transformFaultMsg(codErrore, msgErrore);
            String codiceErroreTrasformato = proprieta.transformFaultCode(codErrore);
            byte[] byteRispostaApplicativa = this.buildBytes_Eccezione(proprieta.getDominio(), proprieta.getIdModulo(), codiceErroreTrasformato, msgErroreTrasformato, "EccezioneProcessamento");
            DettaglioEccezione dettaglioEccezione = null;
            if (produciDettaglioEccezione) {
                Imbustamento imbustamento = new Imbustamento(this.log);
                dettaglioEccezione = imbustamento.buildDettaglioEccezione(identitaPdD, modulo, codiceErroreTrasformato, msgErroreTrasformato);
                if (eProcessamento != null) {
                    boolean informazioniGeneriche = proprieta.isInformazioniGenericheDetailsOpenSPCoop();
                    imbustamento.gestioneDettaglioEccezioneIntegrazione(eProcessamento, dettaglioEccezione, informazioniGeneriche);
                }
            }
            return this.msgErroreApplicativo(byteRispostaApplicativa, proprieta, codiceErroreTrasformato, msgErroreTrasformato, dettaglioEccezione);
        }
        catch (Exception e) {
            this.log.error((Object)"Errore durante la costruzione del messaggio di errore processamento", (Throwable)e);
            return new Message((Object)new AxisFault("ErroreDiProcessamento"));
        }
    }

    public Message msgErroreApplicativo_Eccezione(ProprietaErroreApplicativo proprieta, Eccezione eccezione, IDSoggetto soggettoProduttoreEccezione) {
        return this.msgErroreApplicativo_Eccezione(proprieta, eccezione, soggettoProduttoreEccezione, null);
    }

    public Message msgErroreApplicativo_Eccezione(ProprietaErroreApplicativo proprieta, Eccezione eccezione, IDSoggetto soggettoProduttoreEccezione, DettaglioEccezione dettaglioEccezione) {
        try {
            if (eccezione.getPosizione() != null) {
                String msgPortaDiDominioNonDisponibile = "Porta di Dominio del soggetto @NOMEPDD@ non disponibile".replace("@NOMEPDD@", soggettoProduttoreEccezione.getTipo() + soggettoProduttoreEccezione.getNome());
                if (eccezione.getPosizione().indexOf(msgPortaDiDominioNonDisponibile) == -1) {
                    eccezione.setPosizione(soggettoProduttoreEccezione.toString() + " ha rilevato le seguenti eccezioni:\n" + eccezione.getPosizione());
                }
            }
            byte[] byteRispostaApplicativa = this.buildBytes_Eccezione(proprieta.getDominio(), proprieta.getIdModulo(), eccezione);
            return this.msgErroreApplicativo(byteRispostaApplicativa, proprieta, eccezione.getCodiceEccezione(), eccezione.getPosizione(), dettaglioEccezione);
        }
        catch (Exception e) {
            this.log.error((Object)"Errore durante la costruzione del messaggio di errore busta", (Throwable)e);
            return new Message((Object)new AxisFault("ErroreDiProcessamento"));
        }
    }

    private Message msgErroreApplicativo(byte[] byteRispostaApplicativa, ProprietaErroreApplicativo proprieta, String faultCode, String msgErrore, DettaglioEccezione dettaglioEccezione) {
        ByteArrayInputStream inputBody = null;
        try {
            MessageFactoryImpl mf = new MessageFactoryImpl();
            Message responseAxisMessageError = (Message)mf.createMessage();
            SOAPBody soapBody = (SOAPBody)responseAxisMessageError.getSOAPBody();
            if (proprieta.isFaultAsXML()) {
                inputBody = new ByteArrayInputStream(byteRispostaApplicativa);
                InputStreamBody isBody = new InputStreamBody((InputStream)inputBody);
                soapBody.addChildElement((SOAPElement)isBody);
                inputBody.close();
            } else {
                soapBody.addFault();
                javax.xml.soap.SOAPFault fault = soapBody.getFault();
                fault.setFaultCode(faultCode);
                fault.setFaultActor(proprieta.getFaultActor());
                if (proprieta.isInsertAsDetails()) {
                    fault.setFaultString(msgErrore);
                    Document de = XMLUtils.newDocument((byte[])byteRispostaApplicativa);
                    MessageElement mSenzaXSITypes = new MessageElement(de.getDocumentElement());
                    Detail d = (Detail)fault.getDetail();
                    if (d == null) {
                        d = (Detail)fault.addDetail();
                        d = (Detail)fault.getDetail();
                    }
                    d.addChild(mSenzaXSITypes);
                } else {
                    fault.setFaultString(new String(byteRispostaApplicativa));
                }
                if (dettaglioEccezione != null) {
                    Detail d = (Detail)fault.getDetail();
                    if (d == null) {
                        d = (Detail)fault.addDetail();
                        d = (Detail)fault.getDetail();
                    }
                    byte[] dettaglioEccezioneBytes = org.openspcoop.dao.eccezione.driver.XMLUtils.generateDettaglioEccezione((DettaglioEccezione)dettaglioEccezione);
                    Document de = XMLUtils.newDocument((byte[])dettaglioEccezioneBytes);
                    MessageElement messageElement = new MessageElement(de.getDocumentElement());
                    d.addChild(messageElement);
                }
            }
            return responseAxisMessageError;
        }
        catch (Exception e) {
            try {
                inputBody.close();
            }
            catch (Exception eis) {
                // empty catch block
            }
            return new Message((Object)new AxisFault("ErroreProcessamento"));
        }
    }
}

