/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.egov;

import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.Vector;
import javax.xml.soap.Detail;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPHeaderElement;
import org.apache.axis.Message;
import org.apache.axis.attachments.AttachmentPart;
import org.apache.axis.message.SOAPHeader;
import org.apache.log4j.Logger;
import org.openspcoop.egov.Busta;
import org.openspcoop.egov.Configurazione;
import org.openspcoop.egov.EGovException;
import org.openspcoop.egov.Eccezione;
import org.openspcoop.egov.ProprietaManifestAttachments;
import org.openspcoop.egov.Riscontro;
import org.openspcoop.egov.StrutturaEGovException;
import org.openspcoop.egov.Trasmissione;
import org.openspcoop.utils.SoapUtils;
import org.openspcoop.utils.date.DateManager;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidazioneSintattica {
    private Message msg;
    private SOAPHeader headerSOAP = null;
    private SOAPHeaderElement headerEGov;
    private Vector<Eccezione> erroriValidazione;
    private Vector<Eccezione> erroriProcessamento;
    private Vector<Eccezione> errorsTrovatiSullaListaEccezioni;
    private Busta busta;
    private String msgErrore;
    private String codiceErrore;
    private boolean readQualifiedAttribute;
    private Logger log = null;
    private boolean segnalazioneElementoPresentePiuVolte = false;
    private boolean messaggioScaduto = false;
    private Busta bustaErroreHeaderIntestazione = null;

    public void setHeaderSOAP(SOAPHeader headerSOAP) {
        this.headerSOAP = headerSOAP;
    }

    public Busta getBustaErroreHeaderIntestazione() {
        return this.bustaErroreHeaderIntestazione;
    }

    public ValidazioneSintattica(Message aMsg, boolean readQualifiedAttribute) {
        this(aMsg, Configurazione.getLibraryLog(), readQualifiedAttribute);
    }

    public ValidazioneSintattica(Message aMsg) {
        this(aMsg, Configurazione.getLibraryLog(), false);
    }

    public ValidazioneSintattica(Message aMsg, Logger alog) {
        this(aMsg, alog, false);
    }

    public ValidazioneSintattica(Message aMsg, Logger alog, boolean readQualifiedAttribute) {
        this.msg = aMsg;
        this.log = alog != null ? alog : Logger.getLogger((String)ValidazioneSintattica.class.getName());
        this.readQualifiedAttribute = readQualifiedAttribute;
    }

    public SOAPHeaderElement getHeaderEGov() throws EGovException {
        try {
            if (this.headerEGov != null) {
                return this.headerEGov;
            }
            if (this.headerSOAP == null) {
                this.headerSOAP = (SOAPHeader)this.msg.getSOAPHeader();
            }
            this.headerEGov = this.getHeaderEGov((javax.xml.soap.SOAPHeader)this.headerSOAP);
            return this.headerEGov;
        }
        catch (Exception e) {
            this.log.error((Object)("ValidazioneSintattica.headerEGovAsBytes error: " + e.getMessage()), (Throwable)e);
            throw new EGovException("ValidazioneSintattica.headerEGovAsBytes error: " + e.getMessage(), e);
        }
    }

    public Busta getBusta() {
        return this.busta;
    }

    public Vector<Eccezione> getEccezioniValidazione() {
        return this.erroriValidazione;
    }

    public Vector<Eccezione> getEccezioniProcessamento() {
        return this.erroriProcessamento;
    }

    public Vector<Eccezione> getErroriTrovatiSullaListaEccezioni() {
        return this.errorsTrovatiSullaListaEccezioni;
    }

    public String getMsgErrore() {
        return this.msgErrore;
    }

    public String getCodiceErrore() {
        return this.codiceErrore;
    }

    public SOAPHeaderElement getHeaderSPCoop() {
        return this.headerEGov;
    }

    public boolean bustaSPCoopPresente() {
        return this.existsHeaderEGov();
    }

    public boolean valida() {
        try {
            if (this.headerSOAP == null) {
                this.headerSOAP = (SOAPHeader)this.msg.getSOAPHeader();
            }
            if (this.headerSOAP == null) {
                this.msgErrore = "Analizzato un messaggio senza header";
                this.codiceErrore = "HeaderSOAPNonPresente";
                return false;
            }
            if (this.headerEGov == null) {
                this.headerEGov = this.getHeaderEGov((javax.xml.soap.SOAPHeader)this.headerSOAP);
            }
            if (this.headerEGov == null) {
                this.msgErrore = "Analizzato un messaggio senza busta SPCoop";
                this.codiceErrore = "BustaSPCoopNonPresente";
                return false;
            }
        }
        catch (StrutturaEGovException e) {
            this.log.error((Object)("Struttura della busta non corretta: " + e.getMessage()), (Throwable)e);
            this.msgErrore = e.getMessage();
            this.codiceErrore = "StrutturaErrata" + e.getCodice();
            return false;
        }
        catch (Exception e) {
            this.msgErrore = "(Validazione sintattica) " + e.getMessage();
            this.codiceErrore = "LetturaBustaSPCoopNonRiuscita";
            this.busta = null;
            return false;
        }
        try {
            Eccezione ecc;
            Busta aBusta;
            this.busta = aBusta = new Busta();
            this.erroriValidazione = new Vector();
            this.erroriProcessamento = new Vector();
            this.errorsTrovatiSullaListaEccezioni = new Vector();
            String xmlns = this.getPrefix();
            if (!"http://www.cnipa.it/eGov_it/portadominio".equals(this.headerEGov.getActor())) {
                if (!Configurazione.getConfigurazioneGenerazioneBusta().isGenerazioneBustaSPCoopErrore_actorNonCorretto()) {
                    throw new StrutturaEGovException("Header egov con actor scorretto", "Actor");
                }
                ecc = new Eccezione();
                ecc.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                ecc.setCodiceEccezione("EGOV_IT_002");
                ecc.setRilevanza("GRAVE");
                ecc.setPosizione("Intestazione/actor");
                this.erroriValidazione.add(ecc);
            }
            if (!this.headerEGov.getMustUnderstand()) {
                ecc = new Eccezione();
                ecc.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                ecc.setCodiceEccezione("EGOV_IT_002");
                ecc.setRilevanza("GRAVE");
                ecc.setPosizione("Intestazione/mustUnderstand");
                this.erroriValidazione.add(ecc);
            }
            NodeList list = this.headerEGov.getChildNodes();
            if (!"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/".equals(this.headerEGov.getNamespaceURI())) {
                Eccezione ecc2 = new Eccezione();
                ecc2.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                ecc2.setCodiceEccezione("EGOV_IT_002");
                ecc2.setRilevanza("GRAVE");
                ecc2.setPosizione("Intestazione/namespace");
                this.erroriValidazione.add(ecc2);
            }
            Node intestazioneMsg = list.item(0);
            NodeList headerMsg = intestazioneMsg.getChildNodes();
            boolean mittenteGiaTrovato = false;
            boolean destinatarioGiaTrovato = false;
            boolean profiloCollaborazioneGiaTrovato = false;
            boolean collaborazioneGiaTrovato = false;
            boolean servizioGiaTrovato = false;
            boolean azioneGiaTrovato = false;
            boolean messaggioGiaTrovato = false;
            boolean profiloTrasmissioneGiaTrovato = false;
            boolean sequenzaGiaTrovato = false;
            for (int i = 0; i < headerMsg.getLength(); ++i) {
                Eccezione ecc3;
                Node child = headerMsg.item(i);
                if (SoapUtils.matchLocalName((Node)child, (String)"Mittente", (String)xmlns, (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/")) {
                    if (!mittenteGiaTrovato) {
                        this.validazioneMittente(child, xmlns);
                        mittenteGiaTrovato = true;
                        continue;
                    }
                    if (!Configurazione.getConfigurazioneGenerazioneBusta().isGenerazioneBustaSPCoopErrore_strutturaHeaderNonCorretta()) {
                        throw new StrutturaEGovException("Header egov con pi\u00f9 di un elemento Mittente", "Mittente");
                    }
                    ecc3 = new Eccezione();
                    ecc3.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                    ecc3.setCodiceEccezione("EGOV_IT_101");
                    ecc3.setRilevanza("GRAVE");
                    if (this.segnalazioneElementoPresentePiuVolte) {
                        ecc3.setPosizione("Mittente elemento presente pi\u00f9 volte nell'header");
                    } else {
                        ecc3.setPosizione("Mittente");
                    }
                    this.erroriValidazione.add(ecc3);
                    continue;
                }
                if (SoapUtils.matchLocalName((Node)child, (String)"Destinatario", (String)xmlns, (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/")) {
                    if (!destinatarioGiaTrovato) {
                        this.validazioneDestinatario(child, xmlns);
                        destinatarioGiaTrovato = true;
                        continue;
                    }
                    if (!Configurazione.getConfigurazioneGenerazioneBusta().isGenerazioneBustaSPCoopErrore_strutturaHeaderNonCorretta()) {
                        throw new StrutturaEGovException("Header egov con pi\u00f9 di un elemento Destinatario", "Destinatario");
                    }
                    ecc3 = new Eccezione();
                    ecc3.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                    ecc3.setCodiceEccezione("EGOV_IT_102");
                    ecc3.setRilevanza("GRAVE");
                    if (this.segnalazioneElementoPresentePiuVolte) {
                        ecc3.setPosizione("Destinatario elemento presente pi\u00f9 volte nell'header");
                    } else {
                        ecc3.setPosizione("Destinatario");
                    }
                    this.erroriValidazione.add(ecc3);
                    continue;
                }
                if (SoapUtils.matchLocalName((Node)child, (String)"ProfiloCollaborazione", (String)xmlns, (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/")) {
                    if (!profiloCollaborazioneGiaTrovato) {
                        this.validazioneProfiloCollaborazione(child, xmlns);
                        profiloCollaborazioneGiaTrovato = true;
                        continue;
                    }
                    if (!Configurazione.getConfigurazioneGenerazioneBusta().isGenerazioneBustaSPCoopErrore_strutturaHeaderNonCorretta()) {
                        throw new StrutturaEGovException("Header egov con pi\u00f9 di un elemento ProfiloCollaborazione", "ProfiloCollaborazione");
                    }
                    ecc3 = new Eccezione();
                    ecc3.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                    ecc3.setCodiceEccezione("EGOV_IT_103");
                    ecc3.setRilevanza("GRAVE");
                    if (this.segnalazioneElementoPresentePiuVolte) {
                        ecc3.setPosizione("ProfiloCollaborazione elemento presente pi\u00f9 volte nell'header");
                    } else {
                        ecc3.setPosizione("ProfiloCollaborazione");
                    }
                    this.erroriValidazione.add(ecc3);
                    continue;
                }
                if (SoapUtils.matchLocalName((Node)child, (String)"Collaborazione", (String)xmlns, (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/")) {
                    if (!collaborazioneGiaTrovato) {
                        this.validazioneCollaborazione(child);
                        collaborazioneGiaTrovato = true;
                        continue;
                    }
                    if (!Configurazione.getConfigurazioneGenerazioneBusta().isGenerazioneBustaSPCoopErrore_strutturaHeaderNonCorretta()) {
                        throw new StrutturaEGovException("Header egov con pi\u00f9 di un elemento Collaborazione", "Collaborazione");
                    }
                    ecc3 = new Eccezione();
                    ecc3.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                    ecc3.setCodiceEccezione("EGOV_IT_104");
                    ecc3.setRilevanza("GRAVE");
                    if (this.segnalazioneElementoPresentePiuVolte) {
                        ecc3.setPosizione("Collaborazione elemento presente pi\u00f9 volte nell'header");
                    } else {
                        ecc3.setPosizione("Collaborazione");
                    }
                    this.erroriValidazione.add(ecc3);
                    continue;
                }
                if (SoapUtils.matchLocalName((Node)child, (String)"Servizio", (String)xmlns, (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/")) {
                    if (!servizioGiaTrovato) {
                        this.validazioneServizio(child, xmlns);
                        servizioGiaTrovato = true;
                        continue;
                    }
                    if (!Configurazione.getConfigurazioneGenerazioneBusta().isGenerazioneBustaSPCoopErrore_strutturaHeaderNonCorretta()) {
                        throw new StrutturaEGovException("Header egov con pi\u00f9 di un elemento Servizio", "Servizio");
                    }
                    ecc3 = new Eccezione();
                    ecc3.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                    ecc3.setCodiceEccezione("EGOV_IT_105");
                    ecc3.setRilevanza("GRAVE");
                    if (this.segnalazioneElementoPresentePiuVolte) {
                        ecc3.setPosizione("Servizio elemento presente pi\u00f9 volte nell'header");
                    } else {
                        ecc3.setPosizione("Servizio");
                    }
                    this.erroriValidazione.add(ecc3);
                    continue;
                }
                if (SoapUtils.matchLocalName((Node)child, (String)"Azione", (String)xmlns, (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/")) {
                    if (!azioneGiaTrovato) {
                        this.validazioneAzione(child);
                        azioneGiaTrovato = true;
                        continue;
                    }
                    if (!Configurazione.getConfigurazioneGenerazioneBusta().isGenerazioneBustaSPCoopErrore_strutturaHeaderNonCorretta()) {
                        throw new StrutturaEGovException("Header egov con pi\u00f9 di un elemento Azione", "Azione");
                    }
                    ecc3 = new Eccezione();
                    ecc3.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                    ecc3.setCodiceEccezione("EGOV_IT_106");
                    ecc3.setRilevanza("GRAVE");
                    if (this.segnalazioneElementoPresentePiuVolte) {
                        ecc3.setPosizione("Azione elemento presente pi\u00f9 volte nell'header");
                    } else {
                        ecc3.setPosizione("Azione");
                    }
                    this.erroriValidazione.add(ecc3);
                    continue;
                }
                if (SoapUtils.matchLocalName((Node)child, (String)"Messaggio", (String)xmlns, (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/")) {
                    if (!messaggioGiaTrovato) {
                        this.validazioneMessaggio(child, xmlns);
                        messaggioGiaTrovato = true;
                        continue;
                    }
                    if (!Configurazione.getConfigurazioneGenerazioneBusta().isGenerazioneBustaSPCoopErrore_strutturaHeaderNonCorretta()) {
                        throw new StrutturaEGovException("Header egov con pi\u00f9 di un elemento Messaggio", "Messaggio");
                    }
                    ecc3 = new Eccezione();
                    ecc3.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                    ecc3.setCodiceEccezione("EGOV_IT_002");
                    ecc3.setRilevanza("GRAVE");
                    if (this.segnalazioneElementoPresentePiuVolte) {
                        ecc3.setPosizione("Messaggio elemento presente pi\u00f9 volte nell'header");
                    } else {
                        ecc3.setPosizione("Messaggio");
                    }
                    this.erroriValidazione.add(ecc3);
                    continue;
                }
                if (SoapUtils.matchLocalName((Node)child, (String)"ProfiloTrasmissione", (String)xmlns, (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/")) {
                    if (!profiloTrasmissioneGiaTrovato) {
                        this.validazioneProfiloTrasmissione(child, xmlns);
                        profiloTrasmissioneGiaTrovato = true;
                        continue;
                    }
                    if (!Configurazione.getConfigurazioneGenerazioneBusta().isGenerazioneBustaSPCoopErrore_strutturaHeaderNonCorretta()) {
                        throw new StrutturaEGovException("Header egov con pi\u00f9 di un elemento ProfiloTrasmissione", "ProfiloTrasmissione");
                    }
                    ecc3 = new Eccezione();
                    ecc3.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                    ecc3.setCodiceEccezione("EGOV_IT_113");
                    ecc3.setRilevanza("GRAVE");
                    if (this.segnalazioneElementoPresentePiuVolte) {
                        ecc3.setPosizione("ProfiloTrasmissione elemento presente pi\u00f9 volte nell'header");
                    } else {
                        ecc3.setPosizione("ProfiloTrasmissione");
                    }
                    this.erroriValidazione.add(ecc3);
                    continue;
                }
                if (SoapUtils.matchLocalName((Node)child, (String)"Sequenza", (String)xmlns, (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/")) {
                    if (!sequenzaGiaTrovato) {
                        this.validazioneSequenza(child, xmlns);
                        sequenzaGiaTrovato = true;
                        continue;
                    }
                    if (!Configurazione.getConfigurazioneGenerazioneBusta().isGenerazioneBustaSPCoopErrore_strutturaHeaderNonCorretta()) {
                        throw new StrutturaEGovException("Header egov con pi\u00f9 di un elemento Sequenza", "Sequenza");
                    }
                    ecc3 = new Eccezione();
                    ecc3.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                    ecc3.setCodiceEccezione("EGOV_IT_114");
                    ecc3.setRilevanza("GRAVE");
                    if (this.segnalazioneElementoPresentePiuVolte) {
                        ecc3.setPosizione("Sequenza elemento presente pi\u00f9 volte nell'header");
                    } else {
                        ecc3.setPosizione("Sequenza");
                    }
                    this.erroriValidazione.add(ecc3);
                    continue;
                }
                ecc3 = new Eccezione();
                ecc3.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                ecc3.setCodiceEccezione("EGOV_IT_002");
                ecc3.setRilevanza("GRAVE");
                ecc3.setPosizione("Messaggio/child[" + child.getNodeName() + "]");
                this.erroriValidazione.add(ecc3);
            }
            if (Configurazione.isFiltraBusteScaduteRispettoOraRegistrazione() && !this.messaggioScaduto) {
                String[] split;
                Date oraRegistrazioneMinimaAccettata = new Date(DateManager.getTimeMillis() - Configurazione.getScadenzaBusteDefault() * 60L * 1000L);
                if (this.busta.getOraRegistrazione() != null && this.busta.getOraRegistrazione().before(oraRegistrazioneMinimaAccettata)) {
                    this.log.error((Object)("OraRegistrazione portata nella busta (" + this.formatData(this.busta.getOraRegistrazione()) + ") pi\u00f9 vecchia della data minima attesa (" + this.formatData(oraRegistrazioneMinimaAccettata) + ") e scadenza non presente"));
                    Eccezione ecc4 = new Eccezione();
                    ecc4.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                    ecc4.setCodiceEccezione("EGOV_IT_301");
                    ecc4.setRilevanza("GRAVE");
                    ecc4.setPosizione("Messaggio/Scadenza");
                    this.erroriValidazione.add(ecc4);
                }
                if (this.busta.getID() != null && (split = this.busta.getID().split("_")) != null && split.length == 5) {
                    Date dataIntoIDEgov = null;
                    try {
                        SimpleDateFormat dateformat = new SimpleDateFormat("yyyy-MM-dd_HH:mm");
                        dataIntoIDEgov = dateformat.parse(split[3] + "_" + split[4]);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (dataIntoIDEgov != null && dataIntoIDEgov.before(oraRegistrazioneMinimaAccettata)) {
                        this.log.error((Object)("Data presente nell'idEgov della busta (" + this.formatData(dataIntoIDEgov) + ") pi\u00f9 vecchia della data minima attesa (" + this.formatData(oraRegistrazioneMinimaAccettata) + ") e scadenza non presente"));
                        Eccezione ecc5 = new Eccezione();
                        ecc5.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                        ecc5.setCodiceEccezione("EGOV_IT_301");
                        ecc5.setRilevanza("GRAVE");
                        ecc5.setPosizione("Messaggio/Scadenza");
                        this.erroriValidazione.add(ecc5);
                    }
                }
            }
            if (list.getLength() > 1) {
                boolean listaRiscontriGiaPresente = false;
                boolean listaTrasmissioniGiaPresente = false;
                boolean listaEccezioniGiaPresente = false;
                for (int i = 1; i < list.getLength(); ++i) {
                    Eccezione ecc6;
                    Node child = list.item(i);
                    if (SoapUtils.matchLocalName((Node)child, (String)"IntestazioneMessaggio", (String)xmlns, (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/")) {
                        if (!Configurazione.getConfigurazioneGenerazioneBusta().isGenerazioneBustaSPCoopErrore_strutturaHeaderNonCorretta()) {
                            throw new StrutturaEGovException("Header egov con pi\u00f9 di un elemento IntestazioneMessaggio", "IntestazioneMessaggio");
                        }
                        ecc6 = new Eccezione();
                        ecc6.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                        ecc6.setCodiceEccezione("EGOV_IT_002");
                        ecc6.setRilevanza("GRAVE");
                        if (this.segnalazioneElementoPresentePiuVolte) {
                            ecc6.setPosizione("IntestazioneMessaggio elemento presente pi\u00f9 volte nell'header");
                        } else {
                            ecc6.setPosizione("IntestazioneMessaggio");
                        }
                        this.erroriValidazione.add(ecc6);
                        continue;
                    }
                    if (SoapUtils.matchLocalName((Node)child, (String)"ListaRiscontri", (String)xmlns, (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/")) {
                        if (!listaRiscontriGiaPresente) {
                            this.validazioneListaRiscontri(child, xmlns);
                            listaRiscontriGiaPresente = true;
                            continue;
                        }
                        if (!Configurazione.getConfigurazioneGenerazioneBusta().isGenerazioneBustaSPCoopErrore_strutturaHeaderNonCorretta()) {
                            throw new StrutturaEGovException("Header egov con pi\u00f9 di un elemento ListaRiscontri", "ListaRiscontri");
                        }
                        ecc6 = new Eccezione();
                        ecc6.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                        ecc6.setCodiceEccezione("EGOV_IT_115");
                        ecc6.setRilevanza("GRAVE");
                        if (this.segnalazioneElementoPresentePiuVolte) {
                            ecc6.setPosizione("ListaRiscontri elemento presente pi\u00f9 volte nell'header");
                        } else {
                            ecc6.setPosizione("ListaRiscontri");
                        }
                        this.erroriValidazione.add(ecc6);
                        continue;
                    }
                    if (SoapUtils.matchLocalName((Node)child, (String)"ListaTrasmissioni", (String)xmlns, (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/")) {
                        if (!listaTrasmissioniGiaPresente) {
                            this.validazioneListaTrasmissioni(child, xmlns);
                            listaTrasmissioniGiaPresente = true;
                            continue;
                        }
                        if (!Configurazione.getConfigurazioneGenerazioneBusta().isGenerazioneBustaSPCoopErrore_strutturaHeaderNonCorretta()) {
                            throw new StrutturaEGovException("Header egov con pi\u00f9 di un elemento ListaTrasmissioni", "ListaTrasmissioni");
                        }
                        ecc6 = new Eccezione();
                        ecc6.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                        ecc6.setCodiceEccezione("EGOV_IT_116");
                        ecc6.setRilevanza("GRAVE");
                        if (this.segnalazioneElementoPresentePiuVolte) {
                            ecc6.setPosizione("ListaTrasmissioni elemento presente pi\u00f9 volte nell'header");
                        } else {
                            ecc6.setPosizione("ListaTrasmissioni");
                        }
                        this.erroriValidazione.add(ecc6);
                        continue;
                    }
                    if (SoapUtils.matchLocalName((Node)child, (String)"ListaEccezioni", (String)xmlns, (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/")) {
                        if (!listaEccezioniGiaPresente) {
                            this.validazioneListaEccezioni(child, xmlns);
                            listaEccezioniGiaPresente = true;
                            continue;
                        }
                        if (!Configurazione.getConfigurazioneGenerazioneBusta().isGenerazioneBustaSPCoopErrore_strutturaHeaderNonCorretta()) {
                            throw new StrutturaEGovException("Header egov con pi\u00f9 di un elemento ListaEccezioni", "ListaEccezioni");
                        }
                        ecc6 = new Eccezione();
                        ecc6.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                        ecc6.setCodiceEccezione("EGOV_IT_002");
                        ecc6.setRilevanza("GRAVE");
                        if (this.segnalazioneElementoPresentePiuVolte) {
                            ecc6.setPosizione("ListaEccezioni elemento presente pi\u00f9 volte nell'header");
                        } else {
                            ecc6.setPosizione("ListaEccezioni");
                        }
                        this.errorsTrovatiSullaListaEccezioni.add(ecc6);
                        continue;
                    }
                    ecc6 = new Eccezione();
                    ecc6.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                    ecc6.setCodiceEccezione("EGOV_IT_002");
                    ecc6.setRilevanza("GRAVE");
                    ecc6.setPosizione("Intestazione/child[" + child.getNodeName() + "]");
                    this.erroriValidazione.add(ecc6);
                }
            }
            if (Configurazione.isFiltraDateFuture() && this.erroriValidazione.size() == 0) {
                this.validazioneDatePresentiRispettoDateFuture();
            }
        }
        catch (StrutturaEGovException e) {
            this.log.error((Object)("Struttura della busta non corretta: " + e.getMessage()), (Throwable)e);
            this.msgErrore = e.getMessage();
            this.codiceErrore = "StrutturaErrata" + e.getCodice();
            return false;
        }
        catch (Exception e) {
            Eccezione ecc = new Eccezione();
            ecc.setContestoCodifica("ErroreProcessamentoMessaggioSPCoop");
            ecc.setCodiceEccezione("EGOV_IT_300");
            ecc.setRilevanza("GRAVE");
            ecc.setPosizione("Errore di processamento durante la validazione sintattica");
            this.erroriProcessamento.add(ecc);
            this.log.error((Object)"Errore di processamento durante la validazione sintattica", (Throwable)e);
        }
        return true;
    }

    public SOAPHeaderElement getHeaderEGov_senzaControlli() throws EGovException {
        try {
            SOAPHeaderElement headerElement;
            if (this.headerSOAP == null) {
                this.headerSOAP = (SOAPHeader)this.msg.getSOAPHeader();
            }
            if (this.headerSOAP == null) {
                throw new Exception("Analizzato un messaggio senza header");
            }
            Iterator it = this.headerSOAP.examineAllHeaderElements();
            SOAPHeaderElement headerElementEGov = null;
            while (it.hasNext()) {
                headerElement = (SOAPHeaderElement)it.next();
                if (!"http://www.cnipa.it/eGov_it/portadominio".equals(headerElement.getActor())) continue;
                headerElementEGov = headerElement;
            }
            if (headerElementEGov == null) {
                it = this.headerSOAP.examineAllHeaderElements();
                while (it.hasNext()) {
                    headerElement = (SOAPHeaderElement)it.next();
                    if (!"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/".equals(headerElement.getNamespaceURI())) continue;
                    headerElementEGov = headerElement;
                }
            }
            if (headerElementEGov == null) {
                throw new Exception("Header eGov non presente");
            }
            return headerElementEGov;
        }
        catch (Exception e) {
            throw new EGovException("Lettura non riuscita: " + e.getMessage(), e);
        }
    }

    public SOAPHeaderElement getHeaderEGov(javax.xml.soap.SOAPHeader header) throws EGovException, StrutturaEGovException {
        try {
            int i;
            SOAPHeaderElement headerElement;
            if (header == null) {
                return null;
            }
            Iterator it = header.examineAllHeaderElements();
            SOAPHeaderElement headerElementEGov = null;
            while (it.hasNext()) {
                headerElement = (SOAPHeaderElement)it.next();
                if (!"http://www.cnipa.it/eGov_it/portadominio".equals(headerElement.getActor())) continue;
                headerElementEGov = headerElement;
            }
            if (headerElementEGov == null) {
                it = header.examineAllHeaderElements();
                while (it.hasNext()) {
                    headerElement = (SOAPHeaderElement)it.next();
                    if (!"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/".equals(headerElement.getNamespaceURI())) continue;
                    headerElementEGov = headerElement;
                }
            }
            if (headerElementEGov == null) {
                throw new Exception("Header eGov non presente");
            }
            Busta errore = new Busta();
            errore.setTipoMittente(Configurazione.getConfigurazioneGenerazioneBusta().getKeywordTipoMittenteSconosciuto());
            errore.setMittente(Configurazione.getConfigurazioneGenerazioneBusta().getKeywordMittenteSconosciuto());
            errore.setTipoDestinatario(Configurazione.getConfigurazioneGenerazioneBusta().getKeywordTipoMittenteSconosciuto());
            errore.setDestinatario(Configurazione.getConfigurazioneGenerazioneBusta().getKeywordMittenteSconosciuto());
            if (this.existsMoreHeaderEGov()) {
                errore.addEccezione(Eccezione.getEccezioneValidazione("EGOV_IT_001", "Pi\u00f9 di un header e-Gov presente"));
                this.bustaErroreHeaderIntestazione = errore;
                throw new Exception("Pi\u00f9 di un header e-Gov presente");
            }
            String xmlns = headerElementEGov.getPrefix();
            if (xmlns == null) {
                xmlns = "";
            } else if (!xmlns.equals("")) {
                xmlns = xmlns + ":";
            }
            if (!SoapUtils.matchLocalName((Node)headerElementEGov, (String)"Intestazione", (String)xmlns, (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/")) {
                this.bustaErroreHeaderIntestazione = errore;
                this.bustaErroreHeaderIntestazione.addEccezione(Eccezione.getEccezioneValidazione("EGOV_IT_001", "Intestazione"));
                throw new Exception("Header eGov senza header intestazione");
            }
            NodeList list = headerElementEGov.getChildNodes();
            if (list == null || list.getLength() == 0) {
                this.bustaErroreHeaderIntestazione = errore;
                this.bustaErroreHeaderIntestazione.addEccezione(Eccezione.getEccezioneValidazione("EGOV_IT_002", "IntestazioneMessaggio"));
                throw new Exception("Header eGov con header intestazione senza elementi interni tra cui IntestazioneMessaggio");
            }
            Node intestazioneMsg = list.item(0);
            if (intestazioneMsg == null || !SoapUtils.matchLocalName((Node)intestazioneMsg, (String)"IntestazioneMessaggio", (String)xmlns, (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/")) {
                this.bustaErroreHeaderIntestazione = errore;
                this.bustaErroreHeaderIntestazione.addEccezione(Eccezione.getEccezioneValidazione("EGOV_IT_002", "IntestazioneMessaggio"));
                throw new Exception("Header eGov con header intestazione che possiede first child [" + intestazioneMsg.getNodeName() + "] diverso da IntestazioneMessaggio");
            }
            NodeList intestMsgChild = intestazioneMsg.getChildNodes();
            Node mittente = null;
            Node destinatario = null;
            Node messaggio = null;
            for (int i2 = 0; i2 < intestMsgChild.getLength(); ++i2) {
                Node child = intestMsgChild.item(i2);
                if (child == null) {
                    this.log.info((Object)"Elemento null");
                } else if (child.getNodeName() == null) {
                    this.log.info((Object)"Elemento child null");
                }
                if (child == null || child.getNodeName() == null) continue;
                if (mittente == null && SoapUtils.matchLocalName((Node)child, (String)"Mittente", (String)xmlns, (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/")) {
                    mittente = child;
                    continue;
                }
                if (destinatario == null && SoapUtils.matchLocalName((Node)child, (String)"Destinatario", (String)xmlns, (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/")) {
                    destinatario = child;
                    continue;
                }
                if (messaggio != null || !SoapUtils.matchLocalName((Node)child, (String)"Messaggio", (String)xmlns, (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/")) continue;
                messaggio = child;
            }
            boolean eccezioneStrutturaMittente = false;
            boolean eccezioneStrutturaDestinatario = false;
            boolean eccezioneStrutturaMessaggio = false;
            if (mittente == null) {
                errore.addEccezione(Eccezione.getEccezioneValidazione("EGOV_IT_101", "Mittente"));
                eccezioneStrutturaMittente = true;
            } else {
                NodeList headerMittente = mittente.getChildNodes();
                if (headerMittente == null || headerMittente.getLength() == 0) {
                    errore.addEccezione(Eccezione.getEccezioneValidazione("EGOV_IT_101", "Mittente/IdentificativoParte"));
                    eccezioneStrutturaMittente = true;
                } else {
                    for (i = 0; i < headerMittente.getLength(); ++i) {
                        String tipoMittente;
                        String mittenteValue;
                        block129: {
                            Node idParteMittente = headerMittente.item(i);
                            if (!SoapUtils.matchLocalName((Node)idParteMittente, (String)"IdentificativoParte", (String)xmlns, (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/")) {
                                errore.addEccezione(Eccezione.getEccezioneValidazione("EGOV_IT_101", "Mittente/IdentificativoParte"));
                                eccezioneStrutturaMittente = true;
                                break;
                            }
                            NodeList valueIDParteMitt = idParteMittente.getChildNodes();
                            if (valueIDParteMitt == null || valueIDParteMitt.getLength() == 0 || valueIDParteMitt.getLength() > 1) {
                                errore.addEccezione(Eccezione.getEccezioneValidazione("EGOV_IT_101", "Mittente/IdentificativoParte"));
                                eccezioneStrutturaMittente = false;
                                break;
                            }
                            mittenteValue = null;
                            try {
                                mittenteValue = valueIDParteMitt.item(0).getNodeValue();
                                if (mittenteValue == null) {
                                    throw new Exception("mittente is null");
                                }
                            }
                            catch (Exception e) {
                                errore.addEccezione(Eccezione.getEccezioneValidazione("EGOV_IT_101", "Mittente/IdentificativoParte"));
                                eccezioneStrutturaMittente = false;
                                break;
                            }
                            tipoMittente = null;
                            Node hrefFindMitt = null;
                            hrefFindMitt = this.readQualifiedAttribute ? SoapUtils.getQualifiedAttributeNode((Node)idParteMittente, (String)"tipo", (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/") : SoapUtils.getAttributeNode((Node)idParteMittente, (String)"tipo");
                            if (hrefFindMitt != null) {
                                try {
                                    tipoMittente = hrefFindMitt.getNodeValue();
                                    if (tipoMittente == null) {
                                        throw new Exception("tipo non definito");
                                    }
                                    break block129;
                                }
                                catch (Exception e) {
                                    errore.addEccezione(Eccezione.getEccezioneValidazione("EGOV_IT_101", "Mittente/IdentificativoParte/tipo"));
                                    eccezioneStrutturaMittente = true;
                                    break;
                                }
                            }
                            errore.addEccezione(Eccezione.getEccezioneValidazione("EGOV_IT_101", "Mittente/IdentificativoParte/tipo"));
                            eccezioneStrutturaMittente = true;
                            break;
                        }
                        if (i == 0) {
                            errore.setTipoMittente(tipoMittente);
                            errore.setMittente(mittenteValue);
                            continue;
                        }
                        errore.addEccezione(Eccezione.getEccezioneValidazione("EGOV_IT_101", "Mittente/IdentificativoParte"));
                        eccezioneStrutturaMittente = false;
                    }
                }
            }
            if (destinatario == null) {
                errore.addEccezione(Eccezione.getEccezioneValidazione("EGOV_IT_102", "Destinatario"));
                eccezioneStrutturaDestinatario = true;
            } else {
                NodeList headerDestinatario = destinatario.getChildNodes();
                if (headerDestinatario == null || headerDestinatario.getLength() == 0) {
                    errore.addEccezione(Eccezione.getEccezioneValidazione("EGOV_IT_102", "Destinatario/IdentificativoParte"));
                    eccezioneStrutturaDestinatario = true;
                } else {
                    for (i = 0; i < headerDestinatario.getLength(); ++i) {
                        String tipoDestinatario;
                        String destinatarioValue;
                        block130: {
                            Node idParteDestinatario = headerDestinatario.item(i);
                            if (!SoapUtils.matchLocalName((Node)idParteDestinatario, (String)"IdentificativoParte", (String)xmlns, (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/")) {
                                errore.addEccezione(Eccezione.getEccezioneValidazione("EGOV_IT_102", "Destinatario/IdentificativoParte"));
                                eccezioneStrutturaDestinatario = true;
                                break;
                            }
                            NodeList valueIDParteDest = idParteDestinatario.getChildNodes();
                            if (valueIDParteDest == null || valueIDParteDest.getLength() == 0 || valueIDParteDest.getLength() > 1) {
                                errore.addEccezione(Eccezione.getEccezioneValidazione("EGOV_IT_102", "Destinatario/IdentificativoParte"));
                                eccezioneStrutturaDestinatario = false;
                                break;
                            }
                            destinatarioValue = null;
                            try {
                                destinatarioValue = valueIDParteDest.item(0).getNodeValue();
                                if (destinatarioValue == null) {
                                    throw new Exception("destinatario is null");
                                }
                            }
                            catch (Exception e) {
                                errore.addEccezione(Eccezione.getEccezioneValidazione("EGOV_IT_102", "Destinatario/IdentificativoParte"));
                                eccezioneStrutturaDestinatario = false;
                                break;
                            }
                            tipoDestinatario = null;
                            Node hrefFindDest = null;
                            hrefFindDest = this.readQualifiedAttribute ? SoapUtils.getQualifiedAttributeNode((Node)idParteDestinatario, (String)"tipo", (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/") : SoapUtils.getAttributeNode((Node)idParteDestinatario, (String)"tipo");
                            if (hrefFindDest != null) {
                                try {
                                    tipoDestinatario = hrefFindDest.getNodeValue();
                                    if (tipoDestinatario == null) {
                                        throw new Exception("tipo non definito");
                                    }
                                    break block130;
                                }
                                catch (Exception e) {
                                    errore.addEccezione(Eccezione.getEccezioneValidazione("EGOV_IT_102", "Destinatario/IdentificativoParte/tipo"));
                                    eccezioneStrutturaDestinatario = true;
                                    break;
                                }
                            }
                            errore.addEccezione(Eccezione.getEccezioneValidazione("EGOV_IT_102", "Destinatario/IdentificativoParte/tipo"));
                            eccezioneStrutturaDestinatario = true;
                            break;
                        }
                        if (i == 0) {
                            errore.setTipoDestinatario(tipoDestinatario);
                            errore.setDestinatario(destinatarioValue);
                            continue;
                        }
                        errore.addEccezione(Eccezione.getEccezioneValidazione("EGOV_IT_102", "Destinatario/IdentificativoParte"));
                        eccezioneStrutturaDestinatario = false;
                    }
                }
            }
            if (messaggio == null) {
                errore.addEccezione(Eccezione.getEccezioneValidazione("EGOV_IT_002", "Messaggio"));
                eccezioneStrutturaMessaggio = true;
            } else {
                NodeList contenutoMsg = messaggio.getChildNodes();
                if (contenutoMsg.getLength() <= 0) {
                    errore.addEccezione(Eccezione.getEccezioneValidazione("EGOV_IT_107", "Messaggio/Identificatore"));
                    eccezioneStrutturaMessaggio = true;
                } else {
                    String identificatore = null;
                    boolean identificatoreTrovato = false;
                    for (int j = 0; j < contenutoMsg.getLength(); ++j) {
                        Node childMsg = contenutoMsg.item(j);
                        if (!SoapUtils.matchLocalName((Node)childMsg, (String)"Identificatore", (String)xmlns, (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/")) continue;
                        identificatoreTrovato = true;
                        if (childMsg.getChildNodes().getLength() != 1) {
                            errore.addEccezione(Eccezione.getEccezioneValidazione("EGOV_IT_107", "Messaggio/Identificatore"));
                            break;
                        }
                        try {
                            identificatore = childMsg.getChildNodes().item(0).getNodeValue();
                        }
                        catch (Exception e) {}
                        break;
                    }
                    if (!identificatoreTrovato) {
                        errore.addEccezione(Eccezione.getEccezioneValidazione("EGOV_IT_107", "Messaggio/Identificatore"));
                        eccezioneStrutturaMessaggio = true;
                    } else if (identificatore == null) {
                        errore.addEccezione(Eccezione.getEccezioneValidazione("EGOV_IT_107", "Messaggio/Identificatore"));
                        eccezioneStrutturaMessaggio = false;
                    } else {
                        errore.setID(identificatore);
                    }
                }
            }
            if (errore.sizeListaEccezioni() > 0) {
                String itValue;
                if (!Configurazione.getConfigurazioneGenerazioneBusta().isGenerazioneBustaSPCoopErrore_strutturaHeaderNonCorretta() && (eccezioneStrutturaMittente || eccezioneStrutturaDestinatario || eccezioneStrutturaMessaggio)) {
                    Eccezione ec = errore.getEccezione(0);
                    throw new StrutturaEGovException("Header egov con struttura errata, " + ec.getPosizione(), ec.getPosizione().replaceAll("/", ""));
                }
                Node servizio = null;
                Node azione = null;
                Node profiloCollaborazione = null;
                Node collaborazione = null;
                Node profiloTrasmissione = null;
                Node sequenza = null;
                for (int i3 = 0; i3 < intestMsgChild.getLength(); ++i3) {
                    Node child = intestMsgChild.item(i3);
                    if (mittente == null && SoapUtils.matchLocalName((Node)child, (String)"Mittente", (String)xmlns, (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/")) {
                        mittente = child;
                        continue;
                    }
                    if (destinatario == null && SoapUtils.matchLocalName((Node)child, (String)"Destinatario", (String)xmlns, (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/")) {
                        destinatario = child;
                        continue;
                    }
                    if (servizio == null && SoapUtils.matchLocalName((Node)child, (String)"Servizio", (String)xmlns, (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/")) {
                        servizio = child;
                        continue;
                    }
                    if (azione == null && SoapUtils.matchLocalName((Node)child, (String)"Azione", (String)xmlns, (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/")) {
                        azione = child;
                        continue;
                    }
                    if (profiloCollaborazione == null && SoapUtils.matchLocalName((Node)child, (String)"ProfiloCollaborazione", (String)xmlns, (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/")) {
                        profiloCollaborazione = child;
                        continue;
                    }
                    if (collaborazione == null && SoapUtils.matchLocalName((Node)child, (String)"Collaborazione", (String)xmlns, (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/")) {
                        collaborazione = child;
                        continue;
                    }
                    if (profiloTrasmissione == null && SoapUtils.matchLocalName((Node)child, (String)"ProfiloTrasmissione", (String)xmlns, (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/")) {
                        profiloTrasmissione = child;
                        continue;
                    }
                    if (sequenza != null || !SoapUtils.matchLocalName((Node)child, (String)"Sequenza", (String)xmlns, (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/")) continue;
                    sequenza = child;
                }
                if (mittente != null) {
                    Node hrefFindMitt;
                    Node idParteMittente;
                    NodeList headerMittente;
                    try {
                        headerMittente = mittente.getChildNodes();
                        idParteMittente = headerMittente.item(0);
                        errore.setMittente(idParteMittente.getChildNodes().item(0).getNodeValue());
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    try {
                        headerMittente = mittente.getChildNodes();
                        idParteMittente = headerMittente.item(0);
                        hrefFindMitt = null;
                        hrefFindMitt = this.readQualifiedAttribute ? SoapUtils.getQualifiedAttributeNode((Node)idParteMittente, (String)"tipo", (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/") : SoapUtils.getAttributeNode((Node)idParteMittente, (String)"tipo");
                        itValue = hrefFindMitt.getNodeValue();
                        errore.setTipoMittente(itValue);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    try {
                        headerMittente = mittente.getChildNodes();
                        idParteMittente = headerMittente.item(0);
                        hrefFindMitt = null;
                        hrefFindMitt = this.readQualifiedAttribute ? SoapUtils.getQualifiedAttributeNode((Node)idParteMittente, (String)"indirizzoTelematico", (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/") : SoapUtils.getAttributeNode((Node)idParteMittente, (String)"indirizzoTelematico");
                        itValue = hrefFindMitt.getNodeValue();
                        errore.setIndirizzoTelematicoMittente(itValue);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (destinatario != null) {
                    Node hrefFindDest;
                    Node idParteDest;
                    NodeList headerDest;
                    try {
                        headerDest = destinatario.getChildNodes();
                        idParteDest = headerDest.item(0);
                        errore.setDestinatario(idParteDest.getChildNodes().item(0).getNodeValue());
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    try {
                        headerDest = destinatario.getChildNodes();
                        idParteDest = headerDest.item(0);
                        hrefFindDest = null;
                        hrefFindDest = this.readQualifiedAttribute ? SoapUtils.getQualifiedAttributeNode((Node)idParteDest, (String)"tipo", (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/") : SoapUtils.getAttributeNode((Node)idParteDest, (String)"tipo");
                        itValue = hrefFindDest.getNodeValue();
                        errore.setTipoDestinatario(itValue);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    try {
                        headerDest = destinatario.getChildNodes();
                        idParteDest = headerDest.item(0);
                        hrefFindDest = null;
                        hrefFindDest = this.readQualifiedAttribute ? SoapUtils.getQualifiedAttributeNode((Node)idParteDest, (String)"indirizzoTelematico", (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/") : SoapUtils.getAttributeNode((Node)idParteDest, (String)"indirizzoTelematico");
                        itValue = hrefFindDest.getNodeValue();
                        errore.setIndirizzoTelematicoDestinatario(itValue);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (servizio != null) {
                    try {
                        errore.setServizio(servizio.getChildNodes().item(0).getNodeValue());
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    try {
                        Node hrefFind = null;
                        hrefFind = this.readQualifiedAttribute ? SoapUtils.getQualifiedAttributeNode((Node)servizio, (String)"tipo", (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/") : SoapUtils.getAttributeNode((Node)servizio, (String)"tipo");
                        errore.setTipoServizio(hrefFind.getNodeValue());
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (azione != null) {
                    try {
                        errore.setAzione(azione.getChildNodes().item(0).getNodeValue());
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (profiloCollaborazione != null) {
                    Node hrefFind;
                    try {
                        errore.setProfiloDiCollaborazione(profiloCollaborazione.getChildNodes().item(0).getNodeValue());
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    try {
                        hrefFind = null;
                        hrefFind = this.readQualifiedAttribute ? SoapUtils.getQualifiedAttributeNode((Node)profiloCollaborazione, (String)"tipo", (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/") : SoapUtils.getAttributeNode((Node)profiloCollaborazione, (String)"tipo");
                        errore.setTipoServizioCorrelato(hrefFind.getNodeValue());
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    try {
                        hrefFind = null;
                        hrefFind = this.readQualifiedAttribute ? SoapUtils.getQualifiedAttributeNode((Node)profiloCollaborazione, (String)"servizioCorrelato", (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/") : SoapUtils.getAttributeNode((Node)profiloCollaborazione, (String)"servizioCorrelato");
                        errore.setServizioCorrelato(hrefFind.getNodeValue());
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (collaborazione != null) {
                    try {
                        errore.setCollaborazione(collaborazione.getChildNodes().item(0).getNodeValue());
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (messaggio != null) {
                    try {
                        NodeList contenutoMsg = messaggio.getChildNodes();
                        for (int j = 0; j < contenutoMsg.getLength(); ++j) {
                            Node childMsg = contenutoMsg.item(j);
                            if (SoapUtils.matchLocalName((Node)childMsg, (String)"RiferimentoMessaggio", (String)xmlns, (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/")) {
                                try {
                                    errore.setRiferimentoMessaggio(childMsg.getChildNodes().item(0).getNodeValue());
                                }
                                catch (Exception e) {}
                                continue;
                            }
                            if (SoapUtils.matchLocalName((Node)childMsg, (String)"Scadenza", (String)xmlns, (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/")) {
                                try {
                                    String scadenza = childMsg.getChildNodes().item(0).getNodeValue();
                                    Date scadenzaDate = this.validazioneData(scadenza);
                                    errore.setScadenza(scadenzaDate);
                                }
                                catch (Exception e) {}
                                continue;
                            }
                            if (!SoapUtils.matchLocalName((Node)childMsg, (String)"OraRegistrazione", (String)xmlns, (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/")) continue;
                            try {
                                String oraRegistrazione = childMsg.getChildNodes().item(0).getNodeValue();
                                Date oraDate = this.validazioneData(oraRegistrazione);
                                errore.setOraRegistrazione(oraDate);
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                            try {
                                Node hrefFind = null;
                                hrefFind = this.readQualifiedAttribute ? SoapUtils.getQualifiedAttributeNode((Node)childMsg, (String)"tempo", (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/") : SoapUtils.getAttributeNode((Node)childMsg, (String)"tempo");
                                errore.setTipoOraRegistrazione(hrefFind.getNodeValue());
                                continue;
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (profiloTrasmissione != null) {
                    Node hrefFind;
                    try {
                        hrefFind = null;
                        hrefFind = this.readQualifiedAttribute ? SoapUtils.getQualifiedAttributeNode((Node)profiloTrasmissione, (String)"confermaRicezione", (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/") : SoapUtils.getAttributeNode(profiloTrasmissione, (String)"confermaRicezione");
                        if (hrefFind.getNodeValue().equals("true")) {
                            errore.setConfermaRicezione(true);
                        } else {
                            errore.setConfermaRicezione(false);
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    try {
                        hrefFind = null;
                        hrefFind = this.readQualifiedAttribute ? SoapUtils.getQualifiedAttributeNode((Node)profiloTrasmissione, (String)"inoltro", (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/") : SoapUtils.getAttributeNode((Node)profiloTrasmissione, (String)"inoltro");
                        errore.setInoltro(hrefFind.getNodeValue());
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (sequenza != null) {
                    try {
                        Node hrefFind = null;
                        hrefFind = this.readQualifiedAttribute ? SoapUtils.getQualifiedAttributeNode((Node)sequenza, (String)"numeroProgressivo", (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/") : SoapUtils.getAttributeNode(sequenza, (String)"numeroProgressivo");
                        Long test = new Long(hrefFind.getNodeValue());
                        errore.setSequenza(test);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                this.bustaErroreHeaderIntestazione = errore;
                throw new Exception("Header eGov senza alcuni elementi principali: presenza mittente[" + (mittente != null) + "] destinatario[" + (destinatario != null) + "] messaggio[" + (messaggio != null) + "] eccezioni-riscontrate: [" + errore.toStringListaEccezioni() + "]");
            }
            return headerElementEGov;
        }
        catch (StrutturaEGovException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EGovException("Lettura non riuscita: " + e.getMessage(), e);
        }
    }

    public boolean existsHeaderEGov() {
        try {
            SOAPHeaderElement headerElement;
            if (this.headerEGov != null) {
                return true;
            }
            if (this.headerSOAP == null) {
                this.headerSOAP = (SOAPHeader)this.msg.getSOAPHeader();
            }
            if (this.headerSOAP == null) {
                return false;
            }
            Iterator it = this.headerSOAP.examineAllHeaderElements();
            SOAPHeaderElement headerElementEGov = null;
            while (it.hasNext()) {
                headerElement = (SOAPHeaderElement)it.next();
                if (!"http://www.cnipa.it/eGov_it/portadominio".equals(headerElement.getActor())) continue;
                headerElementEGov = headerElement;
            }
            if (headerElementEGov == null) {
                it = this.headerSOAP.examineAllHeaderElements();
                while (it.hasNext()) {
                    headerElement = (SOAPHeaderElement)it.next();
                    if (!"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/".equals(headerElement.getNamespaceURI())) continue;
                    headerElementEGov = headerElement;
                }
            }
            return headerElementEGov != null;
        }
        catch (Exception e) {
            this.log.error((Object)("existsHeaderEGov error: " + e.getMessage()));
            return false;
        }
    }

    public boolean existsMoreHeaderEGov() {
        try {
            SOAPHeaderElement headerElement;
            if (this.headerSOAP == null) {
                this.headerSOAP = (SOAPHeader)this.msg.getSOAPHeader();
            }
            if (this.headerSOAP == null) {
                return false;
            }
            boolean headerGiaTrovato = false;
            Iterator it = this.headerSOAP.examineAllHeaderElements();
            while (it.hasNext()) {
                headerElement = (SOAPHeaderElement)it.next();
                if (!"http://www.cnipa.it/eGov_it/portadominio".equals(headerElement.getActor())) continue;
                if (headerGiaTrovato) {
                    return true;
                }
                headerGiaTrovato = true;
            }
            if (!headerGiaTrovato) {
                it = this.headerSOAP.examineAllHeaderElements();
                while (it.hasNext()) {
                    headerElement = (SOAPHeaderElement)it.next();
                    if (!"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/".equals(headerElement.getNamespaceURI())) continue;
                    if (headerGiaTrovato) {
                        return true;
                    }
                    headerGiaTrovato = true;
                }
            }
            return false;
        }
        catch (Exception e) {
            this.log.error((Object)("existsMoreHeaderEGov error: " + e.getMessage()));
            return false;
        }
    }

    public String getPrefix() {
        String xmlns = this.headerEGov.getPrefix();
        if (xmlns == null) {
            xmlns = "";
        }
        if (!xmlns.equals("")) {
            xmlns = xmlns + ":";
        }
        return xmlns;
    }

    private void validazioneMittente(Node child, String prefix) {
        NodeList headerMittente = child.getChildNodes();
        Node idParte = headerMittente.item(0);
        NodeList valueIDParte = idParte.getChildNodes();
        String value = valueIDParte.item(0).getNodeValue();
        Node hrefFind = null;
        hrefFind = this.readQualifiedAttribute ? SoapUtils.getQualifiedAttributeNode((Node)idParte, (String)"tipo", (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/") : SoapUtils.getAttributeNode((Node)idParte, (String)"tipo");
        String tipo = hrefFind.getNodeValue();
        if (!Configurazione.getTipiSoggettiValidi().contains(tipo)) {
            Eccezione ecc = new Eccezione();
            ecc.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
            ecc.setCodiceEccezione("EGOV_IT_101");
            ecc.setRilevanza("GRAVE");
            ecc.setPosizione("Mittente/IdentificativoParte/tipo");
            this.erroriValidazione.add(ecc);
        }
        this.busta.setTipoMittente(tipo);
        this.busta.setMittente(value);
        String indTelematico = null;
        try {
            Node hrefFindT = null;
            hrefFindT = this.readQualifiedAttribute ? SoapUtils.getQualifiedAttributeNode((Node)idParte, (String)"indirizzoTelematico", (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/") : SoapUtils.getAttributeNode((Node)idParte, (String)"indirizzoTelematico");
            if (hrefFindT != null) {
                indTelematico = hrefFindT.getNodeValue();
            }
        }
        catch (Exception e) {
            Eccezione ecc = new Eccezione();
            ecc.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
            ecc.setCodiceEccezione("EGOV_IT_101");
            ecc.setRilevanza("GRAVE");
            ecc.setPosizione("Mittente/IdentificativoParte/indirizzoTelematico");
            this.erroriValidazione.add(ecc);
        }
        if (indTelematico != null && !indTelematico.equals("")) {
            URL urlCheck = null;
            try {
                urlCheck = new URL(indTelematico);
                this.busta.setIndirizzoTelematicoMittente(urlCheck.toString());
            }
            catch (Exception e) {
                Eccezione ecc = new Eccezione();
                ecc.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                ecc.setCodiceEccezione("EGOV_IT_101");
                ecc.setRilevanza("GRAVE");
                ecc.setPosizione("Mittente/IdentificativoParte/indirizzoTelematico");
                this.erroriValidazione.add(ecc);
            }
        }
    }

    private void validazioneDestinatario(Node child, String prefix) {
        NodeList headerDestinatario = child.getChildNodes();
        Node idParte = headerDestinatario.item(0);
        NodeList valueIDParte = idParte.getChildNodes();
        String value = valueIDParte.item(0).getNodeValue();
        Node hrefFind = null;
        hrefFind = this.readQualifiedAttribute ? SoapUtils.getQualifiedAttributeNode((Node)idParte, (String)"tipo", (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/") : SoapUtils.getAttributeNode((Node)idParte, (String)"tipo");
        String tipo = hrefFind.getNodeValue();
        if (!Configurazione.getTipiSoggettiValidi().contains(tipo)) {
            Eccezione ecc = new Eccezione();
            ecc.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
            ecc.setCodiceEccezione("EGOV_IT_102");
            ecc.setRilevanza("GRAVE");
            ecc.setPosizione("Destinatario/IdentificativoParte/tipo");
            this.erroriValidazione.add(ecc);
        }
        this.busta.setTipoDestinatario(tipo);
        this.busta.setDestinatario(value);
        String indTelematico = null;
        try {
            Node hrefFindT = null;
            hrefFindT = this.readQualifiedAttribute ? SoapUtils.getQualifiedAttributeNode((Node)idParte, (String)"indirizzoTelematico", (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/") : SoapUtils.getAttributeNode((Node)idParte, (String)"indirizzoTelematico");
            if (hrefFindT != null) {
                indTelematico = hrefFindT.getNodeValue();
            }
        }
        catch (Exception e) {
            Eccezione ecc = new Eccezione();
            ecc.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
            ecc.setCodiceEccezione("EGOV_IT_102");
            ecc.setRilevanza("GRAVE");
            ecc.setPosizione("Destinatario/IdentificativoParte/indirizzoTelematico");
            this.erroriValidazione.add(ecc);
        }
        if (indTelematico != null && !indTelematico.equals("")) {
            URL urlcheck = null;
            try {
                urlcheck = new URL(indTelematico);
                this.busta.setIndirizzoTelematicoDestinatario(urlcheck.toString());
            }
            catch (Exception e) {
                Eccezione ecc = new Eccezione();
                ecc.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                ecc.setCodiceEccezione("EGOV_IT_102");
                ecc.setRilevanza("GRAVE");
                ecc.setPosizione("Destinatario/IdentificativoParte/indirizzoTelematico");
                this.erroriValidazione.add(ecc);
            }
        }
    }

    private void validazioneProfiloCollaborazione(Node child, String prefix) {
        Eccezione ecc;
        Eccezione ecc2;
        Eccezione ecc3;
        String profilo = null;
        NodeList valueProfiloDiCollaborazione = child.getChildNodes();
        if (valueProfiloDiCollaborazione.getLength() == 0 || valueProfiloDiCollaborazione.getLength() > 1) {
            ecc3 = new Eccezione();
            ecc3.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
            ecc3.setCodiceEccezione("EGOV_IT_103");
            ecc3.setRilevanza("GRAVE");
            ecc3.setPosizione("ProfiloCollaborazione");
            this.erroriValidazione.add(ecc3);
        } else {
            try {
                profilo = valueProfiloDiCollaborazione.item(0).getNodeValue();
                if (!(profilo.equals("EGOV_IT_MessaggioSingoloOneWay") || profilo.equals("EGOV_IT_ServizioSincrono") || profilo.equals("EGOV_IT_ServizioAsincronoSimmetrico") || profilo.equals("EGOV_IT_ServizioAsincronoAsimmetrico"))) {
                    ecc3 = new Eccezione();
                    ecc3.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                    ecc3.setCodiceEccezione("EGOV_IT_103");
                    ecc3.setRilevanza("GRAVE");
                    ecc3.setPosizione("ProfiloCollaborazione");
                    this.erroriValidazione.add(ecc3);
                }
                this.busta.setProfiloDiCollaborazione(profilo);
            }
            catch (Exception e) {
                ecc2 = new Eccezione();
                ecc2.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                ecc2.setCodiceEccezione("EGOV_IT_103");
                ecc2.setRilevanza("GRAVE");
                ecc2.setPosizione("ProfiloCollaborazione");
                this.erroriValidazione.add(ecc2);
            }
        }
        String tipo = null;
        try {
            Node hrefFind = null;
            hrefFind = this.readQualifiedAttribute ? SoapUtils.getQualifiedAttributeNode((Node)child, (String)"tipo", (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/") : SoapUtils.getAttributeNode((Node)child, (String)"tipo");
            if (hrefFind != null) {
                tipo = hrefFind.getNodeValue();
            }
        }
        catch (Exception e) {
            ecc = new Eccezione();
            ecc.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
            ecc.setCodiceEccezione("EGOV_IT_103");
            ecc.setRilevanza("GRAVE");
            ecc.setPosizione("ProfiloCollaborazione/tipo");
            this.erroriValidazione.add(ecc);
        }
        if (tipo != null && !Configurazione.getTipiServiziValidi().contains(tipo)) {
            ecc2 = new Eccezione();
            ecc2.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
            ecc2.setCodiceEccezione("EGOV_IT_103");
            ecc2.setRilevanza("GRAVE");
            ecc2.setPosizione("ProfiloCollaborazione/tipo");
            this.erroriValidazione.add(ecc2);
        }
        String servizioCorrelato = null;
        try {
            Node hrefFind = null;
            hrefFind = this.readQualifiedAttribute ? SoapUtils.getQualifiedAttributeNode((Node)child, (String)"servizioCorrelato", (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/") : SoapUtils.getAttributeNode((Node)child, (String)"servizioCorrelato");
            if (hrefFind != null) {
                servizioCorrelato = hrefFind.getNodeValue();
            }
        }
        catch (Exception e) {
            Eccezione ecc4 = new Eccezione();
            ecc4.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
            ecc4.setCodiceEccezione("EGOV_IT_103");
            ecc4.setRilevanza("GRAVE");
            ecc4.setPosizione("ProfiloCollaborazione/servizioCorrelato");
            this.erroriValidazione.add(ecc4);
        }
        this.busta.setTipoServizioCorrelato(tipo);
        this.busta.setServizioCorrelato(servizioCorrelato);
        if (servizioCorrelato != null && (profilo.equals("EGOV_IT_MessaggioSingoloOneWay") || profilo.equals("EGOV_IT_ServizioSincrono"))) {
            ecc = new Eccezione();
            ecc.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
            ecc.setCodiceEccezione("EGOV_IT_103");
            ecc.setRilevanza("GRAVE");
            ecc.setPosizione("ProfiloCollaborazione/servizioCorrelato");
            this.erroriValidazione.add(ecc);
        }
        if (tipo != null && Configurazione.getTipiServiziValidi().contains(tipo) && (profilo.equals("EGOV_IT_MessaggioSingoloOneWay") || profilo.equals("EGOV_IT_ServizioSincrono"))) {
            ecc = new Eccezione();
            ecc.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
            ecc.setCodiceEccezione("EGOV_IT_103");
            ecc.setRilevanza("GRAVE");
            ecc.setPosizione("ProfiloCollaborazione/tipo");
            this.erroriValidazione.add(ecc);
        }
    }

    private void validazioneCollaborazione(Node child) {
        if (child.getChildNodes().getLength() != 1) {
            Eccezione ecc = new Eccezione();
            ecc.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
            ecc.setCodiceEccezione("EGOV_IT_104");
            ecc.setRilevanza("GRAVE");
            ecc.setPosizione("Collaborazione");
            this.erroriValidazione.add(ecc);
            return;
        }
        String coll = null;
        try {
            coll = child.getChildNodes().item(0).getNodeValue();
        }
        catch (Exception e) {
            Eccezione ecc = new Eccezione();
            ecc.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
            ecc.setCodiceEccezione("EGOV_IT_104");
            ecc.setRilevanza("GRAVE");
            ecc.setPosizione("Collaborazione");
            this.erroriValidazione.add(ecc);
        }
        this.busta.setCollaborazione(coll);
    }

    private void validazioneServizio(Node child, String prefix) throws StrutturaEGovException {
        if (child.getChildNodes().getLength() != 1) {
            Eccezione ecc = new Eccezione();
            ecc.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
            ecc.setCodiceEccezione("EGOV_IT_105");
            ecc.setRilevanza("GRAVE");
            ecc.setPosizione("Servizio");
            this.erroriValidazione.add(ecc);
            return;
        }
        String serv = null;
        try {
            serv = child.getChildNodes().item(0).getNodeValue();
        }
        catch (Exception e) {
            Eccezione ecc = new Eccezione();
            ecc.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
            ecc.setCodiceEccezione("EGOV_IT_105");
            ecc.setRilevanza("GRAVE");
            ecc.setPosizione("Servizio");
            this.erroriValidazione.add(ecc);
        }
        this.busta.setServizio(serv);
        String tipo = null;
        try {
            Node hrefFind = null;
            hrefFind = this.readQualifiedAttribute ? SoapUtils.getQualifiedAttributeNode((Node)child, (String)"tipo", (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/") : SoapUtils.getAttributeNode((Node)child, (String)"tipo");
            if (hrefFind != null) {
                tipo = hrefFind.getNodeValue();
            }
            if (tipo == null) {
                if (!Configurazione.getConfigurazioneGenerazioneBusta().isGenerazioneBustaSPCoopErrore_strutturaHeaderNonCorretta()) {
                    throw new StrutturaEGovException("Header egov con elemento Servizio senza tipo", "Servizio");
                }
                Eccezione ecc = new Eccezione();
                ecc.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                ecc.setCodiceEccezione("EGOV_IT_105");
                ecc.setRilevanza("GRAVE");
                ecc.setPosizione("Servizio/tipo");
                this.erroriValidazione.add(ecc);
            } else if (!Configurazione.getTipiServiziValidi().contains(tipo)) {
                Eccezione ecc = new Eccezione();
                ecc.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                ecc.setCodiceEccezione("EGOV_IT_105");
                ecc.setRilevanza("GRAVE");
                ecc.setPosizione("Servizio/tipo");
                this.erroriValidazione.add(ecc);
            }
        }
        catch (StrutturaEGovException e) {
            throw e;
        }
        catch (Exception e) {
            Eccezione ecc = new Eccezione();
            ecc.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
            ecc.setCodiceEccezione("EGOV_IT_105");
            ecc.setRilevanza("GRAVE");
            ecc.setPosizione("Servizio/tipo");
            this.erroriValidazione.add(ecc);
        }
        this.busta.setTipoServizio(tipo);
    }

    private void validazioneAzione(Node child) {
        if (child.getChildNodes().getLength() != 1) {
            Eccezione ecc = new Eccezione();
            ecc.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
            ecc.setCodiceEccezione("EGOV_IT_106");
            ecc.setRilevanza("GRAVE");
            ecc.setPosizione("Azione");
            this.erroriValidazione.add(ecc);
            return;
        }
        String azione = null;
        try {
            azione = child.getChildNodes().item(0).getNodeValue();
        }
        catch (Exception e) {
            Eccezione ecc = new Eccezione();
            ecc.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
            ecc.setCodiceEccezione("EGOV_IT_106");
            ecc.setRilevanza("GRAVE");
            ecc.setPosizione("Azione");
            this.erroriValidazione.add(ecc);
        }
        this.busta.setAzione(azione);
    }

    private void validazioneMessaggio(Node child, String prefix) throws StrutturaEGovException {
        String xmlns = this.getPrefix();
        NodeList contenutoMsg = child.getChildNodes();
        if (contenutoMsg.getLength() == 0 || contenutoMsg.getLength() > 4) {
            Eccezione ecc = new Eccezione();
            ecc.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
            ecc.setCodiceEccezione("EGOV_IT_002");
            ecc.setRilevanza("GRAVE");
            ecc.setPosizione("IntestazioneMessaggio/Messaggio childsize:" + contenutoMsg.getLength());
            this.erroriValidazione.add(ecc);
        }
        boolean presenzaID = false;
        boolean presenzaOra = false;
        boolean presenzaScadenza = false;
        boolean presenzaRifMessaggio = false;
        for (int j = 0; j < contenutoMsg.getLength(); ++j) {
            Eccezione ecc;
            Eccezione ecc2;
            Eccezione ecc3;
            Node childMsg = contenutoMsg.item(j);
            if (SoapUtils.matchLocalName((Node)childMsg, (String)"Identificatore", (String)xmlns, (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/")) {
                if (presenzaID) {
                    if (!Configurazione.getConfigurazioneGenerazioneBusta().isGenerazioneBustaSPCoopErrore_strutturaHeaderNonCorretta()) {
                        throw new StrutturaEGovException("Header egov con pi\u00f9 di un elemento Identificatore", "MessaggioIdentificatore");
                    }
                    ecc3 = new Eccezione();
                    ecc3.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                    ecc3.setCodiceEccezione("EGOV_IT_107");
                    ecc3.setRilevanza("GRAVE");
                    if (this.segnalazioneElementoPresentePiuVolte) {
                        ecc3.setPosizione("Messaggio/Identificatore elemento presente pi\u00f9 volte nell'header");
                    } else {
                        ecc3.setPosizione("Messaggio/Identificatore");
                    }
                    this.erroriValidazione.add(ecc3);
                    continue;
                }
                presenzaID = true;
                if (childMsg.getChildNodes().getLength() != 1) {
                    ecc3 = new Eccezione();
                    ecc3.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                    ecc3.setCodiceEccezione("EGOV_IT_107");
                    ecc3.setRilevanza("GRAVE");
                    ecc3.setPosizione("Messaggio/Identificatore");
                    this.erroriValidazione.add(ecc3);
                    continue;
                }
                String id = null;
                try {
                    id = childMsg.getChildNodes().item(0).getNodeValue();
                }
                catch (Exception e) {
                    ecc2 = new Eccezione();
                    ecc2.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                    ecc2.setCodiceEccezione("EGOV_IT_107");
                    ecc2.setRilevanza("GRAVE");
                    ecc2.setPosizione("Messaggio/Identificatore");
                    this.erroriValidazione.add(ecc2);
                }
                if (id == null) {
                    ecc = new Eccezione();
                    ecc.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                    ecc.setCodiceEccezione("EGOV_IT_107");
                    ecc.setRilevanza("GRAVE");
                    ecc.setPosizione("Messaggio/Identificatore");
                    this.erroriValidazione.add(ecc);
                }
                this.busta.setID(id);
                continue;
            }
            if (SoapUtils.matchLocalName((Node)childMsg, (String)"OraRegistrazione", (String)xmlns, (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/")) {
                if (presenzaOra) {
                    if (!Configurazione.getConfigurazioneGenerazioneBusta().isGenerazioneBustaSPCoopErrore_strutturaHeaderNonCorretta()) {
                        throw new StrutturaEGovException("Header egov con pi\u00f9 di un elemento OraRegistrazione", "MessaggioOraRegistrazione");
                    }
                    ecc3 = new Eccezione();
                    ecc3.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                    ecc3.setCodiceEccezione("EGOV_IT_108");
                    ecc3.setRilevanza("GRAVE");
                    if (this.segnalazioneElementoPresentePiuVolte) {
                        ecc3.setPosizione("Messaggio/OraRegistrazione elemento presente pi\u00f9 volte nell'header");
                    } else {
                        ecc3.setPosizione("Messaggio/OraRegistrazione");
                    }
                    this.erroriValidazione.add(ecc3);
                    continue;
                }
                presenzaOra = true;
                if (childMsg.getChildNodes().getLength() != 1) {
                    ecc3 = new Eccezione();
                    ecc3.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                    ecc3.setCodiceEccezione("EGOV_IT_108");
                    ecc3.setRilevanza("GRAVE");
                    ecc3.setPosizione("Messaggio/OraRegistrazione");
                    this.erroriValidazione.add(ecc3);
                    continue;
                }
                String ora = null;
                try {
                    ora = childMsg.getChildNodes().item(0).getNodeValue();
                }
                catch (Exception e) {
                    ecc2 = new Eccezione();
                    ecc2.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                    ecc2.setCodiceEccezione("EGOV_IT_108");
                    ecc2.setRilevanza("GRAVE");
                    ecc2.setPosizione("Messaggio/OraRegistrazione");
                    this.erroriValidazione.add(ecc2);
                    continue;
                }
                Date oraDate = null;
                if (ora != null) {
                    oraDate = this.validazioneData(ora);
                }
                if (ora == null || oraDate == null) {
                    ecc2 = new Eccezione();
                    ecc2.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                    ecc2.setCodiceEccezione("EGOV_IT_108");
                    ecc2.setRilevanza("GRAVE");
                    ecc2.setPosizione("Messaggio/OraRegistrazione");
                    this.erroriValidazione.add(ecc2);
                }
                this.busta.setOraRegistrazione(oraDate);
                String tipoOra = null;
                try {
                    Node hrefFind = null;
                    hrefFind = this.readQualifiedAttribute ? SoapUtils.getQualifiedAttributeNode((Node)childMsg, (String)"tempo", (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/") : SoapUtils.getAttributeNode((Node)childMsg, (String)"tempo");
                    tipoOra = hrefFind.getNodeValue();
                }
                catch (Exception e) {
                    if (!Configurazione.getConfigurazioneGenerazioneBusta().isGenerazioneBustaSPCoopErrore_strutturaHeaderNonCorretta()) {
                        throw new StrutturaEGovException("Header egov senza elemento OraRegistrazione tempo", "OraRegistrazioneTempo");
                    }
                    Eccezione ecc4 = new Eccezione();
                    ecc4.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                    ecc4.setCodiceEccezione("EGOV_IT_108");
                    ecc4.setRilevanza("GRAVE");
                    ecc4.setPosizione("Messaggio/OraRegistrazione/tempo");
                    this.erroriValidazione.add(ecc4);
                }
                if (tipoOra != null && !tipoOra.equals("EGOV_IT_Locale") && !tipoOra.equals("EGOV_IT_SPC")) {
                    Eccezione ecc5 = new Eccezione();
                    ecc5.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                    ecc5.setCodiceEccezione("EGOV_IT_108");
                    ecc5.setRilevanza("GRAVE");
                    ecc5.setPosizione("Messaggio/OraRegistrazione/tempo");
                    this.erroriValidazione.add(ecc5);
                }
                this.busta.setTipoOraRegistrazione(tipoOra);
                continue;
            }
            if (SoapUtils.matchLocalName((Node)childMsg, (String)"RiferimentoMessaggio", (String)xmlns, (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/")) {
                if (presenzaRifMessaggio) {
                    if (!Configurazione.getConfigurazioneGenerazioneBusta().isGenerazioneBustaSPCoopErrore_strutturaHeaderNonCorretta()) {
                        throw new StrutturaEGovException("Header egov con pi\u00f9 di un elemento RiferimentoMessaggio", "MessaggioRiferimentoMessaggio");
                    }
                    ecc3 = new Eccezione();
                    ecc3.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                    ecc3.setCodiceEccezione("EGOV_IT_109");
                    ecc3.setRilevanza("GRAVE");
                    if (this.segnalazioneElementoPresentePiuVolte) {
                        ecc3.setPosizione("Messaggio/RiferimentoMessaggio elemento presente pi\u00f9 volte nell'header");
                    } else {
                        ecc3.setPosizione("Messaggio/RiferimentoMessaggio");
                    }
                    this.erroriValidazione.add(ecc3);
                    continue;
                }
                presenzaRifMessaggio = true;
                if (childMsg.getChildNodes().getLength() != 1) {
                    ecc3 = new Eccezione();
                    ecc3.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                    ecc3.setCodiceEccezione("EGOV_IT_109");
                    ecc3.setRilevanza("GRAVE");
                    ecc3.setPosizione("Messaggio/RiferimentoMessaggio");
                    this.erroriValidazione.add(ecc3);
                    continue;
                }
                String rifID = null;
                try {
                    rifID = childMsg.getChildNodes().item(0).getNodeValue();
                }
                catch (Exception e) {
                    ecc2 = new Eccezione();
                    ecc2.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                    ecc2.setCodiceEccezione("EGOV_IT_109");
                    ecc2.setRilevanza("GRAVE");
                    ecc2.setPosizione("Messaggio/RiferimentoMessaggio");
                    this.erroriValidazione.add(ecc2);
                }
                if (rifID == null) {
                    ecc = new Eccezione();
                    ecc.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                    ecc.setCodiceEccezione("EGOV_IT_109");
                    ecc.setRilevanza("GRAVE");
                    ecc.setPosizione("Messaggio/RiferimentoMessaggio");
                    this.erroriValidazione.add(ecc);
                }
                this.busta.setRiferimentoMessaggio(rifID);
                continue;
            }
            if (SoapUtils.matchLocalName((Node)childMsg, (String)"Scadenza", (String)xmlns, (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/")) {
                if (presenzaScadenza) {
                    if (!Configurazione.getConfigurazioneGenerazioneBusta().isGenerazioneBustaSPCoopErrore_strutturaHeaderNonCorretta()) {
                        throw new StrutturaEGovException("Header egov con pi\u00f9 di un elemento Scadenza", "MessaggioScadenza");
                    }
                    ecc3 = new Eccezione();
                    ecc3.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                    ecc3.setCodiceEccezione("EGOV_IT_112");
                    ecc3.setRilevanza("GRAVE");
                    if (this.segnalazioneElementoPresentePiuVolte) {
                        ecc3.setPosizione("Messaggio/Scadenza elemento presente pi\u00f9 volte nell'header");
                    } else {
                        ecc3.setPosizione("Messaggio/Scadenza");
                    }
                    this.erroriValidazione.add(ecc3);
                    continue;
                }
                presenzaScadenza = true;
                if (childMsg.getChildNodes().getLength() != 1) {
                    ecc3 = new Eccezione();
                    ecc3.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                    ecc3.setCodiceEccezione("EGOV_IT_112");
                    ecc3.setRilevanza("GRAVE");
                    ecc3.setPosizione("Messaggio/Scadenza");
                    this.erroriValidazione.add(ecc3);
                    continue;
                }
                String scadenza = null;
                try {
                    scadenza = childMsg.getChildNodes().item(0).getNodeValue();
                }
                catch (Exception e) {
                    ecc2 = new Eccezione();
                    ecc2.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                    ecc2.setCodiceEccezione("EGOV_IT_112");
                    ecc2.setRilevanza("GRAVE");
                    ecc2.setPosizione("Messaggio/Scadenza");
                    this.erroriValidazione.add(ecc2);
                    continue;
                }
                Date scadenzaDate = null;
                if (scadenza != null) {
                    scadenzaDate = this.validazioneData(scadenza);
                }
                if (scadenza == null || scadenzaDate == null) {
                    ecc2 = new Eccezione();
                    ecc2.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                    ecc2.setCodiceEccezione("EGOV_IT_112");
                    ecc2.setRilevanza("GRAVE");
                    ecc2.setPosizione("Messaggio/Scadenza");
                    this.erroriValidazione.add(ecc2);
                    continue;
                }
                if (this.dataScaduta(scadenza)) {
                    this.messaggioScaduto = true;
                    ecc2 = new Eccezione();
                    ecc2.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                    ecc2.setCodiceEccezione("EGOV_IT_301");
                    ecc2.setRilevanza("GRAVE");
                    ecc2.setPosizione("Messaggio/Scadenza");
                    this.erroriValidazione.add(ecc2);
                }
                this.busta.setScadenza(scadenzaDate);
                continue;
            }
            ecc3 = new Eccezione();
            ecc3.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
            ecc3.setCodiceEccezione("EGOV_IT_002");
            ecc3.setRilevanza("GRAVE");
            ecc3.setPosizione("IntestazioneMessaggio/Messaggio/child[" + childMsg.getNodeName() + "]");
            this.erroriValidazione.add(ecc3);
        }
        if (!presenzaID) {
            Eccezione ecc = new Eccezione();
            ecc.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
            ecc.setCodiceEccezione("EGOV_IT_107");
            ecc.setRilevanza("GRAVE");
            ecc.setPosizione("Messaggio/Identificatore");
            this.erroriValidazione.add(ecc);
        }
        if (!presenzaOra) {
            Eccezione ecc = new Eccezione();
            ecc.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
            ecc.setCodiceEccezione("EGOV_IT_108");
            ecc.setRilevanza("GRAVE");
            ecc.setPosizione("Messaggio/OraRegistrazione");
            this.erroriValidazione.add(ecc);
        }
    }

    private void validazioneProfiloTrasmissione(Node child, String prefix) {
        Eccezione ecc;
        Node hrefFind;
        if (child.getChildNodes().getLength() != 0) {
            Eccezione ecc2 = new Eccezione();
            ecc2.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
            ecc2.setCodiceEccezione("EGOV_IT_113");
            ecc2.setRilevanza("GRAVE");
            ecc2.setPosizione("ProfiloTrasmissione child size:" + child.getChildNodes().getLength());
            this.erroriValidazione.add(ecc2);
        }
        String inoltro = null;
        String confermaRicezione = null;
        try {
            hrefFind = null;
            hrefFind = this.readQualifiedAttribute ? SoapUtils.getQualifiedAttributeNode((Node)child, (String)"inoltro", (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/") : SoapUtils.getAttributeNode((Node)child, (String)"inoltro");
            inoltro = hrefFind.getNodeValue();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            hrefFind = null;
            hrefFind = this.readQualifiedAttribute ? SoapUtils.getQualifiedAttributeNode((Node)child, (String)"confermaRicezione", (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/") : SoapUtils.getAttributeNode((Node)child, (String)"confermaRicezione");
            confermaRicezione = hrefFind.getNodeValue();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (inoltro == null) {
            inoltro = "EGOV_IT_PIUDIUNAVOLTA";
        } else if (!inoltro.equals("EGOV_IT_ALPIUUNAVOLTA") && !inoltro.equals("EGOV_IT_PIUDIUNAVOLTA")) {
            ecc = new Eccezione();
            ecc.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
            ecc.setCodiceEccezione("EGOV_IT_113");
            ecc.setRilevanza("GRAVE");
            ecc.setPosizione("ProfiloTrasmissione/inoltro");
            this.erroriValidazione.add(ecc);
        }
        if (confermaRicezione == null) {
            confermaRicezione = "false";
        } else if (!confermaRicezione.equals("true") && !confermaRicezione.equals("false")) {
            ecc = new Eccezione();
            ecc.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
            ecc.setCodiceEccezione("EGOV_IT_113");
            ecc.setRilevanza("GRAVE");
            ecc.setPosizione("ProfiloTrasmissione/confermaRicezione");
            this.erroriValidazione.add(ecc);
        }
        this.busta.setInoltro(inoltro);
        if (confermaRicezione.equals("true")) {
            this.busta.setConfermaRicezione(true);
        } else {
            this.busta.setConfermaRicezione(false);
        }
    }

    private void validazioneSequenza(Node child, String prefix) throws StrutturaEGovException {
        if (child.getChildNodes().getLength() != 0) {
            Eccezione ecc = new Eccezione();
            ecc.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
            ecc.setCodiceEccezione("EGOV_IT_114");
            ecc.setRilevanza("GRAVE");
            ecc.setPosizione("Sequenza");
            this.erroriValidazione.add(ecc);
        }
        String seq = null;
        try {
            Node hrefFind = null;
            hrefFind = this.readQualifiedAttribute ? SoapUtils.getQualifiedAttributeNode((Node)child, (String)"numeroProgressivo", (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/") : SoapUtils.getAttributeNode((Node)child, (String)"numeroProgressivo");
            seq = hrefFind.getNodeValue();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (seq == null) {
            if (!Configurazione.getConfigurazioneGenerazioneBusta().isGenerazioneBustaSPCoopErrore_strutturaHeaderNonCorretta()) {
                throw new StrutturaEGovException("Header egov senza elemento Sequenza numeroProgressivo", "SequenzaNumeroProgressivo");
            }
            Eccezione ecc = new Eccezione();
            ecc.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
            ecc.setCodiceEccezione("EGOV_IT_114");
            ecc.setRilevanza("GRAVE");
            ecc.setPosizione("Sequenza/numeroProgressivo");
            this.erroriValidazione.add(ecc);
            return;
        }
        try {
            Long test = new Long(seq);
            this.busta.setSequenza(test);
        }
        catch (Exception e) {
            Eccezione ecc = new Eccezione();
            ecc.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
            ecc.setCodiceEccezione("EGOV_IT_114");
            ecc.setRilevanza("GRAVE");
            ecc.setPosizione("Sequenza/numeroProgressivo");
            this.erroriValidazione.add(ecc);
        }
    }

    private void validazioneListaRiscontri(Node child, String prefix) throws StrutturaEGovException {
        NodeList riscontri = child.getChildNodes();
        if (riscontri.getLength() <= 0) {
            Eccezione ecc = new Eccezione();
            ecc.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
            ecc.setCodiceEccezione("EGOV_IT_115");
            ecc.setRilevanza("GRAVE");
            ecc.setPosizione("ListaRiscontri/Riscontro");
            this.erroriValidazione.add(ecc);
            return;
        }
        for (int i = 0; i < riscontri.getLength(); ++i) {
            boolean errorFind = false;
            Node riscontro = riscontri.item(i);
            if (!SoapUtils.matchLocalName((Node)riscontro, (String)"Riscontro", (String)prefix, (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/")) {
                Eccezione ecc = new Eccezione();
                ecc.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                ecc.setCodiceEccezione("EGOV_IT_115");
                ecc.setRilevanza("GRAVE");
                ecc.setPosizione("ListaRiscontri/childNode[" + riscontro.getNodeName() + "]");
                this.erroriValidazione.add(ecc);
                continue;
            }
            NodeList childsRiscontro = riscontro.getChildNodes();
            boolean presenzaIdentificatore = false;
            boolean presenzaOraRegistrazione = false;
            String id = null;
            boolean findID = false;
            String ora = null;
            Date oraDate = null;
            boolean findOra = false;
            String tipoOra = null;
            boolean findTipoOra = false;
            for (int j = 0; j < childsRiscontro.getLength(); ++j) {
                Eccezione ecc;
                Eccezione ecc2;
                Node elem = childsRiscontro.item(j);
                if (SoapUtils.matchLocalName((Node)elem, (String)"Identificatore", (String)prefix, (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/")) {
                    if (presenzaIdentificatore) {
                        if (!Configurazione.getConfigurazioneGenerazioneBusta().isGenerazioneBustaSPCoopErrore_strutturaHeaderNonCorretta()) {
                            throw new StrutturaEGovException("Header egov con pi\u00f9 di un elemento RiscontroIdentificatore", "RiscontroIdentificatore");
                        }
                        ecc2 = new Eccezione();
                        ecc2.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                        ecc2.setCodiceEccezione("EGOV_IT_115");
                        ecc2.setRilevanza("GRAVE");
                        if (this.segnalazioneElementoPresentePiuVolte) {
                            ecc2.setPosizione("ListaRiscontri/Riscontro/Identificatore elemento presente pi\u00f9 volte nell'header");
                        } else {
                            ecc2.setPosizione("ListaRiscontri/Riscontro/Identificatore");
                        }
                        this.erroriValidazione.add(ecc2);
                        continue;
                    }
                    presenzaIdentificatore = true;
                    try {
                        id = elem.getChildNodes().item(0).getNodeValue();
                        findID = true;
                    }
                    catch (Exception e) {
                        ecc = new Eccezione();
                        ecc.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                        ecc.setCodiceEccezione("EGOV_IT_115");
                        ecc.setRilevanza("GRAVE");
                        ecc.setPosizione("ListaRiscontri/Riscontro/Identificatore");
                        this.erroriValidazione.add(ecc);
                        errorFind = true;
                    }
                    continue;
                }
                if (SoapUtils.matchLocalName((Node)elem, (String)"OraRegistrazione", (String)prefix, (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/")) {
                    if (presenzaOraRegistrazione) {
                        if (!Configurazione.getConfigurazioneGenerazioneBusta().isGenerazioneBustaSPCoopErrore_strutturaHeaderNonCorretta()) {
                            throw new StrutturaEGovException("Header egov con pi\u00f9 di un elemento RiscontroOraRegistrazione", "RiscontroOraRegistrazione");
                        }
                        ecc2 = new Eccezione();
                        ecc2.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                        ecc2.setCodiceEccezione("EGOV_IT_115");
                        ecc2.setRilevanza("GRAVE");
                        if (this.segnalazioneElementoPresentePiuVolte) {
                            ecc2.setPosizione("ListaRiscontri/Riscontro/OraRegistrazione elemento presente pi\u00f9 volte nell'header");
                        } else {
                            ecc2.setPosizione("ListaRiscontri/Riscontro/OraRegistrazione");
                        }
                        this.erroriValidazione.add(ecc2);
                        continue;
                    }
                    presenzaOraRegistrazione = true;
                    try {
                        ora = elem.getChildNodes().item(0).getNodeValue();
                        findOra = true;
                    }
                    catch (Exception e) {
                        ecc = new Eccezione();
                        ecc.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                        ecc.setCodiceEccezione("EGOV_IT_115");
                        ecc.setRilevanza("GRAVE");
                        ecc.setPosizione("ListaRiscontri/Riscontro/OraRegistrazione");
                        this.erroriValidazione.add(ecc);
                        errorFind = true;
                    }
                    oraDate = null;
                    if (ora != null) {
                        oraDate = this.validazioneData(ora);
                    }
                    if (ora == null || oraDate == null) {
                        ecc2 = new Eccezione();
                        ecc2.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                        ecc2.setCodiceEccezione("EGOV_IT_115");
                        ecc2.setRilevanza("GRAVE");
                        ecc2.setPosizione("ListaRiscontri/Riscontro/OraRegistrazione");
                        this.erroriValidazione.add(ecc2);
                        errorFind = true;
                    }
                    try {
                        Node hrefFind = null;
                        hrefFind = this.readQualifiedAttribute ? SoapUtils.getQualifiedAttributeNode((Node)elem, (String)"tempo", (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/") : SoapUtils.getAttributeNode((Node)elem, (String)"tempo");
                        tipoOra = hrefFind.getNodeValue();
                        findTipoOra = true;
                    }
                    catch (Exception e) {
                        if (!Configurazione.getConfigurazioneGenerazioneBusta().isGenerazioneBustaSPCoopErrore_strutturaHeaderNonCorretta()) {
                            throw new StrutturaEGovException("Header egov senza RiscontroOraRegistrazioneTempo", "RiscontroOraRegistrazioneTempo");
                        }
                        ecc = new Eccezione();
                        ecc.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                        ecc.setCodiceEccezione("EGOV_IT_115");
                        ecc.setRilevanza("GRAVE");
                        ecc.setPosizione("ListaRiscontri/Riscontro/OraRegistrazione/tempo");
                        this.erroriValidazione.add(ecc);
                        errorFind = true;
                    }
                    if (tipoOra == null || tipoOra.equals("EGOV_IT_Locale") || tipoOra.equals("EGOV_IT_SPC")) continue;
                    ecc2 = new Eccezione();
                    ecc2.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                    ecc2.setCodiceEccezione("EGOV_IT_115");
                    ecc2.setRilevanza("GRAVE");
                    ecc2.setPosizione("ListaRiscontri/Riscontro/OraRegistrazione/tempo");
                    this.erroriValidazione.add(ecc2);
                    errorFind = true;
                    continue;
                }
                ecc2 = new Eccezione();
                ecc2.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                ecc2.setCodiceEccezione("EGOV_IT_115");
                ecc2.setRilevanza("GRAVE");
                ecc2.setPosizione("ListaRiscontri/Riscontro/child[" + elem.getNodeName() + "]");
                this.erroriValidazione.add(ecc2);
                errorFind = true;
            }
            if (!Configurazione.getConfigurazioneGenerazioneBusta().isGenerazioneBustaSPCoopErrore_strutturaHeaderNonCorretta()) {
                if (!presenzaIdentificatore) {
                    throw new StrutturaEGovException("Header egov senza RiscontroIdentificatore", "RiscontroIdentificatore");
                }
                if (!presenzaOraRegistrazione) {
                    throw new StrutturaEGovException("Header egov senza RiscontroOraRegistrazione", "RiscontroOraRegistrazione");
                }
            }
            if (!errorFind) {
                if (!findID) {
                    Eccezione ecc = new Eccezione();
                    ecc.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                    ecc.setCodiceEccezione("EGOV_IT_115");
                    ecc.setRilevanza("GRAVE");
                    ecc.setPosizione("ListaRiscontri/Riscontro/Identificatore");
                    this.erroriValidazione.add(ecc);
                }
                if (!findOra) {
                    Eccezione ecc = new Eccezione();
                    ecc.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                    ecc.setCodiceEccezione("EGOV_IT_115");
                    ecc.setRilevanza("GRAVE");
                    ecc.setPosizione("ListaRiscontri/Riscontro/OraRegistrazione");
                    this.erroriValidazione.add(ecc);
                } else if (!findTipoOra) {
                    Eccezione ecc = new Eccezione();
                    ecc.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                    ecc.setCodiceEccezione("EGOV_IT_115");
                    ecc.setRilevanza("GRAVE");
                    ecc.setPosizione("ListaRiscontri/Riscontro/OraRegistrazione/tempo");
                    this.erroriValidazione.add(ecc);
                }
            }
            if (id == null && ora == null && tipoOra == null) continue;
            Riscontro r = new Riscontro();
            r.setID(id);
            r.setOraRegistrazione(oraDate);
            r.setTipoOraRegistrazione(tipoOra);
            this.busta.addRiscontro(r);
        }
    }

    private void validazioneListaTrasmissioni(Node child, String prefix) throws StrutturaEGovException {
        NodeList trasmissioni = child.getChildNodes();
        if (trasmissioni.getLength() <= 0) {
            Eccezione ecc = new Eccezione();
            ecc.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
            ecc.setCodiceEccezione("EGOV_IT_116");
            ecc.setRilevanza("GRAVE");
            ecc.setPosizione("ListaTrasmissioni/Trasmissione");
            this.erroriValidazione.add(ecc);
            return;
        }
        for (int i = 0; i < trasmissioni.getLength(); ++i) {
            boolean errorFind = false;
            Node trasmissione = trasmissioni.item(i);
            if (!SoapUtils.matchLocalName((Node)trasmissione, (String)"Trasmissione", (String)prefix, (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/")) {
                Eccezione ecc = new Eccezione();
                ecc.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                ecc.setCodiceEccezione("EGOV_IT_116");
                ecc.setRilevanza("GRAVE");
                ecc.setPosizione("ListaTrasmissioni/child[" + trasmissione.getNodeName() + "]");
                this.erroriValidazione.add(ecc);
                continue;
            }
            NodeList childsTrasmissione = trasmissione.getChildNodes();
            boolean presenzaOrigine = false;
            boolean presenzaDestinazione = false;
            boolean presenzaOraRegistrazione = false;
            String origine = null;
            String tipoOrigine = null;
            String indTelematicoOrigine = null;
            boolean findOrigine = false;
            boolean findTipoOrigine = false;
            String destinazione = null;
            String tipoDestinazione = null;
            String indTelematicoDestinazione = null;
            boolean findDestinazione = false;
            boolean findTipoDestinazione = false;
            String ora = null;
            Date oraDate = null;
            boolean findOra = false;
            String tipoOra = null;
            boolean findTipoOra = false;
            for (int j = 0; j < childsTrasmissione.getLength(); ++j) {
                Eccezione ecc;
                URL urlcheck;
                Node hrefFindT;
                Node hrefFind;
                Eccezione ecc2;
                NodeList valueIDParte;
                Node idParte;
                Eccezione ecc3;
                Node elem = childsTrasmissione.item(j);
                if (SoapUtils.matchLocalName((Node)elem, (String)"Origine", (String)prefix, (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/")) {
                    if (presenzaOrigine) {
                        if (!Configurazione.getConfigurazioneGenerazioneBusta().isGenerazioneBustaSPCoopErrore_strutturaHeaderNonCorretta()) {
                            throw new StrutturaEGovException("Header egov con pi\u00f9 di un elemento TrasmissioneOrigine", "TrasmissioneOrigine");
                        }
                        ecc3 = new Eccezione();
                        ecc3.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                        ecc3.setCodiceEccezione("EGOV_IT_116");
                        ecc3.setRilevanza("GRAVE");
                        if (this.segnalazioneElementoPresentePiuVolte) {
                            ecc3.setPosizione("ListaTrasmissioni/Trasmissione/Origine elemento presente pi\u00f9 volte nell'header");
                        } else {
                            ecc3.setPosizione("ListaTrasmissioni/Trasmissione/Origine");
                        }
                        this.erroriValidazione.add(ecc3);
                        continue;
                    }
                    presenzaOrigine = true;
                    if (elem.getChildNodes().getLength() != 1) {
                        ecc3 = new Eccezione();
                        ecc3.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                        ecc3.setCodiceEccezione("EGOV_IT_116");
                        ecc3.setRilevanza("GRAVE");
                        if (elem.getChildNodes().getLength() < 1) {
                            if (!Configurazione.getConfigurazioneGenerazioneBusta().isGenerazioneBustaSPCoopErrore_strutturaHeaderNonCorretta()) {
                                throw new StrutturaEGovException("Header egov senza TrasmissioneOrigine IdentificativoParte", "TrasmissioneOrigineIdentificativoParte");
                            }
                            ecc3.setPosizione("ListaTrasmissioni/Trasmissione/Origine/IdentificativoParte");
                        } else if (this.segnalazioneElementoPresentePiuVolte) {
                            ecc3.setPosizione("ListaTrasmissioni/Trasmissione/Origine/IdentificativoParte elemento presente pi\u00f9 volte nell'header");
                        } else {
                            ecc3.setPosizione("ListaTrasmissioni/Trasmissione/Origine/IdentificativoParte");
                        }
                        this.erroriValidazione.add(ecc3);
                        errorFind = true;
                        continue;
                    }
                    idParte = elem.getChildNodes().item(0);
                    try {
                        valueIDParte = idParte.getChildNodes();
                        origine = valueIDParte.item(0).getNodeValue();
                        findOrigine = true;
                    }
                    catch (Exception e) {
                        ecc2 = new Eccezione();
                        ecc2.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                        ecc2.setCodiceEccezione("EGOV_IT_116");
                        ecc2.setRilevanza("GRAVE");
                        ecc2.setPosizione("ListaTrasmissioni/Trasmissione/Origine/IdentificativoParte");
                        this.erroriValidazione.add(ecc2);
                        errorFind = true;
                    }
                    try {
                        hrefFind = null;
                        hrefFind = this.readQualifiedAttribute ? SoapUtils.getQualifiedAttributeNode((Node)idParte, (String)"tipo", (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/") : SoapUtils.getAttributeNode((Node)idParte, (String)"tipo");
                        tipoOrigine = hrefFind.getNodeValue();
                        if (tipoOrigine == null) {
                            if (!Configurazione.getConfigurazioneGenerazioneBusta().isGenerazioneBustaSPCoopErrore_strutturaHeaderNonCorretta()) {
                                if (!findTipoOrigine) {
                                    throw new StrutturaEGovException("Header egov senza TrasmissioneOrigine IdentificativoParteTipo", "TrasmissioneOrigineIdentificativoParteTipo");
                                }
                            } else {
                                throw new Exception("Tipo non definito");
                            }
                        }
                        if (!Configurazione.getTipiSoggettiValidi().contains(tipoOrigine)) {
                            throw new Exception("Tipo non valido");
                        }
                        findTipoOrigine = true;
                    }
                    catch (StrutturaEGovException se) {
                        throw se;
                    }
                    catch (Exception e) {
                        ecc2 = new Eccezione();
                        ecc2.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                        ecc2.setCodiceEccezione("EGOV_IT_116");
                        ecc2.setRilevanza("GRAVE");
                        ecc2.setPosizione("ListaTrasmissioni/Trasmissione/Origine/IdentificativoParte/tipo");
                        this.erroriValidazione.add(ecc2);
                        errorFind = true;
                    }
                    try {
                        hrefFindT = null;
                        hrefFindT = this.readQualifiedAttribute ? SoapUtils.getQualifiedAttributeNode((Node)idParte, (String)"indirizzoTelematico", (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/") : SoapUtils.getAttributeNode((Node)idParte, (String)"indirizzoTelematico");
                        if (hrefFindT != null) {
                            indTelematicoOrigine = hrefFindT.getNodeValue();
                        }
                    }
                    catch (Exception e) {
                        ecc2 = new Eccezione();
                        ecc2.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                        ecc2.setCodiceEccezione("EGOV_IT_116");
                        ecc2.setRilevanza("GRAVE");
                        ecc2.setPosizione("ListaTrasmissioni/Trasmissione/Origine/IdentificativoParte/indirizzoTelematico");
                        this.erroriValidazione.add(ecc2);
                        errorFind = true;
                    }
                    if (errorFind || indTelematicoOrigine == null || indTelematicoOrigine.equals("")) continue;
                    urlcheck = null;
                    try {
                        urlcheck = new URL(indTelematicoOrigine);
                        indTelematicoOrigine = urlcheck.toString();
                    }
                    catch (Exception e) {
                        ecc = new Eccezione();
                        ecc.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                        ecc.setCodiceEccezione("EGOV_IT_116");
                        ecc.setRilevanza("GRAVE");
                        ecc.setPosizione("ListaTrasmissioni/Trasmissione/Origine/IdentificativoParte/indirizzoTelematico");
                        this.erroriValidazione.add(ecc);
                        errorFind = true;
                    }
                    continue;
                }
                if (SoapUtils.matchLocalName((Node)elem, (String)"Destinazione", (String)prefix, (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/")) {
                    if (presenzaDestinazione) {
                        if (!Configurazione.getConfigurazioneGenerazioneBusta().isGenerazioneBustaSPCoopErrore_strutturaHeaderNonCorretta()) {
                            throw new StrutturaEGovException("Header egov con pi\u00f9 di un elemento TrasmissioneDestinazione", "TrasmissioneDestinazione");
                        }
                        ecc3 = new Eccezione();
                        ecc3.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                        ecc3.setCodiceEccezione("EGOV_IT_116");
                        ecc3.setRilevanza("GRAVE");
                        if (this.segnalazioneElementoPresentePiuVolte) {
                            ecc3.setPosizione("ListaTrasmissioni/Trasmissione/Destinazione elemento presente pi\u00f9 volte nell'header");
                        } else {
                            ecc3.setPosizione("ListaTrasmissioni/Trasmissione/Destinazione");
                        }
                        this.erroriValidazione.add(ecc3);
                        continue;
                    }
                    presenzaDestinazione = true;
                    if (elem.getChildNodes().getLength() != 1) {
                        ecc3 = new Eccezione();
                        ecc3.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                        ecc3.setCodiceEccezione("EGOV_IT_116");
                        ecc3.setRilevanza("GRAVE");
                        if (elem.getChildNodes().getLength() < 1) {
                            if (!Configurazione.getConfigurazioneGenerazioneBusta().isGenerazioneBustaSPCoopErrore_strutturaHeaderNonCorretta()) {
                                throw new StrutturaEGovException("Header egov senza TrasmissioneDestinazione IdentificativoParte", "TrasmissioneDestinazioneIdentificativoParte");
                            }
                            ecc3.setPosizione("ListaTrasmissioni/Trasmissione/Destinazione/IdentificativoParte");
                        } else if (this.segnalazioneElementoPresentePiuVolte) {
                            ecc3.setPosizione("ListaTrasmissioni/Trasmissione/Destinazione/IdentificativoParte elemento presente pi\u00f9 volte nell'header");
                        } else {
                            ecc3.setPosizione("ListaTrasmissioni/Trasmissione/Destinazione/IdentificativoParte");
                        }
                        this.erroriValidazione.add(ecc3);
                        errorFind = true;
                        continue;
                    }
                    idParte = elem.getChildNodes().item(0);
                    try {
                        valueIDParte = idParte.getChildNodes();
                        destinazione = valueIDParte.item(0).getNodeValue();
                        findDestinazione = true;
                    }
                    catch (Exception e) {
                        ecc2 = new Eccezione();
                        ecc2.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                        ecc2.setCodiceEccezione("EGOV_IT_116");
                        ecc2.setRilevanza("GRAVE");
                        ecc2.setPosizione("ListaTrasmissioni/Trasmissione/Destinazione/IdentificativoParte");
                        this.erroriValidazione.add(ecc2);
                        errorFind = true;
                    }
                    try {
                        hrefFind = null;
                        hrefFind = this.readQualifiedAttribute ? SoapUtils.getQualifiedAttributeNode((Node)idParte, (String)"tipo", (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/") : SoapUtils.getAttributeNode((Node)idParte, (String)"tipo");
                        tipoDestinazione = hrefFind.getNodeValue();
                        if (tipoDestinazione == null) {
                            if (!Configurazione.getConfigurazioneGenerazioneBusta().isGenerazioneBustaSPCoopErrore_strutturaHeaderNonCorretta()) {
                                if (!findTipoOrigine) {
                                    throw new StrutturaEGovException("Header egov senza TrasmissioneDestinazione IdentificativoParteTipo", "TrasmissioneDestinazioneIdentificativoParteTipo");
                                }
                            } else {
                                throw new Exception("Tipo non definito");
                            }
                        }
                        if (!Configurazione.getTipiSoggettiValidi().contains(tipoDestinazione)) {
                            throw new Exception("Tipo non valido");
                        }
                        findTipoDestinazione = true;
                    }
                    catch (StrutturaEGovException se) {
                        throw se;
                    }
                    catch (Exception e) {
                        ecc2 = new Eccezione();
                        ecc2.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                        ecc2.setCodiceEccezione("EGOV_IT_116");
                        ecc2.setRilevanza("GRAVE");
                        ecc2.setPosizione("ListaTrasmissioni/Trasmissione/Destinazione/IdentificativoParte/tipo");
                        this.erroriValidazione.add(ecc2);
                        errorFind = true;
                    }
                    try {
                        hrefFindT = null;
                        hrefFindT = this.readQualifiedAttribute ? SoapUtils.getQualifiedAttributeNode((Node)idParte, (String)"indirizzoTelematico", (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/") : SoapUtils.getAttributeNode((Node)idParte, (String)"indirizzoTelematico");
                        if (hrefFindT != null) {
                            indTelematicoDestinazione = hrefFindT.getNodeValue();
                        }
                    }
                    catch (Exception e) {
                        ecc2 = new Eccezione();
                        ecc2.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                        ecc2.setCodiceEccezione("EGOV_IT_116");
                        ecc2.setRilevanza("GRAVE");
                        ecc2.setPosizione("ListaTrasmissioni/Trasmissione/Destinazione/IdentificativoParte/indirizzoTelematico");
                        this.erroriValidazione.add(ecc2);
                        errorFind = true;
                    }
                    if (errorFind || indTelematicoDestinazione == null || indTelematicoDestinazione.equals("")) continue;
                    urlcheck = null;
                    try {
                        urlcheck = new URL(indTelematicoDestinazione);
                        indTelematicoDestinazione = urlcheck.toString();
                    }
                    catch (Exception e) {
                        ecc = new Eccezione();
                        ecc.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                        ecc.setCodiceEccezione("EGOV_IT_116");
                        ecc.setRilevanza("GRAVE");
                        ecc.setPosizione("ListaTrasmissioni/Trasmissione/Destinazione/IdentificativoParte/indirizzoTelematico");
                        this.erroriValidazione.add(ecc);
                        errorFind = true;
                    }
                    continue;
                }
                if (SoapUtils.matchLocalName((Node)elem, (String)"OraRegistrazione", (String)prefix, (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/")) {
                    Eccezione ecc4;
                    if (presenzaOraRegistrazione) {
                        if (!Configurazione.getConfigurazioneGenerazioneBusta().isGenerazioneBustaSPCoopErrore_strutturaHeaderNonCorretta()) {
                            throw new StrutturaEGovException("Header egov con pi\u00f9 di un elemento TrasmissioneOraRegistrazione", "TrasmissioneOraRegistrazione");
                        }
                        ecc3 = new Eccezione();
                        ecc3.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                        ecc3.setCodiceEccezione("EGOV_IT_116");
                        ecc3.setRilevanza("GRAVE");
                        if (this.segnalazioneElementoPresentePiuVolte) {
                            ecc3.setPosizione("ListaTrasmissioni/Trasmissione/OraRegistrazione elemento presente pi\u00f9 volte nell'header");
                        } else {
                            ecc3.setPosizione("ListaTrasmissioni/Trasmissione/OraRegistrazione");
                        }
                        this.erroriValidazione.add(ecc3);
                        continue;
                    }
                    presenzaOraRegistrazione = true;
                    try {
                        ora = elem.getChildNodes().item(0).getNodeValue();
                        findOra = true;
                    }
                    catch (Exception e) {
                        ecc4 = new Eccezione();
                        ecc4.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                        ecc4.setCodiceEccezione("EGOV_IT_116");
                        ecc4.setRilevanza("GRAVE");
                        ecc4.setPosizione("ListaTrasmissioni/Trasmissione/OraRegistrazione");
                        this.erroriValidazione.add(ecc4);
                        errorFind = true;
                    }
                    oraDate = null;
                    if (ora != null) {
                        oraDate = this.validazioneData(ora);
                    }
                    if (ora == null || oraDate == null) {
                        ecc3 = new Eccezione();
                        ecc3.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                        ecc3.setCodiceEccezione("EGOV_IT_116");
                        ecc3.setRilevanza("GRAVE");
                        ecc3.setPosizione("ListaTrasmissioni/Trasmissione/OraRegistrazione");
                        this.erroriValidazione.add(ecc3);
                        errorFind = true;
                    }
                    try {
                        Node hrefFind2 = null;
                        hrefFind2 = this.readQualifiedAttribute ? SoapUtils.getQualifiedAttributeNode((Node)elem, (String)"tempo", (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/") : SoapUtils.getAttributeNode((Node)elem, (String)"tempo");
                        tipoOra = hrefFind2.getNodeValue();
                        findTipoOra = true;
                    }
                    catch (Exception e) {
                        if (!Configurazione.getConfigurazioneGenerazioneBusta().isGenerazioneBustaSPCoopErrore_strutturaHeaderNonCorretta()) {
                            if (!findTipoOrigine) {
                                throw new StrutturaEGovException("Header egov senza Trasmissione OraRegistrazioneTempo", "TrasmissioneOraRegistrazioneTempo");
                            }
                        }
                        ecc4 = new Eccezione();
                        ecc4.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                        ecc4.setCodiceEccezione("EGOV_IT_116");
                        ecc4.setRilevanza("GRAVE");
                        ecc4.setPosizione("ListaTrasmissioni/Trasmissione/OraRegistrazione/tempo");
                        this.erroriValidazione.add(ecc4);
                        errorFind = true;
                    }
                    if (tipoOra == null || tipoOra.equals("EGOV_IT_Locale") || tipoOra.equals("EGOV_IT_SPC")) continue;
                    ecc3 = new Eccezione();
                    ecc3.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                    ecc3.setCodiceEccezione("EGOV_IT_116");
                    ecc3.setRilevanza("GRAVE");
                    ecc3.setPosizione("ListaTrasmissioni/Trasmissione/OraRegistrazione/tempo");
                    this.erroriValidazione.add(ecc3);
                    errorFind = true;
                    continue;
                }
                ecc3 = new Eccezione();
                ecc3.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                ecc3.setCodiceEccezione("EGOV_IT_116");
                ecc3.setRilevanza("GRAVE");
                ecc3.setPosizione("ListaTrasmissioni/Trasmissione/child[" + elem.getNodeName() + "]");
                this.erroriValidazione.add(ecc3);
                errorFind = true;
            }
            if (!Configurazione.getConfigurazioneGenerazioneBusta().isGenerazioneBustaSPCoopErrore_strutturaHeaderNonCorretta()) {
                if (!presenzaOrigine) {
                    throw new StrutturaEGovException("Header egov senza TrasmissioneOrigine", "TrasmissioneOrigine");
                }
                if (!presenzaDestinazione) {
                    throw new StrutturaEGovException("Header egov senza TrasmissioneDestinazione", "TrasmissioneDestinazione");
                }
                if (!presenzaOraRegistrazione) {
                    throw new StrutturaEGovException("Header egov senza TrasmissioneOraRegistrazione", "TrasmissioneOraRegistrazione");
                }
            }
            if (!errorFind) {
                if (!presenzaOrigine) {
                    errorFind = true;
                    Eccezione ecc = new Eccezione();
                    ecc.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                    ecc.setCodiceEccezione("EGOV_IT_116");
                    ecc.setRilevanza("GRAVE");
                    ecc.setPosizione("ListaTrasmissioni/Trasmissione/Origine");
                    this.erroriValidazione.add(ecc);
                }
                if (!presenzaDestinazione) {
                    errorFind = true;
                    Eccezione ecc = new Eccezione();
                    ecc.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                    ecc.setCodiceEccezione("EGOV_IT_116");
                    ecc.setRilevanza("GRAVE");
                    ecc.setPosizione("ListaTrasmissioni/Trasmissione/Destinazione");
                    this.erroriValidazione.add(ecc);
                }
                if (!presenzaOraRegistrazione) {
                    errorFind = true;
                    Eccezione ecc = new Eccezione();
                    ecc.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                    ecc.setCodiceEccezione("EGOV_IT_116");
                    ecc.setRilevanza("GRAVE");
                    ecc.setPosizione("ListaTrasmissioni/Trasmissione/OraRegistrazione");
                    this.erroriValidazione.add(ecc);
                }
            }
            if (!errorFind) {
                if (!findOrigine) {
                    Eccezione ecc = new Eccezione();
                    ecc.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                    ecc.setCodiceEccezione("EGOV_IT_116");
                    ecc.setRilevanza("GRAVE");
                    ecc.setPosizione("ListaTrasmissioni/Trasmissione/Origine/IdentificativoParte");
                    this.erroriValidazione.add(ecc);
                } else if (!findTipoOrigine) {
                    Eccezione ecc = new Eccezione();
                    ecc.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                    ecc.setCodiceEccezione("EGOV_IT_116");
                    ecc.setRilevanza("GRAVE");
                    ecc.setPosizione("ListaTrasmissioni/Trasmissione/Origine/IdentificativoParte/tipo");
                    this.erroriValidazione.add(ecc);
                }
                if (!findDestinazione) {
                    Eccezione ecc = new Eccezione();
                    ecc.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                    ecc.setCodiceEccezione("EGOV_IT_116");
                    ecc.setRilevanza("GRAVE");
                    ecc.setPosizione("ListaTrasmissioni/Trasmissione/Destinazione/IdentificativoParte");
                    this.erroriValidazione.add(ecc);
                } else if (!findTipoDestinazione) {
                    Eccezione ecc = new Eccezione();
                    ecc.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                    ecc.setCodiceEccezione("EGOV_IT_116");
                    ecc.setRilevanza("GRAVE");
                    ecc.setPosizione("ListaTrasmissioni/Trasmissione/Destinazione/IdentificativoParte/tipo");
                    this.erroriValidazione.add(ecc);
                }
                if (!findOra) {
                    Eccezione ecc = new Eccezione();
                    ecc.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                    ecc.setCodiceEccezione("EGOV_IT_116");
                    ecc.setRilevanza("GRAVE");
                    ecc.setPosizione("ListaTrasmissioni/Trasmissione/OraRegistrazione");
                    this.erroriValidazione.add(ecc);
                } else if (!findTipoOra) {
                    Eccezione ecc = new Eccezione();
                    ecc.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                    ecc.setCodiceEccezione("EGOV_IT_116");
                    ecc.setRilevanza("GRAVE");
                    ecc.setPosizione("ListaTrasmissioni/Trasmissione/OraRegistrazione/tempo");
                    this.erroriValidazione.add(ecc);
                }
            }
            if (origine == null && tipoOrigine == null && tipoDestinazione == null && destinazione == null && ora == null && tipoOra == null) continue;
            Trasmissione tr = new Trasmissione();
            tr.setOrigine(origine);
            tr.setTipoOrigine(tipoOrigine);
            tr.setIndirizzoTelematicoOrigine(indTelematicoOrigine);
            tr.setDestinazione(destinazione);
            tr.setTipoDestinazione(tipoDestinazione);
            tr.setIndirizzoTelematicoDestinazione(indTelematicoDestinazione);
            tr.setOraRegistrazione(oraDate);
            tr.setTempo(tipoOra);
            this.busta.addTrasmissione(tr);
        }
    }

    private void validazioneListaEccezioni(Node child, String prefix) throws StrutturaEGovException {
        NodeList eccezioni = child.getChildNodes();
        for (int i = 0; i < eccezioni.getLength(); ++i) {
            Eccezione ecc;
            boolean errorFind = false;
            Node eccezione = eccezioni.item(i);
            if (!SoapUtils.matchLocalName((Node)eccezione, (String)"Eccezione", (String)prefix, (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/")) {
                Eccezione ecc2 = new Eccezione();
                ecc2.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                ecc2.setCodiceEccezione("EGOV_IT_100");
                ecc2.setRilevanza("GRAVE");
                ecc2.setPosizione("ListaEccezioni/child[" + eccezione.getNodeName() + "]");
                this.errorsTrovatiSullaListaEccezioni.add(ecc2);
                errorFind = true;
            }
            String contestoCodifica = null;
            String codiceEccezione = null;
            String rilevanza = null;
            String posizione = null;
            boolean contestoCodificaError = false;
            try {
                Node hrefFind = null;
                hrefFind = this.readQualifiedAttribute ? SoapUtils.getQualifiedAttributeNode((Node)eccezione, (String)"contestoCodifica", (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/") : SoapUtils.getAttributeNode((Node)eccezione, (String)"contestoCodifica");
                contestoCodifica = hrefFind.getNodeValue();
            }
            catch (Exception e) {
                contestoCodificaError = true;
            }
            if (contestoCodifica == null) {
                contestoCodificaError = true;
            }
            if (contestoCodificaError) {
                Eccezione ecc3 = new Eccezione();
                ecc3.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                ecc3.setCodiceEccezione("EGOV_IT_100");
                ecc3.setRilevanza("GRAVE");
                ecc3.setPosizione("ListaEccezioni/contestoCodifica");
                this.errorsTrovatiSullaListaEccezioni.add(ecc3);
                errorFind = true;
            }
            boolean codiceEccezioneError = false;
            try {
                Node hrefFind = null;
                hrefFind = this.readQualifiedAttribute ? SoapUtils.getQualifiedAttributeNode((Node)eccezione, (String)"codiceEccezione", (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/") : SoapUtils.getAttributeNode((Node)eccezione, (String)"codiceEccezione");
                codiceEccezione = hrefFind.getNodeValue();
            }
            catch (Exception e) {
                codiceEccezioneError = true;
            }
            if (!ValidazioneSintattica.validazioneCodiceEccezione(codiceEccezione)) {
                codiceEccezioneError = true;
            }
            if (codiceEccezioneError) {
                Eccezione ecc4 = new Eccezione();
                ecc4.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                ecc4.setCodiceEccezione("EGOV_IT_100");
                ecc4.setRilevanza("GRAVE");
                ecc4.setPosizione("ListaEccezioni/codiceEccezione");
                this.errorsTrovatiSullaListaEccezioni.add(ecc4);
                errorFind = true;
            }
            boolean rilevanzaError = false;
            try {
                Node hrefFind = null;
                hrefFind = this.readQualifiedAttribute ? SoapUtils.getQualifiedAttributeNode((Node)eccezione, (String)"rilevanza", (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/") : SoapUtils.getAttributeNode((Node)eccezione, (String)"rilevanza");
                rilevanza = hrefFind.getNodeValue();
            }
            catch (Exception e) {
                rilevanzaError = true;
            }
            if (!this.validazioneRilevanza(rilevanza)) {
                rilevanzaError = true;
            }
            if (rilevanzaError) {
                Eccezione ecc5 = new Eccezione();
                ecc5.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                ecc5.setCodiceEccezione("EGOV_IT_100");
                ecc5.setRilevanza("GRAVE");
                ecc5.setPosizione("ListaEccezioni/rilevanza");
                this.errorsTrovatiSullaListaEccezioni.add(ecc5);
                errorFind = true;
            }
            boolean posizioneError = false;
            try {
                Node hrefFind = null;
                hrefFind = this.readQualifiedAttribute ? SoapUtils.getQualifiedAttributeNode((Node)eccezione, (String)"posizione", (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/") : SoapUtils.getAttributeNode((Node)eccezione, (String)"posizione");
                posizione = hrefFind.getNodeValue();
            }
            catch (Exception e) {
                posizioneError = true;
            }
            if (posizione == null) {
                posizioneError = true;
            }
            if (posizioneError) {
                ecc = new Eccezione();
                ecc.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                ecc.setCodiceEccezione("EGOV_IT_100");
                ecc.setRilevanza("GRAVE");
                ecc.setPosizione("ListaEccezioni/posizione");
                this.errorsTrovatiSullaListaEccezioni.add(ecc);
                errorFind = true;
            }
            if (!Configurazione.getConfigurazioneGenerazioneBusta().isGenerazioneBustaSPCoopErrore_strutturaHeaderNonCorretta()) {
                if (contestoCodifica == null) {
                    throw new StrutturaEGovException("Header egov senza Eccezione contestoCodifica", "EccezioneContestoCodifica");
                }
                if (codiceEccezione == null) {
                    throw new StrutturaEGovException("Header egov senza Eccezione codiceEccezione", "EccezioneCodiceEccezione");
                }
                if (rilevanza == null) {
                    throw new StrutturaEGovException("Header egov senza Eccezione rilevanza", "EccezioneRilevanza");
                }
                if (posizione == null) {
                    throw new StrutturaEGovException("Header egov senza Eccezione posizione", "EccezionePosizione");
                }
            }
            if (!errorFind) {
                if (contestoCodifica == null) {
                    ecc = new Eccezione();
                    ecc.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                    ecc.setCodiceEccezione("EGOV_IT_100");
                    ecc.setRilevanza("GRAVE");
                    ecc.setPosizione("ListaEccezioni/contestoCodifica");
                    this.errorsTrovatiSullaListaEccezioni.add(ecc);
                }
                if (codiceEccezione == null) {
                    ecc = new Eccezione();
                    ecc.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                    ecc.setCodiceEccezione("EGOV_IT_100");
                    ecc.setRilevanza("GRAVE");
                    ecc.setPosizione("ListaEccezioni/codiceEccezione");
                    this.errorsTrovatiSullaListaEccezioni.add(ecc);
                }
                if (rilevanza == null) {
                    ecc = new Eccezione();
                    ecc.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                    ecc.setCodiceEccezione("EGOV_IT_100");
                    ecc.setRilevanza("GRAVE");
                    ecc.setPosizione("ListaEccezioni/rilevanza");
                    this.errorsTrovatiSullaListaEccezioni.add(ecc);
                }
                if (posizione == null) {
                    ecc = new Eccezione();
                    ecc.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                    ecc.setCodiceEccezione("EGOV_IT_100");
                    ecc.setRilevanza("GRAVE");
                    ecc.setPosizione("ListaEccezioni/posizione");
                    this.errorsTrovatiSullaListaEccezioni.add(ecc);
                }
            }
            if (contestoCodifica == null || codiceEccezione == null || rilevanza == null || posizione == null) continue;
            Eccezione eccLetta = new Eccezione();
            eccLetta.setContestoCodifica(contestoCodifica);
            eccLetta.setCodiceEccezione(codiceEccezione);
            eccLetta.setRilevanza(rilevanza);
            eccLetta.setPosizione(posizione);
            this.busta.addEccezione(eccLetta);
        }
    }

    private boolean validazioneRilevanza(String codice) {
        if (codice == null) {
            return false;
        }
        if (codice.equals("INFO")) {
            return true;
        }
        if (codice.equals("LIEVE")) {
            return true;
        }
        return codice.equals("GRAVE");
    }

    public static boolean validazioneCodiceEccezione(String codice) {
        if (codice == null) {
            return false;
        }
        if (codice.equals("EGOV_IT_001")) {
            return true;
        }
        if (codice.equals("EGOV_IT_002")) {
            return true;
        }
        if (codice.equals("EGOV_IT_003")) {
            return true;
        }
        if (codice.equals("EGOV_IT_100")) {
            return true;
        }
        if (codice.equals("EGOV_IT_101")) {
            return true;
        }
        if (codice.equals("EGOV_IT_102")) {
            return true;
        }
        if (codice.equals("EGOV_IT_103")) {
            return true;
        }
        if (codice.equals("EGOV_IT_104")) {
            return true;
        }
        if (codice.equals("EGOV_IT_105")) {
            return true;
        }
        if (codice.equals("EGOV_IT_106")) {
            return true;
        }
        if (codice.equals("EGOV_IT_107")) {
            return true;
        }
        if (codice.equals("EGOV_IT_108")) {
            return true;
        }
        if (codice.equals("EGOV_IT_109")) {
            return true;
        }
        if (codice.equals("EGOV_IT_110")) {
            return true;
        }
        if (codice.equals("EGOV_IT_111")) {
            return true;
        }
        if (codice.equals("EGOV_IT_112")) {
            return true;
        }
        if (codice.equals("EGOV_IT_113")) {
            return true;
        }
        if (codice.equals("EGOV_IT_114")) {
            return true;
        }
        if (codice.equals("EGOV_IT_115")) {
            return true;
        }
        if (codice.equals("EGOV_IT_116")) {
            return true;
        }
        if (codice.equals("EGOV_IT_117")) {
            return true;
        }
        if (codice.equals("EGOV_IT_118")) {
            return true;
        }
        if (codice.equals("EGOV_IT_119")) {
            return true;
        }
        if (codice.equals("EGOV_IT_120")) {
            return true;
        }
        if (codice.equals("EGOV_IT_200")) {
            return true;
        }
        if (codice.equals("EGOV_IT_201")) {
            return true;
        }
        if (codice.equals("EGOV_IT_202")) {
            return true;
        }
        if (codice.equals("EGOV_IT_203")) {
            return true;
        }
        if (codice.equals("EGOV_IT_300")) {
            return true;
        }
        if (codice.equals("EGOV_IT_301")) {
            return true;
        }
        if (codice.equals("EGOV_IT_400")) {
            return true;
        }
        if (codice.equals("EGOV_IT_401")) {
            return true;
        }
        return codice.equals("EGOV_IT_402");
    }

    public void validazioneFault(SOAPBody body) {
        try {
            if (!body.hasFault()) {
                Eccezione ecc = new Eccezione();
                ecc.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                ecc.setCodiceEccezione("EGOV_IT_003");
                ecc.setRilevanza("GRAVE");
                ecc.setPosizione("ListaEccezioni/SOAPFault");
                this.errorsTrovatiSullaListaEccezioni.add(ecc);
            } else {
                Eccezione ecc;
                String codeS;
                SOAPFault fault = body.getFault();
                boolean valoriOK = true;
                String faultS = fault.getFaultString();
                if (faultS != null) {
                    faultS = faultS.trim();
                }
                if (!"EGOV_IT_300 - Errore nel processamento del messaggio SPCoop".equals(faultS) && !"EGOV_IT_001 - Formato Busta non corretto".equals(faultS)) {
                    Eccezione ecc2 = new Eccezione();
                    ecc2.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                    ecc2.setCodiceEccezione("EGOV_IT_003");
                    ecc2.setRilevanza("GRAVE");
                    ecc2.setPosizione("ListaEccezioni/SOAPFault/FaultString");
                    this.errorsTrovatiSullaListaEccezioni.add(ecc2);
                    valoriOK = false;
                }
                if ((codeS = fault.getFaultCode()) != null) {
                    codeS = codeS.trim();
                }
                if (!"Client".equals(codeS) && !"Server".equals(codeS)) {
                    ecc = new Eccezione();
                    ecc.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                    ecc.setCodiceEccezione("EGOV_IT_003");
                    ecc.setRilevanza("GRAVE");
                    ecc.setPosizione("ListaEccezioni/SOAPFault/FaultCode");
                    this.errorsTrovatiSullaListaEccezioni.add(ecc);
                    valoriOK = false;
                }
                if (valoriOK) {
                    if ("Client".equals(codeS)) {
                        Eccezione ecc3;
                        boolean detailPresente = false;
                        Detail d = fault.getDetail();
                        if (d != null && d.getDetailEntries().hasNext()) {
                            detailPresente = true;
                        }
                        if (!"EGOV_IT_001 - Formato Busta non corretto".equals(faultS)) {
                            ecc3 = new Eccezione();
                            ecc3.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                            ecc3.setCodiceEccezione("EGOV_IT_003");
                            ecc3.setRilevanza("GRAVE");
                            ecc3.setPosizione("ListaEccezioni/SOAPFault/FaultString");
                            this.errorsTrovatiSullaListaEccezioni.add(ecc3);
                        }
                        if (detailPresente) {
                            ecc3 = new Eccezione();
                            ecc3.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                            ecc3.setCodiceEccezione("EGOV_IT_003");
                            ecc3.setRilevanza("GRAVE");
                            ecc3.setPosizione("ListaEccezioni/SOAPFault/Details");
                            this.errorsTrovatiSullaListaEccezioni.add(ecc3);
                        }
                    }
                    if ("Server".equals(codeS) && !"EGOV_IT_300 - Errore nel processamento del messaggio SPCoop".equals(faultS)) {
                        ecc = new Eccezione();
                        ecc.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                        ecc.setCodiceEccezione("EGOV_IT_003");
                        ecc.setRilevanza("GRAVE");
                        ecc.setPosizione("ListaEccezioni/SOAPFault/FaultString");
                        this.errorsTrovatiSullaListaEccezioni.add(ecc);
                    }
                }
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Errore durante la validazione del SoapFault", (Throwable)e);
            Eccezione ecc = new Eccezione();
            ecc.setContestoCodifica("ErroreProcessamentoMessaggioSPCoop");
            ecc.setCodiceEccezione("EGOV_IT_300");
            ecc.setRilevanza("GRAVE");
            ecc.setPosizione("Validazione SoapFault: errore di processamento");
            this.erroriProcessamento.add(ecc);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validazioneManifestAttachments(Message msg, ProprietaManifestAttachments proprietaManifestAttachments) {
        SOAPBody soapBody = null;
        try {
            Vector<String> contentID = new Vector<String>();
            Vector<String> contentLocation = new Vector<String>();
            for (AttachmentPart ap : msg.getAttachmentsImpl().getAttachments()) {
                contentID.add(ap.getContentId());
                contentLocation.add(ap.getContentLocation());
            }
            boolean isRichiesta = false;
            boolean isRisposta = false;
            soapBody = msg.getSOAPBody();
            NodeList soapBodyList = soapBody.getChildNodes();
            if (soapBodyList.getLength() != 1) {
                Eccezione ecc = new Eccezione();
                ecc.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                ecc.setCodiceEccezione("EGOV_IT_003");
                ecc.setRilevanza("GRAVE");
                ecc.setPosizione("SOAPBody child size:" + soapBodyList.getLength());
                this.erroriValidazione.add(ecc);
                return;
            }
            Node descrizione = soapBody.getFirstChild();
            String prefixManifest = descrizione.getPrefix();
            if (prefixManifest == null) {
                prefixManifest = "";
            }
            if (!"".equals(prefixManifest)) {
                prefixManifest = prefixManifest + ":";
            }
            if (!SoapUtils.matchLocalName((Node)descrizione, (String)"Descrizione", (String)prefixManifest, (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/")) {
                Eccezione ecc = new Eccezione();
                ecc.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                ecc.setCodiceEccezione("EGOV_IT_003");
                ecc.setRilevanza("GRAVE");
                ecc.setPosizione("SOAPBody/Descrizione");
                this.erroriValidazione.add(ecc);
                return;
            }
            if (!"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/".equals(descrizione.getNamespaceURI())) {
                Eccezione ecc = new Eccezione();
                ecc.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                ecc.setCodiceEccezione("EGOV_IT_003");
                ecc.setRilevanza("GRAVE");
                ecc.setPosizione("SOAPBody/Descrizione/namespace");
                this.erroriValidazione.add(ecc);
                return;
            }
            NodeList descrizioneMessaggi = descrizione.getChildNodes();
            if (descrizioneMessaggi.getLength() <= 0) {
                Eccezione ecc = new Eccezione();
                ecc.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                ecc.setCodiceEccezione("EGOV_IT_003");
                ecc.setRilevanza("GRAVE");
                ecc.setPosizione("SOAPBody/Descrizione child size:" + descrizioneMessaggi.getLength());
                this.erroriValidazione.add(ecc);
                return;
            }
            for (int i = 0; i < descrizioneMessaggi.getLength(); ++i) {
                Eccezione ecc;
                Eccezione ecc2;
                Eccezione ecc3;
                Node descrizioneMessaggio = descrizioneMessaggi.item(i);
                if (!SoapUtils.matchLocalName((Node)descrizioneMessaggio, (String)"DescrizioneMessaggio", (String)prefixManifest, (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/")) {
                    Eccezione ecc4 = new Eccezione();
                    ecc4.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                    ecc4.setCodiceEccezione("EGOV_IT_003");
                    ecc4.setRilevanza("GRAVE");
                    ecc4.setPosizione("SOAPBody/Descrizione/child[" + descrizioneMessaggio.getNodeName() + "]");
                    this.erroriValidazione.add(ecc4);
                    continue;
                }
                NodeList riferimentoList = descrizioneMessaggio.getChildNodes();
                if (riferimentoList.getLength() != 1) {
                    Eccezione ecc5 = new Eccezione();
                    ecc5.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                    ecc5.setCodiceEccezione("EGOV_IT_003");
                    ecc5.setRilevanza("GRAVE");
                    ecc5.setPosizione("SOAPBody/Descrizione/DescrizioneMessaggio child size:" + riferimentoList.getLength());
                    this.erroriValidazione.add(ecc5);
                    continue;
                }
                Node riferimento = riferimentoList.item(0);
                if (!SoapUtils.matchLocalName((Node)riferimento, (String)"Riferimento", (String)prefixManifest, (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/")) {
                    Eccezione ecc6 = new Eccezione();
                    ecc6.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                    ecc6.setCodiceEccezione("EGOV_IT_003");
                    ecc6.setRilevanza("GRAVE");
                    ecc6.setPosizione("SOAPBody/Descrizione/DescrizioneMessaggio/child[" + riferimento.getNodeName() + "]");
                    this.erroriValidazione.add(ecc6);
                    continue;
                }
                String href = null;
                boolean hrefError = false;
                try {
                    Node hrefFind = null;
                    hrefFind = this.readQualifiedAttribute ? SoapUtils.getQualifiedAttributeNode((Node)riferimento, (String)"href", (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/") : SoapUtils.getAttributeNode((Node)riferimento, (String)"href");
                    href = hrefFind.getNodeValue();
                }
                catch (Exception e) {
                    hrefError = true;
                }
                if (href == null) {
                    hrefError = true;
                }
                if (hrefError) {
                    Eccezione ecc7 = new Eccezione();
                    ecc7.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                    ecc7.setCodiceEccezione("EGOV_IT_118");
                    ecc7.setRilevanza("GRAVE");
                    ecc7.setPosizione("SOAPBody/Descrizione/DescrizioneMessaggio/Riferimento/href");
                    this.erroriValidazione.add(ecc7);
                    continue;
                }
                boolean findHRef = false;
                for (int k = 0; k < contentID.size(); ++k) {
                    if (!href.equals(contentID.get(k)) && !href.equals("cid:" + (String)contentID.get(k)) && !href.equals(contentLocation.get(k))) continue;
                    contentID.remove(k);
                    contentLocation.remove(k);
                    findHRef = true;
                    break;
                }
                if (!findHRef) {
                    Eccezione ecc8 = new Eccezione();
                    ecc8.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                    ecc8.setCodiceEccezione("EGOV_IT_119");
                    ecc8.setRilevanza("GRAVE");
                    ecc8.setPosizione("SOAPBody/Descrizione/DescrizioneMessaggio/Riferimento/href[" + href + "]");
                    this.erroriValidazione.add(ecc8);
                }
                String role = null;
                boolean roleError = false;
                try {
                    Node roleFind = null;
                    roleFind = this.readQualifiedAttribute ? SoapUtils.getQualifiedAttributeNode((Node)riferimento, (String)"role", (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/") : SoapUtils.getAttributeNode((Node)riferimento, (String)"role");
                    role = roleFind.getNodeValue();
                }
                catch (Exception e) {
                    roleError = true;
                }
                if (role == null) {
                    roleError = true;
                }
                if (roleError) {
                    ecc3 = new Eccezione();
                    ecc3.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                    ecc3.setCodiceEccezione("EGOV_IT_003");
                    ecc3.setRilevanza("GRAVE");
                    ecc3.setPosizione("SOAPBody/Descrizione/DescrizioneMessaggio/Riferimento/role");
                    this.erroriValidazione.add(ecc3);
                    continue;
                }
                if (proprietaManifestAttachments.getRoleRichiesta().equalsIgnoreCase(role) || proprietaManifestAttachments.getRoleRisposta().equalsIgnoreCase(role)) {
                    if (isRichiesta || isRisposta) {
                        ecc3 = new Eccezione();
                        ecc3.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                        ecc3.setCodiceEccezione("EGOV_IT_003");
                        ecc3.setRilevanza("GRAVE");
                        String posizioneErrore = "SOAPBody/Descrizione/DescrizioneMessaggio/Riferimento/role (@RICHIESTA@/@RISPOSTA@) non univoco";
                        posizioneErrore = posizioneErrore.replace("@RICHIESTA@", proprietaManifestAttachments.getRoleRichiesta());
                        posizioneErrore = posizioneErrore.replace("@RISPOSTA@", proprietaManifestAttachments.getRoleRisposta());
                        ecc3.setPosizione(posizioneErrore);
                        this.erroriValidazione.add(ecc3);
                        continue;
                    }
                    if (proprietaManifestAttachments.getRoleRichiesta().equalsIgnoreCase(role)) {
                        isRichiesta = true;
                    } else {
                        isRisposta = true;
                    }
                }
                String id = null;
                boolean idError = false;
                try {
                    Node idFind = SoapUtils.getQualifiedAttributeNode((Node)riferimento, (String)"id", (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/");
                    id = idFind.getNodeValue();
                }
                catch (Exception e) {
                    idError = true;
                }
                if (id == null) {
                    idError = true;
                }
                if (idError) {
                    Eccezione ecc9 = new Eccezione();
                    ecc9.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                    ecc9.setCodiceEccezione("EGOV_IT_003");
                    ecc9.setRilevanza("GRAVE");
                    ecc9.setPosizione("SOAPBody/Descrizione/DescrizioneMessaggio/Riferimento/id");
                    this.erroriValidazione.add(ecc9);
                    continue;
                }
                NodeList elementiRiferimento = riferimento.getChildNodes();
                if (elementiRiferimento.getLength() != 2) {
                    Eccezione ecc10 = new Eccezione();
                    ecc10.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                    ecc10.setCodiceEccezione("EGOV_IT_003");
                    ecc10.setRilevanza("GRAVE");
                    ecc10.setPosizione("SOAPBody/Descrizione/DescrizioneMessaggio/Riferimento child size:" + elementiRiferimento.getLength());
                    this.erroriValidazione.add(ecc10);
                    continue;
                }
                Node child = elementiRiferimento.item(0);
                Node schema = null;
                Node titolo = null;
                if (SoapUtils.matchLocalName((Node)child, (String)"Schema", (String)prefixManifest, (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/")) {
                    schema = child;
                    titolo = elementiRiferimento.item(1);
                } else if (SoapUtils.matchLocalName((Node)child, (String)"Titolo", (String)prefixManifest, (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/")) {
                    titolo = child;
                    schema = elementiRiferimento.item(1);
                } else {
                    ecc2 = new Eccezione();
                    ecc2.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                    ecc2.setCodiceEccezione("EGOV_IT_003");
                    ecc2.setRilevanza("GRAVE");
                    ecc2.setPosizione("SOAPBody/Descrizione/DescrizioneMessaggio/Riferimento/child[" + child.getNodeName() + "]");
                    this.erroriValidazione.add(ecc2);
                    continue;
                }
                if (!SoapUtils.matchLocalName((Node)schema, (String)"Schema", (String)prefixManifest, (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/")) {
                    ecc2 = new Eccezione();
                    ecc2.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                    ecc2.setCodiceEccezione("EGOV_IT_003");
                    ecc2.setRilevanza("GRAVE");
                    ecc2.setPosizione("SOAPBody/Descrizione/DescrizioneMessaggio/Riferimento/Schema");
                    this.erroriValidazione.add(ecc2);
                    continue;
                }
                String posizione = null;
                boolean posizioneError = false;
                try {
                    Node posizioneFind = null;
                    posizioneFind = this.readQualifiedAttribute ? SoapUtils.getQualifiedAttributeNode((Node)schema, (String)"posizione", (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/") : SoapUtils.getAttributeNode((Node)schema, (String)"posizione");
                    posizione = posizioneFind.getNodeValue();
                }
                catch (Exception e) {
                    posizioneError = true;
                }
                if (posizione == null) {
                    posizioneError = true;
                }
                if (posizioneError) {
                    ecc = new Eccezione();
                    ecc.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                    ecc.setCodiceEccezione("EGOV_IT_003");
                    ecc.setRilevanza("GRAVE");
                    ecc.setPosizione("SOAPBody/Descrizione/DescrizioneMessaggio/Riferimento/Schema/posizione");
                    this.erroriValidazione.add(ecc);
                    continue;
                }
                if (!SoapUtils.matchLocalName((Node)titolo, (String)"Titolo", (String)prefixManifest, (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/")) {
                    ecc = new Eccezione();
                    ecc.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                    ecc.setCodiceEccezione("EGOV_IT_003");
                    ecc.setRilevanza("GRAVE");
                    ecc.setPosizione("SOAPBody/Descrizione/DescrizioneMessaggio/Riferimento/Titolo");
                    this.erroriValidazione.add(ecc);
                    continue;
                }
                String Lingua = null;
                try {
                    Node LinguaFind = null;
                    LinguaFind = this.readQualifiedAttribute ? SoapUtils.getQualifiedAttributeNode((Node)titolo, (String)"Lingua", (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/") : SoapUtils.getAttributeNode((Node)titolo, (String)"Lingua");
                    Lingua = LinguaFind.getNodeValue();
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (Lingua == null) {
                    Lingua = "it";
                }
                String valoreTitolo = null;
                try {
                    valoreTitolo = titolo.getChildNodes().item(0).getNodeValue();
                    if (valoreTitolo != null) continue;
                    throw new Exception("valore non presente");
                }
                catch (Exception e) {
                    Eccezione ecc11 = new Eccezione();
                    ecc11.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                    ecc11.setCodiceEccezione("EGOV_IT_003");
                    ecc11.setRilevanza("GRAVE");
                    ecc11.setPosizione("SOAPBody/Descrizione/DescrizioneMessaggio/Riferimento/Titolo");
                    this.erroriValidazione.add(ecc11);
                }
            }
            if (!isRichiesta && !isRisposta) {
                Eccezione ecc = new Eccezione();
                ecc.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                ecc.setCodiceEccezione("EGOV_IT_003");
                ecc.setRilevanza("GRAVE");
                String posizioneErrore = "SOAPBody/Descrizione/DescrizioneMessaggio/Riferimento/role (@RICHIESTA@/@RISPOSTA@) non esistente";
                posizioneErrore = posizioneErrore.replace("@RICHIESTA@", proprietaManifestAttachments.getRoleRichiesta());
                posizioneErrore = posizioneErrore.replace("@RISPOSTA@", proprietaManifestAttachments.getRoleRisposta());
                ecc.setPosizione(posizioneErrore);
                this.erroriValidazione.add(ecc);
                return;
            }
            while (contentID.size() > 0) {
                Eccezione ecc = new Eccezione();
                ecc.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                ecc.setCodiceEccezione("EGOV_IT_120");
                ecc.setRilevanza("GRAVE");
                String href = (String)contentID.remove(0);
                if (href == null) {
                    href = (String)contentLocation.remove(0);
                } else {
                    contentLocation.remove(0);
                }
                ecc.setPosizione("SOAPBody/Descrizione/DescrizioneMessaggio/Riferimento/href[" + href + "] non presente");
                this.erroriValidazione.add(ecc);
            }
            return;
        }
        catch (Exception e) {
            this.log.error((Object)"Errore durante la validazione del Manifest degli attachments", (Throwable)e);
            Eccezione ecc = new Eccezione();
            ecc.setContestoCodifica("ErroreProcessamentoMessaggioSPCoop");
            ecc.setCodiceEccezione("EGOV_IT_300");
            ecc.setRilevanza("GRAVE");
            ecc.setPosizione("Manifest degli attachments: errore di processamento");
            this.erroriProcessamento.add(ecc);
            return;
        }
        finally {
            soapBody = null;
        }
    }

    private Date validazioneData(String aDate) {
        try {
            Integer test;
            String[] split = aDate.split("T");
            if (split == null) {
                return null;
            }
            if (split.length != 2) {
                return null;
            }
            String[] date = split[0].split("-");
            if (date == null) {
                return null;
            }
            if (date.length != 3) {
                return null;
            }
            if (date[0].length() != 4) {
                return null;
            }
            try {
                Integer test2 = new Integer(date[0]);
                if (test2 > 2100) {
                    return null;
                }
            }
            catch (Exception e) {
                return null;
            }
            if (date[1].length() != 2) {
                return null;
            }
            if (date[2].length() != 2) {
                return null;
            }
            try {
                Integer mese = new Integer(date[1]);
                if (mese > 12 || mese < 0) {
                    return null;
                }
                Integer giorno = new Integer(date[2]);
                if (giorno < 0) {
                    return null;
                }
                if (giorno > 29 && mese == 2) {
                    return null;
                }
                if (giorno > 30 && (mese == 4 || mese == 6 || mese == 9 || mese == 11)) {
                    return null;
                }
                if (giorno > 31) {
                    return null;
                }
            }
            catch (Exception e) {
                return null;
            }
            String[] ora = split[1].split(":");
            if (ora == null) {
                return null;
            }
            if (ora.length < 3) {
                return null;
            }
            if (ora[0].length() != 2) {
                return null;
            }
            try {
                test = new Integer(ora[0]);
                if (test > 23 || test < 0) {
                    return null;
                }
            }
            catch (Exception e) {
                return null;
            }
            if (ora[1].length() != 2) {
                return null;
            }
            try {
                test = new Integer(ora[1]);
                if (test > 59 || test < 0) {
                    return null;
                }
            }
            catch (Exception e) {
                return null;
            }
            String secondi = null;
            if (ora[2].length() < 2) {
                return null;
            }
            try {
                secondi = "" + ora[2].charAt(0) + ora[2].charAt(1);
                Integer test3 = new Integer(secondi);
                if (test3 > 59 || test3 < 0) {
                    return null;
                }
            }
            catch (Exception e) {
                return null;
            }
            GregorianCalendar calendar = null;
            try {
                calendar = new GregorianCalendar(new Integer(date[0]), new Integer(date[1]) - 1, new Integer(date[2]), new Integer(ora[0]), new Integer(ora[1]), new Integer(secondi));
            }
            catch (Exception e) {
                return null;
            }
            long value = calendar.getTime().getTime();
            return new Date(value);
        }
        catch (Exception error) {
            return null;
        }
    }

    private boolean dataScaduta(String scadenza) {
        Date now = DateManager.getDate();
        SimpleDateFormat dateformat = new SimpleDateFormat("yyyy MM dd HH mm ss");
        String nowFormat = dateformat.format(now);
        String scadenzaFormat = scadenza.replace('-', ' ').replace(':', ' ').replace('T', ' ');
        String[] splitNow = nowFormat.split(" ");
        String[] splitScadenza = scadenzaFormat.split(" ");
        if (this.validazioneData(scadenza) == null) {
            return false;
        }
        try {
            Integer testNowAnno = new Integer(splitNow[0]);
            Integer testScadenzaAnno = new Integer(splitScadenza[0]);
            Integer testNowMese = new Integer(splitNow[1]);
            Integer testScadenzaMese = new Integer(splitScadenza[1]);
            Integer testNowGiorno = new Integer(splitNow[2]);
            Integer testScadenzaGiorno = new Integer(splitScadenza[2]);
            Integer testNowOra = new Integer(splitNow[3]);
            Integer testScadenzaOra = new Integer(splitScadenza[3]);
            Integer testNowMinuti = new Integer(splitNow[4]);
            Integer testScadenzaMinuti = new Integer(splitScadenza[4]);
            Integer testNowSecondi = new Integer(splitNow[5]);
            Integer testScadenzaSecondi = new Integer(splitScadenza[5].charAt(0) + splitScadenza[5].charAt(1));
            if (testNowAnno > testScadenzaAnno) {
                return true;
            }
            if (testNowAnno.intValue() == testScadenzaAnno.intValue() && testNowMese > testScadenzaMese) {
                return true;
            }
            if (testNowAnno.intValue() == testScadenzaAnno.intValue() && testNowMese.intValue() == testScadenzaMese.intValue() && testNowGiorno > testScadenzaGiorno) {
                return true;
            }
            if (testNowAnno.intValue() == testScadenzaAnno.intValue() && testNowMese.intValue() == testScadenzaMese.intValue() && testNowGiorno.intValue() == testScadenzaGiorno.intValue() && testNowOra > testScadenzaOra) {
                return true;
            }
            if (testNowAnno.intValue() == testScadenzaAnno.intValue() && testNowMese.intValue() == testScadenzaMese.intValue() && testNowGiorno.intValue() == testScadenzaGiorno.intValue() && testNowOra.intValue() == testScadenzaOra.intValue() && testNowMinuti > testScadenzaMinuti) {
                return true;
            }
            if (testNowAnno.intValue() == testScadenzaAnno.intValue() && testNowMese.intValue() == testScadenzaMese.intValue() && testNowGiorno.intValue() == testScadenzaGiorno.intValue() && testNowOra.intValue() == testScadenzaOra.intValue() && testNowMinuti.intValue() == testScadenzaMinuti.intValue() && testNowSecondi > testScadenzaSecondi) {
                return true;
            }
        }
        catch (Exception e) {
            return true;
        }
        return false;
    }

    private String formatData(Date data) {
        SimpleDateFormat dateformat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        return dateformat.format(data);
    }

    private void validazioneDatePresentiRispettoDateFuture() {
        int i;
        Eccezione ecc;
        String[] split;
        Date sistema = DateManager.getDate();
        Date dataFuturaMassimaAccettata = new Date(sistema.getTime() + Configurazione.getIntervalloMinutiTolleranzaDateFuture() * 60L * 1000L);
        if (this.busta.getOraRegistrazione() != null && this.busta.getOraRegistrazione().after(dataFuturaMassimaAccettata)) {
            this.log.error((Object)("Data portata nell'ora di registrazione [" + this.formatData(this.busta.getOraRegistrazione()) + "] futura rispetto all'ora attuale di sistema (" + this.formatData(sistema) + ") e l'intervallo di tolleranza impostato a " + Configurazione.getIntervalloMinutiTolleranzaDateFuture() + " minuti"));
            Eccezione ecc2 = new Eccezione();
            ecc2.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
            ecc2.setCodiceEccezione("EGOV_IT_108");
            ecc2.setRilevanza("GRAVE");
            ecc2.setPosizione("Messaggio/OraRegistrazione");
            this.erroriValidazione.add(ecc2);
        }
        if (this.busta.getID() != null && (split = this.busta.getID().split("_")) != null && split.length == 5) {
            Date dataIntoIDEgov = null;
            try {
                SimpleDateFormat dateformat = new SimpleDateFormat("yyyy-MM-dd_HH:mm");
                dataIntoIDEgov = dateformat.parse(split[3] + "_" + split[4]);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (dataIntoIDEgov != null && dataIntoIDEgov.after(dataFuturaMassimaAccettata)) {
                this.log.error((Object)("Data portata nell'identificativo egov [" + this.busta.getID() + "][" + this.formatData(dataIntoIDEgov) + "] futura rispetto all'ora attuale di sistema (" + this.formatData(sistema) + ") e l'intervallo di tolleranza impostato a " + Configurazione.getIntervalloMinutiTolleranzaDateFuture() + " minuti"));
                ecc = new Eccezione();
                ecc.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                ecc.setCodiceEccezione("EGOV_IT_110");
                ecc.setRilevanza("GRAVE");
                ecc.setPosizione("Messaggio/Identificatore");
                this.erroriValidazione.add(ecc);
            }
        }
        for (i = 0; i < this.busta.sizeListaRiscontri(); ++i) {
            Riscontro riscontro = this.busta.getRiscontro(i);
            if (riscontro.getOraRegistrazione() == null || !riscontro.getOraRegistrazione().after(dataFuturaMassimaAccettata)) continue;
            this.log.error((Object)("Data portata nell'ora di registrazione del riscontro con id [" + riscontro.getID() + "] [" + this.formatData(riscontro.getOraRegistrazione()) + "] futura rispetto all'ora attuale di sistema (" + this.formatData(sistema) + ") e l'intervallo di tolleranza impostato a " + Configurazione.getIntervalloMinutiTolleranzaDateFuture() + " minuti"));
            ecc = new Eccezione();
            ecc.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
            ecc.setCodiceEccezione("EGOV_IT_115");
            ecc.setRilevanza("GRAVE");
            ecc.setPosizione("ListaRiscontri/Riscontro/OraRegistrazione");
            this.erroriValidazione.add(ecc);
        }
        for (i = 0; i < this.busta.sizeListaTrasmissioni(); ++i) {
            Trasmissione trasmissione = this.busta.getTrasmissione(i);
            if (trasmissione.getOraRegistrazione() == null || !trasmissione.getOraRegistrazione().after(dataFuturaMassimaAccettata)) continue;
            this.log.error((Object)("Data portata nell'ora di registrazione di una trasmissione [" + this.formatData(trasmissione.getOraRegistrazione()) + "] futura rispetto all'ora attuale di sistema (" + this.formatData(sistema) + ") e l'intervallo di tolleranza impostato a " + Configurazione.getIntervalloMinutiTolleranzaDateFuture() + " minuti"));
            ecc = new Eccezione();
            ecc.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
            ecc.setCodiceEccezione("EGOV_IT_116");
            ecc.setRilevanza("GRAVE");
            ecc.setPosizione("ListaTrasmissioni/Trasmissione/OraRegistrazione");
            this.erroriValidazione.add(ecc);
        }
    }
}

