/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.egov;

import java.util.Iterator;
import java.util.Vector;
import javax.xml.soap.SOAPBody;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.SOAPHeaderElement;
import org.apache.log4j.Logger;
import org.openspcoop.egov.Configurazione;
import org.openspcoop.egov.Eccezione;
import org.openspcoop.utils.xml.ValidatoreXSD;
import org.openspcoop.utils.xml.XSDResourceResolver;
import org.w3c.dom.Node;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidazioneConSchemaSPCoop {
    private Logger log = null;
    private static ValidatoreXSD validatoreBustaSPCoop = null;
    private Vector<Eccezione> erroriValidazione;
    private Vector<Eccezione> erroriProcessamento;
    private javax.xml.soap.SOAPHeaderElement busta;
    private SOAPBody soapBody;
    private boolean isSPCoopErroreProcessamento = false;
    private boolean isSPCoopErroreIntestazione = false;

    public ValidazioneConSchemaSPCoop(javax.xml.soap.SOAPHeaderElement header, SOAPBody soapBody, boolean isSPCoopErroreProcessamento, boolean isSPCoopErroreIntestazione) {
        this(header, soapBody, isSPCoopErroreProcessamento, isSPCoopErroreIntestazione, Configurazione.getLibraryLog());
    }

    public ValidazioneConSchemaSPCoop(javax.xml.soap.SOAPHeaderElement header, SOAPBody soapBody, boolean isSPCoopErroreProcessamento, boolean isSPCoopErroreIntestazione, Logger aLog) {
        this.busta = header;
        this.soapBody = soapBody;
        this.log = aLog != null ? aLog : Logger.getLogger((String)"ValidazioneConSchemaSPCoop");
        this.isSPCoopErroreProcessamento = isSPCoopErroreProcessamento;
        this.isSPCoopErroreIntestazione = isSPCoopErroreIntestazione;
    }

    public Vector<Eccezione> getEccezioniValidazione() {
        return this.erroriValidazione;
    }

    public Vector<Eccezione> getEccezioniProcessamento() {
        return this.erroriProcessamento;
    }

    public static synchronized boolean initializeSchema(Logger log, String[] schemiDaImportare) {
        if (validatoreBustaSPCoop != null) {
            return true;
        }
        if (log == null) {
            log = Logger.getLogger((String)"ValidazioneConSchemaSPCoop");
        }
        try {
            log.info((Object)"Inizializzazione dello schema di OpenSPCoop (possono essere necessari alcuni minuti...)");
            XSDResourceResolver xsdResourceResolver = new XSDResourceResolver();
            if (schemiDaImportare != null) {
                for (int i = 0; i < schemiDaImportare.length; ++i) {
                    xsdResourceResolver.addResource(schemiDaImportare[i], ValidazioneConSchemaSPCoop.class.getResourceAsStream("/" + schemiDaImportare[i]));
                }
            }
            validatoreBustaSPCoop = new ValidatoreXSD((LSResourceResolver)xsdResourceResolver, ValidazioneConSchemaSPCoop.class.getResourceAsStream("/Busta.xsd"));
            log.info((Object)"Inizializzazione dello schema di OpenSPCoop terminata.");
            return true;
        }
        catch (Exception e) {
            log.error((Object)("Riscontrato errore durante l'inizializzazione dello schema di OpenSPCoop: " + e.getMessage()), (Throwable)e);
            validatoreBustaSPCoop = null;
            return false;
        }
    }

    public void valida() throws Exception {
        Eccezione ecc;
        this.erroriValidazione = new Vector();
        this.erroriProcessamento = new Vector();
        if (validatoreBustaSPCoop == null) {
            throw new Exception("Validatore con schema XSD non inizializzato");
        }
        try {
            SOAPHeaderElement header = (SOAPHeaderElement)this.busta;
            if (!this.isSPCoopErroreProcessamento && !this.isSPCoopErroreIntestazione) {
                validatoreBustaSPCoop.valida((Node)header.getAsDocument());
            } else {
                Iterator itChilds = header.getChildElements();
                MessageElement listaEccezioni = null;
                while (itChilds.hasNext()) {
                    MessageElement elemInterno = (MessageElement)itChilds.next();
                    if (!"ListaEccezioni".equals(elemInterno.getLocalName())) continue;
                    listaEccezioni = elemInterno;
                    break;
                }
                if (listaEccezioni == null && this.isSPCoopErroreIntestazione) {
                    throw new SAXException("ListaEccezioni non presente in un messaggio SPCoopErrore");
                }
                if (listaEccezioni != null) {
                    validatoreBustaSPCoop.valida((Node)listaEccezioni.getAsDocument());
                }
            }
        }
        catch (SAXException e) {
            ecc = new Eccezione();
            ecc.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
            ecc.setCodiceEccezione("EGOV_IT_002");
            ecc.setRilevanza("GRAVE");
            ecc.setPosizione(e.getMessage());
            this.erroriValidazione.add(ecc);
        }
        catch (Exception e) {
            ecc = new Eccezione();
            ecc.setContestoCodifica("ErroreProcessamentoMessaggioSPCoop");
            ecc.setCodiceEccezione("EGOV_IT_300");
            ecc.setRilevanza("GRAVE");
            ecc.setPosizione("Validazione con schema xsd dell'header egov non riuscita: errore di processamento");
            this.log.error((Object)"Validazione con schema xsd dell'header egov non riuscita non riuscita", (Throwable)e);
            this.erroriProcessamento.add(ecc);
        }
        if (this.soapBody != null) {
            try {
                validatoreBustaSPCoop.valida((Node)((MessageElement)this.soapBody.getFirstChild()).getAsDocument());
            }
            catch (SAXException e) {
                ecc = new Eccezione();
                ecc.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                ecc.setCodiceEccezione("EGOV_IT_003");
                ecc.setRilevanza("GRAVE");
                ecc.setPosizione("ManifestAttachments: " + e.getMessage());
                this.erroriValidazione.add(ecc);
            }
            catch (Exception e) {
                ecc = new Eccezione();
                ecc.setContestoCodifica("ErroreProcessamentoMessaggioSPCoop");
                ecc.setCodiceEccezione("EGOV_IT_300");
                ecc.setRilevanza("GRAVE");
                ecc.setPosizione("Validazione con schema xsd del manifest degli attachments non riuscita: errore di processamento");
                this.log.error((Object)"Validazione con schema xsd del manifest degli attachments non riuscita", (Throwable)e);
                this.erroriProcessamento.add(ecc);
            }
        }
    }
}

