/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.egov;

import java.util.Vector;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPMessage;
import org.apache.axis.Message;
import org.apache.log4j.Logger;
import org.openspcoop.dao.commons.IDSoggetto;
import org.openspcoop.dao.registry.driver.IDServizio;
import org.openspcoop.dao.state.IState;
import org.openspcoop.egov.Busta;
import org.openspcoop.egov.Configurazione;
import org.openspcoop.egov.EGovException;
import org.openspcoop.egov.Eccezione;
import org.openspcoop.egov.ProprietaManifestAttachments;
import org.openspcoop.egov.ProprietaValidazione;
import org.openspcoop.egov.RuoloBustaEGov;
import org.openspcoop.egov.ServizioEGov;
import org.openspcoop.egov.ValidazioneConSchemaSPCoop;
import org.openspcoop.egov.ValidazioneSemantica;
import org.openspcoop.egov.ValidazioneSintattica;
import org.openspcoop.wssecurity.WSSBaseUtils;
import org.openspcoop.wssecurity.WSSReceiver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidatoreSPCoop {
    private IState state;
    private Message msg;
    private ProprietaValidazione proprietaValidazione;
    private String msgErrore;
    private String codiceErrore;
    private Vector<Eccezione> erroriValidazione;
    private Vector<Eccezione> erroriProcessamento;
    private boolean isMessaggioSPCoopErrore;
    private boolean isMessaggioSPCoopErroreIntestazione;
    private boolean isMessaggioSPCoopErroreProcessamento;
    private boolean isBustaDiServizio;
    private Busta busta;
    private IDSoggetto mittente;
    private IDServizio servizio;
    private ValidazioneSintattica validatoreSintattico;
    private String servizioCorrelato;
    private String tipoServizioCorrelato;
    private ServizioEGov infoServizio = null;
    private String profiloGestione = null;
    private RuoloBustaEGov ruoloBustaEgovRicevuta = null;
    private boolean readQualifiedAttribute;
    private Logger log = null;
    private Busta bustaErroreHeaderIntestazione = null;
    private Exception eccezioneProcessamentoValidazioneSintattica = null;
    private Exception eccezioneProcessamentoValidazioneSemantica = null;

    public ValidazioneSintattica getValidatoreSintattico() {
        return this.validatoreSintattico;
    }

    public void setValidatoreSintattico(ValidazioneSintattica validator) {
        this.validatoreSintattico = validator;
    }

    public Busta getBustaErroreHeaderIntestazione() {
        return this.bustaErroreHeaderIntestazione;
    }

    public ValidatoreSPCoop(Message aMsg, ProprietaValidazione aValidazione, IState state, boolean readQualifiedAttribute) {
        this(aMsg, aValidazione, state, Configurazione.getLibraryLog(), readQualifiedAttribute);
    }

    public ValidatoreSPCoop(Message aMsg, ProprietaValidazione aValidazione, IState state, Logger alog, boolean readQualifiedAttribute) {
        this.msg = aMsg;
        this.proprietaValidazione = aValidazione == null ? new ProprietaValidazione() : aValidazione;
        this.state = state;
        this.log = alog != null ? alog : Logger.getLogger((String)"ValidatoreSPCoop");
        this.readQualifiedAttribute = readQualifiedAttribute;
    }

    public ValidatoreSPCoop(Message aMsg, Logger alog) {
        this(aMsg, null, null, alog, false);
    }

    public static boolean isBustaSPCoopErrore(Busta busta, String profiloGestione, Message msg) {
        boolean eccezioneProcessamento;
        block7: {
            eccezioneProcessamento = false;
            try {
                if (msg != null && msg.getSOAPBody() != null && msg.getSOAPBody().hasFault()) {
                    SOAPFault soapFault = msg.getSOAPBody().getFault();
                    String faultS = soapFault.getFaultString();
                    if (faultS != null) {
                        faultS = faultS.trim();
                    }
                    if ("EGOV_IT_300 - Errore nel processamento del messaggio SPCoop".equals(faultS)) {
                        eccezioneProcessamento = true;
                    }
                }
            }
            catch (Exception e) {
                if (Configurazione.getLibraryLog() == null) break block7;
                Configurazione.getLibraryLog().error((Object)("Errore durante l'analisi per comprendere se un msg e' una busta SPCoop Errore: " + e.getMessage()), (Throwable)e);
            }
        }
        if (eccezioneProcessamento) {
            return true;
        }
        if ("eGov1.1-lineeGuida1.1".equals(profiloGestione) || Configurazione.isIgnoraEccezioniNonGravi()) {
            return busta.containsEccezioniGravi();
        }
        return busta.sizeListaEccezioni() > 0;
    }

    public static boolean isBustaSPCoopErroreProcessamento(Busta busta, String profiloGestione, Message msg) {
        boolean eccezioneProcessamento;
        block5: {
            eccezioneProcessamento = false;
            try {
                if (msg != null && msg.getSOAPBody() != null && msg.getSOAPBody().hasFault()) {
                    SOAPFault soapFault = msg.getSOAPBody().getFault();
                    String faultS = soapFault.getFaultString();
                    if (faultS != null) {
                        faultS = faultS.trim();
                    }
                    if ("EGOV_IT_300 - Errore nel processamento del messaggio SPCoop".equals(faultS)) {
                        eccezioneProcessamento = true;
                    }
                }
            }
            catch (Exception e) {
                if (Configurazione.getLibraryLog() == null) break block5;
                Configurazione.getLibraryLog().error((Object)("Errore durante l'analisi per comprendere se un msg e' una busta SPCoop Errore: " + e.getMessage()), (Throwable)e);
            }
        }
        return eccezioneProcessamento;
    }

    public static boolean isBustaSPCoopErroreIntestazione(Busta busta, String profiloGestione, Message msg) {
        boolean eccezioneProcessamento;
        block7: {
            eccezioneProcessamento = false;
            try {
                if (msg != null && msg.getSOAPBody() != null && msg.getSOAPBody().hasFault()) {
                    SOAPFault soapFault = msg.getSOAPBody().getFault();
                    String faultS = soapFault.getFaultString();
                    if (faultS != null) {
                        faultS = faultS.trim();
                    }
                    if ("EGOV_IT_300 - Errore nel processamento del messaggio SPCoop".equals(faultS)) {
                        eccezioneProcessamento = true;
                    }
                }
            }
            catch (Exception e) {
                if (Configurazione.getLibraryLog() == null) break block7;
                Configurazione.getLibraryLog().error((Object)("Errore durante l'analisi per comprendere se un msg e' una busta SPCoop Errore: " + e.getMessage()), (Throwable)e);
            }
        }
        if (eccezioneProcessamento) {
            return false;
        }
        if ("eGov1.1-lineeGuida1.1".equals(profiloGestione) || Configurazione.isIgnoraEccezioniNonGravi()) {
            return busta.containsEccezioniGravi();
        }
        return busta.sizeListaEccezioni() > 0;
    }

    public SOAPHeaderElement getHeaderEGov_senzaControlli() throws EGovException {
        this.validatoreSintattico = new ValidazioneSintattica(this.msg, this.log);
        return this.validatoreSintattico.getHeaderEGov_senzaControlli();
    }

    public boolean validazioneSintattica() {
        try {
            this.validatoreSintattico = new ValidazioneSintattica(this.msg, this.log, this.readQualifiedAttribute);
            if (!this.validatoreSintattico.valida()) {
                this.msgErrore = this.validatoreSintattico.getMsgErrore();
                this.codiceErrore = this.validatoreSintattico.getCodiceErrore();
                this.bustaErroreHeaderIntestazione = this.validatoreSintattico.getBustaErroreHeaderIntestazione();
                return false;
            }
            this.busta = this.validatoreSintattico.getBusta();
            this.isMessaggioSPCoopErrore = ValidatoreSPCoop.isBustaSPCoopErrore(this.busta, null, this.msg);
            this.isMessaggioSPCoopErroreIntestazione = ValidatoreSPCoop.isBustaSPCoopErroreIntestazione(this.busta, null, this.msg);
            this.isMessaggioSPCoopErroreProcessamento = ValidatoreSPCoop.isBustaSPCoopErroreProcessamento(this.busta, null, this.msg);
            if (this.busta.getServizio() == null && this.busta.getRiferimentoMessaggio() == null) {
                this.isBustaDiServizio = true;
            }
            this.erroriValidazione = this.isMessaggioSPCoopErrore ? this.validatoreSintattico.getErroriTrovatiSullaListaEccezioni() : this.validatoreSintattico.getEccezioniValidazione();
            this.erroriProcessamento = this.validatoreSintattico.getEccezioniProcessamento();
            if (this.isBustaDiServizio && this.busta.sizeListaEccezioni() <= 0 && this.busta.sizeListaRiscontri() <= 0) {
                Eccezione ec = Eccezione.getEccezioneValidazione("EGOV_IT_105", "Servizio");
                this.erroriValidazione.add(ec);
                this.isBustaDiServizio = false;
            }
            this.mittente = new IDSoggetto(this.busta.getTipoMittente(), this.busta.getMittente());
            this.servizio = new IDServizio(this.busta.getTipoDestinatario(), this.busta.getDestinatario(), this.busta.getTipoServizio(), this.busta.getServizio(), this.busta.getAzione());
            if (this.erroriValidazione.size() > 0 || this.erroriProcessamento.size() > 0) {
                return true;
            }
            return true;
        }
        catch (Exception e) {
            this.log.error((Object)"validazioneSintattica", (Throwable)e);
            this.eccezioneProcessamentoValidazioneSintattica = e;
            this.msgErrore = "Errore di processamento " + e.getMessage();
            this.codiceErrore = "ErroreDiProcessamento";
            return false;
        }
    }

    public Exception getEccezioneProcessamentoValidazioneSintattica() {
        return this.eccezioneProcessamentoValidazioneSintattica;
    }

    public boolean validazioneSemantica(WSSReceiver wssReceiver, boolean rispostaConnectionReply, String profiloGestione, ProprietaManifestAttachments proprietaManifestAttachments, boolean validazioneIDEGovCompleta) {
        try {
            if (this.validatoreSintattico == null) {
                this.msgErrore = "Errore di processamento: Analisi sintattica richiesta";
                this.codiceErrore = "ErroreDiProcessamento";
                return false;
            }
            if (this.ruoloBustaEgovRicevuta == null) {
                this.ruoloBustaEgovRicevuta = ValidazioneSemantica.getTipoBustaDaValidare(this.busta, rispostaConnectionReply, this.state, this.log);
            }
            try {
                this.profiloGestione = rispostaConnectionReply ? profiloGestione : ValidazioneSemantica.riconoscimentoProfiloGestitoServizioErogato(this.busta, this.ruoloBustaEgovRicevuta);
            }
            catch (Exception e) {
                this.log.error((Object)"Riconoscimento profilo di gestione non riuscito", (Throwable)e);
            }
            if ("eGov1.1-lineeGuida1.1".equals(this.profiloGestione) && this.isMessaggioSPCoopErrore) {
                this.isMessaggioSPCoopErrore = ValidatoreSPCoop.isBustaSPCoopErrore(this.busta, this.profiloGestione, this.msg);
                this.isMessaggioSPCoopErroreIntestazione = ValidatoreSPCoop.isBustaSPCoopErroreIntestazione(this.busta, this.profiloGestione, this.msg);
                this.isMessaggioSPCoopErroreProcessamento = ValidatoreSPCoop.isBustaSPCoopErroreProcessamento(this.busta, this.profiloGestione, this.msg);
            }
            if (this.erroriValidazione.size() > 0 || this.erroriProcessamento.size() > 0) {
                return true;
            }
            if (!(wssReceiver == null || this.isMessaggioSPCoopErrore && !WSSBaseUtils.existsHeaderWSS((SOAPMessage)this.msg, wssReceiver.getActor(), this.log) || wssReceiver.process(this.msg, this.busta))) {
                Eccezione ecc = new Eccezione(wssReceiver.getCodiceErrore(), wssReceiver.getMsgErrore(), true);
                this.erroriValidazione.add(ecc);
                return true;
            }
            if (this.isMessaggioSPCoopErrore) {
                this.validatoreSintattico.validazioneFault(this.msg.getSOAPBody());
                this.erroriValidazione = this.validatoreSintattico.getErroriTrovatiSullaListaEccezioni();
                this.erroriProcessamento = this.validatoreSintattico.getEccezioniProcessamento();
                if (this.erroriValidazione.size() > 0 || this.erroriProcessamento.size() > 0) {
                    return true;
                }
            }
            if (!this.isMessaggioSPCoopErrore && this.proprietaValidazione.isValidazioneManifestAttachments() && this.msg.countAttachments() > 0) {
                this.validatoreSintattico.validazioneManifestAttachments(this.msg, proprietaManifestAttachments);
                this.erroriValidazione = this.validatoreSintattico.getEccezioniValidazione();
                this.erroriProcessamento = this.validatoreSintattico.getEccezioniProcessamento();
                if (this.erroriValidazione.size() > 0 || this.erroriProcessamento.size() > 0) {
                    return true;
                }
            }
            if (!this.isMessaggioSPCoopErrore) {
                ValidazioneSemantica registryValidator = new ValidazioneSemantica(this.busta, this.state, validazioneIDEGovCompleta, this.log);
                registryValidator.valida(this.proprietaValidazione, this.ruoloBustaEgovRicevuta, this.profiloGestione);
                this.erroriValidazione = registryValidator.getEccezioniValidazione();
                this.erroriProcessamento = registryValidator.getEccezioniProcessamento();
                this.servizioCorrelato = registryValidator.getServizioCorrelato();
                this.tipoServizioCorrelato = registryValidator.getTipoServizioCorrelato();
                this.infoServizio = registryValidator.getInfoServizio();
                if (this.erroriValidazione.size() > 0 || this.erroriProcessamento.size() > 0) {
                    return true;
                }
            }
            if (this.proprietaValidazione.isValidazioneConSchema()) {
                SOAPBody body = null;
                if (this.proprietaValidazione.isValidazioneManifestAttachments() && this.msg.countAttachments() > 0) {
                    body = this.msg.getSOAPBody();
                }
                ValidazioneConSchemaSPCoop schemaValidator = new ValidazioneConSchemaSPCoop(this.validatoreSintattico.getHeaderSPCoop(), body, this.isMessaggioSPCoopErroreProcessamento, this.isMessaggioSPCoopErroreIntestazione, this.log);
                schemaValidator.valida();
                this.erroriValidazione = schemaValidator.getEccezioniValidazione();
                this.erroriProcessamento = schemaValidator.getEccezioniProcessamento();
                if (this.erroriValidazione.size() > 0 || this.erroriProcessamento.size() > 0) {
                    return true;
                }
            }
        }
        catch (Exception e) {
            this.log.error((Object)"validazioneSemantica", (Throwable)e);
            this.eccezioneProcessamentoValidazioneSemantica = e;
            this.msgErrore = "Errore di processamento ";
            this.codiceErrore = "ErroreDiProcessamento";
            return false;
        }
        return true;
    }

    public Exception getEccezioneProcessamentoValidazioneSemantica() {
        return this.eccezioneProcessamentoValidazioneSemantica;
    }

    public String getMsgErrore() {
        return this.msgErrore;
    }

    public String getCodiceErrore() {
        return this.codiceErrore;
    }

    public boolean validazioneConEccezioni() {
        return this.erroriValidazione.size() > 0 || this.erroriProcessamento.size() > 0;
    }

    public Vector<Eccezione> getEccezioniValidazione() {
        return this.erroriValidazione;
    }

    public Vector<Eccezione> getEccezioniProcessamento() {
        return this.erroriProcessamento;
    }

    public boolean isSPCoopErrore() {
        return this.isMessaggioSPCoopErrore;
    }

    public boolean isMessaggioSPCoopErroreIntestazione() {
        return this.isMessaggioSPCoopErroreIntestazione;
    }

    public boolean isMessaggioSPCoopErroreProcessamento() {
        return this.isMessaggioSPCoopErroreProcessamento;
    }

    public boolean isBustaDiServizio() {
        return this.isBustaDiServizio;
    }

    public Busta getBusta() {
        return this.busta;
    }

    public IDSoggetto getSoggettoMittente() {
        return this.mittente;
    }

    public IDServizio getIDServizio() {
        return this.servizio;
    }

    public String getServizioCorrelato() {
        return this.servizioCorrelato;
    }

    public String getTipoServizioCorrelato() {
        return this.tipoServizioCorrelato;
    }

    public SOAPHeaderElement getHeaderEGov() throws Exception {
        return this.validatoreSintattico.getHeaderEGov();
    }

    public ServizioEGov getInfoServizio() {
        return this.infoServizio;
    }

    public String getProfiloGestione() {
        return this.profiloGestione;
    }

    public void setProfiloGestione(String profiloGestione) {
        this.profiloGestione = profiloGestione;
    }

    public RuoloBustaEGov getRuoloBustaEgovRicevuta(boolean rispostaConnectionReply) throws EGovException {
        if (this.ruoloBustaEgovRicevuta == null) {
            this.ruoloBustaEgovRicevuta = ValidazioneSemantica.getTipoBustaDaValidare(this.busta, rispostaConnectionReply, this.state, this.log);
        }
        return this.ruoloBustaEgovRicevuta;
    }

    public void setProprietaValidazione(ProprietaValidazione proprietaValidazione) {
        this.proprietaValidazione = proprietaValidazione;
    }
}

