/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.egov;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Statement;
import org.apache.log4j.Logger;
import org.openspcoop.dao.state.IState;
import org.openspcoop.dao.state.StateMessage;
import org.openspcoop.egov.Configurazione;
import org.openspcoop.egov.EGovException;
import org.openspcoop.egov.IGestoreRepositoryEGov;

public class RollbackRepositoryEGov
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger log = null;
    private IState state;
    private String idEGov;
    private IGestoreRepositoryEGov gestoreRepositoryEGov;

    public RollbackRepositoryEGov(String id, IState state, boolean oneWay11) {
        this(id, state, Configurazione.getLibraryLog(), oneWay11);
    }

    public RollbackRepositoryEGov(String id, IState state, Logger aLog, boolean oneWay11) {
        this.idEGov = id;
        this.state = state;
        this.gestoreRepositoryEGov = Configurazione.getGestoreRepositoryEGov();
        this.log = aLog != null ? aLog : Logger.getLogger((String)RollbackRepositoryEGov.class.getName());
    }

    public void rollbackBustaIntoOutBox() throws EGovException {
        this.rollback("OUTBOX", true);
    }

    public void rollbackBustaIntoOutBox(boolean rollbackAccessoHistory) throws EGovException {
        this.rollback("OUTBOX", rollbackAccessoHistory);
    }

    public void rollbackBustaIntoInBox() throws EGovException {
        this.rollback("INBOX", true);
    }

    public void rollbackBustaIntoInBox(boolean rollbackAccessoHistory) throws EGovException {
        this.rollback("INBOX", rollbackAccessoHistory);
    }

    public void rollback(String tipoBusta, boolean rollbackAccessoHistory) throws EGovException {
        StateMessage stateMSG = (StateMessage)this.state;
        Connection connectionDB = stateMSG.getConnectionDB();
        if (connectionDB != null) {
            Statement pstmtUpdateHistory = null;
            PreparedStatement pstmtUpdateProfilo = null;
            Statement pstmtUpdatePdd = null;
            try {
                if (rollbackAccessoHistory) {
                    StringBuffer queryUpdateHistory = new StringBuffer();
                    queryUpdateHistory.append("UPDATE ");
                    queryUpdateHistory.append("REPOSITORY_EGOV");
                    queryUpdateHistory.append(" SET ");
                    queryUpdateHistory.append(this.gestoreRepositoryEGov.createSQLSet_History(false));
                    queryUpdateHistory.append(" WHERE ID_EGOV = ? AND TIPO=?");
                    pstmtUpdateHistory = connectionDB.prepareStatement(queryUpdateHistory.toString());
                    pstmtUpdateHistory.setString(1, this.idEGov);
                    pstmtUpdateHistory.setString(2, tipoBusta);
                    stateMSG.getPreparedStatement().put("RollbackGeneraleHISTORY_" + tipoBusta + "_" + this.idEGov, (PreparedStatement)pstmtUpdateHistory);
                }
                StringBuffer queryUpdateProfilo = new StringBuffer();
                queryUpdateProfilo.append("UPDATE ");
                queryUpdateProfilo.append("REPOSITORY_EGOV");
                queryUpdateProfilo.append(" SET ");
                queryUpdateProfilo.append(this.gestoreRepositoryEGov.createSQLSet_ProfiloCollaborazione(false));
                queryUpdateProfilo.append(" WHERE ID_EGOV = ? AND TIPO=?");
                pstmtUpdateProfilo = connectionDB.prepareStatement(queryUpdateProfilo.toString());
                pstmtUpdateProfilo.setString(1, this.idEGov);
                pstmtUpdateProfilo.setString(2, tipoBusta);
                stateMSG.getPreparedStatement().put("RollbackGeneralePROFILO_" + tipoBusta + "_" + this.idEGov, pstmtUpdateProfilo);
                StringBuffer queryUpdatePdd = new StringBuffer();
                queryUpdatePdd.append("UPDATE ");
                queryUpdatePdd.append("REPOSITORY_EGOV");
                queryUpdatePdd.append(" SET ");
                queryUpdatePdd.append(this.gestoreRepositoryEGov.createSQLSet_PdD(false));
                queryUpdatePdd.append(" WHERE ID_EGOV = ? AND TIPO=?");
                pstmtUpdatePdd = connectionDB.prepareStatement(queryUpdatePdd.toString());
                pstmtUpdatePdd.setString(1, this.idEGov);
                pstmtUpdatePdd.setString(2, tipoBusta);
                stateMSG.getPreparedStatement().put("RollbackGeneralePDD_" + tipoBusta + "_" + this.idEGov, (PreparedStatement)pstmtUpdatePdd);
            }
            catch (Exception e) {
                String errorMsg = "ROLLBACK_EGOV, Errore " + tipoBusta + "/" + this.idEGov + ": " + e.getMessage();
                this.log.info((Object)errorMsg, (Throwable)e);
                try {
                    if (pstmtUpdateHistory != null) {
                        pstmtUpdateHistory.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                try {
                    if (pstmtUpdateProfilo != null) {
                        pstmtUpdateProfilo.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                try {
                    if (pstmtUpdatePdd != null) {
                        pstmtUpdatePdd.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                throw new EGovException(errorMsg, e);
            }
        }
        this.log.debug((Object)("Rollback(" + tipoBusta + "/" + this.idEGov + ") non effettuato, connessione is null"));
    }

    public void clearAccessiIntoInBox(boolean history, boolean profilo, boolean pdd) throws EGovException {
        this.clearAccessi("INBOX", history, profilo, pdd);
    }

    public void clearAccessiIntoOutBox(boolean history, boolean profilo, boolean pdd) throws EGovException {
        this.clearAccessi("OUTBOX", history, profilo, pdd);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void clearAccessi(String tipoBusta, boolean history, boolean profilo, boolean pdd) throws EGovException {
        StateMessage stateMSG = (StateMessage)this.state;
        Connection connectionDB = stateMSG.getConnectionDB();
        if (connectionDB != null) {
            Statement pstmtUpdateHistory = null;
            Statement pstmtUpdateProfilo = null;
            Statement pstmtUpdatePdd = null;
            try {
                if (!(history || profilo || pdd)) {
                    return;
                }
                if (history) {
                    StringBuffer queryUpdateHistory = new StringBuffer();
                    queryUpdateHistory.append("UPDATE ");
                    queryUpdateHistory.append("REPOSITORY_EGOV");
                    queryUpdateHistory.append(" SET ");
                    queryUpdateHistory.append(this.gestoreRepositoryEGov.createSQLSet_History(false));
                    queryUpdateHistory.append(" WHERE ID_EGOV = ? AND TIPO=?");
                    pstmtUpdateHistory = connectionDB.prepareStatement(queryUpdateHistory.toString());
                    pstmtUpdateHistory.setString(1, this.idEGov);
                    pstmtUpdateHistory.setString(2, tipoBusta);
                    stateMSG.getPreparedStatement().put("ClearAccessiHISTORY_" + tipoBusta + "_" + this.idEGov, (PreparedStatement)pstmtUpdateHistory);
                }
                if (profilo) {
                    StringBuffer queryUpdateProfilo = new StringBuffer();
                    queryUpdateProfilo.append("UPDATE ");
                    queryUpdateProfilo.append("REPOSITORY_EGOV");
                    queryUpdateProfilo.append(" SET ");
                    queryUpdateProfilo.append(this.gestoreRepositoryEGov.createSQLSet_ProfiloCollaborazione(false));
                    queryUpdateProfilo.append(" WHERE ID_EGOV = ? AND TIPO=?");
                    pstmtUpdateProfilo = connectionDB.prepareStatement(queryUpdateProfilo.toString());
                    pstmtUpdateProfilo.setString(1, this.idEGov);
                    pstmtUpdateProfilo.setString(2, tipoBusta);
                    stateMSG.getPreparedStatement().put("ClearAccessiPROFILO_" + tipoBusta + "_" + this.idEGov, (PreparedStatement)pstmtUpdateProfilo);
                }
                if (!pdd) return;
                StringBuffer queryUpdatePdd = new StringBuffer();
                queryUpdatePdd.append("UPDATE ");
                queryUpdatePdd.append("REPOSITORY_EGOV");
                queryUpdatePdd.append(" SET ");
                queryUpdatePdd.append(this.gestoreRepositoryEGov.createSQLSet_PdD(false));
                queryUpdatePdd.append(" WHERE ID_EGOV = ? AND TIPO=?");
                pstmtUpdatePdd = connectionDB.prepareStatement(queryUpdatePdd.toString());
                pstmtUpdatePdd.setString(1, this.idEGov);
                pstmtUpdatePdd.setString(2, tipoBusta);
                stateMSG.getPreparedStatement().put("ClearAccessiPDD_" + tipoBusta + "_" + this.idEGov, (PreparedStatement)pstmtUpdatePdd);
                return;
            }
            catch (Exception e) {
                String errorMsg = "ROLLBACK_EGOV, setAccessi Errore " + tipoBusta + "/" + this.idEGov + ": " + e.getMessage();
                this.log.info((Object)errorMsg, (Throwable)e);
                try {
                    if (pstmtUpdateHistory != null) {
                        pstmtUpdateHistory.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                try {
                    if (pstmtUpdateProfilo != null) {
                        pstmtUpdateProfilo.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                try {
                    if (pstmtUpdatePdd == null) throw new EGovException(errorMsg, e);
                    pstmtUpdatePdd.close();
                    throw new EGovException(errorMsg, e);
                }
                catch (Exception er) {
                    // empty catch block
                }
                throw new EGovException(errorMsg, e);
            }
        }
        this.log.debug((Object)("clearAccessi(" + tipoBusta + "/" + this.idEGov + ") non effettuato, connessione is null"));
    }
}

