/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.egov;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.openspcoop.dao.commons.IDSoggetto;
import org.openspcoop.dao.registry.driver.IDServizio;
import org.openspcoop.dao.state.IState;
import org.openspcoop.dao.state.StateMessage;
import org.openspcoop.dao.state.StatefulMessage;
import org.openspcoop.dao.state.StatelessMessage;
import org.openspcoop.egov.Busta;
import org.openspcoop.egov.Configurazione;
import org.openspcoop.egov.EGovException;
import org.openspcoop.egov.Eccezione;
import org.openspcoop.egov.IGestoreRepositoryEGov;
import org.openspcoop.egov.Integrazione;
import org.openspcoop.egov.LetturaParametriBusta;
import org.openspcoop.egov.ProfiloDiCollaborazione;
import org.openspcoop.egov.Riscontri;
import org.openspcoop.egov.Riscontro;
import org.openspcoop.egov.Trasmissione;
import org.openspcoop.utils.date.DateManager;
import org.openspcoop.utils.sql.ISQLQueryObject;
import org.openspcoop.utils.sql.SQLObjectFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryEGov {
    private Logger log = null;
    private IState state;
    private boolean isRichiesta = true;
    private IGestoreRepositoryEGov gestoreRepositoryEGov;

    public boolean isRichiesta() {
        return this.isRichiesta;
    }

    public void setRichiesta(boolean isRichiesta) {
        this.isRichiesta = isRichiesta;
    }

    public RepositoryEGov(IState state, boolean isRichiesta) {
        this(state, Configurazione.getLibraryLog(), isRichiesta);
    }

    public RepositoryEGov(IState state, Logger alog, boolean isRichiesta) {
        this.state = state;
        this.gestoreRepositoryEGov = Configurazione.getGestoreRepositoryEGov();
        this.log = alog != null ? alog : Logger.getLogger((String)RepositoryEGov.class.getName());
        this.isRichiesta = isRichiesta;
    }

    public RepositoryEGov(IState state) {
        this(state, Configurazione.getLibraryLog());
    }

    public RepositoryEGov(IState state, Logger alog) {
        this.state = state;
        this.gestoreRepositoryEGov = Configurazione.getGestoreRepositoryEGov();
        this.log = alog != null ? alog : Logger.getLogger((String)RepositoryEGov.class.getName());
    }

    public void updateState(IState state) {
        this.state = state;
    }

    public void registraBustaIntoOutBox(Busta busta, long scadenza) throws EGovException {
        this.registraBusta(busta, "OUTBOX", null, scadenza);
    }

    public void registraBustaIntoOutBox(Busta busta, Vector<Eccezione> errors, long scadenza) throws EGovException {
        this.registraBusta(busta, "OUTBOX", errors, scadenza);
    }

    public void registraBustaIntoOutBox(String idEGov, IDSoggetto soggettoFruitore, IDServizio servizio, long scadenza, String profiloCollaborazione, boolean confermaRicezione, String inoltro) throws EGovException {
        Busta busta = new Busta();
        busta.setID(idEGov);
        busta.setTipoMittente(soggettoFruitore.getTipo());
        busta.setMittente(soggettoFruitore.getNome());
        busta.setTipoDestinatario(servizio.getSoggettoErogatore().getTipo());
        busta.setDestinatario(servizio.getSoggettoErogatore().getNome());
        busta.setTipoServizio(servizio.getTipoServizio());
        busta.setServizio(servizio.getServizio());
        busta.setAzione(servizio.getAzione());
        busta.setProfiloDiCollaborazione(profiloCollaborazione);
        busta.setConfermaRicezione(confermaRicezione);
        busta.setInoltro(inoltro);
        this.registraBusta(busta, "OUTBOX", null, scadenza);
    }

    public void aggiornaDuplicatiIntoOutBox(String idEGov) throws EGovException {
        this.aggiornaDuplicati(idEGov, "OUTBOX");
    }

    public void aggiornaInfoIntegrazioneIntoOutBox(String idEGov, Integrazione infoIntegrazione) throws EGovException {
        this.aggiornaInfoIntegrazione(idEGov, "OUTBOX", infoIntegrazione);
    }

    public void aggiornaInfoIntegrazioneIntoOutBox_ServizioApplicativo(String idEGov, String servizioApplicativo) throws EGovException {
        this.aggiornaInfoIntegrazione_ServizioApplicativo(idEGov, "OUTBOX", servizioApplicativo);
    }

    public void aggiornaInfoIntegrazioneIntoOutBox_Scenario(String idEGov, String scenario) throws EGovException {
        this.aggiornaInfoIntegrazione_Scenario(idEGov, "OUTBOX", scenario);
    }

    public void aggiornaBustaIntoOutBox(Busta busta, long scadenza) throws EGovException {
        this.aggiornaBusta(busta, "OUTBOX", scadenza, null);
    }

    public void aggiornaBustaIntoOutBox(Busta busta, long scadenza, Vector<Eccezione> errors) throws EGovException {
        this.aggiornaBusta(busta, "OUTBOX", scadenza, errors);
    }

    public void aggiornaBustaIntoOutBox(String idEGov, IDSoggetto soggettoFruitore, IDServizio servizio, long scadenza, String profiloCollaborazione, boolean confermaRicezione, String inoltro) throws EGovException {
        Busta bustaDaAggiornare = new Busta();
        bustaDaAggiornare.setID(idEGov);
        bustaDaAggiornare.setTipoMittente(soggettoFruitore.getTipo());
        bustaDaAggiornare.setMittente(soggettoFruitore.getNome());
        bustaDaAggiornare.setTipoDestinatario(servizio.getSoggettoErogatore().getTipo());
        bustaDaAggiornare.setDestinatario(servizio.getSoggettoErogatore().getNome());
        bustaDaAggiornare.setTipoServizio(servizio.getTipoServizio());
        bustaDaAggiornare.setServizio(servizio.getServizio());
        bustaDaAggiornare.setAzione(servizio.getAzione());
        bustaDaAggiornare.setProfiloDiCollaborazione(profiloCollaborazione);
        bustaDaAggiornare.setConfermaRicezione(confermaRicezione);
        bustaDaAggiornare.setInoltro(inoltro);
        this.aggiornaBusta(bustaDaAggiornare, "OUTBOX", scadenza, null);
    }

    public void aggiornaCollaborazioneIntoOutBox(String idEGov, String collaborazione) throws EGovException {
        this.aggiornaCollaborazione(idEGov, "OUTBOX", collaborazione);
    }

    public void aggiornaSequenzaIntoOutBox(String idEGov, long sequenza) throws EGovException {
        this.aggiornaSequenza(idEGov, "OUTBOX", sequenza);
    }

    public boolean isRegistrataIntoOutBox(String idEGov) throws EGovException {
        return this.isRegistrata(idEGov, "OUTBOX");
    }

    public Busta getBustaFromOutBox(String idEGov) throws EGovException {
        return this.getBusta(idEGov, "OUTBOX");
    }

    public Vector<Eccezione> getErrorsFromOutBox(String idEGov) throws EGovException {
        return this.getErrors(idEGov, "OUTBOX");
    }

    public Busta getSomeValuesFromOutBox(String idEGov, LetturaParametriBusta parametri) throws EGovException {
        return this.getSomeValues(idEGov, "OUTBOX", parametri, false);
    }

    public Busta getSomeValuesFromOutBox(String idEGov, LetturaParametriBusta parametri, boolean forzaLetturaDatabase) throws EGovException {
        return this.getSomeValues(idEGov, "OUTBOX", parametri, forzaLetturaDatabase);
    }

    public String getCollaborazioneFromOutBox(String idEGov) throws EGovException {
        return this.getCollaborazione(idEGov, "OUTBOX");
    }

    public String getProfiloCollaborazioneFromOutBox(String idEGov) throws EGovException {
        return this.getProfiloCollaborazione(idEGov, "OUTBOX");
    }

    public long getSequenzaFromOutBox(String idEGov) throws EGovException {
        return this.getSequenza(idEGov, "OUTBOX");
    }

    public Integrazione getInfoIntegrazioneFromOutBox(String idEGov) throws EGovException {
        return this.getInfoIntegrazione(idEGov, "OUTBOX");
    }

    public void eliminaUtilizzoPdDFromOutBox(String idEGov) throws EGovException {
        this.eliminaUtilizzoPdD(idEGov, "OUTBOX", false);
    }

    public void eliminaUtilizzoPdDFromOutBox(String idEGov, boolean forzaUpdateDB) throws EGovException {
        this.eliminaUtilizzoPdD(idEGov, "OUTBOX", forzaUpdateDB);
    }

    public void eliminaBustaFromOutBox(String idEGov) throws EGovException {
        this.eliminaBusta(idEGov, "OUTBOX");
    }

    public void eliminaBustaStatelessFromOutBox(String idEGov) throws EGovException {
        this.eliminaBustaStateless(idEGov, "OUTBOX");
    }

    public void impostaUtilizzoPdDIntoOutBox(String idEGov) throws EGovException {
        this.impostaUtilizzoPdD(idEGov, "OUTBOX");
    }

    public void registraBustaIntoInBox(Busta busta, long scadenza) throws EGovException {
        this.registraBusta(busta, "INBOX", null, scadenza);
    }

    public void registraBustaIntoInBox(Busta busta, Vector<Eccezione> errors, long scadenza) throws EGovException {
        this.registraBusta(busta, "INBOX", errors, scadenza);
    }

    public void registraBustaIntoInBox(String idEGov, IDSoggetto soggettoFruitore, IDServizio servizio, long scadenza, String profiloCollaborazione, boolean confermaRicezione, String inoltro) throws EGovException {
        Busta busta = new Busta();
        busta.setID(idEGov);
        busta.setTipoMittente(soggettoFruitore.getTipo());
        busta.setMittente(soggettoFruitore.getNome());
        busta.setTipoDestinatario(servizio.getSoggettoErogatore().getTipo());
        busta.setDestinatario(servizio.getSoggettoErogatore().getNome());
        busta.setTipoServizio(servizio.getTipoServizio());
        busta.setServizio(servizio.getServizio());
        busta.setAzione(servizio.getAzione());
        busta.setProfiloDiCollaborazione(profiloCollaborazione);
        busta.setConfermaRicezione(confermaRicezione);
        busta.setInoltro(inoltro);
        this.registraBusta(busta, "INBOX", null, scadenza);
    }

    public void aggiornaDuplicatiIntoInBox(String idEGov) throws EGovException {
        this.aggiornaDuplicati(idEGov, "INBOX");
    }

    public void aggiornaInfoIntegrazioneIntoInBox(String idEGov, Integrazione infoIntegrazione) throws EGovException {
        this.aggiornaInfoIntegrazione(idEGov, "INBOX", infoIntegrazione);
    }

    public void aggiornaInfoIntegrazioneIntoInBox_ServizioApplicativo(String idEGov, String servizioApplicativo) throws EGovException {
        this.aggiornaInfoIntegrazione_ServizioApplicativo(idEGov, "INBOX", servizioApplicativo);
    }

    public void aggiornaInfoIntegrazioneIntoInBox_Scenario(String idEGov, String scenario) throws EGovException {
        this.aggiornaInfoIntegrazione_Scenario(idEGov, "INBOX", scenario);
    }

    public void aggiornaBustaIntoInBox(Busta busta, long scadenza) throws EGovException {
        this.aggiornaBusta(busta, "INBOX", scadenza, null);
    }

    public void aggiornaBustaIntoInBox(Busta busta, long scadenza, Vector<Eccezione> errors) throws EGovException {
        this.aggiornaBusta(busta, "INBOX", scadenza, errors);
    }

    public void aggiornaBustaIntoInBox(String idEGov, IDSoggetto soggettoFruitore, IDServizio servizio, long scadenza, String profiloCollaborazione, boolean confermaRicezione, String inoltro) throws EGovException {
        Busta bustaDaAggiornare = new Busta();
        bustaDaAggiornare.setID(idEGov);
        bustaDaAggiornare.setTipoMittente(soggettoFruitore.getTipo());
        bustaDaAggiornare.setMittente(soggettoFruitore.getNome());
        bustaDaAggiornare.setTipoDestinatario(servizio.getSoggettoErogatore().getTipo());
        bustaDaAggiornare.setDestinatario(servizio.getSoggettoErogatore().getNome());
        bustaDaAggiornare.setTipoServizio(servizio.getTipoServizio());
        bustaDaAggiornare.setServizio(servizio.getServizio());
        bustaDaAggiornare.setAzione(servizio.getAzione());
        bustaDaAggiornare.setProfiloDiCollaborazione(profiloCollaborazione);
        bustaDaAggiornare.setConfermaRicezione(confermaRicezione);
        bustaDaAggiornare.setInoltro(inoltro);
        this.aggiornaBusta(bustaDaAggiornare, "INBOX", scadenza, null);
    }

    public void aggiornaCollaborazioneIntoInBox(String idEGov, String collaborazione) throws EGovException {
        this.aggiornaCollaborazione(idEGov, "INBOX", collaborazione);
    }

    public void aggiornaSequenzaIntoInBox(String idEGov, long sequenza) throws EGovException {
        this.aggiornaSequenza(idEGov, "INBOX", sequenza);
    }

    public boolean isRegistrataIntoInBox(String idEGov) throws EGovException {
        return this.isRegistrata(idEGov, "INBOX");
    }

    public Busta getBustaFromInBox(String idEGov) throws EGovException {
        return this.getBusta(idEGov, "INBOX");
    }

    public Vector<Eccezione> getErrorsFromInBox(String idEGov) throws EGovException {
        return this.getErrors(idEGov, "INBOX");
    }

    public Busta getSomeValuesFromInBox(String idEGov, LetturaParametriBusta parametri) throws EGovException {
        return this.getSomeValues(idEGov, "INBOX", parametri, false);
    }

    public Busta getSomeValuesFromInBox(String idEGov, LetturaParametriBusta parametri, boolean forzaLetturaDatabase) throws EGovException {
        return this.getSomeValues(idEGov, "INBOX", parametri, forzaLetturaDatabase);
    }

    public String getCollaborazioneFromInBox(String idEGov) throws EGovException {
        return this.getCollaborazione(idEGov, "INBOX");
    }

    public String getProfiloCollaborazioneFromInBox(String idEGov) throws EGovException {
        return this.getProfiloCollaborazione(idEGov, "INBOX");
    }

    public long getSequenzaFromInBox(String idEGov) throws EGovException {
        return this.getSequenza(idEGov, "INBOX");
    }

    public Integrazione getInfoIntegrazioneFromInBox(String idEGov) throws EGovException {
        return this.getInfoIntegrazione(idEGov, "INBOX");
    }

    public void eliminaUtilizzoPdDFromInBox(String idEGov) throws EGovException {
        this.eliminaUtilizzoPdD(idEGov, "INBOX", false);
    }

    public void eliminaUtilizzoPdDFromInBox(String idEGov, boolean forzaUpdateDB) throws EGovException {
        this.eliminaUtilizzoPdD(idEGov, "INBOX", forzaUpdateDB);
    }

    public void eliminaBustaFromInBox(String idEGov) throws EGovException {
        this.eliminaBusta(idEGov, "INBOX");
    }

    public void eliminaBustaStatelessFromInBox(String idEGov) throws EGovException {
        this.eliminaBustaStateless(idEGov, "INBOX");
    }

    public void impostaUtilizzoPdDIntoInBox(String idEGov) throws EGovException {
        this.impostaUtilizzoPdD(idEGov, "INBOX");
    }

    public void registraBustaIntoInboxForHistory(Busta busta, long scadenza) throws EGovException {
        StateMessage stateMSG = (StateMessage)this.state;
        Connection connectionDB = stateMSG.getConnectionDB();
        Statement pstmtBusta = null;
        try {
            Date scadenzaBusta = busta.getScadenza();
            if (scadenzaBusta == null) {
                scadenzaBusta = new Date(DateManager.getTimeMillis() + scadenza * 60L * 1000L);
            }
            Timestamp scadenzaT = new Timestamp(scadenzaBusta.getTime());
            StringBuffer query = new StringBuffer();
            query.append("INSERT INTO  ");
            query.append("REPOSITORY_EGOV");
            query.append(" (ID_EGOV,TIPO,MITTENTE,TIPO_MITTENTE,IND_TELEMATICO_MITT,DESTINATARIO,TIPO_DESTINATARIO,IND_TELEMATICO_DEST");
            query.append(",SERVIZIO,TIPO_SERVIZIO,AZIONE,PROFILO_DI_COLLABORAZIONE,SERVIZIO_CORRELATO,TIPO_SERVIZIO_CORRELATO");
            query.append(",COLLABORAZIONE,SEQUENZA,INOLTRO_SENZA_DUPLICATI,CONFERMA_RICEZIONE,ORA_REGISTRAZIONE,TIPO_ORA_REGISTRAZIONE");
            query.append(",RIFERIMENTO_MESSAGGIO,SCADENZA_BUSTA,DUPLICATI,LOCATION_PD,SERVIZIO_APPLICATIVO,MODULO_IN_ATTESA,SCENARIO,");
            query.append(this.gestoreRepositoryEGov.createSQLFieldHistory());
            query.append(") ");
            query.append(" VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,");
            query.append(this.gestoreRepositoryEGov.getSQLValueHistory(true));
            query.append(")");
            pstmtBusta = connectionDB.prepareStatement(query.toString());
            pstmtBusta.setString(1, busta.getID());
            pstmtBusta.setString(2, "INBOX");
            pstmtBusta.setString(3, busta.getMittente());
            pstmtBusta.setString(4, busta.getTipoMittente());
            pstmtBusta.setString(5, busta.getIndirizzoTelematicoMittente());
            pstmtBusta.setString(6, busta.getDestinatario());
            pstmtBusta.setString(7, busta.getTipoDestinatario());
            pstmtBusta.setString(8, busta.getIndirizzoTelematicoDestinatario());
            pstmtBusta.setString(9, busta.getServizio());
            pstmtBusta.setString(10, busta.getTipoServizio());
            pstmtBusta.setString(11, busta.getAzione());
            pstmtBusta.setString(12, busta.getProfiloDiCollaborazione());
            pstmtBusta.setString(13, busta.getServizioCorrelato());
            pstmtBusta.setString(14, busta.getTipoServizioCorrelato());
            pstmtBusta.setString(15, busta.getCollaborazione());
            pstmtBusta.setLong(16, busta.getSequenza());
            if ("EGOV_IT_ALPIUUNAVOLTA".equals(busta.getInoltro())) {
                pstmtBusta.setInt(17, 1);
            } else {
                pstmtBusta.setInt(17, 0);
            }
            if (busta.getConfermaRicezione()) {
                pstmtBusta.setInt(18, 1);
            } else {
                pstmtBusta.setInt(18, 0);
            }
            Timestamp oraRec = null;
            String tipoOraRec = null;
            if (busta.getOraRegistrazione() != null && busta.getTipoOraRegistrazione() != null) {
                oraRec = new Timestamp(busta.getOraRegistrazione().getTime());
                tipoOraRec = busta.getTipoOraRegistrazione();
            } else {
                oraRec = DateManager.getTimestamp();
                tipoOraRec = "EGOV_IT_SPC";
            }
            pstmtBusta.setTimestamp(19, oraRec);
            pstmtBusta.setString(20, tipoOraRec);
            pstmtBusta.setString(21, busta.getRiferimentoMessaggio());
            pstmtBusta.setTimestamp(22, scadenzaT);
            pstmtBusta.setInt(23, 0);
            pstmtBusta.setString(24, null);
            pstmtBusta.setString(25, null);
            pstmtBusta.setString(26, null);
            pstmtBusta.setString(27, null);
            stateMSG.getPreparedStatement().put("INSERT RegistrazioneBustaForHistoryINBOX_" + busta.getID(), (PreparedStatement)pstmtBusta);
        }
        catch (Exception e) {
            String id = busta.getID();
            String errorMsg = "REPOSITORY_EGOV, Errore di registrazione per History INBOX/" + id + ": " + e.getMessage();
            this.log.error((Object)errorMsg, (Throwable)e);
            try {
                if (pstmtBusta != null) {
                    pstmtBusta.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            throw new EGovException(errorMsg, e);
        }
    }

    public void registraBusta(Busta busta, String tipoBusta, Vector<Eccezione> errors, long scadenza) throws EGovException {
        if (!this.isRichiesta && this.state instanceof StatelessMessage) {
            ((StatelessMessage)this.state).setBusta(busta);
            return;
        }
        StateMessage stateMSG = (StateMessage)this.state;
        Connection connectionDB = stateMSG.getConnectionDB();
        Statement pstmtBusta = null;
        Statement pstmtUpdateAccessoPdD = null;
        Statement pstmtListaRiscontri = null;
        Statement pstmtListaTrasmissioni = null;
        Statement pstmtListaEccezioni = null;
        Statement pstmtListaEccezioniValidazione = null;
        try {
            Date scadenzaBusta = busta.getScadenza();
            if (scadenzaBusta == null) {
                scadenzaBusta = new Date(DateManager.getTimeMillis() + scadenza * 60L * 1000L);
            }
            Timestamp scadenzaT = new Timestamp(scadenzaBusta.getTime());
            StringBuffer query = new StringBuffer();
            query.append("INSERT INTO  ");
            query.append("REPOSITORY_EGOV");
            query.append(" (ID_EGOV,TIPO,MITTENTE,TIPO_MITTENTE,IND_TELEMATICO_MITT,DESTINATARIO,TIPO_DESTINATARIO,IND_TELEMATICO_DEST");
            query.append(",SERVIZIO,TIPO_SERVIZIO,AZIONE,PROFILO_DI_COLLABORAZIONE,SERVIZIO_CORRELATO,TIPO_SERVIZIO_CORRELATO");
            query.append(",COLLABORAZIONE,SEQUENZA,INOLTRO_SENZA_DUPLICATI,CONFERMA_RICEZIONE,ORA_REGISTRAZIONE,TIPO_ORA_REGISTRAZIONE");
            query.append(",RIFERIMENTO_MESSAGGIO,SCADENZA_BUSTA,DUPLICATI,LOCATION_PD,SERVIZIO_APPLICATIVO,MODULO_IN_ATTESA,SCENARIO) ");
            query.append(" VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
            pstmtBusta = connectionDB.prepareStatement(query.toString());
            pstmtBusta.setString(1, busta.getID());
            pstmtBusta.setString(2, tipoBusta);
            pstmtBusta.setString(3, busta.getMittente());
            pstmtBusta.setString(4, busta.getTipoMittente());
            pstmtBusta.setString(5, busta.getIndirizzoTelematicoMittente());
            pstmtBusta.setString(6, busta.getDestinatario());
            pstmtBusta.setString(7, busta.getTipoDestinatario());
            pstmtBusta.setString(8, busta.getIndirizzoTelematicoDestinatario());
            pstmtBusta.setString(9, busta.getServizio());
            pstmtBusta.setString(10, busta.getTipoServizio());
            pstmtBusta.setString(11, busta.getAzione());
            pstmtBusta.setString(12, busta.getProfiloDiCollaborazione());
            pstmtBusta.setString(13, busta.getServizioCorrelato());
            pstmtBusta.setString(14, busta.getTipoServizioCorrelato());
            pstmtBusta.setString(15, busta.getCollaborazione());
            pstmtBusta.setLong(16, busta.getSequenza());
            if ("EGOV_IT_ALPIUUNAVOLTA".equals(busta.getInoltro())) {
                pstmtBusta.setInt(17, 1);
            } else {
                pstmtBusta.setInt(17, 0);
            }
            if (busta.getConfermaRicezione()) {
                pstmtBusta.setInt(18, 1);
            } else {
                pstmtBusta.setInt(18, 0);
            }
            Timestamp oraRec = null;
            String tipoOraRec = null;
            if (busta.getOraRegistrazione() != null && busta.getTipoOraRegistrazione() != null) {
                oraRec = new Timestamp(busta.getOraRegistrazione().getTime());
                tipoOraRec = busta.getTipoOraRegistrazione();
            } else {
                oraRec = DateManager.getTimestamp();
                tipoOraRec = "EGOV_IT_SPC";
            }
            pstmtBusta.setTimestamp(19, oraRec);
            pstmtBusta.setString(20, tipoOraRec);
            pstmtBusta.setString(21, busta.getRiferimentoMessaggio());
            pstmtBusta.setTimestamp(22, scadenzaT);
            pstmtBusta.setInt(23, 0);
            pstmtBusta.setString(24, null);
            pstmtBusta.setString(25, null);
            pstmtBusta.setString(26, null);
            pstmtBusta.setString(27, null);
            stateMSG.getPreparedStatement().put("INSERT RegistrazioneBusta" + tipoBusta + "_" + busta.getID(), (PreparedStatement)pstmtBusta);
            query.delete(0, query.length());
            query.append("UPDATE ");
            query.append("REPOSITORY_EGOV");
            query.append(" SET ");
            query.append(this.gestoreRepositoryEGov.createSQLSet_PdD(true));
            query.append(" WHERE  ID_EGOV = ? AND TIPO=?");
            pstmtUpdateAccessoPdD = connectionDB.prepareStatement(query.toString());
            pstmtUpdateAccessoPdD.setString(1, busta.getID());
            pstmtUpdateAccessoPdD.setString(2, tipoBusta);
            stateMSG.getPreparedStatement().put("UPDATE RegistrazioneBustaAccessoPdD" + tipoBusta + "_" + busta.getID(), (PreparedStatement)pstmtUpdateAccessoPdD);
            if (this.state instanceof StatefulMessage) {
                Eccezione eccezione;
                int i;
                for (i = 0; i < busta.sizeListaRiscontri(); ++i) {
                    Riscontro riscontro = busta.getRiscontro(i);
                    query.delete(0, query.length());
                    query.append("INSERT INTO  ");
                    query.append("LISTA_RISCONTRI");
                    query.append(" (ID_EGOV,TIPO,ID_RISCONTRO,ORA_REGISTRAZIONE,TIPO_ORA_REGISTRAZIONE)");
                    query.append(" VALUES (?,?,?,?,?)");
                    pstmtListaRiscontri = connectionDB.prepareStatement(query.toString());
                    pstmtListaRiscontri.setString(1, busta.getID());
                    pstmtListaRiscontri.setString(2, tipoBusta);
                    pstmtListaRiscontri.setString(3, riscontro.getID());
                    Timestamp oraRecRiscontro = null;
                    if (riscontro.getOraRegistrazione() != null) {
                        oraRecRiscontro = new Timestamp(riscontro.getOraRegistrazione().getTime());
                    }
                    pstmtListaRiscontri.setTimestamp(4, oraRecRiscontro);
                    pstmtListaRiscontri.setString(5, riscontro.getTipoOraRegistrazione());
                    stateMSG.getPreparedStatement().put("INSERT RegistrazioneListaRiscontri_riscontro[" + i + "]_" + tipoBusta + "_" + busta.getID(), (PreparedStatement)pstmtListaRiscontri);
                }
                for (i = 0; i < busta.sizeListaTrasmissioni(); ++i) {
                    Trasmissione trasmissione = busta.getTrasmissione(i);
                    query.delete(0, query.length());
                    query.append("INSERT INTO  ");
                    query.append("LISTA_TRASMISSIONI");
                    query.append(" (ID_EGOV,TIPO,ORIGINE,TIPO_ORIGINE,DESTINAZIONE,TIPO_DESTINAZIONE,ORA_REGISTRAZIONE,TIPO_ORA_REGISTRAZIONE)");
                    query.append(" VALUES (?,?,?,?,?,?,?,?)");
                    pstmtListaTrasmissioni = connectionDB.prepareStatement(query.toString());
                    pstmtListaTrasmissioni.setString(1, busta.getID());
                    pstmtListaTrasmissioni.setString(2, tipoBusta);
                    pstmtListaTrasmissioni.setString(3, trasmissione.getOrigine());
                    pstmtListaTrasmissioni.setString(4, trasmissione.getTipoOrigine());
                    pstmtListaTrasmissioni.setString(5, trasmissione.getDestinazione());
                    pstmtListaTrasmissioni.setString(6, trasmissione.getTipoDestinazione());
                    Timestamp oraRecTrasmissione = null;
                    if (trasmissione.getOraRegistrazione() != null) {
                        oraRecTrasmissione = new Timestamp(trasmissione.getOraRegistrazione().getTime());
                    }
                    pstmtListaTrasmissioni.setTimestamp(7, oraRecTrasmissione);
                    pstmtListaTrasmissioni.setString(8, trasmissione.getTempo());
                    stateMSG.getPreparedStatement().put("INSERT RegistrazioneListaTrasmissioni_trasmissione[" + i + "]_" + tipoBusta + "_" + busta.getID(), (PreparedStatement)pstmtListaTrasmissioni);
                }
                for (i = 0; i < busta.sizeListaEccezioni(); ++i) {
                    eccezione = busta.getEccezione(i);
                    query.delete(0, query.length());
                    query.append("INSERT INTO  ");
                    query.append("LISTA_ECCEZIONI");
                    query.append(" (ID_EGOV,TIPO,VALIDAZIONE,CONTESTO,CODICE,RILEVANZA,POSIZIONE)");
                    query.append(" VALUES (?,?,?,?,?,?,?)");
                    pstmtListaEccezioni = connectionDB.prepareStatement(query.toString());
                    pstmtListaEccezioni.setString(1, busta.getID());
                    pstmtListaEccezioni.setString(2, tipoBusta);
                    pstmtListaEccezioni.setInt(3, 0);
                    pstmtListaEccezioni.setString(4, eccezione.getContestoCodifica());
                    pstmtListaEccezioni.setString(5, eccezione.getCodiceEccezione());
                    pstmtListaEccezioni.setString(6, eccezione.getRilevanza());
                    pstmtListaEccezioni.setString(7, eccezione.getPosizione());
                    stateMSG.getPreparedStatement().put("INSERT RegistrazioneListaEccezioni_eccezioneBusta[" + i + "]_" + tipoBusta + "_" + busta.getID(), (PreparedStatement)pstmtListaEccezioni);
                }
                if (errors != null) {
                    for (i = 0; i < errors.size(); ++i) {
                        eccezione = errors.get(i);
                        query.delete(0, query.length());
                        query.append("INSERT INTO  ");
                        query.append("LISTA_ECCEZIONI");
                        query.append(" (ID_EGOV,TIPO,VALIDAZIONE,CONTESTO,CODICE,RILEVANZA,POSIZIONE)");
                        query.append(" VALUES (?,?,?,?,?,?,?)");
                        pstmtListaEccezioniValidazione = connectionDB.prepareStatement(query.toString());
                        pstmtListaEccezioniValidazione.setString(1, busta.getID());
                        pstmtListaEccezioniValidazione.setString(2, tipoBusta);
                        pstmtListaEccezioniValidazione.setInt(3, 1);
                        pstmtListaEccezioniValidazione.setString(4, eccezione.getContestoCodifica());
                        pstmtListaEccezioniValidazione.setString(5, eccezione.getCodiceEccezione());
                        pstmtListaEccezioniValidazione.setString(6, eccezione.getRilevanza());
                        pstmtListaEccezioniValidazione.setString(7, eccezione.getPosizione());
                        stateMSG.getPreparedStatement().put("INSERT RegistrazioneListaEccezioni_eccezioneValidazione[" + i + "]_" + tipoBusta + "_" + busta.getID(), (PreparedStatement)pstmtListaEccezioniValidazione);
                    }
                }
            }
        }
        catch (Exception e) {
            String id = busta.getID();
            String errorMsg = "REPOSITORY_EGOV, Errore di registrazione " + tipoBusta + "/" + id + ": " + e.getMessage();
            this.log.error((Object)errorMsg, (Throwable)e);
            try {
                if (pstmtBusta != null) {
                    pstmtBusta.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            try {
                if (pstmtUpdateAccessoPdD != null) {
                    pstmtUpdateAccessoPdD.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            try {
                if (pstmtListaRiscontri != null) {
                    pstmtListaRiscontri.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            try {
                if (pstmtListaTrasmissioni != null) {
                    pstmtListaTrasmissioni.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            try {
                if (pstmtListaEccezioni != null) {
                    pstmtListaEccezioni.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            try {
                if (pstmtListaEccezioniValidazione != null) {
                    pstmtListaEccezioniValidazione.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            throw new EGovException(errorMsg, e);
        }
        if (stateMSG instanceof StatelessMessage) {
            ((StatelessMessage)stateMSG).setBusta(busta);
        }
    }

    public void aggiornaBusta(Busta busta, String tipoBusta, long scadenza, Vector<Eccezione> errors) throws EGovException {
        if (!this.isRichiesta && this.state instanceof StatelessMessage) {
            ((StatelessMessage)this.state).setBusta(busta);
            return;
        }
        StateMessage stateMSG = (StateMessage)this.state;
        Connection connectionDB = stateMSG.getConnectionDB();
        Statement pstmtBusta = null;
        Statement pstmtDeleteListaRiscontri = null;
        Statement pstmtDeleteListaTrasmissioni = null;
        Statement pstmtDeleteListaEccezioni = null;
        Statement pstmtListaRiscontri = null;
        Statement pstmtListaTrasmissioni = null;
        Statement pstmtListaEccezioni = null;
        Statement pstmtListaEccezioniValidazione = null;
        try {
            Date scadenzaBusta = busta.getScadenza();
            if (scadenzaBusta == null) {
                scadenzaBusta = new Date(DateManager.getTimeMillis() + scadenza * 60L * 1000L);
            }
            Timestamp scadenzaT = new Timestamp(scadenzaBusta.getTime());
            StringBuffer query = new StringBuffer();
            query.append("UPDATE  ");
            query.append("REPOSITORY_EGOV");
            query.append(" SET ");
            query.append("MITTENTE = ? ,");
            query.append("TIPO_MITTENTE = ? ,");
            query.append("IND_TELEMATICO_MITT = ? ,");
            query.append("DESTINATARIO = ? ,");
            query.append("TIPO_DESTINATARIO = ? ,");
            query.append("IND_TELEMATICO_DEST = ? ,");
            query.append("SERVIZIO = ? ,");
            query.append("TIPO_SERVIZIO = ? ,");
            query.append("AZIONE = ? ,");
            query.append("PROFILO_DI_COLLABORAZIONE = ? ,");
            query.append("SERVIZIO_CORRELATO = ? ,");
            query.append("TIPO_SERVIZIO_CORRELATO = ? ,");
            query.append("COLLABORAZIONE = ? ,");
            query.append("SEQUENZA = ? ,");
            query.append("INOLTRO_SENZA_DUPLICATI = ? ,");
            query.append("CONFERMA_RICEZIONE = ? ,");
            query.append("ORA_REGISTRAZIONE = ? ,");
            query.append("TIPO_ORA_REGISTRAZIONE = ? ,");
            query.append("RIFERIMENTO_MESSAGGIO = ? ,");
            query.append("SCADENZA_BUSTA = ? ");
            query.append(" WHERE ID_EGOV=? AND TIPO=?");
            pstmtBusta = connectionDB.prepareStatement(query.toString());
            pstmtBusta.setString(1, busta.getMittente());
            pstmtBusta.setString(2, busta.getTipoMittente());
            pstmtBusta.setString(3, busta.getIndirizzoTelematicoMittente());
            pstmtBusta.setString(4, busta.getDestinatario());
            pstmtBusta.setString(5, busta.getTipoDestinatario());
            pstmtBusta.setString(6, busta.getIndirizzoTelematicoDestinatario());
            pstmtBusta.setString(7, busta.getServizio());
            pstmtBusta.setString(8, busta.getTipoServizio());
            pstmtBusta.setString(9, busta.getAzione());
            pstmtBusta.setString(10, busta.getProfiloDiCollaborazione());
            pstmtBusta.setString(11, busta.getServizioCorrelato());
            pstmtBusta.setString(12, busta.getTipoServizioCorrelato());
            pstmtBusta.setString(13, busta.getCollaborazione());
            pstmtBusta.setLong(14, busta.getSequenza());
            if ("EGOV_IT_ALPIUUNAVOLTA".equals(busta.getInoltro())) {
                pstmtBusta.setInt(15, 1);
            } else {
                pstmtBusta.setInt(15, 0);
            }
            if (busta.getConfermaRicezione()) {
                pstmtBusta.setInt(16, 1);
            } else {
                pstmtBusta.setInt(16, 0);
            }
            Timestamp oraRec = null;
            String tipoOraRec = null;
            if (busta.getOraRegistrazione() != null && busta.getTipoOraRegistrazione() != null) {
                oraRec = new Timestamp(busta.getOraRegistrazione().getTime());
                tipoOraRec = busta.getTipoOraRegistrazione();
            }
            pstmtBusta.setTimestamp(17, oraRec);
            pstmtBusta.setString(18, tipoOraRec);
            pstmtBusta.setString(19, busta.getRiferimentoMessaggio());
            pstmtBusta.setTimestamp(20, scadenzaT);
            pstmtBusta.setString(21, busta.getID());
            pstmtBusta.setString(22, tipoBusta);
            stateMSG.getPreparedStatement().put("UPDATE AggiornamentoBusta" + tipoBusta + "_" + busta.getID(), (PreparedStatement)pstmtBusta);
            if (errors != null) {
                Eccezione eccezione;
                int i;
                StringBuffer queryDelete = new StringBuffer();
                queryDelete.append("DELETE FROM ");
                queryDelete.append("LISTA_TRASMISSIONI");
                queryDelete.append(" WHERE ID_EGOV = ? AND TIPO = ?");
                pstmtDeleteListaRiscontri = connectionDB.prepareStatement(queryDelete.toString());
                pstmtDeleteListaRiscontri.setString(1, busta.getID());
                pstmtDeleteListaRiscontri.setString(2, tipoBusta);
                stateMSG.getPreparedStatement().put("DELETE(UPDATE) AggiornamentoBusta_listaRiscontri" + tipoBusta + "_" + busta.getID(), (PreparedStatement)pstmtDeleteListaRiscontri);
                queryDelete.delete(0, queryDelete.length());
                queryDelete.append("DELETE FROM ");
                queryDelete.append("LISTA_RISCONTRI");
                queryDelete.append(" WHERE ID_EGOV = ? AND TIPO = ?");
                pstmtDeleteListaTrasmissioni = connectionDB.prepareStatement(queryDelete.toString());
                pstmtDeleteListaTrasmissioni.setString(1, busta.getID());
                pstmtDeleteListaTrasmissioni.setString(2, tipoBusta);
                stateMSG.getPreparedStatement().put("DELETE(UPDATE) AggiornamentoBusta_listaTrasmissioni" + tipoBusta + "_" + busta.getID(), (PreparedStatement)pstmtDeleteListaTrasmissioni);
                queryDelete.delete(0, queryDelete.length());
                queryDelete.append("DELETE FROM ");
                queryDelete.append("LISTA_ECCEZIONI");
                queryDelete.append(" WHERE ID_EGOV = ? AND TIPO = ?");
                pstmtDeleteListaEccezioni = connectionDB.prepareStatement(queryDelete.toString());
                pstmtDeleteListaEccezioni.setString(1, busta.getID());
                pstmtDeleteListaEccezioni.setString(2, tipoBusta);
                stateMSG.getPreparedStatement().put("DELETE(UPDATE) AggiornamentoBusta_listaEccezioni" + tipoBusta + "_" + busta.getID(), (PreparedStatement)pstmtDeleteListaEccezioni);
                for (i = 0; i < busta.sizeListaRiscontri(); ++i) {
                    Riscontro riscontro = busta.getRiscontro(i);
                    query.delete(0, query.length());
                    query.append("INSERT INTO  ");
                    query.append("LISTA_RISCONTRI");
                    query.append(" (ID_EGOV,TIPO,ID_RISCONTRO,ORA_REGISTRAZIONE,TIPO_ORA_REGISTRAZIONE)");
                    query.append(" VALUES (?,?,?,?,?)");
                    pstmtListaRiscontri = connectionDB.prepareStatement(query.toString());
                    pstmtListaRiscontri.setString(1, busta.getID());
                    pstmtListaRiscontri.setString(2, tipoBusta);
                    pstmtListaRiscontri.setString(3, riscontro.getID());
                    Timestamp oraRecRiscontro = null;
                    if (riscontro.getOraRegistrazione() != null) {
                        oraRecRiscontro = new Timestamp(riscontro.getOraRegistrazione().getTime());
                    }
                    pstmtListaRiscontri.setTimestamp(4, oraRecRiscontro);
                    pstmtListaRiscontri.setString(5, riscontro.getTipoOraRegistrazione());
                    stateMSG.getPreparedStatement().put("INSERT(UPDATE) RegistrazioneListaRiscontri_riscontro[" + i + "]_" + tipoBusta + "_" + busta.getID(), (PreparedStatement)pstmtListaRiscontri);
                }
                for (i = 0; i < busta.sizeListaTrasmissioni(); ++i) {
                    Trasmissione trasmissione = busta.getTrasmissione(i);
                    query.delete(0, query.length());
                    query.append("INSERT INTO  ");
                    query.append("LISTA_TRASMISSIONI");
                    query.append(" (ID_EGOV,TIPO,ORIGINE,TIPO_ORIGINE,DESTINAZIONE,TIPO_DESTINAZIONE,ORA_REGISTRAZIONE,TIPO_ORA_REGISTRAZIONE)");
                    query.append(" VALUES (?,?,?,?,?,?,?,?)");
                    pstmtListaTrasmissioni = connectionDB.prepareStatement(query.toString());
                    pstmtListaTrasmissioni.setString(1, busta.getID());
                    pstmtListaTrasmissioni.setString(2, tipoBusta);
                    pstmtListaTrasmissioni.setString(3, trasmissione.getOrigine());
                    pstmtListaTrasmissioni.setString(4, trasmissione.getTipoOrigine());
                    pstmtListaTrasmissioni.setString(5, trasmissione.getDestinazione());
                    pstmtListaTrasmissioni.setString(6, trasmissione.getTipoDestinazione());
                    Timestamp oraRecTrasmissione = null;
                    if (trasmissione.getOraRegistrazione() != null) {
                        oraRecTrasmissione = new Timestamp(trasmissione.getOraRegistrazione().getTime());
                    }
                    pstmtListaTrasmissioni.setTimestamp(7, oraRecTrasmissione);
                    pstmtListaTrasmissioni.setString(8, trasmissione.getTempo());
                    stateMSG.getPreparedStatement().put("INSERT(UPDATE) RegistrazioneListaTrasmissioni_trasmissione[" + i + "]_" + tipoBusta + "_" + busta.getID(), (PreparedStatement)pstmtListaTrasmissioni);
                }
                for (i = 0; i < busta.sizeListaEccezioni(); ++i) {
                    eccezione = busta.getEccezione(i);
                    query.delete(0, query.length());
                    query.append("INSERT INTO  ");
                    query.append("LISTA_ECCEZIONI");
                    query.append(" (ID_EGOV,TIPO,VALIDAZIONE,CONTESTO,CODICE,RILEVANZA,POSIZIONE)");
                    query.append(" VALUES (?,?,?,?,?,?,?)");
                    pstmtListaEccezioni = connectionDB.prepareStatement(query.toString());
                    pstmtListaEccezioni.setString(1, busta.getID());
                    pstmtListaEccezioni.setString(2, tipoBusta);
                    pstmtListaEccezioni.setInt(3, 0);
                    pstmtListaEccezioni.setString(4, eccezione.getContestoCodifica());
                    pstmtListaEccezioni.setString(5, eccezione.getCodiceEccezione());
                    pstmtListaEccezioni.setString(6, eccezione.getRilevanza());
                    pstmtListaEccezioni.setString(7, eccezione.getPosizione());
                    stateMSG.getPreparedStatement().put("INSERT(UPDATE) RegistrazioneListaEccezioni_eccezioneBusta[" + i + "]_" + tipoBusta + "_" + busta.getID(), (PreparedStatement)pstmtListaEccezioni);
                }
                for (i = 0; i < errors.size(); ++i) {
                    eccezione = errors.get(i);
                    query.delete(0, query.length());
                    query.append("INSERT INTO  ");
                    query.append("LISTA_ECCEZIONI");
                    query.append(" (ID_EGOV,TIPO,VALIDAZIONE,CONTESTO,CODICE,RILEVANZA,POSIZIONE)");
                    query.append(" VALUES (?,?,?,?,?,?,?)");
                    pstmtListaEccezioniValidazione = connectionDB.prepareStatement(query.toString());
                    pstmtListaEccezioniValidazione.setString(1, busta.getID());
                    pstmtListaEccezioniValidazione.setString(2, tipoBusta);
                    pstmtListaEccezioniValidazione.setInt(3, 1);
                    pstmtListaEccezioniValidazione.setString(4, eccezione.getContestoCodifica());
                    pstmtListaEccezioniValidazione.setString(5, eccezione.getCodiceEccezione());
                    pstmtListaEccezioniValidazione.setString(6, eccezione.getRilevanza());
                    pstmtListaEccezioniValidazione.setString(7, eccezione.getPosizione());
                    stateMSG.getPreparedStatement().put("INSERT(UPDATE) RegistrazioneListaEccezioni_eccezioneValidazione[" + i + "]_" + tipoBusta + "_" + busta.getID(), (PreparedStatement)pstmtListaEccezioniValidazione);
                }
            }
        }
        catch (Exception e) {
            String id = busta.getID();
            String errorMsg = "REPOSITORY_EGOV, Errore di aggiornamento " + tipoBusta + "/" + id + ": " + e.getMessage();
            this.log.error((Object)errorMsg, (Throwable)e);
            try {
                if (pstmtBusta != null) {
                    pstmtBusta.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            try {
                if (pstmtDeleteListaRiscontri != null) {
                    pstmtDeleteListaRiscontri.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            try {
                if (pstmtDeleteListaTrasmissioni != null) {
                    pstmtDeleteListaTrasmissioni.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            try {
                if (pstmtDeleteListaEccezioni != null) {
                    pstmtDeleteListaEccezioni.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            try {
                if (pstmtListaRiscontri != null) {
                    pstmtListaRiscontri.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            try {
                if (pstmtListaTrasmissioni != null) {
                    pstmtListaTrasmissioni.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            try {
                if (pstmtListaEccezioni != null) {
                    pstmtListaEccezioni.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            try {
                if (pstmtListaEccezioniValidazione != null) {
                    pstmtListaEccezioniValidazione.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            throw new EGovException(errorMsg, e);
        }
        if (stateMSG instanceof StatelessMessage) {
            ((StatelessMessage)this.state).setBusta(busta);
        }
    }

    private void aggiornaDuplicati(String idEGov, String tipoBusta) throws EGovException {
        StateMessage stateMSG = (StateMessage)this.state;
        Connection connectionDB = stateMSG.getConnectionDB();
        PreparedStatement pstmt = null;
        try {
            StringBuffer query = new StringBuffer();
            query.append("UPDATE ");
            query.append("REPOSITORY_EGOV");
            query.append(" SET DUPLICATI=(DUPLICATI+1) WHERE  ID_EGOV = ? AND TIPO=?");
            pstmt = connectionDB.prepareStatement(query.toString());
            pstmt.setString(1, idEGov);
            pstmt.setString(2, tipoBusta);
            stateMSG.getPreparedStatement().put("UPDATE aggiornaDuplicati " + tipoBusta + "_" + idEGov, pstmt);
        }
        catch (Exception e) {
            String errorMsg = "REPOSITORY_EGOV, Errore di aggiornamento informazioni pacchetti duplicati " + tipoBusta + "/" + idEGov + ": " + e.getMessage();
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            this.log.error((Object)errorMsg, (Throwable)e);
            throw new EGovException(errorMsg, e);
        }
    }

    public void aggiornaInfoIntegrazione(String idEGov, String tipoBusta, Integrazione infoIntegrazione) throws EGovException {
        boolean registrazioneInfoIntegrazione = false;
        if (this.state instanceof StatefulMessage) {
            registrazioneInfoIntegrazione = true;
        } else if (this.isRichiesta && "OUTBOX".equals(tipoBusta)) {
            StatelessMessage stateless = (StatelessMessage)this.state;
            Busta busta = stateless.getBusta();
            if ("EGOV_IT_MessaggioSingoloOneWay".equals(busta.getProfiloDiCollaborazione()) && busta.getConfermaRicezione()) {
                registrazioneInfoIntegrazione = true;
            } else if ("EGOV_IT_ServizioAsincronoSimmetrico".equals(busta.getProfiloDiCollaborazione()) && busta.getRiferimentoMessaggio() == null) {
                registrazioneInfoIntegrazione = true;
            }
        }
        if (registrazioneInfoIntegrazione) {
            StateMessage stateMSG = (StateMessage)this.state;
            Connection connectionDB = stateMSG.getConnectionDB();
            PreparedStatement pstmt = null;
            try {
                StringBuffer query = new StringBuffer();
                query.append("UPDATE ");
                query.append("REPOSITORY_EGOV");
                query.append(" SET LOCATION_PD=? , SERVIZIO_APPLICATIVO=? , MODULO_IN_ATTESA=? , SCENARIO=? WHERE  ID_EGOV = ? AND TIPO=?");
                pstmt = connectionDB.prepareStatement(query.toString());
                pstmt.setString(1, infoIntegrazione.getLocationPD());
                pstmt.setString(2, infoIntegrazione.getServizioApplicativo());
                pstmt.setString(3, infoIntegrazione.getIdModuloInAttesa());
                pstmt.setString(4, infoIntegrazione.getScenario());
                pstmt.setString(5, idEGov);
                pstmt.setString(6, tipoBusta);
                stateMSG.getPreparedStatement().put("UPDATE aggiornaInformazioniIntegrazione " + tipoBusta + "_" + idEGov, pstmt);
            }
            catch (Exception e) {
                String errorMsg = "REPOSITORY_EGOV, Errore di aggiornamento informazioni di Integrazione " + tipoBusta + "/" + idEGov + ": " + e.getMessage();
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                this.log.error((Object)errorMsg, (Throwable)e);
                throw new EGovException(errorMsg, e);
            }
        }
    }

    private void aggiornaInfoIntegrazione_ServizioApplicativo(String idEGov, String tipoBusta, String servizioApplicativo) throws EGovException {
        if (this.state instanceof StatefulMessage) {
            StatefulMessage stateful = (StatefulMessage)this.state;
            Connection connectionDB = stateful.getConnectionDB();
            PreparedStatement pstmt = null;
            try {
                StringBuffer query = new StringBuffer();
                query.append("UPDATE ");
                query.append("REPOSITORY_EGOV");
                query.append(" SET SERVIZIO_APPLICATIVO=? WHERE  ID_EGOV = ? AND TIPO=?");
                pstmt = connectionDB.prepareStatement(query.toString());
                pstmt.setString(1, servizioApplicativo);
                pstmt.setString(2, idEGov);
                pstmt.setString(3, tipoBusta);
                stateful.getPreparedStatement().put("UPDATE aggiornaInformazioniIntegrazione_ServizioApplicativo_" + tipoBusta + "_" + idEGov, pstmt);
            }
            catch (Exception e) {
                String errorMsg = "REPOSITORY_EGOV, Errore di aggiornamento informazioni di Integrazione " + tipoBusta + "/" + idEGov + " (ServizioApplicativo): " + e.getMessage();
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                this.log.error((Object)errorMsg, (Throwable)e);
                throw new EGovException(errorMsg, e);
            }
        }
    }

    private void aggiornaInfoIntegrazione_Scenario(String idEGov, String tipoBusta, String scenario) throws EGovException {
        if (this.state instanceof StatefulMessage) {
            StatefulMessage stateful = (StatefulMessage)this.state;
            Connection connectionDB = stateful.getConnectionDB();
            PreparedStatement pstmt = null;
            try {
                StringBuffer query = new StringBuffer();
                query.append("UPDATE ");
                query.append("REPOSITORY_EGOV");
                query.append(" SET SCENARIO=? WHERE  ID_EGOV = ? AND TIPO=?");
                pstmt = connectionDB.prepareStatement(query.toString());
                pstmt.setString(1, scenario);
                pstmt.setString(2, idEGov);
                pstmt.setString(3, tipoBusta);
                stateful.getPreparedStatement().put("UPDATE aggiornaInformazioniIntegrazione_Scenario_" + tipoBusta + "_" + idEGov, pstmt);
            }
            catch (Exception e) {
                String errorMsg = "REPOSITORY_EGOV, Errore di aggiornamento informazioni di Integrazione " + tipoBusta + "/" + idEGov + " (Scenario): " + e.getMessage();
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                this.log.error((Object)errorMsg, (Throwable)e);
                throw new EGovException(errorMsg, e);
            }
        }
    }

    private void aggiornaCollaborazione(String idEGov, String tipoBusta, String collaborazione) throws EGovException {
        if (this.state instanceof StatefulMessage) {
            StatefulMessage stateful = (StatefulMessage)this.state;
            Connection connectionDB = stateful.getConnectionDB();
            PreparedStatement pstmtBusta = null;
            try {
                StringBuffer query = new StringBuffer();
                query.append("UPDATE  ");
                query.append("REPOSITORY_EGOV");
                query.append(" SET ");
                query.append("COLLABORAZIONE = ?");
                query.append(" WHERE ID_EGOV=? AND TIPO=?");
                pstmtBusta = connectionDB.prepareStatement(query.toString());
                pstmtBusta.setString(1, collaborazione);
                pstmtBusta.setString(2, idEGov);
                pstmtBusta.setString(3, tipoBusta);
                stateful.getPreparedStatement().put("UPDATE AggiornamentoCollaborazione" + tipoBusta + "_" + idEGov, pstmtBusta);
            }
            catch (Exception e) {
                String errorMsg = "REPOSITORY_EGOV, Errore di aggiornamento collaborazione " + tipoBusta + "/" + idEGov + ": " + e.getMessage();
                this.log.error((Object)errorMsg, (Throwable)e);
                try {
                    if (pstmtBusta != null) {
                        pstmtBusta.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                throw new EGovException(errorMsg, e);
            }
        }
        StatelessMessage statelessMsg = (StatelessMessage)this.state;
        statelessMsg.getBusta().setCollaborazione(collaborazione);
    }

    private void aggiornaSequenza(String idEGov, String tipoBusta, long sequenza) throws EGovException {
        if (this.state instanceof StatefulMessage) {
            StatefulMessage stateful = (StatefulMessage)this.state;
            Connection connectionDB = stateful.getConnectionDB();
            PreparedStatement pstmtBusta = null;
            try {
                StringBuffer query = new StringBuffer();
                query.append("UPDATE  ");
                query.append("REPOSITORY_EGOV");
                query.append(" SET ");
                query.append("SEQUENZA = ?");
                query.append(" WHERE ID_EGOV=? AND TIPO=?");
                pstmtBusta = connectionDB.prepareStatement(query.toString());
                pstmtBusta.setLong(1, sequenza);
                pstmtBusta.setString(2, idEGov);
                pstmtBusta.setString(3, tipoBusta);
                stateful.getPreparedStatement().put("UPDATE AggiornamentoSequenza" + tipoBusta + "_" + idEGov, pstmtBusta);
            }
            catch (Exception e) {
                String errorMsg = "REPOSITORY_EGOV, Errore di aggiornamento sequenza " + tipoBusta + "/" + idEGov + ": " + e.getMessage();
                this.log.error((Object)errorMsg, (Throwable)e);
                try {
                    if (pstmtBusta != null) {
                        pstmtBusta.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                throw new EGovException(errorMsg, e);
            }
        }
        StatelessMessage statelessMsg = (StatelessMessage)this.state;
        statelessMsg.getBusta().setSequenza(sequenza);
    }

    public boolean isRegistrata(String idEGov, String tipoBusta) throws EGovException {
        Connection connectionDB = ((StateMessage)this.state).getConnectionDB();
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            StringBuffer query = new StringBuffer();
            query.append("select ID_EGOV from ");
            query.append("REPOSITORY_EGOV");
            query.append(" WHERE ID_EGOV = ? AND TIPO = ?");
            pstmt = connectionDB.prepareStatement(query.toString());
            pstmt.setString(1, idEGov);
            pstmt.setString(2, tipoBusta);
            rs = pstmt.executeQuery();
            if (rs == null) {
                throw new EGovException("RS Null?");
            }
            boolean value = rs.next();
            rs.close();
            pstmt.close();
            return value;
        }
        catch (Exception e) {
            String errorMsg = "REPOSITORY_EGOV, Errore durante isRegistrata " + tipoBusta + "/" + idEGov + ": " + e.getMessage();
            this.log.error((Object)errorMsg, (Throwable)e);
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            throw new EGovException(errorMsg, e);
        }
    }

    private Busta getBusta(String idEGov, String tipoBusta) throws EGovException {
        if (this.state instanceof StatefulMessage) {
            StatefulMessage stateful = (StatefulMessage)this.state;
            Connection connectionDB = stateful.getConnectionDB();
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                StringBuffer query = new StringBuffer();
                query.append("select * from ");
                query.append("REPOSITORY_EGOV");
                query.append(" WHERE ID_EGOV = ? AND TIPO = ?");
                pstmt = connectionDB.prepareStatement(query.toString());
                pstmt.setString(1, idEGov);
                pstmt.setString(2, tipoBusta);
                rs = pstmt.executeQuery();
                if (rs == null) {
                    throw new EGovException("RS Null?");
                }
                if (!rs.next()) {
                    throw new EGovException("Busta non trovata");
                }
                Busta busta_eGov = new Busta();
                busta_eGov.setID(rs.getString("ID_EGOV"));
                busta_eGov.setTipoMittente(rs.getString("TIPO_MITTENTE"));
                busta_eGov.setMittente(rs.getString("MITTENTE"));
                busta_eGov.setIndirizzoTelematicoMittente(rs.getString("IND_TELEMATICO_MITT"));
                busta_eGov.setTipoDestinatario(rs.getString("TIPO_DESTINATARIO"));
                busta_eGov.setDestinatario(rs.getString("DESTINATARIO"));
                busta_eGov.setIndirizzoTelematicoDestinatario(rs.getString("IND_TELEMATICO_DEST"));
                busta_eGov.setServizio(rs.getString("SERVIZIO"));
                busta_eGov.setTipoServizio(rs.getString("TIPO_SERVIZIO"));
                busta_eGov.setAzione(rs.getString("AZIONE"));
                busta_eGov.setProfiloDiCollaborazione(rs.getString("PROFILO_DI_COLLABORAZIONE"));
                busta_eGov.setServizioCorrelato(rs.getString("SERVIZIO_CORRELATO"));
                busta_eGov.setTipoServizioCorrelato(rs.getString("TIPO_SERVIZIO_CORRELATO"));
                busta_eGov.setCollaborazione(rs.getString("COLLABORAZIONE"));
                busta_eGov.setSequenza(rs.getLong("SEQUENZA"));
                if (rs.getInt("INOLTRO_SENZA_DUPLICATI") != 0) {
                    busta_eGov.setInoltro("EGOV_IT_ALPIUUNAVOLTA");
                } else {
                    busta_eGov.setInoltro("EGOV_IT_PIUDIUNAVOLTA");
                }
                if (rs.getInt("CONFERMA_RICEZIONE") != 0) {
                    busta_eGov.setConfermaRicezione(true);
                } else {
                    busta_eGov.setConfermaRicezione(false);
                }
                busta_eGov.setOraRegistrazione(rs.getTimestamp("ORA_REGISTRAZIONE"));
                busta_eGov.setTipoOraRegistrazione(rs.getString("TIPO_ORA_REGISTRAZIONE"));
                busta_eGov.setRiferimentoMessaggio(rs.getString("RIFERIMENTO_MESSAGGIO"));
                busta_eGov.setScadenza(rs.getTimestamp("SCADENZA_BUSTA"));
                rs.close();
                pstmt.close();
                query.delete(0, query.length());
                query.append("select * from ");
                query.append("LISTA_TRASMISSIONI");
                query.append(" WHERE ID_EGOV = ? AND TIPO = ?");
                pstmt = connectionDB.prepareStatement(query.toString());
                pstmt.setString(1, idEGov);
                pstmt.setString(2, tipoBusta);
                rs = pstmt.executeQuery();
                if (rs == null) {
                    throw new EGovException("RS Null?");
                }
                while (rs.next()) {
                    Trasmissione trasmissione = new Trasmissione();
                    trasmissione.setOrigine(rs.getString("ORIGINE"));
                    trasmissione.setTipoOrigine(rs.getString("TIPO_ORIGINE"));
                    trasmissione.setDestinazione(rs.getString("DESTINAZIONE"));
                    trasmissione.setTipoDestinazione(rs.getString("TIPO_DESTINAZIONE"));
                    trasmissione.setOraRegistrazione(rs.getTimestamp("ORA_REGISTRAZIONE"));
                    trasmissione.setTempo(rs.getString("TIPO_ORA_REGISTRAZIONE"));
                    busta_eGov.addTrasmissione(trasmissione);
                }
                rs.close();
                pstmt.close();
                query.delete(0, query.length());
                query.append("select * from ");
                query.append("LISTA_RISCONTRI");
                query.append(" WHERE ID_EGOV = ? AND TIPO = ?");
                pstmt = connectionDB.prepareStatement(query.toString());
                pstmt.setString(1, idEGov);
                pstmt.setString(2, tipoBusta);
                rs = pstmt.executeQuery();
                if (rs == null) {
                    throw new EGovException("RS Null?");
                }
                while (rs.next()) {
                    Riscontro riscontro = new Riscontro();
                    riscontro.setID(rs.getString("ID_RISCONTRO"));
                    riscontro.setOraRegistrazione(rs.getTimestamp("ORA_REGISTRAZIONE"));
                    riscontro.setTipoOraRegistrazione(rs.getString("TIPO_ORA_REGISTRAZIONE"));
                    busta_eGov.addRiscontro(riscontro);
                }
                rs.close();
                pstmt.close();
                query.delete(0, query.length());
                query.append("select * from ");
                query.append("LISTA_ECCEZIONI");
                query.append(" WHERE ID_EGOV = ? AND TIPO = ? AND VALIDAZIONE=0");
                pstmt = connectionDB.prepareStatement(query.toString());
                pstmt.setString(1, idEGov);
                pstmt.setString(2, tipoBusta);
                rs = pstmt.executeQuery();
                if (rs == null) {
                    throw new EGovException("RS Null?");
                }
                while (rs.next()) {
                    Eccezione eccezione = new Eccezione();
                    eccezione.setContestoCodifica(rs.getString("CONTESTO"));
                    eccezione.setCodiceEccezione(rs.getString("CODICE"));
                    eccezione.setRilevanza(rs.getString("RILEVANZA"));
                    eccezione.setPosizione(rs.getString("POSIZIONE"));
                    busta_eGov.addEccezione(eccezione);
                }
                rs.close();
                pstmt.close();
                return busta_eGov;
            }
            catch (Exception e) {
                String errorMsg = "REPOSITORY_EGOV, Errore durante la getBusta " + tipoBusta + "/" + idEGov + ": " + e.getMessage();
                this.log.error((Object)errorMsg, (Throwable)e);
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                throw new EGovException(errorMsg, e);
            }
        }
        StatelessMessage statelessMsg = (StatelessMessage)this.state;
        return statelessMsg.getBusta();
    }

    private Vector<Eccezione> getErrors(String idEGov, String tipoBusta) throws EGovException {
        if (this.state instanceof StatefulMessage) {
            StatefulMessage stateful = (StatefulMessage)this.state;
            Connection connectionDB = stateful.getConnectionDB();
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            Vector<Eccezione> errors = new Vector<Eccezione>();
            try {
                StringBuffer query = new StringBuffer();
                query.append("select * from ");
                query.append("LISTA_ECCEZIONI");
                query.append(" WHERE ID_EGOV = ? AND TIPO = ? AND VALIDAZIONE=1");
                pstmt = connectionDB.prepareStatement(query.toString());
                pstmt.setString(1, idEGov);
                pstmt.setString(2, tipoBusta);
                rs = pstmt.executeQuery();
                if (rs == null) {
                    throw new EGovException("RS Null?");
                }
                while (rs.next()) {
                    Eccezione eccezione = new Eccezione();
                    eccezione.setContestoCodifica(rs.getString("CONTESTO"));
                    eccezione.setCodiceEccezione(rs.getString("CODICE"));
                    eccezione.setRilevanza(rs.getString("RILEVANZA"));
                    eccezione.setPosizione(rs.getString("POSIZIONE"));
                    errors.add(eccezione);
                }
                rs.close();
                pstmt.close();
                return errors;
            }
            catch (Exception e) {
                String errorMsg = "REPOSITORY_EGOV, Errore durante la getErrors " + tipoBusta + "/" + idEGov + ": " + e.getMessage();
                this.log.error((Object)errorMsg, (Throwable)e);
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                throw new EGovException(errorMsg, e);
            }
        }
        return null;
    }

    private Busta getSomeValues(String idEGov, String tipoBusta, LetturaParametriBusta parametri, boolean forzaLetturaSuDatabase) throws EGovException {
        int i;
        if (this.state instanceof StatefulMessage || forzaLetturaSuDatabase) {
            StateMessage state = (StateMessage)this.state;
            Connection connectionDB = state.getConnectionDB();
            Statement pstmt = null;
            ResultSet rs = null;
            Busta busta = new Busta();
            try {
                StringBuffer bf = new StringBuffer();
                bf.append("SELECT ");
                boolean first = true;
                if (parametri.isMittente()) {
                    bf.append("MITTENTE,TIPO_MITTENTE");
                    first = false;
                }
                if (parametri.isDestinatario()) {
                    if (!first) {
                        bf.append(",");
                    } else {
                        first = false;
                    }
                    bf.append("DESTINATARIO,TIPO_DESTINATARIO");
                }
                if (parametri.isIndirizziTelematici()) {
                    if (!first) {
                        bf.append(",");
                    } else {
                        first = false;
                    }
                    bf.append("IND_TELEMATICO_MITT,IND_TELEMATICO_DEST");
                }
                if (parametri.isServizio()) {
                    if (!first) {
                        bf.append(",");
                    } else {
                        first = false;
                    }
                    bf.append("SERVIZIO,TIPO_SERVIZIO");
                }
                if (parametri.isAzione()) {
                    if (!first) {
                        bf.append(",");
                    } else {
                        first = false;
                    }
                    bf.append("AZIONE");
                }
                if (parametri.isProfiloDiCollaborazione()) {
                    if (!first) {
                        bf.append(",");
                    } else {
                        first = false;
                    }
                    bf.append("PROFILO_DI_COLLABORAZIONE");
                }
                if (parametri.isServizioCorrelato()) {
                    if (!first) {
                        bf.append(",");
                    } else {
                        first = false;
                    }
                    bf.append("SERVIZIO_CORRELATO,TIPO_SERVIZIO_CORRELATO");
                }
                if (parametri.isCollaborazione()) {
                    if (!first) {
                        bf.append(",");
                    } else {
                        first = false;
                    }
                    bf.append("COLLABORAZIONE");
                }
                if (parametri.isSequenza()) {
                    if (!first) {
                        bf.append(",");
                    } else {
                        first = false;
                    }
                    bf.append("SEQUENZA");
                }
                if (parametri.isProfiloTrasmissione()) {
                    if (!first) {
                        bf.append(",");
                    } else {
                        first = false;
                    }
                    bf.append("INOLTRO_SENZA_DUPLICATI,CONFERMA_RICEZIONE");
                }
                if (parametri.isOraRegistrazione()) {
                    if (!first) {
                        bf.append(",");
                    } else {
                        first = false;
                    }
                    bf.append("ORA_REGISTRAZIONE,TIPO_ORA_REGISTRAZIONE");
                }
                if (parametri.isRiferimentoMessaggio()) {
                    if (!first) {
                        bf.append(",");
                    } else {
                        first = false;
                    }
                    bf.append("RIFERIMENTO_MESSAGGIO");
                }
                if (parametri.isScadenza()) {
                    if (!first) {
                        bf.append(",");
                    } else {
                        first = false;
                    }
                    bf.append("SCADENZA_BUSTA");
                }
                bf.append(" FROM ");
                bf.append("REPOSITORY_EGOV");
                bf.append(" WHERE ID_EGOV=? AND TIPO=?");
                pstmt = connectionDB.prepareStatement(bf.toString());
                pstmt.setString(1, idEGov);
                pstmt.setString(2, tipoBusta);
                rs = pstmt.executeQuery();
                if (rs == null) {
                    throw new EGovException("RS Null?");
                }
                if (rs.next()) {
                    if (parametri.isMittente()) {
                        busta.setTipoMittente(rs.getString("TIPO_MITTENTE"));
                        busta.setMittente(rs.getString("MITTENTE"));
                    }
                    if (parametri.isDestinatario()) {
                        busta.setTipoDestinatario(rs.getString("TIPO_DESTINATARIO"));
                        busta.setDestinatario(rs.getString("DESTINATARIO"));
                    }
                    if (parametri.isIndirizziTelematici()) {
                        busta.setIndirizzoTelematicoMittente(rs.getString("IND_TELEMATICO_MITT"));
                        busta.setIndirizzoTelematicoDestinatario(rs.getString("IND_TELEMATICO_DEST"));
                    }
                    if (parametri.isServizio()) {
                        busta.setTipoServizio(rs.getString("TIPO_SERVIZIO"));
                        busta.setServizio(rs.getString("SERVIZIO"));
                    }
                    if (parametri.isAzione()) {
                        busta.setAzione(rs.getString("AZIONE"));
                    }
                    if (parametri.isProfiloDiCollaborazione()) {
                        busta.setProfiloDiCollaborazione(rs.getString("PROFILO_DI_COLLABORAZIONE"));
                    }
                    if (parametri.isServizioCorrelato()) {
                        busta.setTipoServizioCorrelato(rs.getString("TIPO_SERVIZIO_CORRELATO"));
                        busta.setServizioCorrelato(rs.getString("SERVIZIO_CORRELATO"));
                    }
                    if (parametri.isCollaborazione()) {
                        busta.setCollaborazione(rs.getString("COLLABORAZIONE"));
                    }
                    if (parametri.isSequenza()) {
                        busta.setSequenza(rs.getLong("SEQUENZA"));
                    }
                    if (parametri.isProfiloTrasmissione()) {
                        if (rs.getInt("INOLTRO_SENZA_DUPLICATI") != 0) {
                            busta.setInoltro("EGOV_IT_ALPIUUNAVOLTA");
                        } else {
                            busta.setInoltro("EGOV_IT_PIUDIUNAVOLTA");
                        }
                        if (rs.getInt("CONFERMA_RICEZIONE") != 0) {
                            busta.setConfermaRicezione(true);
                        } else {
                            busta.setConfermaRicezione(false);
                        }
                    }
                    if (parametri.isOraRegistrazione()) {
                        busta.setOraRegistrazione(rs.getTimestamp("ORA_REGISTRAZIONE"));
                        busta.setTipoOraRegistrazione(rs.getString("TIPO_ORA_REGISTRAZIONE"));
                    }
                    if (parametri.isRiferimentoMessaggio()) {
                        busta.setRiferimentoMessaggio(rs.getString("RIFERIMENTO_MESSAGGIO"));
                    }
                    if (parametri.isScadenza()) {
                        busta.setScadenza(rs.getTimestamp("SCADENZA_BUSTA"));
                    }
                } else {
                    throw new EGovException("Busta non trovata");
                }
                rs.close();
                pstmt.close();
                return busta;
            }
            catch (Exception e) {
                String errorMsg = "REPOSITORY_EGOV, Errore  getSomeValues " + tipoBusta + "/" + idEGov + ": " + e.getMessage();
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                this.log.error((Object)errorMsg, (Throwable)e);
                throw new EGovException(errorMsg, e);
            }
        }
        StatelessMessage statelessMsg = (StatelessMessage)this.state;
        Busta busta = statelessMsg.getBusta();
        if (!parametri.isMittente()) {
            busta.setTipoMittente(null);
            busta.setMittente(null);
        }
        if (!parametri.isDestinatario()) {
            busta.setTipoDestinatario(null);
            busta.setDestinatario(null);
        }
        if (!parametri.isIndirizziTelematici()) {
            busta.setIndirizzoTelematicoMittente(null);
            busta.setIndirizzoTelematicoDestinatario(null);
        }
        if (!parametri.isServizio()) {
            busta.setTipoServizio(null);
            busta.setServizio(null);
        }
        if (!parametri.isAzione()) {
            busta.setAzione(null);
        }
        if (!parametri.isProfiloDiCollaborazione()) {
            busta.setProfiloDiCollaborazione(null);
        }
        if (!parametri.isServizioCorrelato()) {
            busta.setTipoServizioCorrelato(null);
            busta.setServizioCorrelato(null);
        }
        if (!parametri.isCollaborazione()) {
            busta.setCollaborazione(null);
        }
        if (!parametri.isSequenza()) {
            busta.setSequenza(-1L);
        }
        if (!parametri.isProfiloTrasmissione()) {
            busta.setInoltro(null);
            busta.setConfermaRicezione(false);
        }
        if (!parametri.isOraRegistrazione()) {
            busta.setOraRegistrazione(null);
            busta.setTipoOraRegistrazione(null);
        }
        if (!parametri.isRiferimentoMessaggio()) {
            busta.setRiferimentoMessaggio(null);
        }
        if (!parametri.isScadenza()) {
            busta.setScadenza(null);
        }
        for (i = 0; i < busta.sizeListaEccezioni(); ++i) {
            busta.removeEccezione(i);
        }
        for (i = 0; i < busta.sizeListaTrasmissioni(); ++i) {
            busta.removeTrasmissione(i);
        }
        for (i = 0; i < busta.sizeListaRiscontri(); ++i) {
            busta.removeRiscontro(i);
        }
        return busta;
    }

    private String getCollaborazione(String idEGov, String tipoBusta) throws EGovException {
        if (this.state instanceof StatefulMessage) {
            StatefulMessage stateful = (StatefulMessage)this.state;
            Connection connectionDB = stateful.getConnectionDB();
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                String query = "SELECT COLLABORAZIONE FROM REPOSITORY_EGOV WHERE ID_EGOV=? AND TIPO=?";
                pstmt = connectionDB.prepareStatement(query);
                pstmt.setString(1, idEGov);
                pstmt.setString(2, tipoBusta);
                rs = pstmt.executeQuery();
                if (rs == null) {
                    throw new EGovException("RS Null?");
                }
                String collaborazione = null;
                if (rs.next()) {
                    collaborazione = rs.getString("COLLABORAZIONE");
                }
                rs.close();
                pstmt.close();
                return collaborazione;
            }
            catch (Exception e) {
                String errorMsg = "REPOSITORY_EGOV, Errore  getCollaborazione " + tipoBusta + "/" + idEGov + ": " + e.getMessage();
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                this.log.error((Object)errorMsg, (Throwable)e);
                throw new EGovException(errorMsg, e);
            }
        }
        StatelessMessage statelessMsg = (StatelessMessage)this.state;
        Busta busta = statelessMsg.getBusta();
        return busta.getCollaborazione();
    }

    private String getProfiloCollaborazione(String idEGov, String tipoBusta) throws EGovException {
        if (this.state instanceof StatefulMessage) {
            StatefulMessage stateful = (StatefulMessage)this.state;
            Connection connectionDB = stateful.getConnectionDB();
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                String query = "SELECT PROFILO_DI_COLLABORAZIONE FROM REPOSITORY_EGOV WHERE ID_EGOV=? AND TIPO=?";
                pstmt = connectionDB.prepareStatement(query);
                pstmt.setString(1, idEGov);
                pstmt.setString(2, tipoBusta);
                rs = pstmt.executeQuery();
                if (rs == null) {
                    throw new EGovException("RS Null?");
                }
                String profiloCollaborazione = null;
                if (rs.next()) {
                    profiloCollaborazione = rs.getString("PROFILO_DI_COLLABORAZIONE");
                }
                rs.close();
                pstmt.close();
                return profiloCollaborazione;
            }
            catch (Exception e) {
                String errorMsg = "REPOSITORY_EGOV, Errore  getProfiloCollaborazione " + tipoBusta + "/" + idEGov + ": " + e.getMessage();
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                this.log.error((Object)errorMsg, (Throwable)e);
                throw new EGovException(errorMsg, e);
            }
        }
        StatelessMessage statelessMsg = (StatelessMessage)this.state;
        Busta busta = statelessMsg.getBusta();
        return busta.getProfiloDiCollaborazione();
    }

    private long getSequenza(String idEGov, String tipoBusta) throws EGovException {
        if (this.state instanceof StatefulMessage) {
            StatefulMessage stateful = (StatefulMessage)this.state;
            Connection connectionDB = stateful.getConnectionDB();
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                String query = "SELECT SEQUENZA FROM REPOSITORY_EGOV WHERE ID_EGOV=? AND TIPO=?";
                pstmt = connectionDB.prepareStatement(query);
                pstmt.setString(1, idEGov);
                pstmt.setString(2, tipoBusta);
                rs = pstmt.executeQuery();
                if (rs == null) {
                    throw new EGovException("RS Null?");
                }
                long sequenza = -1L;
                if (rs.next()) {
                    sequenza = rs.getLong("SEQUENZA");
                }
                rs.close();
                pstmt.close();
                return sequenza;
            }
            catch (Exception e) {
                String errorMsg = "REPOSITORY_EGOV, Errore  getSequenza " + tipoBusta + "/" + idEGov + ": " + e.getMessage();
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                this.log.error((Object)errorMsg, (Throwable)e);
                throw new EGovException(errorMsg, e);
            }
        }
        StatelessMessage statelessMsg = (StatelessMessage)this.state;
        Busta busta = statelessMsg.getBusta();
        return busta.getSequenza();
    }

    private Integrazione getInfoIntegrazione(String idEGov, String tipoBusta) throws EGovException {
        StateMessage stateful = (StateMessage)this.state;
        Connection connectionDB = stateful.getConnectionDB();
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            String query = "SELECT LOCATION_PD,SERVIZIO_APPLICATIVO,MODULO_IN_ATTESA,SCENARIO FROM REPOSITORY_EGOV WHERE ID_EGOV=? AND TIPO=?";
            pstmt = connectionDB.prepareStatement(query);
            pstmt.setString(1, idEGov);
            pstmt.setString(2, tipoBusta);
            rs = pstmt.executeQuery();
            if (rs == null) {
                throw new EGovException("RS Null?");
            }
            Integrazione infoIntegrazione = new Integrazione();
            if (rs.next()) {
                infoIntegrazione.setIdModuloInAttesa(rs.getString("MODULO_IN_ATTESA"));
                infoIntegrazione.setLocationPD(rs.getString("LOCATION_PD"));
                infoIntegrazione.setScenario(rs.getString("SCENARIO"));
                infoIntegrazione.setServizioApplicativo(rs.getString("SERVIZIO_APPLICATIVO"));
            }
            rs.close();
            pstmt.close();
            return infoIntegrazione;
        }
        catch (Exception e) {
            String errorMsg = "REPOSITORY_EGOV, Errore  getInfoIntegrazione " + tipoBusta + "/" + idEGov + ": " + e.getMessage();
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            this.log.error((Object)errorMsg, (Throwable)e);
            throw new EGovException(errorMsg, e);
        }
    }

    private void eliminaUtilizzoPdD(String idEGov, String tipoBusta, boolean forzaEliminazioneDB) throws EGovException {
        if (this.state instanceof StatefulMessage || forzaEliminazioneDB) {
            StateMessage stateMSG = (StateMessage)this.state;
            Connection connectionDB = stateMSG.getConnectionDB();
            Statement pstmtUpdate = null;
            try {
                StringBuffer queryUpdate = new StringBuffer();
                queryUpdate.append("UPDATE ");
                queryUpdate.append("REPOSITORY_EGOV");
                queryUpdate.append(" SET ");
                queryUpdate.append(this.gestoreRepositoryEGov.createSQLSet_PdD(false));
                queryUpdate.append(" WHERE  ID_EGOV = ? AND TIPO=?");
                pstmtUpdate = connectionDB.prepareStatement(queryUpdate.toString());
                pstmtUpdate.setString(1, idEGov);
                pstmtUpdate.setString(2, tipoBusta);
                stateMSG.getPreparedStatement().put("UPDATE AggiornamentoBusta" + tipoBusta + "_" + idEGov, (PreparedStatement)pstmtUpdate);
            }
            catch (Exception e) {
                String errorMsg = "REPOSITORY_EGOV, Errore di cancellazione utilizzo from PdD " + tipoBusta + "/" + idEGov + ": " + e.getMessage();
                this.log.error((Object)errorMsg, (Throwable)e);
                try {
                    if (pstmtUpdate != null) {
                        pstmtUpdate.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                throw new EGovException(errorMsg, e);
            }
        }
    }

    private void eliminaBustaStateless(String idEGov, String tipoBusta) throws EGovException {
        StateMessage stateMSG = (StateMessage)this.state;
        Connection connectionDB = stateMSG.getConnectionDB();
        Statement pstmtUpdate = null;
        try {
            StringBuffer queryUpdate = new StringBuffer();
            queryUpdate.append("UPDATE ");
            queryUpdate.append("REPOSITORY_EGOV");
            queryUpdate.append(" SET ");
            queryUpdate.append(this.gestoreRepositoryEGov.createSQLSet_PdD(false));
            queryUpdate.append(" WHERE  ID_EGOV = ? AND TIPO=?");
            pstmtUpdate = connectionDB.prepareStatement(queryUpdate.toString());
            pstmtUpdate.setString(1, idEGov);
            pstmtUpdate.setString(2, tipoBusta);
            stateMSG.getPreparedStatement().put("UPDATE AggiornamentoBusta" + tipoBusta + "_" + idEGov, (PreparedStatement)pstmtUpdate);
        }
        catch (Exception e) {
            String errorMsg = "REPOSITORY_EGOV, Errore di cancellazione utilizzo from PdD " + tipoBusta + "/" + idEGov + ": " + e.getMessage();
            this.log.error((Object)errorMsg, (Throwable)e);
            try {
                if (pstmtUpdate != null) {
                    pstmtUpdate.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            throw new EGovException(errorMsg, e);
        }
    }

    private void eliminaBusta(String idEGov, String tipoBusta) throws EGovException {
        StateMessage state = (StateMessage)this.state;
        Connection connectionDB = state.getConnectionDB();
        Statement pstmtDelete = null;
        try {
            StringBuffer queryDelete;
            ProfiloDiCollaborazione profilo;
            if ("OUTBOX".equals(tipoBusta)) {
                if (this.state instanceof StatefulMessage) {
                    Riscontri riscontri = new Riscontri(state, this.log);
                    riscontri.validazioneRiscontroRicevuto(idEGov);
                    state.executePreparedStatement();
                }
                profilo = new ProfiloDiCollaborazione(state, this.log);
                profilo.asincrono_eliminaRegistrazione(idEGov, "OUTBOX");
                state.executePreparedStatement();
            } else if ("INBOX".equals(tipoBusta)) {
                profilo = new ProfiloDiCollaborazione(state, this.log);
                profilo.asincrono_eliminaRegistrazione(idEGov, "INBOX");
                state.executePreparedStatement();
            }
            if (this.state instanceof StatefulMessage) {
                queryDelete = new StringBuffer();
                queryDelete.append("DELETE FROM ");
                queryDelete.append("LISTA_TRASMISSIONI");
                queryDelete.append(" WHERE ID_EGOV = ? AND TIPO = ?");
                pstmtDelete = connectionDB.prepareStatement(queryDelete.toString());
                pstmtDelete.setString(1, idEGov);
                pstmtDelete.setString(2, tipoBusta);
                pstmtDelete.execute();
                pstmtDelete.close();
                queryDelete.delete(0, queryDelete.length());
                queryDelete.append("DELETE FROM ");
                queryDelete.append("LISTA_RISCONTRI");
                queryDelete.append(" WHERE ID_EGOV = ? AND TIPO = ?");
                pstmtDelete = connectionDB.prepareStatement(queryDelete.toString());
                pstmtDelete.setString(1, idEGov);
                pstmtDelete.setString(2, tipoBusta);
                pstmtDelete.execute();
                pstmtDelete.close();
                queryDelete.delete(0, queryDelete.length());
                queryDelete.append("DELETE FROM ");
                queryDelete.append("LISTA_ECCEZIONI");
                queryDelete.append(" WHERE ID_EGOV = ? AND TIPO = ?");
                pstmtDelete = connectionDB.prepareStatement(queryDelete.toString());
                pstmtDelete.setString(1, idEGov);
                pstmtDelete.setString(2, tipoBusta);
                pstmtDelete.execute();
                pstmtDelete.close();
            }
            queryDelete = new StringBuffer();
            queryDelete.append("DELETE FROM ");
            queryDelete.append("REPOSITORY_EGOV");
            queryDelete.append(" WHERE ID_EGOV = ? AND TIPO = ?");
            pstmtDelete = connectionDB.prepareStatement(queryDelete.toString());
            pstmtDelete.setString(1, idEGov);
            pstmtDelete.setString(2, tipoBusta);
            pstmtDelete.execute();
            pstmtDelete.close();
        }
        catch (Exception e) {
            String errorMsg = "REPOSITORY_EGOV, Errore di cancellazione from REPOSITORY_EGOV " + tipoBusta + "/" + idEGov + ": " + e.getMessage();
            this.log.error((Object)errorMsg, (Throwable)e);
            try {
                if (pstmtDelete != null) {
                    pstmtDelete.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            throw new EGovException(errorMsg, e);
        }
    }

    public Vector<String> getBusteDaEliminareFromInBox(int limit, boolean logQuery, boolean forceIndex) throws EGovException {
        return this.getBusteDaEliminare("INBOX", limit, logQuery, forceIndex);
    }

    public Vector<String> getBusteDaEliminareFromOutBox(int limit, boolean logQuery, boolean forceIndex) throws EGovException {
        return this.getBusteDaEliminare("OUTBOX", limit, logQuery, forceIndex);
    }

    private Vector<String> getBusteDaEliminare(String tipoBusta, int limit, boolean logQuery, boolean forceIndex) throws EGovException {
        if (this.state instanceof StatefulMessage) {
            StatefulMessage stateful = (StatefulMessage)this.state;
            Connection connectionDB = stateful.getConnectionDB();
            Statement pstmt = null;
            ResultSet rs = null;
            Vector<String> idBuste = new Vector<String>();
            IGestoreRepositoryEGov gestoreRepositoryEGov = Configurazione.getGestoreRepositoryEGov();
            String queryString = null;
            try {
                ISQLQueryObject sqlQueryObject;
                StringBuffer query;
                if (Configurazione.isFiltraBusteScaduteRispettoOraRegistrazione()) {
                    if (Configurazione.getSqlQueryObjectType() == null) {
                        query = new StringBuffer();
                        query.append("SELECT ");
                        if (forceIndex) {
                            query.append("/*+ index(REPOSITORY_EGOV REP_EGOV_SEARCH) */");
                        }
                        query.append(" ID_EGOV FROM ");
                        query.append("REPOSITORY_EGOV");
                        query.append(" WHERE SCADENZA_BUSTA < ? AND TIPO=? AND ");
                        query.append(gestoreRepositoryEGov.createSQLCondition_ProfiloCollaborazione(false));
                        query.append(" AND ");
                        query.append(gestoreRepositoryEGov.createSQLCondition_PdD(false));
                        queryString = query.toString();
                    } else {
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)Configurazione.getSqlQueryObjectType());
                        if (forceIndex) {
                            sqlQueryObject.addSelectForceIndex("REPOSITORY_EGOV", "REP_EGOV_SEARCH");
                        }
                        sqlQueryObject.addSelectField("ID_EGOV");
                        sqlQueryObject.addSelectField("ORA_REGISTRAZIONE");
                        sqlQueryObject.addSelectField("SCADENZA_BUSTA");
                        sqlQueryObject.addSelectField("TIPO");
                        sqlQueryObject.addSelectField(gestoreRepositoryEGov.createSQLFields());
                        sqlQueryObject.addFromTable("REPOSITORY_EGOV");
                        sqlQueryObject.addWhereCondition("SCADENZA_BUSTA < ?");
                        sqlQueryObject.addWhereCondition("TIPO=?");
                        sqlQueryObject.addWhereCondition(gestoreRepositoryEGov.createSQLCondition_ProfiloCollaborazione(false));
                        sqlQueryObject.addWhereCondition(gestoreRepositoryEGov.createSQLCondition_PdD(false));
                        sqlQueryObject.setANDLogicOperator(true);
                        sqlQueryObject.addOrderBy("ORA_REGISTRAZIONE");
                        sqlQueryObject.setSortType(true);
                        sqlQueryObject.setLimit(limit);
                        queryString = sqlQueryObject.createSQLQuery();
                    }
                    Timestamp now = DateManager.getTimestamp();
                    pstmt = connectionDB.prepareStatement(queryString);
                    pstmt.setTimestamp(1, now);
                    pstmt.setString(2, tipoBusta);
                    long startDateSQLCommand = DateManager.getTimeMillis();
                    if (logQuery) {
                        this.log.debug((Object)("[QUERY] (RepositoryEGov.busteScadute) [" + queryString + "] 1[" + now + "] 2[" + tipoBusta + "]..."));
                    }
                    rs = pstmt.executeQuery();
                    long endDateSQLCommand = DateManager.getTimeMillis();
                    long secondSQLCommand = (endDateSQLCommand - startDateSQLCommand) / 1000L;
                    if (logQuery) {
                        this.log.debug((Object)("[QUERY] (RepositoryEGov.busteScadute) [" + queryString + "] 1[" + now + "] 2[" + tipoBusta + "] effettuata in " + secondSQLCommand + " secondi"));
                    }
                    int countLimit = 0;
                    while (rs.next()) {
                        idBuste.add(rs.getString("ID_EGOV"));
                        if (Configurazione.getSqlQueryObjectType() != null || ++countLimit != limit) continue;
                    }
                    rs.close();
                    pstmt.close();
                }
                queryString = null;
                if (Configurazione.getSqlQueryObjectType() == null) {
                    query = new StringBuffer();
                    query.append("SELECT ");
                    if (forceIndex) {
                        query.append("/*+ index(REPOSITORY_EGOV REP_EGOV_SEARCH_TIPO) */");
                    }
                    query.append(" ID_EGOV FROM ");
                    query.append("REPOSITORY_EGOV");
                    query.append(" WHERE TIPO=? AND ");
                    query.append(gestoreRepositoryEGov.createSQLCondition_History(false));
                    query.append(" AND ");
                    query.append(gestoreRepositoryEGov.createSQLCondition_ProfiloCollaborazione(false));
                    query.append(" AND ");
                    query.append(gestoreRepositoryEGov.createSQLCondition_PdD(false));
                    queryString = query.toString();
                } else {
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)Configurazione.getSqlQueryObjectType());
                    if (forceIndex) {
                        sqlQueryObject.addSelectForceIndex("REPOSITORY_EGOV", "REP_EGOV_SEARCH_TIPO");
                    }
                    sqlQueryObject.addSelectField("ID_EGOV");
                    sqlQueryObject.addSelectField("ORA_REGISTRAZIONE");
                    sqlQueryObject.addSelectField("TIPO");
                    sqlQueryObject.addSelectField(gestoreRepositoryEGov.createSQLFields());
                    sqlQueryObject.addFromTable("REPOSITORY_EGOV");
                    sqlQueryObject.addWhereCondition("TIPO=?");
                    sqlQueryObject.addWhereCondition(gestoreRepositoryEGov.createSQLCondition_History(false));
                    sqlQueryObject.addWhereCondition(gestoreRepositoryEGov.createSQLCondition_ProfiloCollaborazione(false));
                    sqlQueryObject.addWhereCondition(gestoreRepositoryEGov.createSQLCondition_PdD(false));
                    sqlQueryObject.setANDLogicOperator(true);
                    sqlQueryObject.addOrderBy("ORA_REGISTRAZIONE");
                    sqlQueryObject.setSortType(true);
                    sqlQueryObject.setLimit(limit);
                    queryString = sqlQueryObject.createSQLQuery();
                }
                pstmt = connectionDB.prepareStatement(queryString.toString());
                pstmt.setString(1, tipoBusta);
                long startDateSQLCommand = DateManager.getTimeMillis();
                if (logQuery) {
                    this.log.debug((Object)("[QUERY] (RepositoryEGov.busteCancellateLogicamente) [" + queryString + "] 1[" + tipoBusta + "]..."));
                }
                rs = pstmt.executeQuery();
                long endDateSQLCommand = DateManager.getTimeMillis();
                long secondSQLCommand = (endDateSQLCommand - startDateSQLCommand) / 1000L;
                if (logQuery) {
                    this.log.debug((Object)("[QUERY] (RepositoryEGov.busteCancellateLogicamente) [" + queryString + "] 1[" + tipoBusta + "] effettuata in " + secondSQLCommand + " secondi"));
                }
                int countLimit = 0;
                while (rs.next()) {
                    idBuste.add(rs.getString("ID_EGOV"));
                    if (Configurazione.getSqlQueryObjectType() != null || ++countLimit != limit) continue;
                }
                rs.close();
                pstmt.close();
                return idBuste;
            }
            catch (Exception e) {
                String errorMsg = "[RepositoryEGov.getBusteDaEliminare] errore, queryString[" + queryString + "]: " + e.getMessage();
                this.log.error((Object)errorMsg, (Throwable)e);
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                throw new EGovException(errorMsg, e);
            }
        }
        throw new EGovException("Metodo non invocabile in stateless mode");
    }

    public void impostaUtilizzoPdD(String idEGov, String tipoBusta) throws EGovException {
        StateMessage stateMSG = (StateMessage)this.state;
        Connection connectionDB = stateMSG.getConnectionDB();
        Statement pstmtUpdate = null;
        try {
            StringBuffer queryUpdate = new StringBuffer();
            queryUpdate.append("UPDATE ");
            queryUpdate.append("REPOSITORY_EGOV");
            queryUpdate.append(" SET ");
            queryUpdate.append(this.gestoreRepositoryEGov.createSQLSet_PdD(true));
            queryUpdate.append(" WHERE  ID_EGOV = ? AND TIPO=?");
            pstmtUpdate = connectionDB.prepareStatement(queryUpdate.toString());
            pstmtUpdate.setString(1, idEGov);
            pstmtUpdate.setString(2, tipoBusta);
            stateMSG.getPreparedStatement().put("UPDATE AggiornamentoBusta_setUtilizzoPdD" + tipoBusta + "_" + idEGov, (PreparedStatement)pstmtUpdate);
        }
        catch (Exception e) {
            String errorMsg = "REPOSITORY_EGOV, Errore di impostazione utilizzo from PdD " + tipoBusta + "/" + idEGov + ": " + e.getMessage();
            this.log.error((Object)errorMsg, (Throwable)e);
            try {
                if (pstmtUpdate != null) {
                    pstmtUpdate.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            throw new EGovException(errorMsg, e);
        }
    }

    public boolean exists(String idEGov, String tipoBusta) throws EGovException {
        StateMessage stateMSG = (StateMessage)this.state;
        Connection connectionDB = stateMSG.getConnectionDB();
        Statement pstmt = null;
        ResultSet rs = null;
        try {
            StringBuffer queryUpdate = new StringBuffer();
            queryUpdate.append("SELECT ID_EGOV FROM ");
            queryUpdate.append("REPOSITORY_EGOV");
            queryUpdate.append(" WHERE  ID_EGOV = ? AND TIPO=? AND (");
            queryUpdate.append(this.gestoreRepositoryEGov.createSQLCondition_History(true));
            queryUpdate.append(" OR ");
            queryUpdate.append(this.gestoreRepositoryEGov.createSQLCondition_PdD(true));
            queryUpdate.append(" OR ");
            queryUpdate.append(this.gestoreRepositoryEGov.createSQLCondition_ProfiloCollaborazione(true));
            queryUpdate.append(" ) ");
            pstmt = connectionDB.prepareStatement(queryUpdate.toString());
            pstmt.setString(1, idEGov);
            pstmt.setString(2, tipoBusta);
            rs = pstmt.executeQuery();
            if (rs == null) {
                throw new Exception("Result set is null??");
            }
            boolean value = rs.next();
            rs.close();
            pstmt.close();
            return value;
        }
        catch (Exception e) {
            String errorMsg = "REPOSITORY_EGOV, Errore durante l'utilizzo di exists " + tipoBusta + "/" + idEGov + ": " + e.getMessage();
            this.log.error((Object)errorMsg, (Throwable)e);
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            throw new EGovException(errorMsg, e);
        }
    }
}

