/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.egov;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Random;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.openspcoop.dao.commons.IDSoggetto;
import org.openspcoop.dao.registry.driver.IDServizio;
import org.openspcoop.dao.state.IState;
import org.openspcoop.dao.state.StateMessage;
import org.openspcoop.dao.state.StatefulMessage;
import org.openspcoop.dao.state.StatelessMessage;
import org.openspcoop.egov.Busta;
import org.openspcoop.egov.Configurazione;
import org.openspcoop.egov.EGovException;
import org.openspcoop.egov.Eccezione;
import org.openspcoop.egov.History;
import org.openspcoop.egov.IGestoreRepositoryEGov;
import org.openspcoop.egov.Integrazione;
import org.openspcoop.egov.LetturaParametriBusta;
import org.openspcoop.egov.RepositoryEGov;
import org.openspcoop.egov.RisultatoValidazione;
import org.openspcoop.registry.RegistroServiziReader;
import org.openspcoop.utils.date.DateManager;
import org.openspcoop.utils.sql.ISQLQueryObject;
import org.openspcoop.utils.sql.SQLObjectFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProfiloDiCollaborazione {
    private Logger log = null;
    private IState state;
    private IGestoreRepositoryEGov gestoreRepositoryEGov;

    public ProfiloDiCollaborazione(IState state) {
        this(state, Configurazione.getLibraryLog());
    }

    public ProfiloDiCollaborazione(IState state, Logger alog) {
        this.state = state;
        this.gestoreRepositoryEGov = Configurazione.getGestoreRepositoryEGov();
        this.log = alog != null ? alog : Logger.getLogger((String)ProfiloDiCollaborazione.class.getName());
    }

    public void registraBustaInviata(String idEGov) throws EGovException {
        this.registraBusta(idEGov, "OUTBOX");
    }

    public void eliminaBustaInviata(String idEGov, boolean forzaEliminazioneDB) throws EGovException {
        this.eliminaBusta(idEGov, "OUTBOX", forzaEliminazioneDB);
    }

    public void eliminaBustaInviata(String idEGov) throws EGovException {
        this.eliminaBusta(idEGov, "OUTBOX");
    }

    public void registraBustaRicevuta(String idEGov) throws EGovException {
        this.registraBusta(idEGov, "INBOX");
    }

    public void eliminaBustaRicevuta(String idEGov, boolean forzaEliminazioneDB) throws EGovException {
        this.eliminaBusta(idEGov, "INBOX", forzaEliminazioneDB);
    }

    public void eliminaBustaRicevuta(String idEGov) throws EGovException {
        this.eliminaBusta(idEGov, "INBOX");
    }

    public void registraBusta(String idEGov, String tipoBusta) throws EGovException {
        if (this.state instanceof StatefulMessage) {
            StatefulMessage stateful = (StatefulMessage)this.state;
            Connection connectionDB = stateful.getConnectionDB();
            Statement pstmtUpdate = null;
            try {
                StringBuffer queryUpdate = new StringBuffer();
                queryUpdate.append("UPDATE ");
                queryUpdate.append("REPOSITORY_EGOV");
                queryUpdate.append(" SET ");
                queryUpdate.append(this.gestoreRepositoryEGov.createSQLSet_ProfiloCollaborazione(true));
                queryUpdate.append(" WHERE  ID_EGOV = ? AND TIPO=?");
                pstmtUpdate = connectionDB.prepareStatement(queryUpdate.toString());
                pstmtUpdate.setString(1, idEGov);
                pstmtUpdate.setString(2, tipoBusta);
                stateful.getPreparedStatement().put("UPDATE saveBustaForProfilo" + tipoBusta + "_" + idEGov, (PreparedStatement)pstmtUpdate);
            }
            catch (Exception e) {
                String errorMsg = "PROFILO_DI_COLLABORAZIONE, Errore di registrazione " + tipoBusta + "/" + idEGov + ": " + e.getMessage();
                this.log.error((Object)errorMsg, (Throwable)e);
                try {
                    if (pstmtUpdate != null) {
                        pstmtUpdate.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                throw new EGovException(errorMsg, e);
            }
        }
    }

    public void eliminaBusta(String idEGov, String tipoBusta) throws EGovException {
        this.eliminaBusta(idEGov, tipoBusta, false);
    }

    public void eliminaBusta(String idEGov, String tipoBusta, boolean forzaEliminazioneDB) throws EGovException {
        if (this.state instanceof StatefulMessage || forzaEliminazioneDB) {
            StateMessage state = (StateMessage)this.state;
            Connection connectionDB = state.getConnectionDB();
            Statement pstmtUpdate = null;
            try {
                StringBuffer queryUpdate = new StringBuffer();
                queryUpdate.append("UPDATE ");
                queryUpdate.append("REPOSITORY_EGOV");
                queryUpdate.append(" SET ");
                queryUpdate.append(this.gestoreRepositoryEGov.createSQLSet_ProfiloCollaborazione(false));
                queryUpdate.append(" WHERE  ID_EGOV = ? AND TIPO=?");
                pstmtUpdate = connectionDB.prepareStatement(queryUpdate.toString());
                pstmtUpdate.setString(1, idEGov);
                pstmtUpdate.setString(2, tipoBusta);
                state.getPreparedStatement().put("UPDATE eliminaBustaForProfilo" + tipoBusta + "_" + idEGov, (PreparedStatement)pstmtUpdate);
            }
            catch (Exception e) {
                String errorMsg = "PROFILO_DI_COLLABORAZIONE, Errore di cancellazione " + tipoBusta + "/" + idEGov + ": " + e.getMessage();
                this.log.error((Object)errorMsg, (Throwable)e);
                try {
                    if (pstmtUpdate != null) {
                        pstmtUpdate.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                throw new EGovException(errorMsg, e);
            }
        }
    }

    public boolean sincrono_validazioneRiferimentoMessaggio(String riferimentoMessaggio) throws EGovException {
        if (this.state instanceof StatefulMessage) {
            StatefulMessage stateful = (StatefulMessage)this.state;
            try {
                RepositoryEGov repositoryEGov = new RepositoryEGov((IState)stateful, this.log);
                return repositoryEGov.isRegistrataIntoOutBox(riferimentoMessaggio);
            }
            catch (Exception e) {
                String errorMsg = "PROFILO_DI_COLLABORAZIONE_SINCRONO, Errore durante la sincrono_validazioneRiferimentoMessaggio " + riferimentoMessaggio + ": " + e.getMessage();
                this.log.error((Object)errorMsg);
                return false;
            }
        }
        return true;
    }

    public boolean sincrono_validazioneCollaborazione(String riferimentoMessaggio, String idCollaborazione) throws EGovException {
        if (this.state instanceof StatefulMessage) {
            StatefulMessage stateful = (StatefulMessage)this.state;
            try {
                RepositoryEGov repositoryEGov = new RepositoryEGov((IState)stateful, this.log);
                if (repositoryEGov.isRegistrataIntoOutBox(riferimentoMessaggio)) {
                    return idCollaborazione.equals(repositoryEGov.getCollaborazioneFromOutBox(riferimentoMessaggio));
                }
                return false;
            }
            catch (Exception e) {
                String errorMsg = "PROFILO_DI_COLLABORAZIONE_SINCRONO, Errore durante la sincrono_validazioneRiferimentoMessaggio " + riferimentoMessaggio + ": " + e.getMessage();
                this.log.error((Object)errorMsg);
                return false;
            }
        }
        return true;
    }

    public void sincrono_eliminaRichiestaInOutBox(String idEGov) throws EGovException {
        try {
            this.eliminaBustaInviata(idEGov);
        }
        catch (EGovException e) {
            String errorMsg = "PROFILO_DI_COLLABORAZIONE_SINCRONO, Errore durante la sincrono_eliminaRichiestaInOutBox " + idEGov + ": " + e.getMessage();
            this.log.error((Object)errorMsg);
            throw e;
        }
    }

    public Busta sincrono_generaBustaRisposta(String idEGov, String tipoTempo) throws EGovException {
        StateMessage stateMSG = (StateMessage)this.state;
        Busta busta_eGov = null;
        try {
            RepositoryEGov repository = new RepositoryEGov((IState)stateMSG, this.log);
            LetturaParametriBusta parametri = new LetturaParametriBusta();
            parametri.setMittente(true);
            parametri.setDestinatario(true);
            parametri.setServizio(true);
            parametri.setAzione(true);
            parametri.setCollaborazione(true);
            parametri.setProfiloTrasmissione(true);
            busta_eGov = repository.getSomeValuesFromInBox(idEGov, parametri);
        }
        catch (Exception e) {
            String errorMsg = "PROFILO_DI_COLLABORAZIONE_SINCRONO, Errore durante la getBusta dal repository " + idEGov + ": " + e.getMessage();
            this.log.error((Object)errorMsg, (Throwable)e);
            throw new EGovException(errorMsg, e);
        }
        String mitt = busta_eGov.getMittente();
        String tipoMitt = busta_eGov.getTipoMittente();
        String indTelMitt = busta_eGov.getIndirizzoTelematicoMittente();
        busta_eGov.setMittente(busta_eGov.getDestinatario());
        busta_eGov.setTipoMittente(busta_eGov.getTipoDestinatario());
        busta_eGov.setIndirizzoTelematicoMittente(busta_eGov.getIndirizzoTelematicoDestinatario());
        busta_eGov.setDestinatario(mitt);
        busta_eGov.setTipoDestinatario(tipoMitt);
        busta_eGov.setIndirizzoTelematicoDestinatario(indTelMitt);
        busta_eGov.setProfiloDiCollaborazione("EGOV_IT_ServizioSincrono");
        busta_eGov.setRiferimentoMessaggio(idEGov);
        busta_eGov.setOraRegistrazione(DateManager.getDate());
        busta_eGov.setTipoOraRegistrazione(tipoTempo);
        this.eliminaBustaRicevuta(busta_eGov.getRiferimentoMessaggio());
        return busta_eGov;
    }

    public Eccezione sincrono_validazioneCorrelazione(Busta bustaDaValidare) throws EGovException {
        if (this.state instanceof StatefulMessage) {
            Eccezione eccValidazione;
            StatefulMessage stateful = (StatefulMessage)this.state;
            Busta bustaRichiesta = null;
            try {
                RepositoryEGov repository = new RepositoryEGov((IState)stateful, this.log);
                LetturaParametriBusta parametri = new LetturaParametriBusta();
                parametri.setMittente(true);
                parametri.setDestinatario(true);
                parametri.setServizio(true);
                parametri.setAzione(true);
                bustaRichiesta = repository.getSomeValuesFromOutBox(bustaDaValidare.getRiferimentoMessaggio(), parametri);
            }
            catch (Exception e) {
                String errorMsg = "PROFILO_DI_COLLABORAZIONE_SINCRONO, Errore durante la sincrono_validazioneCorrelazione, get dal repository " + bustaDaValidare.getRiferimentoMessaggio() + ": " + e.getMessage();
                this.log.error((Object)errorMsg, (Throwable)e);
                throw new EGovException(errorMsg, e);
            }
            if (!bustaRichiesta.getTipoDestinatario().equals(bustaDaValidare.getTipoMittente())) {
                eccValidazione = new Eccezione();
                eccValidazione.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                eccValidazione.setCodiceEccezione("EGOV_IT_101");
                eccValidazione.setRilevanza("GRAVE");
                eccValidazione.setPosizione("Tipo del mittente diverso da quello atteso nella gestione del profilo di collaborazione Sincrono");
                return eccValidazione;
            }
            if (!bustaRichiesta.getDestinatario().equals(bustaDaValidare.getMittente())) {
                eccValidazione = new Eccezione();
                eccValidazione.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                eccValidazione.setCodiceEccezione("EGOV_IT_101");
                eccValidazione.setRilevanza("GRAVE");
                eccValidazione.setPosizione("Mittente diverso da quello atteso nella gestione del profilo di collaborazione Sincrono");
                return eccValidazione;
            }
            if (!bustaRichiesta.getTipoMittente().equals(bustaDaValidare.getTipoDestinatario())) {
                eccValidazione = new Eccezione();
                eccValidazione.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                eccValidazione.setCodiceEccezione("EGOV_IT_102");
                eccValidazione.setRilevanza("GRAVE");
                eccValidazione.setPosizione("Tipo del destinatario diverso da quello atteso nella gestione del profilo di collaborazione Sincrono");
                return eccValidazione;
            }
            if (!bustaRichiesta.getMittente().equals(bustaDaValidare.getDestinatario())) {
                eccValidazione = new Eccezione();
                eccValidazione.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                eccValidazione.setCodiceEccezione("EGOV_IT_102");
                eccValidazione.setRilevanza("GRAVE");
                eccValidazione.setPosizione("Destinatario diverso da quello atteso nella gestione del profilo di collaborazione Sincrono");
                return eccValidazione;
            }
            if (bustaDaValidare.getServizio() != null && bustaDaValidare.getTipoServizio() != null) {
                if (!bustaRichiesta.getTipoServizio().equals(bustaDaValidare.getTipoServizio())) {
                    eccValidazione = new Eccezione();
                    eccValidazione.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                    eccValidazione.setCodiceEccezione("EGOV_IT_105");
                    eccValidazione.setRilevanza("GRAVE");
                    eccValidazione.setPosizione("Tipo di servizio diverso da quello atteso nella gestione del profilo di collaborazione Sincrono");
                    return eccValidazione;
                }
                if (!bustaRichiesta.getServizio().equals(bustaDaValidare.getServizio())) {
                    eccValidazione = new Eccezione();
                    eccValidazione.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                    eccValidazione.setCodiceEccezione("EGOV_IT_105");
                    eccValidazione.setRilevanza("GRAVE");
                    eccValidazione.setPosizione("Servizio diverso da quello atteso nella gestione del profilo di collaborazione Sincrono");
                    return eccValidazione;
                }
                if (bustaDaValidare.getAzione() != null && !bustaDaValidare.getAzione().equals(bustaRichiesta.getAzione())) {
                    eccValidazione = new Eccezione();
                    eccValidazione.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                    eccValidazione.setCodiceEccezione("EGOV_IT_106");
                    eccValidazione.setRilevanza("GRAVE");
                    eccValidazione.setPosizione("Azione diversa da quella attesa con il profilo di collaborazione Sincrono");
                    return eccValidazione;
                }
            }
            return null;
        }
        return null;
    }

    public void asincronoSimmetrico_registraRichiestaInviata(String idEGov, String idCollaborazione, String tipoServizioCorrelato, String servizioCorrelato, boolean ricevutaApplicativa, Integrazione integrazione, long scadenzaMessaggi) throws EGovException {
        StateMessage state = (StateMessage)this.state;
        Connection connectionDB = state.getConnectionDB();
        Statement pstmt = null;
        Statement pstmtUpdate = null;
        try {
            Timestamp oraInvio = DateManager.getTimestamp();
            StringBuffer query = new StringBuffer();
            query.append("INSERT INTO  ");
            query.append("ASINCRONO");
            query.append(" (ID_EGOV,TIPO,ORA_REGISTRAZIONE,RICEVUTA_ASINCRONA,TIPO_SERVIZIO_CORRELATO,SERVIZIO_CORRELATO");
            query.append(",IS_RICHIESTA,ID_ASINCRONO,ID_COLLABORAZIONE,RICEVUTA_APPLICATIVA) ");
            query.append(" VALUES ( ? , ? , ? , ? , ? , ? , ? , ? , ? , ? )");
            pstmt = connectionDB.prepareStatement(query.toString());
            pstmt.setString(1, idEGov);
            pstmt.setString(2, "OUTBOX");
            pstmt.setTimestamp(3, oraInvio);
            pstmt.setInt(4, 0);
            pstmt.setString(5, tipoServizioCorrelato);
            pstmt.setString(6, servizioCorrelato);
            pstmt.setInt(7, 1);
            pstmt.setString(8, idEGov);
            pstmt.setString(9, idCollaborazione);
            if (ricevutaApplicativa) {
                pstmt.setInt(10, 1);
            } else {
                pstmt.setInt(10, 0);
            }
            state.getPreparedStatement().put("INSERT save_RichiestaAsincronaSimmetricaInviata" + idEGov, (PreparedStatement)pstmt);
            if (this.state instanceof StatefulMessage) {
                this.registraBustaInviata(idEGov);
            } else {
                StatelessMessage statelessMessage = (StatelessMessage)this.state;
                RepositoryEGov repository = new RepositoryEGov(this.state, this.log, true);
                long scadenza = scadenzaMessaggi;
                if (scadenza <= 0L) {
                    scadenza = Configurazione.getScadenzaBusteDefault();
                }
                repository.registraBustaIntoOutBox(statelessMessage.getBusta(), scadenza);
                repository.aggiornaInfoIntegrazioneIntoOutBox(idEGov, integrazione);
                this.registraBustaInviata(idEGov);
                StringBuffer queryUpdate = new StringBuffer();
                queryUpdate.append("UPDATE ");
                queryUpdate.append("REPOSITORY_EGOV");
                queryUpdate.append(" SET ");
                queryUpdate.append(this.gestoreRepositoryEGov.createSQLSet_ProfiloCollaborazione(true));
                queryUpdate.append(" WHERE  ID_EGOV = ? AND TIPO=?");
                pstmtUpdate = connectionDB.prepareStatement(queryUpdate.toString());
                pstmtUpdate.setString(1, idEGov);
                pstmtUpdate.setString(2, "OUTBOX");
                state.getPreparedStatement().put("UPDATE saveBustaForProfiloOUTBOX_" + idEGov, (PreparedStatement)pstmtUpdate);
            }
        }
        catch (Exception e) {
            String errorMsg = "PROFILO_DI_COLLABORAZIONE_ASINCRONO_SIMMETRICO, Errore di registrazione richiesta inviata " + idEGov + ": " + e.getMessage();
            this.log.error((Object)errorMsg, (Throwable)e);
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            try {
                if (pstmtUpdate != null) {
                    pstmtUpdate.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            throw new EGovException(errorMsg, e);
        }
    }

    public Integrazione asincronoSimmetrico_getDatiConsegnaRisposta(String riferimentoMessaggio) throws EGovException {
        StateMessage state = (StateMessage)this.state;
        try {
            History history = new History(state, this.log);
            history.registraBustaInviata(riferimentoMessaggio);
            RepositoryEGov repositoryEGov = new RepositoryEGov((IState)state, this.log);
            Integrazione integrazione = repositoryEGov.getInfoIntegrazioneFromOutBox(riferimentoMessaggio);
            if (integrazione == null) {
                throw new Exception("Dati di integrazione non trovati");
            }
            return integrazione;
        }
        catch (Exception e) {
            String errorMsg = "PROFILO_DI_COLLABORAZIONE_ASINCRONO_SIMMETRICO, Errore durante la asincronoSimmetrico_getDatiConsegnaRisposta " + riferimentoMessaggio + ": " + e.getMessage();
            this.log.error((Object)errorMsg, (Throwable)e);
            throw new EGovException(errorMsg, e);
        }
    }

    public Integrazione asincronoSimmetrico_getDatiConsegnaRicevuta(String riferimentoMessaggio) throws EGovException {
        StateMessage state = (StateMessage)this.state;
        try {
            RepositoryEGov repositoryEGov = new RepositoryEGov((IState)state, this.log);
            Integrazione integrazione = repositoryEGov.getInfoIntegrazioneFromOutBox(riferimentoMessaggio);
            if (integrazione == null) {
                throw new Exception("Dati di integrazione non trovati");
            }
            return integrazione;
        }
        catch (Exception e) {
            String errorMsg = "PROFILO_DI_COLLABORAZIONE_ASINCRONO_SIMMETRICO, Errore durante la asincronoSimmetrico_getDatiConsegnaRicevuta " + riferimentoMessaggio + ": " + e.getMessage();
            this.log.error((Object)errorMsg, (Throwable)e);
            throw new EGovException(errorMsg, e);
        }
    }

    public void asincronoSimmetrico_registraRichiestaRicevuta(String idEGov, String idCollaborazione, String tipoServizioCorrelato, String servizioCorrelato, boolean ricevutaApplicativa, long scadenzaMessaggi) throws EGovException {
        StateMessage state = (StateMessage)this.state;
        Connection connectionDB = state.getConnectionDB();
        PreparedStatement pstmt = null;
        Statement pstmtUpdate = null;
        ResultSet rs = null;
        try {
            Timestamp oraRicezione = DateManager.getTimestamp();
            StringBuffer querySearch = new StringBuffer();
            querySearch.append("SELECT ID_EGOV FROM ");
            querySearch.append("ASINCRONO");
            querySearch.append(" WHERE ID_EGOV=? AND TIPO=?");
            pstmt = connectionDB.prepareStatement(querySearch.toString());
            pstmt.setString(1, idEGov);
            pstmt.setString(2, "INBOX");
            rs = pstmt.executeQuery();
            boolean exists = rs.next();
            rs.close();
            pstmt.close();
            StringBuffer query = new StringBuffer();
            if (exists) {
                query.append("UPDATE ");
                query.append("ASINCRONO");
                query.append(" SET ID_EGOV=?,TIPO=?,ORA_REGISTRAZIONE=?,RICEVUTA_ASINCRONA=?,TIPO_SERVIZIO_CORRELATO=?,SERVIZIO_CORRELATO=?,IS_RICHIESTA=?,ID_ASINCRONO=?,ID_COLLABORAZIONE=?,RICEVUTA_APPLICATIVA=? WHERE ID_EGOV=? AND TIPO=?");
            } else {
                query.append("INSERT INTO  ");
                query.append("ASINCRONO");
                query.append(" (ID_EGOV,TIPO,ORA_REGISTRAZIONE,RICEVUTA_ASINCRONA,TIPO_SERVIZIO_CORRELATO,SERVIZIO_CORRELATO");
                query.append(",IS_RICHIESTA,ID_ASINCRONO,ID_COLLABORAZIONE,RICEVUTA_APPLICATIVA) ");
                query.append(" VALUES ( ? , ? , ? , ? , ? , ? , ? , ? , ? , ? )");
            }
            pstmt = connectionDB.prepareStatement(query.toString());
            pstmt.setString(1, idEGov);
            pstmt.setString(2, "INBOX");
            pstmt.setTimestamp(3, oraRicezione);
            pstmt.setInt(4, 1);
            pstmt.setString(5, tipoServizioCorrelato);
            pstmt.setString(6, servizioCorrelato);
            pstmt.setInt(7, 1);
            pstmt.setString(8, idEGov);
            pstmt.setString(9, idCollaborazione);
            if (ricevutaApplicativa) {
                pstmt.setInt(10, 1);
            } else {
                pstmt.setInt(10, 0);
            }
            if (exists) {
                pstmt.setString(11, idEGov);
                pstmt.setString(12, "INBOX");
            }
            if (exists) {
                state.getPreparedStatement().put("UPDATE save_RichiestaAsincronaSimmetricaRicevuta" + idEGov, pstmt);
            } else {
                state.getPreparedStatement().put("INSERT save_RichiestaAsincronaSimmetricaRicevuta" + idEGov, pstmt);
            }
            if (this.state instanceof StatefulMessage) {
                this.registraBustaRicevuta(idEGov);
            } else {
                StatelessMessage statelessMessage = (StatelessMessage)this.state;
                long scadenza = scadenzaMessaggi;
                if (scadenza <= 0L) {
                    scadenza = Configurazione.getScadenzaBusteDefault();
                }
                RepositoryEGov repository = new RepositoryEGov(this.state, this.log, true);
                String key = "INSERT RegistrazioneBustaForHistoryINBOX_" + statelessMessage.getBusta().getID();
                if (repository.isRegistrataIntoInBox(statelessMessage.getBusta().getID())) {
                    repository.aggiornaBustaIntoInBox(statelessMessage.getBusta(), scadenza);
                } else if (state.getPreparedStatement().containsKey(key)) {
                    repository.aggiornaBustaIntoInBox(statelessMessage.getBusta(), scadenza);
                } else {
                    repository.registraBustaIntoInBox(statelessMessage.getBusta(), scadenza);
                }
                this.registraBustaRicevuta(idEGov);
                StringBuffer queryUpdate = new StringBuffer();
                queryUpdate.append("UPDATE ");
                queryUpdate.append("REPOSITORY_EGOV");
                queryUpdate.append(" SET ");
                queryUpdate.append(this.gestoreRepositoryEGov.createSQLSet_ProfiloCollaborazione(true));
                queryUpdate.append(" WHERE  ID_EGOV = ? AND TIPO=?");
                pstmtUpdate = connectionDB.prepareStatement(queryUpdate.toString());
                pstmtUpdate.setString(1, idEGov);
                pstmtUpdate.setString(2, "INBOX");
                state.getPreparedStatement().put("UPDATE saveBustaForProfiloINBOX_" + idEGov, (PreparedStatement)pstmtUpdate);
            }
        }
        catch (Exception e) {
            String errorMsg = "PROFILO_DI_COLLABORAZIONE_ASINCRONO_SIMMETRICO, Errore di registrazione richiesta ricevuta " + idEGov + ": " + e.getMessage();
            this.log.error((Object)errorMsg, (Throwable)e);
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            try {
                if (pstmtUpdate != null) {
                    pstmtUpdate.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            throw new EGovException(errorMsg, e);
        }
    }

    public Busta asincronoSimmetrico_getBustaRisposta(String spcoopID, String idEGovRisposta, long scadenzaMessaggi) throws EGovException {
        StateMessage state = (StateMessage)this.state;
        Connection connectionDB = state.getConnectionDB();
        Busta busta_eGov = null;
        try {
            RepositoryEGov repository = new RepositoryEGov((IState)state, this.log);
            if (!repository.exists(spcoopID, "INBOX")) {
                throw new Exception("Busta non trovata");
            }
            LetturaParametriBusta parametri = new LetturaParametriBusta();
            parametri.setMittente(true);
            parametri.setDestinatario(true);
            parametri.setServizioCorrelato(true);
            busta_eGov = repository.getSomeValuesFromInBox(spcoopID, parametri, true);
        }
        catch (Exception e) {
            String errorMsg = "PROFILO_DI_COLLABORAZIONE_ASINCRONO_SIMMETRICO, Errore durante la getBusta dal repository " + spcoopID + ": " + e.getMessage();
            this.log.error((Object)errorMsg, (Throwable)e);
            throw new EGovException(errorMsg, e);
        }
        busta_eGov.setProfiloDiCollaborazione("EGOV_IT_ServizioAsincronoSimmetrico");
        PreparedStatement pstmtCheck = null;
        ResultSet rsCheck = null;
        String oldIDRisposta = null;
        String oldTipoRisposta = null;
        try {
            StringBuffer query = new StringBuffer();
            query.append("SELECT ID_EGOV,TIPO FROM ");
            query.append("ASINCRONO");
            query.append(" WHERE BACKUP_ID_RICHIESTA=?");
            pstmtCheck = connectionDB.prepareStatement(query.toString());
            pstmtCheck.setString(1, spcoopID);
            rsCheck = pstmtCheck.executeQuery();
            if (rsCheck == null) {
                throw new EGovException("RS Check Null?");
            }
            if (rsCheck.next()) {
                oldIDRisposta = rsCheck.getString("ID_EGOV");
                oldTipoRisposta = rsCheck.getString("TIPO");
            }
            rsCheck.close();
            pstmtCheck.close();
        }
        catch (Exception e) {
            String errorMsg = "PROFILO_DI_COLLABORAZIONE_ASINCRONO_SIMMETRICO, asincronoSimmetrico_getBustaRisposta " + spcoopID + ": " + e.getMessage();
            this.log.error((Object)errorMsg, (Throwable)e);
            try {
                if (rsCheck != null) {
                    rsCheck.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            try {
                if (pstmtCheck != null) {
                    pstmtCheck.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            throw new EGovException(errorMsg, e);
        }
        PreparedStatement pstmt = null;
        try {
            Timestamp oraInvioRisposta = DateManager.getTimestamp();
            StringBuffer query = new StringBuffer();
            query.append("UPDATE ");
            query.append("ASINCRONO");
            query.append(" SET IS_RICHIESTA=0, RICEVUTA_ASINCRONA=0, ORA_REGISTRAZIONE=?, ID_EGOV=?, TIPO=?, BACKUP_ID_RICHIESTA=? WHERE  ID_EGOV = ? AND TIPO=?");
            pstmt = connectionDB.prepareStatement(query.toString());
            pstmt.setTimestamp(1, oraInvioRisposta);
            pstmt.setString(2, idEGovRisposta);
            pstmt.setString(3, "OUTBOX");
            pstmt.setString(4, spcoopID);
            if (oldIDRisposta != null && oldTipoRisposta != null) {
                pstmt.setString(5, oldIDRisposta);
                pstmt.setString(6, oldTipoRisposta);
            } else {
                pstmt.setString(5, spcoopID);
                pstmt.setString(6, "INBOX");
            }
            state.getPreparedStatement().put("UPDATE save_RispostaAsincronaSimmetricaInviata" + spcoopID, pstmt);
        }
        catch (Exception e) {
            String errorMsg = "PROFILO_DI_COLLABORAZIONE_ASINCRONO_SIMMETRICO, Errore di registrazione risposta inviata " + spcoopID + ": " + e.getMessage();
            this.log.error((Object)errorMsg, (Throwable)e);
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            throw new EGovException(errorMsg, e);
        }
        if (busta_eGov.getTipoServizioCorrelato() == null || busta_eGov.getServizioCorrelato() == null) {
            PreparedStatement pstmtServizioCorrelato = null;
            ResultSet rsServizioCorrelato = null;
            String tipoSC = null;
            String nomeSC = null;
            try {
                StringBuffer query = new StringBuffer();
                query.append("SELECT TIPO_SERVIZIO_CORRELATO,SERVIZIO_CORRELATO FROM ");
                query.append("ASINCRONO");
                query.append(" WHERE ID_EGOV = ? AND TIPO=?");
                pstmtServizioCorrelato = connectionDB.prepareStatement(query.toString());
                if (oldIDRisposta != null && oldTipoRisposta != null) {
                    pstmtServizioCorrelato.setString(1, oldIDRisposta);
                    pstmtServizioCorrelato.setString(2, oldTipoRisposta);
                } else {
                    pstmtServizioCorrelato.setString(1, spcoopID);
                    pstmtServizioCorrelato.setString(2, "INBOX");
                }
                rsServizioCorrelato = pstmtServizioCorrelato.executeQuery();
                if (rsServizioCorrelato == null) {
                    throw new EGovException("RS Check Null?");
                }
                if (rsServizioCorrelato.next()) {
                    tipoSC = rsServizioCorrelato.getString("TIPO_SERVIZIO_CORRELATO");
                    nomeSC = rsServizioCorrelato.getString("SERVIZIO_CORRELATO");
                }
                rsServizioCorrelato.close();
                pstmtServizioCorrelato.close();
                if (tipoSC == null || nomeSC == null) {
                    throw new Exception("Tipo/Nome servizio correlato non trovato");
                }
            }
            catch (Exception e) {
                String errorMsg = "PROFILO_DI_COLLABORAZIONE_ASINCRONO_SIMMETRICO, asincronoSimmetrico_getBustaRisposta " + spcoopID + ": " + e.getMessage();
                this.log.error((Object)errorMsg, (Throwable)e);
                try {
                    if (rsServizioCorrelato != null) {
                        rsServizioCorrelato.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                try {
                    if (pstmtServizioCorrelato != null) {
                        pstmtServizioCorrelato.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                throw new EGovException(errorMsg, e);
            }
            busta_eGov.setTipoServizioCorrelato(tipoSC);
            busta_eGov.setServizioCorrelato(nomeSC);
        }
        if (this.state instanceof StatefulMessage) {
            this.registraBustaInviata(idEGovRisposta);
        } else {
            Statement pstmtUpdate = null;
            try {
                StatelessMessage statelessMessage = (StatelessMessage)this.state;
                RepositoryEGov repository = new RepositoryEGov(this.state, this.log, true);
                long scadenza = scadenzaMessaggi;
                if (scadenza <= 0L) {
                    scadenza = Configurazione.getScadenzaBusteDefault();
                }
                repository.registraBustaIntoOutBox(statelessMessage.getBusta(), scadenza);
                this.registraBustaInviata(idEGovRisposta);
                StringBuffer queryUpdate = new StringBuffer();
                queryUpdate.append("UPDATE ");
                queryUpdate.append("REPOSITORY_EGOV");
                queryUpdate.append(" SET ");
                queryUpdate.append(this.gestoreRepositoryEGov.createSQLSet_ProfiloCollaborazione(true));
                queryUpdate.append(" WHERE  ID_EGOV = ? AND TIPO=?");
                pstmtUpdate = connectionDB.prepareStatement(queryUpdate.toString());
                pstmtUpdate.setString(1, idEGovRisposta);
                pstmtUpdate.setString(2, "OUTBOX");
                state.getPreparedStatement().put("UPDATE saveBustaForProfiloOUTBOX_" + idEGovRisposta, (PreparedStatement)pstmtUpdate);
            }
            catch (Exception e) {
                String errorMsg = "PROFILO_DI_COLLABORAZIONE_ASINCRONO_SIMMETRICO, Errore di aggiornamento busta di risposta " + idEGovRisposta + ": " + e.getMessage();
                this.log.error((Object)errorMsg, (Throwable)e);
                try {
                    if (pstmtUpdate != null) {
                        pstmtUpdate.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                throw new EGovException(errorMsg, e);
            }
        }
        if (oldIDRisposta != null && oldTipoRisposta != null) {
            this.eliminaBusta(oldIDRisposta, oldTipoRisposta, true);
        }
        return busta_eGov;
    }

    public Busta asincronoSimmetrico_getBustaRicevuta(String idEGov, String rifMsgRicevuta, boolean isRichiesta, String tipoTempo) throws EGovException {
        StateMessage state = (StateMessage)this.state;
        Connection connectionDB = state.getConnectionDB();
        Busta busta_eGov = null;
        try {
            RepositoryEGov repository = new RepositoryEGov((IState)state, this.log);
            LetturaParametriBusta parametri = new LetturaParametriBusta();
            parametri.setMittente(true);
            parametri.setDestinatario(true);
            parametri.setServizio(true);
            parametri.setServizioCorrelato(true);
            parametri.setAzione(true);
            parametri.setCollaborazione(true);
            parametri.setProfiloTrasmissione(true);
            if (isRichiesta) {
                busta_eGov = repository.getSomeValuesFromInBox(idEGov, parametri, true);
            } else {
                busta_eGov = repository.getSomeValuesFromOutBox(idEGov, parametri, true);
                this.eliminaBustaInviata(idEGov, true);
            }
            busta_eGov.setProfiloDiCollaborazione("EGOV_IT_ServizioAsincronoSimmetrico");
            if (isRichiesta) {
                String mitt = busta_eGov.getMittente();
                String tipoMitt = busta_eGov.getTipoMittente();
                String indTelMitt = busta_eGov.getIndirizzoTelematicoMittente();
                busta_eGov.setMittente(busta_eGov.getDestinatario());
                busta_eGov.setTipoMittente(busta_eGov.getTipoDestinatario());
                busta_eGov.setIndirizzoTelematicoMittente(busta_eGov.getIndirizzoTelematicoDestinatario());
                busta_eGov.setDestinatario(mitt);
                busta_eGov.setTipoDestinatario(tipoMitt);
                busta_eGov.setIndirizzoTelematicoDestinatario(indTelMitt);
            }
            if (!isRichiesta) {
                String tipoServizioCorrelato = busta_eGov.getTipoServizioCorrelato();
                String servizioCorrelato = busta_eGov.getServizioCorrelato();
                if (tipoServizioCorrelato == null || servizioCorrelato == null) {
                    PreparedStatement pstmtServizioCorrelato = null;
                    ResultSet rsServizioCorrelato = null;
                    try {
                        StringBuffer query = new StringBuffer();
                        query.append("SELECT TIPO_SERVIZIO_CORRELATO,SERVIZIO_CORRELATO FROM ");
                        query.append("ASINCRONO");
                        query.append(" WHERE ID_EGOV = ? AND TIPO=?");
                        pstmtServizioCorrelato = connectionDB.prepareStatement(query.toString());
                        pstmtServizioCorrelato.setString(1, idEGov);
                        pstmtServizioCorrelato.setString(2, "OUTBOX");
                        rsServizioCorrelato = pstmtServizioCorrelato.executeQuery();
                        if (rsServizioCorrelato == null) {
                            throw new EGovException("RS Check Null?");
                        }
                        if (rsServizioCorrelato.next()) {
                            tipoServizioCorrelato = rsServizioCorrelato.getString("TIPO_SERVIZIO_CORRELATO");
                            servizioCorrelato = rsServizioCorrelato.getString("SERVIZIO_CORRELATO");
                        }
                        rsServizioCorrelato.close();
                        pstmtServizioCorrelato.close();
                        if (tipoServizioCorrelato == null || servizioCorrelato == null) {
                            throw new Exception("Tipo/Nome servizio correlato non trovato");
                        }
                    }
                    catch (Exception e) {
                        throw new Exception("Lettura Servizio correlato non riuscita " + e.getMessage(), e);
                    }
                }
                busta_eGov.setTipoServizio(tipoServizioCorrelato);
                busta_eGov.setServizio(servizioCorrelato);
            }
            busta_eGov.setRiferimentoMessaggio(rifMsgRicevuta);
            busta_eGov.setOraRegistrazione(DateManager.getDate());
            busta_eGov.setTipoOraRegistrazione(tipoTempo);
            busta_eGov.setTipoServizioCorrelato(null);
            busta_eGov.setServizioCorrelato(null);
        }
        catch (Exception e) {
            String errorMsg = "PROFILO_DI_COLLABORAZIONE_ASINCRONO_SIMMETRICO, Errore durante la asincronoSimmetrico_getBustaRicevuta dal repository " + idEGov + ": " + e.getMessage();
            this.log.error((Object)errorMsg, (Throwable)e);
            throw new EGovException(errorMsg, e);
        }
        return busta_eGov;
    }

    public Eccezione asincronoSimmetrico_validazioneCorrelazione_ricevutaRichiesta(Busta bustaDaValidare) throws EGovException {
        return this.asincronoSimmetrico_validazioneCorrelazione(bustaDaValidare, true, false, false);
    }

    public Eccezione asincronoSimmetrico_validazioneCorrelazione_risposta(Busta bustaDaValidare) throws EGovException {
        return this.asincronoSimmetrico_validazioneCorrelazione(bustaDaValidare, false, true, false);
    }

    public Eccezione asincronoSimmetrico_validazioneCorrelazione_ricevutaRisposta(Busta bustaDaValidare) throws EGovException {
        return this.asincronoSimmetrico_validazioneCorrelazione(bustaDaValidare, false, false, true);
    }

    private Eccezione asincronoSimmetrico_validazioneCorrelazione(Busta bustaDaValidare, boolean isRicevutaRichiesta, boolean isRisposta, boolean isRicevutaRisposta) throws EGovException {
        Eccezione eccValidazione;
        StateMessage state = (StateMessage)this.state;
        Connection connectionDB = state.getConnectionDB();
        Busta bustaRichiesta = null;
        try {
            RepositoryEGov repository = new RepositoryEGov((IState)state, this.log);
            LetturaParametriBusta parametri = new LetturaParametriBusta();
            parametri.setMittente(true);
            parametri.setDestinatario(true);
            parametri.setServizio(true);
            parametri.setAzione(true);
            bustaRichiesta = isRisposta && bustaDaValidare.getRiferimentoMessaggio() == null ? repository.getSomeValuesFromOutBox(bustaDaValidare.getCollaborazione(), parametri, true) : repository.getSomeValuesFromOutBox(bustaDaValidare.getRiferimentoMessaggio(), parametri, true);
        }
        catch (Exception e) {
            String errorMsg = "PROFILO_DI_COLLABORAZIONE_ASINCRONO_SIMMETRICO, Errore durante la validazioneCorrelazione, get dal repository " + bustaDaValidare.getRiferimentoMessaggio() + ": " + e.getMessage();
            this.log.error((Object)errorMsg, (Throwable)e);
            throw new EGovException(errorMsg, e);
        }
        if (isRicevutaRichiesta) {
            if (bustaDaValidare.getServizio() != null && bustaDaValidare.getTipoServizio() != null) {
                if (!bustaRichiesta.getTipoServizio().equals(bustaDaValidare.getTipoServizio())) {
                    eccValidazione = new Eccezione();
                    eccValidazione.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                    eccValidazione.setCodiceEccezione("EGOV_IT_105");
                    eccValidazione.setRilevanza("GRAVE");
                    eccValidazione.setPosizione("Tipo di servizio diverso da quello atteso nella gestione del profilo di collaborazione Asincrono Simmetrico");
                    return eccValidazione;
                }
                if (!bustaRichiesta.getServizio().equals(bustaDaValidare.getServizio())) {
                    eccValidazione = new Eccezione();
                    eccValidazione.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                    eccValidazione.setCodiceEccezione("EGOV_IT_105");
                    eccValidazione.setRilevanza("GRAVE");
                    eccValidazione.setPosizione("Servizio diverso da quello atteso nella gestione del profilo di collaborazione Asincrono Simmetrico");
                    return eccValidazione;
                }
            }
        } else if (isRisposta || isRicevutaRisposta && bustaDaValidare.getServizio() != null && bustaDaValidare.getTipoServizio() != null) {
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                StringBuffer query = new StringBuffer();
                query.append("SELECT TIPO_SERVIZIO_CORRELATO,SERVIZIO_CORRELATO FROM ");
                query.append("ASINCRONO");
                query.append(" WHERE ID_EGOV=? AND TIPO=?");
                pstmt = connectionDB.prepareStatement(query.toString());
                if (isRisposta && bustaDaValidare.getRiferimentoMessaggio() == null) {
                    pstmt.setString(1, bustaDaValidare.getCollaborazione());
                } else {
                    pstmt.setString(1, bustaDaValidare.getRiferimentoMessaggio());
                }
                pstmt.setString(2, "OUTBOX");
                rs = pstmt.executeQuery();
                if (rs == null) {
                    throw new EGovException("RS Null?");
                }
                String tipoServizioCorrelatoRegistrato = null;
                String servizioCorrelatoRegistrato = null;
                if (rs.next()) {
                    tipoServizioCorrelatoRegistrato = rs.getString("TIPO_SERVIZIO_CORRELATO");
                    servizioCorrelatoRegistrato = rs.getString("SERVIZIO_CORRELATO");
                }
                rs.close();
                pstmt.close();
                if (!bustaDaValidare.getTipoServizio().equals(tipoServizioCorrelatoRegistrato)) {
                    Eccezione eccValidazione2 = new Eccezione();
                    eccValidazione2.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                    eccValidazione2.setCodiceEccezione("EGOV_IT_105");
                    eccValidazione2.setRilevanza("GRAVE");
                    eccValidazione2.setPosizione("Tipo del Servizio diverso da quello atteso con il profilo di collaborazione Asincrono Simmetrico");
                    return eccValidazione2;
                }
                if (!bustaDaValidare.getServizio().equals(servizioCorrelatoRegistrato)) {
                    Eccezione eccValidazione3 = new Eccezione();
                    eccValidazione3.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                    eccValidazione3.setCodiceEccezione("EGOV_IT_105");
                    eccValidazione3.setRilevanza("GRAVE");
                    eccValidazione3.setPosizione("Servizio diverso da quello atteso con il profilo di collaborazione Asincrono Simmetrico");
                    return eccValidazione3;
                }
            }
            catch (Exception e) {
                String errorMsg = "PROFILO_DI_COLLABORAZIONE_ASINCRONO_SIMMETRICO, validazioneCorrelazioneRichiesta RifMsg(" + bustaDaValidare.getRiferimentoMessaggio() + ") Collab(" + bustaDaValidare.getCollaborazione() + "): " + e.getMessage();
                this.log.error((Object)errorMsg);
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                throw new EGovException(errorMsg);
            }
        }
        if (bustaDaValidare.getAzione() != null && !isRisposta && !bustaDaValidare.getAzione().equals(bustaRichiesta.getAzione())) {
            eccValidazione = new Eccezione();
            eccValidazione.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
            eccValidazione.setCodiceEccezione("EGOV_IT_106");
            eccValidazione.setRilevanza("GRAVE");
            eccValidazione.setPosizione("Azione diversa da quella attesa con il profilo di collaborazione Asincrono Simmetrico");
            return eccValidazione;
        }
        if (!bustaRichiesta.getTipoDestinatario().equals(bustaDaValidare.getTipoMittente())) {
            eccValidazione = new Eccezione();
            eccValidazione.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
            eccValidazione.setCodiceEccezione("EGOV_IT_101");
            eccValidazione.setRilevanza("GRAVE");
            eccValidazione.setPosizione("Tipo del mittente diverso da quello atteso con il profilo di collaborazione Asincrono Simmetrico");
            return eccValidazione;
        }
        if (!bustaRichiesta.getDestinatario().equals(bustaDaValidare.getMittente())) {
            eccValidazione = new Eccezione();
            eccValidazione.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
            eccValidazione.setCodiceEccezione("EGOV_IT_101");
            eccValidazione.setRilevanza("GRAVE");
            eccValidazione.setPosizione("Mittente diverso da quello atteso con il profilo di collaborazione Asincrono Simmetrico");
            return eccValidazione;
        }
        if (!bustaRichiesta.getTipoMittente().equals(bustaDaValidare.getTipoDestinatario())) {
            eccValidazione = new Eccezione();
            eccValidazione.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
            eccValidazione.setCodiceEccezione("EGOV_IT_102");
            eccValidazione.setRilevanza("GRAVE");
            eccValidazione.setPosizione("Tipo del destinatario diverso da quello atteso con il profilo di collaborazione Asincrono Simmetrico");
            return eccValidazione;
        }
        if (!bustaRichiesta.getMittente().equals(bustaDaValidare.getDestinatario())) {
            eccValidazione = new Eccezione();
            eccValidazione.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
            eccValidazione.setCodiceEccezione("EGOV_IT_102");
            eccValidazione.setRilevanza("GRAVE");
            eccValidazione.setPosizione("Destinatario diverso da quello atteso con il profilo di collaborazione Asincrono Simmetrico");
            return eccValidazione;
        }
        return null;
    }

    public boolean asincronoSimmetrico_validazioneRiferimentoMessaggio(String riferimentoMessaggio) throws EGovException {
        StateMessage state = (StateMessage)this.state;
        Connection connectionDB = state.getConnectionDB();
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            StringBuffer query = new StringBuffer();
            query.append("SELECT ID_EGOV FROM ");
            query.append("ASINCRONO");
            query.append(" WHERE ID_EGOV=? AND TIPO=?");
            pstmt = connectionDB.prepareStatement(query.toString());
            pstmt.setString(1, riferimentoMessaggio);
            pstmt.setString(2, "OUTBOX");
            rs = pstmt.executeQuery();
            if (rs == null) {
                throw new EGovException("RS Null?");
            }
            boolean value = rs.next();
            rs.close();
            pstmt.close();
            RepositoryEGov repositoryEGov = new RepositoryEGov((IState)state, this.log);
            return value && repositoryEGov.isRegistrataIntoOutBox(riferimentoMessaggio);
        }
        catch (Exception e) {
            String errorMsg = "PROFILO_DI_COLLABORAZIONE_ASINCRONO_SIMMETRICO, validazioneRiferimentoMessaggio " + riferimentoMessaggio + ": " + e.getMessage();
            this.log.error((Object)errorMsg);
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            throw new EGovException(errorMsg, e);
        }
    }

    public boolean asincronoSimmetrico_validazioneCollaborazione_risposta(String riferimentoMessaggio, String idCollaborazione) throws EGovException {
        return this.asincronoSimmetrico_validazioneCollaborazione(riferimentoMessaggio, idCollaborazione, true);
    }

    public boolean asincronoSimmetrico_validazioneCollaborazione_ricevuta(String riferimentoMessaggio, String idCollaborazione) throws EGovException {
        return this.asincronoSimmetrico_validazioneCollaborazione(riferimentoMessaggio, idCollaborazione, false);
    }

    private boolean asincronoSimmetrico_validazioneCollaborazione(String riferimentoMessaggio, String idCollaborazione, boolean isRisposta) throws EGovException {
        StateMessage state = (StateMessage)this.state;
        Connection connectionDB = state.getConnectionDB();
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            StringBuffer query = new StringBuffer();
            query.append("SELECT ID_COLLABORAZIONE FROM ");
            query.append("ASINCRONO");
            query.append(" WHERE ID_EGOV=? AND TIPO=?");
            pstmt = connectionDB.prepareStatement(query.toString());
            if (isRisposta && riferimentoMessaggio == null) {
                pstmt.setString(1, idCollaborazione);
            } else {
                pstmt.setString(1, riferimentoMessaggio);
            }
            pstmt.setString(2, "OUTBOX");
            rs = pstmt.executeQuery();
            if (rs == null) {
                throw new EGovException("RS Null?");
            }
            String value = null;
            if (rs.next()) {
                value = rs.getString("ID_COLLABORAZIONE");
            }
            rs.close();
            pstmt.close();
            return idCollaborazione.equals(value);
        }
        catch (Exception e) {
            String errorMsg = "PROFILO_DI_COLLABORAZIONE_ASINCRONO_SIMMETRICO, validazioneCollaborazione " + riferimentoMessaggio + ": " + e.getMessage();
            this.log.error((Object)errorMsg, (Throwable)e);
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            throw new EGovException(errorMsg, e);
        }
    }

    public void asincronoAsimmetrico_registraRichiestaInviata(String idEGov, String idCollaborazione, boolean ricevutaApplicativa, long scadenzaMessaggi) throws EGovException {
        StateMessage state = (StateMessage)this.state;
        Connection connectionDB = state.getConnectionDB();
        Statement pstmt = null;
        Statement pstmtUpdate = null;
        try {
            Timestamp oraInvio = DateManager.getTimestamp();
            StringBuffer query = new StringBuffer();
            query.append("INSERT INTO  ");
            query.append("ASINCRONO");
            query.append(" (ID_EGOV,TIPO,ORA_REGISTRAZIONE,RICEVUTA_ASINCRONA,TIPO_SERVIZIO_CORRELATO,SERVIZIO_CORRELATO");
            query.append(",IS_RICHIESTA,ID_ASINCRONO,ID_COLLABORAZIONE,RICEVUTA_APPLICATIVA) ");
            query.append(" VALUES ( ? , ? , ? , ? , ? , ? , ? , ? , ? , ?)");
            pstmt = connectionDB.prepareStatement(query.toString());
            pstmt.setString(1, idEGov);
            pstmt.setString(2, "OUTBOX");
            pstmt.setTimestamp(3, oraInvio);
            pstmt.setInt(4, 0);
            pstmt.setString(5, null);
            pstmt.setString(6, null);
            pstmt.setInt(7, 1);
            pstmt.setString(8, idEGov);
            pstmt.setString(9, idCollaborazione);
            if (ricevutaApplicativa) {
                pstmt.setInt(10, 1);
            } else {
                pstmt.setInt(10, 0);
            }
            state.getPreparedStatement().put("INSERT save_RichiestaAsincronaAsimmetricaInviata" + idEGov, (PreparedStatement)pstmt);
            if (this.state instanceof StatefulMessage) {
                this.registraBustaInviata(idEGov);
            } else {
                StatelessMessage statelessMessage = (StatelessMessage)this.state;
                RepositoryEGov repository = new RepositoryEGov(this.state, this.log, true);
                long scadenza = scadenzaMessaggi;
                if (scadenza <= 0L) {
                    scadenza = Configurazione.getScadenzaBusteDefault();
                }
                repository.registraBustaIntoOutBox(statelessMessage.getBusta(), scadenza);
                this.registraBustaInviata(idEGov);
                StringBuffer queryUpdate = new StringBuffer();
                queryUpdate.append("UPDATE ");
                queryUpdate.append("REPOSITORY_EGOV");
                queryUpdate.append(" SET ");
                queryUpdate.append(this.gestoreRepositoryEGov.createSQLSet_ProfiloCollaborazione(true));
                queryUpdate.append(" WHERE  ID_EGOV = ? AND TIPO=?");
                pstmtUpdate = connectionDB.prepareStatement(queryUpdate.toString());
                pstmtUpdate.setString(1, idEGov);
                pstmtUpdate.setString(2, "OUTBOX");
                state.getPreparedStatement().put("UPDATE saveBustaForProfiloOUTBOX_" + idEGov, (PreparedStatement)pstmtUpdate);
            }
        }
        catch (Exception e) {
            String errorMsg = "PROFILO_DI_COLLABORAZIONE_ASINCRONO_ASIMMETRICO, Errore di registrazione richiesta inviata " + idEGov + ": " + e.getMessage();
            this.log.error((Object)errorMsg, (Throwable)e);
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            try {
                if (pstmtUpdate != null) {
                    pstmtUpdate.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            throw new EGovException(errorMsg, e);
        }
    }

    public IDServizio asincronoAsimmetrico_getDatiConsegnaRisposta(String riferimentoMessaggio) throws EGovException {
        StateMessage state = (StateMessage)this.state;
        Connection connectionDB = state.getConnectionDB();
        PreparedStatement pstmtPooling = null;
        try {
            StringBuffer query = new StringBuffer();
            query.append("UPDATE ");
            query.append("ASINCRONO");
            query.append(" SET RICEVUTA_APPLICATIVA=1 WHERE  ID_EGOV = ? AND TIPO=?");
            pstmtPooling = connectionDB.prepareStatement(query.toString());
            pstmtPooling.setString(1, riferimentoMessaggio);
            pstmtPooling.setString(2, "INBOX");
            state.getPreparedStatement().put("UPDATE asincronoAsimmetrico_getDatiConsegnaRisposta " + riferimentoMessaggio, pstmtPooling);
        }
        catch (Exception e) {
            String errorMsg = "PROFILO_DI_COLLABORAZIONE_ASINCRONO_ASIMMETRICO, Errore asincronoAsimmetrico_getDatiConsegnaRisposta, update RICEVUTA_APPLICATIVA " + riferimentoMessaggio + ": " + e.getMessage();
            this.log.error((Object)errorMsg, (Throwable)e);
            try {
                if (pstmtPooling != null) {
                    pstmtPooling.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            throw new EGovException(errorMsg, e);
        }
        try {
            History history = new History(state, this.log);
            history.registraBustaRicevuta(riferimentoMessaggio);
            RepositoryEGov repositoryEGov = new RepositoryEGov((IState)state, this.log);
            LetturaParametriBusta parametri = new LetturaParametriBusta();
            parametri.setServizio(true);
            parametri.setAzione(true);
            Busta busta = repositoryEGov.getSomeValuesFromInBox(riferimentoMessaggio, parametri, true);
            if (busta == null) {
                throw new Exception("Dati non trovati");
            }
            IDServizio id = new IDServizio();
            id.setTipoServizio(busta.getTipoServizio());
            id.setServizio(busta.getServizio());
            id.setAzione(busta.getAzione());
            return id;
        }
        catch (Exception e) {
            String errorMsg = "PROFILO_DI_COLLABORAZIONE_ASINCRONO_ASIMMETRICO, Errore durante la asincronoAsimmetrico_getDatiConsegnaRisposta " + riferimentoMessaggio + ": " + e.getMessage();
            this.log.error((Object)errorMsg, (Throwable)e);
            throw new EGovException(errorMsg, e);
        }
    }

    public Integrazione asincronoAsimmetrico_getDatiConsegnaRicevuta(String riferimentoMessaggio) throws EGovException {
        if (this.state instanceof StatefulMessage) {
            StatefulMessage stateful = (StatefulMessage)this.state;
            try {
                RepositoryEGov repositoryEGov = new RepositoryEGov((IState)stateful, this.log);
                Integrazione integrazione = repositoryEGov.getInfoIntegrazioneFromOutBox(riferimentoMessaggio);
                if (integrazione == null) {
                    throw new Exception("Dati di integrazione non trovati");
                }
                return integrazione;
            }
            catch (Exception e) {
                String errorMsg = "PROFILO_DI_COLLABORAZIONE_ASINCRONO_ASIMMETRICO, Errore durante la asincronoAsimmetrico_getDatiConsegnaRicevuta " + riferimentoMessaggio + ": " + e.getMessage();
                this.log.error((Object)errorMsg, (Throwable)e);
                throw new EGovException(errorMsg, e);
            }
        }
        throw new EGovException("Metodo invocato con IState non valido");
    }

    public void asincronoAsimmetrico_registraRichiestaRicevuta(String idEGov, String idCollaborazione, String tipoServizioCorrelato, String servizioCorrelato, boolean ricevutaApplicativa, long scadenzaMessaggi) throws EGovException {
        StateMessage state = (StateMessage)this.state;
        Connection connectionDB = state.getConnectionDB();
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Statement pstmtUpdate = null;
        try {
            Timestamp oraRicezione = DateManager.getTimestamp();
            StringBuffer querySearch = new StringBuffer();
            querySearch.append("SELECT ID_EGOV FROM ");
            querySearch.append("ASINCRONO");
            querySearch.append(" WHERE ID_EGOV=? AND TIPO=?");
            pstmt = connectionDB.prepareStatement(querySearch.toString());
            pstmt.setString(1, idEGov);
            pstmt.setString(2, "INBOX");
            rs = pstmt.executeQuery();
            boolean exists = rs.next();
            rs.close();
            pstmt.close();
            StringBuffer query = new StringBuffer();
            if (exists) {
                query.append("UPDATE ");
                query.append("ASINCRONO");
                query.append(" SET ID_EGOV=?,TIPO=?,ORA_REGISTRAZIONE=?,RICEVUTA_ASINCRONA=?,TIPO_SERVIZIO_CORRELATO=?,SERVIZIO_CORRELATO=?,IS_RICHIESTA=?,ID_ASINCRONO=?,ID_COLLABORAZIONE=?,RICEVUTA_APPLICATIVA=? WHERE ID_EGOV=? AND TIPO=?");
            } else {
                query.append("INSERT INTO  ");
                query.append("ASINCRONO");
                query.append(" (ID_EGOV,TIPO,ORA_REGISTRAZIONE,RICEVUTA_ASINCRONA,TIPO_SERVIZIO_CORRELATO,SERVIZIO_CORRELATO");
                query.append(",IS_RICHIESTA,ID_ASINCRONO,ID_COLLABORAZIONE,RICEVUTA_APPLICATIVA) ");
                query.append(" VALUES ( ? , ? , ? , ? , ? , ? , ? , ? , ? , ? )");
            }
            pstmt = connectionDB.prepareStatement(query.toString());
            pstmt.setString(1, idEGov);
            pstmt.setString(2, "INBOX");
            pstmt.setTimestamp(3, oraRicezione);
            pstmt.setInt(4, 1);
            pstmt.setString(5, tipoServizioCorrelato);
            pstmt.setString(6, servizioCorrelato);
            pstmt.setInt(7, 0);
            pstmt.setString(8, idEGov);
            pstmt.setString(9, idCollaborazione);
            if (ricevutaApplicativa) {
                pstmt.setInt(10, 1);
            } else {
                pstmt.setInt(10, 0);
            }
            if (exists) {
                pstmt.setString(11, idEGov);
                pstmt.setString(12, "INBOX");
            }
            if (exists) {
                state.getPreparedStatement().put("UPDATE save_RichiestaAsincronaAsimmetricaRicevuta" + idEGov, pstmt);
            } else {
                state.getPreparedStatement().put("INSERT save_RichiestaAsincronaAsimmetricaRicevuta" + idEGov, pstmt);
            }
            if (this.state instanceof StatefulMessage) {
                this.registraBustaRicevuta(idEGov);
            } else {
                StatelessMessage statelessMessage = (StatelessMessage)this.state;
                long scadenza = scadenzaMessaggi;
                if (scadenza <= 0L) {
                    scadenza = Configurazione.getScadenzaBusteDefault();
                }
                RepositoryEGov repository = new RepositoryEGov(this.state, this.log, true);
                String key = "INSERT RegistrazioneBustaForHistoryINBOX_" + statelessMessage.getBusta().getID();
                if (repository.isRegistrataIntoInBox(statelessMessage.getBusta().getID())) {
                    repository.aggiornaBustaIntoInBox(statelessMessage.getBusta(), scadenza);
                } else if (state.getPreparedStatement().containsKey(key)) {
                    repository.aggiornaBustaIntoInBox(statelessMessage.getBusta(), scadenza);
                } else {
                    repository.registraBustaIntoInBox(statelessMessage.getBusta(), scadenza);
                }
                this.registraBustaInviata(idEGov);
                StringBuffer queryUpdate = new StringBuffer();
                queryUpdate.append("UPDATE ");
                queryUpdate.append("REPOSITORY_EGOV");
                queryUpdate.append(" SET ");
                queryUpdate.append(this.gestoreRepositoryEGov.createSQLSet_ProfiloCollaborazione(true));
                queryUpdate.append(" WHERE  ID_EGOV = ? AND TIPO=?");
                pstmtUpdate = connectionDB.prepareStatement(queryUpdate.toString());
                pstmtUpdate.setString(1, idEGov);
                pstmtUpdate.setString(2, "INBOX");
                state.getPreparedStatement().put("UPDATE saveBustaForProfiloINBOX_" + idEGov, (PreparedStatement)pstmtUpdate);
            }
        }
        catch (Exception e) {
            String errorMsg = "PROFILO_DI_COLLABORAZIONE_ASINCRONO_ASIMMETRICO, Errore di registrazione richiesta ricevuta " + idEGov + ": " + e.getMessage();
            this.log.error((Object)errorMsg, (Throwable)e);
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            try {
                if (pstmtUpdate != null) {
                    pstmtUpdate.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            throw new EGovException(errorMsg, e);
        }
    }

    public Busta asincronoAsimmetrico_getBustaRisposta(String spcoopID, String idEGovRisposta, long scadenzaMessaggi) throws EGovException {
        StateMessage state = (StateMessage)this.state;
        Connection connectionDB = state.getConnectionDB();
        Busta busta_eGov = null;
        try {
            RepositoryEGov repository = new RepositoryEGov((IState)state, this.log);
            LetturaParametriBusta parametri = new LetturaParametriBusta();
            parametri.setMittente(true);
            parametri.setDestinatario(true);
            parametri.setServizioCorrelato(true);
            busta_eGov = repository.getSomeValuesFromOutBox(spcoopID, parametri, true);
        }
        catch (Exception e) {
            String errorMsg = "PROFILO_DI_COLLABORAZIONE_ASINCRONO_ASIMMETRICO, Errore durante la getBusta dal repository " + spcoopID + ": " + e.getMessage();
            this.log.error((Object)errorMsg, (Throwable)e);
            throw new EGovException(errorMsg, e);
        }
        busta_eGov.setProfiloDiCollaborazione("EGOV_IT_ServizioAsincronoAsimmetrico");
        PreparedStatement pstmtCheck = null;
        ResultSet rsCheck = null;
        String oldIDRisposta = null;
        String oldTipoRisposta = null;
        try {
            StringBuffer query = new StringBuffer();
            query.append("SELECT ID_EGOV,TIPO FROM ");
            query.append("ASINCRONO");
            query.append(" WHERE BACKUP_ID_RICHIESTA=?");
            pstmtCheck = connectionDB.prepareStatement(query.toString());
            pstmtCheck.setString(1, spcoopID);
            rsCheck = pstmtCheck.executeQuery();
            if (rsCheck == null) {
                throw new EGovException("RS Check Null?");
            }
            if (rsCheck.next()) {
                oldIDRisposta = rsCheck.getString("ID_EGOV");
                oldTipoRisposta = rsCheck.getString("TIPO");
            }
            rsCheck.close();
            pstmtCheck.close();
        }
        catch (Exception e) {
            String errorMsg = "PROFILO_DI_COLLABORAZIONE_ASINCRONO_ASIMMETRICO, asincronoAsimmetrico_getBustaRisposta " + spcoopID + ": " + e.getMessage();
            this.log.error((Object)errorMsg, (Throwable)e);
            try {
                if (rsCheck != null) {
                    rsCheck.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            try {
                if (pstmtCheck != null) {
                    pstmtCheck.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            throw new EGovException(errorMsg, e);
        }
        String tipoServizioCorrelato = null;
        String servizioCorrelato = null;
        PreparedStatement pstmtRead = null;
        ResultSet rsRead = null;
        try {
            StringBuffer query = new StringBuffer();
            query.append("SELECT TIPO_SERVIZIO_CORRELATO,SERVIZIO_CORRELATO FROM ");
            query.append("ASINCRONO");
            query.append(" WHERE ID_EGOV=? AND TIPO=?");
            pstmtRead = connectionDB.prepareStatement(query.toString());
            if (oldIDRisposta != null && oldTipoRisposta != null) {
                pstmtRead.setString(1, oldIDRisposta);
                pstmtRead.setString(2, oldTipoRisposta);
            } else {
                pstmtRead.setString(1, spcoopID);
                pstmtRead.setString(2, "OUTBOX");
            }
            rsRead = pstmtRead.executeQuery();
            if (rsRead == null) {
                throw new EGovException("RS Read Null?");
            }
            if (rsRead.next()) {
                tipoServizioCorrelato = rsRead.getString("TIPO_SERVIZIO_CORRELATO");
                servizioCorrelato = rsRead.getString("SERVIZIO_CORRELATO");
            }
            rsRead.close();
            pstmtRead.close();
        }
        catch (Exception e) {
            String errorMsg = "PROFILO_DI_COLLABORAZIONE_ASINCRONO_ASIMMETRICO, asincronoAsimmetrico_getBustaRisposta, raccolta servizio correlato, " + spcoopID + ": " + e.getMessage();
            this.log.error((Object)errorMsg, (Throwable)e);
            try {
                if (rsRead != null) {
                    rsRead.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            try {
                if (pstmtRead != null) {
                    pstmtRead.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            throw new EGovException(errorMsg, e);
        }
        busta_eGov.setTipoServizioCorrelato(tipoServizioCorrelato);
        busta_eGov.setServizioCorrelato(servizioCorrelato);
        PreparedStatement pstmt = null;
        try {
            Timestamp oraInvioRisposta = DateManager.getTimestamp();
            StringBuffer query = new StringBuffer();
            query.append("UPDATE ");
            query.append("ASINCRONO");
            query.append(" SET IS_RICHIESTA=0, RICEVUTA_ASINCRONA=0, ORA_REGISTRAZIONE=?, ID_EGOV=?, TIPO=?, BACKUP_ID_RICHIESTA=?, RICEVUTA_APPLICATIVA=1 WHERE  ID_EGOV = ? AND TIPO=?");
            pstmt = connectionDB.prepareStatement(query.toString());
            pstmt.setTimestamp(1, oraInvioRisposta);
            pstmt.setString(2, idEGovRisposta);
            pstmt.setString(3, "OUTBOX");
            pstmt.setString(4, spcoopID);
            if (oldIDRisposta != null && oldTipoRisposta != null) {
                pstmt.setString(5, oldIDRisposta);
                pstmt.setString(6, oldTipoRisposta);
            } else {
                pstmt.setString(5, spcoopID);
                pstmt.setString(6, "OUTBOX");
            }
            state.getPreparedStatement().put("UPDATE save_RispostaAsincronaAsimmetricaInviata" + spcoopID, pstmt);
        }
        catch (Exception e) {
            String errorMsg = "PROFILO_DI_COLLABORAZIONE_ASINCRONO_ASIMMETRICO, Errore di registrazione risposta inviata " + spcoopID + ": " + e.getMessage();
            this.log.error((Object)errorMsg, (Throwable)e);
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            throw new EGovException(errorMsg, e);
        }
        History history = new History(state, this.log);
        history.registraBustaInviata(spcoopID);
        if (this.state instanceof StatefulMessage) {
            this.registraBustaInviata(idEGovRisposta);
        } else {
            StatelessMessage statelessMessage = (StatelessMessage)this.state;
            long scadenza = scadenzaMessaggi;
            if (scadenza <= 0L) {
                scadenza = Configurazione.getScadenzaBusteDefault();
            }
            RepositoryEGov repository = new RepositoryEGov(this.state, this.log, true);
            repository.registraBustaIntoOutBox(statelessMessage.getBusta(), scadenza);
            this.registraBustaInviata(idEGovRisposta);
            Statement pstmtUpdate = null;
            try {
                StringBuffer queryUpdate = new StringBuffer();
                queryUpdate.append("UPDATE ");
                queryUpdate.append("REPOSITORY_EGOV");
                queryUpdate.append(" SET ");
                queryUpdate.append(this.gestoreRepositoryEGov.createSQLSet_ProfiloCollaborazione(true));
                queryUpdate.append(" WHERE  ID_EGOV = ? AND TIPO=?");
                pstmtUpdate = connectionDB.prepareStatement(queryUpdate.toString());
                pstmtUpdate.setString(1, idEGovRisposta);
                pstmtUpdate.setString(2, "OUTBOX");
                state.getPreparedStatement().put("UPDATE saveBustaForProfiloOUTBOX_" + idEGovRisposta, (PreparedStatement)pstmtUpdate);
            }
            catch (Exception e) {
                String errorMsg = "PROFILO_DI_COLLABORAZIONE_ASINCRONO_ASIMMETRICO, Errore di aggiornamento busta di risposta " + idEGovRisposta + ": " + e.getMessage();
                this.log.error((Object)errorMsg, (Throwable)e);
                try {
                    if (pstmtUpdate != null) {
                        pstmtUpdate.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                throw new EGovException(errorMsg, e);
            }
        }
        history.registraBustaInviata(idEGovRisposta);
        if (oldIDRisposta != null && oldTipoRisposta != null) {
            this.eliminaBusta(oldIDRisposta, oldTipoRisposta, true);
            history.eliminaBusta(oldIDRisposta, oldTipoRisposta, true);
        }
        return busta_eGov;
    }

    public Busta asincronoAsimmetrico_getBustaRicevuta(String idEGov, String rifMsgRicevuta, boolean isRichiesta, boolean generazioneAttributiAsincroni, String tipoTempo) throws EGovException {
        StateMessage state = (StateMessage)this.state;
        Connection connectionDB = state.getConnectionDB();
        String tipoServizioCorrelato = null;
        String servizioCorrelato = null;
        PreparedStatement pstmtRead = null;
        ResultSet rsRead = null;
        try {
            StringBuffer query = new StringBuffer();
            query.append("SELECT TIPO_SERVIZIO_CORRELATO,SERVIZIO_CORRELATO FROM ");
            query.append("ASINCRONO");
            query.append(" WHERE ID_EGOV=? AND TIPO=?");
            pstmtRead = connectionDB.prepareStatement(query.toString());
            pstmtRead.setString(1, idEGov);
            pstmtRead.setString(2, "INBOX");
            rsRead = pstmtRead.executeQuery();
            if (rsRead == null) {
                throw new EGovException("RS Read Null?");
            }
            if (rsRead.next()) {
                tipoServizioCorrelato = rsRead.getString("TIPO_SERVIZIO_CORRELATO");
                servizioCorrelato = rsRead.getString("SERVIZIO_CORRELATO");
            }
            rsRead.close();
            pstmtRead.close();
        }
        catch (Exception e) {
            String errorMsg = "PROFILO_DI_COLLABORAZIONE_ASINCRONO_ASIMMETRICO, asincronoAsimmetrico_getBustaRicevuta, raccolta servizio correlato, " + idEGov + ": " + e.getMessage();
            this.log.error((Object)errorMsg, (Throwable)e);
            try {
                if (rsRead != null) {
                    rsRead.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            try {
                if (pstmtRead != null) {
                    pstmtRead.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            throw new EGovException(errorMsg, e);
        }
        Busta busta_eGov = null;
        try {
            RepositoryEGov repository = new RepositoryEGov((IState)state, this.log);
            LetturaParametriBusta parametri = new LetturaParametriBusta();
            parametri.setMittente(true);
            parametri.setDestinatario(true);
            parametri.setServizio(true);
            parametri.setAzione(true);
            parametri.setCollaborazione(true);
            parametri.setProfiloTrasmissione(true);
            busta_eGov = repository.getSomeValuesFromInBox(idEGov, parametri, true);
            if (!isRichiesta) {
                this.eliminaBustaRicevuta(idEGov, true);
            }
            busta_eGov.setProfiloDiCollaborazione("EGOV_IT_ServizioAsincronoAsimmetrico");
            String mitt = busta_eGov.getMittente();
            String tipoMitt = busta_eGov.getTipoMittente();
            String indTelMitt = busta_eGov.getIndirizzoTelematicoMittente();
            busta_eGov.setMittente(busta_eGov.getDestinatario());
            busta_eGov.setTipoMittente(busta_eGov.getTipoDestinatario());
            busta_eGov.setIndirizzoTelematicoMittente(busta_eGov.getIndirizzoTelematicoDestinatario());
            busta_eGov.setDestinatario(mitt);
            busta_eGov.setTipoDestinatario(tipoMitt);
            busta_eGov.setIndirizzoTelematicoDestinatario(indTelMitt);
            if (isRichiesta) {
                if (generazioneAttributiAsincroni) {
                    busta_eGov.setTipoServizioCorrelato(tipoServizioCorrelato);
                    busta_eGov.setServizioCorrelato(servizioCorrelato);
                }
            } else {
                busta_eGov.setTipoServizio(tipoServizioCorrelato);
                busta_eGov.setServizio(servizioCorrelato);
            }
            busta_eGov.setRiferimentoMessaggio(rifMsgRicevuta);
            busta_eGov.setOraRegistrazione(DateManager.getDate());
            busta_eGov.setTipoOraRegistrazione(tipoTempo);
        }
        catch (Exception e) {
            String errorMsg = "PROFILO_DI_COLLABORAZIONE_ASINCRONO_ASIMMETRICO, Errore durante la asincronoAsimmetrico_getBustaRicevuta dal repository " + idEGov + ": " + e.getMessage();
            this.log.error((Object)errorMsg, (Throwable)e);
            throw new EGovException(errorMsg, e);
        }
        return busta_eGov;
    }

    public Eccezione asincronoAsimmetrico_validazioneCorrelazione_ricevutaRichiesta(Busta bustaDaValidare) throws EGovException {
        return this.asincronoAsimmetrico_validazioneCorrelazione(bustaDaValidare, true, false, false);
    }

    public Eccezione asincronoAsimmetrico_validazioneCorrelazione_richiestaStato(Busta bustaDaValidare) throws EGovException {
        return this.asincronoAsimmetrico_validazioneCorrelazione(bustaDaValidare, false, true, false);
    }

    public Eccezione asincronoAsimmetrico_validazioneCorrelazione_ricevutaRichiestaStato(Busta bustaDaValidare) throws EGovException {
        return this.asincronoAsimmetrico_validazioneCorrelazione(bustaDaValidare, false, false, true);
    }

    private Eccezione asincronoAsimmetrico_validazioneCorrelazione(Busta bustaDaValidare, boolean isRicevutaRichiesta, boolean isRichiestaStato, boolean isRicevutaRichiestaStato) throws EGovException {
        Eccezione eccValidazione;
        StateMessage state = (StateMessage)this.state;
        Connection connectionDB = state.getConnectionDB();
        Busta bustaRichiesta = null;
        try {
            RepositoryEGov repository = new RepositoryEGov((IState)state, this.log);
            LetturaParametriBusta parametri = new LetturaParametriBusta();
            parametri.setMittente(true);
            parametri.setDestinatario(true);
            parametri.setServizio(true);
            parametri.setAzione(true);
            bustaRichiesta = isRichiestaStato ? (bustaDaValidare.getRiferimentoMessaggio() == null ? repository.getSomeValuesFromInBox(bustaDaValidare.getCollaborazione(), parametri, true) : repository.getSomeValuesFromInBox(bustaDaValidare.getRiferimentoMessaggio(), parametri, true)) : repository.getSomeValuesFromOutBox(bustaDaValidare.getRiferimentoMessaggio(), parametri, true);
        }
        catch (Exception e) {
            String errorMsg = "PROFILO_DI_COLLABORAZIONE_ASINCRONO_ASIMMETRICO, Errore durante la validazioneCorrelazione, get dal repository RifMsg(" + bustaDaValidare.getRiferimentoMessaggio() + ") Collab(" + bustaDaValidare.getCollaborazione() + "): " + e.getMessage();
            this.log.error((Object)errorMsg, (Throwable)e);
            throw new EGovException(errorMsg, e);
        }
        if (isRicevutaRichiesta) {
            if (bustaDaValidare.getServizio() != null && bustaDaValidare.getTipoServizio() != null) {
                if (!bustaRichiesta.getTipoServizio().equals(bustaDaValidare.getTipoServizio())) {
                    eccValidazione = new Eccezione();
                    eccValidazione.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                    eccValidazione.setCodiceEccezione("EGOV_IT_105");
                    eccValidazione.setRilevanza("GRAVE");
                    eccValidazione.setPosizione("Tipo di servizio diverso da quello atteso nella gestione del profilo di collaborazione Asincrono Asimmetrico");
                    return eccValidazione;
                }
                if (!bustaRichiesta.getServizio().equals(bustaDaValidare.getServizio())) {
                    eccValidazione = new Eccezione();
                    eccValidazione.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                    eccValidazione.setCodiceEccezione("EGOV_IT_105");
                    eccValidazione.setRilevanza("GRAVE");
                    eccValidazione.setPosizione("Servizio diverso da quello atteso nella gestione del profilo di collaborazione Asincrono Asimmetrico");
                    return eccValidazione;
                }
            }
        } else if (isRichiestaStato || isRicevutaRichiestaStato && bustaDaValidare.getServizio() != null && bustaDaValidare.getTipoServizio() != null) {
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                StringBuffer query = new StringBuffer();
                query.append("SELECT TIPO_SERVIZIO_CORRELATO,SERVIZIO_CORRELATO FROM ");
                query.append("ASINCRONO");
                query.append(" WHERE ID_EGOV=? AND TIPO=?");
                pstmt = connectionDB.prepareStatement(query.toString());
                if (isRichiestaStato && bustaDaValidare.getRiferimentoMessaggio() == null) {
                    pstmt.setString(1, bustaDaValidare.getCollaborazione());
                } else {
                    pstmt.setString(1, bustaDaValidare.getRiferimentoMessaggio());
                }
                if (isRichiestaStato) {
                    pstmt.setString(2, "INBOX");
                } else {
                    pstmt.setString(2, "OUTBOX");
                }
                rs = pstmt.executeQuery();
                if (rs == null) {
                    throw new EGovException("RS Null?");
                }
                String tipoServizioCorrelatoRegistrato = null;
                String servizioCorrelatoRegistrato = null;
                if (rs.next()) {
                    tipoServizioCorrelatoRegistrato = rs.getString("TIPO_SERVIZIO_CORRELATO");
                    servizioCorrelatoRegistrato = rs.getString("SERVIZIO_CORRELATO");
                }
                rs.close();
                pstmt.close();
                if (!bustaDaValidare.getTipoServizio().equals(tipoServizioCorrelatoRegistrato)) {
                    Eccezione eccValidazione2 = new Eccezione();
                    eccValidazione2.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                    eccValidazione2.setCodiceEccezione("EGOV_IT_105");
                    eccValidazione2.setRilevanza("GRAVE");
                    eccValidazione2.setPosizione("Tipo del Servizio diverso da quello atteso con il profilo di collaborazione Asincrono Asimmetrico");
                    return eccValidazione2;
                }
                if (!bustaDaValidare.getServizio().equals(servizioCorrelatoRegistrato)) {
                    Eccezione eccValidazione3 = new Eccezione();
                    eccValidazione3.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                    eccValidazione3.setCodiceEccezione("EGOV_IT_105");
                    eccValidazione3.setRilevanza("GRAVE");
                    eccValidazione3.setPosizione("Servizio diverso da quello atteso con il profilo di collaborazione Asincrono Asimmetrico");
                    return eccValidazione3;
                }
            }
            catch (Exception e) {
                String errorMsg = "PROFILO_DI_COLLABORAZIONE_ASINCRONO_ASIMMETRICO, validazioneCorrelazione RifMsg(" + bustaDaValidare.getRiferimentoMessaggio() + ") Collab(" + bustaDaValidare.getCollaborazione() + "): " + e.getMessage();
                this.log.error((Object)errorMsg, (Throwable)e);
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                throw new EGovException(errorMsg, e);
            }
        }
        if (bustaDaValidare.getAzione() != null && !isRichiestaStato && !bustaDaValidare.getAzione().equals(bustaRichiesta.getAzione())) {
            eccValidazione = new Eccezione();
            eccValidazione.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
            eccValidazione.setCodiceEccezione("EGOV_IT_106");
            eccValidazione.setRilevanza("GRAVE");
            eccValidazione.setPosizione("Azione diversa da quella attesa con il profilo di collaborazione Asincrono Asimmetrico");
            return eccValidazione;
        }
        if (isRichiestaStato) {
            if (!bustaRichiesta.getTipoMittente().equals(bustaDaValidare.getTipoMittente())) {
                eccValidazione = new Eccezione();
                eccValidazione.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                eccValidazione.setCodiceEccezione("EGOV_IT_101");
                eccValidazione.setRilevanza("GRAVE");
                eccValidazione.setPosizione("Tipo del mittente diverso da quello atteso con il profilo di collaborazione Asincrono Asimmetrico");
                return eccValidazione;
            }
            if (!bustaRichiesta.getMittente().equals(bustaDaValidare.getMittente())) {
                eccValidazione = new Eccezione();
                eccValidazione.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                eccValidazione.setCodiceEccezione("EGOV_IT_101");
                eccValidazione.setRilevanza("GRAVE");
                eccValidazione.setPosizione("Mittente diverso da quello atteso con il profilo di collaborazione Asincrono Asimmetrico");
                return eccValidazione;
            }
            if (!bustaRichiesta.getTipoDestinatario().equals(bustaDaValidare.getTipoDestinatario())) {
                eccValidazione = new Eccezione();
                eccValidazione.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                eccValidazione.setCodiceEccezione("EGOV_IT_102");
                eccValidazione.setRilevanza("GRAVE");
                eccValidazione.setPosizione("Tipo del destinatario diverso da quello atteso con il profilo di collaborazione Asincrono Asimmetrico");
                return eccValidazione;
            }
            if (!bustaRichiesta.getDestinatario().equals(bustaDaValidare.getDestinatario())) {
                eccValidazione = new Eccezione();
                eccValidazione.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                eccValidazione.setCodiceEccezione("EGOV_IT_102");
                eccValidazione.setRilevanza("GRAVE");
                eccValidazione.setPosizione("Destinatario diverso da quello atteso con il profilo di collaborazione Asincrono Asimmetrico");
                return eccValidazione;
            }
        } else {
            if (!bustaRichiesta.getTipoDestinatario().equals(bustaDaValidare.getTipoMittente())) {
                eccValidazione = new Eccezione();
                eccValidazione.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                eccValidazione.setCodiceEccezione("EGOV_IT_101");
                eccValidazione.setRilevanza("GRAVE");
                eccValidazione.setPosizione("Tipo del mittente diverso da quello atteso con il profilo di collaborazione Asincrono Asimmetrico");
                return eccValidazione;
            }
            if (!bustaRichiesta.getDestinatario().equals(bustaDaValidare.getMittente())) {
                eccValidazione = new Eccezione();
                eccValidazione.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                eccValidazione.setCodiceEccezione("EGOV_IT_101");
                eccValidazione.setRilevanza("GRAVE");
                eccValidazione.setPosizione("Mittente diverso da quello atteso con il profilo di collaborazione Asincrono Asimmetrico");
                return eccValidazione;
            }
            if (!bustaRichiesta.getTipoMittente().equals(bustaDaValidare.getTipoDestinatario())) {
                eccValidazione = new Eccezione();
                eccValidazione.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                eccValidazione.setCodiceEccezione("EGOV_IT_102");
                eccValidazione.setRilevanza("GRAVE");
                eccValidazione.setPosizione("Tipo del destinatario diverso da quello atteso con il profilo di collaborazione Asincrono Asimmetrico");
                return eccValidazione;
            }
            if (!bustaRichiesta.getMittente().equals(bustaDaValidare.getDestinatario())) {
                eccValidazione = new Eccezione();
                eccValidazione.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                eccValidazione.setCodiceEccezione("EGOV_IT_102");
                eccValidazione.setRilevanza("GRAVE");
                eccValidazione.setPosizione("Destinatario diverso da quello atteso con il profilo di collaborazione Asincrono Asimmetrico");
                return eccValidazione;
            }
        }
        return null;
    }

    public boolean asincronoAsimmetrico_validazioneRiferimentoMessaggio_richiestaStato(String riferimentoMessaggio) throws EGovException {
        return this.asincronoAsimmetrico_validazioneRiferimentoMessaggio(riferimentoMessaggio, true);
    }

    public boolean asincronoAsimmetrico_validazioneRiferimentoMessaggio_ricevuta(String riferimentoMessaggio) throws EGovException {
        return this.asincronoAsimmetrico_validazioneRiferimentoMessaggio(riferimentoMessaggio, false);
    }

    private boolean asincronoAsimmetrico_validazioneRiferimentoMessaggio(String riferimentoMessaggio, boolean isRichiestaStato) throws EGovException {
        StateMessage state = (StateMessage)this.state;
        Connection connectionDB = state.getConnectionDB();
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            StringBuffer query = new StringBuffer();
            query.append("SELECT ID_EGOV FROM ");
            query.append("ASINCRONO");
            query.append(" WHERE ID_EGOV=? AND TIPO=?");
            pstmt = connectionDB.prepareStatement(query.toString());
            pstmt.setString(1, riferimentoMessaggio);
            if (isRichiestaStato) {
                pstmt.setString(2, "INBOX");
            } else {
                pstmt.setString(2, "OUTBOX");
            }
            rs = pstmt.executeQuery();
            if (rs == null) {
                throw new EGovException("RS Null?");
            }
            boolean value = rs.next();
            rs.close();
            pstmt.close();
            RepositoryEGov repositoryEGov = new RepositoryEGov((IState)state, this.log);
            if (isRichiestaStato) {
                return value && repositoryEGov.isRegistrataIntoInBox(riferimentoMessaggio);
            }
            return value && repositoryEGov.isRegistrataIntoOutBox(riferimentoMessaggio);
        }
        catch (Exception e) {
            String errorMsg = "PROFILO_DI_COLLABORAZIONE_ASINCRONO_ASIMMETRICO, validazioneRiferimentoMessaggio " + riferimentoMessaggio + ": " + e.getMessage();
            this.log.error((Object)errorMsg, (Throwable)e);
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            throw new EGovException(errorMsg, e);
        }
    }

    public boolean asincronoAsimmetrico_validazioneCollaborazione_richiestaStato(String riferimentoMessaggio, String idCollaborazione) throws EGovException {
        return this.asincronoAsimmetrico_validazioneCollaborazione(riferimentoMessaggio, idCollaborazione, true);
    }

    public boolean asincronoAsimmetrico_validazioneCollaborazione_ricevuta(String riferimentoMessaggio, String idCollaborazione) throws EGovException {
        return this.asincronoAsimmetrico_validazioneCollaborazione(riferimentoMessaggio, idCollaborazione, false);
    }

    private boolean asincronoAsimmetrico_validazioneCollaborazione(String riferimentoMessaggio, String idCollaborazione, boolean isRichiestaStato) throws EGovException {
        StateMessage state = (StateMessage)this.state;
        Connection connectionDB = state.getConnectionDB();
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            StringBuffer query = new StringBuffer();
            query.append("SELECT ID_COLLABORAZIONE FROM ");
            query.append("ASINCRONO");
            query.append(" WHERE ID_EGOV=? AND TIPO=?");
            pstmt = connectionDB.prepareStatement(query.toString());
            if (isRichiestaStato && riferimentoMessaggio == null) {
                pstmt.setString(1, idCollaborazione);
            } else {
                pstmt.setString(1, riferimentoMessaggio);
            }
            if (isRichiestaStato) {
                pstmt.setString(2, "INBOX");
            } else {
                pstmt.setString(2, "OUTBOX");
            }
            rs = pstmt.executeQuery();
            if (rs == null) {
                throw new EGovException("RS Null?");
            }
            String value = null;
            if (rs.next()) {
                value = rs.getString("ID_COLLABORAZIONE");
            }
            rs.close();
            pstmt.close();
            return idCollaborazione.equals(value);
        }
        catch (Exception e) {
            String errorMsg = "PROFILO_DI_COLLABORAZIONE_ASINCRONO_ASIMMETRICO, validazioneCollaborazione " + riferimentoMessaggio + ": " + e.getMessage();
            this.log.error((Object)errorMsg, (Throwable)e);
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            throw new EGovException(errorMsg, e);
        }
    }

    @Deprecated
    public Vector<Busta> asincrono_getBusteAsincronePerUlterioreInoltro_serializable(long timeout) throws EGovException {
        return this.asincrono_getBusteAsincronePerUlterioreInoltro_serializable(timeout, Configurazione.getAttesaAttiva(), Configurazione.getCheckInterval());
    }

    @Deprecated
    public Vector<Busta> asincrono_getBusteAsincronePerUlterioreInoltro_serializable(long timeout, long attesaAttiva, int checkInterval) throws EGovException {
        if (this.state instanceof StatefulMessage) {
            StatefulMessage stateful = (StatefulMessage)this.state;
            Connection connectionDB = stateful.getConnectionDB();
            int oldTransactionIsolation = -1;
            try {
                oldTransactionIsolation = connectionDB.getTransactionIsolation();
                connectionDB.setAutoCommit(false);
                connectionDB.setTransactionIsolation(8);
            }
            catch (Exception er) {
                String errorMsg = "PROFILO_DI_COLLABORAZIONE_ASINCRONO, Errore durante la getBusteAsincronePerUlterioreInoltro(setIsolation): " + er.getMessage();
                this.log.error((Object)errorMsg, (Throwable)er);
                throw new EGovException(errorMsg, er);
            }
            boolean getBusteOK = false;
            Vector<Busta> busteNonRingraziate = new Vector<Busta>();
            long scadenzaWhile = DateManager.getTimeMillis() + attesaAttiva;
            while (!getBusteOK && DateManager.getTimeMillis() < scadenzaWhile) {
                Statement pstmt = null;
                ResultSet rs = null;
                Vector<String> IDBuste = new Vector<String>();
                try {
                    long nowTime = DateManager.getTimeMillis() - timeout * 60L * 1000L;
                    Timestamp scadenzaRingraziamento = new Timestamp(nowTime);
                    StringBuffer query = new StringBuffer();
                    query.append("SELECT ID_EGOV FROM ");
                    query.append("ASINCRONO");
                    query.append(" WHERE ORA_REGISTRAZIONE < ? AND TIPO=? AND RICEVUTA_ASINCRONA=0 AND RICEVUTA_APPLICATIVA=0 FOR UPDATE");
                    pstmt = connectionDB.prepareStatement(query.toString());
                    pstmt.setTimestamp(1, scadenzaRingraziamento);
                    pstmt.setString(2, "OUTBOX");
                    rs = pstmt.executeQuery();
                    if (rs == null) {
                        pstmt.close();
                        return null;
                    }
                    while (rs.next()) {
                        String idEGOV = rs.getString("ID_EGOV");
                        IDBuste.add(idEGOV);
                    }
                    rs.close();
                    pstmt.close();
                    if (IDBuste.size() > 0) {
                        RepositoryEGov repositoryBuste = new RepositoryEGov((IState)stateful, this.log);
                        for (int i = 0; i < IDBuste.size(); ++i) {
                            String idEGov = (String)IDBuste.get(i);
                            try {
                                Busta busta = repositoryBuste.getBustaFromOutBox(idEGov);
                                busteNonRingraziate.add(busta);
                                continue;
                            }
                            catch (Exception e) {
                                String errorMsg = "PROFILO_DI_COLLABORAZIONE_ASINCRONO, Errore durante la getBusteAsincronePerUlterioreInoltro (read busta [" + idEGov + "]): " + e.getMessage();
                                this.log.error((Object)errorMsg);
                            }
                        }
                    }
                    connectionDB.commit();
                    getBusteOK = true;
                }
                catch (Exception e) {
                    try {
                        if (pstmt != null) {
                            pstmt.close();
                        }
                    }
                    catch (Exception er) {
                        // empty catch block
                    }
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                    }
                    catch (Exception er) {
                        // empty catch block
                    }
                    try {
                        connectionDB.rollback();
                    }
                    catch (Exception er) {
                        // empty catch block
                    }
                }
                if (getBusteOK) continue;
                try {
                    Thread.sleep(new Random().nextInt(checkInterval));
                }
                catch (Exception eRandom) {}
            }
            try {
                connectionDB.setTransactionIsolation(oldTransactionIsolation);
                connectionDB.setAutoCommit(true);
            }
            catch (Exception er) {
                String errorMsg = "PROFILO_DI_COLLABORAZIONE_ASINCRONO, Errore durante la getBusteAsincronePerUlterioreInoltro(ripristinoIsolation): " + er.getMessage();
                this.log.error((Object)errorMsg, (Throwable)er);
                throw new EGovException(errorMsg, er);
            }
            return busteNonRingraziate;
        }
        if (this.state instanceof StatelessMessage) {
            throw new EGovException("Metodo non invocabile in modalita Stateless");
        }
        throw new EGovException("Metodo invocato con IState non valido");
    }

    public Vector<Busta> asincrono_getBusteAsincronePerUlterioreInoltro(long timeout, int limit, int offset, boolean logQuery) throws EGovException {
        if (this.state instanceof StatefulMessage) {
            StatefulMessage stateful = (StatefulMessage)this.state;
            Connection connectionDB = stateful.getConnectionDB();
            Vector<Busta> busteNonRingraziate = new Vector<Busta>();
            Statement pstmt = null;
            ResultSet rs = null;
            Vector<String> IDBuste = new Vector<String>();
            String queryString = null;
            try {
                long nowTime = DateManager.getTimeMillis() - timeout * 60L * 1000L;
                Timestamp scadenzaRingraziamento = new Timestamp(nowTime);
                IGestoreRepositoryEGov gestoreRepositoryEGov = Configurazione.getGestoreRepositoryEGov();
                if (Configurazione.getSqlQueryObjectType() == null) {
                    StringBuffer query = new StringBuffer();
                    query.append("SELECT ID_EGOV FROM ");
                    query.append("ASINCRONO");
                    query.append(" WHERE ORA_REGISTRAZIONE < ? AND TIPO=? AND RICEVUTA_ASINCRONA=0 AND RICEVUTA_APPLICATIVA=0");
                    query.append(" AND NOT EXISTS (SELECT ID_EGOV FROM ");
                    query.append("REPOSITORY_EGOV");
                    query.append(" WHERE ");
                    query.append("REPOSITORY_EGOV");
                    query.append(".TIPO=");
                    query.append("ASINCRONO");
                    query.append(".TIPO");
                    query.append(" AND ");
                    query.append("REPOSITORY_EGOV");
                    query.append(".ID_EGOV=");
                    query.append("ASINCRONO");
                    query.append(".ID_EGOV");
                    query.append(" AND ");
                    query.append(gestoreRepositoryEGov.createSQLCondition_PdD(false));
                    query.append(" AND ");
                    query.append(gestoreRepositoryEGov.createSQLCondition_ProfiloCollaborazione(false));
                    query.append(" ) ");
                    queryString = query.toString();
                } else {
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)Configurazione.getSqlQueryObjectType());
                    sqlQueryObject.addSelectField("ID_EGOV");
                    sqlQueryObject.addSelectField("ORA_REGISTRAZIONE");
                    sqlQueryObject.addSelectField("TIPO");
                    sqlQueryObject.addSelectField("RICEVUTA_ASINCRONA");
                    sqlQueryObject.addSelectField("RICEVUTA_APPLICATIVA");
                    sqlQueryObject.addFromTable("ASINCRONO");
                    sqlQueryObject.addWhereCondition("ORA_REGISTRAZIONE < ?");
                    sqlQueryObject.addWhereCondition("TIPO=?");
                    sqlQueryObject.addWhereCondition("RICEVUTA_ASINCRONA=0");
                    sqlQueryObject.addWhereCondition("RICEVUTA_APPLICATIVA=0");
                    ISQLQueryObject sqlQueryObjectNotExists = SQLObjectFactory.createSQLQueryObject((String)Configurazione.getSqlQueryObjectType());
                    sqlQueryObjectNotExists.addFromTable("REPOSITORY_EGOV");
                    sqlQueryObjectNotExists.addSelectField("REPOSITORY_EGOV", "ID_EGOV");
                    sqlQueryObjectNotExists.addWhereCondition("REPOSITORY_EGOV.TIPO=ASINCRONO.TIPO");
                    sqlQueryObjectNotExists.addWhereCondition("REPOSITORY_EGOV.ID_EGOV=ASINCRONO.ID_EGOV");
                    sqlQueryObjectNotExists.addWhereCondition(gestoreRepositoryEGov.createSQLCondition_PdD(false));
                    sqlQueryObjectNotExists.addWhereCondition(gestoreRepositoryEGov.createSQLCondition_ProfiloCollaborazione(false));
                    sqlQueryObjectNotExists.setANDLogicOperator(true);
                    sqlQueryObject.addWhereExistsCondition(true, sqlQueryObjectNotExists);
                    sqlQueryObject.setANDLogicOperator(true);
                    sqlQueryObject.addOrderBy("ORA_REGISTRAZIONE");
                    sqlQueryObject.setSortType(true);
                    sqlQueryObject.setLimit(limit);
                    sqlQueryObject.setOffset(offset);
                    queryString = sqlQueryObject.createSQLQuery();
                }
                pstmt = connectionDB.prepareStatement(queryString);
                pstmt.setTimestamp(1, scadenzaRingraziamento);
                pstmt.setString(2, "OUTBOX");
                long startDateSQLCommand = DateManager.getTimeMillis();
                if (logQuery) {
                    this.log.debug((Object)("[QUERY] (RicevuteAsincrone) [" + queryString + "] 1[" + scadenzaRingraziamento + "] 2[" + "OUTBOX" + "]..."));
                }
                rs = pstmt.executeQuery();
                long endDateSQLCommand = DateManager.getTimeMillis();
                long secondSQLCommand = (endDateSQLCommand - startDateSQLCommand) / 1000L;
                if (logQuery) {
                    this.log.debug((Object)("[QUERY] (RicevuteAsincrone) [" + queryString + "] 1[" + scadenzaRingraziamento + "] 2[" + "OUTBOX" + "] effettuata in " + secondSQLCommand + " secondi"));
                }
                if (rs == null) {
                    pstmt.close();
                    return null;
                }
                int countLimit = 0;
                int countOffset = 0;
                while (rs.next()) {
                    String idEGOV;
                    if (Configurazione.getSqlQueryObjectType() == null) {
                        if (countOffset >= offset) {
                            idEGOV = rs.getString("ID_EGOV");
                            IDBuste.add(idEGOV);
                            if (++countLimit != limit) continue;
                            break;
                        }
                        ++countOffset;
                        continue;
                    }
                    idEGOV = rs.getString("ID_EGOV");
                    IDBuste.add(idEGOV);
                }
                rs.close();
                pstmt.close();
                if (IDBuste.size() > 0) {
                    RepositoryEGov repositoryBuste = new RepositoryEGov((IState)stateful, this.log);
                    for (int i = 0; i < IDBuste.size(); ++i) {
                        String idEGov = (String)IDBuste.get(i);
                        try {
                            Busta busta = repositoryBuste.getBustaFromOutBox(idEGov);
                            busteNonRingraziate.add(busta);
                            continue;
                        }
                        catch (Exception e) {
                            String errorMsg = "PROFILO_DI_COLLABORAZIONE_ASINCRONO, Errore durante la getBusteAsincronePerUlterioreInoltro (read busta [" + idEGov + "]): " + e.getMessage();
                            this.log.error((Object)errorMsg);
                        }
                    }
                }
            }
            catch (Exception e) {
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                String errorMsg = "[ProfiloDiCollaborazione.asincrono_getBusteAsincronePerUlterioreInoltro] errore, queryString[" + queryString + "]: " + e.getMessage();
                this.log.error((Object)errorMsg, (Throwable)e);
                throw new EGovException(errorMsg, e);
            }
            return busteNonRingraziate;
        }
        if (this.state instanceof StatelessMessage) {
            throw new EGovException("Metodo non invocabile in modalita stateless");
        }
        throw new EGovException("Metodo invocato con IState non valido");
    }

    public boolean asincrono_isRicevutaRichiesta(String riferimentoMessaggio) throws EGovException {
        return this.asincrono_isRicevuta(riferimentoMessaggio, true);
    }

    public boolean asincrono_isRicevutaRisposta(String riferimentoMessaggio) throws EGovException {
        return this.asincrono_isRicevuta(riferimentoMessaggio, false);
    }

    private boolean asincrono_isRicevuta(String riferimentoMessaggio, boolean isRicevutaRichiesta) throws EGovException {
        StateMessage state = (StateMessage)this.state;
        Connection connectionDB = state.getConnectionDB();
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            StringBuffer query = new StringBuffer();
            query.append("SELECT ID_ASINCRONO FROM ");
            query.append("ASINCRONO");
            query.append(" WHERE ID_EGOV=? AND TIPO=? AND RICEVUTA_ASINCRONA=0");
            pstmt = connectionDB.prepareStatement(query.toString());
            pstmt.setString(1, riferimentoMessaggio);
            pstmt.setString(2, "OUTBOX");
            rs = pstmt.executeQuery();
            if (rs == null) {
                throw new EGovException("RS Null?");
            }
            boolean value = false;
            if (rs.next()) {
                value = riferimentoMessaggio.equals(rs.getString("ID_ASINCRONO")) ? isRicevutaRichiesta : !isRicevutaRichiesta;
            }
            rs.close();
            pstmt.close();
            return value;
        }
        catch (Exception e) {
            String errorMsg = "PROFILO_DI_COLLABORAZIONE_ASINCRONO, isRicevutaAsincrono " + riferimentoMessaggio + ": " + e.getMessage();
            this.log.error((Object)errorMsg, (Throwable)e);
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            throw new EGovException(errorMsg, e);
        }
    }

    @Deprecated
    public void asincrono_valdazioneRicevuta_serializable(Busta ricevuta) throws EGovException {
        this.asincrono_validazioneRicevuta_serializable(ricevuta, Configurazione.getAttesaAttiva(), Configurazione.getCheckInterval());
    }

    @Deprecated
    public void asincrono_validazioneRicevuta_serializable(Busta ricevuta, long attesaAttiva, int checkInterval) throws EGovException {
        if (this.state instanceof StatefulMessage) {
            StatefulMessage stateful = (StatefulMessage)this.state;
            Connection connectionDB = stateful.getConnectionDB();
            String idRicevuta = ricevuta.getRiferimentoMessaggio();
            int oldTransactionIsolation = -1;
            try {
                oldTransactionIsolation = connectionDB.getTransactionIsolation();
                connectionDB.setAutoCommit(false);
                connectionDB.setTransactionIsolation(8);
            }
            catch (Exception er) {
                String errorMsg = "PROFILO_DI_COLLABORAZIONE_ASINCRONO, Errore durante la validazioneRicevutaAsincrona " + idRicevuta + "(setIsolation): " + er.getMessage();
                this.log.error((Object)errorMsg, (Throwable)er);
                throw new EGovException(errorMsg, er);
            }
            boolean validazioneRicevutaOK = false;
            long scadenzaWhile = DateManager.getTimeMillis() + attesaAttiva;
            while (!validazioneRicevutaOK && DateManager.getTimeMillis() < scadenzaWhile) {
                Statement pstmtValidazione = null;
                Statement pstmt = null;
                ResultSet rs = null;
                try {
                    StringBuffer query = new StringBuffer();
                    query.append("SELECT IS_RICHIESTA,RICEVUTA_ASINCRONA,ID_ASINCRONO FROM ");
                    query.append("ASINCRONO");
                    query.append(" WHERE ID_EGOV=? AND TIPO=? FOR UPDATE");
                    pstmt = connectionDB.prepareStatement(query.toString());
                    pstmt.setString(1, idRicevuta);
                    pstmt.setString(2, "OUTBOX");
                    rs = pstmt.executeQuery();
                    if (rs == null) {
                        throw new EGovException("RS Null?");
                    }
                    boolean isRichiesta = false;
                    boolean validaRicevuta = false;
                    String idCollaborazione = null;
                    if (!rs.next()) {
                        rs.close();
                        pstmt.close();
                        return;
                    }
                    if (rs.getInt("IS_RICHIESTA") == 1) {
                        isRichiesta = true;
                    }
                    if (rs.getInt("RICEVUTA_ASINCRONA") == 0) {
                        validaRicevuta = true;
                    }
                    idCollaborazione = rs.getString("ID_ASINCRONO");
                    rs.close();
                    pstmt.close();
                    if (!validaRicevuta) {
                        String tipoRicevuta = "ricevuta di una richiesta asincrona";
                        if (!isRichiesta) {
                            tipoRicevuta = "ricevuta di una risposta asincrona";
                        }
                        this.log.warn((Object)("Validazione " + tipoRicevuta + " non effettuata, poiche' inutile: ricevuta precedentemente gia' analizzata."));
                    }
                    if (isRichiesta) {
                        query.delete(0, query.length());
                        query.append("UPDATE ");
                        query.append("ASINCRONO");
                        if (ricevuta.getServizioCorrelato() != null && "EGOV_IT_ServizioAsincronoAsimmetrico".equals(ricevuta.getProfiloDiCollaborazione())) {
                            query.append(" SET RICEVUTA_ASINCRONA=1,IS_RICHIESTA=0,TIPO_SERVIZIO_CORRELATO=?,SERVIZIO_CORRELATO=? WHERE  ID_EGOV = ? AND TIPO=?");
                            pstmtValidazione = connectionDB.prepareStatement(query.toString());
                            pstmtValidazione.setString(1, ricevuta.getTipoServizioCorrelato());
                            pstmtValidazione.setString(2, ricevuta.getServizioCorrelato());
                            pstmtValidazione.setString(3, idRicevuta);
                            pstmtValidazione.setString(4, "OUTBOX");
                        } else {
                            query.append(" SET RICEVUTA_ASINCRONA=1,IS_RICHIESTA=0 WHERE  ID_EGOV = ? AND TIPO=?");
                            pstmtValidazione = connectionDB.prepareStatement(query.toString());
                            pstmtValidazione.setString(1, idRicevuta);
                            pstmtValidazione.setString(2, "OUTBOX");
                        }
                        pstmtValidazione.execute();
                        pstmtValidazione.close();
                    } else {
                        if ("EGOV_IT_ServizioAsincronoSimmetrico".equals(ricevuta.getProfiloDiCollaborazione())) {
                            this.eliminaBustaRicevuta(idCollaborazione);
                        } else {
                            this.eliminaBustaInviata(idCollaborazione);
                        }
                        if ("EGOV_IT_ServizioAsincronoSimmetrico".equals(ricevuta.getProfiloDiCollaborazione())) {
                            query.delete(0, query.capacity());
                            query.append("DELETE FROM ");
                            query.append("ASINCRONO");
                            query.append(" WHERE ID_EGOV=? AND TIPO=?");
                            pstmtValidazione = connectionDB.prepareStatement(query.toString());
                            pstmtValidazione.setString(1, idRicevuta);
                            pstmtValidazione.setString(2, "OUTBOX");
                            pstmtValidazione.execute();
                            pstmtValidazione.close();
                        }
                        this.eliminaBustaInviata(idRicevuta);
                        stateful.executePreparedStatement();
                    }
                    connectionDB.commit();
                    validazioneRicevutaOK = true;
                }
                catch (Exception e) {
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                    }
                    catch (Exception er) {
                        // empty catch block
                    }
                    try {
                        if (pstmt != null) {
                            pstmt.close();
                        }
                    }
                    catch (Exception er) {
                        // empty catch block
                    }
                    try {
                        if (pstmtValidazione != null) {
                            pstmtValidazione.close();
                        }
                    }
                    catch (Exception er) {
                        // empty catch block
                    }
                    try {
                        connectionDB.rollback();
                    }
                    catch (Exception er) {
                        // empty catch block
                    }
                }
                if (validazioneRicevutaOK) continue;
                try {
                    Thread.sleep(new Random().nextInt(checkInterval));
                }
                catch (Exception eRandom) {}
            }
            try {
                connectionDB.setTransactionIsolation(oldTransactionIsolation);
                connectionDB.setAutoCommit(true);
            }
            catch (Exception er) {
                String errorMsg = "PROFILO_DI_COLLABORAZIONE_ASINCRONO, Errore durante la validazioneRicevutaAsincrona " + idRicevuta + "(ripristinoIsolation): " + er.getMessage();
                this.log.error((Object)errorMsg, (Throwable)er);
                throw new EGovException(errorMsg, er);
            }
        }
        throw new EGovException("Metodo invocato con IState non valido");
    }

    public void asincrono_valdazioneRicevuta(Busta ricevuta) throws EGovException {
        StateMessage state = (StateMessage)this.state;
        Connection connectionDB = state.getConnectionDB();
        String idRicevuta = ricevuta.getRiferimentoMessaggio();
        Statement pstmtValidazione = null;
        Statement pstmt = null;
        ResultSet rs = null;
        try {
            StringBuffer query = new StringBuffer();
            query.append("SELECT IS_RICHIESTA,RICEVUTA_ASINCRONA,ID_ASINCRONO FROM ");
            query.append("ASINCRONO");
            query.append(" WHERE ID_EGOV=? AND TIPO=?");
            pstmt = connectionDB.prepareStatement(query.toString());
            pstmt.setString(1, idRicevuta);
            pstmt.setString(2, "OUTBOX");
            rs = pstmt.executeQuery();
            if (rs == null) {
                throw new EGovException("RS Null?");
            }
            boolean isRichiesta = false;
            boolean validaRicevuta = false;
            String idCollaborazione = null;
            if (!rs.next()) {
                rs.close();
                pstmt.close();
                return;
            }
            if (rs.getInt("IS_RICHIESTA") == 1) {
                isRichiesta = true;
            }
            if (rs.getInt("RICEVUTA_ASINCRONA") == 0) {
                validaRicevuta = true;
            }
            idCollaborazione = rs.getString("ID_ASINCRONO");
            rs.close();
            pstmt.close();
            if (!validaRicevuta) {
                String tipoRicevuta = "ricevuta di una richiesta asincrona";
                if (!isRichiesta) {
                    tipoRicevuta = "ricevuta di una risposta asincrona";
                }
                this.log.warn((Object)("Validazione " + tipoRicevuta + " non effettuata, poiche' inutile: ricevuta precedentemente gia' analizzata."));
            }
            if (isRichiesta) {
                query.delete(0, query.length());
                query.append("UPDATE ");
                query.append("ASINCRONO");
                if ("EGOV_IT_ServizioAsincronoAsimmetrico".equals(ricevuta.getProfiloDiCollaborazione())) {
                    String tipoServizioCorrelato = ricevuta.getTipoServizioCorrelato();
                    String servizioCorrelato = ricevuta.getServizioCorrelato();
                    if (servizioCorrelato == null || tipoServizioCorrelato == null) {
                        IDSoggetto fruitore = new IDSoggetto(ricevuta.getTipoDestinatario(), ricevuta.getDestinatario());
                        IDServizio servizio = new IDServizio(ricevuta.getTipoMittente(), ricevuta.getMittente(), ricevuta.getTipoServizio(), ricevuta.getServizio(), ricevuta.getAzione());
                        RisultatoValidazione validazione = RegistroServiziReader.getInstance().validaServizio(fruitore, servizio, null);
                        if (validazione == null || !validazione.getServizioRegistrato()) {
                            throw new Exception("Servizio [" + servizio.toString() + "] non esiste nel registro dei servizi");
                        }
                        if (validazione.getServizioCorrelato() == null || validazione.getTipoServizioCorrelato() == null) {
                            throw new Exception("Servizio [" + servizio.toString() + "] non possiede un servizio correlato associato");
                        }
                        tipoServizioCorrelato = validazione.getTipoServizioCorrelato();
                        servizioCorrelato = validazione.getServizioCorrelato();
                    }
                    query.append(" SET RICEVUTA_ASINCRONA=1,IS_RICHIESTA=0,TIPO_SERVIZIO_CORRELATO=?,SERVIZIO_CORRELATO=? WHERE  ID_EGOV = ? AND TIPO=?");
                    pstmtValidazione = connectionDB.prepareStatement(query.toString());
                    pstmtValidazione.setString(1, tipoServizioCorrelato);
                    pstmtValidazione.setString(2, servizioCorrelato);
                    pstmtValidazione.setString(3, idRicevuta);
                    pstmtValidazione.setString(4, "OUTBOX");
                } else {
                    query.append(" SET RICEVUTA_ASINCRONA=1,IS_RICHIESTA=0 WHERE  ID_EGOV = ? AND TIPO=?");
                    pstmtValidazione = connectionDB.prepareStatement(query.toString());
                    pstmtValidazione.setString(1, idRicevuta);
                    pstmtValidazione.setString(2, "OUTBOX");
                }
                state.getPreparedStatement().put("UPDATE validazioneRicevutaRichiestaAsincrona_" + idRicevuta, (PreparedStatement)pstmtValidazione);
            } else {
                if ("EGOV_IT_ServizioAsincronoSimmetrico".equals(ricevuta.getProfiloDiCollaborazione())) {
                    this.eliminaBustaRicevuta(idCollaborazione, true);
                } else {
                    this.eliminaBustaInviata(idCollaborazione, true);
                }
                if ("EGOV_IT_ServizioAsincronoSimmetrico".equals(ricevuta.getProfiloDiCollaborazione())) {
                    query.delete(0, query.capacity());
                    query.append("DELETE FROM ");
                    query.append("ASINCRONO");
                    query.append(" WHERE ID_EGOV=? AND TIPO=?");
                    pstmtValidazione = connectionDB.prepareStatement(query.toString());
                    pstmtValidazione.setString(1, idRicevuta);
                    pstmtValidazione.setString(2, "OUTBOX");
                    state.getPreparedStatement().put("UPDATE validazioneRicevutaRispostaAsincrona_" + idRicevuta, (PreparedStatement)pstmtValidazione);
                }
                this.eliminaBustaInviata(idRicevuta, true);
            }
        }
        catch (Exception e) {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            try {
                if (pstmtValidazione != null) {
                    pstmtValidazione.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            String errorMsg = "PROFILO_DI_COLLABORAZIONE_ASINCRONO, Errore durante la validazioneRicevutaAsincrona " + idRicevuta + ": " + e.getMessage();
            this.log.error((Object)errorMsg, (Throwable)e);
            throw new EGovException(errorMsg, e);
        }
    }

    public boolean asincrono_isRisposta(Busta busta) throws EGovException {
        StateMessage state = (StateMessage)this.state;
        Connection connectionDB = state.getConnectionDB();
        Statement pstmt = null;
        ResultSet rs = null;
        try {
            if (busta.getRiferimentoMessaggio() == null && busta.getCollaborazione() == null) {
                return false;
            }
            StringBuffer query = new StringBuffer();
            query.append("SELECT * FROM ");
            query.append("ASINCRONO");
            query.append(" WHERE ");
            if (busta.getRiferimentoMessaggio() != null && busta.getCollaborazione() != null) {
                query.append(" (ID_EGOV=? OR ID_EGOV=?) ");
            } else {
                query.append(" ID_EGOV=? ");
            }
            query.append(" AND TIPO=?");
            String tipo = null;
            tipo = "EGOV_IT_ServizioAsincronoSimmetrico".equals(busta.getProfiloDiCollaborazione()) ? "OUTBOX" : "INBOX";
            pstmt = connectionDB.prepareStatement(query.toString());
            if (busta.getRiferimentoMessaggio() != null && busta.getCollaborazione() != null) {
                pstmt.setString(1, busta.getRiferimentoMessaggio());
                pstmt.setString(2, busta.getCollaborazione());
                pstmt.setString(3, tipo);
            } else if (busta.getRiferimentoMessaggio() != null) {
                pstmt.setString(1, busta.getRiferimentoMessaggio());
                pstmt.setString(2, tipo);
            } else {
                pstmt.setString(1, busta.getCollaborazione());
                pstmt.setString(2, tipo);
            }
            rs = pstmt.executeQuery();
            if (rs == null) {
                throw new EGovException("RS Null?");
            }
            boolean value = false;
            if (rs.next() && rs.getInt("IS_RICHIESTA") == 0 && rs.getInt("RICEVUTA_ASINCRONA") == 1 && rs.getString("TIPO_SERVIZIO_CORRELATO") != null && rs.getString("TIPO_SERVIZIO_CORRELATO").equals(busta.getTipoServizio()) && rs.getString("SERVIZIO_CORRELATO") != null && rs.getString("SERVIZIO_CORRELATO").equals(busta.getServizio())) {
                value = true;
            }
            rs.close();
            pstmt.close();
            return value;
        }
        catch (Exception e) {
            String errorMsg = "PROFILO_DI_COLLABORAZIONE_ASINCRONO, asincrono_isRisposta " + busta.getRiferimentoMessaggio() + ": " + e.getMessage();
            this.log.error((Object)errorMsg, (Throwable)e);
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            throw new EGovException(errorMsg, e);
        }
    }

    public boolean asincrono_ricevutaApplicativaAbilitata(String idEGov) throws EGovException {
        StateMessage state = (StateMessage)this.state;
        Connection connectionDB = state.getConnectionDB();
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            StringBuffer query = new StringBuffer();
            query.append("SELECT * FROM ");
            query.append("ASINCRONO");
            query.append(" WHERE ID_EGOV=? AND TIPO=?");
            pstmt = connectionDB.prepareStatement(query.toString());
            pstmt.setString(1, idEGov);
            pstmt.setString(2, "OUTBOX");
            rs = pstmt.executeQuery();
            if (rs == null) {
                throw new EGovException("RS Null?");
            }
            if (rs.next()) {
                if (rs.getInt("RICEVUTA_APPLICATIVA") == 0) {
                    rs.close();
                    pstmt.close();
                    return false;
                }
                rs.close();
                pstmt.close();
                return true;
            }
            throw new Exception("?Valore non trovato nella tabella asincrona?");
        }
        catch (Exception e) {
            String errorMsg = "PROFILO_DI_COLLABORAZIONE_ASINCRONO, asincrono_ricevutaApplicativaAbilitata " + idEGov + ": " + e.getMessage();
            this.log.error((Object)errorMsg, (Throwable)e);
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            throw new EGovException(errorMsg, e);
        }
    }

    public boolean asincrono_spedizioneRichiestaInCorso(String idEGov) throws EGovException {
        StateMessage state = (StateMessage)this.state;
        Connection connectionDB = state.getConnectionDB();
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            StringBuffer query = new StringBuffer();
            query.append("SELECT IS_RICHIESTA,RICEVUTA_ASINCRONA FROM ");
            query.append("ASINCRONO");
            query.append(" WHERE ID_EGOV=? AND TIPO=?");
            pstmt = connectionDB.prepareStatement(query.toString());
            pstmt.setString(1, idEGov);
            pstmt.setString(2, "OUTBOX");
            rs = pstmt.executeQuery();
            if (rs == null) {
                throw new EGovException("RS Null?");
            }
            if (rs.next()) {
                if (rs.getInt("IS_RICHIESTA") == 1 && rs.getInt("RICEVUTA_ASINCRONA") == 0) {
                    rs.close();
                    pstmt.close();
                    return true;
                }
                rs.close();
                pstmt.close();
                return false;
            }
            rs.close();
            pstmt.close();
            return false;
        }
        catch (Exception e) {
            String errorMsg = "PROFILO_DI_COLLABORAZIONE_ASINCRONO, asincrono_spedizioneRichiestaInCorso " + idEGov + ": " + e.getMessage();
            this.log.error((Object)errorMsg, (Throwable)e);
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            throw new EGovException(errorMsg, e);
        }
    }

    public boolean asincrono_spedizioneRispostaInCorso(String idEGov) throws EGovException {
        StateMessage state = (StateMessage)this.state;
        Connection connectionDB = state.getConnectionDB();
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            StringBuffer query = new StringBuffer();
            query.append("SELECT IS_RICHIESTA,RICEVUTA_ASINCRONA FROM ");
            query.append("ASINCRONO");
            query.append(" WHERE ID_EGOV=? AND TIPO=?");
            pstmt = connectionDB.prepareStatement(query.toString());
            pstmt.setString(1, idEGov);
            pstmt.setString(2, "OUTBOX");
            rs = pstmt.executeQuery();
            if (rs == null) {
                throw new EGovException("RS Null?");
            }
            if (rs.next()) {
                if (rs.getInt("IS_RICHIESTA") == 0 && rs.getInt("RICEVUTA_ASINCRONA") == 0) {
                    rs.close();
                    pstmt.close();
                    return true;
                }
                rs.close();
                pstmt.close();
                return false;
            }
            rs.close();
            pstmt.close();
            return false;
        }
        catch (Exception e) {
            String errorMsg = "PROFILO_DI_COLLABORAZIONE_ASINCRONO, asincrono_spedizioneRispostaInCorso " + idEGov + ": " + e.getMessage();
            this.log.error((Object)errorMsg, (Throwable)e);
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            throw new EGovException(errorMsg, e);
        }
    }

    public void asincrono_eliminaRegistrazione(String idEGov, String tipoBusta) throws EGovException {
        StateMessage state = (StateMessage)this.state;
        Connection connectionDB = state.getConnectionDB();
        PreparedStatement pstmt = null;
        try {
            StringBuffer query = new StringBuffer();
            query.append("DELETE FROM ");
            query.append("ASINCRONO");
            query.append(" WHERE ID_EGOV = ? AND TIPO=?");
            pstmt = connectionDB.prepareStatement(query.toString());
            pstmt.setString(1, idEGov);
            pstmt.setString(2, tipoBusta);
            state.getPreparedStatement().put("DELETE delete_datiAsincroni" + idEGov, pstmt);
        }
        catch (Exception e) {
            String errorMsg = "PROFILO_DI_COLLABORAZIONE_ASINCRONO, Errore durante l'asincrono_eliminaRegistrazione " + idEGov + ": " + e.getMessage();
            this.log.error((Object)errorMsg, (Throwable)e);
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            throw new EGovException(errorMsg, e);
        }
    }
}

