/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.egov;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Random;
import java.util.Vector;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.Detail;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPFault;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.PrefixedQName;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.message.SOAPHeader;
import org.apache.axis.message.SOAPHeaderElement;
import org.apache.axis.soap.MessageFactoryImpl;
import org.apache.log4j.Logger;
import org.openspcoop.dao.commons.IDSoggetto;
import org.openspcoop.dao.eccezione.Dettaglio;
import org.openspcoop.dao.eccezione.DettaglioEccezione;
import org.openspcoop.egov.Busta;
import org.openspcoop.egov.Configurazione;
import org.openspcoop.egov.Costanti;
import org.openspcoop.egov.EGovException;
import org.openspcoop.egov.Eccezione;
import org.openspcoop.egov.ProprietaErroreApplicativo;
import org.openspcoop.egov.ProprietaManifestAttachments;
import org.openspcoop.egov.Riscontro;
import org.openspcoop.egov.Trasmissione;
import org.openspcoop.egov.ValidazioneSemantica;
import org.openspcoop.egov.ValidazioneSintattica;
import org.openspcoop.utils.SoapUtils;
import org.openspcoop.utils.date.DateManager;
import org.openspcoop.utils.xml.XMLUtils;
import org.openspcoop.wssecurity.WSSBaseUtils;
import org.openspcoop.wssecurity.WSSSender;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Imbustamento {
    private Logger log = null;
    private static int serialCounter = 0;
    private static int maxSeriale = 0;
    private static int prefixLenght = 0;

    public Imbustamento() {
        this(Configurazione.getLibraryLog());
    }

    public Imbustamento(Logger aLog) {
        this.log = aLog != null ? aLog : Logger.getLogger((String)"Imbustamento");
    }

    public static synchronized int getSerialCounter() {
        if (maxSeriale == 0) {
            if (Configurazione.getPrefixSeriale() == -1) {
                maxSeriale = 9999999;
                prefixLenght = 0;
            } else if (Configurazione.getPrefixSeriale() < 10) {
                maxSeriale = 999999;
                prefixLenght = 1;
            } else {
                maxSeriale = 99999;
                prefixLenght = 2;
            }
        }
        if (serialCounter + 1 > maxSeriale) {
            serialCounter = 0;
        }
        return ++serialCounter;
    }

    public String buildID_eGov(String idPD, String codAmm) throws EGovException {
        return this.buildID_eGov_engine(idPD, codAmm, Configurazione.getAttesaAttiva(), Configurazione.getCheckInterval());
    }

    public String buildID_eGov(String idPD, String codAmm, long attesaAttiva, int checkInterval) throws EGovException {
        return this.buildID_eGov_engine(idPD, codAmm, attesaAttiva, checkInterval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String buildID_eGov_engine(String idPD, String codAmm, long attesaAttiva, int checkInterval) throws EGovException {
        Connection conDB = null;
        if (!"static".equals(Configurazione.getTipoSeriale())) {
            try {
                conDB = Configurazione.getConnectionPdD();
                if (conDB == null) {
                    throw new Exception("Connessione non disponibile");
                }
            }
            catch (Exception e) {
                throw new EGovException("Negoziamento connessione a database per costruzione id egov non riuscito: " + e.getMessage());
            }
        }
        try {
            int i;
            int padding;
            String c;
            long counter = -1L;
            int oldTransactionIsolation = -1;
            if (idPD == null || codAmm == null) {
                this.log.error((Object)("Creazione ID eGov non riuscita: alcuni parametri di creazione null idPD[" + idPD + "] codAmm[" + codAmm + "]"));
                throw new EGovException("Creazione ID eGov non riuscita: alcuni parametri di creazione null idPD[" + idPD + "] codAmm[" + codAmm + "]");
            }
            StringBuffer bf = new StringBuffer();
            bf.append(codAmm);
            bf.append('_');
            bf.append(idPD);
            bf.append('_');
            if (!Costanti.IDENTIFICATIVO_EGOV_SERIALE_MYSQL.equals(Configurazione.getTipoSeriale())) {
                if ("static".equals(Configurazione.getTipoSeriale())) {
                    if (Configurazione.getPrefixSeriale() != -1) {
                        bf.append(Configurazione.getPrefixSeriale());
                    }
                    c = Long.toString(Imbustamento.getSerialCounter());
                    padding = 7 - prefixLenght - c.length();
                    for (i = 0; i < padding; ++i) {
                        bf.append('0');
                    }
                    bf.append(c);
                } else {
                    try {
                        oldTransactionIsolation = conDB.getTransactionIsolation();
                        try {
                            conDB.rollback();
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        conDB.setTransactionIsolation(8);
                        conDB.setAutoCommit(false);
                    }
                    catch (Exception er) {
                        this.log.error((Object)("Creazione ID eGov non riuscita (impostazione transazione): " + er.getMessage()), (Throwable)er);
                        throw new EGovException("Creazione ID eGov non riuscita (impostazione transazione): " + er.getMessage(), er);
                    }
                    boolean idBuildOK = false;
                    long scadenzaWhile = DateManager.getTimeMillis() + attesaAttiva;
                    while (!idBuildOK && DateManager.getTimeMillis() < scadenzaWhile) {
                        counter = -1L;
                        Statement pstmt = null;
                        Statement pstmtInsert = null;
                        ResultSet rs = null;
                        try {
                            StringBuffer queryInsert;
                            StringBuffer query = new StringBuffer();
                            query.append("SELECT COUNTER FROM ");
                            query.append("ID_EGOV");
                            query.append(" FOR UPDATE");
                            pstmt = conDB.prepareStatement(query.toString());
                            rs = pstmt.executeQuery();
                            if (rs == null) {
                                pstmt.close();
                                this.log.error((Object)"Creazione ID eGov non riuscita: ResultSet is null?");
                                throw new EGovException("Creazione ID eGov non riuscita: ResultSet is null?");
                            }
                            boolean exist = rs.next();
                            if (exist) {
                                counter = rs.getLong("COUNTER");
                                if (counter + 1L > 9999999L) {
                                    counter = 0L;
                                }
                                ++counter;
                            }
                            rs.close();
                            pstmt.close();
                            if (!exist) {
                                counter = 1L;
                                queryInsert = new StringBuffer();
                                queryInsert.append("INSERT INTO  ");
                                queryInsert.append("ID_EGOV");
                                queryInsert.append(" VALUES ( ? )");
                                pstmtInsert = conDB.prepareStatement(queryInsert.toString());
                                pstmtInsert.setLong(1, 1L);
                                pstmtInsert.execute();
                                pstmtInsert.close();
                            } else {
                                queryInsert = new StringBuffer();
                                queryInsert.append("UPDATE ");
                                queryInsert.append("ID_EGOV");
                                queryInsert.append(" SET COUNTER = ? ");
                                pstmtInsert = conDB.prepareStatement(queryInsert.toString());
                                pstmtInsert.setLong(1, counter);
                                pstmtInsert.execute();
                                pstmtInsert.close();
                            }
                            conDB.commit();
                            idBuildOK = true;
                        }
                        catch (Exception e) {
                            System.out.println("ERRORE: " + e.getMessage());
                            try {
                                if (pstmt != null) {
                                    pstmt.close();
                                }
                            }
                            catch (Exception er) {
                                // empty catch block
                            }
                            try {
                                if (pstmtInsert != null) {
                                    pstmtInsert.close();
                                }
                            }
                            catch (Exception er) {
                                // empty catch block
                            }
                            try {
                                if (rs != null) {
                                    rs.close();
                                }
                            }
                            catch (Exception er) {
                                // empty catch block
                            }
                            try {
                                conDB.rollback();
                            }
                            catch (Exception er) {
                                // empty catch block
                            }
                        }
                        if (idBuildOK) continue;
                        try {
                            Thread.sleep(new Random().nextInt(checkInterval));
                        }
                        catch (Exception eRandom) {}
                    }
                    if (!idBuildOK) {
                        throw new EGovException("Creazione ID eGov non riuscita: l'accesso serializable non ha permesso la creazione del numero sequenziale");
                    }
                }
            }
            if (!"static".equals(Configurazione.getTipoSeriale())) {
                try {
                    conDB.setTransactionIsolation(oldTransactionIsolation);
                    conDB.setAutoCommit(true);
                }
                catch (Exception er) {
                    System.out.println("ERROR UNSET:" + er.getMessage());
                    this.log.error((Object)("Creazione ID eGov non riuscita (ripristino transazione): " + er.getMessage()));
                    throw new EGovException("Creazione ID eGov non riuscita (ripristino transazione): " + er.getMessage());
                }
                c = Long.toString(counter);
                padding = 7 - c.length();
                for (i = 0; i < padding; ++i) {
                    bf.append('0');
                }
                bf.append(c);
            }
            bf.append('_');
            Date now = DateManager.getDate();
            SimpleDateFormat dateformat = new SimpleDateFormat("yyyy-MM-dd_HH:mm");
            bf.append(dateformat.format(now));
            String string = bf.toString();
            return string;
        }
        finally {
            try {
                Configurazione.releaseConnectionPdD(conDB);
            }
            catch (Exception e) {
                this.log.error((Object)"Rilascio connessione per creazione id egov non riuscito", (Throwable)e);
            }
        }
    }

    public static String getDate_eGovFormat() {
        Date now = DateManager.getDate();
        return Imbustamento.getDate_eGovFormat(now);
    }

    public static String getDate_eGovFormat(Date date) {
        SimpleDateFormat dateformat = new SimpleDateFormat("yyyy-MM-dd_HH:mm:ss.SSS");
        return dateformat.format(date).replace('_', 'T');
    }

    @Deprecated
    public static Date getDateObject_eGovFormat() {
        return DateManager.getDate();
    }

    public SOAPElement build_eGovHeader(Busta eGov) throws EGovException {
        return this.build_eGovHeader(eGov, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SOAPElement build_eGovHeader(Busta eGov, boolean verificaPresenzaElementiObbligatori) throws EGovException {
        try {
            boolean generazioneElemento;
            PrefixedQName name = new PrefixedQName("http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/", "Intestazione", "eGov_IT");
            SOAPHeaderElement eGovHeader = new SOAPHeaderElement((Name)name);
            eGovHeader.setActor("http://www.cnipa.it/eGov_it/portadominio");
            eGovHeader.setMustUnderstand(true);
            eGovHeader.addNamespaceDeclaration("SOAP_ENV", "http://schemas.xmlsoap.org/soap/envelope/");
            MessageElement eGovIntestazioneMsg = (MessageElement)eGovHeader.addChildElement("IntestazioneMessaggio");
            if (verificaPresenzaElementiObbligatori) {
                if (eGov.getMittente() == null) {
                    throw new EGovException("Mittente e' un elemento obbligatorio, e non e' stato definito");
                }
                if (eGov.getTipoMittente() == null) {
                    throw new EGovException("TipoMittente e' un attributo obbligatorio, e non e' stato definito");
                }
            }
            MessageElement eGovMitt = (MessageElement)eGovIntestazioneMsg.addChildElement("Mittente");
            MessageElement eGovIDParteMitt = (MessageElement)eGovMitt.addChildElement("IdentificativoParte");
            if (eGov.getMittente() != null) {
                eGovIDParteMitt.setValue(eGov.getMittente());
            }
            if (eGov.getTipoMittente() != null) {
                eGovIDParteMitt.setAttribute("tipo", eGov.getTipoMittente());
            }
            if (eGov.getIndirizzoTelematicoMittente() != null) {
                eGovIDParteMitt.setAttribute("indirizzoTelematico", eGov.getIndirizzoTelematicoMittente());
            }
            if (verificaPresenzaElementiObbligatori) {
                if (eGov.getDestinatario() == null) {
                    throw new EGovException("Destinatario e' un elemento obbligatorio, e non e' stato definito");
                }
                if (eGov.getTipoDestinatario() == null) {
                    throw new EGovException("TipoDestinatario e' un attributo obbligatorio, e non e' stato definito");
                }
            }
            MessageElement eGovDest = (MessageElement)eGovIntestazioneMsg.addChildElement("Destinatario");
            MessageElement eGovIDParteDest = (MessageElement)eGovDest.addChildElement("IdentificativoParte");
            if (eGov.getDestinatario() != null) {
                eGovIDParteDest.setValue(eGov.getDestinatario());
            }
            if (eGov.getTipoDestinatario() != null) {
                eGovIDParteDest.setAttribute("tipo", eGov.getTipoDestinatario());
            }
            if (eGov.getIndirizzoTelematicoDestinatario() != null) {
                eGovIDParteDest.setAttribute("indirizzoTelematico", eGov.getIndirizzoTelematicoDestinatario());
            }
            if (eGov.getProfiloDiCollaborazione() != null) {
                generazioneElemento = true;
                if (!(Configurazione.getConfigurazioneGenerazioneBusta().isGenerazioneElementiNonValidabiliRispettoXSD() || "EGOV_IT_MessaggioSingoloOneWay".equals(eGov.getProfiloDiCollaborazione()) || "EGOV_IT_ServizioSincrono".equals(eGov.getProfiloDiCollaborazione()) || "EGOV_IT_ServizioAsincronoSimmetrico".equals(eGov.getProfiloDiCollaborazione()) || "EGOV_IT_ServizioAsincronoAsimmetrico".equals(eGov.getProfiloDiCollaborazione()))) {
                    generazioneElemento = false;
                }
                if (generazioneElemento) {
                    MessageElement eGovProfCollaborazione = (MessageElement)eGovIntestazioneMsg.addChildElement("ProfiloCollaborazione");
                    eGovProfCollaborazione.setValue(eGov.getProfiloDiCollaborazione());
                    if (eGov.getServizioCorrelato() != null) {
                        eGovProfCollaborazione.setAttribute("servizioCorrelato", eGov.getServizioCorrelato());
                    }
                    if (eGov.getTipoServizioCorrelato() != null) {
                        boolean generazioneAttributo = true;
                        if (!Configurazione.getConfigurazioneGenerazioneBusta().isGenerazioneElementiNonValidabiliRispettoXSD()) {
                            generazioneAttributo = Configurazione.getTipiServiziValidi().contains(eGov.getTipoServizioCorrelato());
                        }
                        if (generazioneAttributo) {
                            eGovProfCollaborazione.setAttribute("tipo", eGov.getTipoServizioCorrelato());
                        }
                    }
                }
            }
            if (eGov.getCollaborazione() != null) {
                generazioneElemento = true;
                if (!Configurazione.getConfigurazioneGenerazioneBusta().isGenerazioneElementiNonValidabiliRispettoXSD()) {
                    generazioneElemento = ValidazioneSemantica.validazioneIDEGov(eGov.getCollaborazione());
                }
                if (generazioneElemento) {
                    MessageElement eGovCollaborazione = (MessageElement)eGovIntestazioneMsg.addChildElement("Collaborazione");
                    eGovCollaborazione.setValue(eGov.getCollaborazione());
                }
            }
            if (eGov.getServizio() != null) {
                MessageElement eGovServizio = (MessageElement)eGovIntestazioneMsg.addChildElement("Servizio");
                eGovServizio.setValue(eGov.getServizio());
                if (eGov.getTipoServizio() != null) {
                    eGovServizio.setAttribute("tipo", eGov.getTipoServizio());
                }
            }
            if (eGov.getAzione() != null) {
                MessageElement eGovAzione = (MessageElement)eGovIntestazioneMsg.addChildElement("Azione");
                eGovAzione.setValue(eGov.getAzione());
            }
            MessageElement eGovMessaggio = (MessageElement)eGovIntestazioneMsg.addChildElement("Messaggio");
            if (eGov.getID() != null) {
                boolean generazioneElemento2 = true;
                if (!Configurazione.getConfigurazioneGenerazioneBusta().isGenerazioneElementiNonValidabiliRispettoXSD()) {
                    generazioneElemento2 = ValidazioneSemantica.validazioneIDEGov(eGov.getID());
                }
                if (!generazioneElemento2) throw new EGovException("Identificatore e' un elemento obbligatorio, e il valore non e' utilizzabile rispetto all'xsd (" + eGov.getID() + ")");
                MessageElement eGovIDMsg = (MessageElement)eGovMessaggio.addChildElement("Identificatore");
                if (eGov.getID() != null) {
                    eGovIDMsg.setValue(eGov.getID());
                }
            } else if (verificaPresenzaElementiObbligatori) {
                throw new EGovException("Identificatore e' un elemento obbligatorio, e non e' stato definito");
            }
            MessageElement eGovOraRegistrazione = (MessageElement)eGovMessaggio.addChildElement("OraRegistrazione");
            if (eGov.getOraRegistrazione() == null && verificaPresenzaElementiObbligatori) {
                throw new EGovException("OraRegistrazione e' un elemento obbligatorio, e non e' stato definito");
            }
            SimpleDateFormat dateformat = new SimpleDateFormat("yyyy-MM-dd_HH:mm:ss.SSS");
            if (eGov.getOraRegistrazione() != null) {
                String oraS = dateformat.format(eGov.getOraRegistrazione()).replace('_', 'T');
                eGovOraRegistrazione.setObjectValue((Object)oraS);
            }
            if (eGov.getTipoOraRegistrazione() != null) {
                boolean generazioneAttributo = true;
                if (!Configurazione.getConfigurazioneGenerazioneBusta().isGenerazioneElementiNonValidabiliRispettoXSD()) {
                    boolean bl = generazioneAttributo = "EGOV_IT_Locale".equals(eGov.getTipoOraRegistrazione()) || "EGOV_IT_SPC".equals(eGov.getTipoOraRegistrazione());
                }
                if (!generazioneAttributo) throw new EGovException("TipoOraRegistrazione e' un elemento obbligatorio, e il valore non e' utilizzabile rispetto all'xsd (" + eGov.getTipoOraRegistrazione() + ")");
                eGovOraRegistrazione.setAttribute("tempo", eGov.getTipoOraRegistrazione());
            } else {
                eGovOraRegistrazione.setAttribute("tempo", "EGOV_IT_SPC");
            }
            if (eGov.getRiferimentoMessaggio() != null) {
                boolean generazioneElemento3 = true;
                if (!Configurazione.getConfigurazioneGenerazioneBusta().isGenerazioneElementiNonValidabiliRispettoXSD()) {
                    generazioneElemento3 = ValidazioneSemantica.validazioneIDEGov(eGov.getRiferimentoMessaggio());
                }
                if (generazioneElemento3) {
                    MessageElement eGovRifMsg = (MessageElement)eGovMessaggio.addChildElement("RiferimentoMessaggio");
                    eGovRifMsg.setValue(eGov.getRiferimentoMessaggio());
                }
            }
            if (eGov.getScadenza() != null) {
                MessageElement eGovScadenza = (MessageElement)eGovMessaggio.addChildElement("Scadenza");
                dateformat = new SimpleDateFormat("yyyy-MM-dd_HH:mm:ss.SSS");
                String oraS = dateformat.format(eGov.getScadenza()).replace('_', 'T');
                eGovScadenza.setObjectValue((Object)oraS);
            }
            MessageElement eGovProfTrasmissione = (MessageElement)eGovIntestazioneMsg.addChildElement("ProfiloTrasmissione");
            if (eGov.getInoltro() != null) {
                boolean generazioneElemento4 = true;
                if (!Configurazione.getConfigurazioneGenerazioneBusta().isGenerazioneElementiNonValidabiliRispettoXSD()) {
                    boolean bl = generazioneElemento4 = "EGOV_IT_PIUDIUNAVOLTA".equals(eGov.getInoltro()) || "EGOV_IT_ALPIUUNAVOLTA".equals(eGov.getInoltro());
                }
                if (generazioneElemento4) {
                    eGovProfTrasmissione.setAttribute("inoltro", eGov.getInoltro());
                }
            }
            String crValue = "false";
            if (eGov.getConfermaRicezione()) {
                crValue = "true";
            }
            eGovProfTrasmissione.setAttribute("confermaRicezione", crValue);
            if (eGov.getSequenza() != -1L) {
                MessageElement eGovSequenza = (MessageElement)eGovIntestazioneMsg.addChildElement("Sequenza");
                StringBuffer bf = new StringBuffer();
                String sequenza = Long.toString(eGov.getSequenza());
                int padding = 7 - sequenza.length();
                for (int i = 0; i < padding; ++i) {
                    bf.append('0');
                }
                bf.append(sequenza);
                eGovSequenza.setAttribute("numeroProgressivo", bf.toString());
            }
            if (eGov.sizeListaRiscontri() > 0) {
                MessageElement eGovListaRiscontri = (MessageElement)eGovHeader.addChildElement("ListaRiscontri");
                for (int i = 0; i < eGov.sizeListaRiscontri(); ++i) {
                    Riscontro ris = eGov.getRiscontro(i);
                    MessageElement Riscontro2 = (MessageElement)eGovListaRiscontri.addChildElement("Riscontro");
                    if (ris.getID() != null) {
                        boolean generazioneElemento5 = true;
                        if (!Configurazione.getConfigurazioneGenerazioneBusta().isGenerazioneElementiNonValidabiliRispettoXSD()) {
                            generazioneElemento5 = ValidazioneSemantica.validazioneIDEGov(ris.getID());
                        }
                        if (!generazioneElemento5) throw new EGovException("Identificatore e' un elemento obbligatorio in un Riscontro, e il valore non e' utilizzabile rispetto all'xsd (" + ris.getID() + ")");
                        MessageElement id = (MessageElement)Riscontro2.addChildElement("Identificatore");
                        id.setValue(ris.getID());
                    } else if (verificaPresenzaElementiObbligatori) {
                        throw new EGovException("Identificatore e' un elemento obbligatorio in un Riscontro, e non e' stato definito");
                    }
                    if (ris.getOraRegistrazione() != null) {
                        MessageElement ora = (MessageElement)Riscontro2.addChildElement("OraRegistrazione");
                        dateformat = new SimpleDateFormat("yyyy-MM-dd_HH:mm:ss.SSS");
                        String oraR = dateformat.format(ris.getOraRegistrazione()).replace('_', 'T');
                        ora.setObjectValue((Object)oraR);
                        if (ris.getTipoOraRegistrazione() != null) {
                            boolean generazioneAttributo = true;
                            if (!Configurazione.getConfigurazioneGenerazioneBusta().isGenerazioneElementiNonValidabiliRispettoXSD()) {
                                boolean bl = generazioneAttributo = "EGOV_IT_Locale".equals(ris.getTipoOraRegistrazione()) || "EGOV_IT_SPC".equals(ris.getTipoOraRegistrazione());
                            }
                            if (!generazioneAttributo) throw new EGovException("TipoOraRegistrazione e' un attributo obbligatorio in un Riscontro, e il valore non e' utilizzabile rispetto all'xsd (" + ris.getTipoOraRegistrazione() + ")");
                            ora.setAttribute("tempo", ris.getTipoOraRegistrazione());
                            continue;
                        }
                        ora.setAttribute("tempo", "EGOV_IT_SPC");
                        continue;
                    }
                    if (!verificaPresenzaElementiObbligatori) continue;
                    throw new EGovException("OraRegistrazione e' un elemento obbligatorio in un Riscontro, e non e' stato definito");
                }
            }
            if (eGov.sizeListaTrasmissioni() > 0) {
                boolean addFirstElement = false;
                MessageElement eGovListaTrasmissioni = null;
                for (int i = 0; i < eGov.sizeListaTrasmissioni(); ++i) {
                    Trasmissione tr = eGov.getTrasmissione(i);
                    if (tr.getOrigine() == null || tr.getTipoOrigine() == null || tr.getDestinazione() == null || tr.getTipoDestinazione() == null || tr.getOraRegistrazione() == null || tr.getTempo() == null) continue;
                    if (!addFirstElement) {
                        eGovListaTrasmissioni = (MessageElement)eGovHeader.addChildElement("ListaTrasmissioni");
                        addFirstElement = true;
                    }
                    MessageElement Trasmissione2 = (MessageElement)eGovListaTrasmissioni.addChildElement("Trasmissione");
                    MessageElement orig = (MessageElement)Trasmissione2.addChildElement("Origine");
                    MessageElement IDParteOrigine = (MessageElement)orig.addChildElement("IdentificativoParte");
                    IDParteOrigine.setValue(tr.getOrigine());
                    IDParteOrigine.setAttribute("tipo", tr.getTipoOrigine());
                    if (tr.getIndirizzoTelematicoOrigine() != null) {
                        IDParteOrigine.setAttribute("indirizzoTelematico", tr.getIndirizzoTelematicoOrigine());
                    }
                    MessageElement dest = (MessageElement)Trasmissione2.addChildElement("Destinazione");
                    MessageElement IDParteDest = (MessageElement)dest.addChildElement("IdentificativoParte");
                    IDParteDest.setValue(tr.getDestinazione());
                    IDParteDest.setAttribute("tipo", tr.getTipoDestinazione());
                    if (tr.getIndirizzoTelematicoDestinazione() != null) {
                        IDParteDest.setAttribute("indirizzoTelematico", tr.getIndirizzoTelematicoDestinazione());
                    }
                    MessageElement ora = (MessageElement)Trasmissione2.addChildElement("OraRegistrazione");
                    dateformat = new SimpleDateFormat("yyyy-MM-dd_HH:mm:ss.SSS");
                    String oraR = dateformat.format(tr.getOraRegistrazione()).replace('_', 'T');
                    ora.setObjectValue((Object)oraR);
                    boolean generazioneAttributo = true;
                    if (!Configurazione.getConfigurazioneGenerazioneBusta().isGenerazioneElementiNonValidabiliRispettoXSD()) {
                        boolean bl = generazioneAttributo = "EGOV_IT_Locale".equals(tr.getTempo()) || "EGOV_IT_SPC".equals(tr.getTempo());
                    }
                    if (!generazioneAttributo) throw new EGovException("Tempo e' un attributo obbligatorio in una trasmissione, e il valore non e' utilizzabile rispetto all'xsd (" + tr.getTempo() + ")");
                    ora.setAttribute("tempo", tr.getTempo());
                }
            }
            if (eGov.sizeListaEccezioni() <= 0) return eGovHeader;
            MessageElement eGovListaEccezioni = (MessageElement)eGovHeader.addChildElement("ListaEccezioni");
            for (int i = 0; i < eGov.sizeListaEccezioni(); ++i) {
                boolean generazioneAttributo;
                Eccezione ecc = eGov.getEccezione(i);
                MessageElement eccezione = (MessageElement)eGovListaEccezioni.addChildElement("Eccezione");
                if (ecc.getContestoCodifica() != null) {
                    eccezione.setAttribute("contestoCodifica", ecc.getContestoCodifica());
                } else if (verificaPresenzaElementiObbligatori) {
                    throw new EGovException("ContestoCodifica e' un attributo obbligatorio in una eccezione, e non e' stato definito");
                }
                if (ecc.getCodiceEccezione() != null) {
                    generazioneAttributo = true;
                    if (!Configurazione.getConfigurazioneGenerazioneBusta().isGenerazioneElementiNonValidabiliRispettoXSD()) {
                        generazioneAttributo = ValidazioneSintattica.validazioneCodiceEccezione(ecc.getCodiceEccezione());
                    }
                    if (!generazioneAttributo) throw new EGovException("CodiceEccezione e' un attributo obbligatorio in una eccezione, e il valore non e' utilizzabile rispetto all'xsd (" + ecc.getCodiceEccezione() + ")");
                    eccezione.setAttribute("codiceEccezione", ecc.getCodiceEccezione());
                } else if (verificaPresenzaElementiObbligatori) {
                    throw new EGovException("CodiceEccezione e' un attributo obbligatorio in una eccezione, e non e' stato definito");
                }
                if (ecc.getRilevanza() != null) {
                    generazioneAttributo = true;
                    if (!Configurazione.getConfigurazioneGenerazioneBusta().isGenerazioneElementiNonValidabiliRispettoXSD()) {
                        boolean bl = generazioneAttributo = "INFO".equals(ecc.getRilevanza()) || "LIEVE".equals(ecc.getRilevanza()) || "GRAVE".equals(ecc.getRilevanza());
                    }
                    if (!generazioneAttributo) throw new EGovException("Rilevanza e' un attributo obbligatorio in una eccezione, e il valore non e' utilizzabile rispetto all'xsd (" + ecc.getRilevanza() + ")");
                    eccezione.setAttribute("rilevanza", ecc.getRilevanza());
                } else if (verificaPresenzaElementiObbligatori) {
                    throw new EGovException("Rilevanza e' un attributo obbligatorio in una eccezione, e non e' stato definito");
                }
                if (ecc.getPosizione() != null) {
                    eccezione.setAttribute("posizione", ecc.getPosizione());
                    continue;
                }
                if (!verificaPresenzaElementiObbligatori) continue;
                throw new EGovException("Posizione e' un attributo obbligatorio in una eccezione, e non e' stato definito");
            }
            return eGovHeader;
        }
        catch (Exception e) {
            this.log.error((Object)("Creazione busta eGov non riuscita: " + e.getMessage()), (Throwable)e);
            throw new EGovException("Creazione busta eGov non riuscita: " + e.getMessage(), e);
        }
    }

    public Message build_eGovManifest(Message msg, boolean isRichiesta, boolean scartaBody, boolean onlyRefreshIdManifestAttachments, ProprietaManifestAttachments proprietaManifestAttachments) throws EGovException {
        try {
            if (!onlyRefreshIdManifestAttachments) {
                PrefixedQName name = new PrefixedQName("http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/", "Descrizione", "eGov_IT");
                MessageElement descrizione = new MessageElement((Name)name);
                Iterator iter = msg.getAttachmentsImpl().getAttachments().iterator();
                int attach = 1;
                while (iter.hasNext()) {
                    org.apache.axis.attachments.AttachmentPart p = (org.apache.axis.attachments.AttachmentPart)iter.next();
                    String contentID = p.getContentId();
                    String contentLocation = p.getContentLocation();
                    String contentType = p.getContentType();
                    MessageElement descrizioneMessaggio = (MessageElement)descrizione.addChildElement("DescrizioneMessaggio");
                    MessageElement riferimento = (MessageElement)descrizioneMessaggio.addChildElement("Riferimento");
                    if (contentID != null) {
                        riferimento.setAttribute("href", "cid:" + contentID);
                    } else {
                        riferimento.setAttribute("href", contentLocation);
                    }
                    if (attach == 1 && scartaBody) {
                        if (isRichiesta) {
                            riferimento.setAttribute("role", proprietaManifestAttachments.getRoleRichiesta());
                        } else {
                            riferimento.setAttribute("role", proprietaManifestAttachments.getRoleRisposta());
                        }
                    } else {
                        riferimento.setAttribute("role", proprietaManifestAttachments.getRoleAllegato());
                    }
                    riferimento.setAttribute("http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/", "id", "attachment" + attach);
                    MessageElement schema = (MessageElement)riferimento.addChildElement("Schema");
                    schema.setAttribute("posizione", contentType);
                    MessageElement titolo = (MessageElement)riferimento.addChildElement("Titolo");
                    titolo.setAttribute("Lingua", "it");
                    if (attach == 1 && scartaBody) {
                        if (isRichiesta) {
                            titolo.setValue(proprietaManifestAttachments.getRoleRichiesta());
                        } else {
                            titolo.setValue(proprietaManifestAttachments.getRoleRisposta());
                        }
                    } else {
                        titolo.setValue("attachment" + attach);
                    }
                    ++attach;
                }
                if (!scartaBody) {
                    byte[] body = SoapUtils.sbustamentoSOAPEnvelope((SOAPEnvelope)msg.getSOAPEnvelope());
                    org.apache.axis.attachments.AttachmentPart ap = (org.apache.axis.attachments.AttachmentPart)msg.createAttachmentPart();
                    ByteArrayInputStream isContent = new ByteArrayInputStream(body);
                    ap.setContent((Object)isContent, "text/xml");
                    msg.addAttachmentPart((AttachmentPart)ap);
                    isContent.close();
                    MessageElement descrizioneMessaggio = (MessageElement)descrizione.addChildElement("DescrizioneMessaggio");
                    MessageElement riferimento = (MessageElement)descrizioneMessaggio.addChildElement("Riferimento");
                    riferimento.setAttribute("href", "cid:" + ap.getContentId());
                    if (isRichiesta) {
                        riferimento.setAttribute("role", proprietaManifestAttachments.getRoleRichiesta());
                    } else {
                        riferimento.setAttribute("role", proprietaManifestAttachments.getRoleRisposta());
                    }
                    riferimento.setAttribute("http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/", "id", "attachment" + attach);
                    MessageElement schema = (MessageElement)riferimento.addChildElement("Schema");
                    schema.setAttribute("posizione", ap.getContentType());
                    MessageElement titolo = (MessageElement)riferimento.addChildElement("Titolo");
                    titolo.setAttribute("Lingua", "it");
                    if (isRichiesta) {
                        titolo.setValue(proprietaManifestAttachments.getRoleRichiesta());
                    } else {
                        titolo.setValue(proprietaManifestAttachments.getRoleRisposta());
                    }
                }
                msg.getSOAPBody().removeContents();
                byte[] manifest = SoapUtils.msgElementoToByte((MessageElement)descrizione);
                Document document = XMLUtils.newDocument((byte[])manifest);
                MessageElement manifestTypeErase = new MessageElement(document.getDocumentElement());
                msg.getSOAPBody().addChildElement((SOAPElement)manifestTypeErase);
            }
            return msg;
        }
        catch (Exception e) {
            this.log.error((Object)("Creazione Manifest degli attachments non riuscita: " + e.getMessage()), (Throwable)e);
            throw new EGovException("Creazione Manifest degli attachments non riuscita: " + e.getMessage(), e);
        }
    }

    public void imbustamentoEGov(Message msg, Busta busta, ProprietaManifestAttachments proprietaManifestAttachments) throws EGovException {
        this.imbustamentoEGov(msg, busta, false, false, false, false, proprietaManifestAttachments);
    }

    public void imbustamentoEGov(Message msg, Busta busta, boolean gestioneManifest, boolean isRichiesta, boolean scartaBody, boolean onlyRefreshIdManifestAttachments, ProprietaManifestAttachments proprietaManifestAttachments) throws EGovException {
        try {
            SOAPHeaderElement headerEGovElement = (SOAPHeaderElement)this.build_eGovHeader(busta);
            this.imbustamentoEGov(msg, headerEGovElement, gestioneManifest, isRichiesta, scartaBody, onlyRefreshIdManifestAttachments, proprietaManifestAttachments);
        }
        catch (Exception e) {
            this.log.error((Object)("ImbustamentoEGov non riuscito: " + e.getMessage()), (Throwable)e);
            throw new EGovException("ImbustamentoEGov non riuscito: " + e.getMessage(), e);
        }
    }

    public void imbustamentoEGov(Message msg, SOAPHeaderElement headerEGovElement, boolean gestioneManifest, boolean isRichiesta, boolean scartaBody, boolean onlyRefreshIdManifestAttachments, ProprietaManifestAttachments proprietaManifestAttachments) throws EGovException {
        try {
            byte[] headerEGov = SoapUtils.msgElementoToByte((MessageElement)headerEGovElement);
            Document document = XMLUtils.newDocument((byte[])headerEGov);
            SOAPHeaderElement hdrEGov = new SOAPHeaderElement(document.getDocumentElement());
            SOAPHeader hdr = (SOAPHeader)msg.getSOAPHeader();
            if (hdr == null) {
                hdr = (SOAPHeader)msg.getSOAPEnvelope().addHeader();
            }
            hdr.addChildElement((SOAPElement)hdrEGov);
            if (msg.countAttachments() > 0 && gestioneManifest) {
                this.build_eGovManifest(msg, isRichiesta, scartaBody, onlyRefreshIdManifestAttachments, proprietaManifestAttachments);
            }
        }
        catch (Exception e) {
            this.log.error((Object)("ImbustamentoEGov non riuscito: " + e.getMessage()), (Throwable)e);
            throw new EGovException("ImbustamentoEGov non riuscito: " + e.getMessage(), e);
        }
    }

    public void build_trasmissione(Trasmissione trasmissione, MessageElement listaTrasmissioni) throws EGovException {
        try {
            MessageElement trasmissioneNode = (MessageElement)listaTrasmissioni.addChildElement("Trasmissione");
            MessageElement orig = (MessageElement)trasmissioneNode.addChildElement("Origine");
            MessageElement IDParteOrigine = (MessageElement)orig.addChildElement("IdentificativoParte");
            IDParteOrigine.setValue(trasmissione.getOrigine());
            IDParteOrigine.setAttribute("tipo", trasmissione.getTipoOrigine());
            if (trasmissione.getIndirizzoTelematicoOrigine() != null) {
                IDParteOrigine.setAttribute("indirizzoTelematico", trasmissione.getIndirizzoTelematicoOrigine());
            }
            MessageElement dest = (MessageElement)trasmissioneNode.addChildElement("Destinazione");
            MessageElement IDParteDest = (MessageElement)dest.addChildElement("IdentificativoParte");
            IDParteDest.setValue(trasmissione.getDestinazione());
            IDParteDest.setAttribute("tipo", trasmissione.getTipoDestinazione());
            if (trasmissione.getIndirizzoTelematicoDestinazione() != null) {
                IDParteDest.setAttribute("indirizzoTelematico", trasmissione.getIndirizzoTelematicoDestinazione());
            }
            MessageElement ora = (MessageElement)trasmissioneNode.addChildElement("OraRegistrazione");
            SimpleDateFormat dateformat = new SimpleDateFormat("yyyy-MM-dd_HH:mm:ss.SSS");
            String oraR = dateformat.format(trasmissione.getOraRegistrazione()).replace('_', 'T');
            ora.setValue(oraR);
            ora.setAttribute("tempo", trasmissione.getTempo());
        }
        catch (Exception e) {
            this.log.error((Object)("Creazione trasmissione non riuscita: " + e.getMessage()), (Throwable)e);
            throw new EGovException("Creazione trasmissione non riuscita: " + e.getMessage(), e);
        }
    }

    public void addTrasmissione(Message message, Trasmissione trasmissione, boolean readQualifiedAttribute) throws EGovException {
        ValidazioneSintattica validatoreSintattico = null;
        SOAPHeaderElement eGovHeaderOLD = null;
        SOAPHeaderElement eGovHeaderNEW = null;
        try {
            validatoreSintattico = new ValidazioneSintattica(message, readQualifiedAttribute);
            eGovHeaderOLD = (SOAPHeaderElement)validatoreSintattico.getHeaderEGov();
            if (eGovHeaderOLD == null) {
                throw new EGovException("Header eGov non esistente");
            }
            PrefixedQName name = new PrefixedQName(eGovHeaderOLD.getNamespaceURI(), eGovHeaderOLD.getLocalName(), eGovHeaderOLD.getPrefix());
            eGovHeaderNEW = new SOAPHeaderElement((Name)name);
            eGovHeaderNEW.setActor(eGovHeaderOLD.getActor());
            eGovHeaderNEW.setMustUnderstand(eGovHeaderOLD.getMustUnderstand());
            Iterator namespaces = eGovHeaderOLD.getNamespacePrefixes();
            while (namespaces.hasNext()) {
                String mNamespace = (String)namespaces.next();
                eGovHeaderNEW.addNamespaceDeclaration(mNamespace, eGovHeaderOLD.getNamespaceURI(mNamespace));
            }
            Iterator attributes = eGovHeaderOLD.getAllAttributes();
            while (attributes.hasNext()) {
                Name mAttribute = (Name)attributes.next();
                eGovHeaderNEW.addAttribute(mAttribute, eGovHeaderOLD.getAttributeValue(mAttribute));
            }
            Iterator child = eGovHeaderOLD.getChildElements();
            while (child.hasNext()) {
                MessageElement mChild = (MessageElement)child.next();
                eGovHeaderNEW.addChild(mChild);
            }
            child = eGovHeaderNEW.getChildElements();
            MessageElement listaTrasmissioni = null;
            while (child.hasNext()) {
                MessageElement mChild = (MessageElement)child.next();
                if (!"ListaTrasmissioni".equals(mChild.getLocalName())) continue;
                listaTrasmissioni = mChild;
                break;
            }
            if (listaTrasmissioni == null) {
                listaTrasmissioni = (MessageElement)eGovHeaderNEW.addChildElement("ListaTrasmissioni");
            }
            this.build_trasmissione(trasmissione, listaTrasmissioni);
            message.getSOAPHeader().removeChild((Node)eGovHeaderOLD);
            this.imbustamentoEGov(message, eGovHeaderNEW, false, false, false, false, null);
        }
        catch (Exception e) {
            this.log.error((Object)("addTrasmissione non riuscita: " + e.getMessage()), (Throwable)e);
            throw new EGovException("addTrasmissione non riuscita: " + e.getMessage(), e);
        }
        finally {
            if (validatoreSintattico != null) {
                validatoreSintattico.setHeaderSOAP(null);
            }
            validatoreSintattico = null;
            eGovHeaderOLD = null;
            eGovHeaderNEW = null;
        }
    }

    public Busta buildSPCoopErrore_Validazione(Vector<Eccezione> eccezioni, Busta busta, String id_eGov, String tipoTempo) {
        return this.buildSPCoopErrore(eccezioni, busta, id_eGov, tipoTempo);
    }

    public Busta buildSPCoopErrore_Processamento(Vector<Eccezione> eccezioni, Busta busta, String id_eGov, String tipoTempo) {
        return this.buildSPCoopErrore(eccezioni, busta, id_eGov, tipoTempo);
    }

    public Busta buildSPCoopErrore_Processamento(Eccezione ecc, Busta busta, String id_eGov, String tipoTempo) {
        Vector<Eccezione> eccs = new Vector<Eccezione>();
        eccs.add(ecc);
        return this.buildSPCoopErrore(eccs, busta, id_eGov, tipoTempo);
    }

    private Busta buildSPCoopErrore(Vector<Eccezione> eccezioni, Busta busta, String id_eGov, String tipoTempo) {
        String tipoDest = busta.getTipoMittente();
        String dest = busta.getMittente();
        String indTdest = busta.getIndirizzoTelematicoMittente();
        busta.setTipoMittente(busta.getTipoDestinatario());
        busta.setMittente(busta.getDestinatario());
        busta.setIndirizzoTelematicoMittente(busta.getIndirizzoTelematicoDestinatario());
        busta.setTipoDestinatario(tipoDest);
        busta.setDestinatario(dest);
        busta.setIndirizzoTelematicoDestinatario(indTdest);
        busta.setRiferimentoMessaggio(busta.getID());
        busta.setID(id_eGov);
        busta.setOraRegistrazione(DateManager.getDate());
        busta.setTipoOraRegistrazione(tipoTempo);
        while (busta.sizeListaTrasmissioni() != 0) {
            busta.removeTrasmissione(0);
        }
        while (busta.sizeListaEccezioni() != 0) {
            busta.removeEccezione(0);
        }
        while (busta.sizeListaRiscontri() != 0) {
            busta.removeRiscontro(0);
        }
        while (eccezioni.size() > 0) {
            Eccezione e = eccezioni.remove(0);
            busta.addEccezione(e);
        }
        if (!Configurazione.getConfigurazioneGenerazioneBusta().isGenerazioneElementiNonValidabiliRispettoXSD()) {
            if (busta.getProfiloDiCollaborazione() != null) {
                if (!("EGOV_IT_MessaggioSingoloOneWay".equals(busta.getProfiloDiCollaborazione()) || "EGOV_IT_ServizioSincrono".equals(busta.getProfiloDiCollaborazione()) || "EGOV_IT_ServizioAsincronoSimmetrico".equals(busta.getProfiloDiCollaborazione()) || "EGOV_IT_ServizioAsincronoAsimmetrico".equals(busta.getProfiloDiCollaborazione()))) {
                    busta.setProfiloDiCollaborazione(null);
                    busta.setTipoServizioCorrelato(null);
                    busta.setServizioCorrelato(null);
                } else if (busta.getTipoServizioCorrelato() != null && !Configurazione.getTipiServiziValidi().contains(busta.getTipoServizioCorrelato())) {
                    busta.setTipoServizioCorrelato(null);
                }
            }
            if (busta.getRiferimentoMessaggio() != null && !ValidazioneSemantica.validazioneIDEGov(busta.getRiferimentoMessaggio())) {
                busta.setRiferimentoMessaggio(null);
            }
            if (busta.getInoltro() != null && !"EGOV_IT_PIUDIUNAVOLTA".equals(busta.getInoltro()) && !"EGOV_IT_ALPIUUNAVOLTA".equals(busta.getInoltro())) {
                busta.setInoltro(null);
            }
        }
        return busta;
    }

    public Message buildAxisMsgSPCoopErrore_Validazione() {
        return this.buildAxisMsgSPCoopErrore(true, null);
    }

    public Message buildAxisMsgSPCoopErrore_Processamento(DettaglioEccezione dettaglioEccezione) {
        return this.buildAxisMsgSPCoopErrore(false, dettaglioEccezione);
    }

    private Message buildAxisMsgSPCoopErrore(boolean erroreValidazione, DettaglioEccezione dettaglioEccezione) {
        try {
            MessageFactoryImpl mf = new MessageFactoryImpl();
            Message msg = (Message)mf.createMessage();
            SOAPEnvelope env = msg.getSOAPEnvelope();
            env.addNamespaceDeclaration("xsi", "http://www.w3.org/2001/XMLSchema-instance");
            SOAPBody bdy = env.getBody();
            bdy.addFault();
            SOAPFault fault = bdy.getFault();
            if (erroreValidazione) {
                fault.setFaultString("EGOV_IT_001 - Formato Busta non corretto");
                fault.setFaultCode("soap:Client");
            } else {
                fault.setFaultString("EGOV_IT_300 - Errore nel processamento del messaggio SPCoop");
                fault.setFaultCode("soap:Server");
            }
            if (!erroreValidazione && dettaglioEccezione != null) {
                fault.addDetail();
                Detail d = fault.getDetail();
                Element e = XMLUtils.newElement((byte[])org.openspcoop.dao.eccezione.driver.XMLUtils.generateDettaglioEccezione((DettaglioEccezione)dettaglioEccezione));
                d.addChildElement((SOAPElement)new MessageElement(e));
            }
            return msg;
        }
        catch (Exception e) {
            this.log.error((Object)("Build msgSPCoopErrore non riuscito: " + e.getMessage()));
            return new Message((Object)new AxisFault("ErroreProcessamento"));
        }
    }

    public String transformFaultCode(String code) {
        if (Configurazione.getConfigurazioneGenerazioneBusta().isGenerazioneBustaSPCoopErroreDetailsInformazioniGeneriche()) {
            if (code.startsWith("OPENSPCOOP_ORG_")) {
                ProprietaErroreApplicativo pErroreApplicativo = new ProprietaErroreApplicativo();
                pErroreApplicativo.setFaultAsGenericCode(true);
                return pErroreApplicativo.transformFaultCode(new String(code));
            }
            return code;
        }
        return code;
    }

    public String transformFaultMsg(String code, String msg) {
        if (Configurazione.getConfigurazioneGenerazioneBusta().isGenerazioneBustaSPCoopErroreDetailsInformazioniGeneriche()) {
            if (code.startsWith("OPENSPCOOP_ORG_")) {
                ProprietaErroreApplicativo pErroreApplicativo = new ProprietaErroreApplicativo();
                pErroreApplicativo.setFaultAsGenericCode(true);
                return pErroreApplicativo.transformFaultMsg(new String(code), new String(msg));
            }
            if (code.equals("EGOV_IT_300")) {
                if ("Servizio Applicativo non disponibile".equals(msg)) {
                    return msg;
                }
                return "Errore nel processamento del messaggio SPCoop";
            }
            return msg;
        }
        return msg;
    }

    public Message buildSPCoopSoapFault_processamento(IDSoggetto identitaPdD, String modulo, String codErrore, Exception eProcessamento) {
        return this.buildSPCoopSoapFault_processamento(identitaPdD, modulo, codErrore, null, eProcessamento);
    }

    public Message buildSPCoopSoapFault_processamento(IDSoggetto identitaPdD, String modulo, String codErrore, String prefixMsgErrore, Exception eProcessamento) {
        try {
            DettaglioEccezione dettaglioEccezione = null;
            if (Configurazione.getConfigurazioneGenerazioneBusta().isGenerazioneBustaSPCoopErroreProcessamentoWithDetails()) {
                String msgErrore = null;
                msgErrore = prefixMsgErrore == null ? (eProcessamento.getMessage() != null ? "ErroreProcessamento: " + eProcessamento.getMessage() : "ErroreProcessamento: " + eProcessamento.toString()) : (eProcessamento.getMessage() != null ? prefixMsgErrore + eProcessamento.getMessage() : prefixMsgErrore + eProcessamento.toString());
                dettaglioEccezione = this.buildDettaglioEccezione(identitaPdD, modulo, this.transformFaultCode(codErrore), this.transformFaultMsg(codErrore, msgErrore));
                this.gestioneDettaglioEccezioneProcessamento(eProcessamento, dettaglioEccezione);
            }
            return new Message((Object)SoapUtils.build_Soap_Fault((String)"EGOV_IT_300 - Errore nel processamento del messaggio SPCoop", null, (String)"soap:Server", dettaglioEccezione, (boolean)Configurazione.getConfigurazioneGenerazioneBusta().isGenerazioneBustaSPCoopErroreProcessamentoWithDetails()));
        }
        catch (Exception e) {
            return new Message((Object)new AxisFault("Errore buildSPCoopSoapFault_processamento(exception): " + e.getMessage()));
        }
    }

    public Message buildSPCoopSoapFault_processamento(IDSoggetto identitaPdD, String modulo, String codErrore, String msgErrore) {
        try {
            DettaglioEccezione dettaglioEccezione = null;
            if (Configurazione.getConfigurazioneGenerazioneBusta().isGenerazioneBustaSPCoopErroreProcessamentoWithDetails()) {
                dettaglioEccezione = this.buildDettaglioEccezione(identitaPdD, modulo, this.transformFaultCode(codErrore), this.transformFaultMsg(codErrore, msgErrore));
            }
            return new Message((Object)SoapUtils.build_Soap_Fault((String)"EGOV_IT_300 - Errore nel processamento del messaggio SPCoop", null, (String)"soap:Server", dettaglioEccezione, (boolean)Configurazione.getConfigurazioneGenerazioneBusta().isGenerazioneBustaSPCoopErroreProcessamentoWithDetails()));
        }
        catch (Exception e) {
            if (this.log != null) {
                this.log.error((Object)("Errore buildSPCoopSoapFault_processamento: " + e.getMessage()), (Throwable)e);
            }
            return new Message((Object)new AxisFault("Errore buildSPCoopSoapFault_processamento: " + e.getMessage()));
        }
    }

    public Message buildSPCoopSoapFault_intestazione(IDSoggetto identitaPdD, String modulo, String codErrore, String msgErrore) {
        try {
            DettaglioEccezione dettaglioEccezione = null;
            if (Configurazione.getConfigurazioneGenerazioneBusta().isGenerazioneBustaSPCoopErroreValidazioneWithDetails()) {
                dettaglioEccezione = this.buildDettaglioEccezione(identitaPdD, modulo, this.transformFaultCode(codErrore), this.transformFaultMsg(codErrore, msgErrore));
            }
            return new Message((Object)SoapUtils.build_Soap_Fault((String)"EGOV_IT_001 - Formato Busta non corretto", null, (String)"soap:Client", dettaglioEccezione, (boolean)Configurazione.getConfigurazioneGenerazioneBusta().isGenerazioneBustaSPCoopErroreValidazioneWithDetails()));
        }
        catch (Exception e) {
            if (this.log != null) {
                this.log.error((Object)("Errore buildSPCoopSoapFault_intestazione: " + e.getMessage()), (Throwable)e);
            }
            return new Message((Object)new AxisFault("Errore buildSPCoopSoapFault_intestazione: " + e.getMessage()));
        }
    }

    public DettaglioEccezione buildDettaglioEccezione(IDSoggetto identitaPdD, String modulo, String codErrore, String msgErrore) {
        DettaglioEccezione dettaglioEccezione = new DettaglioEccezione();
        dettaglioEccezione.setIdentificativoPorta(identitaPdD.getCodicePorta());
        dettaglioEccezione.setIdentificativoFunzione(modulo);
        dettaglioEccezione.setOraRegistrazione(DateManager.getDate());
        org.openspcoop.dao.eccezione.Eccezione eccezione = new org.openspcoop.dao.eccezione.Eccezione();
        eccezione.setCodice(codErrore);
        eccezione.setDescrizione(msgErrore);
        dettaglioEccezione.addEccezioni(eccezione);
        return dettaglioEccezione;
    }

    public DettaglioEccezione buildDettaglioEccezioneFromBusta(IDSoggetto identitaPdD, String modulo, String servizioApplicativoErogatore, Busta busta, Exception eProcessamento) {
        DettaglioEccezione dettaglioEccezione = new DettaglioEccezione();
        dettaglioEccezione.setOraRegistrazione(DateManager.getDate());
        dettaglioEccezione.setIdentificativoPorta(identitaPdD.getCodicePorta());
        dettaglioEccezione.setIdentificativoFunzione(modulo);
        for (int i = 0; i < busta.sizeListaEccezioni(); ++i) {
            Eccezione e = busta.getEccezione(i);
            org.openspcoop.dao.eccezione.Eccezione eccezione = new org.openspcoop.dao.eccezione.Eccezione();
            if (Configurazione.getConfigurazioneGenerazioneBusta().isGenerazioneBustaSPCoopErroreDetailsInformazioniGeneriche()) {
                eccezione.setCodice(this.transformFaultCode(e.getCodiceEccezione()));
                eccezione.setDescrizione(this.transformFaultMsg(e.getCodiceEccezione(), e.getPosizione()));
                eccezione.setRilevanza(e.getRilevanza());
                eccezione.setContestoCodifica("ErroreProcessamentoMessaggioSPCoop");
            } else {
                eccezione.setCodice(e.getCodiceEccezione());
                eccezione.setDescrizione(e.getPosizione());
                eccezione.setRilevanza(e.getRilevanza());
                eccezione.setContestoCodifica(e.getContestoCodifica());
            }
            dettaglioEccezione.addEccezioni(eccezione);
        }
        if (!Configurazione.getConfigurazioneGenerazioneBusta().isGenerazioneBustaSPCoopErroreDetailsInformazioniGeneriche() && servizioApplicativoErogatore != null) {
            Dettaglio detail = new Dettaglio();
            detail.setTipo("servizioApplicativo");
            detail.setBase(servizioApplicativoErogatore);
            dettaglioEccezione.addDettagli(detail);
        }
        this.gestioneDettaglioEccezioneProcessamento(eProcessamento, dettaglioEccezione);
        return dettaglioEccezione;
    }

    public void gestioneDettaglioEccezioneIntegrazione(Exception eProcessamento, DettaglioEccezione dettaglioEccezione, boolean generaInformazioniGeneriche) {
        this.gestioneDettaglioEccezioneProcessamento_engine(eProcessamento, dettaglioEccezione, Configurazione.isGenerazioneSOAPFaultIntegrazioneDetailsWithStackTrace(), generaInformazioniGeneriche);
    }

    public void gestioneDettaglioEccezioneProcessamento(Exception eProcessamento, DettaglioEccezione dettaglioEccezione) {
        this.gestioneDettaglioEccezioneProcessamento_engine(eProcessamento, dettaglioEccezione, Configurazione.getConfigurazioneGenerazioneBusta().isGenerazioneBustaSPCoopErroreDetailsWithStackTrace(), Configurazione.getConfigurazioneGenerazioneBusta().isGenerazioneBustaSPCoopErroreDetailsInformazioniGeneriche());
    }

    private void gestioneDettaglioEccezioneProcessamento_engine(Exception eProcessamento, DettaglioEccezione dettaglioEccezione, boolean generaStackTrace, boolean generaInformazioniGeneriche) {
        if (eProcessamento != null) {
            if (generaInformazioniGeneriche) {
                Dettaglio detail = new Dettaglio();
                detail.setTipo("causa");
                String msg = null;
                msg = eProcessamento.getMessage() != null ? eProcessamento.getMessage() : eProcessamento.toString();
                if ("Connection refused".equals(msg)) {
                    msg = "Connection refused";
                    detail.setBase(msg);
                    dettaglioEccezione.addDettagli(detail);
                } else if ("Read timed out".equals(msg)) {
                    msg = "Read timed out";
                    detail.setBase(msg);
                    dettaglioEccezione.addDettagli(detail);
                } else if ("connect timed out".equals(msg)) {
                    msg = "Connect timed out";
                    detail.setBase(msg);
                    dettaglioEccezione.addDettagli(detail);
                }
            } else {
                Dettaglio detail = new Dettaglio();
                detail.setTipo("causa");
                if (eProcessamento.getMessage() != null) {
                    detail.setBase(eProcessamento.getMessage());
                } else {
                    detail.setBase(eProcessamento.toString());
                }
                dettaglioEccezione.addDettagli(detail);
                if (eProcessamento.getCause() != null) {
                    this.gestioneDettaglioEccezioneProcessamento_engine_InnerException(eProcessamento.getCause(), dettaglioEccezione);
                }
                if (generaStackTrace) {
                    Dettaglio detailStackTrace = new Dettaglio();
                    detailStackTrace.setTipo("stackTrace");
                    ByteArrayOutputStream bout = new ByteArrayOutputStream();
                    PrintWriter pWriter = new PrintWriter(bout);
                    eProcessamento.printStackTrace(pWriter);
                    try {
                        bout.flush();
                        pWriter.flush();
                        pWriter.close();
                        bout.close();
                    }
                    catch (Exception eClose) {
                        System.err.println("ERRORE buildEccezioneProcessamentoFromBusta: " + eClose.getMessage());
                    }
                    detailStackTrace.setBase(bout.toString());
                    dettaglioEccezione.addDettagli(detailStackTrace);
                }
            }
        }
    }

    private void gestioneDettaglioEccezioneProcessamento_engine_InnerException(Throwable e, DettaglioEccezione dettaglioEccezione) {
        if (e != null) {
            Dettaglio detail = new Dettaglio();
            detail.setTipo("causato da");
            if (e.getMessage() != null) {
                detail.setBase(e.getMessage());
            } else {
                detail.setBase(e.toString());
            }
            dettaglioEccezione.addDettagli(detail);
            if (e.getCause() != null) {
                this.gestioneDettaglioEccezioneProcessamento_engine_InnerException(e.getCause(), dettaglioEccezione);
            }
        }
    }

    public void gestioneListaEccezioniMessaggioSPCoopErroreProcessamento(Busta busta) {
        if (!Configurazione.getConfigurazioneGenerazioneBusta().isGenerazioneBustaSPCoopErroreProcessamentoWithListaEccezioni()) {
            while (busta.sizeListaEccezioni() > 0) {
                Eccezione eccezione = busta.removeEccezione(0);
            }
        }
    }

    public Message msgErroreProcessamentoSPCoop(IDSoggetto identitaPdD, String modulo, Busta busta, Vector<Eccezione> errori, Hashtable<?, ?> wssPropertiesResponse, WSSBaseUtils baseWSS, long attesaAttiva, int checkInterval, String profiloGestione, String tipoTempo, boolean generazioneListaTrasmissioni, Exception eProcessamento) {
        return this.msgErroreProcessamentoSPCoop(identitaPdD, modulo, busta, null, null, errori, wssPropertiesResponse, baseWSS, attesaAttiva, checkInterval, profiloGestione, tipoTempo, generazioneListaTrasmissioni, eProcessamento);
    }

    public Message msgErroreProcessamentoSPCoop(IDSoggetto identitaPdD, String modulo, Busta busta, String msgErrore, String codErrore, Hashtable<?, ?> wssPropertiesResponse, WSSBaseUtils baseWSS, long attesaAttiva, int checkInterval, String profiloGestione, String tipoTempo, boolean generazioneListaTrasmissioni, Exception eProcessamento) {
        return this.msgErroreProcessamentoSPCoop(identitaPdD, modulo, busta, msgErrore, codErrore, null, wssPropertiesResponse, baseWSS, attesaAttiva, checkInterval, profiloGestione, tipoTempo, generazioneListaTrasmissioni, eProcessamento);
    }

    private Message msgErroreProcessamentoSPCoop(IDSoggetto identitaPdD, String modulo, Busta busta, String msgErrore, String codErrore, Vector<Eccezione> errori, Hashtable<?, ?> wssPropertiesResponse, WSSBaseUtils baseWSS, long attesaAttiva, int checkInterval, String profiloGestione, String tipoTempo, boolean generazioneListaTrasmissioni, Exception eProcessamento) {
        try {
            WSSSender wssSender;
            ArrayList<Trasmissione> listaTrasmissioniBustaRichiesta = new ArrayList<Trasmissione>();
            for (int i = 0; i < busta.sizeListaTrasmissioni(); ++i) {
                listaTrasmissioniBustaRichiesta.add(busta.getTrasmissione(i));
            }
            String id_eGovErrore = this.buildID_eGov(identitaPdD.getCodicePorta(), identitaPdD.getNome(), attesaAttiva, checkInterval);
            if (errori == null) {
                errori = new Vector();
            }
            if (msgErrore != null && codErrore != null) {
                Eccezione ecc = new Eccezione();
                ecc.setContestoCodifica(modulo + "_" + "ErroreProcessamentoMessaggioSPCoop");
                ecc.setCodiceEccezione("EGOV_IT_300");
                ecc.setRilevanza("GRAVE");
                ecc.setPosizione(msgErrore);
                errori.add(ecc);
            }
            busta = this.buildSPCoopErrore_Processamento(errori, busta, id_eGovErrore, tipoTempo);
            DettaglioEccezione dettaglioEccezione = null;
            if (Configurazione.getConfigurazioneGenerazioneBusta().isGenerazioneBustaSPCoopErroreProcessamentoWithDetails()) {
                dettaglioEccezione = this.buildDettaglioEccezioneFromBusta(identitaPdD, modulo, null, busta, eProcessamento);
            }
            this.gestioneListaEccezioniMessaggioSPCoopErroreProcessamento(busta);
            Message responseAxisMessage = this.buildAxisMsgSPCoopErrore_Processamento(dettaglioEccezione);
            if (generazioneListaTrasmissioni) {
                Trasmissione tras = new Trasmissione();
                tras.setOrigine(identitaPdD.getNome());
                tras.setTipoOrigine(identitaPdD.getTipo());
                for (int i = 0; i < listaTrasmissioniBustaRichiesta.size(); ++i) {
                    if (!identitaPdD.getTipo().equals(((Trasmissione)listaTrasmissioniBustaRichiesta.get(i)).getTipoDestinazione()) || !identitaPdD.getNome().equals(((Trasmissione)listaTrasmissioniBustaRichiesta.get(i)).getDestinazione())) continue;
                    tras.setDestinazione(((Trasmissione)listaTrasmissioniBustaRichiesta.get(i)).getOrigine());
                    tras.setTipoDestinazione(((Trasmissione)listaTrasmissioniBustaRichiesta.get(i)).getTipoOrigine());
                }
                tras.setOraRegistrazione(busta.getOraRegistrazione());
                tras.setTempo(busta.getTipoOraRegistrazione());
                busta.addTrasmissione(tras);
            }
            SOAPHeaderElement headerEGovElement = (SOAPHeaderElement)this.build_eGovHeader(busta);
            byte[] headerEGov = SoapUtils.msgElementoToByte((MessageElement)headerEGovElement);
            Document document = XMLUtils.newDocument((byte[])headerEGov);
            SOAPHeaderElement hdrEGov = new SOAPHeaderElement(document.getDocumentElement());
            javax.xml.soap.SOAPHeader hdr = responseAxisMessage.getSOAPHeader();
            if (hdr == null) {
                hdr = responseAxisMessage.getSOAPEnvelope().addHeader();
            }
            hdr.addChildElement((SOAPElement)hdrEGov);
            if (wssPropertiesResponse != null && wssPropertiesResponse.size() > 0 && !(wssSender = new WSSSender(wssPropertiesResponse, baseWSS)).process(responseAxisMessage)) {
                return this.msgErroreValidazioneSPCoop(identitaPdD, modulo, busta, wssSender.getMsgErrore(), wssSender.getCodiceErrore(), null, null, attesaAttiva, checkInterval, profiloGestione, tipoTempo, generazioneListaTrasmissioni);
            }
            return responseAxisMessage;
        }
        catch (Exception e) {
            this.log.error((Object)("Build msgSPCoopErroreProcessamento non riuscito: " + e.getMessage()));
            return new Message((Object)new AxisFault("ErroreProcessamento"));
        }
    }

    public Message msgErroreValidazioneSPCoop(IDSoggetto identitaPdD, String modulo, Busta busta, Vector<Eccezione> errori, Hashtable<?, ?> wssPropertiesResponse, WSSBaseUtils baseWSS, long attesaAttiva, int checkInterval, String profiloGestione, String tipoTempo, boolean generazioneListaTrasmissioni) {
        return this.msgErroreValidazioneSPCoop(identitaPdD, modulo, busta, null, null, errori, wssPropertiesResponse, baseWSS, attesaAttiva, checkInterval, profiloGestione, tipoTempo, generazioneListaTrasmissioni);
    }

    public Message msgErroreValidazioneSPCoop(IDSoggetto identitaPdD, String modulo, Busta busta, String msgErrore, String codErrore, Hashtable<?, ?> wssPropertiesResponse, WSSBaseUtils baseWSS, long attesaAttiva, int checkInterval, String profiloGestione, String tipoTempo, boolean generazioneListaTrasmissioni) {
        return this.msgErroreValidazioneSPCoop(identitaPdD, modulo, busta, msgErrore, codErrore, null, wssPropertiesResponse, baseWSS, attesaAttiva, checkInterval, profiloGestione, tipoTempo, generazioneListaTrasmissioni);
    }

    public Message msgErroreValidazioneSPCoop(IDSoggetto identitaPdD, String modulo, Busta busta, String msgErrore, String codErrore, Vector<Eccezione> errori, Hashtable<?, ?> wssPropertiesResponse, WSSBaseUtils baseWSS, long attesaAttiva, int checkInterval, String profiloGestione, String tipoTempo, boolean generazioneListaTrasmissioni) {
        try {
            WSSSender wssSender;
            ArrayList<Trasmissione> listaTrasmissioniBustaRichiesta = new ArrayList<Trasmissione>();
            for (int i = 0; i < busta.sizeListaTrasmissioni(); ++i) {
                listaTrasmissioniBustaRichiesta.add(busta.getTrasmissione(i));
            }
            String id_eGovErrore = this.buildID_eGov(identitaPdD.getCodicePorta(), identitaPdD.getNome(), attesaAttiva, checkInterval);
            if (errori == null) {
                errori = new Vector();
            }
            if (msgErrore != null && codErrore != null) {
                Eccezione ecc = new Eccezione();
                ecc.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                ecc.setCodiceEccezione(codErrore);
                ecc.setRilevanza("GRAVE");
                ecc.setPosizione(msgErrore);
                errori.add(ecc);
            }
            busta = this.buildSPCoopErrore_Validazione(errori, busta, id_eGovErrore, tipoTempo);
            Message responseAxisMessage = this.buildAxisMsgSPCoopErrore_Validazione();
            if (generazioneListaTrasmissioni) {
                Trasmissione tras = new Trasmissione();
                tras.setOrigine(identitaPdD.getNome());
                tras.setTipoOrigine(identitaPdD.getTipo());
                for (int i = 0; i < listaTrasmissioniBustaRichiesta.size(); ++i) {
                    if (!identitaPdD.getTipo().equals(((Trasmissione)listaTrasmissioniBustaRichiesta.get(i)).getTipoDestinazione()) || !identitaPdD.getNome().equals(((Trasmissione)listaTrasmissioniBustaRichiesta.get(i)).getDestinazione())) continue;
                    tras.setDestinazione(((Trasmissione)listaTrasmissioniBustaRichiesta.get(i)).getOrigine());
                    tras.setTipoDestinazione(((Trasmissione)listaTrasmissioniBustaRichiesta.get(i)).getTipoOrigine());
                }
                tras.setOraRegistrazione(busta.getOraRegistrazione());
                tras.setTempo(busta.getTipoOraRegistrazione());
                busta.addTrasmissione(tras);
            }
            SOAPHeaderElement headerEGovElement = (SOAPHeaderElement)this.build_eGovHeader(busta);
            byte[] headerEGov = SoapUtils.msgElementoToByte((MessageElement)headerEGovElement);
            Document document = XMLUtils.newDocument((byte[])headerEGov);
            SOAPHeaderElement hdrEGov = new SOAPHeaderElement(document.getDocumentElement());
            javax.xml.soap.SOAPHeader hdr = responseAxisMessage.getSOAPHeader();
            if (hdr == null) {
                hdr = responseAxisMessage.getSOAPEnvelope().addHeader();
            }
            hdr.addChildElement((SOAPElement)hdrEGov);
            if (wssPropertiesResponse != null && wssPropertiesResponse.size() > 0 && !(wssSender = new WSSSender(wssPropertiesResponse, baseWSS)).process(responseAxisMessage)) {
                return this.msgErroreValidazioneSPCoop(identitaPdD, modulo, busta, wssSender.getMsgErrore(), wssSender.getCodiceErrore(), null, null, attesaAttiva, checkInterval, profiloGestione, tipoTempo, generazioneListaTrasmissioni);
            }
            return responseAxisMessage;
        }
        catch (Exception e) {
            this.log.error((Object)("Build msgSPCoopErroreValidazione non riuscito: " + e.getMessage()));
            return new Message((Object)new AxisFault("ErroreProcessamento"));
        }
    }

    @Deprecated
    public String eraserType(String patch) throws EGovException {
        try {
            StringBuffer soapEnvelopePatch = new StringBuffer();
            int start = patch.indexOf("<eGov_IT:Intestazione");
            int end = patch.indexOf("</eGov_IT:Intestazione>") + "</eGov_IT:Intestazione>".length();
            soapEnvelopePatch.append(patch.substring(0, start));
            String header = patch.substring(start, end);
            header = header.replaceAll("xsi:type", "");
            header = header.replaceAll("=\"xsd", "");
            header = header.replaceAll(":string\"", "");
            header = header.replaceAll(":dateTime\"", "");
            soapEnvelopePatch.append(header);
            soapEnvelopePatch.append(patch.substring(end));
            return soapEnvelopePatch.toString();
        }
        catch (Exception e) {
            this.log.error((Object)("ImbustamentoEGov.eraserType_byte non riuscito: " + e.getMessage()), (Throwable)e);
            throw new EGovException("ImbustamentoEGov.eraserType_byte non riuscito: " + e.getMessage(), e);
        }
    }

    @Deprecated
    public byte[] eraserType(byte[] xml) throws EGovException {
        ByteArrayOutputStream cleanEGov = null;
        try {
            int i;
            String header = new String(xml);
            int start = header.indexOf("<eGov_IT:Intestazione");
            int end = header.indexOf("</eGov_IT:Intestazione>") + "</eGov_IT:Intestazione>".length();
            if (start == -1) {
                return null;
            }
            if (end == -1) {
                return null;
            }
            if (end <= start) {
                return null;
            }
            String eraserString = " xsi:type=\"xsd:string\"";
            String eraserDate = " xsi:type=\"xsd:dateTime\"";
            cleanEGov = new ByteArrayOutputStream();
            for (i = 0; i < start; ++i) {
                cleanEGov.write(xml[i]);
            }
            i = start;
            while (i < end) {
                if (xml[i] == 32) {
                    int k;
                    StringBuffer test;
                    if (i + eraserDate.length() < end) {
                        test = new StringBuffer();
                        for (k = 0; k < eraserDate.length(); ++k) {
                            test.append((char)xml[i + k]);
                        }
                        if (test.toString().equals(eraserDate)) {
                            i += eraserDate.length();
                            continue;
                        }
                    }
                    if (i + eraserString.length() < end) {
                        test = new StringBuffer();
                        for (k = 0; k < eraserString.length(); ++k) {
                            test.append((char)xml[i + k]);
                        }
                        if (test.toString().equals(eraserString)) {
                            i += eraserString.length();
                            continue;
                        }
                    }
                    cleanEGov.write(xml[i]);
                    ++i;
                    continue;
                }
                cleanEGov.write(xml[i]);
                ++i;
            }
            for (i = end; i < xml.length; ++i) {
                cleanEGov.write(xml[i]);
            }
            byte[] cleanBytes = cleanEGov.toByteArray();
            cleanEGov.close();
            return cleanBytes;
        }
        catch (Exception e) {
            try {
                if (cleanEGov != null) {
                    cleanEGov.close();
                }
            }
            catch (Exception eis) {
                // empty catch block
            }
            this.log.error((Object)("ImbustamentoEGov.eraserType_byte non riuscito: " + e.getMessage()), (Throwable)e);
            throw new EGovException("ImbustamentoEGov.eraserType_byte non riuscito: " + e.getMessage(), e);
        }
    }
}

