/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.egov;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import org.apache.log4j.Logger;
import org.openspcoop.dao.state.IState;
import org.openspcoop.dao.state.StateMessage;
import org.openspcoop.dao.state.StatefulMessage;
import org.openspcoop.egov.Configurazione;
import org.openspcoop.egov.EGovException;
import org.openspcoop.egov.IGestoreRepositoryEGov;

public class History {
    private Logger log = null;
    private IState state;
    private IGestoreRepositoryEGov gestoreRepositoryEGov;

    public History(IState state) {
        this(state, Configurazione.getLibraryLog());
    }

    public History(IState state, Logger alog) {
        this.state = state;
        this.gestoreRepositoryEGov = Configurazione.getGestoreRepositoryEGov();
        this.log = alog != null ? alog : Logger.getLogger((String)History.class.getName());
    }

    public void registraBustaInviata(String idEGov) throws EGovException {
        this.registraBusta(idEGov, "OUTBOX");
    }

    public void eliminaBustaInviata(String idEGov) throws EGovException {
        this.eliminaBusta(idEGov, "OUTBOX");
    }

    public void eliminaBustaInviataPerRiscontri(String idEGov) throws EGovException {
        this.eliminaBustaPerRiscontri(idEGov, "OUTBOX");
    }

    public void registraBustaRicevuta(String idEGov) throws EGovException {
        this.registraBusta(idEGov, "INBOX");
    }

    public void eliminaBustaRicevuta(String idEGov) throws EGovException {
        this.eliminaBusta(idEGov, "INBOX");
    }

    public void eliminaBustaRicevutaPerRiscontri(String idEGov) throws EGovException {
        this.eliminaBustaPerRiscontri(idEGov, "INBOX");
    }

    public boolean bustaRicevutaPrecedentemente(String idEGov) throws EGovException {
        StateMessage stateMSG = (StateMessage)this.state;
        Connection connectionDB = stateMSG.getConnectionDB();
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            StringBuffer query = new StringBuffer();
            query.append("select ID_EGOV from ");
            query.append("REPOSITORY_EGOV");
            query.append(" WHERE ID_EGOV = ? AND TIPO=? AND ");
            query.append(this.gestoreRepositoryEGov.createSQLCondition_History(true));
            pstmt = connectionDB.prepareStatement(query.toString());
            pstmt.setString(1, idEGov);
            pstmt.setString(2, "INBOX");
            rs = pstmt.executeQuery();
            if (rs != null) {
                if (rs.next()) {
                    rs.close();
                    pstmt.close();
                    return true;
                }
                rs.close();
                pstmt.close();
                return false;
            }
            pstmt.close();
            return false;
        }
        catch (Exception e) {
            String errorMsg = "HISTORY_BUSTE, Errore durante il check bustaRicevutaPrecedentemente " + idEGov + ": " + e.getMessage();
            this.log.error((Object)errorMsg, (Throwable)e);
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            throw new EGovException(errorMsg, e);
        }
    }

    public void registraBusta(String idEGov, String tipoBusta) throws EGovException {
        StateMessage stateMSG = (StateMessage)this.state;
        Connection connectionDB = stateMSG.getConnectionDB();
        Statement pstmtUpdate = null;
        try {
            StringBuffer queryUpdate = new StringBuffer();
            queryUpdate.append("UPDATE ");
            queryUpdate.append("REPOSITORY_EGOV");
            queryUpdate.append(" SET ");
            queryUpdate.append(this.gestoreRepositoryEGov.createSQLSet_History(true));
            queryUpdate.append(" WHERE  ID_EGOV = ? AND TIPO=?");
            pstmtUpdate = connectionDB.prepareStatement(queryUpdate.toString());
            pstmtUpdate.setString(1, idEGov);
            pstmtUpdate.setString(2, tipoBusta);
            stateMSG.getPreparedStatement().put("UPDATE saveBustaForHistory" + tipoBusta + "_" + idEGov, (PreparedStatement)pstmtUpdate);
        }
        catch (Exception e) {
            String errorMsg = "HISTORY_BUSTE, Errore di registrazione " + tipoBusta + "/" + idEGov + ": " + e.getMessage();
            this.log.error((Object)errorMsg, (Throwable)e);
            try {
                if (pstmtUpdate != null) {
                    pstmtUpdate.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            throw new EGovException(errorMsg, e);
        }
    }

    public void eliminaBusta(String idEGov, String tipoBusta) throws EGovException {
        this.eliminaBusta(idEGov, tipoBusta, false);
    }

    public void eliminaBusta(String idEGov, String tipoBusta, boolean forzaEliminazioneDb) throws EGovException {
        if (this.state instanceof StatefulMessage || forzaEliminazioneDb) {
            StateMessage state = (StateMessage)this.state;
            Connection connectionDB = state.getConnectionDB();
            Statement pstmtUpdate = null;
            try {
                StringBuffer queryUpdate = new StringBuffer();
                queryUpdate.append("UPDATE ");
                queryUpdate.append("REPOSITORY_EGOV");
                queryUpdate.append(" SET ");
                queryUpdate.append(this.gestoreRepositoryEGov.createSQLSet_History(false));
                queryUpdate.append(" WHERE  ID_EGOV = ? AND TIPO=?");
                pstmtUpdate = connectionDB.prepareStatement(queryUpdate.toString());
                pstmtUpdate.setString(1, idEGov);
                pstmtUpdate.setString(2, tipoBusta);
                state.getPreparedStatement().put("UPDATE eliminaBustaForHistory" + tipoBusta + "_" + idEGov, (PreparedStatement)pstmtUpdate);
            }
            catch (Exception e) {
                String errorMsg = "HISTORY_BUSTE, Errore di cancellazione " + tipoBusta + "/" + idEGov + ": " + e.getMessage();
                this.log.error((Object)errorMsg, (Throwable)e);
                try {
                    if (pstmtUpdate != null) {
                        pstmtUpdate.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                throw new EGovException(errorMsg, e);
            }
        }
        throw new EGovException("Metodo non invocabile in modalita' stateless");
    }

    public void eliminaBustaPerRiscontri(String idEGov, String tipoBusta) throws EGovException {
        StateMessage stateMSG = (StateMessage)this.state;
        Connection connectionDB = stateMSG.getConnectionDB();
        Statement pstmtUpdate = null;
        try {
            StringBuffer queryUpdate = new StringBuffer();
            queryUpdate.append("UPDATE ");
            queryUpdate.append("REPOSITORY_EGOV");
            queryUpdate.append(" SET ");
            queryUpdate.append(this.gestoreRepositoryEGov.createSQLSet_History(false));
            queryUpdate.append(" WHERE  ID_EGOV = ? AND TIPO=?");
            pstmtUpdate = connectionDB.prepareStatement(queryUpdate.toString());
            pstmtUpdate.setString(1, idEGov);
            pstmtUpdate.setString(2, tipoBusta);
            stateMSG.getPreparedStatement().put("UPDATE eliminaBustaForHistory" + tipoBusta + "_" + idEGov, (PreparedStatement)pstmtUpdate);
        }
        catch (Exception e) {
            String errorMsg = "HISTORY_BUSTE, Errore di cancellazione " + tipoBusta + "/" + idEGov + ": " + e.getMessage();
            this.log.error((Object)errorMsg, (Throwable)e);
            try {
                if (pstmtUpdate != null) {
                    pstmtUpdate.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            throw new EGovException(errorMsg, e);
        }
    }
}

