/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.egov;

import org.openspcoop.egov.Busta;
import org.openspcoop.egov.EGovException;
import org.openspcoop.egov.History;
import org.openspcoop.egov.IFiltroDuplicati;
import org.openspcoop.egov.RepositoryEGov;

public class FiltroDuplicati
implements IFiltroDuplicati {
    private History historyBuste;
    private RepositoryEGov repositoryEGov;
    private boolean gestioneStateless;
    private long repositoryIntervalloScadenzaMessaggi;

    public void init(Object context) throws EGovException {
    }

    public boolean isDuplicata(String idEGov) throws EGovException {
        return this.historyBuste.bustaRicevutaPrecedentemente(idEGov);
    }

    public void incrementaNumeroDuplicati(String idEGov) throws EGovException {
        this.repositoryEGov.aggiornaDuplicatiIntoInBox(idEGov);
    }

    public void registraBusta(Busta busta) throws EGovException {
        if (this.gestioneStateless) {
            if (!this.repositoryEGov.isRegistrataIntoInBox(busta.getID())) {
                this.repositoryEGov.registraBustaIntoInboxForHistory(busta, this.repositoryIntervalloScadenzaMessaggi);
            }
        } else {
            this.historyBuste.registraBustaRicevuta(busta.getID());
        }
    }

    public void setHistoryBuste(History historyBuste) {
        this.historyBuste = historyBuste;
    }

    public void setRepositoryEGov(RepositoryEGov repositoryEGov) {
        this.repositoryEGov = repositoryEGov;
    }

    public void setGestioneStateless(boolean stateless) {
        this.gestioneStateless = stateless;
    }

    public void setRepositoryIntervalloScadenzaMessaggi(long repositoryIntervalloScadenzaMessaggi) {
        this.repositoryIntervalloScadenzaMessaggi = repositoryIntervalloScadenzaMessaggi;
    }
}

