/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.writer.govway.utils;

import it.link.pdd.tools.migrazione_govway.writer.govway.utils.ConverterHttpServletRequestWrapper;
import it.link.pdd.tools.migrazione_govway.writer.govway.utils.ConverterHttpServletResponseWrapper;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.logger.ILogger;
import org.openspcoop2.utils.logger.LoggerFactory;
import org.openspcoop2.utils.logger.beans.context.core.AbstractContext;
import org.openspcoop2.utils.logger.beans.context.core.AbstractTransactionWithClient;
import org.openspcoop2.utils.logger.beans.context.core.Operation;
import org.openspcoop2.utils.logger.beans.context.core.Service;
import org.openspcoop2.utils.service.context.IContext;
import org.openspcoop2.utils.service.logger.ServiceLogger;
import org.slf4j.Logger;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.SimpleGrantedAuthority;

public class ConverterContext
implements IContext {
    private HttpServletRequest servletRequest = new ConverterHttpServletRequestWrapper();
    private HttpServletResponse servletResponse = new ConverterHttpServletResponseWrapper();
    private UriInfo uriInfo;
    private String transactionId;
    private String className;
    private String methodName;
    private String restPath;
    private AbstractContext applicationContext;
    private ILogger applicationLogger;
    private ServiceLogger logger;
    private Authentication authentication;

    public ConverterContext(Logger log) throws UtilsException {
        ILogger logger = LoggerFactory.newLogger();
        logger.initLogger();
        this.applicationLogger = logger;
        this.applicationContext = (AbstractContext)this.applicationLogger.getContext();
        this.transactionId = this.applicationContext.getIdTransaction();
        if (this.transactionId == null) {
            throw new UtilsException("TransactionId undefined");
        }
        ArrayList<SimpleGrantedAuthority> authorities = new ArrayList<SimpleGrantedAuthority>();
        SimpleGrantedAuthority grant = new SimpleGrantedAuthority("configuratore");
        authorities.add(grant);
        this.authentication = new AnonymousAuthenticationToken("converter", (Object)"amministratore", authorities);
        int level = 1;
        StackTraceElement[] stackTrace = new Throwable().getStackTrace();
        if (stackTrace != null && stackTrace.length >= level + 1) {
            this.className = stackTrace[level].getClassName();
            this.methodName = stackTrace[level].getMethodName();
        }
        this.logger = new ServiceLogger(this.transactionId, this.methodName, this.className, log, true);
        AbstractTransactionWithClient transaction = (AbstractTransactionWithClient)this.applicationContext.getTransaction();
        if (this.className != null) {
            if (transaction.getService() == null) {
                transaction.setService(new Service());
            }
            if (transaction.getService().getName() == null) {
                if (this.className.lastIndexOf(".") > 0) {
                    transaction.getService().setName(this.className.substring(this.className.lastIndexOf(".") + 1, this.className.length()));
                } else {
                    transaction.getService().setName(this.className);
                }
            }
        }
        if (this.methodName != null) {
            if (transaction.getOperation() == null) {
                transaction.setOperation(new Operation());
            }
            transaction.getOperation().setName(this.methodName);
        }
        this.uriInfo = new UriInfo(){

            public URI resolve(URI arg0) {
                return null;
            }

            public URI relativize(URI arg0) {
                return null;
            }

            public UriBuilder getRequestUriBuilder() {
                return null;
            }

            public URI getRequestUri() {
                return null;
            }

            public MultivaluedMap<String, String> getQueryParameters(boolean arg0) {
                return null;
            }

            public MultivaluedMap<String, String> getQueryParameters() {
                return null;
            }

            public List<PathSegment> getPathSegments(boolean arg0) {
                return null;
            }

            public List<PathSegment> getPathSegments() {
                return null;
            }

            public MultivaluedMap<String, String> getPathParameters(boolean arg0) {
                return null;
            }

            public MultivaluedMap<String, String> getPathParameters() {
                return null;
            }

            public String getPath(boolean arg0) {
                return "/migratore-govway/";
            }

            public String getPath() {
                return "/migratore-govway/";
            }

            public List<String> getMatchedURIs(boolean arg0) {
                return null;
            }

            public List<String> getMatchedURIs() {
                return null;
            }

            public List<Object> getMatchedResources() {
                return null;
            }

            public UriBuilder getBaseUriBuilder() {
                return null;
            }

            public URI getBaseUri() {
                return null;
            }

            public UriBuilder getAbsolutePathBuilder() {
                return null;
            }

            public URI getAbsolutePath() {
                return null;
            }
        };
    }

    public void setRestPath(String restPath) {
        this.restPath = restPath;
    }

    public HttpServletRequest getServletRequest() {
        return this.servletRequest;
    }

    public HttpServletResponse getServletResponse() {
        return this.servletResponse;
    }

    public UriInfo getUriInfo() {
        return this.uriInfo;
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public String getClassName() {
        return this.className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getRestPath() {
        return this.restPath;
    }

    public AbstractContext getApplicationContext() {
        return this.applicationContext;
    }

    public ILogger getApplicationLogger() throws UtilsException {
        return this.applicationLogger;
    }

    public ServiceLogger getLogger() {
        return this.logger;
    }

    public Authentication getAuthentication() {
        return this.authentication;
    }
}

