/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.writer.govway;

import it.link.pdd.tools.migrazione_govway.drivers.DriverConfigurazioneServiziGovway;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDPortaApplicativaByNome;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDPortaDelegata;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDServizioApplicativo;
import it.link.pdd.tools.migrazione_govway.properties.DatabaseProperties;
import it.link.pdd.tools.migrazione_govway.properties.MigrazioneProperties;
import it.link.pdd.tools.migrazione_govway.wrapper.govway.ApiWrapper;
import it.link.pdd.tools.migrazione_govway.wrapper.govway.ApplicativoWrapper;
import it.link.pdd.tools.migrazione_govway.wrapper.govway.ErogazioneWrapper;
import it.link.pdd.tools.migrazione_govway.wrapper.govway.FruizioneWrapper;
import it.link.pdd.tools.migrazione_govway.wrapper.govway.InputWrapper;
import it.link.pdd.tools.migrazione_govway.wrapper.govway.MultitenantConfigurazione;
import it.link.pdd.tools.migrazione_govway.wrapper.govway.SoggettoWrapper;
import it.link.pdd.tools.migrazione_govway.wrapper.govway.Warnings;
import it.link.pdd.tools.migrazione_govway.writer.AbstractOpenspcoop2Writer;
import it.link.pdd.tools.migrazione_govway.writer.govway.utils.ConverterContext;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.sql.ConnectionPoolDataSource;
import javax.ws.rs.WebApplicationException;
import org.apache.commons.dbcp2.cpdsadapter.DriverAdapterCPDS;
import org.apache.commons.dbcp2.datasources.SharedPoolDataSource;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.core.config.rs.server.api.ApiApi;
import org.openspcoop2.core.config.rs.server.api.ApplicativiApi;
import org.openspcoop2.core.config.rs.server.api.ErogazioniApi;
import org.openspcoop2.core.config.rs.server.api.ErogazioniConfigurazioneApi;
import org.openspcoop2.core.config.rs.server.api.ErogazioniGruppiApi;
import org.openspcoop2.core.config.rs.server.api.FruizioniApi;
import org.openspcoop2.core.config.rs.server.api.FruizioniConfigurazioneApi;
import org.openspcoop2.core.config.rs.server.api.FruizioniGruppiApi;
import org.openspcoop2.core.config.rs.server.api.RuoliApi;
import org.openspcoop2.core.config.rs.server.api.SoggettiApi;
import org.openspcoop2.core.config.rs.server.api.impl.api.ApiApiServiceImpl;
import org.openspcoop2.core.config.rs.server.api.impl.applicativi.ApplicativiApiServiceImpl;
import org.openspcoop2.core.config.rs.server.api.impl.erogazioni.ErogazioniApiServiceImpl;
import org.openspcoop2.core.config.rs.server.api.impl.erogazioni.configurazione.ErogazioniConfigurazioneApiServiceImpl;
import org.openspcoop2.core.config.rs.server.api.impl.erogazioni.gruppi.ErogazioniGruppiApiServiceImpl;
import org.openspcoop2.core.config.rs.server.api.impl.fruizioni.FruizioniApiServiceImpl;
import org.openspcoop2.core.config.rs.server.api.impl.fruizioni.configurazione.FruizioniConfigurazioneApiServiceImpl;
import org.openspcoop2.core.config.rs.server.api.impl.fruizioni.gruppi.FruizioniGruppiApiServiceImpl;
import org.openspcoop2.core.config.rs.server.api.impl.ruoli.RuoliApiServiceImpl;
import org.openspcoop2.core.config.rs.server.api.impl.soggetti.SoggettiApiServiceImpl;
import org.openspcoop2.core.config.rs.server.config.Startup;
import org.openspcoop2.core.config.rs.server.model.ApiAllegato;
import org.openspcoop2.core.config.rs.server.model.ApiAllegatoGenerico;
import org.openspcoop2.core.config.rs.server.model.ApiAllegatoSpecificaSemiformale;
import org.openspcoop2.core.config.rs.server.model.ApiAzione;
import org.openspcoop2.core.config.rs.server.model.ApiImplAllegato;
import org.openspcoop2.core.config.rs.server.model.ApiImplAllegatoGenerico;
import org.openspcoop2.core.config.rs.server.model.ApiImplAllegatoSpecificaLivelloServizio;
import org.openspcoop2.core.config.rs.server.model.ApiImplAllegatoSpecificaSemiformale;
import org.openspcoop2.core.config.rs.server.model.ApiImplAllegatoSpecificaSicurezza;
import org.openspcoop2.core.config.rs.server.model.ApiImplStato;
import org.openspcoop2.core.config.rs.server.model.ApiImplUrlInvocazioneView;
import org.openspcoop2.core.config.rs.server.model.ApiServizio;
import org.openspcoop2.core.config.rs.server.model.ControlloAccessiAutorizzazioneApplicativo;
import org.openspcoop2.core.config.rs.server.model.ControlloAccessiAutorizzazioneSoggetto;
import org.openspcoop2.core.config.rs.server.model.CorrelazioneApplicativaRichiesta;
import org.openspcoop2.core.config.rs.server.model.CorrelazioneApplicativaRisposta;
import org.openspcoop2.core.config.rs.server.model.DominioEnum;
import org.openspcoop2.core.config.rs.server.model.Gruppo;
import org.openspcoop2.core.config.rs.server.model.GruppoEreditaConfigurazione;
import org.openspcoop2.core.config.rs.server.model.ModalitaAccessoEnum;
import org.openspcoop2.core.config.rs.server.model.ModalitaConfigurazioneGruppoEnum;
import org.openspcoop2.core.config.rs.server.model.OneOfGruppoConfigurazione;
import org.openspcoop2.core.config.rs.server.model.Ruolo;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.driver.IDServizioFactory;
import org.openspcoop2.utils.service.beans.ProfiloEnum;
import org.openspcoop2.utils.service.context.ContextThreadLocal;
import org.openspcoop2.utils.service.context.IContext;
import org.openspcoop2.utils.service.fault.jaxrs.ProblemRFC7807;
import org.slf4j.Logger;

public class ConfigurazioneServiziWriter
extends AbstractOpenspcoop2Writer {
    private long idAppender;
    private String bindNameOriginal;
    private String bindName;
    private ApiApi api;
    private RuoliApi ruoli;
    private ApplicativiApi applicativi;
    private SoggettiApi soggetti;
    private ErogazioniApi erogazioni;
    private ErogazioniConfigurazioneApi erogazioniConfigurazione;
    private ErogazioniGruppiApi erogazioniGruppi;
    private FruizioniApi fruizioni;
    private FruizioniConfigurazioneApi fruizioniConfigurazione;
    private FruizioniGruppiApi fruizioniGruppi;
    private DriverConfigurazioneServiziGovway driverAvanzato;
    private Logger infoLogger;
    private static final int OFFSET = 5;

    public ConfigurazioneServiziWriter(DatabaseProperties init, Logger log, Logger driverLogger) throws Exception {
        super(driverLogger);
        try {
            this.infoLogger = log;
            this.dsMode = init.isDataSourceMode();
            Properties prop = new Properties();
            InputStream resourceAsStream = ConfigurazioneServiziWriter.class.getResourceAsStream("/rs-api-config.datasource.properties");
            if (resourceAsStream == null) {
                throw new Exception("File rs-api-config.datasource.properties non trovato nel classpath");
            }
            prop.load(resourceAsStream);
            String property = prop.getProperty("db.dataSource");
            if (property == null) {
                throw new Exception("Property db.dataSource non trovata");
            }
            this.bindName = property.trim();
            if (!this.dsMode) {
                DriverAdapterCPDS cpds = new DriverAdapterCPDS();
                cpds.setDriver(init.getDriverJDBC());
                cpds.setUrl(init.getConnectionURL());
                cpds.setUser(init.getUsername());
                cpds.setPassword(init.getPassword());
                SharedPoolDataSource dataSource = new SharedPoolDataSource();
                dataSource.setConnectionPoolDataSource((ConnectionPoolDataSource)cpds);
                dataSource.setMaxTotal(5);
                Properties p = new Properties();
                p.setProperty("java.naming.factory.initial", "org.apache.naming.java.javaURLContextFactory");
                p.setProperty("java.naming.factory.url.pkgs", "org.apache.naming");
                InitialContext ic = new InitialContext(p);
                ic.createSubcontext("java:");
                ic.bind(this.bindName, (Object)dataSource);
                Class.forName(init.getDriverJDBC());
                this.connection = dataSource.getConnection();
                this.performUpdatesOnInit();
                Startup.initLog();
                Startup.initResources();
                ContextThreadLocal.set((IContext)new ConverterContext(driverLogger));
                this.soggetti = new SoggettiApiServiceImpl();
                this.ruoli = new RuoliApiServiceImpl();
                this.api = new ApiApiServiceImpl();
                this.applicativi = new ApplicativiApiServiceImpl();
                this.fruizioni = new FruizioniApiServiceImpl();
                this.fruizioniConfigurazione = new FruizioniConfigurazioneApiServiceImpl();
                this.fruizioniGruppi = new FruizioniGruppiApiServiceImpl();
                this.erogazioni = new ErogazioniApiServiceImpl();
                this.erogazioniConfigurazione = new ErogazioniConfigurazioneApiServiceImpl();
                this.erogazioniGruppi = new ErogazioniGruppiApiServiceImpl();
                this.driverAvanzato = new DriverConfigurazioneServiziGovway(this.connection, driverLogger, init.getTipoDatabase());
            }
        }
        catch (Exception e) {
            log.error("Impossibile inizializzare il driver del database OpenSPCoop2 di destinazione: " + e.getMessage(), (Throwable)e);
            throw new Exception("Impossibile inizializzare il driver del database OpenSPCoop2 di destinazione: " + e.getMessage(), e);
        }
    }

    private void performUpdatesOnInit() throws Exception {
        PreparedStatement ps = null;
        ResultSet rs = null;
        Connection con = this.connection;
        ps = con.prepareStatement("select id from audit_appender where class=?");
        ps.setString(1, "org.openspcoop2.web.lib.audit.appender.AuditDBAppender");
        rs = ps.executeQuery();
        if (rs.next()) {
            this.idAppender = rs.getLong("id");
        }
        rs.close();
        ps.close();
        this.log.debug("id Appender : " + this.idAppender);
        if (this.idAppender > 0L) {
            ps = con.prepareStatement("select value from audit_appender_prop where id_audit_appender=? and name ='datasource'");
            ps.setLong(1, this.idAppender);
            rs = ps.executeQuery();
            if (rs.next()) {
                this.bindNameOriginal = rs.getString("value");
            }
            rs.close();
            ps.close();
            this.log.debug("bindName [" + this.bindName + "] bindNameOriginal [" + this.bindNameOriginal + "]");
            if (this.bindNameOriginal != null && !this.bindNameOriginal.equals(this.bindName)) {
                String sql = "update audit_appender_prop set value = ? where id_audit_appender=? and name ='datasource'";
                this.log.debug("eseguo update: " + sql + "bindName [" + this.bindName + "] bindNameOriginal [" + this.bindNameOriginal + "]");
                ps = con.prepareStatement(sql);
                ps.setString(1, this.bindName);
                ps.setLong(2, this.idAppender);
                ps.executeUpdate();
                ps.close();
            }
            ps = con.prepareStatement("insert into audit_appender_prop (id_audit_appender,name,value) VALUES (?,?,?)");
            ps.setLong(1, this.idAppender);
            ps.setString(2, "context-java.naming.factory.initial");
            ps.setString(3, "org.apache.naming.java.javaURLContextFactory");
            ps.executeUpdate();
            ps.close();
            ps = con.prepareStatement("insert into audit_appender_prop (id_audit_appender,name,value) VALUES (?,?,?)");
            ps.setLong(1, this.idAppender);
            ps.setString(2, "context-java.naming.factory.url.pkgs");
            ps.setString(3, "org.apache.naming");
            ps.executeUpdate();
            ps.close();
        }
    }

    public void updateMultitenantConf(MultitenantConfigurazione conf) throws Exception {
        block7: {
            ProfiloEnum profilo = null;
            String q = null;
            Integer limit = null;
            Integer offset = null;
            DominioEnum dominio = DominioEnum.INTERNO;
            String ruolo = null;
            ModalitaAccessoEnum tipoCredenziali = null;
            Boolean profiloQualsiasi = null;
            int numSoggettiGiaPresenti = this.soggetti.findAllSoggetti(profilo, q, limit, offset, dominio, ruolo, tipoCredenziali, profiloQualsiasi).getItems().size();
            if (conf.getCountSoggetti() + (long)numSoggettiGiaPresenti > 1L) {
                Statement ps = null;
                ResultSet rs = null;
                try {
                    Connection con = this.connection;
                    ps = con.prepareStatement("select multitenant_erogazioni, multitenant_fruizioni from configurazione");
                    rs = ps.executeQuery();
                    MultitenantConfigurazione.TIPO_MULTITENANT attualeErogazioni = null;
                    MultitenantConfigurazione.TIPO_MULTITENANT attualeFruizioni = null;
                    if (rs.next()) {
                        String attualeFruizioniString;
                        String attualeErogazioniString = rs.getString("multitenant_erogazioni");
                        if (attualeErogazioniString != null) {
                            attualeErogazioni = MultitenantConfigurazione.TIPO_MULTITENANT.valueOf(attualeErogazioniString);
                        }
                        if ((attualeFruizioniString = rs.getString("multitenant_fruizioni")) != null) {
                            attualeFruizioni = MultitenantConfigurazione.TIPO_MULTITENANT.valueOf(attualeFruizioniString);
                        }
                    }
                    ps = con.prepareStatement("update configurazione set multitenant_stato = 'abilitato', multitenant_fruizioni = ?, multitenant_erogazioni = ?");
                    ps.setString(1, conf.getMultitenantFruizioniValue(attualeFruizioni));
                    ps.setString(2, conf.getMultitenantErogazioniValue(attualeErogazioni));
                    ps.executeUpdate();
                }
                catch (Throwable t) {
                    if (ps != null) {
                        ps.close();
                    }
                    if (rs == null) break block7;
                    rs.close();
                }
            }
        }
    }

    @Override
    public void closeConnection() throws SQLException {
        this.performUpdatesOnClose();
        super.closeConnection();
    }

    private void performUpdatesOnClose() throws SQLException {
        if (this.idAppender > 0L) {
            String deleteSql = "delete from audit_appender_prop where name LIKE 'context-%' AND id_audit_appender=?";
            this.log.debug("Perform delete: " + deleteSql + " param: idAppender[" + this.idAppender + "]");
            Connection con = this.connection;
            PreparedStatement ps = null;
            ps = con.prepareStatement(deleteSql);
            ps.setLong(1, this.idAppender);
            ps.executeUpdate();
            ps.close();
            if (this.bindNameOriginal != null && !this.bindNameOriginal.equals(this.bindName)) {
                String updateSql = "update audit_appender_prop set value = ? where id_audit_appender=? and name ='datasource'";
                this.log.debug("Perform update: " + updateSql + " param: bindNameOriginal[" + this.bindNameOriginal + "] idAppender[" + this.idAppender + "]");
                ps = con.prepareStatement(updateSql);
                ps.setString(1, this.bindNameOriginal);
                ps.setLong(2, this.idAppender);
                ps.executeUpdate();
                ps.close();
            }
        }
    }

    public InputWrapper<it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDSoggetto, SoggettoWrapper> insertAllSoggetti(InputWrapper<it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDSoggetto, SoggettoWrapper> input) throws Exception {
        InputWrapper<it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDSoggetto, SoggettoWrapper> output = new InputWrapper<it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDSoggetto, SoggettoWrapper>();
        output.getElementiNonMigrati().putAll(input.getElementiNonMigrati());
        output.getWarnings().addAll(input.getWarnings());
        List<SoggettoWrapper> lst = input.getElementi();
        int count = 0;
        this.infoLogger.info("Inserisco [" + lst.size() + "] Soggetti");
        for (SoggettoWrapper wrap : lst) {
            ++count;
            if (!this.existsSoggetto(wrap)) {
                this.log.info("Inserisco soggetto " + wrap);
                try {
                    this.soggetti.createSoggetto(wrap.getSoggetto(), wrap.getProfilo());
                    output.getElementi().add(wrap);
                }
                catch (WebApplicationException e) {
                    output.getElementiNonMigrati().put((it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDSoggetto)wrap.getKey(), "Errore durante l'inserimento del soggetto: " + ((ProblemRFC7807)e.getResponse().getEntity()).getDetail());
                    output.removeAllWarnings(wrap);
                }
                this.log.info("Soggetto " + wrap.getSoggetto() + " inserito con successo");
            } else {
                output.getElementiGiaPresenti().add(wrap);
                this.log.info("Soggetto " + wrap.getSoggetto() + " gia esistente");
            }
            if (count % 5 != 0) continue;
            this.infoLogger.info("Inseriti [" + count + "/" + lst.size() + "] Soggetti");
        }
        this.infoLogger.info("Inseriti [" + count + "/" + lst.size() + "] Soggetti");
        return output;
    }

    public InputWrapper<String, ApiWrapper> insertAllApi(InputWrapper<String, ApiWrapper> input) throws Exception {
        InputWrapper<String, ApiWrapper> output = new InputWrapper<String, ApiWrapper>();
        output.getElementiNonMigrati().putAll(input.getElementiNonMigrati());
        output.getWarnings().addAll(input.getWarnings());
        List<ApiWrapper> lst = input.getElementi();
        int count = 0;
        this.infoLogger.info("Inserisco [" + lst.size() + "] API");
        for (ApiWrapper wrap : lst) {
            boolean giaPresente;
            block24: {
                ++count;
                giaPresente = false;
                if (!this.existsApi(wrap)) {
                    this.log.info("Inserisco API: " + wrap);
                    try {
                        this.api.createApi(wrap.getApi(), wrap.getProfilo(), wrap.getApi().getReferente());
                        break block24;
                    }
                    catch (WebApplicationException e) {
                        output.getElementiNonMigrati().put((String)wrap.getKey(), "Errore durante l'inserimento della API: " + ((ProblemRFC7807)e.getResponse().getEntity()).getDetail());
                        output.removeAllWarnings(wrap);
                        continue;
                    }
                }
                giaPresente = true;
            }
            ArrayList<Object> warningList = new ArrayList<Object>();
            if (wrap.getAllegati() != null && !wrap.getAllegati().isEmpty()) {
                giaPresente = false;
                for (ApiAllegato apiAllegato : wrap.getAllegati()) {
                    try {
                        this.api.createApiAllegato(apiAllegato, wrap.getApi().getNome(), wrap.getApi().getVersione(), wrap.getProfilo(), wrap.getApi().getReferente());
                    }
                    catch (WebApplicationException e) {
                        ApiAllegatoGenerico gen;
                        Object nome = null;
                        if (apiAllegato.getAllegato() instanceof ApiAllegatoGenerico) {
                            gen = (ApiAllegatoGenerico)apiAllegato.getAllegato();
                            nome = gen.getNome();
                        } else if (apiAllegato.getAllegato() instanceof ApiAllegatoSpecificaSemiformale) {
                            gen = (ApiAllegatoSpecificaSemiformale)apiAllegato.getAllegato();
                            nome = gen.getNome();
                        } else {
                            nome = "tipo di allegato '" + apiAllegato.getAllegato().getRuolo() + "'";
                        }
                        warningList.add("Rilevato errore durante la createApiAllegato [" + (String)nome + "]: " + ((ProblemRFC7807)e.getResponse().getEntity()).getDetail());
                    }
                }
            }
            if (wrap.getServizi().isEmpty()) {
                warningList.add("nessun servizio trovato");
            }
            for (ApiServizio apiServizio : wrap.getServizi()) {
                if (this.existsServizio(wrap, apiServizio)) continue;
                giaPresente = false;
                try {
                    this.api.createApiServizio(apiServizio, wrap.getApi().getNome(), wrap.getApi().getVersione(), wrap.getProfilo(), wrap.getApi().getReferente());
                }
                catch (WebApplicationException e) {
                    warningList.add("Rilevato errore durante la createApiServizio [" + apiServizio.getNome() + "]: " + ((ProblemRFC7807)e.getResponse().getEntity()).getDetail());
                }
            }
            if (wrap.getAzioni().isEmpty()) {
                warningList.add("nessuna azione trovata");
            }
            for (ApiAzione apiAzione : wrap.getAzioni().keySet()) {
                String nomeServizio;
                if (this.existsAzione(wrap, apiAzione, nomeServizio = wrap.getAzioni().get(apiAzione))) continue;
                giaPresente = false;
                try {
                    this.api.createApiAzione(apiAzione, wrap.getApi().getNome(), wrap.getApi().getVersione(), nomeServizio, wrap.getProfilo(), wrap.getApi().getReferente());
                }
                catch (WebApplicationException e) {
                    warningList.add("Rilevato errore durante la createApiAzione  [" + apiAzione.getNome() + "]: " + ((ProblemRFC7807)e.getResponse().getEntity()).getDetail());
                }
            }
            if (giaPresente) {
                output.getElementiGiaPresenti().add(wrap);
                output.removeAllWarnings(wrap);
            } else {
                output.getElementi().add(wrap);
                if (!warningList.isEmpty()) {
                    for (String string : warningList) {
                        output.addWarning(wrap, string);
                    }
                }
            }
            if (count % 5 != 0) continue;
            this.infoLogger.info("Inserite [" + count + "/" + lst.size() + "] API");
        }
        this.infoLogger.info("Inserite [" + count + "/" + lst.size() + "] API");
        return output;
    }

    private boolean existsApi(ApiWrapper wrap) {
        try {
            this.log.info("Cerco API: " + wrap);
            return this.api.getApi(wrap.getApi().getNome(), wrap.getApi().getVersione(), wrap.getProfilo(), wrap.getApi().getReferente()) != null;
        }
        catch (WebApplicationException e) {
            if (e.getResponse().getStatus() == 404) {
                return false;
            }
            throw e;
        }
    }

    private boolean existsSoggetto(SoggettoWrapper wrap) {
        try {
            this.log.info("Cerco soggetto: " + wrap);
            return this.soggetti.getSoggetto(wrap.getSoggetto().getNome(), wrap.getProfilo()) != null;
        }
        catch (WebApplicationException e) {
            if (e.getResponse().getStatus() == 404) {
                return false;
            }
            throw e;
        }
    }

    private boolean existsRuolo(Ruolo wrap) {
        try {
            this.log.info("Cerco ruolo: " + wrap);
            return this.ruoli.getRuolo(wrap.getNome()) != null;
        }
        catch (WebApplicationException e) {
            if (e.getResponse().getStatus() == 404) {
                return false;
            }
            throw e;
        }
    }

    private boolean existsApplicativo(ApplicativoWrapper wrap) {
        try {
            this.log.info("Cerco applicativo: " + wrap);
            return this.applicativi.getApplicativo(wrap.getApplicativo().getNome(), wrap.getProfilo(), wrap.getSoggetto()) != null;
        }
        catch (WebApplicationException e) {
            if (e.getResponse().getStatus() == 404) {
                return false;
            }
            throw e;
        }
    }

    private boolean existsAzione(ApiWrapper wrap, ApiAzione azione, String nomeServizio) {
        try {
            return this.api.getApiAzione(wrap.getApi().getNome(), wrap.getApi().getVersione(), nomeServizio, azione.getNome(), wrap.getProfilo(), wrap.getApi().getReferente()) != null;
        }
        catch (WebApplicationException e) {
            if (e.getResponse().getStatus() == 404) {
                return false;
            }
            throw e;
        }
    }

    private boolean existsServizio(ApiWrapper wrap, ApiServizio servizio) {
        try {
            return this.api.getApiServizio(wrap.getApi().getNome(), wrap.getApi().getVersione(), servizio.getNome(), wrap.getProfilo(), wrap.getApi().getReferente()) != null;
        }
        catch (WebApplicationException e) {
            if (e.getResponse().getStatus() == 404) {
                return false;
            }
            throw e;
        }
    }

    private boolean existsErogazione(ErogazioneWrapper wrap) {
        try {
            this.log.info("Cerco erogazione: " + wrap);
            return this.erogazioni.getErogazione(wrap.getErogazione().getErogazioneNome(), wrap.getErogazione().getApiVersione(), wrap.getProfilo(), wrap.getNomeSoggettoErogatore(), wrap.getErogazione().getTipoServizio()) != null;
        }
        catch (WebApplicationException e) {
            if (e.getResponse().getStatus() == 404) {
                return false;
            }
            throw e;
        }
    }

    private boolean existsFruizione(FruizioneWrapper wrap) {
        try {
            this.log.info("Cerco fruizione: " + wrap);
            return this.fruizioni.getFruizione(wrap.getFruizione().getErogatore(), wrap.getFruizione().getFruizioneNome(), wrap.getFruizione().getApiVersione(), wrap.getProfilo(), wrap.getNomeFruitore(), wrap.getFruizione().getTipoServizio()) != null;
        }
        catch (WebApplicationException e) {
            if (e.getResponse().getStatus() == 404) {
                return false;
            }
            throw e;
        }
    }

    public void disabilitaAbilitaErogazioni(InputWrapper<IDPortaApplicativaByNome, ErogazioneWrapper> input) throws Exception {
        if (input.getElementiDaRiabilitare() != null && !input.getElementiDaRiabilitare().isEmpty()) {
            for (ErogazioneWrapper erogazioneWrapper : input.getElementiDaRiabilitare()) {
                ApiImplStato stato = new ApiImplStato();
                stato.setAbilitato(Boolean.valueOf(true));
                this.log.info("Riabilito erogazione " + erogazioneWrapper);
                try {
                    this.erogazioniConfigurazione.updateErogazioneStato(stato, erogazioneWrapper.getErogazione().getErogazioneNome(), erogazioneWrapper.getErogazione().getApiVersione(), erogazioneWrapper.getProfilo(), erogazioneWrapper.getNomeSoggettoErogatore(), erogazioneWrapper.getGruppo(), erogazioneWrapper.getErogazione().getTipoServizio());
                }
                catch (WebApplicationException e) {
                    throw new Exception("Errore durante updateErogazioneStato[" + erogazioneWrapper + "]:" + e.getMessage(), e);
                }
            }
        }
        if (input.getWarnings() != null) {
            for (Warnings warnings : input.getWarningList()) {
                ErogazioneWrapper wrap = (ErogazioneWrapper)warnings.getKey();
                ApiImplStato stato = new ApiImplStato();
                stato.setAbilitato(Boolean.valueOf(false));
                this.log.info("Disabilito erogazione " + wrap + " a causa di " + (wrap.isMigrazioneSpcEGw() ? warnings.getWarningsNoSpc() : warnings.getWarnings()));
                try {
                    this.erogazioniConfigurazione.updateErogazioneStato(stato, wrap.getErogazione().getErogazioneNome(), wrap.getErogazione().getApiVersione(), wrap.getProfilo(), wrap.getNomeSoggettoErogatore(), wrap.getGruppo(), wrap.getErogazione().getTipoServizio());
                }
                catch (WebApplicationException e) {
                    throw new Exception("Errore durante updateErogazioneStato[" + wrap + "]:" + e.getMessage(), e);
                }
            }
        }
    }

    public InputWrapper<IDPortaApplicativaByNome, ErogazioneWrapper> insertAllErogazioni(InputWrapper<IDPortaApplicativaByNome, ErogazioneWrapper> input) throws Exception {
        InputWrapper<IDPortaApplicativaByNome, ErogazioneWrapper> output = new InputWrapper<IDPortaApplicativaByNome, ErogazioneWrapper>();
        output.getElementiNonMigrati().putAll(input.getElementiNonMigrati());
        output.getWarnings().addAll(input.getWarnings());
        int count = 0;
        this.infoLogger.info("Inserisco [" + input.getElementi().size() + "] Erogazioni");
        for (ErogazioneWrapper wrap : input.getElementi()) {
            IDServizio idServizio;
            boolean giaPresenteConStatoDisabilitato;
            boolean giaPresente;
            block54: {
                ++count;
                giaPresente = false;
                giaPresenteConStatoDisabilitato = false;
                idServizio = IDServizioFactory.getInstance().getIDServizioFromValues(wrap.getErogazione().getTipoServizio(), wrap.getNomeServizio(), wrap.getErogazione().getTipoServizio(), wrap.getNomeSoggettoErogatore(), wrap.getErogazione().getApiVersione().intValue());
                if (!this.existsErogazione(wrap)) {
                    this.log.info("Inserisco erogazione : " + wrap);
                    try {
                        this.erogazioni.createErogazione(wrap.getErogazione(), wrap.getProfilo(), wrap.getNomeSoggettoErogatore());
                        break block54;
                    }
                    catch (WebApplicationException e) {
                        String detailError = ((ProblemRFC7807)e.getResponse().getEntity()).getDetail();
                        if (detailError == null || StringUtils.isEmpty((String)detailError)) {
                            detailError = e.getMessage();
                        }
                        this.log.error("Errore durante l'inserimento dell'erogazione : " + wrap + ":" + detailError, (Throwable)e);
                        output.getElementiNonMigrati().put((IDPortaApplicativaByNome)wrap.getKey(), "Errore durante l'inserimento della erogazione: " + detailError);
                        output.removeAllWarnings(wrap);
                        continue;
                    }
                }
                giaPresente = true;
                try {
                    ApiImplStato stato = this.erogazioniConfigurazione.getErogazioneStato(wrap.getErogazione().getErogazioneNome(), wrap.getErogazione().getApiVersione(), wrap.getProfilo(), wrap.getNomeSoggettoErogatore(), wrap.getGruppo(), wrap.getErogazione().getTipoServizio());
                    if (stato != null && stato.isAbilitato() != null && !stato.isAbilitato().booleanValue()) {
                        giaPresenteConStatoDisabilitato = true;
                    }
                }
                catch (WebApplicationException e) {
                    this.log.error("Errore durante la comprensione dello stato della erogazione " + wrap + ": " + ((ProblemRFC7807)e.getResponse().getEntity()).getDetail(), (Throwable)e);
                }
            }
            ArrayList<CallSite> warningList = new ArrayList<CallSite>();
            if (wrap.getGruppo() != null) {
                this.log.info("Inserisco gruppo: " + wrap.getGruppo());
                Gruppo body = new Gruppo();
                body.setNome(wrap.getGruppo());
                GruppoEreditaConfigurazione gruppoEreditaConfigurazione = new GruppoEreditaConfigurazione();
                gruppoEreditaConfigurazione.setModalita(ModalitaConfigurazioneGruppoEnum.EREDITA);
                gruppoEreditaConfigurazione.setNome("Predefinito");
                body.setConfigurazione((OneOfGruppoConfigurazione)gruppoEreditaConfigurazione);
                body.setAzioni(Arrays.asList(wrap.getGruppo()));
                try {
                    this.erogazioniGruppi.createErogazioneGruppo(body, wrap.getErogazione().getErogazioneNome(), wrap.getErogazione().getApiVersione(), wrap.getProfilo(), wrap.getNomeSoggettoErogatore(), wrap.getErogazione().getTipoServizio());
                    giaPresente = false;
                }
                catch (WebApplicationException e) {
                    if (e.getResponse().getStatus() != 409) {
                        warningList.add((CallSite)((Object)("Errore durante la creazione del gruppo [" + wrap.getGruppo() + "]: " + ((ProblemRFC7807)e.getResponse().getEntity()).getDetail())));
                        giaPresente = false;
                    }
                }
            } else {
                this.log.info("Nessun gruppo per l'erogazione " + wrap);
            }
            if (wrap.getAllegati() != null && !wrap.getAllegati().isEmpty()) {
                giaPresente = false;
                for (ApiImplAllegato apiImplAllegato : wrap.getAllegati()) {
                    try {
                        this.erogazioni.createErogazioneAllegato(apiImplAllegato, wrap.getErogazione().getErogazioneNome(), wrap.getErogazione().getApiVersione(), wrap.getProfilo(), wrap.getNomeSoggettoErogatore(), wrap.getErogazione().getTipoServizio());
                    }
                    catch (WebApplicationException e) {
                        ApiImplAllegatoGenerico gen;
                        Object nome = null;
                        if (apiImplAllegato.getAllegato() instanceof ApiImplAllegatoGenerico) {
                            gen = (ApiImplAllegatoGenerico)apiImplAllegato.getAllegato();
                            nome = gen.getNome();
                        } else if (apiImplAllegato.getAllegato() instanceof ApiImplAllegatoSpecificaSemiformale) {
                            gen = (ApiImplAllegatoSpecificaSemiformale)apiImplAllegato.getAllegato();
                            nome = gen.getNome();
                        } else if (apiImplAllegato.getAllegato() instanceof ApiImplAllegatoSpecificaSicurezza) {
                            gen = (ApiImplAllegatoSpecificaSicurezza)apiImplAllegato.getAllegato();
                            nome = gen.getNome();
                        } else if (apiImplAllegato.getAllegato() instanceof ApiImplAllegatoSpecificaLivelloServizio) {
                            gen = (ApiImplAllegatoSpecificaLivelloServizio)apiImplAllegato.getAllegato();
                            nome = gen.getNome();
                        } else {
                            nome = "tipo di allegato '" + apiImplAllegato.getAllegato().getRuolo() + "'";
                        }
                        warningList.add((CallSite)((Object)("Rilevato errore durante la createErogazioneAllegato [" + (String)nome + "]: " + ((ProblemRFC7807)e.getResponse().getEntity()).getDetail())));
                    }
                }
            }
            if (wrap.getControlloAccessiLst() != null) {
                for (ControlloAccessiAutorizzazioneSoggetto controlloAccessiAutorizzazioneSoggetto : wrap.getControlloAccessiLst()) {
                    try {
                        this.log.info("Inserisco addErogazioneControlloAccessiAutorizzazioneSoggetti: " + controlloAccessiAutorizzazioneSoggetto.getSoggetto());
                        this.erogazioniConfigurazione.addErogazioneControlloAccessiAutorizzazioneSoggetti(controlloAccessiAutorizzazioneSoggetto, wrap.getErogazione().getErogazioneNome(), wrap.getErogazione().getApiVersione(), wrap.getProfilo(), wrap.getNomeSoggettoErogatore(), wrap.getGruppo(), wrap.getErogazione().getTipoServizio());
                        giaPresente = false;
                    }
                    catch (WebApplicationException e) {
                        if (e.getResponse().getStatus() == 409) continue;
                        warningList.add((CallSite)((Object)("Rilevato errore durante la addErogazioneControlloAccessiAutorizzazioneSoggetti [" + controlloAccessiAutorizzazioneSoggetto.getSoggetto() + "]: " + ((ProblemRFC7807)e.getResponse().getEntity()).getDetail())));
                        giaPresente = false;
                    }
                }
            }
            if (wrap.getCorrelazioneApplicativaRichiestaLst() != null) {
                for (CorrelazioneApplicativaRichiesta correlazioneApplicativaRichiesta : wrap.getCorrelazioneApplicativaRichiestaLst()) {
                    try {
                        this.erogazioniConfigurazione.addErogazioneTracciamentoCorrelazioneApplicativaRichiesta(correlazioneApplicativaRichiesta, wrap.getErogazione().getErogazioneNome(), wrap.getErogazione().getApiVersione(), wrap.getProfilo(), wrap.getNomeSoggettoErogatore(), wrap.getGruppo(), wrap.getErogazione().getTipoServizio());
                        giaPresente = false;
                    }
                    catch (WebApplicationException e) {
                        if (e.getResponse().getStatus() == 409) continue;
                        warningList.add((CallSite)((Object)("Rilevato errore durante la addErogazioneTracciamentoCorrelazioneApplicativaRichiesta [" + correlazioneApplicativaRichiesta.getElemento() + "]: " + ((ProblemRFC7807)e.getResponse().getEntity()).getDetail())));
                        giaPresente = false;
                    }
                }
            }
            if (wrap.getCorrelazioneApplicativaRispostaLst() != null) {
                for (CorrelazioneApplicativaRisposta correlazioneApplicativaRisposta : wrap.getCorrelazioneApplicativaRispostaLst()) {
                    try {
                        this.erogazioniConfigurazione.addErogazioneTracciamentoCorrelazioneApplicativaRisposta(correlazioneApplicativaRisposta, wrap.getErogazione().getErogazioneNome(), wrap.getErogazione().getApiVersione(), wrap.getProfilo(), wrap.getNomeSoggettoErogatore(), wrap.getGruppo(), wrap.getErogazione().getTipoServizio());
                        giaPresente = false;
                    }
                    catch (WebApplicationException e) {
                        if (e.getResponse().getStatus() == 409) continue;
                        warningList.add((CallSite)((Object)("Rilevato errore durante la addErogazioneTracciamentoCorrelazioneApplicativaRisposta [" + correlazioneApplicativaRisposta.getElemento() + "]: " + ((ProblemRFC7807)e.getResponse().getEntity()).getDetail())));
                        giaPresente = false;
                    }
                }
            }
            if (wrap.getValidazione() != null) {
                giaPresente = false;
                try {
                    this.erogazioniConfigurazione.updateErogazioneValidazione(wrap.getValidazione(), wrap.getErogazione().getErogazioneNome(), wrap.getErogazione().getApiVersione(), wrap.getProfilo(), wrap.getNomeSoggettoErogatore(), wrap.getGruppo(), wrap.getErogazione().getTipoServizio());
                }
                catch (WebApplicationException e) {
                    warningList.add((CallSite)((Object)("Rilevato errore durante la updateErogazioneValidazione: " + ((ProblemRFC7807)e.getResponse().getEntity()).getDetail())));
                }
            }
            if (wrap.getMessageSecurity() != null) {
                giaPresente = false;
                try {
                    long idPorta = this.driverAvanzato.getIdPA(idServizio, wrap.getGruppo());
                    if (wrap.getMessageSecurity().getRequestFlow() != null) {
                        this.driverAvanzato.enableWsSecurityPA(idPorta, DriverConfigurazioneServiziGovway.TIPO_MESSAGGIO.RICHIESTA, wrap.getMessageSecurity().getRequestFlow());
                    }
                    if (wrap.getMessageSecurity().getResponseFlow() != null) {
                        this.driverAvanzato.enableWsSecurityPA(idPorta, DriverConfigurazioneServiziGovway.TIPO_MESSAGGIO.RISPOSTA, wrap.getMessageSecurity().getResponseFlow());
                    }
                }
                catch (Throwable e) {
                    warningList.add((CallSite)((Object)("Rilevato errore durante la updateWsSecurity: " + e.getMessage())));
                }
            }
            if (MigrazioneProperties.getInstance().getMetadatiErogazioni() != null) {
                giaPresente = false;
                try {
                    long idPorta = this.driverAvanzato.getIdPA(idServizio, wrap.getGruppo());
                    this.driverAvanzato.setMetadatiPA(idPorta, MigrazioneProperties.getInstance().getMetadatiErogazioni());
                }
                catch (Throwable e) {
                    warningList.add((CallSite)((Object)("Rilevato errore durante la setMetadati: " + e.getMessage())));
                }
            }
            if (giaPresente) {
                output.getElementiGiaPresenti().add(wrap);
                output.removeAllWarnings(wrap);
            } else {
                output.getElementi().add(wrap);
                if (!warningList.isEmpty()) {
                    for (String string : warningList) {
                        output.addWarning(wrap, string);
                    }
                } else if (giaPresenteConStatoDisabilitato) {
                    output.getElementiDaRiabilitare().add(wrap);
                }
            }
            if (count % 5 != 0) continue;
            this.infoLogger.info("Inserite [" + count + "/" + input.getElementi().size() + "] Erogazioni");
        }
        this.infoLogger.info("Inserite [" + count + "/" + input.getElementi().size() + "] Erogazioni");
        return output;
    }

    public void disabilitaAbilitaFruizioni(InputWrapper<IDPortaDelegata, FruizioneWrapper> input) throws Exception {
        if (input.getElementiDaRiabilitare() != null && !input.getElementiDaRiabilitare().isEmpty()) {
            for (FruizioneWrapper fruizioneWrapper : input.getElementiDaRiabilitare()) {
                ApiImplStato stato = new ApiImplStato();
                stato.setAbilitato(Boolean.valueOf(true));
                this.log.info("Riabilito fruizione " + fruizioneWrapper);
                try {
                    this.fruizioniConfigurazione.updateFruizioneStato(stato, fruizioneWrapper.getFruizione().getErogatore(), fruizioneWrapper.getFruizione().getFruizioneNome(), fruizioneWrapper.getFruizione().getApiVersione(), fruizioneWrapper.getProfilo(), fruizioneWrapper.getNomeFruitore(), fruizioneWrapper.getGruppo(), fruizioneWrapper.getFruizione().getTipoServizio());
                }
                catch (WebApplicationException e) {
                    throw new Exception("Errore durante updateFruizioneStato[" + fruizioneWrapper + "]:" + e.getMessage(), e);
                }
            }
        }
        if (input.getWarnings() != null) {
            for (Warnings warnings : input.getWarningList()) {
                FruizioneWrapper wrap = (FruizioneWrapper)warnings.getKey();
                ApiImplStato stato = new ApiImplStato();
                stato.setAbilitato(Boolean.valueOf(false));
                this.log.info("Disabilito fruizione " + wrap + " a causa di " + (wrap.isMigrazioneSpc2Gw() ? warnings.getWarningsNoSpc() : warnings.getWarnings()));
                try {
                    this.fruizioniConfigurazione.updateFruizioneStato(stato, wrap.getFruizione().getErogatore(), wrap.getFruizione().getFruizioneNome(), wrap.getFruizione().getApiVersione(), wrap.getProfilo(), wrap.getNomeFruitore(), wrap.getGruppo(), wrap.getFruizione().getTipoServizio());
                }
                catch (WebApplicationException e) {
                    throw new Exception("Errore durante updateFruizioneStato[" + wrap + "]:" + e.getMessage(), e);
                }
            }
        }
    }

    /*
     * Could not resolve type clashes
     */
    public InputWrapper<IDPortaDelegata, FruizioneWrapper> insertAllFruizioni(InputWrapper<IDPortaDelegata, FruizioneWrapper> input) throws Exception {
        InputWrapper<IDPortaDelegata, FruizioneWrapper> output = new InputWrapper<IDPortaDelegata, FruizioneWrapper>();
        output.getElementiNonMigrati().putAll(input.getElementiNonMigrati());
        output.getWarnings().addAll(input.getWarnings());
        int count = 0;
        this.infoLogger.info("Inserisco [" + input.getElementi().size() + "] fruizioni");
        for (FruizioneWrapper wrap : input.getElementi()) {
            IDSoggetto idFruitore;
            IDServizio idServizio;
            boolean giaPresenteConStatoDisabilitato;
            boolean giaPresente;
            block57: {
                ++count;
                giaPresente = false;
                giaPresenteConStatoDisabilitato = false;
                idServizio = IDServizioFactory.getInstance().getIDServizioFromValues(wrap.getFruizione().getTipoServizio(), wrap.getNomeServizio(), wrap.getFruizione().getTipoServizio(), wrap.getNomeSoggettoErogatore(), wrap.getFruizione().getApiVersione().intValue());
                if (!this.existsFruizione(wrap)) {
                    try {
                        this.log.info("Creazione fruizione " + wrap);
                        this.fruizioni.createFruizione(wrap.getFruizione(), wrap.getProfilo(), wrap.getNomeFruitore());
                        this.log.info("Creazione fruizione " + wrap + " completata con successo");
                        break block57;
                    }
                    catch (WebApplicationException e) {
                        this.log.error("Errore durante l'inserimento della fruizione: " + wrap, (Throwable)e);
                        String detailError = ((ProblemRFC7807)e.getResponse().getEntity()).getDetail();
                        if (detailError == null || StringUtils.isEmpty((String)detailError)) {
                            detailError = e.getMessage();
                        }
                        output.getElementiNonMigrati().put((IDPortaDelegata)wrap.getKey(), "Errore durante l'inserimento della fruizione: " + detailError);
                        output.removeAllWarnings(wrap);
                        continue;
                    }
                }
                giaPresente = true;
                try {
                    ApiImplStato stato = this.fruizioniConfigurazione.getFruizioneStato(wrap.getFruizione().getErogatore(), wrap.getFruizione().getFruizioneNome(), wrap.getFruizione().getApiVersione(), wrap.getProfilo(), wrap.getNomeFruitore(), wrap.getGruppo(), wrap.getFruizione().getTipoServizio());
                    if (stato != null && stato.isAbilitato() != null && !stato.isAbilitato().booleanValue()) {
                        giaPresenteConStatoDisabilitato = true;
                    }
                }
                catch (WebApplicationException e) {
                    this.log.error("Errore durante la comprensione dello stato della fruizione " + wrap + ": " + ((ProblemRFC7807)e.getResponse().getEntity()).getDetail(), (Throwable)e);
                }
            }
            ArrayList<CallSite> warningList = new ArrayList<CallSite>();
            if (wrap.getUrlInvocazione() != null) {
                try {
                    this.log.info("Aggiornamento URL invocazione per la fruizione " + wrap);
                    giaPresente = false;
                    this.fruizioni.updateFruizioneUrlInvocazione(wrap.getUrlInvocazione(), wrap.getNomeSoggettoErogatore(), wrap.getNomeServizio(), wrap.getFruizione().getApiVersione(), wrap.getProfilo(), wrap.getNomeFruitore(), wrap.getFruizione().getTipoServizio());
                    this.log.info("Aggiornamento URL invocazione per la fruizione " + wrap + " completato con successo");
                }
                catch (WebApplicationException e) {
                    this.log.error("Errore durante l'aggiornamento dell'URL invocazione per la fruizione " + wrap + ": " + ((ProblemRFC7807)e.getResponse().getEntity()).getDetail(), (Throwable)e);
                    warningList.add((CallSite)((Object)("Errore durante l'aggiornamento dell'URL invocazione: " + ((ProblemRFC7807)e.getResponse().getEntity()).getDetail())));
                }
            }
            if (wrap.getGruppo() != null) {
                this.log.info("Inserisco gruppo: " + wrap.getGruppo());
                Gruppo body = new Gruppo();
                body.setNome(wrap.getGruppo());
                GruppoEreditaConfigurazione configurazione = new GruppoEreditaConfigurazione();
                configurazione.setModalita(ModalitaConfigurazioneGruppoEnum.EREDITA);
                configurazione.setNome("Predefinito");
                body.setConfigurazione((OneOfGruppoConfigurazione)configurazione);
                body.setAzioni(Arrays.asList(wrap.getGruppo()));
                try {
                    this.log.info("Creazione gruppo " + wrap);
                    giaPresente = false;
                    this.fruizioniGruppi.createFruizioneGruppo(body, wrap.getFruizione().getErogatore(), wrap.getFruizione().getFruizioneNome(), wrap.getFruizione().getApiVersione(), wrap.getProfilo(), wrap.getNomeFruitore(), wrap.getFruizione().getTipoServizio());
                    this.log.info("Creazione gruppo " + wrap + " completato con successo");
                }
                catch (WebApplicationException e) {
                    if (e.getResponse().getStatus() != 409) {
                        warningList.add((CallSite)((Object)("Errore durante la creazione del gruppo [" + wrap.getGruppo() + "]: " + ((ProblemRFC7807)e.getResponse().getEntity()).getDetail())));
                        giaPresente = false;
                    }
                }
            } else {
                this.log.info("Nessun gruppo da creare per " + wrap);
            }
            if (wrap.getAllegati() != null && !wrap.getAllegati().isEmpty()) {
                giaPresente = false;
                for (ApiImplAllegato allegato : wrap.getAllegati()) {
                    try {
                        this.fruizioni.createFruizioneAllegato(allegato, wrap.getFruizione().getErogatore(), wrap.getFruizione().getFruizioneNome(), wrap.getFruizione().getApiVersione(), wrap.getProfilo(), wrap.getNomeFruitore(), wrap.getFruizione().getTipoServizio());
                    }
                    catch (WebApplicationException e) {
                        ApiImplAllegatoGenerico gen;
                        Object nome = null;
                        if (allegato.getAllegato() instanceof ApiImplAllegatoGenerico) {
                            gen = (ApiImplAllegatoGenerico)allegato.getAllegato();
                            nome = gen.getNome();
                        } else if (allegato.getAllegato() instanceof ApiImplAllegatoSpecificaSemiformale) {
                            gen = (ApiImplAllegatoSpecificaSemiformale)allegato.getAllegato();
                            nome = gen.getNome();
                        } else if (allegato.getAllegato() instanceof ApiImplAllegatoSpecificaSicurezza) {
                            gen = (ApiImplAllegatoSpecificaSicurezza)allegato.getAllegato();
                            nome = gen.getNome();
                        } else if (allegato.getAllegato() instanceof ApiImplAllegatoSpecificaLivelloServizio) {
                            gen = (ApiImplAllegatoSpecificaLivelloServizio)allegato.getAllegato();
                            nome = gen.getNome();
                        } else {
                            nome = "tipo di allegato '" + allegato.getAllegato().getRuolo() + "'";
                        }
                        warningList.add((CallSite)((Object)("Rilevato errore durante la createFruizioneAllegato [" + (String)nome + "]: " + ((ProblemRFC7807)e.getResponse().getEntity()).getDetail())));
                    }
                }
            }
            if (wrap.getControlloAccessiLst() != null) {
                for (ControlloAccessiAutorizzazioneApplicativo contrAcc : wrap.getControlloAccessiLst()) {
                    try {
                        this.fruizioniConfigurazione.addFruizioneControlloAccessiAutorizzazioneApplicativi(contrAcc, wrap.getFruizione().getErogatore(), wrap.getFruizione().getFruizioneNome(), wrap.getFruizione().getApiVersione(), wrap.getProfilo(), wrap.getNomeFruitore(), wrap.getGruppo(), wrap.getFruizione().getTipoServizio());
                        giaPresente = false;
                    }
                    catch (WebApplicationException e) {
                        if (e.getResponse().getStatus() == 409) continue;
                        warningList.add((CallSite)((Object)("Rilevato errore durante la addFruizioneControlloAccessiAutorizzazioneApplicativi [" + contrAcc.getApplicativo() + "]: " + ((ProblemRFC7807)e.getResponse().getEntity()).getDetail())));
                        giaPresente = false;
                    }
                }
            }
            if (wrap.getCorrelazioneApplicativaRichiestaLst() != null) {
                for (CorrelazioneApplicativaRichiesta corr : wrap.getCorrelazioneApplicativaRichiestaLst()) {
                    try {
                        this.fruizioniConfigurazione.addFruizioneTracciamentoCorrelazioneApplicativaRichiesta(corr, wrap.getFruizione().getErogatore(), wrap.getFruizione().getFruizioneNome(), wrap.getFruizione().getApiVersione(), wrap.getProfilo(), wrap.getNomeFruitore(), wrap.getGruppo(), wrap.getFruizione().getTipoServizio());
                        giaPresente = false;
                    }
                    catch (WebApplicationException e) {
                        if (e.getResponse().getStatus() == 409) continue;
                        warningList.add((CallSite)((Object)("Rilevato errore durante la addFruizioneTracciamentoCorrelazioneApplicativaRichiesta [" + corr.getElemento() + "]: " + ((ProblemRFC7807)e.getResponse().getEntity()).getDetail())));
                        giaPresente = false;
                    }
                }
            }
            if (wrap.getCorrelazioneApplicativaRispostaLst() != null) {
                for (CorrelazioneApplicativaRichiesta corr : wrap.getCorrelazioneApplicativaRispostaLst()) {
                    try {
                        this.fruizioniConfigurazione.addFruizioneTracciamentoCorrelazioneApplicativaRisposta((CorrelazioneApplicativaRisposta)corr, wrap.getFruizione().getErogatore(), wrap.getFruizione().getFruizioneNome(), wrap.getFruizione().getApiVersione(), wrap.getProfilo(), wrap.getNomeFruitore(), wrap.getGruppo(), wrap.getFruizione().getTipoServizio());
                        giaPresente = false;
                    }
                    catch (WebApplicationException e) {
                        if (e.getResponse().getStatus() == 409) continue;
                        warningList.add((CallSite)((Object)("Rilevato errore durante la addFruizioneTracciamentoCorrelazioneApplicativaRisposta [" + corr.getElemento() + "]: " + ((ProblemRFC7807)e.getResponse().getEntity()).getDetail())));
                        giaPresente = false;
                    }
                }
            }
            if (wrap.getValidazione() != null) {
                giaPresente = false;
                try {
                    this.fruizioniConfigurazione.updateFruizioneValidazione(wrap.getValidazione(), wrap.getFruizione().getErogatore(), wrap.getFruizione().getFruizioneNome(), wrap.getFruizione().getApiVersione(), wrap.getProfilo(), wrap.getNomeFruitore(), wrap.getGruppo(), wrap.getFruizione().getTipoServizio());
                }
                catch (WebApplicationException e) {
                    warningList.add((CallSite)((Object)("Rilevato errore durante la updateFruizioneValidazione: " + ((ProblemRFC7807)e.getResponse().getEntity()).getDetail())));
                }
            }
            if (wrap.getMessageSecurity() != null) {
                giaPresente = false;
                try {
                    idFruitore = new IDSoggetto(wrap.getFruizione().getTipoServizio(), wrap.getNomeFruitore());
                    long idPorta = this.driverAvanzato.getIdPD(idServizio, idFruitore, wrap.getGruppo());
                    if (wrap.getMessageSecurity().getRequestFlow() != null) {
                        this.driverAvanzato.enableWsSecurityPD(idPorta, DriverConfigurazioneServiziGovway.TIPO_MESSAGGIO.RICHIESTA, wrap.getMessageSecurity().getRequestFlow());
                    }
                    if (wrap.getMessageSecurity().getResponseFlow() != null) {
                        this.driverAvanzato.enableWsSecurityPD(idPorta, DriverConfigurazioneServiziGovway.TIPO_MESSAGGIO.RISPOSTA, wrap.getMessageSecurity().getResponseFlow());
                    }
                }
                catch (Throwable e) {
                    warningList.add((CallSite)((Object)("Rilevato errore durante la updateWsSecurity: " + e.getMessage())));
                }
            }
            if (MigrazioneProperties.getInstance().getMetadatiFruizioni() != null) {
                giaPresente = false;
                try {
                    idFruitore = new IDSoggetto(wrap.getFruizione().getTipoServizio(), wrap.getNomeFruitore());
                    long idPorta = this.driverAvanzato.getIdPD(idServizio, idFruitore, wrap.getGruppo());
                    this.driverAvanzato.setMetadatiPD(idPorta, MigrazioneProperties.getInstance().getMetadatiFruizioni());
                }
                catch (Throwable e) {
                    warningList.add((CallSite)((Object)("Rilevato errore durante la setMetadati: " + e.getMessage())));
                }
            }
            if (giaPresente) {
                output.getElementiGiaPresenti().add(wrap);
                output.removeAllWarnings(wrap);
            } else {
                output.getElementi().add(wrap);
                if (!warningList.isEmpty()) {
                    for (String warning : warningList) {
                        output.addWarning(wrap, warning);
                    }
                } else if (giaPresenteConStatoDisabilitato) {
                    output.getElementiDaRiabilitare().add(wrap);
                }
            }
            if (count % 5 != 0) continue;
            this.infoLogger.info("Inserite [" + count + "/" + input.getElementi().size() + "] fruizioni");
        }
        this.infoLogger.info("Inserite [" + count + "/" + input.getElementi().size() + "] fruizioni");
        return output;
    }

    public String getUrlInvocazione(FruizioneWrapper wrap) {
        ApiImplUrlInvocazioneView urlInvocazione = this.fruizioni.getFruizioneUrlInvocazione(wrap.getFruizione().getErogatore(), wrap.getFruizione().getFruizioneNome(), wrap.getFruizione().getApiVersione(), wrap.getProfilo(), wrap.getNomeFruitore(), wrap.getFruizione().getTipoServizio());
        return wrap.getUrlAzione() != null ? urlInvocazione.getUrlInvocazione() + "/" + wrap.getUrlAzione() : urlInvocazione.getUrlInvocazione();
    }

    public String getUrlInvocazione(ErogazioneWrapper wrap) {
        ApiImplUrlInvocazioneView urlInvocazione = this.erogazioni.getErogazioneUrlInvocazione(wrap.getErogazione().getErogazioneNome(), wrap.getErogazione().getApiVersione(), wrap.getProfilo(), wrap.getNomeSoggettoErogatore(), wrap.getErogazione().getTipoServizio());
        return urlInvocazione.getUrlInvocazione();
    }

    public void insertAllRuoli(List<Ruolo> lst) {
        int count = 0;
        this.infoLogger.info("Inserisco [" + lst.size() + "] ruoli");
        for (Ruolo wrap : lst) {
            ++count;
            if (!this.existsRuolo(wrap)) {
                this.ruoli.createRuolo(wrap);
            }
            if (count % 5 != 0) continue;
            this.infoLogger.info("Inseriti [" + count + "/" + lst.size() + "] ruoli");
        }
        this.infoLogger.info("Inseriti [" + count + "/" + lst.size() + "] ruoli");
    }

    public InputWrapper<IDServizioApplicativo, ApplicativoWrapper> insertAllApplicativi(InputWrapper<IDServizioApplicativo, ApplicativoWrapper> input) {
        InputWrapper<IDServizioApplicativo, ApplicativoWrapper> output = new InputWrapper<IDServizioApplicativo, ApplicativoWrapper>();
        output.getElementiNonMigrati().putAll(input.getElementiNonMigrati());
        output.getWarnings().addAll(input.getWarnings());
        int count = 0;
        List<ApplicativoWrapper> lst = input.getElementi();
        this.infoLogger.info("Inserisco [" + lst.size() + "] applicativi");
        for (ApplicativoWrapper wrap : lst) {
            block4: {
                ++count;
                if (!this.existsApplicativo(wrap)) {
                    try {
                        this.applicativi.createApplicativo(wrap.getApplicativo(), wrap.getProfilo(), wrap.getSoggetto());
                        output.getElementi().add(wrap);
                        break block4;
                    }
                    catch (WebApplicationException e) {
                        output.getElementiNonMigrati().put((IDServizioApplicativo)wrap.getKey(), "Errore durante l'inserimento dell'applicativo: " + ((ProblemRFC7807)e.getResponse().getEntity()).getDetail());
                        output.removeAllWarnings(wrap);
                        continue;
                    }
                }
                output.getElementiGiaPresenti().add(wrap);
            }
            if (count % 5 != 0) continue;
            this.infoLogger.info("Inseriti [" + count + "/" + lst.size() + "] applicativi");
        }
        this.infoLogger.info("Inseriti [" + count + "/" + lst.size() + "] applicativi");
        return output;
    }
}

