/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.writer;

import it.link.pdd.tools.migrazione_govway.converter.OpenSPCoop2IdConverter;
import it.link.pdd.tools.migrazione_govway.drivers.DriverConfigurazioneServiziOpenSPCoopV2;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.PortaApplicativa;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.PortaDelegata;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.ServizioApplicativo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.Soggetto;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.driver.IDriverConfigurazioneCRUD;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.driver.db.DriverConfigurazioneDB;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDAccordo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDAccordoCooperazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDPortaApplicativaByNome;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDPortaDelegata;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDRuolo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDServizio;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDServizioApplicativo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDSoggetto;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.engine.ProtocolFactoryManager;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.AccordoCooperazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.AccordoServizioParteComune;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.AccordoServizioParteSpecifica;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Connettore;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Ruolo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.IDriverRegistroServiziCRUD;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.db.DriverRegistroServiziDB;
import it.link.pdd.tools.migrazione_govway.properties.DatabaseProperties;
import it.link.pdd.tools.migrazione_govway.properties.MigrazioneProperties;
import it.link.pdd.tools.migrazione_govway.wrapper.ConnettoriProperty;
import it.link.pdd.tools.migrazione_govway.wrapper.CorrelazioneRisposta;
import it.link.pdd.tools.migrazione_govway.wrapper.PortaApplicativaV2Wrapper;
import it.link.pdd.tools.migrazione_govway.wrapper.PortaDelegataV2Wrapper;
import it.link.pdd.tools.migrazione_govway.wrapper.PortaDominioV2Wrapper;
import it.link.pdd.tools.migrazione_govway.writer.AbstractOpenspcoop2Writer;
import java.sql.DriverManager;
import java.util.List;
import org.slf4j.Logger;

public class Openspcoop2ConfigurazioneServiziWriter
extends AbstractOpenspcoop2Writer {
    private IDriverRegistroServiziCRUD driverRegistro;
    private IDriverConfigurazioneCRUD driverConfigurazione;
    private DriverConfigurazioneServiziOpenSPCoopV2 driverAvanzato;
    private MigrazioneProperties props = MigrazioneProperties.getInstance();

    public Openspcoop2ConfigurazioneServiziWriter(DatabaseProperties init, Logger log) throws Exception {
        super(log);
        try {
            this.dsMode = init.isDataSourceMode();
            if (this.dsMode) {
                this.driverRegistro = new DriverRegistroServiziDB(init.getJndiName(), init.getJndiProp(), init.getTipoDatabase());
                this.driverConfigurazione = new DriverConfigurazioneDB(init.getJndiName(), init.getJndiProp(), init.getTipoDatabase());
                this.driverAvanzato = new DriverConfigurazioneServiziOpenSPCoopV2(init.getJndiName(), init.getJndiProp(), log, init.getTipoDatabase());
            } else {
                Class.forName(init.getDriverJDBC());
                this.connection = DriverManager.getConnection(init.getConnectionURL(), init.getUsername(), init.getPassword());
                this.driverRegistro = new DriverRegistroServiziDB(this.connection, log, init.getTipoDatabase());
                this.driverConfigurazione = new DriverConfigurazioneDB(this.connection, log, init.getTipoDatabase());
                this.driverAvanzato = new DriverConfigurazioneServiziOpenSPCoopV2(this.connection, log, init.getTipoDatabase());
            }
        }
        catch (Exception e) {
            log.error("Impossibile inizializzare il driver del database OpenSPCoop2 di destinazione: " + e.getMessage(), (Throwable)e);
            throw new Exception("Impossibile inizializzare il driver del database OpenSPCoop2 di destinazione: " + e.getMessage(), e);
        }
    }

    public void insertAllPdD(List<PortaDominioV2Wrapper> lst) throws Exception {
        for (PortaDominioV2Wrapper obj : lst) {
            String id = OpenSPCoop2IdConverter.getInstance().convertToId(obj.getPorta());
            if (!this.driverRegistro.existsPortaDominio(id)) {
                this.driverRegistro.createPortaDominio(obj.getPorta());
                this.driverAvanzato.updateTipoPortaDominio(id, obj.getTipo().toString());
                this.log.info("Porta di Dominio con id [" + id + "] creata con successo");
                continue;
            }
            if (this.props.isUpdateOnExists()) {
                obj.getPorta().setOldNomeForUpdate(id);
                this.driverRegistro.updatePortaDominio(obj.getPorta());
                this.driverAvanzato.updateTipoPortaDominio(id, obj.getTipo().toString());
                this.log.info("Porta di Dominio con id [" + id + "] aggiornata con successo");
                continue;
            }
            this.log.warn("Porta di Dominio con id [" + id + "] gia' esistente nel db, non la creo");
        }
    }

    public void insertAllSoggettiRegistro(List<it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Soggetto> lst) throws Exception {
        for (it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Soggetto obj : lst) {
            IDSoggetto id = OpenSPCoop2IdConverter.getInstance().convertToId(obj);
            if (!this.driverRegistro.existsSoggetto(id)) {
                this.driverRegistro.createSoggetto(obj);
                this.log.info("Soggetto con id [" + id + "] creato con successo");
                continue;
            }
            if (this.props.isUpdateOnExists()) {
                obj.setOldNomeForUpdate(id.getNome());
                obj.setOldTipoForUpdate(id.getTipo());
                this.driverRegistro.updateSoggetto(obj);
                this.log.info("Soggetto con id [" + id + "] aggiornato con successo");
                continue;
            }
            this.log.warn("Soggetto con id [" + id + "] gia' esistente nel db, non lo creo");
        }
        List tipi = ProtocolFactoryManager.getInstance().getSubjectTypesAsList();
        String nomeSoggettoReferenteDefault = MigrazioneProperties.getInstance().getNomeSoggettoReferenteDefault();
        for (String tipo : tipi) {
            if (this.driverRegistro.existsSoggetto(new IDSoggetto(tipo, nomeSoggettoReferenteDefault))) continue;
            it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Soggetto soggetto = new it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Soggetto();
            soggetto.setNome(nomeSoggettoReferenteDefault);
            soggetto.setTipo(tipo);
            soggetto.setCodiceIpa(ProtocolFactoryManager.getInstance().getProtocolFactoryBySubjectType(tipo).createTraduttore().getIdentificativoCodiceIPADefault(new IDSoggetto(tipo, nomeSoggettoReferenteDefault), false));
            Connettore connettore = new Connettore();
            connettore.setTipo("disabilitato");
            soggetto.setConnettore(connettore);
            this.driverRegistro.createSoggetto(soggetto);
        }
    }

    public void insertAllAccordiParteComune(List<AccordoServizioParteComune> lst) throws Exception {
        for (AccordoServizioParteComune obj : lst) {
            IDAccordo id = OpenSPCoop2IdConverter.getInstance().convertToId(obj);
            if (!this.driverRegistro.existsAccordoServizioParteComune(id)) {
                this.driverRegistro.createAccordoServizioParteComune(obj);
                this.log.info("AccordoServizioParteComune con id [" + id + "] creato con successo");
                continue;
            }
            if (this.props.isUpdateOnExists()) {
                obj.setOldIDAccordoForUpdate(id);
                this.driverRegistro.updateAccordoServizioParteComune(obj);
                this.log.info("AccordoServizioParteComune con id [" + id + "] aggiornato con successo");
                continue;
            }
            this.log.warn("AccordoServizioParteComune con id [" + id + "] gia' esistente nel db, non lo creo");
        }
    }

    public void insertAllServizi(List<AccordoServizioParteSpecifica> lst) throws Exception {
        for (AccordoServizioParteSpecifica obj : lst) {
            IDServizio id = OpenSPCoop2IdConverter.getInstance().convertToId(obj);
            this.log.debug("ID Accordo: " + id);
            if (!this.driverRegistro.existsAccordoServizioParteSpecifica(id)) {
                this.driverRegistro.createAccordoServizioParteSpecifica(obj);
                this.log.info("AccordoServizioParteSpecifica con id [" + id + "] creato con successo");
                continue;
            }
            if (this.props.isUpdateOnExists()) {
                obj.getServizio().setOldTipoForUpdate(obj.getServizio().getTipo());
                obj.getServizio().setOldNomeForUpdate(obj.getServizio().getNome());
                obj.getServizio().setOldTipoSoggettoErogatoreForUpdate(obj.getServizio().getTipoSoggettoErogatore());
                obj.getServizio().setOldNomeSoggettoErogatoreForUpdate(obj.getServizio().getNomeSoggettoErogatore());
                obj.setOldNomeAccordoForUpdate(obj.getNome());
                obj.setOldVersioneAccordoForUpdate(obj.getVersione());
                this.driverRegistro.updateAccordoServizioParteSpecifica(obj);
                this.log.info("AccordoServizioParteSpecifica con id [" + id + "] aggiornato con successo");
                continue;
            }
            this.log.warn("AccordoServizioParteSpecifica con id [" + id + "] gia' esistente nel db, non lo creo");
        }
    }

    public void insertAllAccordiCooperazione(List<AccordoCooperazione> lst) throws Exception {
        for (AccordoCooperazione obj : lst) {
            IDAccordoCooperazione id = OpenSPCoop2IdConverter.getInstance().convertToId(obj);
            if (!this.driverRegistro.existsAccordoCooperazione(id)) {
                this.driverRegistro.createAccordoCooperazione(obj);
                this.log.info("Accordo Cooperazione con id [" + id + "] creato con successo");
                continue;
            }
            if (this.props.isUpdateOnExists()) {
                obj.setOldIDAccordoForUpdate(id);
                this.driverRegistro.updateAccordoCooperazione(obj);
                this.log.info("Accordo Cooperazione con id [" + id + "] aggiornato con successo");
                continue;
            }
            this.log.warn("Accordo Cooperazione con id [" + id + "] gia' esistente nel db, non lo creo");
        }
    }

    public void insertAllSoggettiConfig(List<Soggetto> lst) throws Exception {
        for (Soggetto obj : lst) {
            IDSoggetto id = OpenSPCoop2IdConverter.getInstance().convertToId(obj);
            if (this.driverConfigurazione.existsSoggetto(id)) {
                obj.setOldNomeForUpdate(id.getNome());
                obj.setOldTipoForUpdate(id.getTipo());
                this.driverConfigurazione.updateSoggetto(obj);
                this.log.info("Soggetto con id [" + id + "] aggiornato con successo");
                continue;
            }
            this.log.warn("Soggetto con id [" + id + "] non esistente nel db di Registro, impossibile aggiornarne le informazioni di configurazione");
        }
    }

    public void insertAllServiziApplicativi(List<ServizioApplicativo> lst) throws Exception {
        for (ServizioApplicativo obj : lst) {
            IDServizioApplicativo id = OpenSPCoop2IdConverter.getInstance().convertToId(obj);
            if (!this.driverConfigurazione.existsServizioApplicativo(id)) {
                this.driverConfigurazione.createServizioApplicativo(obj);
                this.log.info("ServizioApplicativo con id [" + id + "] creato con successo");
                continue;
            }
            if (this.props.isUpdateOnExists()) {
                obj.setOldNomeForUpdate(id.getNome());
                obj.setOldNomeSoggettoProprietarioForUpdate(id.getIdSoggettoProprietario().getNome());
                obj.setOldTipoSoggettoProprietarioForUpdate(id.getIdSoggettoProprietario().getTipo());
                this.driverConfigurazione.updateServizioApplicativo(obj);
                this.log.info("ServizioApplicativo con id [" + id + "] aggiornato con successo");
                continue;
            }
            this.log.warn("ServizioApplicativo con id [" + id + "] gia' esistente nel db, non lo creo");
        }
    }

    public void insertAllPorteApplicative(List<PortaApplicativaV2Wrapper> lst) throws Exception {
        for (PortaApplicativaV2Wrapper wrap : lst) {
            PortaApplicativa pa;
            PortaApplicativa obj = wrap.getPortaApplicativa();
            IDPortaApplicativaByNome id = OpenSPCoop2IdConverter.getInstance().convertToId(obj);
            if (!this.driverConfigurazione.existsPortaApplicativa(id)) {
                this.driverConfigurazione.createPortaApplicativa(obj);
                this.log.info("PortaApplicativa con id [" + id + "] creata con successo");
                if (wrap.getCorrelazioneRisposta() == null || wrap.getCorrelazioneRisposta().isEmpty()) continue;
                pa = ((DriverConfigurazioneDB)this.driverConfigurazione).getPortaApplicativa(id);
                for (CorrelazioneRisposta corr : wrap.getCorrelazioneRisposta()) {
                    corr.setIdPorta(pa.getId());
                    this.driverAvanzato.insertPACorrRisp(corr);
                    this.log.info("CorrelazioneRisposta [" + corr + "] per la porta con id [" + id + "] creata con successo");
                }
                continue;
            }
            if (this.props.isUpdateOnExists()) {
                obj.setOldNomeForUpdate(id.getNome());
                obj.setOldNomeSoggettoProprietarioForUpdate(id.getSoggetto().getNome());
                obj.setOldTipoSoggettoProprietarioForUpdate(id.getSoggetto().getTipo());
                this.driverConfigurazione.updatePortaApplicativa(obj);
                if (wrap.getCorrelazioneRisposta() != null) {
                    pa = ((DriverConfigurazioneDB)this.driverConfigurazione).getPortaApplicativa(id);
                    this.driverAvanzato.deleteAllPACorrRisp(pa.getId());
                    if (!wrap.getCorrelazioneRisposta().isEmpty()) {
                        for (CorrelazioneRisposta corr : wrap.getCorrelazioneRisposta()) {
                            corr.setIdPorta(pa.getId());
                            this.driverAvanzato.insertPACorrRisp(corr);
                            this.log.info("CorrelazioneRisposta [" + corr + "] per la porta con id [" + id + "] creata con successo");
                        }
                    }
                }
                this.log.info("PortaApplicativa con id [" + id + "] aggiornata con successo");
                continue;
            }
            this.log.warn("PortaApplicativa con id [" + id + "] gia' esistente nel db, non la creo");
        }
    }

    public void insertAllPorteDelegate(List<PortaDelegataV2Wrapper> lst) throws Exception {
        for (PortaDelegataV2Wrapper wrap : lst) {
            PortaDelegata pd;
            PortaDelegata obj = wrap.getPortaDelegata();
            IDPortaDelegata id = OpenSPCoop2IdConverter.getInstance().convertToId(obj);
            if (!this.driverConfigurazione.existsPortaDelegata(id)) {
                this.driverConfigurazione.createPortaDelegata(obj);
                this.log.info("PortaDelegata con id [" + id + "] creata con successo");
                if (wrap.getCorrelazioneRisposta() == null || wrap.getCorrelazioneRisposta().isEmpty()) continue;
                pd = ((DriverConfigurazioneDB)this.driverConfigurazione).getPortaDelegata(id);
                for (CorrelazioneRisposta corr : wrap.getCorrelazioneRisposta()) {
                    corr.setIdPorta(pd.getId());
                    this.driverAvanzato.insertPDCorrRisp(corr);
                    this.log.info("CorrelazioneRisposta [" + corr + "] per la porta con id [" + id + "] creata con successo");
                }
                continue;
            }
            if (this.props.isUpdateOnExists()) {
                obj.setOldNomeForUpdate(obj.getNome());
                obj.setOldNomeSoggettoProprietarioForUpdate(id.getSoggettoFruitore().getNome());
                obj.setOldTipoSoggettoProprietarioForUpdate(id.getSoggettoFruitore().getTipo());
                this.driverConfigurazione.updatePortaDelegata(obj);
                this.log.info("PortaDelegata con id [" + id + "] aggiornata con successo");
                if (wrap.getCorrelazioneRisposta() == null) continue;
                pd = ((DriverConfigurazioneDB)this.driverConfigurazione).getPortaDelegata(id);
                this.driverAvanzato.deleteAllPDCorrRisp(pd.getId());
                if (wrap.getCorrelazioneRisposta().isEmpty()) continue;
                for (CorrelazioneRisposta corr : wrap.getCorrelazioneRisposta()) {
                    corr.setIdPorta(pd.getId());
                    if (!this.driverAvanzato.existsPDCorrRisp(corr)) {
                        this.driverAvanzato.insertPDCorrRisp(corr);
                        this.log.info("CorrelazioneRisposta [" + corr + "] per la porta con id [" + id + "] creata con successo");
                        continue;
                    }
                    this.driverAvanzato.updatePDCorrRisp(corr);
                    this.log.info("CorrelazioneRisposta [" + corr + "] per la porta con id [" + id + "] aggiornata con successo");
                }
                continue;
            }
            this.log.warn("PortaDelegata con id [" + id + "] gia' esistente nel db, non la creo");
        }
    }

    public void insertAllConnettoreProperties(List<ConnettoriProperty> lst) throws Exception {
        for (ConnettoriProperty obj : lst) {
            String id = OpenSPCoop2IdConverter.getInstance().convertToId(obj);
            if (!this.driverAvanzato.existsConnettoreProperties(id)) {
                this.driverAvanzato.createConnettoreProperties(obj);
                this.log.info("ConnettoriProperty con id [" + id + "] creata con successo");
                continue;
            }
            if (this.props.isUpdateOnExists()) {
                this.driverAvanzato.updateConnettoreProperties(id, obj);
                this.log.info("ConnettoriProperty con id [" + id + "] aggiornata con successo");
                continue;
            }
            this.log.warn("ConnettoriProperty con id [" + id + "] gia' esistente nel db, non la creo");
        }
    }

    public void insertAllRuoli(List<Ruolo> lst) throws Exception {
        for (Ruolo obj : lst) {
            IDRuolo idRuolo = new IDRuolo(obj.getNome());
            if (!this.driverRegistro.existsRuolo(idRuolo)) {
                this.driverRegistro.createRuolo(obj);
                this.log.info("Ruolo con id [" + idRuolo + "] creato con successo");
                continue;
            }
            if (this.props.isUpdateOnExists()) {
                this.driverRegistro.updateRuolo(obj);
                this.log.info("Ruolo con id [" + idRuolo + "] aggiornato con successo");
                continue;
            }
            this.log.warn("Ruolo con id [" + idRuolo + "] gia' esistente nel db, non lo creo");
        }
    }
}

