/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.writer;

import it.link.pdd.tools.migrazione_govway.Utilities;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.OpenspcoopAppender;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.Property;
import it.link.pdd.tools.migrazione_govway.properties.DatabaseProperties;
import java.sql.Connection;
import java.sql.SQLException;
import org.slf4j.Logger;

public class AbstractOpenspcoop2Writer {
    protected Logger log;
    protected boolean dsMode;
    protected Connection connection;

    public void closeConnection() throws SQLException {
        if (!this.dsMode) {
            this.connection.close();
        }
    }

    public AbstractOpenspcoop2Writer(Logger log) throws Exception {
        this.log = log;
        Utilities.initProtocolFactory();
        Utilities.initExtendedInfoManager();
    }

    protected OpenspcoopAppender getOp2Appender(DatabaseProperties init) throws Exception {
        return this.getOp2Appender(init, false, false);
    }

    protected OpenspcoopAppender getOp2Appender(DatabaseProperties init, boolean usePdDConnection, boolean debug) throws Exception {
        Property addUsePdDConnection;
        OpenspcoopAppender appenderProperties = new OpenspcoopAppender();
        if (init.isDataSourceMode()) {
            Property dsProperty = new Property();
            dsProperty.setNome("datasource");
            dsProperty.setValore(init.getJndiName());
            appenderProperties.addProperty(dsProperty);
            Property tipoDBProperty = new Property();
            tipoDBProperty.setNome("tipoDatabase");
            tipoDBProperty.setValore(init.getTipoDatabase());
            appenderProperties.addProperty(tipoDBProperty);
        } else {
            Property connectionURLProperty = new Property();
            connectionURLProperty.setNome("connectionUrl");
            connectionURLProperty.setValore(init.getConnectionURL());
            appenderProperties.addProperty(connectionURLProperty);
            Property tipoDBProperty = new Property();
            tipoDBProperty.setNome("tipoDatabase");
            tipoDBProperty.setValore(init.getTipoDatabase());
            appenderProperties.addProperty(tipoDBProperty);
            Property connectionDriverProperty = new Property();
            connectionDriverProperty.setNome("connectionDriver");
            connectionDriverProperty.setValore(init.getDriverJDBC());
            appenderProperties.addProperty(connectionDriverProperty);
            if (init.getUsername() != null) {
                Property connectionUsernameProperty = new Property();
                connectionUsernameProperty.setNome("connectionUsername");
                connectionUsernameProperty.setValore(init.getUsername());
                appenderProperties.addProperty(connectionUsernameProperty);
            }
            if (init.getPassword() != null) {
                Property connectionPasswordProperty = new Property();
                connectionPasswordProperty.setNome("connectionPassword");
                connectionPasswordProperty.setValore(init.getPassword());
                appenderProperties.addProperty(connectionPasswordProperty);
            }
        }
        if (usePdDConnection) {
            addUsePdDConnection = new Property();
            addUsePdDConnection.setNome("usePdDConnection");
            addUsePdDConnection.setValore("true");
            appenderProperties.addProperty(addUsePdDConnection);
        }
        if (debug) {
            addUsePdDConnection = new Property();
            addUsePdDConnection.setNome("debug");
            addUsePdDConnection.setValore("true");
            appenderProperties.addProperty(addUsePdDConnection);
        }
        return appenderProperties;
    }
}

