/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.properties;

import it.link.pdd.tools.migrazione_govway.utils.resources.PropertiesReader;
import it.link.pdd.tools.migrazione_govway.wrapper.IdSoggettoWrapper;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Properties;

public class MigrazioneProperties {
    private static MigrazioneProperties instance;
    private String configurazioneServiziReaderClass;
    private String configurazioneServiziReaderGovwayClass;
    private TIPO_MIGRAZIONE_SERVIZI tipoMigrazioneServizi;
    private boolean updateOnExists;
    private String reportFolder;
    private String protocollo;
    private String metadatiErogazioni;
    private String metadatiFruizioni;
    private IdSoggettoWrapper[] idSoggettiDefault;
    private String tipoSoggettoReferenteDefault;
    private String nomeSoggettoReferenteDefault;

    public static MigrazioneProperties getInstance() throws Exception {
        if (instance == null) {
            throw new Exception("Properties non inizializzate");
        }
        return instance;
    }

    public static void init(String propFile) throws Exception {
        instance = new MigrazioneProperties(propFile);
    }

    public MigrazioneProperties(String propFile) throws Exception {
        String metadatiFruizioniString;
        InputStream is = MigrazioneProperties.class.getResourceAsStream("/" + propFile);
        Properties props = new Properties();
        props.load(is);
        String versione = props.getProperty("migrazione.versioneSorgente");
        if (versione == null) {
            throw new Exception("Parametro [migrazione.versioneSorgente] non trovato nel file [" + propFile + "]");
        }
        String classNameReader = "configurazioneServiziReader." + versione.trim() + ".className";
        String configurazioneServiziReaderClassString = props.getProperty(classNameReader);
        if (configurazioneServiziReaderClassString == null) {
            throw new Exception("Parametro [" + classNameReader + "] non trovato nel file [" + propFile + "]");
        }
        this.configurazioneServiziReaderClass = configurazioneServiziReaderClassString.trim();
        String configurazioneServiziReaderGovwayClassString = props.getProperty("configurazioneServiziReaderGovway.className");
        if (configurazioneServiziReaderGovwayClassString == null) {
            throw new Exception("Parametro [configurazioneServiziReaderGovway.className] non trovato nel file [" + propFile + "]");
        }
        this.configurazioneServiziReaderGovwayClass = configurazioneServiziReaderGovwayClassString.trim();
        String updateOnExistsString = props.getProperty("updateOnExists");
        if (updateOnExistsString == null) {
            throw new Exception("Parametro [updateOnExists] non trovato nel file [" + propFile + "]");
        }
        this.updateOnExists = Boolean.parseBoolean(updateOnExistsString.trim());
        String protocolloString = props.getProperty("protocollo");
        if (protocolloString == null) {
            throw new Exception("Parametro [protocollo] non trovato nel file [" + propFile + "]");
        }
        this.protocollo = protocolloString.trim();
        String reportFolderString = props.getProperty("reportFolder");
        if (reportFolderString == null) {
            throw new Exception("Parametro [reportFolder] non trovato nel file [" + propFile + "]");
        }
        this.reportFolder = reportFolderString.trim();
        this.idSoggettiDefault = this.getIdSoggettiDefault(props, "soggettoDefault.");
        String referenteTipoDefault = props.getProperty("soggettoReferenteDefault.tipo");
        if (referenteTipoDefault == null) {
            throw new Exception("Parametro [soggettoReferenteDefault.tipo] non trovato nel file [" + propFile + "]");
        }
        this.tipoSoggettoReferenteDefault = referenteTipoDefault.trim();
        String referenteNomeDefault = props.getProperty("soggettoReferenteDefault.nome");
        if (referenteNomeDefault == null) {
            throw new Exception("Parametro [soggettoReferenteDefault.nome] non trovato nel file [" + propFile + "]");
        }
        this.nomeSoggettoReferenteDefault = referenteNomeDefault.trim();
        String tipoMigrazioneServiziString = props.getProperty("govway.tipoMigrazioneServiziSPC");
        if (tipoMigrazioneServiziString == null) {
            this.tipoMigrazioneServizi = TIPO_MIGRAZIONE_SERVIZI.SPC;
        } else {
            try {
                this.tipoMigrazioneServizi = TIPO_MIGRAZIONE_SERVIZI.valueOf(tipoMigrazioneServiziString);
                if (this.tipoMigrazioneServizi == null) {
                    throw new Exception("Valore " + tipoMigrazioneServiziString + " non valido");
                }
            }
            catch (Exception e) {
                throw new Exception("Parametro [tipoMigrazioneServizi] trovato nel file [" + propFile + "] non valido: " + e.getMessage());
            }
        }
        String metadatiErogazioniString = props.getProperty("metadati.erogazioni");
        if (metadatiErogazioniString != null && !metadatiErogazioniString.trim().isEmpty()) {
            this.metadatiErogazioni = metadatiErogazioniString.trim();
        }
        if ((metadatiFruizioniString = props.getProperty("metadati.fruizioni")) != null && !metadatiFruizioniString.trim().isEmpty()) {
            this.metadatiFruizioni = metadatiFruizioniString.trim();
        }
    }

    private IdSoggettoWrapper[] getIdSoggettiDefault(Properties props, String prefix) throws Exception {
        HashMap<String, IdSoggettoWrapper> idSoggettiMap = new HashMap<String, IdSoggettoWrapper>();
        PropertiesReader idSoggettiReader = new PropertiesReader(props, false);
        Properties idSoggettiProps = idSoggettiReader.readProperties(prefix);
        for (Object oKey : idSoggettiProps.keySet()) {
            String key = (String)oKey;
            String[] split = key.split("\\.");
            String soggetto = split[0];
            if (idSoggettiMap.containsKey(soggetto)) continue;
            PropertiesReader idSoggettiReader2 = new PropertiesReader(idSoggettiProps, false);
            Properties soggettoProperties = idSoggettiReader2.readProperties(soggetto + ".");
            idSoggettiMap.put(soggetto, this.getIdSoggetto(soggettoProperties, soggetto));
        }
        if (!idSoggettiMap.isEmpty()) {
            return idSoggettiMap.values().toArray(new IdSoggettoWrapper[1]);
        }
        return new IdSoggettoWrapper[0];
    }

    private IdSoggettoWrapper getIdSoggetto(Properties props, String soggetto) throws Exception {
        String codicePorta = props.getProperty("codicePorta");
        if (codicePorta == null) {
            throw new Exception("Codice porta non definito per soggetto di default [" + soggetto + "]");
        }
        String nomeSoggetto = props.getProperty("nomeSoggetto");
        if (nomeSoggetto == null) {
            throw new Exception("Nome soggetto non definito per soggetto di default [" + soggetto + "]");
        }
        String tipoSoggetto = props.getProperty("tipoSoggetto");
        if (tipoSoggetto == null) {
            throw new Exception("Tipo soggetto non definito per soggetto di default [" + soggetto + "]");
        }
        IdSoggettoWrapper wrapper = new IdSoggettoWrapper();
        wrapper.setNome(nomeSoggetto);
        wrapper.setTipo(tipoSoggetto);
        wrapper.setCodicePorta(codicePorta);
        return wrapper;
    }

    public String getTipoSoggettoReferenteDefault() {
        return this.tipoSoggettoReferenteDefault;
    }

    public String getNomeSoggettoReferenteDefault() {
        return this.nomeSoggettoReferenteDefault;
    }

    public boolean isUpdateOnExists() {
        return this.updateOnExists;
    }

    public String getProtocollo() {
        return this.protocollo;
    }

    public IdSoggettoWrapper[] getIdSoggettiDefault() {
        return this.idSoggettiDefault;
    }

    public String getConfigurazioneServiziReaderClass() {
        return this.configurazioneServiziReaderClass;
    }

    public TIPO_MIGRAZIONE_SERVIZI getTipoMigrazioneServizi() {
        return this.tipoMigrazioneServizi;
    }

    public String getConfigurazioneServiziReaderGovwayClass() {
        return this.configurazioneServiziReaderGovwayClass;
    }

    public String getReportFolder() {
        return this.reportFolder;
    }

    public void setReportFolder(String reportFolder) {
        this.reportFolder = reportFolder;
    }

    public String getMetadatiFruizioni() {
        return this.metadatiFruizioni;
    }

    public String getMetadatiErogazioni() {
        return this.metadatiErogazioni;
    }

    public static enum TIPO_MIGRAZIONE_SERVIZI {
        SPC,
        GW,
        SPC_E_GW;

    }
}

