/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.properties;

import it.link.pdd.tools.migrazione_govway.MigrazioneConfigurazioneServizi;
import it.link.pdd.tools.migrazione_govway.generic_project.utils.ServerProperties;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;

public class DatabaseProperties {
    private String jndiName;
    private Properties jndiProp = new Properties();
    private String tipoDatabase;
    private String connectionURL;
    private String driverJDBC;
    private String username;
    private String password;
    private boolean dataSourceMode;

    public String getJndiName() {
        return this.jndiName;
    }

    public Properties getJndiProp() {
        return this.jndiProp;
    }

    public String getTipoDatabase() {
        return this.tipoDatabase;
    }

    public String getConnectionURL() {
        return this.connectionURL;
    }

    public String getDriverJDBC() {
        return this.driverJDBC;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean isDataSourceMode() {
        return this.dataSourceMode;
    }

    public DatabaseProperties(String filename, Logger log) throws Exception {
        log.debug("Inizializzazione in corso...");
        InputStream inProp = null;
        try {
            inProp = MigrazioneConfigurazioneServizi.class.getResourceAsStream("/" + filename);
            Properties properties = new Properties();
            properties.load(inProp);
            ServerProperties readerProperties = new ServerProperties(properties);
            String tmpDataSourceMode = readerProperties.getProperty("tipo", true);
            this.dataSourceMode = "ds".equalsIgnoreCase(tmpDataSourceMode.trim());
            log.debug("DataSource Mode...[" + this.dataSourceMode + "]");
            this.tipoDatabase = readerProperties.getProperty("tipoDatabase", true);
            log.debug("TipoDatabase...[" + this.tipoDatabase + "]");
            if (this.dataSourceMode) {
                this.jndiName = readerProperties.getProperty("dataSource", true);
                log.debug("DataSource...[" + this.jndiName + "]");
                this.jndiProp = readerProperties.readProperties("dataSource.property.");
                log.debug("DataSourceCtx...size[" + this.jndiProp.size() + "]");
            } else {
                this.driverJDBC = readerProperties.getProperty("driver", true);
                this.connectionURL = readerProperties.getProperty("connection-url", true);
                this.username = readerProperties.getProperty("username", false);
                this.password = readerProperties.getProperty("password", false);
            }
        }
        catch (Exception e) {
            log.error("Rilevato errore durante la lettura del file '" + filename + "': " + e.getMessage(), (Throwable)e);
            throw new Exception("Rilevato errore durante la lettura del file '" + filename + "': " + e.getMessage(), e);
        }
        finally {
            try {
                if (inProp != null) {
                    inProp.close();
                }
            }
            catch (Exception exception) {}
        }
        log.debug("Lettura datasource.properties terminata, jndiName: [" + this.jndiName + "]");
    }
}

