/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.drivers;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.driver.DriverConfigurazioneException;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.driver.db.DriverConfigurazioneDB_LIB;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDSoggetto;
import it.link.pdd.tools.migrazione_govway.utils.LoggerWrapperFactory;
import it.link.pdd.tools.migrazione_govway.utils.sql.ISQLQueryObject;
import it.link.pdd.tools.migrazione_govway.utils.sql.SQLObjectFactory;
import it.link.pdd.tools.migrazione_govway.wrapper.ConnettoriProperty;
import it.link.pdd.tools.migrazione_govway.wrapper.CorrelazioneRisposta;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.openspcoop2.core.config.rs.server.model.DominioEnum;
import org.slf4j.Logger;

public class DriverConfigurazioneServiziOpenSPCoopV2 {
    public DataSource datasource = null;
    protected Connection globalConnection = null;
    protected boolean atomica = true;
    protected Logger log = null;
    protected String tipoDB = null;
    private Map<Long, DominioEnum> dominiSoggetti;

    public DriverConfigurazioneServiziOpenSPCoopV2(String nomeDataSource, Properties context, String tipoDB) throws Exception {
        this(nomeDataSource, context, null, tipoDB);
    }

    public DriverConfigurazioneServiziOpenSPCoopV2(String nomeDataSource, Properties context, Logger alog, String tipoDB) throws Exception {
        this(nomeDataSource, context, alog, tipoDB, false);
    }

    public DriverConfigurazioneServiziOpenSPCoopV2(String nomeDataSource, Properties context, Logger alog, String tipoDB, boolean tabellaSoggettiPDD) throws Exception {
        this.initDriverConfigurazioneFindAll(nomeDataSource, context, alog, tipoDB, tabellaSoggettiPDD);
    }

    public DriverConfigurazioneServiziOpenSPCoopV2(Connection connection, Logger alog, String tipoDB) throws Exception {
        if (alog == null) {
            this.log = LoggerWrapperFactory.getLogger((String)"DRIVER_DB_CONFIGURAZIONE");
        } else {
            this.log = alog;
            DriverConfigurazioneDB_LIB.initStaticLogger((Logger)this.log);
        }
        if (connection == null) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::DriverConfigurazioneDB(Connection con, Properties context) La connection non puo essere null.");
        }
        if (tipoDB == null) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::DriverConfigurazioneDB(Connection ) Il tipoDatabase non puo essere null.");
        }
        this.globalConnection = connection;
        this.atomica = false;
        this.tipoDB = tipoDB;
    }

    private void initDriverConfigurazioneFindAll(String nomeDataSource, Properties context, Logger alog, String tipoDB, boolean tabellaSoggettiPDD) throws Exception {
        try {
            if (alog == null) {
                this.log = LoggerWrapperFactory.getLogger((String)"DRIVER_DB_CONFIGURAZIONE");
            } else {
                this.log = alog;
                DriverConfigurazioneDB_LIB.initStaticLogger((Logger)this.log);
            }
            InitialContext initCtx = new InitialContext(context);
            this.datasource = (DataSource)initCtx.lookup(nomeDataSource);
            initCtx.close();
        }
        catch (NamingException ne) {
            this.log.error("Impossibile recuperare il context: " + ne.getMessage());
            throw new Exception("Impossibile recuperare il context: " + ne.getMessage());
        }
        if (tipoDB == null) {
            this.log.error("Il tipoDatabase non puo essere null.");
            throw new Exception("Il tipoDatabase non puo essere null.");
        }
        this.atomica = true;
        this.tipoDB = tipoDB;
    }

    public void updateTipoPortaDominio(String nomePorta, String tipo) throws DriverConfigurazioneException {
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        this.log.debug("updateTipoPortaDominio id [" + nomePorta + "] tipo [" + tipo + "]...");
        try {
            this.log.debug("operazione atomica = " + this.atomica);
            con = this.atomica ? this.datasource.getConnection() : this.globalConnection;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addUpdateTable("pdd");
            sqlQueryObject.addUpdateField("tipo", "?");
            sqlQueryObject.addWhereCondition("nome = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlUpdate = sqlQueryObject.createSQLUpdate();
            this.log.debug("eseguo update : " + sqlUpdate);
            stm = con.prepareStatement(sqlUpdate);
            stm.setString(1, tipo);
            stm.setString(2, nomePorta);
            stm.execute();
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException("updateTipoPortaDominio id [" + nomePorta + "] tipo [" + tipo + "] error", (Throwable)e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessione al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public String getTipoPortaDominio(String nomePorta) throws DriverConfigurazioneException {
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        this.log.debug("getTipoPortaDominio [" + nomePorta + "]...");
        try {
            this.log.debug("operazione atomica = " + this.atomica);
            con = this.atomica ? this.datasource.getConnection() : this.globalConnection;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("pdd");
            sqlQueryObject.addSelectField("pdd.tipo");
            sqlQueryObject.addWhereCondition("pdd.nome = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            this.log.debug("eseguo query : " + sqlQuery);
            stm = con.prepareStatement(sqlQuery);
            stm.setString(1, nomePorta);
            rs = stm.executeQuery();
            if (rs.next()) {
                String string = rs.getString("tipo");
                return string;
            }
            try {
                throw new Exception("Porta [" + nomePorta + "] non trovata");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("getTipoPortaDominio [" + nomePorta + "] error", (Throwable)e);
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessione al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public DominioEnum getDominio(long id) throws DriverConfigurazioneException {
        if (this.dominiSoggetti == null) {
            this.dominiSoggetti = this.getDominiSoggetti();
        }
        if (this.dominiSoggetti.containsKey(id)) {
            return this.dominiSoggetti.get(id);
        }
        return DominioEnum.ESTERNO;
    }

    public boolean migraSoggettiProxy() throws DriverConfigurazioneException {
        String sqlQuery;
        ISQLQueryObject sqlQueryObject;
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        this.log.debug("migraSoggettiProxy");
        long cnt = 0L;
        try {
            this.log.debug("operazione atomica = " + this.atomica);
            con = this.atomica ? this.datasource.getConnection() : this.globalConnection;
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("porte_applicative");
            sqlQueryObject.addSelectCountField("porte_applicative.id", "cnt");
            sqlQueryObject.addWhereCondition("porte_applicative.id_soggetto in (select id from soggetti where tipo_soggetto  = ?)");
            sqlQuery = sqlQueryObject.createSQLQuery();
            this.log.debug("eseguo query : " + sqlQuery);
            stm = con.prepareStatement(sqlQuery);
            stm.setString(1, "PROXY");
            rs = stm.executeQuery();
            if (rs.next()) {
                cnt += rs.getLong("cnt");
            }
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException("migraSoggettiProxy error", (Throwable)e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
        }
        try {
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("porte_delegate");
            sqlQueryObject.addSelectCountField("porte_delegate.id", "cnt");
            sqlQueryObject.addWhereCondition("porte_delegate.id_soggetto in (select id from soggetti where tipo_soggetto  = ?)");
            sqlQuery = sqlQueryObject.createSQLQuery();
            this.log.debug("eseguo query : " + sqlQuery);
            stm = con.prepareStatement(sqlQuery);
            stm.setString(1, "PROXY");
            rs = stm.executeQuery();
            if (rs.next()) {
                cnt += rs.getLong("cnt");
            }
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException("migraSoggettiProxy error", (Throwable)e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessione al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
        try {
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("accordi");
            sqlQueryObject.addSelectCountField("accordi.id", "cnt");
            sqlQueryObject.addWhereCondition("accordi.id_referente in (select id from soggetti where tipo_soggetto  = ?)");
            sqlQuery = sqlQueryObject.createSQLQuery();
            this.log.debug("eseguo query : " + sqlQuery);
            stm = con.prepareStatement(sqlQuery);
            stm.setString(1, "PROXY");
            rs = stm.executeQuery();
            if (rs.next()) {
                cnt += rs.getLong("cnt");
            }
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException("migraSoggettiProxy error", (Throwable)e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessione al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
        try {
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("servizi_applicativi");
            sqlQueryObject.addSelectCountField("servizi_applicativi.id", "cnt");
            sqlQueryObject.addWhereCondition("servizi_applicativi.id_soggetto in (select id from soggetti where tipo_soggetto  = ?)");
            sqlQuery = sqlQueryObject.createSQLQuery();
            this.log.debug("eseguo query : " + sqlQuery);
            stm = con.prepareStatement(sqlQuery);
            stm.setString(1, "PROXY");
            rs = stm.executeQuery();
            if (rs.next()) {
                cnt += rs.getLong("cnt");
            }
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException("migraSoggettiProxy error", (Throwable)e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessione al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
        this.log.debug("Numero di elementi trovati corrispondenti a soggetti PROXY: " + cnt);
        return cnt > 0L;
    }

    private Map<Long, DominioEnum> getDominiSoggetti() throws DriverConfigurazioneException {
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        this.log.debug("getDominiSoggetti");
        try {
            this.log.debug("operazione atomica = " + this.atomica);
            con = this.atomica ? this.datasource.getConnection() : this.globalConnection;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("pdd");
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectCountField("pdd.id", "cnt");
            sqlQueryObject.addSelectField("soggetti.id");
            sqlQueryObject.addWhereCondition("pdd.nome = soggetti.server");
            sqlQueryObject.addWhereCondition("pdd.tipo = ?");
            sqlQueryObject.addGroupBy("soggetti.id");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            this.log.debug("eseguo query : " + sqlQuery);
            stm = con.prepareStatement(sqlQuery);
            stm.setString(1, "operativo");
            rs = stm.executeQuery();
            HashMap<Long, DominioEnum> map = new HashMap<Long, DominioEnum>();
            while (rs.next()) {
                map.put(rs.getLong("id"), rs.getLong("cnt") > 0L ? DominioEnum.INTERNO : DominioEnum.ESTERNO);
            }
            HashMap<Long, DominioEnum> hashMap = map;
            return hashMap;
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException("getDominiSoggetti error", (Throwable)e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessione al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public DominioEnum getDominioSoggetto(long idSoggetto) throws DriverConfigurazioneException {
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        this.log.debug("getDominioSoggetto [" + idSoggetto + "]...");
        try {
            this.log.debug("operazione atomica = " + this.atomica);
            con = this.atomica ? this.datasource.getConnection() : this.globalConnection;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("pdd");
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectCountField("pdd.id", "cnt");
            sqlQueryObject.addWhereCondition("pdd.nome = soggetti.server");
            sqlQueryObject.addWhereCondition("pdd.tipo = ?");
            sqlQueryObject.addWhereCondition("soggetti.id = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            this.log.debug("eseguo query : " + sqlQuery);
            stm = con.prepareStatement(sqlQuery);
            stm.setString(1, "operativo");
            stm.setLong(2, idSoggetto);
            rs = stm.executeQuery();
            if (rs.next()) {
                DominioEnum dominioEnum = rs.getLong("cnt") > 0L ? DominioEnum.INTERNO : DominioEnum.ESTERNO;
                return dominioEnum;
            }
            DominioEnum dominioEnum = DominioEnum.ESTERNO;
            return dominioEnum;
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException("getDominioSoggetto [" + idSoggetto + "] error", (Throwable)e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessione al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void insertCorrRisp(CorrelazioneRisposta correlazioneRisposta, String nomeTabella) throws DriverConfigurazioneException {
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        this.log.debug("insertCorrRisp tabella[" + nomeTabella + "] porta.id [" + correlazioneRisposta.getIdPorta() + "]...");
        try {
            this.log.debug("operazione atomica = " + this.atomica);
            con = this.atomica ? this.datasource.getConnection() : this.globalConnection;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addInsertTable(nomeTabella);
            sqlQueryObject.addInsertField("id_porta", "?");
            sqlQueryObject.addInsertField("nome_elemento", "?");
            sqlQueryObject.addInsertField("mode_correlazione", "?");
            sqlQueryObject.addInsertField("pattern", "?");
            sqlQueryObject.addInsertField("identificazione_fallita", "?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlInsert = sqlQueryObject.createSQLInsert();
            this.log.debug("eseguo insert: " + sqlInsert);
            stm = con.prepareStatement(sqlInsert);
            stm.setLong(1, correlazioneRisposta.getIdPorta());
            stm.setString(2, correlazioneRisposta.getNomeElemento());
            stm.setString(3, correlazioneRisposta.getModeCorrelazione());
            stm.setString(4, correlazioneRisposta.getPattern());
            stm.setString(5, correlazioneRisposta.getIdentificazioneFallita());
            stm.execute();
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException("insertCorrRisp tabella[" + nomeTabella + "] porta.id [" + correlazioneRisposta.getIdPorta() + "] error", (Throwable)e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessione al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void updateCorrRisp(CorrelazioneRisposta correlazioneRisposta, String nomeTabella) throws DriverConfigurazioneException {
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        this.log.debug("updateCorrRisp tabella[" + nomeTabella + "] porta.id [" + correlazioneRisposta.getIdPorta() + "]...");
        try {
            long idCorrApp = this.findLongIdCorrRisp(correlazioneRisposta, nomeTabella);
            this.log.debug("operazione atomica = " + this.atomica);
            con = this.atomica ? this.datasource.getConnection() : this.globalConnection;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addUpdateTable(nomeTabella);
            sqlQueryObject.addUpdateField("id_porta", "?");
            sqlQueryObject.addUpdateField("nome_elemento", "?");
            sqlQueryObject.addUpdateField("mode_correlazione", "?");
            sqlQueryObject.addUpdateField("pattern", "?");
            sqlQueryObject.addUpdateField("identificazione_fallita", "?");
            sqlQueryObject.addWhereCondition("id=?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlUpdate = sqlQueryObject.createSQLUpdate();
            this.log.debug("eseguo insert: " + sqlUpdate);
            stm = con.prepareStatement(sqlUpdate);
            stm.setLong(1, correlazioneRisposta.getIdPorta());
            stm.setString(2, correlazioneRisposta.getNomeElemento());
            stm.setString(3, correlazioneRisposta.getModeCorrelazione());
            stm.setString(4, correlazioneRisposta.getPattern());
            stm.setString(5, correlazioneRisposta.getIdentificazioneFallita());
            stm.setLong(6, idCorrApp);
            stm.execute();
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException("updateCorrRisp tabella[" + nomeTabella + "] porta.id [" + correlazioneRisposta.getIdPorta() + "] error", (Throwable)e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessione al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void insertPACorrRisp(CorrelazioneRisposta correlazioneRisposta) throws DriverConfigurazioneException {
        this.insertCorrRisp(correlazioneRisposta, "pa_correlazione_risposta");
    }

    public void updatePACorrRisp(CorrelazioneRisposta correlazioneRisposta) throws DriverConfigurazioneException {
        this.updateCorrRisp(correlazioneRisposta, "pa_correlazione_risposta");
    }

    private long findLongIdPACorrRisp(CorrelazioneRisposta correlazioneRisposta) throws DriverConfigurazioneException {
        return this.findLongIdCorrRisp(correlazioneRisposta, "pa_correlazione_risposta");
    }

    public void deleteAllPACorrRisp(long idPorta) throws DriverConfigurazioneException {
        this.deleteAllCorrRisp(idPorta, "pa_correlazione_risposta");
    }

    public boolean existsPACorrRisp(CorrelazioneRisposta correlazioneRisposta) throws DriverConfigurazioneException {
        return this.findLongIdPACorrRisp(correlazioneRisposta) >= 0L;
    }

    public void insertPDCorrRisp(CorrelazioneRisposta correlazioneRisposta) throws DriverConfigurazioneException {
        this.insertCorrRisp(correlazioneRisposta, "pd_correlazione_risposta");
    }

    public void updatePDCorrRisp(CorrelazioneRisposta correlazioneRisposta) throws DriverConfigurazioneException {
        this.updateCorrRisp(correlazioneRisposta, "pd_correlazione_risposta");
    }

    public boolean existsPDCorrRisp(CorrelazioneRisposta correlazioneRisposta) throws DriverConfigurazioneException {
        return this.findLongIdPDCorrRisp(correlazioneRisposta) >= 0L;
    }

    private long findLongIdPDCorrRisp(CorrelazioneRisposta correlazioneRisposta) throws DriverConfigurazioneException {
        return this.findLongIdCorrRisp(correlazioneRisposta, "pd_correlazione_risposta");
    }

    public void deleteAllPDCorrRisp(long idPorta) throws DriverConfigurazioneException {
        this.deleteAllCorrRisp(idPorta, "pd_correlazione_risposta");
    }

    public void deleteAllCorrRisp(long idPorta, String nomeTabella) throws DriverConfigurazioneException {
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        this.log.debug("deleteAllCorrRisp idPorta [" + idPorta + "] nomeTabella[" + nomeTabella + "]...");
        try {
            this.log.debug("operazione atomica = " + this.atomica);
            con = this.atomica ? this.datasource.getConnection() : this.globalConnection;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addDeleteTable(nomeTabella);
            sqlQueryObject.addWhereCondition("id_porta = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlDelete = sqlQueryObject.createSQLDelete();
            this.log.debug("eseguo delete : " + sqlDelete);
            stm = con.prepareStatement(sqlDelete);
            stm.setLong(1, idPorta);
            stm.execute();
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException("deleteAllCorrRisp idPorta [" + idPorta + "] nomeTabella[" + nomeTabella + "] error", (Throwable)e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessione al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private long findLongIdCorrRisp(CorrelazioneRisposta correlazioneRisposta, String nomeTabella) throws DriverConfigurazioneException {
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        this.log.debug("CorrelazioneRisposta idPorta[" + correlazioneRisposta.getIdPorta() + "]...");
        try {
            this.log.debug("operazione atomica = " + this.atomica);
            con = this.atomica ? this.datasource.getConnection() : this.globalConnection;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable(nomeTabella);
            sqlQueryObject.addSelectField("id");
            sqlQueryObject.addWhereCondition("id_porta = ?");
            if (correlazioneRisposta.getNomeElemento() != null) {
                sqlQueryObject.addWhereCondition("nome_elemento = ?");
            } else {
                sqlQueryObject.addWhereCondition("nome_elemento IS NULL");
            }
            if (correlazioneRisposta.getModeCorrelazione() != null) {
                sqlQueryObject.addWhereCondition("mode_correlazione = ?");
            } else {
                sqlQueryObject.addWhereCondition("mode_correlazione IS NULL");
            }
            if (correlazioneRisposta.getPattern() != null) {
                sqlQueryObject.addWhereLikeCondition("pattern", correlazioneRisposta.getPattern());
            } else {
                sqlQueryObject.addWhereCondition("pattern IS NULL");
            }
            if (correlazioneRisposta.getIdentificazioneFallita() != null) {
                sqlQueryObject.addWhereCondition("identificazione_fallita = ?");
            } else {
                sqlQueryObject.addWhereCondition("identificazione_fallita IS NULL");
            }
            sqlQueryObject.setANDLogicOperator(true);
            String sqlInsert = sqlQueryObject.createSQLQuery();
            this.log.debug("eseguo query : " + sqlInsert);
            stm = con.prepareStatement(sqlInsert);
            int index = 1;
            stm.setLong(index++, correlazioneRisposta.getIdPorta());
            if (correlazioneRisposta.getNomeElemento() != null) {
                stm.setString(index++, correlazioneRisposta.getNomeElemento());
            }
            if (correlazioneRisposta.getModeCorrelazione() != null) {
                stm.setString(index++, correlazioneRisposta.getModeCorrelazione());
            }
            if (correlazioneRisposta.getIdentificazioneFallita() != null) {
                stm.setString(index++, correlazioneRisposta.getIdentificazioneFallita());
            }
            if ((rs = stm.executeQuery()).next()) {
                long l = rs.getInt("id");
                return l;
            }
            long l = -1L;
            return l;
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException("CorrelazioneRisposta idPorta[" + correlazioneRisposta.getIdPorta() + "] error", (Throwable)e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessione al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void createConnettoreProperties(ConnettoriProperty prop) throws DriverConfigurazioneException {
        String nomeConnettore = prop.getNomeConnettore();
        String path = prop.getPath();
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        this.log.debug("insertConnettoreProperties nome [" + nomeConnettore + "] path [" + path + "]...");
        try {
            this.log.debug("operazione atomica = " + this.atomica);
            con = this.atomica ? this.datasource.getConnection() : this.globalConnection;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addInsertTable("connettori_properties");
            sqlQueryObject.addInsertField("connettori_properties.nome_connettore", "?");
            sqlQueryObject.addInsertField("connettori_properties.path", "?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlInsert = sqlQueryObject.createSQLInsert();
            this.log.debug("eseguo update : " + sqlInsert);
            stm = con.prepareStatement(sqlInsert);
            stm.setString(1, nomeConnettore);
            stm.setString(2, path);
            stm.execute();
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException("insertConnettoreProperties nome [" + nomeConnettore + "] path [" + path + "] error", (Throwable)e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessione al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void updateConnettoreProperties(String id, ConnettoriProperty prop) throws DriverConfigurazioneException {
        String nomeConnettore = prop.getNomeConnettore();
        String path = prop.getPath();
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        this.log.debug("updateConnettoreProperties id[" + id + "] nome [" + nomeConnettore + "] path [" + path + "]...");
        try {
            this.log.debug("operazione atomica = " + this.atomica);
            con = this.atomica ? this.datasource.getConnection() : this.globalConnection;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addUpdateTable("connettori_properties");
            sqlQueryObject.addUpdateField("connettori_properties.nome_connettore", "?");
            sqlQueryObject.addUpdateField("connettori_properties.path", "?");
            sqlQueryObject.addWhereCondition("connettori_properties.nome_connettore = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlInsert = sqlQueryObject.createSQLUpdate();
            this.log.debug("eseguo update : " + sqlInsert);
            stm = con.prepareStatement(sqlInsert);
            stm.setString(1, nomeConnettore);
            stm.setString(2, path);
            stm.setString(3, id);
            stm.execute();
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException("insertConnettoreProperties id[" + id + "] nome [" + nomeConnettore + "] path [" + path + "] error", (Throwable)e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessione al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public boolean existsConnettoreProperties(String id) throws DriverConfigurazioneException {
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        this.log.debug("existsConnettoreProperties id[" + id + "]...");
        try {
            this.log.debug("operazione atomica = " + this.atomica);
            con = this.atomica ? this.datasource.getConnection() : this.globalConnection;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("connettori_properties");
            sqlQueryObject.addSelectField("connettori_properties.nome_connettore");
            sqlQueryObject.addWhereCondition("connettori_properties.nome_connettore = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlInsert = sqlQueryObject.createSQLQuery();
            this.log.debug("eseguo query : " + sqlInsert);
            stm = con.prepareStatement(sqlInsert);
            stm.setString(1, id);
            rs = stm.executeQuery();
            boolean bl = rs.next();
            return bl;
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException("insertConnettoreProperties id[" + id + "] error", (Throwable)e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessione al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public ConnettoriProperty getConnettoreProperties(String nomeConnettore) throws DriverConfigurazioneException {
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        this.log.debug("getTipoPortaDominio [" + nomeConnettore + "]...");
        try {
            this.log.debug("operazione atomica = " + this.atomica);
            con = this.atomica ? this.datasource.getConnection() : this.globalConnection;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("connettori_properties");
            sqlQueryObject.addSelectField("connettori_properties.nome_connettore");
            sqlQueryObject.addSelectField("connettori_properties.path");
            sqlQueryObject.addWhereCondition("connettori_properties.nome_connettore = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            this.log.debug("eseguo query : " + sqlQuery);
            stm = con.prepareStatement(sqlQuery);
            stm.setString(1, nomeConnettore);
            rs = stm.executeQuery();
            if (rs.next()) {
                ConnettoriProperty connProps = new ConnettoriProperty();
                connProps.setNomeConnettore(rs.getString("nome_connettore"));
                connProps.setPath(rs.getString("path"));
                ConnettoriProperty connettoriProperty = connProps;
                return connettoriProperty;
            }
            try {
                throw new Exception("Connettore [" + nomeConnettore + "] non ha properties");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("Connettore [" + nomeConnettore + "] error", (Throwable)e);
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessione al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public List<String> findAllIdConnettoreProperties() throws DriverConfigurazioneException {
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        this.log.debug("findAllIdConnettoreProperties...");
        try {
            this.log.debug("operazione atomica = " + this.atomica);
            con = this.atomica ? this.datasource.getConnection() : this.globalConnection;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("connettori_properties");
            sqlQueryObject.addSelectField("connettori_properties.nome_connettore");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            this.log.debug("eseguo query : " + sqlQuery);
            stm = con.prepareStatement(sqlQuery);
            rs = stm.executeQuery();
            ArrayList<String> lst = new ArrayList<String>();
            while (rs.next()) {
                lst.add(rs.getString("nome_connettore"));
            }
            ArrayList<String> arrayList = lst;
            return arrayList;
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException("findAllIdConnettoreProperties error", (Throwable)e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessione al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public List<CorrelazioneRisposta> getPDCorrelazioneRisposta(long idPorta) throws DriverConfigurazioneException {
        return this.getCorrelazioneRisposta(idPorta, "pd_correlazione_risposta");
    }

    public List<CorrelazioneRisposta> getPACorrelazioneRisposta(long idPorta) throws DriverConfigurazioneException {
        return this.getCorrelazioneRisposta(idPorta, "pa_correlazione_risposta");
    }

    private List<CorrelazioneRisposta> getCorrelazioneRisposta(long idPorta, String nomeTabella) throws DriverConfigurazioneException {
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        this.log.debug("getCorrelazioneRisposta [" + idPorta + "]...");
        try {
            this.log.debug("operazione atomica = " + this.atomica);
            con = this.atomica ? this.datasource.getConnection() : this.globalConnection;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable(nomeTabella);
            sqlQueryObject.addSelectField("nome_elemento");
            sqlQueryObject.addSelectField("mode_correlazione");
            sqlQueryObject.addSelectField("pattern");
            sqlQueryObject.addSelectField("identificazione_fallita");
            sqlQueryObject.addWhereCondition("id_porta = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            this.log.debug("eseguo query : " + sqlQuery);
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, idPorta);
            rs = stm.executeQuery();
            ArrayList<CorrelazioneRisposta> lst = new ArrayList<CorrelazioneRisposta>();
            while (rs.next()) {
                CorrelazioneRisposta corr = new CorrelazioneRisposta();
                corr.setNomeElemento(rs.getString("nome_elemento"));
                corr.setModeCorrelazione(rs.getString("mode_correlazione"));
                corr.setPattern(rs.getString("pattern"));
                corr.setIdentificazioneFallita(rs.getString("identificazione_fallita"));
                lst.add(corr);
            }
            ArrayList<CorrelazioneRisposta> arrayList = lst;
            return arrayList;
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException("getCorrelazioneRisposta [" + idPorta + "] error", (Throwable)e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessione al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public IDSoggetto[] getAllIdSoggettiConfig() throws DriverConfigurazioneException {
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        this.log.debug("getAllIdSoggetti...");
        try {
            IDSoggetto[] iDSoggettoArray;
            this.log.debug("operazione atomica = " + this.atomica);
            con = this.atomica ? this.datasource.getConnection() : this.globalConnection;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectField("tipo_soggetto");
            sqlQueryObject.addSelectField("nome_soggetto");
            sqlQueryObject.addSelectField("identificativo_porta");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            this.log.debug("eseguo query : " + sqlQuery);
            stm = con.prepareStatement(sqlQuery);
            rs = stm.executeQuery();
            Vector<IDSoggetto> idSoggetti = new Vector<IDSoggetto>();
            while (rs.next()) {
                IDSoggetto idS = new IDSoggetto(rs.getString("tipo_soggetto"), rs.getString("nome_soggetto"), rs.getString("identificativo_porta"));
                idSoggetti.add(idS);
            }
            if (idSoggetti.size() > 0) {
                iDSoggettoArray = idSoggetti.toArray(new IDSoggetto[1]);
                return iDSoggettoArray;
            }
            iDSoggettoArray = null;
            return iDSoggettoArray;
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException("getAllIdSoggetti error", (Throwable)e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessione al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }
}

