/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.drivers;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.MessageSecurityFlow;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.MessageSecurityFlowParameter;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.driver.DriverConfigurazioneException;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.driver.db.DriverConfigurazioneDB_LIB;
import it.link.pdd.tools.migrazione_govway.utils.LoggerWrapperFactory;
import it.link.pdd.tools.migrazione_govway.utils.sql.ISQLQueryObject;
import it.link.pdd.tools.migrazione_govway.utils.sql.SQLObjectFactory;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.openspcoop2.core.commons.DBUtils;
import org.openspcoop2.core.id.IDPortaApplicativa;
import org.openspcoop2.core.id.IDPortaDelegata;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.mapping.DBMappingUtils;
import org.slf4j.Logger;

public class DriverConfigurazioneServiziGovway {
    public DataSource datasource = null;
    protected Connection globalConnection = null;
    protected boolean atomica = true;
    protected Logger log = null;
    protected String tipoDB = null;

    public DriverConfigurazioneServiziGovway(String nomeDataSource, Properties context, String tipoDB) throws Exception {
        this(nomeDataSource, context, null, tipoDB);
    }

    public DriverConfigurazioneServiziGovway(String nomeDataSource, Properties context, Logger alog, String tipoDB) throws Exception {
        this(nomeDataSource, context, alog, tipoDB, false);
    }

    public DriverConfigurazioneServiziGovway(String nomeDataSource, Properties context, Logger alog, String tipoDB, boolean tabellaSoggettiPDD) throws Exception {
        this.initDriverConfigurazioneFindAll(nomeDataSource, context, alog, tipoDB, tabellaSoggettiPDD);
    }

    public DriverConfigurazioneServiziGovway(Connection connection, Logger alog, String tipoDB) throws Exception {
        if (alog == null) {
            this.log = LoggerWrapperFactory.getLogger((String)"DRIVER_DB_CONFIGURAZIONE");
        } else {
            this.log = alog;
            DriverConfigurazioneDB_LIB.initStaticLogger((Logger)this.log);
        }
        if (connection == null) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::DriverConfigurazioneDB(Connection con, Properties context) La connection non puo essere null.");
        }
        if (tipoDB == null) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::DriverConfigurazioneDB(Connection ) Il tipoDatabase non puo essere null.");
        }
        this.globalConnection = connection;
        this.atomica = false;
        this.tipoDB = tipoDB;
    }

    private void initDriverConfigurazioneFindAll(String nomeDataSource, Properties context, Logger alog, String tipoDB, boolean tabellaSoggettiPDD) throws Exception {
        try {
            if (alog == null) {
                this.log = LoggerWrapperFactory.getLogger((String)"DRIVER_DB_CONFIGURAZIONE");
            } else {
                this.log = alog;
                DriverConfigurazioneDB_LIB.initStaticLogger((Logger)this.log);
            }
            InitialContext initCtx = new InitialContext(context);
            this.datasource = (DataSource)initCtx.lookup(nomeDataSource);
            initCtx.close();
        }
        catch (NamingException ne) {
            this.log.error("Impossibile recuperare il context: " + ne.getMessage());
            throw new Exception("Impossibile recuperare il context: " + ne.getMessage());
        }
        if (tipoDB == null) {
            this.log.error("Il tipoDatabase non puo essere null.");
            throw new Exception("Il tipoDatabase non puo essere null.");
        }
        this.atomica = true;
        this.tipoDB = tipoDB;
    }

    private void insertWsSecurity(long idPorta, String nomeTabella, String nome, String valore) throws DriverConfigurazioneException {
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        this.log.debug("insertWsSecurity tabella [" + nomeTabella + "] idPorta [" + idPorta + "] nome[" + nome + "] valore[" + valore + "]...");
        try {
            this.log.debug("operazione atomica = " + this.atomica);
            con = this.atomica ? this.datasource.getConnection() : this.globalConnection;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addInsertTable(nomeTabella);
            sqlQueryObject.addInsertField("id_porta", "?");
            sqlQueryObject.addInsertField("nome", "?");
            sqlQueryObject.addInsertField("valore", "?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlInsert = sqlQueryObject.createSQLInsert();
            this.log.debug("eseguo insert : " + sqlInsert);
            stm = con.prepareStatement(sqlInsert);
            stm.setLong(1, idPorta);
            stm.setString(2, nome);
            stm.setString(3, valore);
            stm.execute();
            this.log.debug("insertWsSecurity tabella [" + nomeTabella + "] idPorta [" + idPorta + "] nome[" + nome + "] valore[" + valore + "] completato");
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException("Errore durante la insertWsSecurity tabella [" + nomeTabella + "] idPorta [" + idPorta + "] nome[" + nome + "] valore[" + valore + "]:" + e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessione al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private void enableWsSecurity(long idPorta, String nomeTabella, TIPO_MESSAGGIO tipoMessaggio) throws DriverConfigurazioneException {
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        String column = tipoMessaggio.equals((Object)TIPO_MESSAGGIO.RICHIESTA) ? "security_request_mode" : "security_response_mode";
        this.log.debug("enableWsSecurity tabella [" + nomeTabella + "] idPorta [" + idPorta + "] colonna[" + column + "]...");
        try {
            this.log.debug("operazione atomica = " + this.atomica);
            con = this.atomica ? this.datasource.getConnection() : this.globalConnection;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addUpdateTable(nomeTabella);
            sqlQueryObject.addUpdateField(column, "default");
            sqlQueryObject.addUpdateField("security", "?");
            sqlQueryObject.addWhereCondition("id = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlUpdate = sqlQueryObject.createSQLUpdate();
            this.log.debug("eseguo update: " + sqlUpdate);
            stm = con.prepareStatement(sqlUpdate);
            stm.setString(1, "abilitato");
            stm.setLong(2, idPorta);
            stm.execute();
            this.log.debug("enableWsSecurity tabella [" + nomeTabella + "] idPorta [" + idPorta + "] colonna[" + column + "] completato");
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException("Errore durante la enableWsSecurity tabella [" + nomeTabella + "] idPorta [" + idPorta + "] colonna[" + column + "]:" + e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessione al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private void clearWsSecurity(long idPorta, String nomeTabella) throws DriverConfigurazioneException {
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        this.log.debug("clearWsSecurity tabella [" + nomeTabella + "] idPorta [" + idPorta + "] ...");
        try {
            this.log.debug("operazione atomica = " + this.atomica);
            con = this.atomica ? this.datasource.getConnection() : this.globalConnection;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addDeleteTable(nomeTabella);
            sqlQueryObject.addWhereCondition("id_porta = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlDelete = sqlQueryObject.createSQLDelete();
            this.log.debug("eseguo delete: " + sqlDelete);
            stm = con.prepareStatement(sqlDelete);
            stm.setLong(1, idPorta);
            stm.execute();
            this.log.debug("clearWsSecurity tabella [" + nomeTabella + "] idPorta [" + idPorta + "] completato");
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException("Errore durante la clearWsSecurity tabella [" + nomeTabella + "] idPorta [" + idPorta + "]:" + e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessione al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void setMetadatiPD(long idPorta, String metadati) throws DriverConfigurazioneException {
        this.setMetadati(idPorta, "porte_delegate", metadati);
    }

    public void setMetadatiPA(long idPorta, String metadati) throws DriverConfigurazioneException {
        this.setMetadati(idPorta, "porte_applicative", metadati);
    }

    private void setMetadati(long idPorta, String nomeTabella, String metadati) throws DriverConfigurazioneException {
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        this.log.debug("setMetadati tabella [" + nomeTabella + "] metadati [" + metadati + "] idPorta [" + idPorta + "] ...");
        try {
            this.log.debug("operazione atomica = " + this.atomica);
            con = this.atomica ? this.datasource.getConnection() : this.globalConnection;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addUpdateTable(nomeTabella);
            sqlQueryObject.addUpdateField("integrazione", "?");
            sqlQueryObject.addWhereCondition("id = ?");
            sqlQueryObject.addWhereIsNullCondition("integrazione");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlUpdate = sqlQueryObject.createSQLUpdate();
            this.log.debug("eseguo update: " + sqlUpdate);
            stm = con.prepareStatement(sqlUpdate);
            stm.setString(1, metadati);
            stm.setLong(2, idPorta);
            stm.execute();
            this.log.debug("setMetadati tabella [" + nomeTabella + "] metadati [" + metadati + "] idPorta [" + idPorta + "] completato");
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException("Errore durante la setMetadati tabella [" + nomeTabella + "] metadati [" + metadati + "] idPorta [" + idPorta + "]:" + e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessione al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void enableWsSecurityPD(long idPorta, TIPO_MESSAGGIO tipoMessaggio, MessageSecurityFlow messageSecurityFlow) throws DriverConfigurazioneException {
        String table = tipoMessaggio.equals((Object)TIPO_MESSAGGIO.RICHIESTA) ? "pd_security_request" : "pd_security_response";
        this.enableWsSecurity(idPorta, "porte_delegate", tipoMessaggio);
        this.clearWsSecurity(idPorta, table);
        for (MessageSecurityFlowParameter param : messageSecurityFlow.getParameterList()) {
            this.insertWsSecurity(idPorta, table, param.getNome(), param.getValore());
        }
    }

    public void enableWsSecurityPA(long idPorta, TIPO_MESSAGGIO tipoMessaggio, MessageSecurityFlow messageSecurityFlow) throws DriverConfigurazioneException {
        String table = tipoMessaggio.equals((Object)TIPO_MESSAGGIO.RICHIESTA) ? "pa_security_request" : "pa_security_response";
        this.enableWsSecurity(idPorta, "porte_applicative", tipoMessaggio);
        this.clearWsSecurity(idPorta, table);
        for (MessageSecurityFlowParameter param : messageSecurityFlow.getParameterList()) {
            this.insertWsSecurity(idPorta, table, param.getNome(), param.getValore());
        }
    }

    public long getIdPA(IDServizio idServizio, String azione) throws DriverConfigurazioneException {
        Connection con = null;
        this.log.debug("getIdPA idServizio [" + idServizio + "] azione [" + azione + "]...");
        try {
            this.log.debug("operazione atomica = " + this.atomica);
            con = this.atomica ? this.datasource.getConnection() : this.globalConnection;
            IDPortaApplicativa pa = null;
            if (azione != null) {
                idServizio.setAzione(azione);
                pa = DBMappingUtils.getIDPortaApplicativaAssociataAzione((IDServizio)idServizio, (Connection)con, (String)this.tipoDB);
            } else {
                pa = DBMappingUtils.getIDPortaApplicativaAssociataDefault((IDServizio)idServizio, (Connection)con, (String)this.tipoDB);
            }
            long idPorta = DBUtils.getIdPortaApplicativa((String)pa.getNome(), (Connection)con, (String)this.tipoDB);
            this.log.debug("getIdPA idServizio [" + idServizio + "] azione [" + azione + "] completato");
            long l = idPorta;
            return l;
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException("Errore durante la getIdPA idServizio [" + idServizio + "] azione [" + azione + "]:" + e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessione al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public long getIdPD(IDServizio idServizio, IDSoggetto idFruitore, String azione) throws DriverConfigurazioneException {
        Connection con = null;
        this.log.debug("getIdPA idServizio [" + idServizio + "] idFruitore [" + idFruitore + "] azione [" + azione + "]...");
        try {
            this.log.debug("operazione atomica = " + this.atomica);
            con = this.atomica ? this.datasource.getConnection() : this.globalConnection;
            IDPortaDelegata pd = null;
            if (azione != null) {
                idServizio.setAzione(azione);
                pd = DBMappingUtils.getIDPortaDelegataAssociataAzione((IDServizio)idServizio, (IDSoggetto)idFruitore, (Connection)con, (String)this.tipoDB);
            } else {
                pd = DBMappingUtils.getIDPortaDelegataAssociataDefault((IDServizio)idServizio, (IDSoggetto)idFruitore, (Connection)con, (String)this.tipoDB);
            }
            long idPorta = DBUtils.getIdPortaDelegata((String)pd.getNome(), (Connection)con, (String)this.tipoDB);
            this.log.debug("getIdPA idServizio [" + idServizio + "] idFruitore [" + idFruitore + "] azione [" + azione + "] completato");
            long l = idPorta;
            return l;
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException("Errore durante la getIdPD idServizio [" + idServizio + "] idFruitore [" + idFruitore + "] azione [" + azione + "]:" + e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessione al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static enum TIPO_MESSAGGIO {
        RICHIESTA,
        RISPOSTA;

    }
}

