/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.converter;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.PortaApplicativa;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.PortaDelegata;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.ServizioApplicativo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.Soggetto;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDAccordo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDAccordoCooperazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDPortaApplicativaByNome;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDPortaDelegata;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDServizio;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDServizioApplicativo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDSoggetto;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.AccordoCooperazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.AccordoServizioParteComune;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.AccordoServizioParteSpecifica;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.PortaDominio;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.DriverRegistroServiziException;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.IDAccordoCooperazioneFactory;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.IDAccordoFactory;
import it.link.pdd.tools.migrazione_govway.wrapper.ConnettoriProperty;

public class OpenSPCoop2IdConverter {
    private static OpenSPCoop2IdConverter instance;

    public static OpenSPCoop2IdConverter getInstance() throws Exception {
        if (instance == null) {
            instance = new OpenSPCoop2IdConverter();
        }
        return instance;
    }

    public String convertToId(PortaDominio obj) {
        return obj.getNome();
    }

    public IDSoggetto convertToId(it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Soggetto obj) {
        IDSoggetto id = new IDSoggetto();
        id.setCodicePorta(obj.getIdentificativoPorta());
        id.setNome(obj.getNome());
        id.setTipo(obj.getTipo());
        return id;
    }

    public IDAccordo convertToId(AccordoServizioParteComune obj) throws DriverRegistroServiziException {
        IDAccordo id = IDAccordoFactory.getInstance().getIDAccordoFromAccordo(obj);
        return id;
    }

    public IDServizio convertToId(AccordoServizioParteSpecifica obj) throws Exception {
        IDServizio idServizio = new IDServizio(obj.getServizio().getTipoSoggettoErogatore(), obj.getServizio().getNomeSoggettoErogatore(), obj.getServizio().getTipo(), obj.getServizio().getNome());
        return idServizio;
    }

    public IDAccordoCooperazione convertToId(AccordoCooperazione obj) throws DriverRegistroServiziException {
        IDAccordoCooperazione id = IDAccordoCooperazioneFactory.getInstance().getIDAccordoFromAccordo(obj);
        return id;
    }

    public IDServizioApplicativo convertToId(ServizioApplicativo obj) {
        IDServizioApplicativo id = new IDServizioApplicativo();
        IDSoggetto soggettoProprietario = new IDSoggetto();
        soggettoProprietario.setNome(obj.getNomeSoggettoProprietario());
        soggettoProprietario.setTipo(obj.getTipoSoggettoProprietario());
        id.setIdSoggettoProprietario(soggettoProprietario);
        id.setNome(obj.getNome());
        return id;
    }

    public IDPortaApplicativaByNome convertToId(PortaApplicativa obj) {
        IDPortaApplicativaByNome id = new IDPortaApplicativaByNome();
        IDSoggetto soggettoProprietario = new IDSoggetto();
        soggettoProprietario.setNome(obj.getNomeSoggettoProprietario());
        soggettoProprietario.setTipo(obj.getTipoSoggettoProprietario());
        id.setSoggetto(soggettoProprietario);
        id.setNome(obj.getNome());
        return id;
    }

    public IDPortaDelegata convertToId(PortaDelegata obj) {
        IDPortaDelegata id = new IDPortaDelegata();
        if (obj.getLocation() != null && !"".equals(obj.getLocation())) {
            id.setLocationPD(obj.getLocation());
        } else {
            id.setLocationPD(obj.getNome());
        }
        IDSoggetto soggettoFruitore = new IDSoggetto();
        soggettoFruitore.setNome(obj.getNomeSoggettoProprietario());
        soggettoFruitore.setTipo(obj.getTipoSoggettoProprietario());
        id.setSoggettoFruitore(soggettoFruitore);
        return id;
    }

    public IDSoggetto convertToId(Soggetto obj) {
        IDSoggetto id = new IDSoggetto();
        id.setCodicePorta(obj.getIdentificativoPorta());
        id.setNome(obj.getNome());
        id.setTipo(obj.getTipo());
        return id;
    }

    public String convertToId(ConnettoriProperty obj) {
        return obj.getNomeConnettore();
    }
}

