/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway;

import com.google.common.io.Files;
import it.link.pdd.tools.migrazione_govway.AbstractMigrazione;
import it.link.pdd.tools.migrazione_govway.Utilities;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDPortaApplicativaByNome;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDPortaDelegata;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDRuolo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDServizioApplicativo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDSoggetto;
import it.link.pdd.tools.migrazione_govway.properties.MigrazioneProperties;
import it.link.pdd.tools.migrazione_govway.reader.ReaderFactory;
import it.link.pdd.tools.migrazione_govway.reader.govway.IConfigurazioneServiziReader;
import it.link.pdd.tools.migrazione_govway.wrapper.govway.AbstractFruizioneErogazioneWrapper;
import it.link.pdd.tools.migrazione_govway.wrapper.govway.AbstractWrapperWithKey;
import it.link.pdd.tools.migrazione_govway.wrapper.govway.ApiWrapper;
import it.link.pdd.tools.migrazione_govway.wrapper.govway.ApplicativoWrapper;
import it.link.pdd.tools.migrazione_govway.wrapper.govway.ErogazioneWrapper;
import it.link.pdd.tools.migrazione_govway.wrapper.govway.FruizioneWrapper;
import it.link.pdd.tools.migrazione_govway.wrapper.govway.InputWrapper;
import it.link.pdd.tools.migrazione_govway.wrapper.govway.MultitenantConfigurazione;
import it.link.pdd.tools.migrazione_govway.wrapper.govway.SoggettoWrapper;
import it.link.pdd.tools.migrazione_govway.wrapper.govway.Warnings;
import it.link.pdd.tools.migrazione_govway.writer.govway.ConfigurazioneServiziWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.openspcoop2.core.config.rs.server.model.AuthenticationHttps;
import org.openspcoop2.core.config.rs.server.model.AuthenticationHttpsConfigurazioneManuale;
import org.openspcoop2.core.config.rs.server.model.ControlloAccessiAutorizzazioneSoggetto;
import org.openspcoop2.core.config.rs.server.model.DominioEnum;
import org.openspcoop2.core.config.rs.server.model.ModalitaAccessoEnum;
import org.openspcoop2.core.config.rs.server.model.OneOfAuthenticationHttpsCertificato;
import org.openspcoop2.core.config.rs.server.model.OneOfBaseCredenzialiCredenziali;
import org.openspcoop2.core.config.rs.server.model.Ruolo;
import org.openspcoop2.core.config.rs.server.model.TipoAutenticazioneHttps;
import org.openspcoop2.utils.service.beans.ProfiloEnum;
import org.openspcoop2.utils.service.beans.utils.BaseHelper;
import org.slf4j.Logger;

public class MigrazioneConfigurazioneServiziGovway
extends AbstractMigrazione {
    private IConfigurazioneServiziReader reader;
    private ConfigurazioneServiziWriter writer;

    public MigrazioneConfigurazioneServiziGovway(String propertiesFile, String dbInFile, String dbOutFile) throws Exception {
        super(propertiesFile, dbInFile, dbOutFile);
        Logger driverLogger = Utilities.getDriverLogger();
        this.reader = ReaderFactory.getConfigurazioneServiziGovwayReader(this.dbIn, this.dbOut, driverLogger);
        this.writer = new ConfigurazioneServiziWriter(this.dbOut, this.log, driverLogger);
    }

    public static void main(String[] args) {
        try {
            if (args.length < 3) {
                throw new Exception("Usage: java " + MigrazioneConfigurazioneServiziGovway.class + " propertiesFile dbInFile dbOutFile");
            }
            BaseHelper.validateAfterDeserialize = false;
            MigrazioneConfigurazioneServiziGovway migrazione = new MigrazioneConfigurazioneServiziGovway(args[0].trim(), args[1].trim(), args[2].trim());
            migrazione.migra();
        }
        catch (Exception e) {
            System.err.println("Errore durante la migrazione della Configurazione dei Servizi di OpenSPCoop1:" + e.getMessage());
            e.printStackTrace(System.err);
            System.exit(1);
        }
    }

    public void migra() throws Exception {
        try {
            this.log.info("Recupero Soggetti da inserire ...");
            InputWrapper<IDSoggetto, SoggettoWrapper> soggetti = this.reader.findAllSoggetti();
            this.log.info("Recupero Soggetti da inserire completato");
            this.log.info("Recupero Applicativi da inserire ...");
            InputWrapper<IDServizioApplicativo, ApplicativoWrapper> applicativi = this.reader.findAllApplicativi();
            this.log.info("Recupero Applicativi da inserire completato");
            this.log.info("Recupero API da inserire ...");
            InputWrapper<String, ApiWrapper> api = this.reader.findAllApi();
            this.log.info("Recupero API da inserire completato");
            this.log.info("Recupero Ruoli da inserire ...");
            InputWrapper<IDRuolo, Ruolo> ruoli = this.reader.findAllRuoli();
            this.log.info("Recupero Ruoli da inserire completato");
            this.log.info("Recupero Erogazioni da inserire...");
            InputWrapper<IDPortaApplicativaByNome, ErogazioneWrapper> erogazioni = this.reader.findAllErogazioni(api.getElementiNonMigrati());
            this.log.info("Recupero Erogazioni da inserire completato");
            this.log.info("Recupero Fruizioni da inserire...");
            InputWrapper<IDPortaDelegata, FruizioneWrapper> fruizioni = this.reader.findAllFruizioni(api.getElementiNonMigrati());
            this.log.info("Recupero Fruizioni da inserire completato");
            this.initMultitenant(soggetti, erogazioni, fruizioni);
            this.migraRuoli(ruoli);
            soggetti = this.migraSoggetti(soggetti, erogazioni);
            applicativi = this.migraApplicativi(applicativi);
            api = this.migraApi(api);
            erogazioni = this.migraErogazioni(erogazioni);
            fruizioni = this.migraFruizioni(fruizioni);
            this.writeSoggettoLog(soggetti);
            this.writeApplicativiLog(applicativi);
            this.writeApiLog(api);
            this.writeErogazioneLog(erogazioni);
            this.writeFruizioneLog(fruizioni);
        }
        catch (Throwable t) {
            this.log.error(t.getMessage(), t);
            throw t;
        }
        finally {
            if (this.reader != null) {
                try {
                    this.reader.closeConnection();
                }
                catch (Exception soggetti) {}
            }
            if (this.writer != null) {
                try {
                    this.writer.closeConnection();
                }
                catch (Exception soggetti) {}
            }
        }
    }

    private void writeSoggettoLog(InputWrapper<IDSoggetto, SoggettoWrapper> iw) throws Exception {
        this.writeLog(iw, Paths.get(MigrazioneProperties.getInstance().getReportFolder(), "soggetti"), null, TIPO_MIGRATO.SOGGETTO);
    }

    private void writeApiLog(InputWrapper<String, ApiWrapper> iw) throws Exception {
        this.writeLog(iw, Paths.get(MigrazioneProperties.getInstance().getReportFolder(), "api"), null, TIPO_MIGRATO.API);
    }

    private void writeApplicativiLog(InputWrapper<IDServizioApplicativo, ApplicativoWrapper> iw) throws Exception {
        this.writeLog(iw, Paths.get(MigrazioneProperties.getInstance().getReportFolder(), "applicativi"), null, TIPO_MIGRATO.APPLICATIVO);
    }

    private void writeFruizioneLog(InputWrapper<IDPortaDelegata, FruizioneWrapper> iw) throws Exception {
        HashMap<IDPortaDelegata, UrlInvocazioneBean> urlInvocazioneMap = new HashMap<IDPortaDelegata, UrlInvocazioneBean>();
        for (FruizioneWrapper wrap : iw.getElementi()) {
            this.addFruizione(urlInvocazioneMap, wrap);
        }
        for (FruizioneWrapper wrap : iw.getElementiGiaPresenti()) {
            this.addFruizione(urlInvocazioneMap, wrap);
        }
        this.writeLog(iw, Paths.get(MigrazioneProperties.getInstance().getReportFolder(), "fruizioni"), urlInvocazioneMap, TIPO_MIGRATO.FRUIZIONE);
    }

    private void addFruizione(Map<IDPortaDelegata, UrlInvocazioneBean> urlInvocazioneMap, FruizioneWrapper wrap) throws Exception {
        UrlInvocazioneBean bean = null;
        if (urlInvocazioneMap.containsKey(wrap.getKey())) {
            bean = urlInvocazioneMap.get(wrap.getKey());
        } else {
            bean = new UrlInvocazioneBean();
            bean.porta = ((IDPortaDelegata)wrap.getKey()).toString();
            bean.connettoriPath = wrap.getLocationConnettore();
            bean.wsSecReqPath = wrap.getLocationWsSecurityRichiesta();
            bean.wsSecResPath = wrap.getLocationWsSecurityRisposta();
        }
        if (MigrazioneProperties.getInstance().getTipoMigrazioneServizi().equals((Object)MigrazioneProperties.TIPO_MIGRAZIONE_SERVIZI.SPC_E_GW) && wrap.getProfilo().equals((Object)ProfiloEnum.APIGATEWAY)) {
            if (bean.migrata == null) {
                bean.migrata = this.writer.getUrlInvocazione(wrap);
            } else {
                bean.migrataNoSpc = this.writer.getUrlInvocazione(wrap);
            }
        } else {
            bean.migrata = this.writer.getUrlInvocazione(wrap);
        }
        urlInvocazioneMap.put((IDPortaDelegata)wrap.getKey(), bean);
    }

    private void writeErogazioneLog(InputWrapper<IDPortaApplicativaByNome, ErogazioneWrapper> iw) throws Exception {
        HashMap<IDPortaApplicativaByNome, UrlInvocazioneBean> urlInvocazioneMap = new HashMap<IDPortaApplicativaByNome, UrlInvocazioneBean>();
        for (ErogazioneWrapper wrap : iw.getElementi()) {
            this.addErogazione(urlInvocazioneMap, wrap);
        }
        for (ErogazioneWrapper wrap : iw.getElementiGiaPresenti()) {
            this.addErogazione(urlInvocazioneMap, wrap);
        }
        this.writeLog(iw, Paths.get(MigrazioneProperties.getInstance().getReportFolder(), "erogazioni"), urlInvocazioneMap, TIPO_MIGRATO.EROGAZIONE);
    }

    private void addErogazione(Map<IDPortaApplicativaByNome, UrlInvocazioneBean> urlInvocazioneMap, ErogazioneWrapper wrap) throws Exception {
        UrlInvocazioneBean bean = null;
        if (urlInvocazioneMap.containsKey(wrap.getKey())) {
            bean = urlInvocazioneMap.get(wrap.getKey());
        } else {
            bean = new UrlInvocazioneBean();
            bean.porta = ((IDPortaApplicativaByNome)wrap.getKey()).toString();
            bean.connettoriPath = wrap.getLocationConnettore();
            bean.wsSecReqPath = wrap.getLocationWsSecurityRichiesta();
            bean.wsSecResPath = wrap.getLocationWsSecurityRisposta();
        }
        if (MigrazioneProperties.getInstance().getTipoMigrazioneServizi().equals((Object)MigrazioneProperties.TIPO_MIGRAZIONE_SERVIZI.SPC_E_GW) && wrap.getProfilo().equals((Object)ProfiloEnum.APIGATEWAY)) {
            if (bean.migrata == null) {
                bean.migrata = this.writer.getUrlInvocazione(wrap);
            } else {
                bean.migrataNoSpc = this.writer.getUrlInvocazione(wrap);
            }
        } else {
            bean.migrata = this.writer.getUrlInvocazione(wrap);
        }
        urlInvocazioneMap.put((IDPortaApplicativaByNome)wrap.getKey(), bean);
    }

    private void writeLog(InputWrapper<?, ? extends AbstractWrapperWithKey<?>> iw, Path path, Map<?, UrlInvocazioneBean> urlInvocazioneMap, TIPO_MIGRATO tipo) throws Exception {
        StringBuffer sbGiaPresenti;
        String filename;
        StringBuffer sbMigrate;
        String tipoOut = null;
        String tipoIn = null;
        switch (tipo) {
            case API: {
                tipoOut = "api";
                tipoIn = "Accordo Servizio";
                break;
            }
            case APPLICATIVO: {
                tipoOut = "Applicativo";
                tipoIn = "Servizi applicativi";
                break;
            }
            case EROGAZIONE: {
                tipoOut = "Erogazione";
                tipoIn = "Porte applicative";
                break;
            }
            case FRUIZIONE: {
                tipoOut = "Fruizione";
                tipoIn = "Porte delegate";
                break;
            }
            case SOGGETTO: {
                tipoIn = "Soggetti";
                tipoOut = "Soggetti";
            }
        }
        if (tipo.equals((Object)TIPO_MIGRATO.FRUIZIONE) || tipo.equals((Object)TIPO_MIGRATO.EROGAZIONE)) {
            if (iw.getElementi() != null && !iw.getElementi().isEmpty()) {
                this.log.info(iw.getElementi().size() + " configurazioni di tipo " + tipoOut + " migrate correttamente");
                sbMigrate = new StringBuffer();
                filename = "migrate_correttamente.csv";
                sbMigrate.append(new UrlInvocazioneBean().getHeader(tipoIn)).append("\n");
                boolean writeReport = false;
                for (AbstractWrapperWithKey<?> elemento : iw.getElementi()) {
                    if (iw.hasWarning(elemento)) continue;
                    writeReport = true;
                    sbMigrate.append(urlInvocazioneMap.get(elemento.getKey())).append("\n");
                }
                if (writeReport) {
                    this.writeReport(path, filename, sbMigrate.toString(), tipoIn + " migrate");
                }
            } else {
                this.log.info("Nessuna configurazione di tipo " + tipoOut + " migrata");
            }
        } else if (iw.getElementi() != null && !iw.getElementi().isEmpty()) {
            this.log.info(iw.getElementi().size() + " configurazioni di tipo " + tipoOut + " migrate correttamente");
            sbMigrate = new StringBuffer();
            filename = "migrate_correttamente.csv";
            sbMigrate.append(tipoIn).append("\n");
            for (AbstractWrapperWithKey<?> abstractWrapperWithKey : iw.getElementi()) {
                sbMigrate.append(abstractWrapperWithKey.getKeyString()).append("\n");
            }
            this.writeReport(path, filename, sbMigrate.toString(), tipoIn + " migrate");
        } else {
            this.log.info("Nessuna configurazione di tipo " + tipoOut + " migrata");
        }
        if (tipo.equals((Object)TIPO_MIGRATO.FRUIZIONE) || tipo.equals((Object)TIPO_MIGRATO.EROGAZIONE)) {
            if (iw.getElementiGiaPresenti() != null && !iw.getElementiGiaPresenti().isEmpty()) {
                sbGiaPresenti = new StringBuffer();
                filename = "gia_presenti.csv";
                Path pathGiaPresenti = Paths.get(path.toString(), filename);
                this.log.info(iw.getElementiGiaPresenti().size() + " configurazioni di tipo " + tipoOut + " non inserite perche' gia' presenti, ma aggiornate. Scrivo l'elenco in: " + pathGiaPresenti.toString());
                sbGiaPresenti.append(new UrlInvocazioneBean().getHeader(tipoIn)).append("\n");
                for (AbstractWrapperWithKey<?> elem : iw.getElementiGiaPresenti()) {
                    sbGiaPresenti.append(urlInvocazioneMap.get(elem.getKey())).append("\n");
                }
                this.writeReport(path, filename, sbGiaPresenti.toString(), tipoIn + " gia presenti");
            } else {
                this.log.info("Nessuna configurazione di tipo " + tipoOut + " gia presente");
            }
        } else if (iw.getElementiGiaPresenti() != null && !iw.getElementiGiaPresenti().isEmpty()) {
            sbGiaPresenti = new StringBuffer();
            filename = "gia_presenti.csv";
            Path pathGiaPresenti = Paths.get(path.toString(), filename);
            this.log.info(iw.getElementiGiaPresenti().size() + " configurazioni di tipo " + tipoOut + " non inserite perche' gia' presenti, ma aggiornate. Scrivo l'elenco in: " + pathGiaPresenti.toString());
            sbGiaPresenti.append(tipoIn).append("\n");
            for (AbstractWrapperWithKey<?> elem : iw.getElementiGiaPresenti()) {
                sbGiaPresenti.append(elem.getKey()).append("\n");
            }
            this.writeReport(path, filename, sbGiaPresenti.toString(), tipoIn + " gia presenti");
        } else {
            this.log.info("Nessuna configurazione di tipo " + tipoOut + " gia presente");
        }
        if (iw.getElementiNonMigrati() != null && !iw.getElementiNonMigrati().isEmpty()) {
            StringBuffer sbNonMigrate = new StringBuffer();
            filename = "non_migrate.csv";
            this.log.info(iw.getElementiNonMigrati().size() + " configurazioni di tipo " + tipoOut + " non migrate. Scrivo il mapping tra " + tipoIn + " e causa della mancata migrazione in: " + Paths.get(path.toString(), filename));
            sbNonMigrate.append(tipoIn + ",motivo della mancata migrazione").append("\n");
            for (Object obj : iw.getElementiNonMigrati().keySet()) {
                sbNonMigrate.append(obj + "," + iw.getElementiNonMigrati().get(obj)).append("\n");
            }
            this.writeReport(path, filename, sbNonMigrate.toString(), tipoIn + " non migrate");
        } else {
            this.log.info("Nessuna configurazione di tipo " + tipoOut + " in stato mancata migrazione");
        }
        if (iw.getWarnings() != null && !iw.getWarnings().isEmpty()) {
            StringBuffer sbMigrateParzialmente = new StringBuffer();
            filename = "migrate_parzialmente.csv";
            this.log.info(iw.getWarningList().size() + " configurazioni di tipo " + tipoOut + " migrate parzialmente (e disabilitate). Scrivo il mapping tra " + tipoIn + " e cause della migrazione parziale in: " + Paths.get(path.toString(), filename));
            if (urlInvocazioneMap != null) {
                sbMigrateParzialmente.append(new UrlInvocazioneBean().getHeader(tipoIn));
            } else {
                sbMigrateParzialmente.append(tipoIn);
            }
            sbMigrateParzialmente.append(",causa della migrazione parziale");
            if (MigrazioneProperties.getInstance().getTipoMigrazioneServizi().equals((Object)MigrazioneProperties.TIPO_MIGRAZIONE_SERVIZI.SPC_E_GW)) {
                sbMigrateParzialmente.append("causa della migrazione parziale(NO SPC)");
            }
            sbMigrateParzialmente.append("\n");
            for (Warnings<AbstractWrapperWithKey<?>> warnings : iw.getWarningList()) {
                Object k = warnings.getKey().getKey();
                if (urlInvocazioneMap != null && urlInvocazioneMap.containsKey(k)) {
                    sbMigrateParzialmente.append(urlInvocazioneMap.get(k));
                } else {
                    sbMigrateParzialmente.append(k);
                }
                sbMigrateParzialmente.append(",").append(warnings.getWarnings());
                if (MigrazioneProperties.getInstance().getTipoMigrazioneServizi().equals((Object)MigrazioneProperties.TIPO_MIGRAZIONE_SERVIZI.SPC_E_GW)) {
                    sbMigrateParzialmente.append(",").append(warnings.getWarningsNoSpc());
                }
                sbMigrateParzialmente.append("\n");
            }
            this.writeReport(path, filename, sbMigrateParzialmente.toString(), tipoIn + " migrate parzialmente");
        } else {
            this.log.info("Nessuna configurazione di tipo " + tipoOut + " migrata parzialmente");
        }
    }

    private void writeReport(Path path, String filename, String message, String tipo) throws Exception {
        if (path.toFile().exists()) {
            if (!path.toFile().isDirectory()) {
                throw new Exception(path.toFile() + " deve essere un file di tipo directory");
            }
        } else {
            path.toFile().mkdirs();
        }
        Path fileOut = Paths.get(path.toString(), filename);
        try {
            Files.write((byte[])message.getBytes(), (File)fileOut.toFile());
            this.log.info("Rapporto migrazione [" + tipo + "] scritto su " + fileOut.toFile());
        }
        catch (IOException e) {
            this.log.error("Errore durante la scrittura del rapporto migrazione [" + tipo + "] su " + fileOut.toFile() + ":" + e.getMessage());
        }
    }

    private void initMultitenant(InputWrapper<IDSoggetto, SoggettoWrapper> soggetti, InputWrapper<IDPortaApplicativaByNome, ErogazioneWrapper> erogazioni, InputWrapper<IDPortaDelegata, FruizioneWrapper> fruizioni) throws Exception {
        this.log.info("Costruzione configurazione multitenant...");
        MultitenantConfigurazione conf = new MultitenantConfigurazione();
        long interni = 0L;
        for (int i = 0; i < soggetti.getElementi().size(); ++i) {
            if (!soggetti.getElementi().get(i).getSoggetto().getDominio().equals((Object)DominioEnum.INTERNO)) continue;
            ++interni;
        }
        conf.setCountSoggetti(interni);
        boolean isTutti = false;
        for (ErogazioneWrapper erog : erogazioni.getElementi()) {
            if (erog.getTipoMultitenant().equals((Object)AbstractFruizioneErogazioneWrapper.TIPO_MULTITENANT.TUTTI)) {
                conf.setErogazioni(MultitenantConfigurazione.TIPO_MULTITENANT.TUTTI);
                isTutti = true;
                continue;
            }
            if (isTutti || !erog.getTipoMultitenant().equals((Object)AbstractFruizioneErogazioneWrapper.TIPO_MULTITENANT.ESCLUDI_FRUITORE_EROGATORE)) continue;
            conf.setErogazioni(MultitenantConfigurazione.TIPO_MULTITENANT.ESCLUDI_FRUITORE_EROGATORE);
        }
        if (conf.getErogazioni() == null) {
            conf.setErogazioni(MultitenantConfigurazione.TIPO_MULTITENANT.ESTERNI);
        }
        boolean isTuttiFruitori = false;
        for (FruizioneWrapper fruizione : fruizioni.getElementi()) {
            if (fruizione.getTipoMultitenant().equals((Object)AbstractFruizioneErogazioneWrapper.TIPO_MULTITENANT.TUTTI)) {
                conf.setFruizioni(MultitenantConfigurazione.TIPO_MULTITENANT.TUTTI);
                isTuttiFruitori = true;
                continue;
            }
            if (isTuttiFruitori || !fruizione.getTipoMultitenant().equals((Object)AbstractFruizioneErogazioneWrapper.TIPO_MULTITENANT.ESCLUDI_FRUITORE_EROGATORE)) continue;
            conf.setFruizioni(MultitenantConfigurazione.TIPO_MULTITENANT.ESCLUDI_FRUITORE_EROGATORE);
        }
        if (conf.getFruizioni() == null) {
            conf.setFruizioni(MultitenantConfigurazione.TIPO_MULTITENANT.ESTERNI);
        }
        this.log.info("Aggiornamento multitenant");
        this.writer.updateMultitenantConf(conf);
        this.log.info("Aggiornamento multitenant completato.");
    }

    private InputWrapper<IDSoggetto, SoggettoWrapper> migraSoggetti(InputWrapper<IDSoggetto, SoggettoWrapper> input, InputWrapper<IDPortaApplicativaByNome, ErogazioneWrapper> erogazioni) throws Exception {
        this.log.info("Inserimento Soggetti ...");
        for (ErogazioneWrapper erogazione : erogazioni.getElementi()) {
            if (!erogazione.isAggiungiCredenzialiASoggetto() || erogazione.getControlloAccessiLst() == null) continue;
            for (ControlloAccessiAutorizzazioneSoggetto acl : erogazione.getControlloAccessiLst()) {
                for (SoggettoWrapper soggetto : input.getElementi()) {
                    if (!soggetto.getSoggetto().getNome().equals(acl.getSoggetto()) || !soggetto.getProfilo().equals((Object)ProfiloEnum.APIGATEWAY) || soggetto.getSoggetto().getCredenziali() != null) continue;
                    AuthenticationHttps credenziali = new AuthenticationHttps();
                    AuthenticationHttpsConfigurazioneManuale authenticationHttpsConfigurazioneManuale = new AuthenticationHttpsConfigurazioneManuale();
                    authenticationHttpsConfigurazioneManuale.setSubject("c=it/o=" + soggetto.getSoggetto().getNome() + "/" + (soggetto.getProfilo().equals((Object)ProfiloEnum.APIGATEWAY) ? "profilo=api/" : ""));
                    authenticationHttpsConfigurazioneManuale.setTipo(TipoAutenticazioneHttps.CONFIGURAZIONE_MANUALE);
                    credenziali.setCertificato((OneOfAuthenticationHttpsCertificato)authenticationHttpsConfigurazioneManuale);
                    credenziali.setModalitaAccesso(ModalitaAccessoEnum.HTTPS);
                    soggetto.getSoggetto().setCredenziali((OneOfBaseCredenzialiCredenziali)credenziali);
                }
            }
        }
        InputWrapper<IDSoggetto, SoggettoWrapper> output = this.writer.insertAllSoggetti(input);
        this.log.info("Inserimento Soggetti completato");
        return output;
    }

    private InputWrapper<String, ApiWrapper> migraApi(InputWrapper<String, ApiWrapper> input) throws Exception {
        this.log.info("Inserimento API ...");
        InputWrapper<String, ApiWrapper> output = this.writer.insertAllApi(input);
        this.log.info("Inserimento API completato");
        return output;
    }

    private InputWrapper<IDPortaApplicativaByNome, ErogazioneWrapper> migraErogazioni(InputWrapper<IDPortaApplicativaByNome, ErogazioneWrapper> input) throws Exception {
        this.log.info("Inserimento Erogazioni ...");
        InputWrapper<IDPortaApplicativaByNome, ErogazioneWrapper> output = this.writer.insertAllErogazioni(input);
        this.writer.disabilitaAbilitaErogazioni(output);
        this.log.info("Inserimento Erogazioni completato");
        return output;
    }

    private InputWrapper<IDServizioApplicativo, ApplicativoWrapper> migraApplicativi(InputWrapper<IDServizioApplicativo, ApplicativoWrapper> input) {
        this.log.info("Inserimento Applicativi...");
        InputWrapper<IDServizioApplicativo, ApplicativoWrapper> output = this.writer.insertAllApplicativi(input);
        this.log.info("Inserimento Applicativi completato");
        return output;
    }

    private InputWrapper<IDPortaDelegata, FruizioneWrapper> migraFruizioni(InputWrapper<IDPortaDelegata, FruizioneWrapper> input) throws Exception {
        this.log.info("Inserimento Fruizioni ...");
        InputWrapper<IDPortaDelegata, FruizioneWrapper> output = this.writer.insertAllFruizioni(input);
        this.writer.disabilitaAbilitaFruizioni(output);
        this.log.info("Inserimento Fruizioni completato");
        return output;
    }

    private void migraRuoli(InputWrapper<IDRuolo, Ruolo> input) throws Exception {
        this.log.info("Inserimento Ruoli ...");
        this.writer.insertAllRuoli(input.getElementi());
        this.log.info("Inserimento Ruoli completato");
    }

    private static enum TIPO_MIGRATO {
        SOGGETTO,
        API,
        APPLICATIVO,
        EROGAZIONE,
        FRUIZIONE;

    }

    private class UrlInvocazioneBean {
        public String porta;
        public String migrata;
        public String migrataNoSpc = "";
        public String connettoriPath = "";
        public String wsSecReqPath = "";
        public String wsSecResPath = "";
        private boolean showMigrataNoSpc = MigrazioneProperties.getInstance().getTipoMigrazioneServizi().equals((Object)MigrazioneProperties.TIPO_MIGRAZIONE_SERVIZI.SPC_E_GW);

        public String toString() {
            ArrayList<String> lst = new ArrayList<String>();
            lst.add(this.porta);
            lst.add(this.migrata);
            if (this.showMigrataNoSpc) {
                lst.add(this.migrataNoSpc);
            }
            lst.add(this.connettoriPath);
            lst.add(this.wsSecReqPath);
            lst.add(this.wsSecResPath);
            return String.join((CharSequence)",", lst);
        }

        public String getHeader(String tipoIn) throws Exception {
            StringBuilder sbMigrate = new StringBuilder();
            sbMigrate.append(tipoIn + ",url invocazione");
            if (this.showMigrataNoSpc) {
                sbMigrate.append(",url invocazione (no SPC)");
            }
            sbMigrate.append(",path connettore").append(",path WS-Security request").append(",path WS-Security response");
            return sbMigrate.toString();
        }
    }
}

