/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway;

import it.link.pdd.tools.migrazione_govway.AbstractMigrazione;
import it.link.pdd.tools.migrazione_govway.Utilities;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.ServizioApplicativo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.Soggetto;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDAccordo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.AccordoCooperazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.AccordoServizioParteComune;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.AccordoServizioParteSpecifica;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Ruolo;
import it.link.pdd.tools.migrazione_govway.reader.IConfigurazioneServiziReader;
import it.link.pdd.tools.migrazione_govway.reader.ReaderFactory;
import it.link.pdd.tools.migrazione_govway.wrapper.ConnettoriProperty;
import it.link.pdd.tools.migrazione_govway.wrapper.PortaApplicativaV2Wrapper;
import it.link.pdd.tools.migrazione_govway.wrapper.PortaDelegataV2Wrapper;
import it.link.pdd.tools.migrazione_govway.wrapper.PortaDominioV2Wrapper;
import it.link.pdd.tools.migrazione_govway.writer.Openspcoop2ConfigurazioneServiziWriter;
import java.util.List;

public class MigrazioneConfigurazioneServizi
extends AbstractMigrazione {
    private IConfigurazioneServiziReader reader;
    private Openspcoop2ConfigurazioneServiziWriter writer;

    public MigrazioneConfigurazioneServizi(String propertiesFile, String dbInFile, String dbOutFile) throws Exception {
        super(propertiesFile, dbInFile, dbOutFile);
        this.reader = ReaderFactory.getConfigurazioneServiziReader(this.dbIn, this.dbOut, Utilities.getDriverLogger());
        this.writer = new Openspcoop2ConfigurazioneServiziWriter(this.dbOut, Utilities.getDriverLogger());
    }

    public static void main(String[] args) {
        try {
            if (args.length < 3) {
                throw new Exception("Usage: java " + MigrazioneConfigurazioneServizi.class + " propertiesFile dbInFile dbOutFile");
            }
            MigrazioneConfigurazioneServizi migrazione = new MigrazioneConfigurazioneServizi(args[0].trim(), args[1].trim(), args[2].trim());
            migrazione.migra();
        }
        catch (Exception e) {
            System.err.println("Errore durante la migrazione della Configurazione dei Servizi di OpenSPCoop1:" + e.getMessage());
            e.printStackTrace(System.err);
            System.exit(1);
        }
    }

    public void migra() throws Exception {
        try {
            this.migraPdD();
            this.migraRuoli();
            this.migraSoggettiRegistro();
            this.migraAccordiCooperazione();
            this.migraAccordiParteComuneNonComposti();
            this.migraServiziNonComposti();
            this.migraServiziCorrelatiNonComposti();
            this.migraAccordiParteComuneComposti();
            this.migraServiziComposti();
            this.migraServiziCorrelatiComposti();
            this.migraSoggettiConfig();
            this.migraConnettoreProperties();
            this.migraServiziApplicativi();
            this.migraPorteApplicative();
            this.migraPorteDelegate();
        }
        catch (Throwable t) {
            this.log.error(t.getMessage(), t);
            throw t;
        }
        finally {
            if (this.reader != null) {
                try {
                    this.reader.closeConnection();
                }
                catch (Exception exception) {}
            }
            if (this.writer != null) {
                try {
                    this.writer.closeConnection();
                }
                catch (Exception exception) {}
            }
        }
    }

    private void migraPdD() throws Exception {
        this.log.info("Recupera Porte Di Dominio da inserire ...");
        List<PortaDominioV2Wrapper> lst = this.reader.findAllPdD();
        this.log.info("Inserimento [" + lst.size() + "] Porte Di Dominio...");
        this.writer.insertAllPdD(lst);
        this.log.info("Inserimento [" + lst.size() + "] Porte Di Dominio completato");
    }

    private void migraRuoli() throws Exception {
        this.log.info("Recupera Ruoli da inserire ...");
        List<Ruolo> lst = this.reader.findAllRuoli();
        this.log.info("Inserimento [" + lst.size() + "] Ruoli...");
        this.writer.insertAllRuoli(lst);
        this.log.info("Inserimento [" + lst.size() + "] Ruoli completato");
    }

    private void migraSoggettiRegistro() throws Exception {
        this.log.info("Recupera Soggetti (registro) da inserire ...");
        List<it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Soggetto> lst = this.reader.findAllSoggettiRegistro();
        this.log.info("Inserimento [" + lst.size() + "] Soggetti (registro)...");
        this.writer.insertAllSoggettiRegistro(lst);
        this.log.info("Inserimento [" + lst.size() + "] Soggetti (registro) completato");
    }

    private void migraAccordiParteComuneNonComposti() throws Exception {
        this.log.info("Recupera Accordi di Servizio Parte Comune Non Composti da inserire ...");
        List<AccordoServizioParteComune> lst = this.reader.findAllAccordiParteComuneNonComposti();
        this.log.info("Inserimento [" + lst.size() + "] Accordi di Servizio Parte Comune Non Composti...");
        this.writer.insertAllAccordiParteComune(lst);
        this.log.info("Inserimento [" + lst.size() + "] Accordi di Servizio Parte Comune Non Composti completato");
    }

    private void migraServiziNonComposti() throws Exception {
        this.log.info("Recupera IdAccordiNonComposti ...");
        List<IDAccordo> lstIdAccordi = this.reader.findIdAccordiNonComposti();
        this.log.info("Recuperati [" + (lstIdAccordi != null ? lstIdAccordi.size() : 0) + "] IdAccordiNonComposti, recupera Servizi Non Composti da inserire ...");
        List<AccordoServizioParteSpecifica> lst = this.reader.findAllServizi(lstIdAccordi);
        this.log.info("Inserimento [" + lst.size() + "] Servizi Non Composti...");
        this.writer.insertAllServizi(lst);
        this.log.info("Inserimento [" + lst.size() + "] Servizi Non Composti completato");
    }

    private void migraServiziCorrelatiNonComposti() throws Exception {
        this.log.info("Recupera IdAccordiNonComposti ...");
        List<IDAccordo> lstIdAccordi = this.reader.findIdAccordiNonComposti();
        this.log.info("Recuperati [" + (lstIdAccordi != null ? lstIdAccordi.size() : 0) + "] IdAccordiNonComposti, recupera Servizi Correlati Non Composti da inserire ...");
        List<AccordoServizioParteSpecifica> lst = this.reader.findAllServiziCorrelati(lstIdAccordi);
        this.log.info("Inserimento [" + lst.size() + "] Servizi Correlati Non Composti...");
        this.writer.insertAllServizi(lst);
        this.log.info("Inserimento [" + lst.size() + "] Servizi Correlati Non Composti completato");
    }

    private void migraAccordiParteComuneComposti() throws Exception {
        this.log.info("Recupera Accordi di Servizio Parte Comune Composti ...");
        List<AccordoServizioParteComune> lst = this.reader.findAllAccordiParteComuneComposti();
        this.log.info("Inserimento [" + lst.size() + "] Accordi di Servizio Parte Comune Composti...");
        this.writer.insertAllAccordiParteComune(lst);
        this.log.info("Inserimento [" + lst.size() + "] Accordi di Servizio Parte Comune Composti completato");
    }

    private void migraServiziComposti() throws Exception {
        this.log.info("Recupera IdAccordiComposti ...");
        List<IDAccordo> lstIdAccordi = this.reader.findIdAccordiComposti();
        this.log.info("Recuperati [" + (lstIdAccordi != null ? lstIdAccordi.size() : 0) + "] IdAccordiComposti, recupera Servizi Composti da inserire ...");
        List<AccordoServizioParteSpecifica> lst = this.reader.findAllServizi(lstIdAccordi);
        this.log.info("Inserimento [" + lst.size() + "] Servizi Composti...");
        this.writer.insertAllServizi(lst);
        this.log.info("Inserimento [" + lst.size() + "] Servizi Composti completato");
    }

    private void migraServiziCorrelatiComposti() throws Exception {
        this.log.info("Recupera IdAccordiComposti ...");
        List<IDAccordo> lstIdAccordi = this.reader.findIdAccordiComposti();
        this.log.info("Recuperati [" + (lstIdAccordi != null ? lstIdAccordi.size() : 0) + "] IdAccordiComposti, recupera Servizi Correlati Composti da inserire ...");
        List<AccordoServizioParteSpecifica> lst = this.reader.findAllServiziCorrelati(lstIdAccordi);
        this.log.info("Inserimento [" + lst.size() + "] Servizi Correlati Composti...");
        this.writer.insertAllServizi(lst);
        this.log.info("Inserimento [" + lst.size() + "] Servizi Correlati Composti completato");
    }

    private void migraAccordiCooperazione() throws Exception {
        this.log.info("Recupera Accordi di Cooperazione da inserire ...");
        List<AccordoCooperazione> lst = this.reader.findAllAccordiCooperazione();
        this.log.info("Inserimento [" + lst.size() + "] Accordi di Cooperazione...");
        this.writer.insertAllAccordiCooperazione(lst);
        this.log.info("Inserimento [" + lst.size() + "] Accordi di Cooperazione completato");
    }

    private void migraSoggettiConfig() throws Exception {
        this.log.info("Recupera Soggetti (configurazione) da inserire ...");
        List<Soggetto> lst = this.reader.findAllSoggettiConfig();
        this.log.info("Inserimento [" + lst.size() + "] Soggetti (configurazione)...");
        this.writer.insertAllSoggettiConfig(lst);
        this.log.info("Inserimento [" + lst.size() + "] Soggetti (configurazione) completato");
    }

    private void migraServiziApplicativi() throws Exception {
        this.log.info("Recupera Servizi Applicativi da inserire ...");
        List<ServizioApplicativo> lst = this.reader.findAllServiziApplicativi();
        this.log.info("Inserimento [" + lst.size() + "] Servizi Applicativi...");
        this.writer.insertAllServiziApplicativi(lst);
        this.log.info("Inserimento [" + lst.size() + "] Servizi Applicativi completato");
    }

    private void migraPorteApplicative() throws Exception {
        this.log.info("Recupera Porte Applicative da inserire ...");
        List<PortaApplicativaV2Wrapper> lst = this.reader.findAllPorteApplicative();
        this.log.info("Inserimento [" + lst.size() + "] Porte Applicative...");
        this.writer.insertAllPorteApplicative(lst);
        this.log.info("Inserimento [" + lst.size() + "] Porte Applicative completato");
    }

    private void migraPorteDelegate() throws Exception {
        this.log.info("Recupera Porte Delegate da inserire ...");
        List<PortaDelegataV2Wrapper> lst = this.reader.findAllPorteDelegate();
        this.log.info("Inserimento [" + lst.size() + "] Porte Delegate...");
        this.writer.insertAllPorteDelegate(lst);
        this.log.info("Inserimento [" + lst.size() + "] Porte Delegate completato");
    }

    private void migraConnettoreProperties() throws Exception {
        this.log.info("Recupera Connettore Properties da inserire ...");
        List<ConnettoriProperty> lst = this.reader.findAllConnettoriProperties();
        this.log.info("Inserimento [" + lst.size() + "] Connettore Properties...");
        this.writer.insertAllConnettoreProperties(lst);
        this.log.info("Inserimento [" + lst.size() + "] Connettore Properties completato");
    }
}

