/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;

public class HSQLToDerbyConverter {
    public static void main(String[] args) {
        String fileHsqlInput = null;
        String fileDerbyOutput = null;
        if (args.length < 2) {
            System.err.println("Usage: " + HSQLToDerbyConverter.class.getName() + " fileHsqlInput fileDerbyOutput");
            System.exit(1);
        }
        if (!args[0].trim().equals("${fileHsqlInput}")) {
            fileHsqlInput = args[0].trim();
        } else {
            System.err.println("Errore: specificare il file in input");
            System.exit(2);
        }
        if (!args[1].trim().equals("${fileDerbyOutput}")) {
            fileDerbyOutput = args[1].trim();
        } else {
            System.err.println("Errore: specificare il file in output");
            System.exit(3);
        }
        try {
            String db = HSQLToDerbyConverter.getStringDb(fileHsqlInput);
            String newDb = db.replaceAll("LONGVARCHAR", "CLOB").replaceAll("VARCHAR\\(65535\\)", "CLOB").replaceAll("VARBINARY\\([0-9]*\\)", "BLOB");
            HSQLToDerbyConverter.putStringFile(fileDerbyOutput, newDb);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            System.err.println("Errore durante la conversione del file hsql [" + fileHsqlInput + "] nel file derby [" + fileDerbyOutput + "]: " + e.getMessage());
        }
    }

    private static void checkFile(String filePath) throws Exception {
        File file = new File(filePath);
        if (!file.exists()) {
            throw new Exception("Il file [" + filePath + "] non esiste");
        }
        if (!file.canRead()) {
            throw new Exception("Il file [" + filePath + "] e' protetto in lettura");
        }
        if (!file.canWrite()) {
            throw new Exception("Il file [" + filePath + "] e' protetto in scrittura");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getStringDb(String filePath) throws Exception {
        HSQLToDerbyConverter.checkFile(filePath);
        InputStreamReader fr = null;
        StringBuffer sb = new StringBuffer();
        try {
            fr = new FileReader(new File(filePath));
            int length = 1;
            char[] cbuf = new char[length];
            int n = fr.read(cbuf, 0, length);
            sb.append(cbuf);
            while (n > 0) {
                n = fr.read(cbuf, 0, length);
                sb.append(cbuf);
            }
        }
        finally {
            if (fr != null) {
                try {
                    fr.close();
                }
                catch (Exception exception) {}
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void putStringFile(String filePath, String newDb) throws Exception {
        OutputStreamWriter fw = null;
        try {
            fw = new FileWriter(new File(filePath));
            fw.write(newDb);
        }
        finally {
            if (fw != null) {
                try {
                    fw.flush();
                }
                catch (Exception exception) {}
            }
            if (fw != null) {
                try {
                    fw.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

