/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway;

import it.link.pdd.tools.migrazione_govway.properties.DatabaseProperties;
import it.link.pdd.tools.migrazione_govway.properties.MigrazioneProperties;
import it.link.pdd.tools.migrazione_govway.utils.LoggerWrapperFactory;
import java.io.InputStream;
import java.util.Properties;
import org.apache.logging.log4j.Level;
import org.slf4j.Logger;

public class AbstractMigrazione {
    protected Logger log;
    protected DatabaseProperties dbIn;
    protected DatabaseProperties dbOut;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractMigrazione(String propertiesFile, String dbInFile, String dbOutFile) throws Exception {
        InputStream inPropLog4j = null;
        Properties propertiesLog4j = new Properties();
        try {
            LoggerWrapperFactory.setDefaultConsoleLogConfiguration((Level)Level.ERROR);
            inPropLog4j = AbstractMigrazione.class.getResourceAsStream("/migrazione_govway.log4j2.properties");
            propertiesLog4j.load(inPropLog4j);
            LoggerWrapperFactory.setLogConfiguration((Properties)propertiesLog4j);
        }
        catch (Exception e) {
            System.err.println("Impossibile leggere i dati dal file 'migrazione_govway.log4j2.properties': " + e.getMessage());
            return;
        }
        finally {
            try {
                if (inPropLog4j != null) {
                    inPropLog4j.close();
                }
            }
            catch (Exception exception) {}
        }
        this.log = LoggerWrapperFactory.getLogger((String)"migrazione");
        this.dbIn = new DatabaseProperties(dbInFile, this.log);
        this.dbOut = new DatabaseProperties(dbOutFile, this.log);
        MigrazioneProperties.init(propertiesFile);
    }
}

