/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.utils.xml;

import it.link.pdd.tools.migrazione_govway.utils.date.DateManager;
import it.link.pdd.tools.migrazione_govway.utils.resources.FileSystemUtilities;
import it.link.pdd.tools.migrazione_govway.utils.xml.ValidatoreXSD;
import it.link.pdd.tools.migrazione_govway.utils.xml.XMLException;
import it.link.pdd.tools.migrazione_govway.utils.xml.XSDResourceResolver;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.validation.Schema;
import org.slf4j.Logger;
import org.w3c.dom.ls.LSResourceResolver;

public class XSDSchemaCollection {
    private byte[] schemaRoot;
    private Hashtable<String, byte[]> resources;
    private Hashtable<String, String> mappingNamespaceLocations;
    private boolean serializeXSDSchemi_buildSchemaSuccess = false;
    private boolean serializeXSDSchemi_buildSchemaError = true;
    private static long counter = 0L;

    public boolean isSerializeXSDSchemi_buildSchemaSuccess() {
        return this.serializeXSDSchemi_buildSchemaSuccess;
    }

    public void setSerializeXSDSchemi_buildSchemaSuccess(boolean serializeXSDSchemi_buildSchemaSuccess) {
        this.serializeXSDSchemi_buildSchemaSuccess = serializeXSDSchemi_buildSchemaSuccess;
    }

    public boolean isSerializeXSDSchemi_buildSchemaError() {
        return this.serializeXSDSchemi_buildSchemaError;
    }

    public void setSerializeXSDSchemi_buildSchemaError(boolean serializeXSDSchemi_buildSchemaErrror) {
        this.serializeXSDSchemi_buildSchemaError = serializeXSDSchemi_buildSchemaErrror;
    }

    public byte[] getSchemaRoot() {
        return this.schemaRoot;
    }

    public void setSchemaRoot(byte[] schemaRoot) {
        this.schemaRoot = schemaRoot;
    }

    public Hashtable<String, byte[]> getResources() {
        return this.resources;
    }

    public void setResources(Hashtable<String, byte[]> resources) {
        this.resources = resources;
    }

    public Hashtable<String, String> getMappingNamespaceLocations() {
        return this.mappingNamespaceLocations;
    }

    public void setMappingNamespaceLocations(Hashtable<String, String> mappingNamespaceLocations) {
        this.mappingNamespaceLocations = mappingNamespaceLocations;
    }

    public void serialize(Logger log, File file) throws XMLException {
        FileOutputStream fout = null;
        try {
            fout = new FileOutputStream(file);
            this.serialize(log, fout);
            fout.flush();
        }
        catch (Exception e) {
            throw new XMLException(e.getMessage(), e);
        }
        finally {
            try {
                if (fout != null) {
                    fout.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void serialize(Logger log, String fileName) throws XMLException {
        FileOutputStream fout = null;
        try {
            fout = new FileOutputStream(fileName);
            this.serialize(log, fout);
            fout.flush();
        }
        catch (Exception e) {
            throw new XMLException(e.getMessage(), e);
        }
        finally {
            try {
                if (fout != null) {
                    fout.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public byte[] serialize(Logger log) throws XMLException {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            this.serialize(log, bout);
            bout.flush();
            bout.close();
            return bout.toByteArray();
        }
        catch (Exception e) {
            throw new XMLException(e.getMessage(), e);
        }
    }

    public void serialize(Logger log, OutputStream out) throws XMLException {
        ZipOutputStream zipOut = null;
        try {
            zipOut = new ZipOutputStream(out);
            this.zipSerialize(log, zipOut);
            zipOut.flush();
        }
        catch (Exception e) {
            throw new XMLException(e.getMessage(), e);
        }
        finally {
            try {
                if (zipOut != null) {
                    zipOut.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void zipSerialize(Logger log, ZipOutputStream zipOut) throws XMLException {
        try {
            Object rootPackageDir = "";
            rootPackageDir = "schemi" + File.separatorChar;
            Object nomeFile = "RootSchema.xsd";
            zipOut.putNextEntry(new ZipEntry((String)rootPackageDir + (String)nomeFile));
            zipOut.write(this.schemaRoot);
            if (this.resources != null && this.resources.size() > 0) {
                Enumeration<String> kesy = this.resources.keys();
                while (kesy.hasMoreElements()) {
                    String name = kesy.nextElement();
                    nomeFile = name;
                    zipOut.putNextEntry(new ZipEntry((String)rootPackageDir + (String)nomeFile));
                    zipOut.write(this.resources.get(name));
                    Enumeration<String> namespaces = this.mappingNamespaceLocations.keys();
                    String namespaceFound = null;
                    String locationFound = null;
                    while (namespaces.hasMoreElements()) {
                        String namespace = namespaces.nextElement();
                        String location = this.mappingNamespaceLocations.get(namespace);
                        String[] split = location.split(" ");
                        if (split == null) continue;
                        for (int i = 0; i < split.length; ++i) {
                            if (split[i] == null || !split[i].equals(nomeFile)) continue;
                            namespaceFound = namespace;
                            locationFound = location;
                            break;
                        }
                        if (namespaceFound == null) continue;
                        break;
                    }
                    if (namespaceFound == null) continue;
                    nomeFile = name + ".namespace.txt";
                    zipOut.putNextEntry(new ZipEntry((String)rootPackageDir + (String)nomeFile));
                    Object valore = namespaceFound;
                    if (locationFound != null) {
                        valore = locationFound + "\n" + valore;
                    }
                    zipOut.write(((String)valore).getBytes());
                }
            }
            try {
                this._buildSchema(log, false, false);
            }
            catch (Throwable e) {
                log.error("Costruzione Struttura degli Schemi XSD fallita: " + e.getMessage(), e);
                nomeFile = "BuildSchemaFailed.txt";
                zipOut.putNextEntry(new ZipEntry((String)nomeFile));
                String msg = e.getMessage();
                if (msg == null || msg.equals("")) {
                    if (e instanceof NullPointerException) {
                        msg = "Internal Error (NP)";
                    } else {
                        msg = e.toString();
                        if (msg == null || msg.equals("")) {
                            msg = "Internal Error";
                        }
                    }
                }
                zipOut.write(msg.getBytes());
            }
        }
        catch (Exception e) {
            throw new XMLException(e.getMessage(), e);
        }
    }

    public Schema buildSchema(Logger logger) throws XMLException {
        return this._buildSchema(logger, this.serializeXSDSchemi_buildSchemaSuccess, this.serializeXSDSchemi_buildSchemaError);
    }

    private Schema _buildSchema(Logger logger, boolean serializeXSDSchemi_buildSchemaSuccess, boolean serializeXSDSchemi_buildSchemaErrror) throws XMLException {
        XSDResourceResolver resourceResolver = new XSDResourceResolver(this.resources);
        try {
            ValidatoreXSD validatoreXSD = new ValidatoreXSD(logger, "org.apache.xerces.jaxp.validation.XMLSchemaFactory", (LSResourceResolver)resourceResolver, (InputStream)new ByteArrayInputStream(this.schemaRoot));
            if (serializeXSDSchemi_buildSchemaSuccess) {
                this.debugPrintXSDSchemi(this.schemaRoot, resourceResolver, logger, true);
            }
            return validatoreXSD.getSchema();
        }
        catch (Exception e) {
            if (serializeXSDSchemi_buildSchemaErrror) {
                this.debugPrintXSDSchemi(this.schemaRoot, resourceResolver, logger, false);
            }
            throw new XMLException("Riscontrato errore durante l'inizializzazione dello schema: " + e.getMessage(), e);
        }
    }

    private void debugPrintXSDSchemi(byte[] schemaPerValidazione, XSDResourceResolver resourceResolver, Logger logger, boolean success) {
        try {
            File dir = File.createTempFile("xsd_dir_", "");
            dir.delete();
            boolean dirCreate = dir.mkdir();
            String uniqueID = XSDSchemaCollection.getIdForDebug();
            File f = null;
            f = (dirCreate &= dir.isDirectory()) ? File.createTempFile("root_" + uniqueID + "_", ".xsd", dir) : File.createTempFile("root_" + uniqueID + "_", ".xsd");
            FileSystemUtilities.writeFile(f, schemaPerValidazione);
            if (resourceResolver != null && resourceResolver instanceof XSDResourceResolver) {
                XSDResourceResolver xsdResolver = resourceResolver;
                Enumeration<String> keys = xsdResolver.getResources().keys();
                while (keys.hasMoreElements()) {
                    String systemId = keys.nextElement();
                    byte[] contenuto = xsdResolver.getResources().get(systemId);
                    File schemaTmpLog = null;
                    schemaTmpLog = dirCreate ? File.createTempFile("import_" + uniqueID + "_" + systemId + "_", ".xsd", dir) : File.createTempFile("import_" + uniqueID + "_" + systemId + "_", ".xsd");
                    FileSystemUtilities.writeFile(schemaTmpLog, contenuto);
                }
            }
            String motivo = null;
            motivo = success ? "completata con successo" : "completata con errore";
            String msg = null;
            msg = dirCreate ? "Inizializzazione dello schema " + motivo + ", gli schemi sono stati registrati nella directory " + dir.getAbsolutePath() : "Inizializzazione dello schema " + motivo + ", gli schemi sono stati registrati nella area temporanea (root schema: " + f.getAbsolutePath() + ")";
            if (success) {
                logger.info(msg);
            } else {
                logger.error(msg);
            }
        }
        catch (Exception eDebug) {
            logger.error("Registrazione xsd per debug non riuscita: " + eDebug.getMessage(), (Throwable)eDebug);
        }
    }

    private static synchronized String getIdForDebug() {
        SimpleDateFormat dateformat = new SimpleDateFormat("yyyy-MM-dd_HH:mm:ss.SSS");
        return "ID_" + ++counter + "_" + dateformat.format(DateManager.getDate());
    }
}

