/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.utils.xml;

import it.link.pdd.tools.migrazione_govway.utils.resources.FileSystemUtilities;
import it.link.pdd.tools.migrazione_govway.utils.xml.PrettyPrintXMLUtils;
import it.link.pdd.tools.migrazione_govway.utils.xml.XQueryEvaluateNotFoundException;
import it.link.pdd.tools.migrazione_govway.utils.xml.XQueryException;
import it.link.pdd.tools.migrazione_govway.utils.xml.XQueryExpressionEngine;
import it.link.pdd.tools.migrazione_govway.utils.xml.XQueryNotValidException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XQueryClientTest {
    private static final String SOAP_XML = "<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\">\n        <soapenv:Header/>\n        <soapenv:Body>\n            <sam:searchResponse xmlns:sam=\"http://www.prova.org\">\n                <sam:searchResponse>\n                    <sam:item>\n                        <id>1</id>\n                        <description>One handy protocol droid</description>\n                        <price>1</price>\n                    </sam:item>\n                    <sam:item>\n                        <id>2</id>\n                        <description>Item nr 2</description>\n                        <price>2</price>\n                    </sam:item>\n                    <sam:item>\n                        <id>3</id>\n                        <description>Item nr 3</description>\n                       <price>3</price>\n                    </sam:item>\n                    <sam:item>\n                        <id>4</id>\n                        <description>Item nr 4</description>\n                        <price>4</price>\n                    </sam:item>\n                    <sam:item>\n                        <id>5</id>\n                        <description>Item nr 5</description>\n                        <price>5</price>\n                    </sam:item>\n                </sam:searchResponse>\n            </sam:searchResponse>\n        </soapenv:Body>\n    </soapenv:Envelope>\n";
    private static final String XQUERY = "declare namespace sam=\"http://www.prova.org\";\n\t<Result>\n\t{\n\tfor $z in //sam:item\n\torder by $z/id\n\treturn <price>{data($z/price/text())}</price>\n\t}\n\t</Result>\n";
    private static final String XQUERY_WITHOUT_CODE_EXTERNAL = "declare namespace sam=\"http://www.prova.org\";\n\tfor $z in //sam:item\n\torder by $z/id\n\treturn <price>{data($z/price/text())}</price>\n";

    public static void main(String[] args) throws Exception {
        File sourceFile = File.createTempFile("src", ".xml");
        FileSystemUtilities.writeFile(sourceFile, SOAP_XML.getBytes());
        File xqueryFile = File.createTempFile("test", ".xquery");
        FileSystemUtilities.writeFile(xqueryFile, XQUERY.getBytes());
        XQueryExpressionEngine xqueryEngine = new XQueryExpressionEngine();
        System.out.println("\n\n\n*************** TESTSUITE SRC **********************");
        System.out.println("======== SRC AS FILE ===========");
        System.out.println(xqueryEngine.evaluate(sourceFile, xqueryFile, true));
        System.out.println("========= SRC AS DOCUMENT ==========");
        System.out.println(xqueryEngine.evaluate(xqueryEngine.getXMLUtils().newDocument(sourceFile), xqueryFile, true));
        System.out.println("======== SRC AS ELEMENT ===========");
        System.out.println(xqueryEngine.evaluate((Node)xqueryEngine.getXMLUtils().newElement(sourceFile), xqueryFile, true));
        System.out.println("======== SRC AS NODE ===========");
        System.out.println(xqueryEngine.evaluate(xqueryEngine.getXMLUtils().newDocument(sourceFile).getDocumentElement().getLastChild(), xqueryFile, true));
        System.out.println("======== SRC AS INPUT STREAM ===========");
        System.out.println(xqueryEngine.evaluate((InputStream)new FileInputStream(sourceFile), xqueryFile, true));
        System.out.println("======== SRC AS READER ===========");
        System.out.println(xqueryEngine.evaluate((Reader)new FileReader(sourceFile), xqueryFile, true));
        System.out.println("======== SRC AS STRING ===========");
        System.out.println(xqueryEngine.evaluate(FileSystemUtilities.readFile(sourceFile), xqueryFile, true));
        System.out.println("\n\n\n*************** TESTSUITE XQUERY **********************");
        System.out.println("======== QUERY AS FILE ===========");
        System.out.println(xqueryEngine.evaluate(sourceFile, xqueryFile, true));
        System.out.println("========= QUERY AS INPUT STREAM ==========");
        System.out.println(xqueryEngine.evaluate(sourceFile, (InputStream)new FileInputStream(xqueryFile), true));
        System.out.println("========= QUERY AS READER ==========");
        System.out.println(xqueryEngine.evaluate(sourceFile, (Reader)new FileReader(xqueryFile), true));
        System.out.println("========= QUERY AS STRING ==========");
        System.out.println(xqueryEngine.evaluate(sourceFile, FileSystemUtilities.readFile(xqueryFile), true));
        System.out.println("\n\n\n*************** TESTSUITE DESTINATION **********************");
        System.out.println("======== DESTINATION AS FILE ===========");
        File tmp = File.createTempFile("prova", ".tmp");
        xqueryEngine.evaluate(sourceFile, xqueryFile, tmp, true);
        System.out.println(FileSystemUtilities.readFile(tmp));
        tmp.delete();
        System.out.println("======== DESTINATION AS OUTPUT STREAM ===========");
        tmp = File.createTempFile("prova", ".tmp");
        FileOutputStream fout = new FileOutputStream(tmp);
        xqueryEngine.evaluate(sourceFile, xqueryFile, (OutputStream)fout, true);
        fout.flush();
        fout.close();
        System.out.println(FileSystemUtilities.readFile(tmp));
        tmp.delete();
        System.out.println("======== DESTINATION AS WRITER ===========");
        tmp = File.createTempFile("prova", ".tmp");
        FileWriter fw = new FileWriter(tmp);
        xqueryEngine.evaluate(sourceFile, xqueryFile, (Writer)fw, true);
        fw.flush();
        fw.close();
        System.out.println(FileSystemUtilities.readFile(tmp));
        tmp.delete();
        System.out.println("======== DESTINATION AS DOCUMENT ===========");
        Document dTmp = xqueryEngine.getXMLUtils().newDocument();
        xqueryEngine.evaluate(sourceFile, xqueryFile, (Node)dTmp, true);
        System.out.println(PrettyPrintXMLUtils.prettyPrintWithTrAX(dTmp, true));
        System.out.println("======== DESTINATION AS ELEMENT ===========");
        dTmp = xqueryEngine.getXMLUtils().newDocument();
        Element eTmp = dTmp.createElement("prova");
        xqueryEngine.evaluate(sourceFile, xqueryFile, (Node)eTmp, true);
        System.out.println(PrettyPrintXMLUtils.prettyPrintWithTrAX(eTmp, true));
        System.out.println("======== DESTINATION AS NODE ===========");
        dTmp = xqueryEngine.getXMLUtils().newDocument();
        eTmp = dTmp.createElement("prova");
        eTmp.appendChild(dTmp.createElement("provaInterno"));
        Node nTmp = eTmp.getFirstChild();
        xqueryEngine.evaluate(sourceFile, xqueryFile, nTmp, true);
        System.out.println(PrettyPrintXMLUtils.prettyPrintWithTrAX(nTmp, true));
        System.out.println("\n\n\n*************** TESTSUITE CASI ERRATI **********************");
        File sourceFileErrato = File.createTempFile("srcErrato", ".xml");
        FileSystemUtilities.writeFile(sourceFileErrato, "<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\">\n        <soapenv:Header/>\n        <soapenv:Body>\n            <sam:searchResponse xmlns:sam=\"http://www.prova.org\">\n                <sam:searchResponse>\n                    <sam:item>\n                        <id>1</id>\n                        <description>One handy protocol droid</description>\n                        <price>1</price>\n                    </sam:item>\n                    <sam:item>\n                        <id>2</id>\n                        <description>Item nr 2</description>\n                        <price>2</price>\n                    </sam:item>\n                    <sam:item>\n                        <id>3</id>\n                        <description>Item nr 3</description>\n                       <price>3</price>\n                    </sam:item>\n                    <sam:item>\n                        <id>4</id>\n                        <description>Item nr 4</description>\n                        <price>4</price>\n                    </sam:item>\n                    <sam:item>\n                        <id>5</id>\n                        <description>Item nr 5</description>\n                        <price>5</price>\n                    </sam:item>\n                </sam:searchResponse>\n            </sam:searchResponse>\n        </soapenv:Body>\n    </soapenv:Envelope>\nALTRO ELEMENTO IN FONDO CHE RENDE INVALIDO XML".getBytes());
        File sourceFileNamespaceDifferente = File.createTempFile("srcNamespaceErrato", ".xml");
        FileSystemUtilities.writeFile(sourceFileNamespaceDifferente, SOAP_XML.replace("www.prova.org", "www.altroNamespace.org").getBytes());
        File xqueryFileErrato = File.createTempFile("testErrato", ".xquery");
        FileSystemUtilities.writeFile(xqueryFileErrato, "declare namespace sam=\"http://www.prova.org\";\n\t<Result>\n\t{\n\tfor $z in //sam:item\n\torder by $z/id\n\treturn <price>{data($z/price/text())}</price>\n\t}\n\t</Result>\nCodice errato che non significa nulla".getBytes());
        File xqueryFileCodeExtenral = File.createTempFile("testSenzaExternalCode", ".xquery");
        FileSystemUtilities.writeFile(xqueryFileCodeExtenral, XQUERY_WITHOUT_CODE_EXTERNAL.getBytes());
        System.out.println("======== SRC ERRATO ===========");
        try {
            xqueryEngine.evaluate(sourceFileErrato, xqueryFile, true);
            throw new Exception("Attesa eccezione non lanciata");
        }
        catch (XQueryException x) {
            System.out.println("Ricevuta eccezione [" + x.getClass().getName() + "] attesa: " + x.getMessage());
            System.out.println("======== QEURY ERRATA ===========");
            try {
                xqueryEngine.evaluate(sourceFile, xqueryFileErrato, true);
                throw new Exception("Attesa eccezione non lanciata");
            }
            catch (XQueryNotValidException x2) {
                System.out.println("Ricevuta eccezione [" + x2.getClass().getName() + "] attesa: " + x2.getMessage());
                System.out.println("======== QEURY NON TROVA RISULTATI (con xml cmq riempito) ===========");
                System.out.println("STRING:");
                System.out.println(xqueryEngine.evaluate(sourceFileNamespaceDifferente, xqueryFile, true) + "\n");
                System.out.println("FILE:");
                tmp = File.createTempFile("prova", ".tmp");
                xqueryEngine.evaluate(sourceFileNamespaceDifferente, xqueryFile, tmp, true);
                System.out.println(FileSystemUtilities.readFile(tmp) + "\n");
                tmp.delete();
                System.out.println("OUTPUT STREAM:");
                tmp = File.createTempFile("prova", ".tmp");
                fout = new FileOutputStream(tmp);
                xqueryEngine.evaluate(sourceFileNamespaceDifferente, xqueryFile, (OutputStream)fout, true);
                fout.flush();
                fout.close();
                System.out.println(FileSystemUtilities.readFile(tmp) + "\n");
                tmp.delete();
                System.out.println("DOCUMENT:");
                dTmp = xqueryEngine.getXMLUtils().newDocument();
                xqueryEngine.evaluate(sourceFileNamespaceDifferente, xqueryFile, (Node)dTmp, true);
                System.out.println(PrettyPrintXMLUtils.prettyPrintWithTrAX(dTmp, true));
                System.out.println("ELEMENT:");
                dTmp = xqueryEngine.getXMLUtils().newDocument();
                eTmp = dTmp.createElement("prova");
                xqueryEngine.evaluate(sourceFileNamespaceDifferente, xqueryFile, (Node)eTmp, true);
                System.out.println(PrettyPrintXMLUtils.prettyPrintWithTrAX(eTmp, true));
                System.out.println("NODe:");
                dTmp = xqueryEngine.getXMLUtils().newDocument();
                eTmp = dTmp.createElement("prova");
                eTmp.appendChild(dTmp.createElement("provaInterno"));
                nTmp = eTmp.getFirstChild();
                xqueryEngine.evaluate(sourceFileNamespaceDifferente, xqueryFile, nTmp, true);
                System.out.println(PrettyPrintXMLUtils.prettyPrintWithTrAX(nTmp, true));
                System.out.println("======== QEURY NON TROVA RISULTATI (con xml vuoto) ===========");
                try {
                    System.out.println("STRING:");
                    System.out.println(xqueryEngine.evaluate(sourceFileNamespaceDifferente, xqueryFileCodeExtenral, true) + "\n");
                }
                catch (XQueryEvaluateNotFoundException x3) {
                    System.out.println("Ricevuta eccezione [" + x3.getClass().getName() + "] attesa: " + x3.getMessage());
                }
                try {
                    System.out.println("FILE:");
                    tmp = File.createTempFile("prova", ".tmp");
                    xqueryEngine.evaluate(sourceFileNamespaceDifferente, xqueryFileCodeExtenral, tmp, true);
                    System.out.println(FileSystemUtilities.readFile(tmp) + "\n");
                    tmp.delete();
                }
                catch (XQueryEvaluateNotFoundException x4) {
                    System.out.println("Ricevuta eccezione [" + x4.getClass().getName() + "] attesa: " + x4.getMessage());
                }
                try {
                    System.out.println("OUTPUT STREAM:");
                    tmp = File.createTempFile("prova", ".tmp");
                    fout = new FileOutputStream(tmp);
                    xqueryEngine.evaluate(sourceFileNamespaceDifferente, xqueryFileCodeExtenral, (OutputStream)fout, true);
                    fout.flush();
                    fout.close();
                    System.out.println(FileSystemUtilities.readFile(tmp) + "\n");
                    tmp.delete();
                }
                catch (XQueryEvaluateNotFoundException x5) {
                    System.out.println("Ricevuta eccezione [" + x5.getClass().getName() + "] attesa: " + x5.getMessage());
                }
                try {
                    System.out.println("DOCUMENT:");
                    dTmp = xqueryEngine.getXMLUtils().newDocument();
                    xqueryEngine.evaluate(sourceFileNamespaceDifferente, xqueryFileCodeExtenral, (Node)dTmp, true);
                    System.out.println(PrettyPrintXMLUtils.prettyPrintWithTrAX(dTmp, true));
                }
                catch (XQueryEvaluateNotFoundException x6) {
                    System.out.println("Ricevuta eccezione [" + x6.getClass().getName() + "] attesa: " + x6.getMessage());
                }
                try {
                    System.out.println("ELEMENT:");
                    dTmp = xqueryEngine.getXMLUtils().newDocument();
                    eTmp = dTmp.createElement("prova");
                    xqueryEngine.evaluate(sourceFileNamespaceDifferente, xqueryFileCodeExtenral, (Node)eTmp, true);
                    System.out.println(PrettyPrintXMLUtils.prettyPrintWithTrAX(eTmp, true));
                }
                catch (XQueryEvaluateNotFoundException x7) {
                    System.out.println("Ricevuta eccezione [" + x7.getClass().getName() + "] attesa: " + x7.getMessage());
                }
                try {
                    System.out.println("NODe:");
                    dTmp = xqueryEngine.getXMLUtils().newDocument();
                    eTmp = dTmp.createElement("prova");
                    eTmp.appendChild(dTmp.createElement("provaInterno"));
                    nTmp = eTmp.getFirstChild();
                    xqueryEngine.evaluate(sourceFileNamespaceDifferente, xqueryFileCodeExtenral, nTmp, true);
                    System.out.println(PrettyPrintXMLUtils.prettyPrintWithTrAX(nTmp, true));
                }
                catch (XQueryEvaluateNotFoundException x8) {
                    System.out.println("Ricevuta eccezione [" + x8.getClass().getName() + "] attesa: " + x8.getMessage());
                }
                return;
            }
        }
    }
}

