/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.utils.xml;

import it.link.pdd.tools.migrazione_govway.utils.resources.FileSystemUtilities;
import it.link.pdd.tools.migrazione_govway.utils.xml.AbstractXMLUtils;
import it.link.pdd.tools.migrazione_govway.utils.xml.PrettyPrintXMLUtils;
import it.link.pdd.tools.migrazione_govway.utils.xml.XMLException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class SchemaXSD {
    private Element xml;
    private String filename;
    private File source;
    private AbstractXMLUtils xmlUtils;

    public SchemaXSD(Element xml, String filename, File source, AbstractXMLUtils xmlUtils) {
        this.xmlUtils = xmlUtils;
        this.xml = xml;
        this.filename = filename;
        this.source = source;
    }

    public SchemaXSD(byte[] xml, String filename, File source, AbstractXMLUtils xmlUtils) throws IOException, SAXException, ParserConfigurationException, XMLException {
        this.xmlUtils = xmlUtils;
        this.xml = this.xmlUtils.newElement(xml);
        this.filename = filename;
        this.source = source;
    }

    public Element getXml() {
        return this.xml;
    }

    public String getFilename() {
        return this.filename;
    }

    public File getSource() {
        return this.source;
    }

    public String getSourceAbsolutePath() {
        return this.source.getAbsolutePath();
    }

    public boolean compareSource(SchemaXSD definitorio) {
        return this.source.getAbsolutePath().equalsIgnoreCase(definitorio.getSource().getAbsolutePath());
    }

    public boolean compareFilename(SchemaXSD definitorio) {
        return this.filename.equalsIgnoreCase(definitorio.getFilename());
    }

    public void writeTo(File folder) throws ParserConfigurationException, TransformerFactoryConfigurationError, FileNotFoundException, TransformerException, IOException, XMLException {
        this.writeTo(folder, false);
    }

    public void writeTo(File folder, boolean prettyPrint) throws ParserConfigurationException, TransformerFactoryConfigurationError, FileNotFoundException, TransformerException, IOException, XMLException {
        if (this.filename == null) {
            throw new FileNotFoundException("File name non impostato");
        }
        File out = new File(folder.getAbsolutePath() + File.separator + this.getFilename());
        try {
            FileSystemUtilities.mkdirParentDirectory(out);
        }
        catch (Exception e) {
            throw new TransformerException(e.getMessage(), e);
        }
        if (prettyPrint) {
            PrettyPrintXMLUtils.prettyPrintWithTrAX(this.xml, out);
        } else {
            this.xmlUtils.writeTo(this.xml, out);
        }
    }

    public byte[] toByteArray() throws ParserConfigurationException, TransformerFactoryConfigurationError, FileNotFoundException, TransformerException, IOException, XMLException {
        return this.toByteArray(false);
    }

    public byte[] toByteArray(boolean prettyPrint) throws ParserConfigurationException, TransformerFactoryConfigurationError, FileNotFoundException, TransformerException, IOException, XMLException {
        if (prettyPrint) {
            return PrettyPrintXMLUtils.prettyPrintWithTrAX(this.xml).getBytes();
        }
        return this.xmlUtils.toByteArray(this.xml);
    }
}

