/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.utils.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IMarshallingContext;
import org.jibx.runtime.IUnmarshallingContext;
import org.jibx.runtime.JiBXException;

public class JiBXUtils {
    private static Hashtable<String, IBindingFactory> mapBindingFactory = new Hashtable();

    private static synchronized void initBindingFactory(Class<?> classType) throws JiBXException {
        if (!mapBindingFactory.containsKey(classType.getName())) {
            mapBindingFactory.put(classType.getName(), BindingDirectory.getFactory(classType));
        }
    }

    private static IBindingFactory getBindingFactory(Class<?> classType) throws JiBXException {
        if (!mapBindingFactory.containsKey(classType.getName())) {
            JiBXUtils.initBindingFactory(classType);
        }
        return mapBindingFactory.get(classType.getName());
    }

    public static Object xmlToObj(String xmlFileName, Class<?> classType) throws JiBXException, FileNotFoundException {
        IBindingFactory bfact = JiBXUtils.getBindingFactory(classType);
        IUnmarshallingContext uctx = bfact.createUnmarshallingContext();
        FileInputStream fis = new FileInputStream(xmlFileName);
        Object objectRead = null;
        try {
            objectRead = uctx.unmarshalDocument((InputStream)fis, null);
        }
        catch (JiBXException e) {
            throw e;
        }
        finally {
            try {
                fis.close();
            }
            catch (Exception exception) {}
        }
        return objectRead;
    }

    public static void objToXml(String xmlFileName, Class<?> classType, Object object) throws JiBXException, FileNotFoundException {
        JiBXUtils.objToXml(xmlFileName, classType, object, false);
    }

    public static void objToXml(String xmlFileName, Class<?> classType, Object object, boolean prettyDocument) throws JiBXException, FileNotFoundException {
        File file = new File(xmlFileName);
        if (file.exists()) {
            file.delete();
        }
        IBindingFactory bfact = JiBXUtils.getBindingFactory(classType);
        FileOutputStream fileOut = new FileOutputStream(xmlFileName);
        try {
            IMarshallingContext uctx = bfact.createMarshallingContext();
            if (prettyDocument) {
                uctx.setIndent(4);
            } else {
                uctx.setIndent(0);
            }
            uctx.marshalDocument(object, "UTF-8", null, (OutputStream)fileOut);
        }
        catch (JiBXException e) {
            throw e;
        }
        finally {
            try {
                fileOut.close();
            }
            catch (Exception exception) {}
        }
    }

    public static void objToXml(String xmlFileName, byte[] object) throws FileNotFoundException, IOException {
        File file = new File(xmlFileName);
        if (file.exists()) {
            file.delete();
        }
        FileOutputStream fileOut = new FileOutputStream(xmlFileName);
        try {
            fileOut.write(object);
            fileOut.flush();
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            try {
                fileOut.close();
            }
            catch (Exception exception) {}
        }
    }

    public static Object xmlToObj(InputStream i, Class<?> classType) throws JiBXException, FileNotFoundException {
        IBindingFactory bfact = JiBXUtils.getBindingFactory(classType);
        IUnmarshallingContext uctx = bfact.createUnmarshallingContext();
        Object objectRead = null;
        try {
            objectRead = uctx.unmarshalDocument(i, null);
        }
        catch (JiBXException e) {
            throw e;
        }
        finally {
            try {
                i.close();
            }
            catch (Exception exception) {}
        }
        return objectRead;
    }

    public static void objToXml(OutputStream out, Class<?> classType, Object object) throws JiBXException, FileNotFoundException {
        JiBXUtils.objToXml(out, classType, object, false);
    }

    public static void objToXml(OutputStream out, Class<?> classType, Object object, boolean prettyDocument) throws JiBXException, FileNotFoundException {
        IBindingFactory bfact = JiBXUtils.getBindingFactory(classType);
        try {
            IMarshallingContext uctx = bfact.createMarshallingContext();
            if (prettyDocument) {
                uctx.setIndent(4);
            } else {
                uctx.setIndent(0);
            }
            uctx.marshalDocument(object, "UTF-8", null, out);
        }
        catch (JiBXException e) {
            throw e;
        }
        finally {
            try {
                out.close();
            }
            catch (Exception exception) {}
        }
    }
}

