/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.utils.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;

public class JaxbUtils {
    private static Hashtable<String, JAXBContext> mapJAXBContext = new Hashtable();

    private static synchronized void initJAXBContext(String packageName) throws JAXBException {
        if (!mapJAXBContext.containsKey(packageName)) {
            mapJAXBContext.put(packageName, JAXBContext.newInstance((String)packageName));
        }
    }

    private static JAXBContext getJAXBContext(String packageName) throws JAXBException {
        if (!mapJAXBContext.containsKey(packageName)) {
            JaxbUtils.initJAXBContext(packageName);
        }
        return mapJAXBContext.get(packageName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object xmlToObj(String xmlFileName, Class<?> classType) throws FileNotFoundException, JAXBException {
        JAXBContext jc = JaxbUtils.getJAXBContext(classType.getPackage().getName());
        Unmarshaller uctx = jc.createUnmarshaller();
        FileInputStream fis = new FileInputStream(xmlFileName);
        Object objectRead = null;
        try {
            objectRead = uctx.unmarshal((InputStream)fis);
        }
        finally {
            try {
                fis.close();
            }
            catch (Exception exception) {}
        }
        if (objectRead instanceof JAXBElement) {
            return ((JAXBElement)objectRead).getValue();
        }
        return objectRead;
    }

    public static void objToXml(String xmlFileName, Class<?> classType, Object object) throws FileNotFoundException, JAXBException {
        JaxbUtils.objToXml(xmlFileName, classType, object, false);
    }

    public static void objToXml(String xmlFileName, Class<?> classType, Object object, boolean prettyDocument) throws FileNotFoundException, JAXBException {
        File file = new File(xmlFileName);
        if (file.exists()) {
            file.delete();
        }
        JAXBContext jc = JaxbUtils.getJAXBContext(classType.getPackage().getName());
        Marshaller uctx = jc.createMarshaller();
        if (prettyDocument) {
            uctx.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        } else {
            uctx.setProperty("jaxb.formatted.output", (Object)Boolean.FALSE);
        }
        uctx.marshal(object, file);
    }

    public static void objToXml(String xmlFileName, byte[] object) throws FileNotFoundException, IOException {
        File file = new File(xmlFileName);
        if (file.exists()) {
            file.delete();
        }
        FileOutputStream fileOut = new FileOutputStream(xmlFileName);
        try {
            fileOut.write(object);
            fileOut.flush();
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            try {
                fileOut.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object xmlToObj(InputStream i, Class<?> classType) throws FileNotFoundException, JAXBException {
        JAXBContext jc = JaxbUtils.getJAXBContext(classType.getPackage().getName());
        Unmarshaller uctx = jc.createUnmarshaller();
        Object objectRead = null;
        try {
            objectRead = uctx.unmarshal(i);
        }
        finally {
            try {
                i.close();
            }
            catch (Exception exception) {}
        }
        if (objectRead instanceof JAXBElement) {
            return ((JAXBElement)objectRead).getValue();
        }
        return objectRead;
    }

    public static void objToXml(OutputStream out, Class<?> classType, Object object) throws FileNotFoundException, JAXBException {
        JaxbUtils.objToXml(out, classType, object, false);
    }

    public static void objToXml(OutputStream out, Class<?> classType, Object object, boolean prettyDocument) throws FileNotFoundException, JAXBException {
        JaxbUtils.objToXml(out, classType, object, prettyDocument, false);
    }

    public static void objToXml(OutputStream out, Class<?> classType, Object object, boolean prettyDocument, boolean omitXmlDeclaration) throws FileNotFoundException, JAXBException {
        JAXBContext jc = JaxbUtils.getJAXBContext(classType.getPackage().getName());
        Marshaller uctx = jc.createMarshaller();
        if (prettyDocument) {
            uctx.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        } else {
            uctx.setProperty("jaxb.formatted.output", (Object)Boolean.FALSE);
        }
        if (omitXmlDeclaration) {
            uctx.setProperty("jaxb.fragment", (Object)Boolean.TRUE);
        }
        uctx.marshal(object, out);
    }
}

