/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.utils.xml;

import it.link.pdd.tools.migrazione_govway.utils.UtilsException;
import it.link.pdd.tools.migrazione_govway.utils.xml.DynamicNamespaceContext;
import it.link.pdd.tools.migrazione_govway.utils.xml.XMLErrorHandler;
import it.link.pdd.tools.migrazione_govway.utils.xml.XMLErrorListener;
import it.link.pdd.tools.migrazione_govway.utils.xml.XMLException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.validation.SchemaFactory;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class AbstractXMLUtils {
    private DocumentBuilderFactory documentFactory = null;
    private DatatypeFactory datatypeFactory = null;
    private SchemaFactory schemaFactory = null;
    private TransformerFactory transformerFactory = null;
    private XPathFactory xpathFactory = null;
    private GregorianCalendar gregorianCalendar = null;
    private static final String XMLSCHEMA_INSTANCE_NAMESPACE = "http://www.w3.org/2001/XMLSchema-instance";
    private static final String XMLSCHEMA_INSTANCE_LOCAL_NAME_TYPE = "type";

    protected abstract DocumentBuilderFactory newDocumentBuilderFactory() throws XMLException;

    protected abstract DatatypeFactory newDatatypeFactory() throws XMLException;

    protected abstract SchemaFactory newSchemaFactory() throws XMLException;

    protected abstract TransformerFactory newTransformerFactory() throws XMLException;

    protected abstract XPathFactory newXPathFactory() throws XMLException;

    public synchronized void initDocumentBuilderFactory() throws XMLException {
        if (this.documentFactory == null) {
            try {
                this.documentFactory = this.newDocumentBuilderFactory();
            }
            catch (Exception e) {
                throw new XMLException(e.getMessage(), e);
            }
            this.documentFactory.setNamespaceAware(true);
        }
    }

    public synchronized void initDatatypeFactory() throws XMLException {
        if (this.datatypeFactory == null) {
            try {
                this.datatypeFactory = this.newDatatypeFactory();
            }
            catch (Exception e) {
                throw new XMLException(e.getMessage(), e);
            }
        }
    }

    public synchronized void initSchemaFactory() throws XMLException {
        if (this.schemaFactory == null) {
            try {
                this.schemaFactory = this.newSchemaFactory();
            }
            catch (Exception e) {
                throw new XMLException(e.getMessage(), e);
            }
        }
    }

    public synchronized void initTransformerFactory() throws XMLException {
        if (this.transformerFactory == null) {
            this.transformerFactory = this.newTransformerFactory();
        }
    }

    public synchronized void initXPathFactory() throws XMLException {
        if (this.xpathFactory == null) {
            this.xpathFactory = this.newXPathFactory();
        }
    }

    public synchronized void initCalendarConverter() throws XMLException {
        try {
            this.initDatatypeFactory();
            this.gregorianCalendar = (GregorianCalendar)Calendar.getInstance();
        }
        catch (Exception e) {
            throw new XMLException(e.getMessage(), e);
        }
    }

    public DocumentBuilderFactory getDocumentBuilderFactory() throws XMLException {
        if (this.documentFactory == null) {
            this.initDocumentBuilderFactory();
        }
        return this.documentFactory;
    }

    public DatatypeFactory getDatatypeFactory() throws XMLException {
        if (this.datatypeFactory == null) {
            this.initDatatypeFactory();
        }
        return this.datatypeFactory;
    }

    public SchemaFactory getSchemaFactory() throws XMLException {
        if (this.schemaFactory == null) {
            this.initSchemaFactory();
        }
        return this.schemaFactory;
    }

    public TransformerFactory getTransformerFactory() throws XMLException {
        if (this.transformerFactory == null) {
            this.initTransformerFactory();
        }
        return this.transformerFactory;
    }

    public XPathFactory getXPathFactory() throws XMLException {
        if (this.xpathFactory == null) {
            this.initXPathFactory();
        }
        return this.xpathFactory;
    }

    public XMLGregorianCalendar toGregorianCalendar(Date d) throws XMLException {
        if (this.datatypeFactory == null || this.gregorianCalendar == null) {
            this.initCalendarConverter();
        }
        this.gregorianCalendar.setTime(d);
        return this.datatypeFactory.newXMLGregorianCalendar(this.gregorianCalendar);
    }

    public Document getAsDocument(Element element) throws IOException, SAXException, ParserConfigurationException, TransformerException, XMLException {
        return this.newDocument(this.toByteArray(element));
    }

    public Document getAsDocument(Element element, ErrorHandler errorHandler) throws IOException, SAXException, ParserConfigurationException, TransformerException, XMLException {
        return this.newDocument(this.toByteArray(element), errorHandler);
    }

    public Document getAsDocument(Element element, EntityResolver entityResolver) throws IOException, SAXException, ParserConfigurationException, TransformerException, XMLException {
        return this.newDocument(this.toByteArray(element), entityResolver);
    }

    public Document getAsDocument(Element element, ErrorHandler errorHandler, EntityResolver entityResolver) throws IOException, SAXException, ParserConfigurationException, TransformerException, XMLException {
        return this.newDocument(this.toByteArray(element), errorHandler, entityResolver);
    }

    public Document getAsDocument(Node Node2) throws IOException, SAXException, ParserConfigurationException, TransformerException, XMLException {
        return this.newDocument(this.toByteArray(Node2));
    }

    public Document getAsDocument(Node Node2, ErrorHandler errorHandler) throws IOException, SAXException, ParserConfigurationException, TransformerException, XMLException {
        return this.newDocument(this.toByteArray(Node2), errorHandler);
    }

    public Document getAsDocument(Node Node2, EntityResolver entityResolver) throws IOException, SAXException, ParserConfigurationException, TransformerException, XMLException {
        return this.newDocument(this.toByteArray(Node2), entityResolver);
    }

    public Document getAsDocument(Node Node2, ErrorHandler errorHandler, EntityResolver entityResolver) throws IOException, SAXException, ParserConfigurationException, TransformerException, XMLException {
        return this.newDocument(this.toByteArray(Node2), errorHandler, entityResolver);
    }

    public Document newDocument() throws IOException, SAXException, ParserConfigurationException, XMLException {
        return this.newDocument_engine(new XMLErrorHandler(), null);
    }

    public Document newDocument(ErrorHandler errorHandler) throws IOException, SAXException, ParserConfigurationException, XMLException {
        return this.newDocument_engine(errorHandler, null);
    }

    public Document newDocument(EntityResolver entityResolver) throws IOException, SAXException, ParserConfigurationException, XMLException {
        return this.newDocument_engine(new XMLErrorHandler(), entityResolver);
    }

    public Document newDocument(ErrorHandler errorHandler, EntityResolver entityResolver) throws IOException, SAXException, ParserConfigurationException, XMLException {
        return this.newDocument_engine(errorHandler, entityResolver);
    }

    private Document newDocument_engine(ErrorHandler errorHandler, EntityResolver entityResolver) throws IOException, SAXException, ParserConfigurationException, XMLException {
        DocumentBuilder documentBuilder = this.getDocumentBuilderFactory().newDocumentBuilder();
        documentBuilder.setErrorHandler(errorHandler);
        if (entityResolver != null) {
            documentBuilder.setEntityResolver(entityResolver);
        }
        return documentBuilder.newDocument();
    }

    public Document newDocument(byte[] xml) throws IOException, SAXException, ParserConfigurationException, XMLException {
        return this.newDocument(xml, (ErrorHandler)new XMLErrorHandler(), null);
    }

    public Document newDocument(byte[] xml, ErrorHandler errorHandler) throws IOException, SAXException, ParserConfigurationException, XMLException {
        return this.newDocument(xml, errorHandler, null);
    }

    public Document newDocument(byte[] xml, EntityResolver entityResolver) throws IOException, SAXException, ParserConfigurationException, XMLException {
        return this.newDocument(xml, (ErrorHandler)new XMLErrorHandler(), entityResolver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document newDocument(byte[] xml, ErrorHandler errorHandler, EntityResolver entityResolver) throws IOException, SAXException, ParserConfigurationException, XMLException {
        ByteArrayInputStream bin = null;
        try {
            bin = new ByteArrayInputStream(xml);
            Document document = this.newDocument(bin, errorHandler, entityResolver);
            return document;
        }
        finally {
            if (bin != null) {
                try {
                    bin.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public Document newDocument(InputStream is) throws IOException, SAXException, ParserConfigurationException, XMLException {
        return this.newDocument(is, (ErrorHandler)new XMLErrorHandler(), null);
    }

    public Document newDocument(InputStream is, ErrorHandler errorHandler) throws IOException, SAXException, ParserConfigurationException, XMLException {
        return this.newDocument(is, errorHandler, null);
    }

    public Document newDocument(InputStream is, EntityResolver entityResolver) throws IOException, SAXException, ParserConfigurationException, XMLException {
        return this.newDocument(is, (ErrorHandler)new XMLErrorHandler(), entityResolver);
    }

    public Document newDocument(InputStream is, ErrorHandler errorHandler, EntityResolver entityResolver) throws IOException, SAXException, ParserConfigurationException, XMLException {
        DocumentBuilder documentBuilder = this.getDocumentBuilderFactory().newDocumentBuilder();
        documentBuilder.setErrorHandler(errorHandler);
        if (entityResolver != null) {
            documentBuilder.setEntityResolver(entityResolver);
        }
        return documentBuilder.parse(is);
    }

    public Document newDocument(File f) throws IOException, SAXException, ParserConfigurationException, XMLException {
        return this.newDocument(f, (ErrorHandler)new XMLErrorHandler(), null);
    }

    public Document newDocument(File f, ErrorHandler errorHandler) throws IOException, SAXException, ParserConfigurationException, XMLException {
        return this.newDocument(f, errorHandler, null);
    }

    public Document newDocument(File f, EntityResolver entityResolver) throws IOException, SAXException, ParserConfigurationException, XMLException {
        return this.newDocument(f, (ErrorHandler)new XMLErrorHandler(), entityResolver);
    }

    public Document newDocument(File f, ErrorHandler errorHandler, EntityResolver entityResolver) throws IOException, SAXException, ParserConfigurationException, XMLException {
        DocumentBuilder documentBuilder = this.getDocumentBuilderFactory().newDocumentBuilder();
        documentBuilder.setErrorHandler(errorHandler);
        if (entityResolver != null) {
            documentBuilder.setEntityResolver(entityResolver);
        }
        return documentBuilder.parse(f);
    }

    public Document newDocument(InputSource is) throws IOException, SAXException, ParserConfigurationException, XMLException {
        return this.newDocument(is, (ErrorHandler)new XMLErrorHandler(), null);
    }

    public Document newDocument(InputSource is, ErrorHandler errorHandler) throws IOException, SAXException, ParserConfigurationException, XMLException {
        return this.newDocument(is, errorHandler, null);
    }

    public Document newDocument(InputSource is, EntityResolver entityResolver) throws IOException, SAXException, ParserConfigurationException, XMLException {
        return this.newDocument(is, (ErrorHandler)new XMLErrorHandler(), entityResolver);
    }

    public Document newDocument(InputSource is, ErrorHandler errorHandler, EntityResolver entityResolver) throws IOException, SAXException, ParserConfigurationException, XMLException {
        DocumentBuilder documentBuilder = this.getDocumentBuilderFactory().newDocumentBuilder();
        documentBuilder.setErrorHandler(errorHandler);
        if (entityResolver != null) {
            documentBuilder.setEntityResolver(entityResolver);
        }
        return documentBuilder.parse(is);
    }

    public Element newElement() throws IOException, SAXException, ParserConfigurationException, XMLException {
        return this.newElement_engine(new XMLErrorHandler(), null);
    }

    public Element newElement(ErrorHandler errorHandler) throws IOException, SAXException, ParserConfigurationException, XMLException {
        return this.newElement_engine(errorHandler, null);
    }

    public Element newElement(EntityResolver entityResolver) throws IOException, SAXException, ParserConfigurationException, XMLException {
        return this.newElement_engine(new XMLErrorHandler(), entityResolver);
    }

    public Element newElement(ErrorHandler errorHandler, EntityResolver entityResolver) throws IOException, SAXException, ParserConfigurationException, XMLException {
        return this.newElement_engine(errorHandler, entityResolver);
    }

    private Element newElement_engine(ErrorHandler errorHandler, EntityResolver entityResolver) throws IOException, SAXException, ParserConfigurationException, XMLException {
        DocumentBuilder documentBuilder = this.getDocumentBuilderFactory().newDocumentBuilder();
        documentBuilder.setErrorHandler(errorHandler);
        if (entityResolver != null) {
            documentBuilder.setEntityResolver(entityResolver);
        }
        return documentBuilder.newDocument().getDocumentElement();
    }

    public Element newElement(byte[] xml) throws IOException, SAXException, ParserConfigurationException, XMLException {
        return this.newDocument(xml).getDocumentElement();
    }

    public Element newElement(byte[] xml, ErrorHandler errorHandler) throws IOException, SAXException, ParserConfigurationException, XMLException {
        return this.newDocument(xml, errorHandler).getDocumentElement();
    }

    public Element newElement(byte[] xml, EntityResolver entityResolver) throws IOException, SAXException, ParserConfigurationException, XMLException {
        return this.newDocument(xml, entityResolver).getDocumentElement();
    }

    public Element newElement(byte[] xml, ErrorHandler errorHandler, EntityResolver entityResolver) throws IOException, SAXException, ParserConfigurationException, XMLException {
        return this.newDocument(xml, errorHandler, entityResolver).getDocumentElement();
    }

    public Element newElement(InputStream is) throws IOException, SAXException, ParserConfigurationException, XMLException {
        return this.newDocument(is).getDocumentElement();
    }

    public Element newElement(InputStream is, ErrorHandler errorHandler) throws IOException, SAXException, ParserConfigurationException, XMLException {
        return this.newDocument(is, errorHandler).getDocumentElement();
    }

    public Element newElement(InputStream is, EntityResolver entityResolver) throws IOException, SAXException, ParserConfigurationException, XMLException {
        return this.newDocument(is, entityResolver).getDocumentElement();
    }

    public Element newElement(InputStream is, ErrorHandler errorHandler, EntityResolver entityResolver) throws IOException, SAXException, ParserConfigurationException, XMLException {
        return this.newDocument(is, errorHandler, entityResolver).getDocumentElement();
    }

    public Element newElement(File f) throws IOException, SAXException, ParserConfigurationException, XMLException {
        return this.newDocument(f).getDocumentElement();
    }

    public Element newElement(File f, ErrorHandler errorHandler) throws IOException, SAXException, ParserConfigurationException, XMLException {
        return this.newDocument(f, errorHandler).getDocumentElement();
    }

    public Element newElement(File f, EntityResolver entityResolver) throws IOException, SAXException, ParserConfigurationException, XMLException {
        return this.newDocument(f, entityResolver).getDocumentElement();
    }

    public Element newElement(File f, ErrorHandler errorHandler, EntityResolver entityResolver) throws IOException, SAXException, ParserConfigurationException, XMLException {
        return this.newDocument(f, errorHandler, entityResolver).getDocumentElement();
    }

    public Element newElement(InputSource is) throws IOException, SAXException, ParserConfigurationException, XMLException {
        return this.newDocument(is).getDocumentElement();
    }

    public Element newElement(InputSource is, ErrorHandler errorHandler) throws IOException, SAXException, ParserConfigurationException, XMLException {
        return this.newDocument(is, errorHandler).getDocumentElement();
    }

    public Element newElement(InputSource is, EntityResolver entityResolver) throws IOException, SAXException, ParserConfigurationException, XMLException {
        return this.newDocument(is, entityResolver).getDocumentElement();
    }

    public Element newElement(InputSource is, ErrorHandler errorHandler, EntityResolver entityResolver) throws IOException, SAXException, ParserConfigurationException, XMLException {
        return this.newDocument(is, errorHandler, entityResolver).getDocumentElement();
    }

    public byte[] toByteArray(Document doc) throws TransformerException, IOException, XMLException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        this.writeTo(doc, (OutputStream)bout);
        bout.close();
        return bout.toByteArray();
    }

    public byte[] toByteArray(Document doc, boolean omitXMLDeclaration) throws TransformerException, IOException, XMLException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        this.writeTo(doc, (OutputStream)bout, omitXMLDeclaration);
        bout.close();
        return bout.toByteArray();
    }

    public byte[] toByteArray(Element element) throws TransformerException, IOException, XMLException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        this.writeTo(element, (OutputStream)bout);
        bout.close();
        return bout.toByteArray();
    }

    public byte[] toByteArray(Element element, boolean omitXMLDeclaration) throws TransformerException, IOException, XMLException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        this.writeTo(element, (OutputStream)bout, omitXMLDeclaration);
        bout.close();
        return bout.toByteArray();
    }

    public byte[] toByteArray(Node node) throws TransformerException, IOException, XMLException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        this.writeTo(node, (OutputStream)bout);
        bout.close();
        return bout.toByteArray();
    }

    public byte[] toByteArray(Node node, boolean omitXMLDeclaration) throws TransformerException, IOException, XMLException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        this.writeTo(node, (OutputStream)bout, omitXMLDeclaration);
        bout.close();
        return bout.toByteArray();
    }

    public String toString(Document doc) throws TransformerException, IOException, XMLException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        this.writeTo(doc, (OutputStream)bout);
        bout.close();
        return bout.toString();
    }

    public String toString(Document doc, boolean omitXMLDeclaration) throws TransformerException, IOException, XMLException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        this.writeTo(doc, (OutputStream)bout, omitXMLDeclaration);
        bout.close();
        return bout.toString();
    }

    public String toString(Element element) throws TransformerException, IOException, XMLException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        this.writeTo(element, (OutputStream)bout);
        bout.close();
        return bout.toString();
    }

    public String toString(Element element, boolean omitXMLDeclaration) throws TransformerException, IOException, XMLException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        this.writeTo(element, (OutputStream)bout, omitXMLDeclaration);
        bout.close();
        return bout.toString();
    }

    public String toString(Node node) throws TransformerException, IOException, XMLException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        this.writeTo(node, (OutputStream)bout);
        bout.close();
        return bout.toString();
    }

    public String toString(Node node, boolean omitXMLDeclaration) throws TransformerException, IOException, XMLException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        this.writeTo(node, (OutputStream)bout, omitXMLDeclaration);
        bout.close();
        return bout.toString();
    }

    public void writeTo(Document doc, OutputStream os) throws TransformerException, IOException, XMLException {
        this.writeNodeTo((Node)doc, os, (ErrorListener)new XMLErrorListener(), false);
    }

    public void writeTo(Document doc, OutputStream os, ErrorListener errorListener) throws TransformerException, IOException, XMLException {
        this.writeNodeTo((Node)doc, os, errorListener, false);
    }

    public void writeTo(Document doc, OutputStream os, boolean omitXMLDeclaration) throws TransformerException, IOException, XMLException {
        this.writeNodeTo((Node)doc, os, (ErrorListener)new XMLErrorListener(), omitXMLDeclaration);
    }

    public void writeTo(Document doc, OutputStream os, ErrorListener errorListener, boolean omitXMLDeclaration) throws TransformerException, IOException, XMLException {
        this.writeNodeTo((Node)doc, os, errorListener, omitXMLDeclaration);
    }

    public void writeTo(Document doc, Writer writer) throws TransformerException, IOException, XMLException {
        this.writeNodeTo((Node)doc, writer, (ErrorListener)new XMLErrorListener(), false);
    }

    public void writeTo(Document doc, Writer writer, ErrorListener errorListener) throws TransformerException, IOException, XMLException {
        this.writeNodeTo((Node)doc, writer, errorListener, false);
    }

    public void writeTo(Document doc, Writer writer, boolean omitXMLDeclaration) throws TransformerException, IOException, XMLException {
        this.writeNodeTo((Node)doc, writer, (ErrorListener)new XMLErrorListener(), omitXMLDeclaration);
    }

    public void writeTo(Document doc, Writer writer, ErrorListener errorListener, boolean omitXMLDeclaration) throws TransformerException, IOException, XMLException {
        this.writeNodeTo((Node)doc, writer, errorListener, omitXMLDeclaration);
    }

    public void writeTo(Document doc, File file) throws TransformerException, IOException, XMLException {
        this.writeNodeTo((Node)doc, file, (ErrorListener)new XMLErrorListener(), false);
    }

    public void writeTo(Document doc, File file, ErrorListener errorListener) throws TransformerException, IOException, XMLException {
        this.writeNodeTo((Node)doc, file, errorListener, false);
    }

    public void writeTo(Document doc, File file, boolean omitXMLDeclaration) throws TransformerException, IOException, XMLException {
        this.writeNodeTo((Node)doc, file, (ErrorListener)new XMLErrorListener(), omitXMLDeclaration);
    }

    public void writeTo(Document doc, File file, ErrorListener errorListener, boolean omitXMLDeclaration) throws TransformerException, IOException, XMLException {
        this.writeNodeTo((Node)doc, file, errorListener, omitXMLDeclaration);
    }

    public void writeTo(Element element, OutputStream os) throws TransformerException, IOException, XMLException {
        this.writeNodeTo((Node)element, os, (ErrorListener)new XMLErrorListener(), false);
    }

    public void writeTo(Element element, OutputStream os, ErrorListener errorListener) throws TransformerException, IOException, XMLException {
        this.writeNodeTo((Node)element, os, errorListener, false);
    }

    public void writeTo(Element element, OutputStream os, boolean omitXMLDeclaration) throws TransformerException, IOException, XMLException {
        this.writeNodeTo((Node)element, os, (ErrorListener)new XMLErrorListener(), omitXMLDeclaration);
    }

    public void writeTo(Element element, OutputStream os, ErrorListener errorListener, boolean omitXMLDeclaration) throws TransformerException, IOException, XMLException {
        this.writeNodeTo((Node)element, os, errorListener, omitXMLDeclaration);
    }

    public void writeTo(Element element, Writer writer) throws TransformerException, IOException, XMLException {
        this.writeNodeTo((Node)element, writer, (ErrorListener)new XMLErrorListener(), false);
    }

    public void writeTo(Element element, Writer writer, ErrorListener errorListener) throws TransformerException, IOException, XMLException {
        this.writeNodeTo((Node)element, writer, errorListener, false);
    }

    public void writeTo(Element element, Writer writer, boolean omitXMLDeclaration) throws TransformerException, IOException, XMLException {
        this.writeNodeTo((Node)element, writer, (ErrorListener)new XMLErrorListener(), omitXMLDeclaration);
    }

    public void writeTo(Element element, Writer writer, ErrorListener errorListener, boolean omitXMLDeclaration) throws TransformerException, IOException, XMLException {
        this.writeNodeTo((Node)element, writer, errorListener, omitXMLDeclaration);
    }

    public void writeTo(Element element, File file) throws TransformerException, IOException, XMLException {
        this.writeNodeTo((Node)element, file, (ErrorListener)new XMLErrorListener(), false);
    }

    public void writeTo(Element element, File file, ErrorListener errorListener) throws TransformerException, IOException, XMLException {
        this.writeNodeTo((Node)element, file, errorListener, false);
    }

    public void writeTo(Element element, File file, boolean omitXMLDeclaration) throws TransformerException, IOException, XMLException {
        this.writeNodeTo((Node)element, file, (ErrorListener)new XMLErrorListener(), omitXMLDeclaration);
    }

    public void writeTo(Element element, File file, ErrorListener errorListener, boolean omitXMLDeclaration) throws TransformerException, IOException, XMLException {
        this.writeNodeTo((Node)element, file, errorListener, omitXMLDeclaration);
    }

    public void writeTo(Node node, OutputStream os) throws TransformerException, IOException, XMLException {
        this.writeNodeTo(node, os, (ErrorListener)new XMLErrorListener(), false);
    }

    public void writeTo(Node node, OutputStream os, ErrorListener errorListener) throws TransformerException, IOException, XMLException {
        this.writeNodeTo(node, os, errorListener, false);
    }

    public void writeTo(Node node, OutputStream os, boolean omitXMLDeclaration) throws TransformerException, IOException, XMLException {
        this.writeNodeTo(node, os, (ErrorListener)new XMLErrorListener(), omitXMLDeclaration);
    }

    public void writeTo(Node node, OutputStream os, ErrorListener errorListener, boolean omitXMLDeclaration) throws TransformerException, IOException, XMLException {
        this.writeNodeTo(node, os, errorListener, omitXMLDeclaration);
    }

    public void writeTo(Node node, Writer writer) throws TransformerException, IOException, XMLException {
        this.writeNodeTo(node, writer, (ErrorListener)new XMLErrorListener(), false);
    }

    public void writeTo(Node node, Writer writer, ErrorListener errorListener) throws TransformerException, IOException, XMLException {
        this.writeNodeTo(node, writer, errorListener, false);
    }

    public void writeTo(Node node, Writer writer, boolean omitXMLDeclaration) throws TransformerException, IOException, XMLException {
        this.writeNodeTo(node, writer, (ErrorListener)new XMLErrorListener(), omitXMLDeclaration);
    }

    public void writeTo(Node node, Writer writer, ErrorListener errorListener, boolean omitXMLDeclaration) throws TransformerException, IOException, XMLException {
        this.writeNodeTo(node, writer, errorListener, omitXMLDeclaration);
    }

    public void writeTo(Node node, File file) throws TransformerException, IOException, XMLException {
        this.writeNodeTo(node, file, (ErrorListener)new XMLErrorListener(), false);
    }

    public void writeTo(Node node, File file, ErrorListener errorListener) throws TransformerException, IOException, XMLException {
        this.writeNodeTo(node, file, errorListener, false);
    }

    public void writeTo(Node node, File file, boolean omitXMLDeclaration) throws TransformerException, IOException, XMLException {
        this.writeNodeTo(node, file, (ErrorListener)new XMLErrorListener(), omitXMLDeclaration);
    }

    public void writeTo(Node node, File file, ErrorListener errorListener, boolean omitXMLDeclaration) throws TransformerException, IOException, XMLException {
        this.writeNodeTo(node, file, errorListener, omitXMLDeclaration);
    }

    private void writeNodeTo(Node node, OutputStream os, ErrorListener errorListener, boolean omitXMLDeclaration) throws TransformerException, IOException, XMLException, XMLException {
        DOMSource source = new DOMSource(node);
        StreamResult result = new StreamResult(os);
        Transformer transformer = this.getTransformerFactory().newTransformer();
        if (omitXMLDeclaration) {
            transformer.setOutputProperty("omit-xml-declaration", "yes");
        }
        transformer.setErrorListener(errorListener);
        transformer.transform(source, result);
        os.flush();
    }

    private void writeNodeTo(Node node, Writer writer, ErrorListener errorListener, boolean omitXMLDeclaration) throws TransformerException, IOException, XMLException {
        DOMSource source = new DOMSource(node);
        StreamResult result = new StreamResult(writer);
        Transformer transformer = this.getTransformerFactory().newTransformer();
        if (omitXMLDeclaration) {
            transformer.setOutputProperty("omit-xml-declaration", "yes");
        }
        transformer.setErrorListener(errorListener);
        transformer.transform(source, result);
        writer.flush();
    }

    private void writeNodeTo(Node node, File file, ErrorListener errorListener, boolean omitXMLDeclaration) throws TransformerException, IOException, XMLException {
        DOMSource source = new DOMSource(node);
        StreamResult result = new StreamResult(file);
        Transformer transformer = this.getTransformerFactory().newTransformer();
        if (omitXMLDeclaration) {
            transformer.setOutputProperty("omit-xml-declaration", "yes");
        }
        transformer.setErrorListener(errorListener);
        transformer.transform(source, result);
    }

    @Deprecated
    public byte[] eraserXML(byte[] xml) {
        return this.eraserXML(new String(xml)).getBytes();
    }

    @Deprecated
    public String eraserXML(String xml) {
        String tmp = xml.trim();
        if (tmp.startsWith("<?xml")) {
            int indexOf = tmp.indexOf(">");
            return tmp.substring(indexOf + 1);
        }
        return xml;
    }

    @Deprecated
    public byte[] eraserXsiType(byte[] xml) throws UtilsException {
        ByteArrayOutputStream cleanXML = null;
        try {
            String eraserString = " xsi:type=\"xsd:string\"";
            cleanXML = new ByteArrayOutputStream();
            int i = 0;
            while (i < xml.length) {
                if (xml[i] == 32) {
                    if (i + eraserString.length() < xml.length) {
                        StringBuffer test = new StringBuffer();
                        for (int k = 0; k < eraserString.length(); ++k) {
                            test.append((char)xml[i + k]);
                        }
                        if (test.toString().equals(eraserString)) {
                            i += eraserString.length();
                            continue;
                        }
                    }
                    cleanXML.write(xml[i]);
                    ++i;
                    continue;
                }
                cleanXML.write(xml[i]);
                ++i;
            }
            byte[] risultato = cleanXML.toByteArray();
            cleanXML.close();
            return risultato;
        }
        catch (Exception e) {
            try {
                if (cleanXML != null) {
                    cleanXML.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new UtilsException("Utilities.eraserType error " + e.getMessage(), e);
        }
    }

    public boolean isDocument(byte[] xml) {
        try {
            return this.newDocument(xml) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isElement(byte[] xml) {
        try {
            return this.newElement(xml) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public String getAttributeValue(Node n, String attrName) {
        Node nA;
        NamedNodeMap att = n.getAttributes();
        if (att != null && (nA = att.getNamedItem(attrName)) != null) {
            return nA.getNodeValue();
        }
        return null;
    }

    public void removeAttribute(Attr attr, Element src) {
        if ("http://www.w3.org/2000/xmlns/".equals(attr.getNamespaceURI())) {
            if ("xmlns".equals(attr.getName())) {
                if (attr.getClass().getName().contains("org.apache.axiom.")) {
                    src.removeAttributeNS(attr.getNamespaceURI(), "");
                } else {
                    src.removeAttributeNS(attr.getNamespaceURI(), attr.getName());
                }
            } else if (attr.getNamespaceURI() != null) {
                src.removeAttributeNS(attr.getNamespaceURI(), attr.getLocalName());
            }
        } else {
            src.removeAttribute(attr.getName());
        }
    }

    public void addAttribute(Attr attr, Element src) {
        if ("http://www.w3.org/2000/xmlns/".equals(attr.getNamespaceURI())) {
            if ("xmlns".equals(attr.getLocalName())) {
                src.setAttribute(attr.getName(), attr.getValue());
            } else {
                src.setAttributeNS(attr.getNamespaceURI(), attr.getName(), attr.getValue());
            }
        } else {
            src.setAttribute(attr.getName(), attr.getValue());
        }
    }

    public Hashtable<String, String> getNamespaceDeclaration(Node n) {
        NamedNodeMap map = n.getAttributes();
        Hashtable<String, String> namespaces = new Hashtable<String, String>();
        if (map != null) {
            for (int i = 0; i < map.getLength(); ++i) {
                Attr a;
                String prefix;
                Node attribute = map.item(i);
                if (attribute == null || !(attribute instanceof Attr) || (prefix = (a = (Attr)attribute).getName()) == null || !prefix.startsWith("xmlns") && !prefix.equals("xmlns")) continue;
                prefix = prefix.contains(":") ? prefix.split(":")[1] : "";
                namespaces.put(prefix, a.getValue());
            }
        }
        return namespaces;
    }

    public String findNamespaceByPrefix(String prefix, Node node) {
        return this.findNamespaceByPrefix(prefix, node, node);
    }

    public String findNamespaceByPrefix(String prefix, Node node, Node parentNode) {
        if (node == null) {
            return null;
        }
        NamedNodeMap nn = node.getAttributes();
        if (nn != null && nn.getLength() > 0) {
            for (int k = 0; k < nn.getLength(); ++k) {
                Node nAttr = nn.item(k);
                if (!(nAttr instanceof Attr)) continue;
                Attr attr = (Attr)nAttr;
                String prefixAttr = attr.getName();
                if (prefixAttr != null && (prefixAttr.startsWith("xmlns") || prefix.equals("prefixAttr"))) {
                    prefixAttr = prefixAttr.contains(":") ? prefixAttr.split(":")[1] : "";
                }
                if (!prefix.equals(prefixAttr)) continue;
                return attr.getValue();
            }
        }
        if (node.isSameNode(parentNode)) {
            return null;
        }
        Node p = node.getParentNode();
        if (p == null) {
            return null;
        }
        return this.findNamespaceByPrefix(prefix, p, parentNode);
    }

    public void addNamespaceDeclaration(Hashtable<String, String> namespace, Element destNode) {
        if (namespace != null && namespace.size() > 0) {
            Hashtable<String, String> declarationNamespacesDestNode = this.getNamespaceDeclaration(destNode);
            Enumeration<String> decSource = namespace.keys();
            while (decSource.hasMoreElements()) {
                String dec = decSource.nextElement();
                if (declarationNamespacesDestNode.containsKey(dec)) continue;
                Object name = "xmlns:" + dec;
                if ("".equals(dec)) {
                    name = "xmlns";
                }
                destNode.setAttributeNS("http://www.w3.org/2000/xmlns/", (String)name, namespace.get(dec));
            }
        }
    }

    public void removeNamespaceDeclaration(Hashtable<String, String> namespace, Element destNode) {
        if (namespace != null && namespace.size() > 0) {
            Enumeration<String> decSource = namespace.keys();
            while (decSource.hasMoreElements()) {
                String dec = decSource.nextElement();
                Object name = "xmlns:" + dec;
                if ("".equals(dec)) {
                    name = "xmlns";
                }
                destNode.removeAttributeNS("http://www.w3.org/2000/xmlns/", (String)name);
            }
        }
    }

    public void addNamespaceXSITypeIfNotExists(Node node, DynamicNamespaceContext dnc, boolean deep) {
        this.addNamespaceXSITypeIfNotExists(node, dnc, deep, node);
    }

    private void addNamespaceXSITypeIfNotExists(Node node, DynamicNamespaceContext dnc, boolean deep, Node parentNode) {
        Vector<Node> childList;
        Element element;
        NamedNodeMap nn;
        if (node == null) {
            return;
        }
        if (node instanceof Element && (nn = (element = (Element)node).getAttributes()) != null && nn.getLength() > 0) {
            String prefix;
            ArrayList<String> prefixXSIType = new ArrayList<String>();
            for (int k = 0; k < nn.getLength(); ++k) {
                Attr attr;
                Node nAttr = nn.item(k);
                if (!(nAttr instanceof Attr) || !XMLSCHEMA_INSTANCE_NAMESPACE.equals((attr = (Attr)nAttr).getNamespaceURI())) continue;
                prefix = attr.getPrefix();
                Object nameAtteso = prefix + ":type";
                if (prefix == null || "".equals(prefix)) {
                    nameAtteso = XMLSCHEMA_INSTANCE_LOCAL_NAME_TYPE;
                }
                if (!((String)nameAtteso).equals(attr.getName()) || attr.getValue() == null || !attr.getValue().contains(":")) continue;
                prefixXSIType.add(attr.getValue());
            }
            if (prefixXSIType.size() > 0) {
                for (String prefixValue : prefixXSIType) {
                    String namespaceEsistente;
                    boolean foundNamespace;
                    String[] tmp = prefixValue.split(":");
                    if (tmp == null || tmp.length != 2 || (foundNamespace = (namespaceEsistente = this.findNamespaceByPrefix(prefix = tmp[0], element, parentNode)) != null)) continue;
                    String namespace = dnc.getNamespaceURI(prefix);
                    element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + prefix, namespace);
                }
            }
        }
        if (deep && (childList = this.getNotEmptyChildNodes(node, false)) != null && childList.size() > 0) {
            for (Node child : childList) {
                this.addNamespaceXSITypeIfNotExists(child, dnc, deep, parentNode);
            }
        }
    }

    public Vector<Node> getNotEmptyChildNodes(Node e) {
        return this.getNotEmptyChildNodes(e, true);
    }

    public Vector<Node> getNotEmptyChildNodes(Node e, boolean consideraTextNotEmptyAsNode) {
        NodeList nl = e.getChildNodes();
        Vector<Node> vec = new Vector<Node>();
        if (nl != null) {
            for (int index = 0; index < nl.getLength(); ++index) {
                Node n = nl.item(index);
                if (n instanceof Text ? !consideraTextNotEmptyAsNode || ((Text)nl.item(index)).getData().trim().length() == 0 : n instanceof Comment) continue;
                vec.add(nl.item(index));
            }
        }
        return vec;
    }

    public Node getFirstNotEmptyChildNode(Node e) {
        return this.getFirstNotEmptyChildNode(e, true);
    }

    public Node getFirstNotEmptyChildNode(Node e, boolean consideraTextNotEmptyAsNode) {
        NodeList nl = e.getChildNodes();
        if (nl != null) {
            for (int index = 0; index < nl.getLength(); ++index) {
                Node n = nl.item(index);
                if (n instanceof Text ? !consideraTextNotEmptyAsNode || ((Text)nl.item(index)).getData().trim().length() == 0 : nl.item(index) instanceof Comment) continue;
                return nl.item(index);
            }
        }
        return null;
    }
}

