/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.utils.xml;

import it.link.pdd.tools.migrazione_govway.utils.LoggerWrapperFactory;
import it.link.pdd.tools.migrazione_govway.utils.xml.AbstractXMLUtils;
import it.link.pdd.tools.migrazione_govway.utils.xml.XMLDiffImplType;
import it.link.pdd.tools.migrazione_govway.utils.xml.XMLDiffOptions;
import it.link.pdd.tools.migrazione_govway.utils.xml.XMLException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.io.input.ReaderInputStream;
import org.custommonkey.xmlunit.DetailedDiff;
import org.custommonkey.xmlunit.Difference;
import org.custommonkey.xmlunit.XMLUnit;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public abstract class AbstractXMLDiff {
    private static Logger logger = LoggerWrapperFactory.getLogger(AbstractXMLDiff.class);
    private static XMLDiffOptions xmlDiffOptions = new XMLDiffOptions();
    private static XMLDiffImplType implType = XMLDiffImplType.XML_UNIT;
    private static DocumentBuilderFactory dbf_org_w3c_dom_document_impl = null;
    private static boolean initialized = false;
    private String difference;

    public static void setLogger(Logger logger) {
        AbstractXMLDiff.logger = logger;
    }

    public static XMLDiffImplType getImplType() {
        return implType;
    }

    public static void setImplType(XMLDiffImplType implType) {
        AbstractXMLDiff.implType = implType;
    }

    public static XMLDiffOptions getXmlDiffOptions() {
        return xmlDiffOptions;
    }

    public static void setXmlDiffOptions(XMLDiffOptions xmlDiffOptions) {
        AbstractXMLDiff.xmlDiffOptions = xmlDiffOptions;
    }

    private static synchronized void initialize(AbstractXMLUtils instance) throws XMLException {
        if (!initialized) {
            dbf_org_w3c_dom_document_impl = instance.newDocumentBuilderFactory();
            dbf_org_w3c_dom_document_impl.setNamespaceAware(true);
            dbf_org_w3c_dom_document_impl.setCoalescing(xmlDiffOptions.isIgnoreDiffBetweenTextAndCDATA());
            dbf_org_w3c_dom_document_impl.setIgnoringElementContentWhitespace(xmlDiffOptions.isIgnoreWhitespace());
            dbf_org_w3c_dom_document_impl.setIgnoringComments(xmlDiffOptions.isIgnoreComments());
            if (XMLDiffImplType.XML_UNIT.equals((Object)implType)) {
                XMLUnit.setIgnoreAttributeOrder((boolean)true);
                XMLUnit.setExpandEntityReferences((boolean)true);
                XMLUnit.setIgnoreComments((boolean)xmlDiffOptions.isIgnoreComments());
                XMLUnit.setIgnoreDiffBetweenTextAndCDATA((boolean)xmlDiffOptions.isIgnoreDiffBetweenTextAndCDATA());
                XMLUnit.setIgnoreWhitespace((boolean)xmlDiffOptions.isIgnoreWhitespace());
                XMLUnit.setNormalize((boolean)xmlDiffOptions.isNormalize());
                XMLUnit.setNormalizeWhitespace((boolean)xmlDiffOptions.isNormalize());
            }
            initialized = true;
        }
    }

    private static synchronized void _initialize(XMLDiffImplType implType, XMLDiffOptions xmlDiffOptions, AbstractXMLUtils instance) throws XMLException {
        AbstractXMLDiff.implType = implType;
        AbstractXMLDiff.xmlDiffOptions = xmlDiffOptions;
        AbstractXMLDiff.initialize(instance);
    }

    public void initialize(XMLDiffImplType implType, XMLDiffOptions xmlDiffOptions) throws XMLException {
        AbstractXMLDiff._initialize(implType, xmlDiffOptions, this.getXMLUtils());
    }

    public abstract AbstractXMLUtils getXMLUtils();

    public abstract Element readXPathElement(Element var1);

    public abstract void normalizeDocument(Document var1);

    public String getDifferenceDetails() throws XMLException {
        if (!XMLDiffImplType.XML_UNIT.equals((Object)implType)) {
            throw new XMLException("Difference details permit only on implementation: " + XMLDiffImplType.XML_UNIT);
        }
        return this.difference;
    }

    private boolean _diff(Object original, Object compare) throws XMLException {
        if (!initialized) {
            throw new XMLException("Library not initialized. Invoke initialize method");
        }
        if (XMLDiffImplType.XML_UNIT.equals((Object)implType)) {
            return this._diffXmlUnit(original, compare);
        }
        if (XMLDiffImplType.ORG_W3C_DOM_DOCUMENT.equals((Object)implType)) {
            return this._diffW3cDomDocument(original, compare);
        }
        throw new XMLException("Implementation [" + implType + "] not supported");
    }

    private boolean _diffXmlUnit(Object original, Object compare) throws XMLException {
        Document docCompare;
        Document docOriginal;
        DetailedDiff diff = null;
        if (original instanceof Document || original instanceof Element || original instanceof Node) {
            docOriginal = this._getDiffW3cDomDocument(original, "original");
            docCompare = this._getDiffW3cDomDocument(compare, "compare");
            if (xmlDiffOptions.isNormalize()) {
                this.normalizeDocument(docOriginal);
                this.normalizeDocument(docCompare);
            }
            diff = new DetailedDiff(XMLUnit.compareXML((Document)docOriginal, (Document)docCompare));
        } else {
            String sOriginal;
            String sCompare;
            Reader rCompare;
            Reader rOriginal;
            if (original instanceof Reader && compare instanceof Reader) {
                rOriginal = (Reader)original;
                rCompare = (Reader)compare;
                try {
                    diff = new DetailedDiff(XMLUnit.compareXML((Reader)rOriginal, (Reader)rCompare));
                }
                catch (Exception e) {
                    throw new XMLException(e.getMessage(), e);
                }
            }
            if (original instanceof Reader && compare instanceof String) {
                rOriginal = (Reader)original;
                sCompare = (String)compare;
                try {
                    diff = new DetailedDiff(XMLUnit.compareXML((Reader)rOriginal, (String)sCompare));
                }
                catch (Exception e) {
                    throw new XMLException(e.getMessage(), e);
                }
            }
            if (original instanceof String && compare instanceof Reader) {
                sOriginal = (String)original;
                rCompare = (Reader)compare;
                try {
                    diff = new DetailedDiff(XMLUnit.compareXML((String)sOriginal, (Reader)rCompare));
                }
                catch (Exception e) {
                    throw new XMLException(e.getMessage(), e);
                }
            }
            if (original instanceof String && compare instanceof String) {
                sOriginal = (String)original;
                sCompare = (String)compare;
                try {
                    diff = new DetailedDiff(XMLUnit.compareXML((String)sOriginal, (String)sCompare));
                }
                catch (Exception e) {
                    throw new XMLException(e.getMessage(), e);
                }
            }
            if ((original instanceof InputStream || original instanceof File) && (compare instanceof InputStream || compare instanceof File)) {
                InputSource isOriginal = null;
                InputSource isCompare = null;
                FileInputStream finOriginal = null;
                FileInputStream finCompare = null;
                try {
                    if (original instanceof InputStream) {
                        isOriginal = new InputSource((InputStream)original);
                    } else if (original instanceof File) {
                        finOriginal = new FileInputStream((File)original);
                        isOriginal = new InputSource(finOriginal);
                    }
                    if (compare instanceof InputStream) {
                        isCompare = new InputSource((InputStream)compare);
                    } else if (compare instanceof File) {
                        finCompare = new FileInputStream((File)compare);
                        isCompare = new InputSource(finCompare);
                    }
                    diff = new DetailedDiff(XMLUnit.compareXML((InputSource)isOriginal, (InputSource)isCompare));
                }
                catch (Exception e) {
                    throw new XMLException(e.getMessage(), e);
                }
                finally {
                    try {
                        if (finOriginal != null) {
                            finOriginal.close();
                        }
                    }
                    catch (Exception exception) {}
                    try {
                        if (finCompare != null) {
                            finCompare.close();
                        }
                    }
                    catch (Exception exception) {}
                }
            }
            docOriginal = this._getDiffW3cDomDocument(original, "original");
            docCompare = this._getDiffW3cDomDocument(compare, "compare");
            if (xmlDiffOptions.isNormalize()) {
                this.normalizeDocument(docOriginal);
                this.normalizeDocument(docCompare);
            }
            diff = new DetailedDiff(XMLUnit.compareXML((Document)docOriginal, (Document)docCompare));
        }
        if (!diff.identical()) {
            StringBuffer bfDifferences = new StringBuffer();
            List allDifferences = diff.getAllDifferences();
            bfDifferences.append("allDifferences: " + allDifferences.size());
            bfDifferences.append("\n");
            int index = 1;
            for (Object object : allDifferences) {
                if (object instanceof Difference) {
                    Difference d = (Difference)object;
                    bfDifferences.append("Diff-" + index + ": " + d.toString());
                    bfDifferences.append("\n");
                }
                ++index;
            }
            this.difference = bfDifferences.toString();
        }
        return diff.identical();
    }

    private boolean _diffW3cDomDocument(Object original, Object compare) throws XMLException {
        Document docOriginal = this._getDiffW3cDomDocument(original, "original");
        Document docCompare = this._getDiffW3cDomDocument(compare, "compare");
        if (xmlDiffOptions.isNormalize()) {
            this.normalizeDocument(docOriginal);
            this.normalizeDocument(docCompare);
        }
        return docOriginal.isEqualNode(docCompare);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Document _getDiffW3cDomDocument(Object o, String parameterName) throws XMLException {
        if (o == null) {
            throw new XMLException("Object is null for parameter [" + parameterName + "]");
        }
        if (o instanceof Document) {
            return (Document)o;
        }
        if (o instanceof Element) {
            return ((Element)o).getOwnerDocument();
        }
        if (o instanceof Node) {
            return ((Node)o).getOwnerDocument();
        }
        if (!(o instanceof String || o instanceof File || o instanceof InputStream)) {
            if (!(o instanceof Reader)) throw new XMLException("Object type [" + o.getClass().getName() + "] not supported for parameter [" + parameterName + "]");
        }
        ReaderInputStream ris = null;
        try {
            DocumentBuilder db = dbf_org_w3c_dom_document_impl.newDocumentBuilder();
            if (o instanceof String) {
                byte[] b = ((String)o).getBytes();
                Document document = db.parse(new ByteArrayInputStream(b));
                return document;
            }
            if (o instanceof File) {
                Document b = db.parse((File)o);
                return b;
            }
            if (o instanceof InputStream) {
                Document b = db.parse((InputStream)o);
                return b;
            }
            if (o instanceof Reader) {
                Reader r = (Reader)o;
                ris = new ReaderInputStream(r, Charset.forName("UTF-8"));
                Document document = db.parse((InputStream)ris);
                return document;
            }
            throw new XMLException("Object type [" + o.getClass().getName() + "] not supported ?? for parameter [" + parameterName + "]");
        }
        catch (Exception e) {
            throw new XMLException("Object type [" + o.getClass().getName() + "] parser error for parameter [" + parameterName + "]: " + e.getMessage(), e);
        }
        finally {
            try {
                if (ris != null) {
                    ris.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public boolean diff(String original, String compare) throws XMLException {
        return this._diff(original, compare);
    }

    public boolean diff(File original, File compare) throws XMLException {
        return this._diff(original, compare);
    }

    public boolean diff(InputStream original, InputStream compare) throws XMLException {
        return this._diff(original, compare);
    }

    public boolean diff(Reader original, Reader compare) throws XMLException {
        return this._diff(original, compare);
    }

    public boolean diff(Document original, Document compare) throws XMLException {
        return this._diff(original, compare);
    }

    public boolean diff(Element original, Element compare) throws XMLException {
        return this._diff(original, compare);
    }

    public boolean diff(Node original, Node compare) throws XMLException {
        return this._diff(original, compare);
    }

    public boolean diff(Object original, Object compare) throws XMLException {
        return this._diff(original, compare);
    }
}

