/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.utils.xacml;

import it.link.pdd.tools.migrazione_govway.utils.xacml.MarshallUtilities;
import java.util.ArrayList;
import java.util.List;
import org.herasaf.xacml.core.context.impl.ActionType;
import org.herasaf.xacml.core.context.impl.AttributeType;
import org.herasaf.xacml.core.context.impl.AttributeValueType;
import org.herasaf.xacml.core.context.impl.EnvironmentType;
import org.herasaf.xacml.core.context.impl.ObjectFactory;
import org.herasaf.xacml.core.context.impl.RequestType;
import org.herasaf.xacml.core.context.impl.ResourceType;
import org.herasaf.xacml.core.context.impl.SubjectType;
import org.herasaf.xacml.core.dataTypeAttribute.DataTypeAttribute;
import org.herasaf.xacml.core.dataTypeAttribute.impl.StringDataTypeAttribute;

public class XacmlRequest {
    private ObjectFactory factory = new ObjectFactory();
    private RequestType xacmlRequest = this.factory.createRequestType();

    public RequestType getXacmlRequest() {
        return this.xacmlRequest;
    }

    public XacmlRequest() {
        MarshallUtilities.runInitializers();
    }

    public void createAction() {
        if (this.xacmlRequest.getAction() == null) {
            ActionType action = this.factory.createActionType();
            this.xacmlRequest.setAction(action);
        }
    }

    public void addAction(String azione) {
        this.addActionAttribute("urn:oasis:names:tc:xacml:1.0:action:action-id", azione);
    }

    public void addActionAttribute(String attributeName, String attributeValue) {
        this.addActionAttribute(this.createAttribute(attributeName, attributeValue));
    }

    public void addActionAttribute(String attributeName, List<String> attributeValues) {
        this.addActionAttribute(this.createAttribute(attributeName, attributeValues));
    }

    public void addActionAttribute(AttributeType attribute) {
        this.createAction();
        this.xacmlRequest.getAction().getAttributes().add(attribute);
    }

    public void addSubject(String subject) {
        this.addSubjectAttribute("urn:oasis:names:tc:xacml:1.0:subject:subject-id", subject);
    }

    public void createSubject() {
        if (this.xacmlRequest.getSubjects().isEmpty()) {
            SubjectType subject = this.factory.createSubjectType();
            this.xacmlRequest.getSubjects().add(subject);
        }
    }

    public void addSubjectAttribute(String attributeName, String attributeValue) {
        this.addSubjectAttribute(this.createAttribute(attributeName, attributeValue));
    }

    public void addSubjectAttribute(String attributeName, List<String> attributeValues) {
        this.addSubjectAttribute(this.createAttribute(attributeName, attributeValues));
    }

    public void addSubjectAttribute(AttributeType attribute) {
        this.createSubject();
        ((SubjectType)this.xacmlRequest.getSubjects().get(0)).getAttributes().add(attribute);
    }

    public void createEnvironment() {
        if (this.xacmlRequest.getEnvironment() == null) {
            EnvironmentType action = this.factory.createEnvironmentType();
            this.xacmlRequest.setEnvironment(action);
        }
    }

    public void addEnvironmentAttribute(String attributeName, String attributeValue) {
        this.addEnvironmentAttribute(this.createAttribute(attributeName, attributeValue));
    }

    public void addEnvironmentAttribute(String attributeName, List<String> attributeValues) {
        this.addEnvironmentAttribute(this.createAttribute(attributeName, attributeValues));
    }

    public void addEnvironmentAttribute(AttributeType attribute) {
        this.createEnvironment();
        this.xacmlRequest.getEnvironment().getAttributes().add(attribute);
    }

    public void createResource() {
        if (this.xacmlRequest.getResources().isEmpty()) {
            ResourceType resource = this.factory.createResourceType();
            this.xacmlRequest.getResources().add(resource);
        }
    }

    public void addResourceAttribute(String attributeName, String attributeValue) {
        this.addResourceAttribute(this.createAttribute(attributeName, attributeValue));
    }

    public void addResourceAttribute(String attributeName, List<String> attributeValues) {
        this.addResourceAttribute(this.createAttribute(attributeName, attributeValues));
    }

    public void addResourceAttribute(AttributeType attribute) {
        this.createResource();
        ((ResourceType)this.xacmlRequest.getResources().get(0)).getAttributes().add(attribute);
    }

    private AttributeType createAttribute(String name, List<String> values) {
        AttributeType attribute = this.factory.createAttributeType();
        for (String value : values) {
            AttributeValueType value1 = new AttributeValueType();
            value1.getContent().add(value);
            attribute.getAttributeValues().add(value1);
        }
        attribute.setAttributeId(name);
        attribute.setDataType((DataTypeAttribute)new StringDataTypeAttribute());
        return attribute;
    }

    private AttributeType createAttribute(String name, String value) {
        ArrayList<String> lst = new ArrayList<String>();
        lst.add(value);
        return this.createAttribute(name, lst);
    }
}

