/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.utils.xacml;

import it.link.pdd.tools.migrazione_govway.utils.xacml.XacmlRequest;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.herasaf.xacml.core.SyntaxException;
import org.herasaf.xacml.core.WritingException;
import org.herasaf.xacml.core.context.RequestMarshaller;
import org.herasaf.xacml.core.context.ResponseMarshaller;
import org.herasaf.xacml.core.context.impl.RequestType;
import org.herasaf.xacml.core.context.impl.ResponseType;
import org.herasaf.xacml.core.context.impl.ResultType;
import org.herasaf.xacml.core.policy.Evaluatable;
import org.herasaf.xacml.core.policy.PolicyMarshaller;
import org.herasaf.xacml.core.simplePDP.initializers.InitializerExecutor;

public class MarshallUtilities {
    private static boolean runInitialized = false;

    private static synchronized void _runInitializers() {
        if (!runInitialized) {
            InitializerExecutor.runInitializers();
            runInitialized = true;
        }
    }

    public static void runInitializers() {
        if (!runInitialized) {
            MarshallUtilities._runInitializers();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ResultType> unmarshallResult(byte[] res) throws SyntaxException {
        MarshallUtilities.runInitializers();
        ByteArrayInputStream inputStream = null;
        try {
            inputStream = new ByteArrayInputStream(res);
            ResponseType response = ResponseMarshaller.unmarshal((InputStream)inputStream);
            List list = response.getResults();
            return list;
        }
        finally {
            if (inputStream != null) {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Evaluatable unmarshallPolicy(byte[] res) throws SyntaxException {
        MarshallUtilities.runInitializers();
        ByteArrayInputStream inputStream = null;
        try {
            Evaluatable response;
            inputStream = new ByteArrayInputStream(res);
            Evaluatable evaluatable = response = PolicyMarshaller.unmarshal((InputStream)inputStream);
            return evaluatable;
        }
        finally {
            if (inputStream != null) {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static byte[] marshallRequest(XacmlRequest request) throws SecurityException {
        return MarshallUtilities.marshallRequest(request.getXacmlRequest());
    }

    public static byte[] marshallRequest(RequestType request) throws SecurityException {
        MarshallUtilities.runInitializers();
        ByteArrayOutputStream baos = null;
        try {
            baos = new ByteArrayOutputStream();
            RequestMarshaller.marshal((RequestType)request, (OutputStream)baos);
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (WritingException e) {
            throw new SecurityException(e);
        }
        finally {
            if (baos != null) {
                try {
                    baos.flush();
                    baos.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

