/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.utils.xacml;

import it.link.pdd.tools.migrazione_govway.utils.xacml.PolicyException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.herasaf.xacml.core.WritingException;
import org.herasaf.xacml.core.context.impl.AttributeType;
import org.herasaf.xacml.core.context.impl.RequestType;
import org.herasaf.xacml.core.context.impl.ResourceType;
import org.herasaf.xacml.core.dataTypeAttribute.DataTypeAttribute;
import org.herasaf.xacml.core.dataTypeAttribute.impl.StringDataTypeAttribute;
import org.herasaf.xacml.core.function.Function;
import org.herasaf.xacml.core.function.impl.equalityPredicates.StringEqualFunction;
import org.herasaf.xacml.core.policy.Evaluatable;
import org.herasaf.xacml.core.policy.EvaluatableID;
import org.herasaf.xacml.core.policy.PolicyMarshaller;
import org.herasaf.xacml.core.policy.impl.ActionAttributeDesignatorType;
import org.herasaf.xacml.core.policy.impl.ActionMatchType;
import org.herasaf.xacml.core.policy.impl.ActionType;
import org.herasaf.xacml.core.policy.impl.ActionsType;
import org.herasaf.xacml.core.policy.impl.AttributeValueType;
import org.herasaf.xacml.core.policy.impl.EvaluatableIDImpl;
import org.herasaf.xacml.core.policy.impl.ObjectFactory;
import org.herasaf.xacml.core.policy.impl.PolicyType;
import org.herasaf.xacml.core.policy.impl.ResourceAttributeDesignatorType;
import org.herasaf.xacml.core.policy.impl.ResourceMatchType;
import org.herasaf.xacml.core.policy.impl.ResourcesType;
import org.herasaf.xacml.core.policy.impl.TargetType;
import org.herasaf.xacml.core.simplePDP.OrderedMapBasedSimplePolicyRepository;
import org.slf4j.Logger;

public class CachedMapBasedSimplePolicyRepository
extends OrderedMapBasedSimplePolicyRepository {
    private Map<EvaluatableID, String> cacheMap = new HashMap<EvaluatableID, String>();
    private MessageDigest md;
    private Logger log;
    public static final boolean USE_RESOURCE_TO_MATCH_POLICY = true;
    public static final String RESOURCE_ATTRIBUTE_ID_TO_MATCH = "___resource-id___";
    public static final String ACTION_ATTRIBUTE_ID_TO_MATCH = "urn:oasis:names:tc:xacml:1.0:action:action-id";

    public CachedMapBasedSimplePolicyRepository(Logger log) throws PolicyException {
        this.log = log;
        try {
            this.md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new PolicyException(e);
        }
    }

    public boolean existsPolicy(EvaluatableID id, String policyString) {
        return this.cacheMap.containsKey(id) && this.cacheMap.get(id).equals(this.hash(policyString));
    }

    public void deploy(Evaluatable evaluatable, String policyString) {
        if (this.individualEvaluatables.containsKey(evaluatable.getId())) {
            this.undeploy(evaluatable.getId());
        }
        super.deploy(evaluatable);
        this.cacheMap.put(evaluatable.getId(), this.hash(policyString));
    }

    public void deploy(Evaluatable evaluatable) {
        CachedMapBasedSimplePolicyRepository.addResourceToPolicy((PolicyType)evaluatable, evaluatable.getId().toString());
        if (this.individualEvaluatables.containsKey(evaluatable.getId())) {
            this.undeploy(evaluatable.getId());
        }
        super.deploy(evaluatable);
        this.cacheMap.put(evaluatable.getId(), this.hash(this.unmarshallPolicy(evaluatable)));
    }

    private static void addActionToPolicy(PolicyType policy1, String key) {
        ObjectFactory factory = new ObjectFactory();
        TargetType target = factory.createTargetType();
        if (policy1.getTarget() != null) {
            target = policy1.getTarget();
        }
        ActionType action = factory.createActionType();
        ActionMatchType actionMatch = factory.createActionMatchType();
        StringEqualFunction function = new StringEqualFunction();
        actionMatch.setMatchFunction((Function)function);
        ActionAttributeDesignatorType attributeDesignator = factory.createActionAttributeDesignatorType();
        attributeDesignator.setMustBePresent(Boolean.valueOf(true));
        attributeDesignator.setAttributeId(ACTION_ATTRIBUTE_ID_TO_MATCH);
        attributeDesignator.setDataType((DataTypeAttribute)new StringDataTypeAttribute());
        actionMatch.setActionAttributeDesignator(attributeDesignator);
        AttributeValueType attributeValue = new AttributeValueType();
        attributeValue.getContent().add(key);
        attributeValue.setDataType((DataTypeAttribute)new StringDataTypeAttribute());
        actionMatch.setAttributeValue(attributeValue);
        action.getActionMatches().add(actionMatch);
        ActionsType actions = factory.createActionsType();
        actions.getActions().add(action);
        target.setActions(actions);
        policy1.setTarget(target);
    }

    private static void addResourceToPolicy(PolicyType policy1, String key) {
        ObjectFactory factory = new ObjectFactory();
        TargetType target = factory.createTargetType();
        if (policy1.getTarget() != null) {
            target = policy1.getTarget();
        }
        org.herasaf.xacml.core.policy.impl.ResourceType resource = factory.createResourceType();
        ResourceMatchType resourceMatch = factory.createResourceMatchType();
        StringEqualFunction function = new StringEqualFunction();
        resourceMatch.setMatchFunction((Function)function);
        ResourceAttributeDesignatorType attributeDesignator = factory.createResourceAttributeDesignatorType();
        attributeDesignator.setMustBePresent(Boolean.valueOf(true));
        attributeDesignator.setAttributeId(RESOURCE_ATTRIBUTE_ID_TO_MATCH);
        attributeDesignator.setDataType((DataTypeAttribute)new StringDataTypeAttribute());
        resourceMatch.setResourceAttributeDesignator(attributeDesignator);
        AttributeValueType attributeValue = new AttributeValueType();
        attributeValue.getContent().add(key);
        attributeValue.setDataType((DataTypeAttribute)new StringDataTypeAttribute());
        resourceMatch.setAttributeValue(attributeValue);
        resource.getResourceMatches().add(resourceMatch);
        ResourcesType resources = factory.createResourcesType();
        resources.getResources().add(resource);
        target.setResources(resources);
        policy1.setTarget(target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String unmarshallPolicy(Evaluatable eval) {
        ByteArrayOutputStream baos = null;
        try {
            baos = new ByteArrayOutputStream();
            PolicyMarshaller.marshal((Evaluatable)eval, (OutputStream)baos);
            String string = baos.toString();
            return string;
        }
        catch (WritingException e) {
            String string = null;
            return string;
        }
        finally {
            if (baos != null) {
                try {
                    baos.flush();
                }
                catch (IOException iOException) {}
                try {
                    baos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void deploy(Collection<Evaluatable> evaluatables, String policyString) {
        for (Evaluatable eval : evaluatables) {
            this.deploy(eval, this.hash(policyString));
        }
    }

    public void undeploy(EvaluatableID evaluatable) {
        super.undeploy(evaluatable);
        this.cacheMap.remove(evaluatable);
    }

    public void undeploy(Collection<EvaluatableID> evaluatables, String policyString) {
        super.undeploy(evaluatables);
        for (EvaluatableID eval : evaluatables) {
            this.cacheMap.remove(eval);
        }
    }

    private String hash(String policyString) {
        String digest = CachedMapBasedSimplePolicyRepository.toHex(this.md.digest(policyString.getBytes()));
        return digest;
    }

    private static String toHex(byte[] bytes) {
        BigInteger bi = new BigInteger(1, bytes);
        return String.format("%0" + (bytes.length << 1) + "X", bi);
    }

    public List<Evaluatable> getEvaluatables(RequestType request) {
        try {
            String key = this.getKey(request);
            this.log.info("KEY: " + key);
            if (key != null) {
                EvaluatableIDImpl policyId = new EvaluatableIDImpl(key);
                Evaluatable eval = super.getEvaluatable((EvaluatableID)policyId);
                this.log.info("eval is null? " + (eval == null));
                if (eval != null) {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    PolicyMarshaller.marshal((Evaluatable)eval, (OutputStream)baos);
                    this.log.info("eval:" + new String(baos.toByteArray()));
                }
                return Arrays.asList(eval);
            }
            return new ArrayList<Evaluatable>();
        }
        catch (Exception exception) {
            return super.getEvaluatables(request);
        }
    }

    private String getKey(RequestType request) {
        try {
            for (ResourceType resource : request.getResources()) {
                for (AttributeType attribute : resource.getAttributes()) {
                    if (!attribute.getAttributeId().equals(RESOURCE_ATTRIBUTE_ID_TO_MATCH)) continue;
                    return (String)((org.herasaf.xacml.core.context.impl.AttributeValueType)attribute.getAttributeValues().get(0)).getContent().get(0);
                }
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }
}

