/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.utils.wsdl;

import com.ibm.wsdl.xml.WSDLReaderImpl;
import com.ibm.wsdl.xml.WSDLWriterImpl;
import it.link.pdd.tools.migrazione_govway.utils.wsdl.DefinitionWrapper;
import it.link.pdd.tools.migrazione_govway.utils.wsdl.WSDLException;
import it.link.pdd.tools.migrazione_govway.utils.xml.AbstractXMLUtils;
import it.link.pdd.tools.migrazione_govway.utils.xml.PrettyPrintXMLUtils;
import it.link.pdd.tools.migrazione_govway.utils.xml.XMLException;
import it.link.pdd.tools.migrazione_govway.utils.xml.XSDUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.wsdl.Definition;
import javax.wsdl.Types;
import javax.wsdl.extensions.schema.Schema;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class WSDLUtilities {
    private AbstractXMLUtils xmlUtils = null;

    public static WSDLUtilities getInstance(AbstractXMLUtils xmlUtils) {
        return new WSDLUtilities(xmlUtils);
    }

    public WSDLUtilities(AbstractXMLUtils xmlUtils) {
        this.xmlUtils = xmlUtils;
    }

    public WSDLReaderImpl getWSDLReader(boolean verbose, boolean importDocuments) {
        WSDLReaderImpl wsdlReader = new WSDLReaderImpl();
        wsdlReader.setFeature("javax.wsdl.verbose", verbose);
        wsdlReader.setFeature("javax.wsdl.importDocuments", importDocuments);
        return wsdlReader;
    }

    public boolean isWSDL(byte[] wsdl) throws WSDLException {
        try {
            if (this.xmlUtils == null) {
                throw new Exception("XMLUtils not initialized in WSDLUtilities, use static instance 'getInstance(AbstractXMLUtils xmlUtils)'");
            }
            if (!this.xmlUtils.isDocument(wsdl)) {
                return false;
            }
            Document docXML = this.xmlUtils.newDocument(wsdl);
            Element elemXML = docXML.getDocumentElement();
            return this.isWSDL(elemXML);
        }
        catch (Exception e) {
            throw new WSDLException(e.getMessage(), e);
        }
    }

    public boolean isWSDL(Document wsdl) throws WSDLException {
        Element elemXML = wsdl.getDocumentElement();
        return this.isWSDL(elemXML);
    }

    public boolean isWSDL(Element wsdl) throws WSDLException {
        return this.isWSDL((Node)wsdl);
    }

    public boolean isWSDL(Node wsdl) throws WSDLException {
        try {
            if (wsdl == null) {
                throw new Exception("Documento wsdl da verificare non definito");
            }
            if (!"definitions".equals(wsdl.getLocalName())) {
                return false;
            }
            return "http://schemas.xmlsoap.org/wsdl/".equals(wsdl.getNamespaceURI());
        }
        catch (Exception e) {
            throw new WSDLException(e.getMessage(), e);
        }
    }

    public String getTargetNamespace(byte[] xsd) throws WSDLException {
        try {
            if (this.xmlUtils == null) {
                throw new Exception("XMLUtils not initialized in WSDLUtilities, use static instance 'getInstance(AbstractXMLUtils xmlUtils)'");
            }
            if (!this.xmlUtils.isDocument(xsd)) {
                throw new Exception("Wsdl non e' un documento valido");
            }
            Document docXML = this.xmlUtils.newDocument(xsd);
            Element elemXML = docXML.getDocumentElement();
            return this.getTargetNamespace(elemXML);
        }
        catch (Exception e) {
            throw new WSDLException(e.getMessage(), e);
        }
    }

    public String getTargetNamespace(Document xsd) throws WSDLException {
        Element elemXML = xsd.getDocumentElement();
        return this.getTargetNamespace(elemXML);
    }

    public String getTargetNamespace(Element elemXML) throws WSDLException {
        return this.getTargetNamespace((Node)elemXML);
    }

    public String getTargetNamespace(Node elemXML) throws WSDLException {
        try {
            if (this.xmlUtils == null) {
                throw new Exception("XMLUtils not initialized in WSDLUtilities, use static instance 'getInstance(AbstractXMLUtils xmlUtils)'");
            }
            if (elemXML == null) {
                throw new Exception("Wsdl non e' un documento valido");
            }
            if (!"definitions".equals(elemXML.getLocalName())) {
                throw new Exception("Root element non e' un definition wsdl (" + elemXML.getLocalName() + ")");
            }
            String targetNamespace = this.xmlUtils.getAttributeValue(elemXML, "targetNamespace");
            return targetNamespace;
        }
        catch (Exception e) {
            throw new WSDLException(e.getMessage(), e);
        }
    }

    public String getTargetNamespace(Schema schema) {
        NamedNodeMap attributi = schema.getElement().getAttributes();
        if (attributi != null) {
            for (int i = 0; i < attributi.getLength(); ++i) {
                Node a = attributi.item(i);
                if (!"targetNamespace".equals(a.getLocalName())) continue;
                return a.getNodeValue();
            }
        }
        return null;
    }

    public String getImportNamespace(Node elemXML) throws WSDLException {
        try {
            if (this.xmlUtils == null) {
                throw new Exception("XMLUtils not initialized in WSDLUtilities, use static instance 'getInstance(AbstractXMLUtils xmlUtils)'");
            }
            if (elemXML == null) {
                throw new Exception("Non e' un import valido");
            }
            if (!"import".equals(elemXML.getLocalName())) {
                throw new Exception("Root element non e' un import wsdl (" + elemXML.getLocalName() + ")");
            }
            String targetNamespace = this.xmlUtils.getAttributeValue(elemXML, "namespace");
            return targetNamespace;
        }
        catch (Exception e) {
            throw new WSDLException(e.getMessage(), e);
        }
    }

    public String getImportLocation(Node elemXML) throws WSDLException {
        try {
            if (this.xmlUtils == null) {
                throw new Exception("XMLUtils not initialized in WSDLUtilities, use static instance 'getInstance(AbstractXMLUtils xmlUtils)'");
            }
            if (elemXML == null) {
                throw new Exception("Non e' un import valido");
            }
            if (!"import".equals(elemXML.getLocalName())) {
                throw new Exception("Root element non e' un import wsdl (" + elemXML.getLocalName() + ")");
            }
            String targetNamespace = this.xmlUtils.getAttributeValue(elemXML, "location");
            return targetNamespace;
        }
        catch (Exception e) {
            throw new WSDLException(e.getMessage(), e);
        }
    }

    public void updateLocation(Node elemXML, String newLocation) throws WSDLException {
        try {
            if (this.xmlUtils == null) {
                throw new Exception("XMLUtils not initialized in WSDLUtilities, use static instance 'getInstance(AbstractXMLUtils xmlUtils)'");
            }
            if (elemXML == null) {
                throw new Exception("Non e' un import valido");
            }
            if (!"import".equals(elemXML.getLocalName())) {
                throw new Exception("Root element non e' un import wsdl (" + elemXML.getLocalName() + ")");
            }
            if (elemXML != null && elemXML.getAttributes() != null && elemXML.getAttributes().getLength() > 0) {
                Attr oldLocation = (Attr)elemXML.getAttributes().getNamedItem("location");
                this.xmlUtils.removeAttribute(oldLocation, (Element)elemXML);
                oldLocation.setValue(newLocation);
                this.xmlUtils.addAttribute(oldLocation, (Element)elemXML);
            }
        }
        catch (Exception e) {
            throw new WSDLException(e.getMessage(), e);
        }
    }

    public void writeWsdlTo(Definition wsdl, String absoluteFilename) throws javax.wsdl.WSDLException, IOException, WSDLException {
        this.writeWsdlTo(wsdl, absoluteFilename, false);
    }

    public void writeWsdlTo(Definition wsdl, String absoluteFilename, boolean prettyPrint) throws javax.wsdl.WSDLException, IOException, WSDLException {
        if (wsdl == null) {
            return;
        }
        WSDLWriterImpl writer = new WSDLWriterImpl();
        if (prettyPrint) {
            this.writeWsdlTo(wsdl, new File(absoluteFilename), prettyPrint);
        } else {
            writer.writeWSDL(wsdl, (Writer)new FileWriter(absoluteFilename));
        }
    }

    public void writeWsdlTo(Definition wsdl, File file) throws javax.wsdl.WSDLException, IOException, WSDLException {
        this.writeWsdlTo(wsdl, file, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeWsdlTo(Definition wsdl, File file, boolean prettyPrint) throws javax.wsdl.WSDLException, IOException, WSDLException {
        if (wsdl == null) {
            return;
        }
        WSDLWriterImpl writer = new WSDLWriterImpl();
        if (prettyPrint) {
            FileOutputStream fout = null;
            try {
                fout = new FileOutputStream(file);
                this.writeWsdlTo(wsdl, fout, prettyPrint);
            }
            finally {
                try {
                    fout.flush();
                }
                catch (Exception exception) {}
                try {
                    fout.close();
                }
                catch (Exception exception) {}
            }
        }
        writer.writeWSDL(wsdl, (Writer)new FileWriter(file));
    }

    public void writeWsdlTo(Definition wsdl, OutputStream out) throws javax.wsdl.WSDLException, IOException, WSDLException {
        this.writeWsdlTo(wsdl, out, false);
    }

    public void writeWsdlTo(Definition wsdl, OutputStream out, boolean prettyPrint) throws javax.wsdl.WSDLException, IOException, WSDLException {
        if (wsdl == null) {
            return;
        }
        WSDLWriterImpl writer = new WSDLWriterImpl();
        if (prettyPrint) {
            out.write(this.prettyPrintWsdl(wsdl).getBytes());
        } else {
            writer.writeWSDL(wsdl, out);
        }
    }

    public void writeWsdlTo(Definition wsdl, Writer writer) throws javax.wsdl.WSDLException, IOException, WSDLException {
        this.writeWsdlTo(wsdl, writer, false);
    }

    public void writeWsdlTo(Definition wsdl, Writer writer, boolean prettyPrint) throws javax.wsdl.WSDLException, IOException, WSDLException {
        if (wsdl == null) {
            return;
        }
        WSDLWriterImpl writerWsdl = new WSDLWriterImpl();
        if (prettyPrint) {
            writer.append(this.prettyPrintWsdl(wsdl));
        } else {
            writerWsdl.writeWSDL(wsdl, writer);
        }
    }

    private String prettyPrintWsdl(Definition wsdl) throws javax.wsdl.WSDLException, IOException, WSDLException {
        try {
            if (this.xmlUtils == null) {
                throw new Exception("XMLUtils not initialized in WSDLUtilities, use static instance 'getInstance(AbstractXMLUtils xmlUtils)'");
            }
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            this.writeWsdlTo(wsdl, bout, false);
            bout.flush();
            bout.close();
            Document wsdlDocument = this.xmlUtils.newDocument(bout.toByteArray());
            return PrettyPrintXMLUtils.prettyPrintWithTrAX(wsdlDocument);
        }
        catch (Exception e) {
            throw new WSDLException(e.getMessage(), e);
        }
    }

    public Definition readWSDLFromFile(File file) throws javax.wsdl.WSDLException {
        return this.readWSDLFromFile(file, false, true);
    }

    public Definition readWSDLFromFile(File file, boolean verbose, boolean importsDocument) throws javax.wsdl.WSDLException {
        try {
            if (file == null) {
                throw new Exception("Path non definito");
            }
            WSDLReaderImpl reader = this.getWSDLReader(verbose, importsDocument);
            Definition def = reader.readWSDL(file.getAbsolutePath());
            return def;
        }
        catch (Exception e) {
            throw new javax.wsdl.WSDLException("WSDLDefinitorio.readWSDLFromLocation(String path)", "Lettura del wsdl non riuscita: " + e.getMessage());
        }
    }

    public Definition readWSDLFromLocation(String path) throws javax.wsdl.WSDLException {
        return this.readWSDLFromLocation(path, false, true);
    }

    public Definition readWSDLFromLocation(String path, boolean verbose, boolean importsDocument) throws javax.wsdl.WSDLException {
        try {
            if (path == null) {
                throw new Exception("Path non definito");
            }
            WSDLReaderImpl reader = this.getWSDLReader(verbose, importsDocument);
            Definition def = reader.readWSDL(path);
            return def;
        }
        catch (Exception e) {
            throw new javax.wsdl.WSDLException("WSDLDefinitorio.readWSDLFromLocation(String path)", "Lettura del wsdl non riuscita: " + e.getMessage());
        }
    }

    public Definition readWSDLFromBytes(byte[] wsdl) throws javax.wsdl.WSDLException {
        return this.readWSDLFromBytes(wsdl, false, true);
    }

    public Definition readWSDLFromBytes(byte[] wsdl, boolean verbose, boolean importsDocument) throws javax.wsdl.WSDLException {
        try {
            if (this.xmlUtils == null) {
                throw new Exception("XMLUtils not initialized in WSDLUtilities, use static instance 'getInstance(AbstractXMLUtils xmlUtils)'");
            }
            if (wsdl == null) {
                throw new Exception("Bytes non definiti");
            }
            WSDLReaderImpl reader = this.getWSDLReader(verbose, importsDocument);
            Document document = this.xmlUtils.newDocument(wsdl);
            Definition def = reader.readWSDL(null, document);
            return def;
        }
        catch (Exception e) {
            throw new javax.wsdl.WSDLException("WSDLDefinitorio.readWSDLFromBytes(byte[] wsdl)", "Lettura del wsdl non riuscita: " + e.getMessage());
        }
    }

    public Definition readWSDLFromDocument(Document doc) throws javax.wsdl.WSDLException {
        return this.readWSDLFromDocument(doc, false, true);
    }

    public Definition readWSDLFromDocument(Document doc, boolean verbose, boolean importsDocument) throws javax.wsdl.WSDLException {
        try {
            if (doc == null) {
                throw new Exception("Document non definito");
            }
            WSDLReaderImpl reader = this.getWSDLReader(verbose, importsDocument);
            Definition def = reader.readWSDL(null, doc);
            return def;
        }
        catch (Exception e) {
            throw new javax.wsdl.WSDLException("WSDLDefinitorio.readWSDLFromDocument(Document doc)", "Lettura del wsdl non riuscita: " + e.getMessage());
        }
    }

    public Definition readWSDLFromElement(Element elem) throws javax.wsdl.WSDLException {
        return this.readWSDLFromElement(elem, false, true);
    }

    public Definition readWSDLFromElement(Element elem, boolean verbose, boolean importsDocument) throws javax.wsdl.WSDLException {
        try {
            if (elem == null) {
                throw new Exception("Element non definito");
            }
            WSDLReaderImpl reader = this.getWSDLReader(verbose, importsDocument);
            String param = null;
            Definition def = reader.readWSDL(param, elem);
            return def;
        }
        catch (Exception e) {
            throw new javax.wsdl.WSDLException("WSDLDefinitorio.readWSDLFromElement(Element elem)", "Lettura del wsdl non riuscita: " + e.getMessage());
        }
    }

    public Definition readWSDLFromURI(URI uri) throws javax.wsdl.WSDLException {
        return this.readWSDLFromURI(uri, false, true);
    }

    public Definition readWSDLFromURI(URI uri, boolean verbose, boolean importsDocument) throws javax.wsdl.WSDLException {
        try {
            if (uri == null) {
                throw new Exception("URI non definita");
            }
            WSDLReaderImpl reader = this.getWSDLReader(verbose, importsDocument);
            Definition def = reader.readWSDL(null, uri.getPath());
            return def;
        }
        catch (Exception e) {
            throw new javax.wsdl.WSDLException("WSDLDefinitorio.readWSDLFromURI(URI uri)", "Lettura del wsdl non riuscita: " + e.getMessage());
        }
    }

    public void addSchemaIntoTypes(Document wsdl, Node schema) throws WSDLException {
        try {
            NodeList list = wsdl.getChildNodes();
            if (list != null) {
                for (int i = 0; i < list.getLength(); ++i) {
                    NodeList listDefinition;
                    Node child = list.item(i);
                    if (!"definitions".equals(child.getLocalName()) || (listDefinition = child.getChildNodes()) == null) continue;
                    for (int j = 0; j < listDefinition.getLength(); ++j) {
                        Node childDefinition = listDefinition.item(j);
                        if (!"types".equals(childDefinition.getLocalName())) continue;
                        childDefinition.appendChild(wsdl.createTextNode("\n\t\t"));
                        childDefinition.appendChild(schema);
                        childDefinition.appendChild(wsdl.createTextNode("\n"));
                    }
                }
            }
        }
        catch (Exception e) {
            throw new WSDLException("Riscontrato errore durante l'aggiunto di uno schema nell'elemento Types: " + e.getMessage(), e);
        }
    }

    public void addImportSchemaIntoTypes(Document wsdl, String targetNamespace, String location) throws WSDLException {
        try {
            NodeList list = wsdl.getChildNodes();
            if (list != null) {
                for (int i = 0; i < list.getLength(); ++i) {
                    NodeList listDefinition;
                    Node child = list.item(i);
                    if (!"definitions".equals(child.getLocalName()) || (listDefinition = child.getChildNodes()) == null) continue;
                    for (int j = 0; j < listDefinition.getLength(); ++j) {
                        Node childDefinition = listDefinition.item(j);
                        if (!"types".equals(childDefinition.getLocalName())) continue;
                        Element importSchemaElement = wsdl.createElementNS("http://www.w3.org/2001/XMLSchema", "schema");
                        importSchemaElement.setAttribute("targetNamespace", targetNamespace);
                        Element importElement = wsdl.createElementNS("http://www.w3.org/2001/XMLSchema", "import");
                        importElement.setAttribute("namespace", targetNamespace);
                        importElement.setAttribute("schemaLocation", location);
                        importSchemaElement.appendChild(wsdl.createTextNode("\n\t\t\t"));
                        importSchemaElement.appendChild(importElement);
                        importSchemaElement.appendChild(wsdl.createTextNode("\n\t\t"));
                        childDefinition.appendChild(wsdl.createTextNode("\n\t\t"));
                        childDefinition.appendChild(importSchemaElement);
                        childDefinition.appendChild(wsdl.createTextNode("\n\n"));
                    }
                }
            }
        }
        catch (Exception e) {
            throw new WSDLException("Riscontrato errore durante l'aggiunto di uno schema nell'elemento Types: " + e.getMessage(), e);
        }
    }

    public Node getIfExistsDefinitionsElementIntoWSDL(Document wsdl) throws WSDLException {
        try {
            NodeList list = wsdl.getChildNodes();
            if (list != null) {
                for (int i = 0; i < list.getLength(); ++i) {
                    Node child = list.item(i);
                    if (!"definitions".equals(child.getLocalName())) continue;
                    return child;
                }
            }
            return null;
        }
        catch (Exception e) {
            throw new WSDLException("Riscontrato errore durante la lettura del wsdl: " + e.getMessage(), e);
        }
    }

    public List<Node> readImports(Document wsdl) throws WSDLException {
        try {
            Vector<Node> imports = new Vector<Node>();
            NodeList list = wsdl.getChildNodes();
            if (list != null) {
                for (int i = 0; i < list.getLength(); ++i) {
                    NodeList listDefinition;
                    Node child = list.item(i);
                    if (!"definitions".equals(child.getLocalName()) || (listDefinition = child.getChildNodes()) == null) continue;
                    for (int j = 0; j < listDefinition.getLength(); ++j) {
                        Node childDefinition = listDefinition.item(j);
                        if (!"import".equals(childDefinition.getLocalName())) continue;
                        imports.add(childDefinition);
                    }
                }
            }
            return imports;
        }
        catch (Exception e) {
            throw new WSDLException("Riscontrato errore durante la lettura del wsdl: " + e.getMessage(), e);
        }
    }

    public List<Node> readImportsAndIncludesSchemaIntoTypes(Document wsdl) throws WSDLException {
        return this.readImportsIncludesSchemaIntoTypes(wsdl, true, true);
    }

    public List<Node> readImportsSchemaIntoTypes(Document wsdl) throws WSDLException {
        return this.readImportsIncludesSchemaIntoTypes(wsdl, true, false);
    }

    public List<Node> readIncludesSchemaIntoTypes(Document wsdl) throws WSDLException {
        return this.readImportsIncludesSchemaIntoTypes(wsdl, false, true);
    }

    private List<Node> readImportsIncludesSchemaIntoTypes(Document wsdl, boolean readImport, boolean readInclude) throws WSDLException {
        try {
            if (this.xmlUtils == null) {
                throw new Exception("XMLUtils not initialized in WSDLUtilities, use static instance 'getInstance(AbstractXMLUtils xmlUtils)'");
            }
            XSDUtils xsdUtils = new XSDUtils(this.xmlUtils);
            Vector<Node> imports = new Vector<Node>();
            NodeList list = wsdl.getChildNodes();
            if (list != null) {
                for (int i = 0; i < list.getLength(); ++i) {
                    NodeList listDefinition;
                    Node child = list.item(i);
                    if (!"definitions".equals(child.getLocalName()) || (listDefinition = child.getChildNodes()) == null) continue;
                    for (int j = 0; j < listDefinition.getLength(); ++j) {
                        NodeList listTypes;
                        Node childDefinition = listDefinition.item(j);
                        if (!"types".equals(childDefinition.getLocalName()) || (listTypes = childDefinition.getChildNodes()) == null) continue;
                        for (int h = 0; h < listTypes.getLength(); ++h) {
                            List<Node> includesSchemi;
                            List<Node> importsSchemi;
                            Node childTypes = listTypes.item(h);
                            if (!"schema".equals(childTypes.getLocalName())) continue;
                            String targetNamespaceSchema = null;
                            if (targetNamespaceSchema == null) {
                                try {
                                    targetNamespaceSchema = xsdUtils.getTargetNamespace(childTypes);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            if (readImport && (importsSchemi = xsdUtils.readImports(targetNamespaceSchema, childTypes)) != null && importsSchemi.size() > 0) {
                                imports.addAll(importsSchemi);
                            }
                            if (!readInclude || (includesSchemi = xsdUtils.readIncludes(targetNamespaceSchema, childTypes)) == null || includesSchemi.size() <= 0) continue;
                            imports.addAll(includesSchemi);
                        }
                    }
                }
            }
            return imports;
        }
        catch (Exception e) {
            throw new WSDLException("Riscontrato errore durante la lettura del wsdl: " + e.getMessage(), e);
        }
    }

    public List<Node> readImportsAndIncludesFromSchemaXSD(Schema xsd) throws WSDLException {
        try {
            if (this.xmlUtils == null) {
                throw new Exception("XMLUtils not initialized in WSDLUtilities, use static instance 'getInstance(AbstractXMLUtils xmlUtils)'");
            }
            XSDUtils xsdUtils = new XSDUtils(this.xmlUtils);
            return xsdUtils.readImportsAndIncludes(this.getTargetNamespace(xsd), xsd.getElement());
        }
        catch (Exception e) {
            throw new WSDLException(e.getMessage(), e);
        }
    }

    public List<Node> readImportsFromSchemaXSD(Schema xsd) throws WSDLException {
        try {
            if (this.xmlUtils == null) {
                throw new Exception("XMLUtils not initialized in WSDLUtilities, use static instance 'getInstance(AbstractXMLUtils xmlUtils)'");
            }
            XSDUtils xsdUtils = new XSDUtils(this.xmlUtils);
            return xsdUtils.readImports(this.getTargetNamespace(xsd), xsd.getElement());
        }
        catch (Exception e) {
            throw new WSDLException(e.getMessage(), e);
        }
    }

    public List<Node> readIncludesFromSchemaXSD(Schema xsd) throws WSDLException {
        try {
            if (this.xmlUtils == null) {
                throw new Exception("XMLUtils not initialized in WSDLUtilities, use static instance 'getInstance(AbstractXMLUtils xmlUtils)'");
            }
            XSDUtils xsdUtils = new XSDUtils(this.xmlUtils);
            return xsdUtils.readIncludes(this.getTargetNamespace(xsd), xsd.getElement());
        }
        catch (Exception e) {
            throw new WSDLException(e.getMessage(), e);
        }
    }

    public Vector<byte[]> getSchemiXSD(Definition wsdlNormalizzato) throws IOException, TransformerException, XMLException, WSDLException {
        if (this.xmlUtils == null) {
            throw new WSDLException("XMLUtils not initialized in WSDLUtilities, use static instance 'getInstance(AbstractXMLUtils xmlUtils)'");
        }
        Vector<byte[]> v = new Vector<byte[]>();
        Types types = wsdlNormalizzato.getTypes();
        List xsdTypes = types.getExtensibilityElements();
        for (int i = 0; i < xsdTypes.size(); ++i) {
            Schema schema = (Schema)xsdTypes.get(i);
            v.add(this.xmlUtils.toByteArray(schema.getElement()));
        }
        return v;
    }

    public List<Node> getSchemiXSD(Document wsdl) throws WSDLException {
        try {
            if (this.xmlUtils == null) {
                throw new Exception("XMLUtils not initialized in WSDLUtilities, use static instance 'getInstance(AbstractXMLUtils xmlUtils)'");
            }
            XSDUtils xsdUtils = new XSDUtils(this.xmlUtils);
            Vector<Node> schemi = new Vector<Node>();
            NodeList list = wsdl.getChildNodes();
            if (list != null) {
                for (int i = 0; i < list.getLength(); ++i) {
                    NodeList listDefinition;
                    Node child = list.item(i);
                    if (!"definitions".equals(child.getLocalName()) || (listDefinition = child.getChildNodes()) == null) continue;
                    for (int j = 0; j < listDefinition.getLength(); ++j) {
                        NodeList listTypes;
                        Node childDefinition = listDefinition.item(j);
                        if (!"types".equals(childDefinition.getLocalName()) || (listTypes = childDefinition.getChildNodes()) == null) continue;
                        for (int h = 0; h < listTypes.getLength(); ++h) {
                            Node childTypes = listTypes.item(h);
                            if (!"schema".equals(childTypes.getLocalName()) || !xsdUtils.isXSDSchema(childTypes)) continue;
                            schemi.add(childTypes);
                        }
                    }
                }
            }
            return schemi;
        }
        catch (Exception e) {
            throw new WSDLException("Riscontrato errore durante la lettura del wsdl: " + e.getMessage(), e);
        }
    }

    public List<byte[]> getBytesSchemiXSD(Document wsdl) throws WSDLException {
        List<Node> schemi = this.getSchemiXSD(wsdl);
        try {
            if (this.xmlUtils == null) {
                throw new Exception("XMLUtils not initialized in WSDLUtilities, use static instance 'getInstance(AbstractXMLUtils xmlUtils)'");
            }
            ArrayList<byte[]> schemiBytes = new ArrayList<byte[]>();
            if (schemi != null && schemi.size() > 0) {
                for (Node node : schemi) {
                    schemiBytes.add(this.xmlUtils.toByteArray(node));
                }
            }
            return schemiBytes;
        }
        catch (Exception e) {
            throw new WSDLException("Riscontrato errore durante la lettura del wsdl: " + e.getMessage(), e);
        }
    }

    public String normalizzazioneSchemaPerInserimentoInWsdl(Element schemaXSD, Element wsdl, HashMap<String, String> prefixForWSDL, String uniquePrefixWSDL, boolean docImportato, String targetNamespaceParent) throws WSDLException {
        String targetNamespace = null;
        if (docImportato) {
            targetNamespace = this.readPrefixForWsdl(schemaXSD, wsdl, prefixForWSDL, uniquePrefixWSDL, true);
            NamedNodeMap attributi = schemaXSD.getAttributes();
            Vector<Attr> attributiDaMantenere = new Vector<Attr>();
            if (attributi != null && attributi.getLength() > 0) {
                for (int i = attributi.getLength() - 1; i >= 0; --i) {
                    Attr attr = (Attr)attributi.item(i);
                    if (targetNamespace.equals(attr.getNodeValue())) {
                        attributiDaMantenere.add(attr);
                    }
                    this.xmlUtils.removeAttribute(attr, schemaXSD);
                }
            }
            while (attributiDaMantenere.size() > 0) {
                Attr attr = (Attr)attributiDaMantenere.remove(0);
                this.xmlUtils.addAttribute(attr, schemaXSD);
            }
        } else {
            Attr attr;
            targetNamespace = targetNamespaceParent;
            NamedNodeMap attributi = schemaXSD.getAttributes();
            Vector<Attr> attributiDaMantenere = new Vector<Attr>();
            if (attributi != null && attributi.getLength() > 0) {
                for (int i = attributi.getLength() - 1; i >= 0; --i) {
                    attr = (Attr)attributi.item(i);
                    if (targetNamespace.equals(attr.getNodeValue())) {
                        attributiDaMantenere.add(attr);
                    }
                    this.xmlUtils.removeAttribute(attr, schemaXSD);
                }
            }
            boolean foundTargetNamespace = false;
            if (attributiDaMantenere.size() > 0) {
                while (attributiDaMantenere.size() > 0) {
                    attr = (Attr)attributiDaMantenere.remove(0);
                    if ("targetNamespace".equals(attr.getName())) {
                        foundTargetNamespace = true;
                    }
                    this.xmlUtils.addAttribute(attr, schemaXSD);
                }
            }
            if (!foundTargetNamespace) {
                schemaXSD.setAttribute("targetNamespace", targetNamespace);
            }
        }
        return targetNamespace;
    }

    public String readPrefixForWsdl(Element schemaXSD, Element wsdl, HashMap<String, String> prefixForWSDL, String uniquePrefixWSDL, boolean targetNamespaceObbligatorio) throws WSDLException {
        String targetNamespace = null;
        NamedNodeMap attributi = schemaXSD.getAttributes();
        if (attributi != null) {
            NamedNodeMap attributi_wsdl;
            for (int i = 0; i < attributi.getLength(); ++i) {
                Node attr = attributi.item(i);
                if (!"targetNamespace".equals(attr.getLocalName())) continue;
                targetNamespace = attr.getNodeValue();
                break;
            }
            if (targetNamespace == null) {
                if (targetNamespaceObbligatorio) {
                    throw new WSDLException("Target namespace non trovato");
                }
                return null;
            }
            String prefixTargetNamespaceXSD = null;
            for (int i = 0; i < attributi.getLength(); ++i) {
                Node attr = attributi.item(i);
                if (!targetNamespace.equals(attr.getNodeValue()) || !"xmlns".equals(attr.getPrefix())) continue;
                prefixTargetNamespaceXSD = attr.getLocalName();
                break;
            }
            if ((attributi_wsdl = wsdl.getAttributes()) != null) {
                boolean findIntoWSDL = false;
                for (int i = 0; i < attributi_wsdl.getLength(); ++i) {
                    Node attr = attributi_wsdl.item(i);
                    if (!targetNamespace.equals(attr.getNodeValue()) || !"xmlns".equals(attr.getPrefix())) continue;
                    if (prefixTargetNamespaceXSD == null) {
                        findIntoWSDL = attr.getLocalName() == null;
                        break;
                    }
                    if (!prefixTargetNamespaceXSD.equals(attr.getLocalName())) continue;
                    findIntoWSDL = true;
                    break;
                }
                if (!findIntoWSDL) {
                    Object newPrefix = null;
                    newPrefix = prefixTargetNamespaceXSD == null ? (uniquePrefixWSDL != null ? "xmlns:" + uniquePrefixWSDL : "xmlns") : (uniquePrefixWSDL != null ? "xmlns:" + uniquePrefixWSDL + prefixTargetNamespaceXSD : "xmlns:" + prefixTargetNamespaceXSD);
                    schemaXSD.setAttribute((String)newPrefix, targetNamespace);
                    if (!prefixForWSDL.containsKey(newPrefix)) {
                        prefixForWSDL.put((String)newPrefix, targetNamespace);
                    } else {
                        String namespace = prefixForWSDL.get(newPrefix);
                        if (!namespace.equals(targetNamespace)) {
                            throw new WSDLException("Rilevati due prefissi a cui sono stati associati namespace differenti. \nPrefix[" + (String)newPrefix + "]=Namespace[" + namespace + "]\nPrefix[" + (String)newPrefix + "]=Namespace[" + targetNamespace + "]");
                        }
                    }
                }
            }
        }
        return targetNamespace;
    }

    public void removeImports(Document document) {
        this.removeImport(document, null);
    }

    public void removeImport(Document document, Node importNode) {
        NodeList list = document.getChildNodes();
        if (list != null) {
            for (int i = 0; i < list.getLength(); ++i) {
                NodeList listDefinition;
                Node child = list.item(i);
                if (!"definitions".equals(child.getLocalName()) || (listDefinition = child.getChildNodes()) == null) continue;
                for (int j = 0; j < listDefinition.getLength(); ++j) {
                    Node childDefinition = listDefinition.item(j);
                    if (!"import".equals(childDefinition.getLocalName())) continue;
                    if (importNode == null) {
                        child.removeChild(childDefinition);
                        continue;
                    }
                    if (!importNode.equals(childDefinition)) continue;
                    child.removeChild(childDefinition);
                }
            }
        }
    }

    public void removeSchemiIntoTypes(Document document) throws WSDLException {
        try {
            NodeList list = document.getChildNodes();
            if (list != null) {
                for (int i = 0; i < list.getLength(); ++i) {
                    NodeList listDefinition;
                    Node child = list.item(i);
                    if (!"definitions".equals(child.getLocalName()) || (listDefinition = child.getChildNodes()) == null) continue;
                    for (int j = 0; j < listDefinition.getLength(); ++j) {
                        int h;
                        NodeList listTypes;
                        Node childDefinition = listDefinition.item(j);
                        if (!"types".equals(childDefinition.getLocalName()) || (listTypes = childDefinition.getChildNodes()) == null) continue;
                        boolean onlySchemaAndComment = true;
                        for (h = 0; h < listTypes.getLength(); ++h) {
                            Node childTypes = listTypes.item(h);
                            if ("schema".equals(childTypes.getLocalName())) {
                                childDefinition.removeChild(childTypes);
                                continue;
                            }
                            if (childTypes instanceof Text || childTypes instanceof Comment) continue;
                            onlySchemaAndComment = false;
                        }
                        if (!onlySchemaAndComment || (listTypes = childDefinition.getChildNodes()) == null) continue;
                        for (h = 0; h < listTypes.getLength(); ++h) {
                            childDefinition.removeChild(listTypes.item(h));
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            throw new WSDLException("Riscontrato errore durante la lettura del wsdl: " + e.getMessage(), e);
        }
    }

    public void removeTypes(Document wsdl) throws WSDLException {
        try {
            NodeList list = wsdl.getChildNodes();
            if (list != null) {
                for (int i = 0; i < list.getLength(); ++i) {
                    NodeList listDefinition;
                    Node child = list.item(i);
                    if (!"definitions".equals(child.getLocalName()) || (listDefinition = child.getChildNodes()) == null) continue;
                    for (int j = 0; j < listDefinition.getLength(); ++j) {
                        Node childDefinition = listDefinition.item(j);
                        if (!"types".equals(childDefinition.getLocalName())) continue;
                        child.removeChild(childDefinition);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new WSDLException("Riscontrato errore durante la rimozione dell'elemento Types: " + e.getMessage(), e);
        }
    }

    public void removeImportsFromSchemaXSD(Schema xsd) throws WSDLException {
        if (this.xmlUtils == null) {
            throw new WSDLException("XMLUtils not initialized in WSDLUtilities, use static instance 'getInstance(AbstractXMLUtils xmlUtils)'");
        }
        XSDUtils xsdUtils = new XSDUtils(this.xmlUtils);
        xsdUtils.removeImports(xsd.getElement());
    }

    public void removeIncludesFromSchemaXSD(Schema xsd) throws WSDLException {
        if (this.xmlUtils == null) {
            throw new WSDLException("XMLUtils not initialized in WSDLUtilities, use static instance 'getInstance(AbstractXMLUtils xmlUtils)'");
        }
        XSDUtils xsdUtils = new XSDUtils(this.xmlUtils);
        xsdUtils.removeIncludes(xsd.getElement());
    }

    public void removeImportsAndIncludesFromSchemaXSD(Schema xsd) throws WSDLException {
        if (this.xmlUtils == null) {
            throw new WSDLException("XMLUtils not initialized in WSDLUtilities, use static instance 'getInstance(AbstractXMLUtils xmlUtils)'");
        }
        XSDUtils xsdUtils = new XSDUtils(this.xmlUtils);
        xsdUtils.removeImportsAndIncludes(xsd.getElement());
    }

    public void removeAllImports(Definition definition) throws javax.wsdl.WSDLException {
        if (definition == null) {
            throw new javax.wsdl.WSDLException("removeAllImports(Definition definition)", "WSDL non fornito");
        }
        DefinitionWrapper wsdl = new DefinitionWrapper(definition, this.xmlUtils);
        wsdl.removeAllImports();
    }

    public void removeAllMessages(Definition definition) throws javax.wsdl.WSDLException {
        if (definition == null) {
            throw new javax.wsdl.WSDLException("removeAllMessages(Definition definition)", "WSDL non fornito");
        }
        DefinitionWrapper wsdl = new DefinitionWrapper(definition, this.xmlUtils);
        wsdl.removeAllMessages();
    }

    public void removeAllPortTypes(Definition definition) throws javax.wsdl.WSDLException {
        if (definition == null) {
            throw new javax.wsdl.WSDLException("removeAllPortTypes(Definition definition)", "WSDL non fornito");
        }
        DefinitionWrapper wsdl = new DefinitionWrapper(definition, this.xmlUtils);
        wsdl.removeAllPortTypes();
    }

    public void removeAllBindings(Definition definition) throws javax.wsdl.WSDLException {
        if (definition == null) {
            throw new javax.wsdl.WSDLException("removeAllBindings(Definition definition)", "WSDL non fornito");
        }
        DefinitionWrapper wsdl = new DefinitionWrapper(definition, this.xmlUtils);
        wsdl.removeAllBindings();
    }

    public void removeAllServices(Definition definition) throws javax.wsdl.WSDLException {
        if (definition == null) {
            throw new javax.wsdl.WSDLException("removeAllServices(Definition definition)", "WSDL non fornito");
        }
        DefinitionWrapper wsdl = new DefinitionWrapper(definition, this.xmlUtils);
        wsdl.removeAllServices();
    }

    public boolean existsTypes(Document document) throws WSDLException {
        try {
            NodeList list = document.getChildNodes();
            if (list != null) {
                for (int i = 0; i < list.getLength(); ++i) {
                    NodeList listDefinition;
                    Node child = list.item(i);
                    if (!"definitions".equals(child.getLocalName()) || (listDefinition = child.getChildNodes()) == null) continue;
                    for (int j = 0; j < listDefinition.getLength(); ++j) {
                        Node childDefinition = listDefinition.item(j);
                        if (!"types".equals(childDefinition.getLocalName())) continue;
                        return true;
                    }
                }
            }
        }
        catch (Exception e) {
            throw new WSDLException("Riscontrato errore durante la lettura del wsdl: " + e.getMessage(), e);
        }
        return false;
    }

    public Node getIfExistsTypesElementIntoWSDL(Document wsdl) throws WSDLException {
        try {
            NodeList list = wsdl.getChildNodes();
            if (list != null) {
                for (int i = 0; i < list.getLength(); ++i) {
                    NodeList listDefinition;
                    Node child = list.item(i);
                    if (!"definitions".equals(child.getLocalName()) || (listDefinition = child.getChildNodes()) == null) continue;
                    for (int j = 0; j < listDefinition.getLength(); ++j) {
                        Node childDefinition = listDefinition.item(j);
                        if (!"types".equals(childDefinition.getLocalName())) continue;
                        return childDefinition;
                    }
                }
            }
            return null;
        }
        catch (Exception e) {
            throw new WSDLException("Riscontrato errore durante la lettura del wsdl: " + e.getMessage(), e);
        }
    }

    public Node addEmptyTypesIfNotExists(Document document) throws WSDLException {
        try {
            boolean exists = false;
            NodeList list = document.getChildNodes();
            if (list != null) {
                for (int i = 0; i < list.getLength(); ++i) {
                    Node child = list.item(i);
                    if (!"definitions".equals(child.getLocalName())) continue;
                    NodeList listDefinition = child.getChildNodes();
                    if (listDefinition != null) {
                        for (int j = 0; j < listDefinition.getLength(); ++j) {
                            Node childDefinition = listDefinition.item(j);
                            if (!"types".equals(childDefinition.getLocalName())) continue;
                            exists = true;
                            break;
                        }
                    }
                    if (exists) continue;
                    Object name = "types";
                    if (child.getPrefix() != null && !"".equals(child.getPrefix())) {
                        name = child.getPrefix() + ":" + (String)name;
                    }
                    Node n = this.xmlUtils.getFirstNotEmptyChildNode(child, false);
                    Element type = document.createElementNS(child.getNamespaceURI(), (String)name);
                    child.insertBefore(type, n);
                    return type;
                }
            }
            return null;
        }
        catch (Exception e) {
            throw new WSDLException("Riscontrato errore durante la lettura del wsdl: " + e.getMessage(), e);
        }
    }
}

