/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.utils.wadl;

import it.link.pdd.tools.migrazione_govway.utils.resources.FileSystemUtilities;
import it.link.pdd.tools.migrazione_govway.utils.wadl.ApplicationWrapper;
import it.link.pdd.tools.migrazione_govway.utils.wadl.WADLException;
import it.link.pdd.tools.migrazione_govway.utils.wadl.WADLOperation;
import it.link.pdd.tools.migrazione_govway.utils.wadl.WADLReader;
import it.link.pdd.tools.migrazione_govway.utils.xml.AbstractXMLUtils;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.jvnet.ws.wadl.HTTPMethods;
import org.jvnet.ws.wadl.ast.ApplicationNode;
import org.jvnet.ws.wadl.ast.MethodNode;
import org.jvnet.ws.wadl.ast.ResourceNode;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WADLUtilities {
    private AbstractXMLUtils xmlUtils = null;

    public static WADLUtilities getInstance(AbstractXMLUtils xmlUtils) {
        return new WADLUtilities(xmlUtils);
    }

    public WADLUtilities(AbstractXMLUtils xmlUtils) {
        this.xmlUtils = xmlUtils;
    }

    public WADLReader getWADLReader(Logger log, boolean verbose, boolean processInclude, boolean processInlineSchema) {
        return new WADLReader(log, this.xmlUtils, verbose, processInclude, processInlineSchema);
    }

    public boolean isWADL(byte[] wadl) throws WADLException {
        try {
            if (this.xmlUtils == null) {
                throw new Exception("XMLUtils not initialized in WADLUtilities, use static instance 'getInstance(AbstractXMLUtils xmlUtils)'");
            }
            if (!this.xmlUtils.isDocument(wadl)) {
                return false;
            }
            Document docXML = this.xmlUtils.newDocument(wadl);
            Element elemXML = docXML.getDocumentElement();
            return this.isWADL(elemXML);
        }
        catch (Exception e) {
            throw new WADLException(e.getMessage(), e);
        }
    }

    public boolean isWADL(Document wadl) throws WADLException {
        Element elemXML = wadl.getDocumentElement();
        return this.isWADL(elemXML);
    }

    public boolean isWADL(Element wadl) throws WADLException {
        return this.isWADL((Node)wadl);
    }

    public boolean isWADL(Node wadl) throws WADLException {
        try {
            if (wadl == null) {
                throw new Exception("Documento wadl da verificare non definito");
            }
            if (!"application".equals(wadl.getLocalName())) {
                return false;
            }
            return "http://wadl.dev.java.net/2009/02".equals(wadl.getNamespaceURI());
        }
        catch (Exception e) {
            throw new WADLException(e.getMessage(), e);
        }
    }

    public String getTargetNamespace(byte[] xsd) throws WADLException {
        try {
            if (this.xmlUtils == null) {
                throw new Exception("XMLUtils not initialized in WADLUtilities, use static instance 'getInstance(AbstractXMLUtils xmlUtils)'");
            }
            if (!this.xmlUtils.isDocument(xsd)) {
                throw new Exception("Wadl non e' un documento valido");
            }
            Document docXML = this.xmlUtils.newDocument(xsd);
            Element elemXML = docXML.getDocumentElement();
            return this.getTargetNamespace(elemXML);
        }
        catch (Exception e) {
            throw new WADLException(e.getMessage(), e);
        }
    }

    public String getTargetNamespace(Document xsd) throws WADLException {
        Element elemXML = xsd.getDocumentElement();
        return this.getTargetNamespace(elemXML);
    }

    public String getTargetNamespace(Element elemXML) throws WADLException {
        return this.getTargetNamespace((Node)elemXML);
    }

    public String getTargetNamespace(Node elemXML) throws WADLException {
        try {
            if (this.xmlUtils == null) {
                throw new Exception("XMLUtils not initialized in WADLUtilities, use static instance 'getInstance(AbstractXMLUtils xmlUtils)'");
            }
            if (elemXML == null) {
                throw new Exception("Wadl non e' un documento valido");
            }
            if (!"application".equals(elemXML.getLocalName())) {
                throw new Exception("Root element non e' un application wadl (" + elemXML.getLocalName() + ")");
            }
            String targetNamespace = this.xmlUtils.getAttributeValue(elemXML, "targetNamespace");
            return targetNamespace;
        }
        catch (Exception e) {
            throw new WADLException(e.getMessage(), e);
        }
    }

    public ApplicationWrapper readWADLFromFile(Logger log, File file) throws WADLException {
        return this.readWADLFromFile(log, file, false, true, true);
    }

    public ApplicationWrapper readWADLFromFile(Logger log, File file, boolean verbose, boolean processInclude, boolean processInlineSchema) throws WADLException {
        try {
            if (file == null) {
                throw new Exception("Path non definito");
            }
            WADLReader reader = this.getWADLReader(log, verbose, processInclude, processInlineSchema);
            ApplicationNode appNode = reader.readWADL(file.getAbsolutePath());
            ApplicationWrapper ap = new ApplicationWrapper(appNode, reader.getResources(), reader.getMappingNamespaceLocations(), this.xmlUtils);
            return ap;
        }
        catch (Exception e) {
            throw new WADLException("Lettura del wadl non riuscita (File): " + e.getMessage(), e);
        }
    }

    public ApplicationWrapper readWADLFromLocation(Logger log, String path) throws WADLException {
        return this.readWADLFromLocation(log, path, false, true, true);
    }

    public ApplicationWrapper readWADLFromLocation(Logger log, String path, boolean verbose, boolean processInclude, boolean processInlineSchema) throws WADLException {
        try {
            if (path == null) {
                throw new Exception("Path non definito");
            }
            WADLReader reader = this.getWADLReader(log, verbose, processInclude, processInlineSchema);
            ApplicationNode appNode = reader.readWADL(path);
            ApplicationWrapper ap = new ApplicationWrapper(appNode, reader.getResources(), reader.getMappingNamespaceLocations(), this.xmlUtils);
            return ap;
        }
        catch (Exception e) {
            throw new WADLException("Lettura del wadl non riuscita (Path): " + e.getMessage(), e);
        }
    }

    public ApplicationWrapper readWADLFromBytes(Logger log, byte[] wadl) throws WADLException {
        return this.readWADLFromBytes(log, wadl, false, true, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ApplicationWrapper readWADLFromBytes(Logger log, byte[] wadl, boolean verbose, boolean processInclude, boolean processInlineSchema) throws WADLException {
        try {
            if (wadl == null) {
                throw new Exception("Bytes non definiti");
            }
            File tmp = File.createTempFile("wadl", ".tmp");
            try {
                FileSystemUtilities.writeFile(tmp, wadl);
                ApplicationWrapper applicationWrapper = this.readWADLFromFile(log, tmp, verbose, processInclude, processInlineSchema);
                return applicationWrapper;
            }
            catch (WADLException e) {
                throw e;
            }
            finally {
                tmp.delete();
            }
        }
        catch (Exception e) {
            throw new WADLException("Lettura del wadl non riuscita (byte[]): " + e.getMessage(), e);
        }
    }

    public ApplicationWrapper readWADLFromDocument(Logger log, Document doc) throws WADLException {
        return this.readWADLFromDocument(log, doc, false, true, true);
    }

    public ApplicationWrapper readWADLFromDocument(Logger log, Document doc, boolean verbose, boolean processInclude, boolean processInlineSchema) throws WADLException {
        try {
            if (this.xmlUtils == null) {
                throw new Exception("XMLUtils not initialized in WADLUtilities, use static instance 'getInstance(AbstractXMLUtils xmlUtils)'");
            }
            if (doc == null) {
                throw new Exception("Document non definito");
            }
            byte[] wadl = this.xmlUtils.toByteArray(doc);
            return this.readWADLFromBytes(log, wadl, verbose, processInclude, processInlineSchema);
        }
        catch (Exception e) {
            throw new WADLException("Lettura del wadl non riuscita (Document): " + e.getMessage(), e);
        }
    }

    public ApplicationWrapper readWADLFromDocument(Logger log, Element elem) throws WADLException {
        return this.readWADLFromDocument(log, elem, false, true, true);
    }

    public ApplicationWrapper readWADLFromDocument(Logger log, Element elem, boolean verbose, boolean processInclude, boolean processInlineSchema) throws WADLException {
        try {
            if (this.xmlUtils == null) {
                throw new Exception("XMLUtils not initialized in WADLUtilities, use static instance 'getInstance(AbstractXMLUtils xmlUtils)'");
            }
            if (elem == null) {
                throw new Exception("Element non definito");
            }
            byte[] wadl = this.xmlUtils.toByteArray(elem);
            return this.readWADLFromBytes(log, wadl, verbose, processInclude, processInlineSchema);
        }
        catch (Exception e) {
            throw new WADLException("Lettura del wadl non riuscita (Document): " + e.getMessage(), e);
        }
    }

    public ApplicationWrapper readWADLFromURI(Logger log, URI uri) throws WADLException {
        return this.readWADLFromURI(log, uri, false, true, true);
    }

    public ApplicationWrapper readWADLFromURI(Logger log, URI uri, boolean verbose, boolean processInclude, boolean processInlineSchema) throws WADLException {
        try {
            if (uri == null) {
                throw new Exception("URI non definita");
            }
            WADLReader reader = this.getWADLReader(log, verbose, processInclude, processInlineSchema);
            ApplicationNode appNode = reader.readWADL(uri);
            ApplicationWrapper ap = new ApplicationWrapper(appNode, reader.getResources(), reader.getMappingNamespaceLocations(), this.xmlUtils);
            return ap;
        }
        catch (Exception e) {
            throw new WADLException("Lettura del wadl non riuscita (URI): " + e.getMessage(), e);
        }
    }

    public Node getIfExistsApplicationElementIntoWADL(Document wadl) throws WADLException {
        try {
            NodeList list = wadl.getChildNodes();
            if (list != null) {
                for (int i = 0; i < list.getLength(); ++i) {
                    Node child = list.item(i);
                    if (!"application".equals(child.getLocalName())) continue;
                    return child;
                }
            }
            return null;
        }
        catch (Exception e) {
            throw new WADLException("Riscontrato errore durante la lettura del wadl: " + e.getMessage(), e);
        }
    }

    public Node getIfExistsGrammarsElementIntoWADL(Document wadl) throws WADLException {
        try {
            NodeList list = wadl.getChildNodes();
            if (list != null) {
                for (int i = 0; i < list.getLength(); ++i) {
                    NodeList listDefinition;
                    Node child = list.item(i);
                    if (!"application".equals(child.getLocalName()) || (listDefinition = child.getChildNodes()) == null) continue;
                    for (int j = 0; j < listDefinition.getLength(); ++j) {
                        Node childDefinition = listDefinition.item(j);
                        if (!"grammars".equals(childDefinition.getLocalName())) continue;
                        return childDefinition;
                    }
                }
            }
            return null;
        }
        catch (Exception e) {
            throw new WADLException("Riscontrato errore durante la lettura del wadl: " + e.getMessage(), e);
        }
    }

    public List<Node> readIncludes(Document wadl) throws WADLException {
        try {
            Vector<Node> includes = new Vector<Node>();
            NodeList list = wadl.getChildNodes();
            if (list != null) {
                for (int i = 0; i < list.getLength(); ++i) {
                    NodeList listDefinition;
                    Node child = list.item(i);
                    if (!"application".equals(child.getLocalName()) || (listDefinition = child.getChildNodes()) == null) continue;
                    for (int j = 0; j < listDefinition.getLength(); ++j) {
                        NodeList listGrammars;
                        Node childDefinition = listDefinition.item(j);
                        if (!"grammars".equals(childDefinition.getLocalName()) || (listGrammars = childDefinition.getChildNodes()) == null) continue;
                        for (int k = 0; k < listGrammars.getLength(); ++k) {
                            Node childGrammar = listGrammars.item(k);
                            if (!"include".equals(childGrammar.getLocalName())) continue;
                            includes.add(childGrammar);
                        }
                    }
                }
            }
            return includes;
        }
        catch (Exception e) {
            throw new WADLException("Riscontrato errore durante la lettura del wadl: " + e.getMessage(), e);
        }
    }

    public List<Node> removeIncludes(Document wadl) throws WADLException {
        try {
            Vector<Node> includes = new Vector<Node>();
            NodeList list = wadl.getChildNodes();
            if (list != null) {
                for (int i = 0; i < list.getLength(); ++i) {
                    NodeList listDefinition;
                    Node child = list.item(i);
                    if (!"application".equals(child.getLocalName()) || (listDefinition = child.getChildNodes()) == null) continue;
                    for (int j = 0; j < listDefinition.getLength(); ++j) {
                        NodeList listGrammars;
                        Node childDefinition = listDefinition.item(j);
                        if (!"grammars".equals(childDefinition.getLocalName()) || (listGrammars = childDefinition.getChildNodes()) == null) continue;
                        for (int k = 0; k < listGrammars.getLength(); ++k) {
                            Node childGrammar = listGrammars.item(k);
                            if (!"include".equals(childGrammar.getLocalName())) continue;
                            includes.add(childGrammar);
                            childDefinition.removeChild(childGrammar);
                        }
                    }
                }
            }
            return includes;
        }
        catch (Exception e) {
            throw new WADLException("Riscontrato errore durante la lettura del wadl: " + e.getMessage(), e);
        }
    }

    public static ResourceNode findResourceNode(ApplicationNode application, String url) throws WADLException {
        if (application == null) {
            throw new WADLException("ApplicationNode non fornita");
        }
        return WADLUtilities.findResourceNode(application.getResources(), url);
    }

    private static ResourceNode findResourceNode(List<ResourceNode> resources, String url) throws WADLException {
        String baseURI = null;
        for (int i = 0; i < resources.size() && baseURI == null; ++i) {
            ResourceNode resourceNode = resources.get(i);
            if (baseURI != null || !resourceNode.getAllResourceUriTemplate().equals("/")) continue;
            baseURI = resourceNode.getUriTemplate();
        }
        String[] urlList = WADLUtilities.extractUrlList(baseURI, url);
        return WADLUtilities.getResourceNode(urlList, 0, resources);
    }

    private static String[] extractUrlList(String baseURI, String url) throws WADLException {
        if (url == null) {
            throw new WADLException("URL non fornita");
        }
        ArrayList<Object> urlList = new ArrayList<Object>();
        if (baseURI != null) {
            urlList.add(baseURI);
            if (url.startsWith(baseURI)) {
                url = url.substring(baseURI.length(), url.length());
            }
        }
        for (String s : url.split("/")) {
            if (s.equals("")) continue;
            urlList.add("/" + s);
        }
        return urlList.toArray(new String[0]);
    }

    public static boolean isTemplate(String partialURL) {
        String realPartialUrl = partialURL;
        if (realPartialUrl.startsWith("/")) {
            realPartialUrl = realPartialUrl.substring(1);
        }
        return realPartialUrl.startsWith("$");
    }

    public static WADLOperation findOperation(List<WADLOperation> operations, String url, HTTPMethods method) throws WADLException {
        String[] urlSplit = WADLUtilities.extractUrlList(null, url);
        for (WADLOperation op : operations) {
            String[] urlList = WADLUtilities.extractUrlList(null, op.getPath());
            ArrayList<WADLOperation> lst = new ArrayList<WADLOperation>();
            WADLOperation root = WADLUtilities.getTreeWadlOperation(op, urlList[0]);
            lst.add(root);
            for (int i = 1; i < urlList.length; ++i) {
                WADLOperation wadlOp = WADLUtilities.getTreeWadlOperation(root, urlList[i]);
                lst.add(wadlOp);
            }
            WADLOperation found = WADLUtilities.getWADLOperation(urlSplit, 0, lst, method);
            if (found == null) continue;
            return found;
        }
        throw new WADLException("Risorsa [" + url + "] non definita");
    }

    private static WADLOperation getTreeWadlOperation(WADLOperation father, String url) {
        WADLOperation child = new WADLOperation();
        child.setMethod(father.getMethod());
        child.setName(father.getName());
        child.setPath(url);
        child.setTemplate(WADLUtilities.isTemplate(url));
        return child;
    }

    private static WADLOperation getWADLOperation(String[] url, int index, List<WADLOperation> operations, HTTPMethods method) throws WADLException {
        if (url.length != operations.size()) {
            return null;
        }
        WADLOperation operationFound = null;
        if (method.equals((Object)operations.get(index).getMethod())) {
            if (operations.get(index).getPath().equals(url[index])) {
                operationFound = operations.get(index);
            } else if (operations.get(index).isTemplate()) {
                operationFound = operations.get(index);
            }
        }
        if (operationFound != null) {
            if (index < url.length - 1) {
                WADLOperation rn = WADLUtilities.getWADLOperation(url, index + 1, operations, method);
                if (rn != null) {
                    return rn;
                }
            } else {
                return operationFound;
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static ResourceNode getResourceNode(String[] url, int index, List<ResourceNode> resources) throws WADLException {
        ResourceNode resourceFound = null;
        for (int i = 0; i < resources.size() && resourceFound == null; ++i) {
            ResourceNode resourceNode = resources.get(i);
            if (resourceNode.getPathSegment().getTemplate().equals(url[index])) {
                resourceFound = resourceNode;
                continue;
            }
            if (resourceNode.getPathSegment().getTemplateParameters().size() <= 0) continue;
            resourceFound = resourceNode;
        }
        if (resourceFound != null) {
            if (index >= url.length - 1) return resourceFound;
            ResourceNode rn = WADLUtilities.getResourceNode(url, index + 1, resourceFound.getChildResources());
            if (rn == null) return null;
            return rn;
        }
        Object urlString = "";
        for (String s : url) {
            urlString = (String)urlString + s;
        }
        throw new WADLException("Risorsa [" + (String)urlString + "] non definita");
    }

    public static MethodNode findMethodNode(ResourceNode resourceNode, HTTPMethods httpMethod) throws WADLException {
        if (httpMethod == null) {
            throw new WADLException("Metodo HTTP da cercare non fornito");
        }
        for (MethodNode method : resourceNode.getMethods()) {
            if (!httpMethod.value().equals(method.getName())) continue;
            return method;
        }
        throw new WADLException("Metodo [" + httpMethod + "] non definito per la risorsa [" + resourceNode.getAllResourceUriTemplate() + "]");
    }
}

