/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.utils.wadl;

import it.link.pdd.tools.migrazione_govway.utils.Utilities;
import it.link.pdd.tools.migrazione_govway.utils.xml.AbstractXMLUtils;
import it.link.pdd.tools.migrazione_govway.utils.xml.XMLException;
import it.link.pdd.tools.migrazione_govway.utils.xml.XSDUtils;
import java.util.Hashtable;
import org.jvnet.ws.wadl.ast.WadlAstBuilder;
import org.slf4j.Logger;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class SchemaCallback
implements WadlAstBuilder.SchemaCallback {
    private Hashtable<String, byte[]> resources = new Hashtable();
    private Hashtable<String, String> mappingNamespaceLocations = new Hashtable();
    private Logger log;
    private AbstractXMLUtils xmlUtils = null;
    private XSDUtils xsdUtils = null;
    private boolean processInclude;
    private boolean processInlineSchema;

    public SchemaCallback(Logger log, AbstractXMLUtils xmlUtils, boolean processInclude, boolean processInlineSchema) {
        this.log = log;
        this.xmlUtils = xmlUtils;
        this.xsdUtils = new XSDUtils(this.xmlUtils);
        this.processInclude = processInclude;
        this.processInlineSchema = processInlineSchema;
    }

    public void processSchema(InputSource isSource) {
        if (this.processInclude) {
            try {
                String publicId = isSource.getPublicId();
                String systemId = isSource.getSystemId();
                byte[] resource = Utilities.getAsByteArray(isSource.getByteStream());
                this.addResource(this.xsdUtils.getBaseNameXSDLocation(systemId), resource);
                if (this.log != null) {
                    this.log.debug("SCHEMA CALLBACK (import) [" + publicId + "]  [" + systemId + "] ");
                } else {
                    System.out.println("SCHEMA CALLBACK (import) [" + publicId + "]  [" + systemId + "] ");
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
    }

    public void processSchema(String systemId, Element element) {
        if (this.processInlineSchema) {
            try {
                byte[] resource = this.xmlUtils.toByteArray(element);
                this.addResource(this.xsdUtils.getBaseNameXSDLocation(systemId), resource);
                if (this.log != null) {
                    this.log.debug("SCHEMA CALLBACK (inline) [" + systemId + "] ");
                } else {
                    System.out.println("SCHEMA CALLBACK (inline) [" + systemId + "] ");
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
    }

    public Hashtable<String, byte[]> getResources() {
        return this.resources;
    }

    public Hashtable<String, String> getMappingNamespaceLocations() {
        return this.mappingNamespaceLocations;
    }

    public void addResource(String systemId, byte[] resource) throws XMLException {
        if (!this.resources.containsKey(systemId)) {
            this.resources.put(systemId, resource);
            this.xsdUtils.registraMappingNamespaceLocations(resource, systemId, this.mappingNamespaceLocations);
        }
    }
}

