/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.utils.wadl;

import it.link.pdd.tools.migrazione_govway.utils.xml.AbstractXMLUtils;
import it.link.pdd.tools.migrazione_govway.utils.xml.XMLException;
import it.link.pdd.tools.migrazione_govway.utils.xml.XSDSchemaCollection;
import it.link.pdd.tools.migrazione_govway.utils.xml.XSDUtils;
import java.util.Hashtable;
import org.jvnet.ws.wadl.ast.ApplicationNode;
import org.slf4j.Logger;

public class ApplicationWrapper {
    private ApplicationNode applicationNode;
    private Hashtable<String, byte[]> resources = new Hashtable();
    private Hashtable<String, String> mappingNamespaceLocations = new Hashtable();
    private AbstractXMLUtils xmlUtils = null;
    private XSDUtils xsdUtils = null;

    public ApplicationWrapper(ApplicationNode applicationNode, Hashtable<String, byte[]> resources, Hashtable<String, String> mappingNamespaceLocations, AbstractXMLUtils xmlUtils) {
        this.applicationNode = applicationNode;
        this.resources = resources;
        this.mappingNamespaceLocations = mappingNamespaceLocations;
        this.xmlUtils = xmlUtils;
        this.xsdUtils = new XSDUtils(this.xmlUtils);
    }

    public ApplicationNode getApplicationNode() {
        return this.applicationNode;
    }

    public Hashtable<String, byte[]> getResources() {
        return this.resources;
    }

    public Hashtable<String, String> getMappingNamespaceLocations() {
        return this.mappingNamespaceLocations;
    }

    public void addResource(String systemId, byte[] resource) throws XMLException {
        if (!this.resources.containsKey(systemId)) {
            this.resources.put(systemId, resource);
            this.xsdUtils.registraMappingNamespaceLocations(resource, systemId, this.mappingNamespaceLocations);
        }
    }

    public XSDSchemaCollection buildSchemaCollection(Logger log) throws XMLException {
        return this.xsdUtils.buildSchemaCollection(this.resources, this.mappingNamespaceLocations, log);
    }
}

