/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.utils.sql;

import it.link.pdd.tools.migrazione_govway.utils.TipiDatabase;
import it.link.pdd.tools.migrazione_govway.utils.sql.EscapeSQLConfiguration;
import it.link.pdd.tools.migrazione_govway.utils.sql.ISQLQueryObject;
import it.link.pdd.tools.migrazione_govway.utils.sql.SQLQueryObjectCore;
import it.link.pdd.tools.migrazione_govway.utils.sql.SQLQueryObjectException;
import java.util.Iterator;
import java.util.Random;

public class SQLServerQueryObject
extends SQLQueryObjectCore {
    public SQLServerQueryObject(TipiDatabase tipoDatabase) {
        super(tipoDatabase);
    }

    @Override
    protected boolean continueNormalizeField(String normalizeField) {
        return normalizeField == null || !normalizeField.contains("(CAST(DATEDIFF(s, '1970-01-01 00:00:00',") || !normalizeField.contains("as BIGINT)*1000) + (DATEPART(ms");
    }

    @Override
    public String getUnixTimestampConversion(String column) {
        return "(CAST(DATEDIFF(s, '1970-01-01 00:00:00', " + column + ") as BIGINT)*1000) + (DATEPART(ms," + column + "))";
    }

    @Override
    public String getDiffUnixTimestamp(String columnMax, String columnMin) {
        return "( " + this.getUnixTimestampConversion(columnMax) + " - " + this.getUnixTimestampConversion(columnMin) + " )";
    }

    @Override
    public ISQLQueryObject addSelectAvgTimestampField(String field, String alias) throws SQLQueryObjectException {
        if (field == null) {
            throw new SQLQueryObjectException("field avg non puo' essere null");
        }
        String fieldSQL = "avg(" + this.getUnixTimestampConversion(field) + ")";
        if (alias != null) {
            fieldSQL = fieldSQL + this.getDefaultAliasFieldKeyword() + alias;
        }
        this._engine_addSelectField(null, fieldSQL, null, false, true);
        this.fieldNames.add(alias);
        return this;
    }

    @Override
    public ISQLQueryObject addSelectMaxTimestampField(String field, String alias) throws SQLQueryObjectException {
        if (field == null) {
            throw new SQLQueryObjectException("field avg non puo' essere null");
        }
        String fieldSQL = "max(" + this.getUnixTimestampConversion(field) + ")";
        if (alias != null) {
            fieldSQL = fieldSQL + this.getDefaultAliasFieldKeyword() + alias;
        }
        this._engine_addSelectField(null, fieldSQL, null, false, true);
        this.fieldNames.add(alias);
        return this;
    }

    @Override
    public ISQLQueryObject addSelectMinTimestampField(String field, String alias) throws SQLQueryObjectException {
        if (field == null) {
            throw new SQLQueryObjectException("field avg non puo' essere null");
        }
        String fieldSQL = "min(" + this.getUnixTimestampConversion(field) + ")";
        if (alias != null) {
            fieldSQL = fieldSQL + this.getDefaultAliasFieldKeyword() + alias;
        }
        this._engine_addSelectField(null, fieldSQL, null, false, true);
        this.fieldNames.add(alias);
        return this;
    }

    @Override
    public ISQLQueryObject addSelectSumTimestampField(String field, String alias) throws SQLQueryObjectException {
        if (field == null) {
            throw new SQLQueryObjectException("field avg non puo' essere null");
        }
        String fieldSQL = "sum(" + this.getUnixTimestampConversion(field) + ")";
        if (alias != null) {
            fieldSQL = fieldSQL + this.getDefaultAliasFieldKeyword() + alias;
        }
        this._engine_addSelectField(null, fieldSQL, null, false, true);
        this.fieldNames.add(alias);
        return this;
    }

    @Override
    public ISQLQueryObject addFromTable(ISQLQueryObject subSelect) throws SQLQueryObjectException {
        StringBuffer bf = new StringBuffer();
        bf.append(" ( ");
        bf.append(subSelect.createSQLQuery());
        bf.append(" ) ");
        StringBuffer subselectalias = new StringBuffer();
        subselectalias.append("tabella");
        Random rand = new Random();
        for (int count = 0; count < 3; ++count) {
            int rnd = rand.nextInt(52);
            int base = rnd < 26 ? 65 : 97;
            subselectalias.append((char)(base + rnd % 26));
        }
        this.addFromTable(bf.toString(), subselectalias.toString());
        return this;
    }

    @Override
    protected EscapeSQLConfiguration getEscapeSQLConfiguration() {
        EscapeSQLConfiguration config = new EscapeSQLConfiguration();
        config.addCharacter('_');
        config.addCharacter('%');
        config.addCharacter('\\');
        config.addCharacter('[');
        config.addCharacter(']');
        config.addCharacter('^');
        config.setUseEscapeClausole(true);
        config.setEscape('\\');
        config.addCharacterWithOtherEscapeChar('\'', '\'');
        return config;
    }

    @Override
    public String createSQLQuery() throws SQLQueryObjectException {
        return this.createSQLQuery(false);
    }

    private String createSQLQuery(boolean union) throws SQLQueryObjectException {
        this.precheckBuildQuery();
        StringBuffer bf = new StringBuffer();
        bf.append("SELECT ");
        if (this.isSelectDistinct()) {
            bf.append(" DISTINCT ");
        }
        if (this.offset < 0 && this.limit > 0) {
            bf.append(" TOP ");
            bf.append(this.limit);
            bf.append(" ");
        } else {
            bf.append("TOP 100 PERCENT ");
        }
        if (!(this.offset >= 0 || this.limit >= 0)) {
            Iterator itForceIndex = this.forceIndexTableNames.iterator();
            while (itForceIndex.hasNext()) {
                bf.append(" " + (String)itForceIndex.next() + " ");
            }
        }
        if (this.fields.size() == 0) {
            bf.append("*");
        } else {
            Iterator it = this.fields.iterator();
            boolean first = true;
            while (it.hasNext()) {
                if (!first) {
                    bf.append(",");
                } else {
                    first = false;
                }
                String field = (String)it.next();
                if (this.offset >= 0) {
                    field = this.normalizeField(field, false);
                }
                bf.append(field);
            }
        }
        bf.append(this.getSQL(false, false, false, union));
        return bf.toString();
    }

    @Override
    public String _createSQLDelete() throws SQLQueryObjectException {
        StringBuffer bf = new StringBuffer();
        bf.append("DELETE ");
        bf.append(this.getSQL(true, false, false, false));
        return bf.toString();
    }

    private String getSQL(boolean delete, boolean update, boolean conditions, boolean union) throws SQLQueryObjectException {
        StringBuffer bf = new StringBuffer();
        if (this.selectForUpdate) {
            this.checkSelectForUpdate(update, delete, union);
        }
        if (!update && !conditions) {
            bf.append(" FROM ");
            if (this.offset >= 0 && !delete) {
                int rnd;
                int count;
                boolean sortTypeAsc;
                String f;
                boolean first;
                Iterator it;
                bf.append(" ( SELECT ");
                Iterator itForceIndex = this.forceIndexTableNames.iterator();
                while (itForceIndex.hasNext()) {
                    bf.append(" " + (String)itForceIndex.next() + " ");
                }
                if (this.isSelectDistinct()) {
                    if (this.fields.size() == 0) {
                        bf.append("*");
                    } else {
                        it = this.fields.iterator();
                        first = true;
                        while (it.hasNext()) {
                            if (!first) {
                                bf.append(",");
                            } else {
                                first = false;
                            }
                            String field = (String)it.next();
                            if (this.offset >= 0) {
                                field = this.normalizeField(field, false);
                            }
                            bf.append(field);
                        }
                    }
                } else if (this.fields.size() == 0) {
                    bf.append("*");
                } else {
                    it = this.fields.iterator();
                    first = true;
                    while (it.hasNext()) {
                        if (!first) {
                            bf.append(",");
                        } else {
                            first = false;
                        }
                        f = (String)it.next();
                        bf.append(f);
                    }
                }
                bf.append(" , ROW_NUMBER() OVER ( ORDER BY ");
                if (this.orderBy.size() == 0) {
                    throw new SQLQueryObjectException("Condizioni di OrderBy richieste");
                }
                if (this.orderBy.size() > 0) {
                    it = this.orderBy.iterator();
                    first = true;
                    while (it.hasNext()) {
                        if (!first) {
                            bf.append(",");
                        } else {
                            first = false;
                        }
                        String condizione = (String)it.next();
                        if (this.alias.containsKey(condizione)) {
                            if (this.isSelectDistinct()) {
                                bf.append(condizione);
                            } else {
                                bf.append((String)this.alias.get(condizione));
                            }
                        } else {
                            bf.append(this.normalizeField(condizione, false));
                        }
                        sortTypeAsc = this.sortTypeAsc;
                        if (this.orderBySortType.containsKey(condizione)) {
                            sortTypeAsc = (Boolean)this.orderBySortType.get(condizione);
                        }
                        if (sortTypeAsc) {
                            bf.append(" ASC ");
                            continue;
                        }
                        bf.append(" DESC ");
                    }
                }
                bf.append(" ) AS rowNumber ");
                bf.append(" FROM ");
                if (this.isSelectDistinct()) {
                    bf.append(" ( SELECT DISTINCT TOP 100 PERCENT ");
                    if (this.fields.size() == 0) {
                        bf.append("*");
                    } else {
                        it = this.fields.iterator();
                        first = true;
                        while (it.hasNext()) {
                            if (!first) {
                                bf.append(",");
                            } else {
                                first = false;
                            }
                            f = (String)it.next();
                            bf.append(f);
                        }
                    }
                    bf.append(" FROM ");
                }
                if (this.tables.size() == 0) {
                    throw new SQLQueryObjectException("Tabella di ricerca (... FROM Table ...) non definita");
                }
                it = this.tables.iterator();
                first = true;
                while (it.hasNext()) {
                    if (!first) {
                        bf.append(",");
                    } else {
                        first = false;
                    }
                    bf.append((String)it.next());
                }
                if (this.conditions.size() > 0) {
                    bf.append(" WHERE ");
                    if (this.notBeforeConditions) {
                        bf.append(" NOT ( ");
                    }
                    for (int i = 0; i < this.conditions.size(); ++i) {
                        if (i > 0) {
                            if (this.andLogicOperator) {
                                bf.append(" AND ");
                            } else {
                                bf.append(" OR ");
                            }
                        }
                        String cond = (String)this.conditions.get(i);
                        bf.append(cond);
                    }
                    if (this.notBeforeConditions) {
                        bf.append(" )");
                    }
                }
                if (this.getGroupByConditions().size() > 0 && !delete) {
                    bf.append(" GROUP BY ");
                    Iterator<String> it2 = this.getGroupByConditions().iterator();
                    first = true;
                    while (it2.hasNext()) {
                        if (!first) {
                            bf.append(",");
                        } else {
                            first = false;
                        }
                        bf.append(it2.next());
                    }
                }
                if (this.isSelectDistinct()) {
                    if (this.orderBy.size() > 0 && !delete) {
                        bf.append(" ORDER BY ");
                        Iterator it3 = this.orderBy.iterator();
                        first = true;
                        while (it3.hasNext()) {
                            String column = (String)it3.next();
                            if (!first) {
                                bf.append(",");
                            } else {
                                first = false;
                            }
                            bf.append(column);
                            sortTypeAsc = this.sortTypeAsc;
                            if (this.orderBySortType.containsKey(column)) {
                                sortTypeAsc = (Boolean)this.orderBySortType.get(column);
                            }
                            if (sortTypeAsc) {
                                bf.append(" ASC ");
                                continue;
                            }
                            bf.append(" DESC ");
                        }
                    }
                    bf.append(" ) ");
                    bf.append(this.getDefaultAliasFieldKeyword());
                    bf.append("tableSelectRaw");
                    Random rand = new Random();
                    for (count = 0; count < 3; ++count) {
                        rnd = rand.nextInt(52);
                        int base = rnd < 26 ? 65 : 97;
                        bf.append((char)(base + rnd % 26));
                    }
                }
                bf.append(" ) ");
                bf.append(this.getDefaultAliasFieldKeyword());
                bf.append("tabella");
                Random rand = new Random();
                for (count = 0; count < 3; ++count) {
                    rnd = rand.nextInt(52);
                    int base = rnd < 26 ? 65 : 97;
                    bf.append((char)(base + rnd % 26));
                }
                bf.append(" WHERE ( ");
                if (this.offset >= 0) {
                    bf.append(" rowNumber > ");
                    bf.append(this.offset);
                }
                if (this.limit >= 0) {
                    if (this.offset >= 0) {
                        bf.append(" AND");
                    }
                    bf.append(" rowNumber <=  ");
                    if (this.offset >= 0) {
                        bf.append(this.offset + this.limit);
                    } else {
                        bf.append(this.limit);
                    }
                }
                bf.append(" )");
                if (!union && this.orderBy.size() > 0) {
                    bf.append(" ORDER BY ");
                    Iterator it4 = this.orderBy.iterator();
                    boolean first2 = true;
                    while (it4.hasNext()) {
                        if (!first2) {
                            bf.append(",");
                        } else {
                            first2 = false;
                        }
                        String originalField = (String)it4.next();
                        String field = this.normalizeField(originalField);
                        bf.append(field);
                        boolean sortTypeAsc2 = this.sortTypeAsc;
                        if (this.orderBySortType.containsKey(originalField)) {
                            sortTypeAsc2 = (Boolean)this.orderBySortType.get(originalField);
                        }
                        if (sortTypeAsc2) {
                            bf.append(" ASC ");
                            continue;
                        }
                        bf.append(" DESC ");
                    }
                }
            } else {
                if (this.tables.size() == 0) {
                    throw new SQLQueryObjectException("Tabella di ricerca (... FROM Table ...) non definita");
                }
                if (delete && this.tables.size() > 2) {
                    throw new SQLQueryObjectException("Non e' possibile effettuare una delete con piu' di una tabella alla volta");
                }
                Iterator it = this.tables.iterator();
                boolean first = true;
                while (it.hasNext()) {
                    if (!first) {
                        bf.append(",");
                    } else {
                        first = false;
                    }
                    bf.append((String)it.next());
                }
                if (this.selectForUpdate) {
                    bf.append(" WITH (ROWLOCK) ");
                }
                if (this.conditions.size() > 0) {
                    bf.append(" WHERE ");
                    if (this.notBeforeConditions) {
                        bf.append("NOT (");
                    }
                    for (int i = 0; i < this.conditions.size(); ++i) {
                        if (i > 0) {
                            if (this.andLogicOperator) {
                                bf.append(" AND ");
                            } else {
                                bf.append(" OR ");
                            }
                        }
                        bf.append((String)this.conditions.get(i));
                    }
                    if (this.notBeforeConditions) {
                        bf.append(")");
                    }
                }
                if (this.getGroupByConditions().size() > 0 && !delete) {
                    bf.append(" GROUP BY ");
                    Iterator<String> it5 = this.getGroupByConditions().iterator();
                    first = true;
                    while (it5.hasNext()) {
                        if (!first) {
                            bf.append(",");
                        } else {
                            first = false;
                        }
                        bf.append(it5.next());
                    }
                }
                if (!union && this.orderBy.size() > 0 && !delete) {
                    bf.append(" ORDER BY ");
                    Iterator it6 = this.orderBy.iterator();
                    first = true;
                    while (it6.hasNext()) {
                        String column = (String)it6.next();
                        if (!first) {
                            bf.append(",");
                        } else {
                            first = false;
                        }
                        bf.append(column);
                        boolean sortTypeAsc = this.sortTypeAsc;
                        if (this.orderBySortType.containsKey(column)) {
                            sortTypeAsc = (Boolean)this.orderBySortType.get(column);
                        }
                        if (sortTypeAsc) {
                            bf.append(" ASC ");
                            continue;
                        }
                        bf.append(" DESC ");
                    }
                }
            }
        } else if (this.conditions.size() > 0) {
            if (!conditions) {
                bf.append(" WHERE ");
            }
            if (this.notBeforeConditions) {
                bf.append("NOT (");
            }
            for (int i = 0; i < this.conditions.size(); ++i) {
                if (i > 0) {
                    if (this.andLogicOperator) {
                        bf.append(" AND ");
                    } else {
                        bf.append(" OR ");
                    }
                }
                bf.append((String)this.conditions.get(i));
            }
            if (this.notBeforeConditions) {
                bf.append(")");
            }
        }
        return bf.toString();
    }

    @Override
    public String createSQLUnion(boolean unionAll, ISQLQueryObject ... sqlQueryObject) throws SQLQueryObjectException {
        this.checkUnionField(false, sqlQueryObject);
        if (this.selectForUpdate) {
            this.checkSelectForUpdate(false, false, true);
        }
        StringBuffer bf = new StringBuffer();
        if (this.offset >= 0) {
            int i;
            boolean first;
            Iterator it;
            bf.append("SELECT TOP 100 PERCENT * from ");
            bf.append(" ( SELECT ");
            if (this.fields.size() == 0) {
                bf.append("*");
            } else {
                it = this.fields.iterator();
                first = true;
                while (it.hasNext()) {
                    if (!first) {
                        bf.append(",");
                    } else {
                        first = false;
                    }
                    String f = (String)it.next();
                    bf.append(f);
                }
            }
            bf.append(" , ROW_NUMBER() OVER ( ORDER BY ");
            if (this.orderBy.size() == 0) {
                throw new SQLQueryObjectException("Condizioni di OrderBy richieste");
            }
            if (this.orderBy.size() > 0) {
                it = this.orderBy.iterator();
                first = true;
                while (it.hasNext()) {
                    if (!first) {
                        bf.append(",");
                    } else {
                        first = false;
                    }
                    String condizione = (String)it.next();
                    if (this.alias.containsKey(condizione)) {
                        bf.append((String)this.alias.get(condizione));
                    } else {
                        bf.append(condizione);
                    }
                    boolean sortTypeAsc = this.sortTypeAsc;
                    if (this.orderBySortType.containsKey(condizione)) {
                        sortTypeAsc = (Boolean)this.orderBySortType.get(condizione);
                    }
                    if (sortTypeAsc) {
                        bf.append(" ASC ");
                        continue;
                    }
                    bf.append(" DESC ");
                }
            }
            bf.append(" ) AS rowNumber ");
            bf.append(" FROM ( ");
            for (i = 0; i < sqlQueryObject.length; ++i) {
                if (((SQLServerQueryObject)sqlQueryObject[i]).selectForUpdate) {
                    try {
                        ((SQLServerQueryObject)sqlQueryObject[i]).checkSelectForUpdate(false, false, true);
                    }
                    catch (Exception e) {
                        throw new SQLQueryObjectException("Parametro SqlQueryObject[" + i + "] non valido: " + e.getMessage());
                    }
                }
                if (i > 0) {
                    bf.append(" UNION ");
                    if (unionAll) {
                        bf.append(" ALL ");
                    }
                }
                bf.append("( ");
                bf.append(((SQLServerQueryObject)sqlQueryObject[i]).createSQLQuery(true));
                bf.append(") ");
            }
            bf.append(" ) as subquery" + this.getSerial() + " ");
            if (this.conditions.size() > 0) {
                bf.append(" WHERE ");
                if (this.notBeforeConditions) {
                    bf.append(" NOT ( ");
                }
                for (i = 0; i < this.conditions.size(); ++i) {
                    if (i > 0) {
                        if (this.andLogicOperator) {
                            bf.append(" AND ");
                        } else {
                            bf.append(" OR ");
                        }
                    }
                    String cond = (String)this.conditions.get(i);
                    bf.append(cond);
                }
                if (this.notBeforeConditions) {
                    bf.append(" )");
                }
            }
            if (this.getGroupByConditions().size() > 0) {
                bf.append(" GROUP BY ");
                Iterator<String> it2 = this.getGroupByConditions().iterator();
                first = true;
                while (it2.hasNext()) {
                    if (!first) {
                        bf.append(",");
                    } else {
                        first = false;
                    }
                    bf.append(it2.next());
                }
            }
            bf.append(" ) as subquery" + this.getSerial() + " ");
            bf.append(" WHERE ( ");
            if (this.offset >= 0) {
                bf.append(" rowNumber > ");
                bf.append(this.offset);
            }
            if (this.limit >= 0) {
                if (this.offset >= 0) {
                    bf.append(" AND");
                }
                bf.append(" rowNumber <=  ");
                if (this.offset >= 0) {
                    bf.append(this.offset + this.limit);
                } else {
                    bf.append(this.limit);
                }
            }
            bf.append(" )");
        } else {
            boolean first;
            bf.append("SELECT ");
            if (this.offset < 0 && this.limit > 0) {
                bf.append("TOP ");
                bf.append(this.limit);
                bf.append(" ");
            } else {
                bf.append("TOP 100 PERCENT ");
            }
            Iterator itForceIndex = this.forceIndexTableNames.iterator();
            while (itForceIndex.hasNext()) {
                bf.append(" " + (String)itForceIndex.next() + " ");
            }
            if (this.fields.size() == 0) {
                bf.append("*");
            } else {
                Iterator it = this.fields.iterator();
                first = true;
                while (it.hasNext()) {
                    if (!first) {
                        bf.append(",");
                    } else {
                        first = false;
                    }
                    String f = (String)it.next();
                    bf.append(f);
                }
            }
            bf.append(" FROM ( ");
            for (int i = 0; i < sqlQueryObject.length; ++i) {
                if (((SQLServerQueryObject)sqlQueryObject[i]).selectForUpdate) {
                    try {
                        ((SQLServerQueryObject)sqlQueryObject[i]).checkSelectForUpdate(false, false, true);
                    }
                    catch (Exception e) {
                        throw new SQLQueryObjectException("Parametro SqlQueryObject[" + i + "] non valido: " + e.getMessage());
                    }
                }
                if (i > 0) {
                    bf.append(" UNION ");
                    if (unionAll) {
                        bf.append(" ALL ");
                    }
                }
                bf.append("( ");
                bf.append(((SQLServerQueryObject)sqlQueryObject[i]).createSQLQuery(true));
                bf.append(") ");
            }
            bf.append(" ) as subquery" + this.getSerial() + " ");
            if (this.getGroupByConditions().size() > 0) {
                bf.append(" GROUP BY ");
                Iterator<String> it = this.getGroupByConditions().iterator();
                first = true;
                while (it.hasNext()) {
                    if (!first) {
                        bf.append(",");
                    } else {
                        first = false;
                    }
                    bf.append(it.next());
                }
            }
            if (this.orderBy.size() > 0) {
                bf.append(" ORDER BY ");
                Iterator it = this.orderBy.iterator();
                first = true;
                while (it.hasNext()) {
                    String column = (String)it.next();
                    if (!first) {
                        bf.append(",");
                    } else {
                        first = false;
                    }
                    bf.append(column);
                    boolean sortTypeAsc = this.sortTypeAsc;
                    if (this.orderBySortType.containsKey(column)) {
                        sortTypeAsc = (Boolean)this.orderBySortType.get(column);
                    }
                    if (sortTypeAsc) {
                        bf.append(" ASC ");
                        continue;
                    }
                    bf.append(" DESC ");
                }
            }
        }
        return bf.toString();
    }

    @Override
    public String createSQLUnionCount(boolean unionAll, String aliasCount, ISQLQueryObject ... sqlQueryObject) throws SQLQueryObjectException {
        this.checkUnionField(true, sqlQueryObject);
        if (aliasCount == null) {
            throw new SQLQueryObjectException("Alias per il count non definito");
        }
        StringBuffer bf = new StringBuffer();
        bf.append("SELECT count(*) " + this.getDefaultAliasFieldKeyword() + " ");
        bf.append(aliasCount);
        bf.append(" FROM ( ");
        bf.append(this.createSQLUnion(unionAll, sqlQueryObject));
        bf.append(" ) as subquery" + this.getSerial() + " ");
        return bf.toString();
    }

    @Override
    public String _createSQLUpdate() throws SQLQueryObjectException {
        StringBuffer bf = new StringBuffer();
        bf.append("UPDATE ");
        bf.append(this.updateTable);
        bf.append(" SET ");
        for (int i = 0; i < this.updateFieldsName.size(); ++i) {
            if (i > 0) {
                bf.append(" , ");
            }
            bf.append((String)this.updateFieldsName.get(i));
            bf.append(" = ");
            bf.append((String)this.updateFieldsValue.get(i));
        }
        bf.append(this.getSQL(false, true, false, false));
        return bf.toString();
    }

    @Override
    public String _createSQLConditions() throws SQLQueryObjectException {
        StringBuffer bf = new StringBuffer();
        bf.append(this.getSQL(false, false, true, false));
        return bf.toString();
    }
}

