/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.utils.sql;

import it.link.pdd.tools.migrazione_govway.utils.TipiDatabase;
import it.link.pdd.tools.migrazione_govway.utils.sql.DB2QueryObject;
import it.link.pdd.tools.migrazione_govway.utils.sql.DerbyQueryObject;
import it.link.pdd.tools.migrazione_govway.utils.sql.HyperSQLQueryObject;
import it.link.pdd.tools.migrazione_govway.utils.sql.ISQLQueryObject;
import it.link.pdd.tools.migrazione_govway.utils.sql.MySQLQueryObject;
import it.link.pdd.tools.migrazione_govway.utils.sql.OracleQueryObject;
import it.link.pdd.tools.migrazione_govway.utils.sql.PostgreSQLQueryObject;
import it.link.pdd.tools.migrazione_govway.utils.sql.SQLQueryObjectException;
import it.link.pdd.tools.migrazione_govway.utils.sql.SQLServerQueryObject;

public class SQLObjectFactory {
    public static ISQLQueryObject createSQLQueryObject(String tipoDatabase) throws SQLQueryObjectException {
        return SQLObjectFactory.toQueryObject(tipoDatabase);
    }

    public static ISQLQueryObject createSQLQueryObject(TipiDatabase tipoDatabase) throws SQLQueryObjectException {
        return SQLObjectFactory.createSQLQueryObject(tipoDatabase.toString());
    }

    public static ISQLQueryObject toQueryObject(String tipoDatabase) throws SQLQueryObjectException {
        if (TipiDatabase.POSTGRESQL.equals(tipoDatabase)) {
            return new PostgreSQLQueryObject(TipiDatabase.POSTGRESQL);
        }
        if (TipiDatabase.MYSQL.equals(tipoDatabase)) {
            return new MySQLQueryObject(TipiDatabase.MYSQL);
        }
        if (TipiDatabase.ORACLE.equals(tipoDatabase)) {
            return new OracleQueryObject(TipiDatabase.ORACLE);
        }
        if (TipiDatabase.HSQL.toString().equals(tipoDatabase)) {
            return new HyperSQLQueryObject(TipiDatabase.HSQL);
        }
        if (TipiDatabase.DERBY.toString().equals(tipoDatabase)) {
            return new DerbyQueryObject(TipiDatabase.DERBY);
        }
        if (TipiDatabase.SQLSERVER.toString().equals(tipoDatabase)) {
            return new SQLServerQueryObject(TipiDatabase.SQLSERVER);
        }
        if (TipiDatabase.DB2.toString().equals(tipoDatabase)) {
            return new DB2QueryObject(TipiDatabase.DB2);
        }
        throw new SQLQueryObjectException("Tipo database non gestito [" + tipoDatabase + "]");
    }
}

