/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.utils.sql;

import it.link.pdd.tools.migrazione_govway.utils.LoggerWrapperFactory;
import it.link.pdd.tools.migrazione_govway.utils.TipiDatabase;
import it.link.pdd.tools.migrazione_govway.utils.Utilities;
import it.link.pdd.tools.migrazione_govway.utils.date.DateManager;
import it.link.pdd.tools.migrazione_govway.utils.date.SystemDate;
import it.link.pdd.tools.migrazione_govway.utils.sql.ISQLQueryObject;
import it.link.pdd.tools.migrazione_govway.utils.sql.SQLObjectFactory;
import it.link.pdd.tools.migrazione_govway.utils.sql.SQLQueryObjectCore;
import it.link.pdd.tools.migrazione_govway.utils.sql.SQLQueryObjectException;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Properties;
import java.util.Vector;
import org.apache.logging.log4j.Level;
import org.slf4j.Logger;

public class ClientTest {
    private static int ROW = 21;
    private static Logger log = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        String passwordCustom;
        String usernameCustom;
        String urlCustom;
        File logFile = File.createTempFile("runSQLQueryObjectTest_", ".log");
        System.out.println("LogMessages write in " + logFile.getAbsolutePath());
        LoggerWrapperFactory.setDefaultLogConfiguration(Level.ALL, false, null, logFile, "%m %n");
        log = LoggerWrapperFactory.getLogger(ClientTest.class);
        DateManager.initializeDataManager(SystemDate.class.getName(), new Properties(), log);
        Enum tipoDatabase = null;
        if (args.length > 0 && !"${tipoDatabase}".equals(args[0].trim())) {
            tipoDatabase = TipiDatabase.toEnumConstant(args[0].trim());
        }
        String url = null;
        String driver = null;
        String userName = null;
        String password = null;
        switch (1.$SwitchMap$it$link$pdd$tools$migrazione_govway$utils$TipiDatabase[tipoDatabase.ordinal()]) {
            case 1: {
                url = "jdbc:postgresql://localhost/prova";
                driver = "org.postgresql.Driver";
                userName = "openspcoop2";
                password = "openspcoop2";
                break;
            }
            case 2: {
                url = "jdbc:mysql://localhost/prova";
                driver = "com.mysql.jdbc.Driver";
                userName = "openspcoop2";
                password = "openspcoop2";
                break;
            }
            case 3: {
                url = "jdbc:oracle:thin:@localhost:1521:XE";
                driver = "oracle.jdbc.OracleDriver";
                userName = "prova";
                password = "prova";
                break;
            }
            case 4: {
                url = "jdbc:hsqldb:hsql://localhost:9001/";
                driver = "org.hsqldb.jdbcDriver";
                userName = "sa";
                password = "";
                break;
            }
            case 5: {
                url = "jdbc:derby:sample";
                driver = "org.apache.derby.jdbc.EmbeddedDriver";
                userName = "";
                password = "";
                break;
            }
            case 6: {
                url = "jdbc:sqlserver://localhost:1433;databaseName=prova";
                driver = "com.microsoft.sqlserver.jdbc.SQLServerDriver";
                userName = "openspcoop2";
                password = "openspcoop2";
                break;
            }
            case 7: {
                url = "jdbc:db2://127.0.0.1:50000/prova";
                driver = "com.ibm.db2.jcc.DB2Driver";
                userName = "openspcoop2";
                password = "openspcoop2";
                break;
            }
        }
        if (args.length > 1 && !"${url}".equals(urlCustom = args[1].trim())) {
            url = urlCustom;
        }
        if (args.length > 2 && !"${username}".equals(usernameCustom = args[2].trim())) {
            userName = usernameCustom;
        }
        if (args.length > 3 && !"${password}".equals(passwordCustom = args[3].trim())) {
            password = passwordCustom;
        }
        Class.forName(driver).getConstructor(new Class[0]).newInstance(new Object[0]);
        Connection con = null;
        Statement stmtDelete = null;
        Statement stmtInsert = null;
        try {
            long increment;
            int index;
            String campoVuoto;
            Object descrizione;
            int i;
            con = DriverManager.getConnection(url, userName, password);
            String caratteriStraniParte1 = "- { ( [ _ % ^ \\ / # | & \u00e0 \u00e8 @ . : ; , < parolaCasualeMAIUSCOLA > \u00e9 \u00f9 \u00ec ^ \" ' ? ! ] ) } -";
            String caratteriStraniParte2 = "\n \t \r \b Un  po di parole Maiuscole Minuscole \u00a7 \u00b0 \u00e7 \u00a3";
            String rigaCaratteriStrani = "------" + caratteriStraniParte1 + "-----" + caratteriStraniParte2 + "-----";
            String delete = "delete from msgdiagnostici";
            stmtDelete = con.createStatement();
            stmtDelete.execute(delete);
            stmtDelete.close();
            delete = "delete from tracce";
            stmtDelete = con.createStatement();
            stmtDelete.execute(delete);
            stmtDelete.close();
            for (i = 0; i < ROW; ++i) {
                String insertMsgDiagnosticoWithGdo = "INSERT INTO msgdiagnostici (descrizione,gdo,gdo2,tipo_mittente,mittente,tipo_destinatario,destinatario,campo_vuoto) VALUES (?,?,?,?,?,?,?,?)";
                String insertMsgDiagnosticoWithoutGdo = "INSERT INTO msgdiagnostici (descrizione,gdo2,tipo_mittente,mittente,tipo_destinatario,destinatario,campo_vuoto) VALUES (?,?,?,?,?,?,?)";
                descrizione = "descrizione esempio " + i;
                if (i > 9) {
                    descrizione = "descrizione esempio uguale";
                }
                if (i == 20) {
                    descrizione = "descrizione con caratteri particolari: " + rigaCaratteriStrani;
                }
                campoVuoto = null;
                if (i == 0) {
                    campoVuoto = "Prima colonna valorizzata";
                }
                if (i > 10) {
                    campoVuoto = "";
                }
                if (i == ROW - 1) {
                    campoVuoto = "Ultima colonna valorizzata";
                }
                stmtInsert = i % 2 == 0 ? con.prepareStatement(insertMsgDiagnosticoWithGdo) : con.prepareStatement(insertMsgDiagnosticoWithoutGdo);
                index = 1;
                stmtInsert.setString(index++, (String)descrizione);
                if (i % 2 == 0) {
                    stmtInsert.setTimestamp(index++, DateManager.getTimestamp());
                    increment = 10368000000L * (long)(i + 1);
                    stmtInsert.setTimestamp(index++, new Timestamp(DateManager.getTimeMillis() + increment + (long)(200101 * (i + 1))));
                } else {
                    stmtInsert.setTimestamp(index++, new Timestamp(DateManager.getTimeMillis() + (long)(23 * (i + 1))));
                }
                stmtInsert.setString(index++, "SPC");
                stmtInsert.setString(index++, "SoggettoMittente" + i / 2);
                stmtInsert.setString(index++, "SPC");
                stmtInsert.setString(index++, "SoggettoDestinatario" + i / 2);
                stmtInsert.setString(index++, campoVuoto);
                stmtInsert.execute();
                stmtInsert.close();
            }
            for (i = 0; i < ROW; ++i) {
                String insertTracciaWithGdo = "INSERT INTO tracce (descrizione,gdo,gdo2,tipo_mittente,mittente,tipo_destinatario,destinatario,campo_vuoto) VALUES (?,?,?,?,?,?,?,?)";
                String insertTracciaWithoutGdo = "INSERT INTO tracce (descrizione,gdo2,tipo_mittente,mittente,tipo_destinatario,destinatario,campo_vuoto) VALUES (?,?,?,?,?,?,?)";
                descrizione = "descrizione esempio " + i;
                if (i > 9) {
                    descrizione = "descrizione esempio uguale";
                }
                if (i == 20) {
                    descrizione = "descrizione con caratteri particolari: " + rigaCaratteriStrani;
                }
                campoVuoto = null;
                if (i == 0) {
                    campoVuoto = "Prima colonna valorizzata";
                }
                if (i > 10) {
                    campoVuoto = "";
                }
                if (i == ROW - 1) {
                    campoVuoto = "Ultima colonna valorizzata";
                }
                stmtInsert = i % 2 == 0 ? con.prepareStatement(insertTracciaWithGdo) : con.prepareStatement(insertTracciaWithoutGdo);
                index = 1;
                stmtInsert.setString(index++, (String)descrizione);
                if (i % 2 == 0) {
                    stmtInsert.setTimestamp(index++, DateManager.getTimestamp());
                    increment = 10368000000L * (long)(i + 1);
                    stmtInsert.setTimestamp(index++, new Timestamp(DateManager.getTimeMillis() + increment + (long)(200101 * (i + 1))));
                } else {
                    stmtInsert.setTimestamp(index++, new Timestamp(DateManager.getTimeMillis() + (long)(23 * (i + 1))));
                }
                stmtInsert.setString(index++, "SPC");
                stmtInsert.setString(index++, "SoggettoMittente" + i / 2);
                stmtInsert.setString(index++, "SPC");
                stmtInsert.setString(index++, "SoggettoDestinatario" + i / 2);
                stmtInsert.setString(index++, campoVuoto);
                stmtInsert.execute();
                stmtInsert.close();
            }
            for (i = 0; i < 2; ++i) {
                boolean selectForUpdate = false;
                if (i == 1) {
                    selectForUpdate = true;
                }
                log.info("\n\n@@@ SELECT FOR UPDATE: " + selectForUpdate);
                ClientTest.testUnixTime_engine((TipiDatabase)tipoDatabase, "msgdiagnostici", con, selectForUpdate);
                ClientTest.testUnixTime_engine((TipiDatabase)tipoDatabase, "tracce", con, selectForUpdate);
                ClientTest.testFromTable_engine((TipiDatabase)tipoDatabase, "msgdiagnostici", con, selectForUpdate);
                ClientTest.testLikeEscapeChar_engine((TipiDatabase)tipoDatabase, "msgdiagnostici", con, selectForUpdate, caratteriStraniParte1, caratteriStraniParte2);
                ClientTest.test0_engine((TipiDatabase)tipoDatabase, con, selectForUpdate);
                ClientTest.test1_engine((TipiDatabase)tipoDatabase, false, con, selectForUpdate);
                ClientTest.test1_engine((TipiDatabase)tipoDatabase, true, con, selectForUpdate);
                ClientTest.testUnion_engine((TipiDatabase)tipoDatabase, false, true, con, selectForUpdate);
                ClientTest.testUnion_engine((TipiDatabase)tipoDatabase, true, true, con, selectForUpdate);
                ClientTest.testUnion_engine((TipiDatabase)tipoDatabase, false, false, con, selectForUpdate);
                ClientTest.testUnion_engine((TipiDatabase)tipoDatabase, true, false, con, selectForUpdate);
                ClientTest.testUnionWithGroupBy_engine((TipiDatabase)tipoDatabase, false, true, con, selectForUpdate);
                ClientTest.testUnionWithGroupBy_engine((TipiDatabase)tipoDatabase, true, true, con, selectForUpdate);
                ClientTest.testUnionWithGroupBy_engine((TipiDatabase)tipoDatabase, false, false, con, selectForUpdate);
                ClientTest.testUnionWithGroupBy_engine((TipiDatabase)tipoDatabase, true, false, con, selectForUpdate);
                ClientTest.testEmptyNull_engine((TipiDatabase)tipoDatabase, "msgdiagnostici", con, selectForUpdate);
            }
        }
        finally {
            try {
                stmtDelete.close();
            }
            catch (Exception exception) {}
            try {
                stmtInsert.close();
            }
            catch (Exception exception) {}
            try {
                con.close();
            }
            catch (Exception exception) {}
        }
    }

    private static SQLQueryObjectCore createSQLQueryObjectCore(TipiDatabase tipo, boolean selectForUpdate) throws Exception {
        SQLQueryObjectCore sqlQueryObject = (SQLQueryObjectCore)SQLObjectFactory.createSQLQueryObject(tipo);
        if (selectForUpdate) {
            sqlQueryObject.setSelectForUpdate(true);
        }
        return sqlQueryObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void testUnixTime_engine(TipiDatabase tipo, String table, Connection con, boolean selectForUpdate) throws Exception {
        Statement stmtQuery = null;
        ResultSet rs = null;
        try {
            boolean check;
            SQLQueryObjectCore sqlQueryObject = ClientTest.createSQLQueryObjectCore(tipo, false);
            sqlQueryObject.addFromTable(table);
            sqlQueryObject.addSelectField("descrizione");
            sqlQueryObject.addSelectField("gdo");
            sqlQueryObject.addSelectAliasField(sqlQueryObject.getUnixTimestampConversion("gdo"), "unixtime");
            sqlQueryObject.setLimit(1);
            sqlQueryObject.addOrderBy("gdo");
            sqlQueryObject.setSortType(true);
            String testUnixTime = sqlQueryObject.createSQLQuery();
            log.info("\ntest1-" + table + " unixtime:\n\t" + testUnixTime);
            stmtQuery = con.prepareStatement(testUnixTime);
            rs = stmtQuery.executeQuery();
            int index = 0;
            if (!rs.next()) {
                log.error("Query: " + sqlQueryObject.toString());
                throw new Exception("UnixTime [checkDB] test1 failed");
            }
            String format = "yyyy-MM-dd_HH:mm:ss.SSSZ";
            SimpleDateFormat dateformat = new SimpleDateFormat(format);
            Timestamp timestamp = rs.getTimestamp("gdo");
            String s = dateformat.format(timestamp);
            long timeStampValue = timestamp.getTime();
            long timeStampValueWithTimeZone = -1L;
            if (timestamp.getTimezoneOffset() != 0) {
                timeStampValueWithTimeZone = timestamp.getTimezoneOffset() < 0 ? timestamp.getTime() + (long)(-1 * timestamp.getTimezoneOffset() * 60 * 1000) : timestamp.getTime() + (long)(timestamp.getTimezoneOffset() * 60 * 1000);
            }
            long unixAtteso = dateformat.parse(s).getTime() - (long)(dateformat.parse(s).getTimezoneOffset() * 60 * 1000);
            long unixAttesoCalcolatoViaDB = rs.getLong("unixtime");
            log.info("Data[" + s + "]");
            log.info("timeStampValue[" + timeStampValue + "] offset[" + timestamp.getTimezoneOffset() + "] timeStampValueWithTimeZone[" + timeStampValueWithTimeZone + "]");
            log.info("unixEpoqueAtteso[" + unixAtteso + "] unixEpoqueCalcolato[" + unixAttesoCalcolatoViaDB + "]");
            log.info("riga[" + index++ + "]=" + rs.getString("descrizione") + " (time:" + rs.getTimestamp("gdo") + " timeValue:" + timeStampValue + ") (" + unixAttesoCalcolatoViaDB + ")");
            boolean bl = check = timeStampValue == unixAttesoCalcolatoViaDB;
            if (!check && timeStampValueWithTimeZone != -1L) {
                boolean bl2 = check = timeStampValueWithTimeZone == unixAttesoCalcolatoViaDB;
            }
            if (!check) {
                if (!TipiDatabase.ORACLE.equals(tipo)) {
                    log.error("Query: " + sqlQueryObject.toString());
                    throw new Exception("UnixTime [checkDB] test failed diff(" + (unixAttesoCalcolatoViaDB - timeStampValue) + ")");
                }
                if (timeStampValue != unixAttesoCalcolatoViaDB - 1000L) {
                    log.error("Query: " + sqlQueryObject.toString());
                    throw new Exception("UnixTime [checkDB] test failed diff(" + (unixAttesoCalcolatoViaDB - timeStampValue) + ")");
                }
            }
            if (rs != null) {
                rs.close();
                rs = null;
            }
            if (stmtQuery != null) {
                stmtQuery.close();
                stmtQuery = null;
            }
            sqlQueryObject = ClientTest.createSQLQueryObjectCore(tipo, false);
            sqlQueryObject.addFromTable(table);
            sqlQueryObject.addSelectField("descrizione");
            sqlQueryObject.addSelectAvgTimestampField("gdo", "unixtimeavg");
            sqlQueryObject.addSelectMinTimestampField("gdo", "unixtimemin");
            sqlQueryObject.addSelectMaxTimestampField("gdo", "unixtimemax");
            sqlQueryObject.addSelectSumTimestampField("gdo", "unixtimesum");
            sqlQueryObject.addGroupBy("descrizione");
            testUnixTime = sqlQueryObject.createSQLQuery();
            log.info("\ntest2-" + table + " unixtime:\n\t" + testUnixTime);
            stmtQuery = con.prepareStatement(testUnixTime);
            rs = stmtQuery.executeQuery();
            index = 0;
            while (rs.next()) {
                log.info("riga[" + index++ + "]=" + rs.getString("descrizione") + " [min:" + rs.getLong("unixtimemin") + " max:" + rs.getLong("unixtimemax") + " avg:" + rs.getLong("unixtimeavg") + " sum:" + rs.getLong("unixtimesum") + "]");
            }
            if (rs != null) {
                rs.close();
                rs = null;
            }
            if (stmtQuery != null) {
                stmtQuery.close();
                stmtQuery = null;
            }
            sqlQueryObject = ClientTest.createSQLQueryObjectCore(tipo, selectForUpdate);
            String format2 = "yyyy-MM-dd_HH:mm:ss.SSS";
            SimpleDateFormat dateformat2 = new SimpleDateFormat(format2);
            sqlQueryObject.addFromTable(table);
            sqlQueryObject.addSelectField("descrizione");
            sqlQueryObject.addSelectField("gdo");
            sqlQueryObject.addSelectField("gdo2");
            sqlQueryObject.addSelectAliasField(sqlQueryObject.getDiffUnixTimestamp("gdo2", "gdo"), "latenza");
            sqlQueryObject.addOrderBy(sqlQueryObject.getDiffUnixTimestamp("gdo2", "gdo"));
            sqlQueryObject.setSortType(true);
            testUnixTime = sqlQueryObject.createSQLQuery();
            log.info("\ntest3-" + table + " unixtime:\n\t" + testUnixTime);
            long oldLatenza = 0L;
            stmtQuery = con.prepareStatement(testUnixTime);
            rs = stmtQuery.executeQuery();
            int index2 = 0;
            while (rs.next()) {
                long latenza = rs.getLong("latenza");
                log.info("riga[" + index2++ + "]=" + rs.getString("descrizione") + " gdo[" + dateformat2.format(rs.getTimestamp("gdo")) + "] gdo2[" + dateformat2.format(rs.getTimestamp("gdo2")) + "] [msLatenza:" + latenza + " humanReadable:" + Utilities.convertSystemTimeIntoString_millisecondi(latenza, true) + "]");
                if (latenza <= oldLatenza) {
                    throw new Exception("Attesa latenza con ordinamento crescente. Latenza della entry precedente aveva [" + oldLatenza + "]");
                }
                if (index2 > 10 && latenza < 10000000000L) {
                    throw new Exception("Attesa latenza enorme, riscontro non avvenuto");
                }
                oldLatenza = latenza;
            }
            if (rs != null) {
                rs.close();
                rs = null;
            }
            if (stmtQuery == null) return;
            stmtQuery.close();
            stmtQuery = null;
            return;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
            }
            catch (Exception exception) {}
            try {
                if (stmtQuery != null) {
                    stmtQuery.close();
                    stmtQuery = null;
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testFromTable_engine(TipiDatabase tipo, String table, Connection con, boolean selectForUpdate) throws Exception {
        Statement stmtQuery = null;
        ResultSet rs = null;
        try {
            SQLQueryObjectCore sqlQueryObject = ClientTest.createSQLQueryObjectCore(tipo, false);
            sqlQueryObject.addFromTable(table);
            sqlQueryObject.addSelectField("descrizione");
            sqlQueryObject.addSelectField("gdo");
            sqlQueryObject.setLimit(1);
            sqlQueryObject.addOrderBy("gdo");
            sqlQueryObject.setSortType(true);
            SQLQueryObjectCore sqlQueryObjectExternal = ClientTest.createSQLQueryObjectCore(tipo, false);
            sqlQueryObjectExternal.addFromTable(sqlQueryObject);
            String test = sqlQueryObjectExternal.createSQLQuery();
            log.info("\ntest-" + table + " fromTable:\n\t" + test);
            stmtQuery = con.createStatement();
            rs = stmtQuery.executeQuery(test);
            int index = 0;
            if (!rs.next()) {
                throw new Exception("Test failed");
            }
            log.info("riga[" + index++ + "]=" + rs.getString("descrizione") + " (time:" + rs.getTimestamp("gdo") + ")");
            if (rs != null) {
                rs.close();
                rs = null;
            }
            if (stmtQuery != null) {
                stmtQuery.close();
                stmtQuery = null;
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
            }
            catch (Exception exception) {}
            try {
                if (stmtQuery != null) {
                    stmtQuery.close();
                    stmtQuery = null;
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void testLikeEscapeChar_engine(TipiDatabase tipo, String table, Connection con, boolean selectForUpdate, String caratteriStraniParte1, String caratteriStraniParte2) throws Exception {
        Statement stmtQuery = null;
        ResultSet rs = null;
        try {
            boolean escape = true;
            boolean contains = true;
            boolean caseInsensitive = true;
            SQLQueryObjectCore sqlQueryObject = ClientTest.createSQLQueryObjectCore(tipo, false);
            sqlQueryObject.addFromTable(table);
            sqlQueryObject.addSelectField("descrizione");
            sqlQueryObject.addSelectField("gdo");
            sqlQueryObject.setLimit(1);
            sqlQueryObject.addOrderBy("gdo");
            sqlQueryObject.setSortType(true);
            String ricerca = caratteriStraniParte1;
            sqlQueryObject.addWhereLikeCondition("descrizione", ricerca, escape, contains, caseInsensitive);
            String test = sqlQueryObject.createSQLQuery();
            log.info("\ntest (Parte1)-" + table + " escapeLike:\n\t" + test);
            stmtQuery = con.createStatement();
            rs = stmtQuery.executeQuery(test);
            int index = 0;
            if (!rs.next()) {
                throw new Exception("Test failed");
            }
            log.info("riga[" + index++ + "]=" + rs.getString("descrizione") + " (time:" + rs.getTimestamp("gdo") + ")");
            if (rs != null) {
                rs.close();
                rs = null;
            }
            if (stmtQuery != null) {
                stmtQuery.close();
                stmtQuery = null;
            }
            sqlQueryObject = (SQLQueryObjectCore)SQLObjectFactory.createSQLQueryObject(tipo);
            sqlQueryObject.addFromTable(table);
            sqlQueryObject.addSelectField("descrizione");
            sqlQueryObject.addSelectField("gdo");
            sqlQueryObject.setLimit(1);
            sqlQueryObject.addOrderBy("gdo");
            sqlQueryObject.setSortType(true);
            ricerca = caratteriStraniParte1.toLowerCase();
            sqlQueryObject.addWhereLikeCondition("descrizione", ricerca, escape, contains, caseInsensitive);
            test = sqlQueryObject.createSQLQuery();
            log.info("\ntestLower (Parte1)-" + table + " escapeLike:\n\t" + test);
            stmtQuery = con.createStatement();
            rs = stmtQuery.executeQuery(test);
            index = 0;
            if (!rs.next()) {
                throw new Exception("Test failed");
            }
            log.info("riga[" + index++ + "]=" + rs.getString("descrizione") + " (time:" + rs.getTimestamp("gdo") + ")");
            if (rs != null) {
                rs.close();
                rs = null;
            }
            if (stmtQuery != null) {
                stmtQuery.close();
                stmtQuery = null;
            }
            sqlQueryObject = (SQLQueryObjectCore)SQLObjectFactory.createSQLQueryObject(tipo);
            sqlQueryObject.addFromTable(table);
            sqlQueryObject.addSelectField("descrizione");
            sqlQueryObject.addSelectField("gdo");
            sqlQueryObject.setLimit(1);
            sqlQueryObject.addOrderBy("gdo");
            sqlQueryObject.setSortType(true);
            ricerca = caratteriStraniParte2;
            sqlQueryObject.addWhereLikeCondition("descrizione", ricerca, escape, contains, caseInsensitive);
            test = sqlQueryObject.createSQLQuery();
            log.info("\ntest (Parte2)-" + table + " escapeLike:\n\t" + test);
            stmtQuery = con.createStatement();
            rs = stmtQuery.executeQuery(test);
            index = 0;
            if (!rs.next()) {
                throw new Exception("Test failed");
            }
            log.info("riga[" + index++ + "]=" + rs.getString("descrizione") + " (time:" + rs.getTimestamp("gdo") + ")");
            if (rs != null) {
                rs.close();
                rs = null;
            }
            if (stmtQuery != null) {
                stmtQuery.close();
                stmtQuery = null;
            }
            sqlQueryObject = (SQLQueryObjectCore)SQLObjectFactory.createSQLQueryObject(tipo);
            sqlQueryObject.addFromTable(table);
            sqlQueryObject.addSelectField("descrizione");
            sqlQueryObject.addSelectField("gdo");
            sqlQueryObject.setLimit(1);
            sqlQueryObject.addOrderBy("gdo");
            sqlQueryObject.setSortType(true);
            ricerca = caratteriStraniParte2.toLowerCase();
            sqlQueryObject.addWhereLikeCondition("descrizione", ricerca, escape, contains, caseInsensitive);
            test = sqlQueryObject.createSQLQuery();
            log.info("\ntestLower (Parte2)-" + table + " escapeLike:\n\t" + test);
            stmtQuery = con.createStatement();
            rs = stmtQuery.executeQuery(test);
            index = 0;
            if (!rs.next()) {
                throw new Exception("Test failed");
            }
            log.info("riga[" + index++ + "]=" + rs.getString("descrizione") + " (time:" + rs.getTimestamp("gdo") + ")");
            if (rs != null) {
                rs.close();
                rs = null;
            }
            if (stmtQuery != null) {
                stmtQuery.close();
                stmtQuery = null;
            }
            sqlQueryObject = (SQLQueryObjectCore)SQLObjectFactory.createSQLQueryObject(tipo);
            sqlQueryObject.addFromTable(table);
            sqlQueryObject.addSelectField("descrizione");
            sqlQueryObject.addSelectField("gdo");
            sqlQueryObject.setLimit(1);
            sqlQueryObject.addOrderBy("gdo");
            sqlQueryObject.setSortType(true);
            ricerca = caratteriStraniParte1;
            sqlQueryObject.addWhereLikeCondition("descrizione", ricerca, escape, contains, !caseInsensitive);
            test = sqlQueryObject.createSQLQuery();
            log.info("\ntest (Parte1)-" + table + " escapeLike:\n\t" + test);
            stmtQuery = con.createStatement();
            rs = stmtQuery.executeQuery(test);
            index = 0;
            if (!rs.next()) {
                throw new Exception("Test failed");
            }
            log.info("riga[" + index++ + "]=" + rs.getString("descrizione") + " (time:" + rs.getTimestamp("gdo") + ")");
            if (rs != null) {
                rs.close();
                rs = null;
            }
            if (stmtQuery != null) {
                stmtQuery.close();
                stmtQuery = null;
            }
            sqlQueryObject = (SQLQueryObjectCore)SQLObjectFactory.createSQLQueryObject(tipo);
            sqlQueryObject.addFromTable(table);
            sqlQueryObject.addSelectField("descrizione");
            sqlQueryObject.addSelectField("gdo");
            sqlQueryObject.setLimit(1);
            sqlQueryObject.addOrderBy("gdo");
            sqlQueryObject.setSortType(true);
            ricerca = caratteriStraniParte1.toLowerCase();
            sqlQueryObject.addWhereLikeCondition("descrizione", ricerca, escape, contains, !caseInsensitive);
            test = sqlQueryObject.createSQLQuery();
            log.info("\ntestLower (Parte1)-" + table + " escapeLike:\n\t" + test);
            stmtQuery = con.createStatement();
            rs = stmtQuery.executeQuery(test);
            index = 0;
            if (rs.next()) {
                if (!TipiDatabase.MYSQL.equals(tipo) && !TipiDatabase.SQLSERVER.equals(tipo)) throw new Exception("Atteso fallimento del test");
                log.info("riga[" + index++ + "]=" + rs.getString("descrizione") + " (time:" + rs.getTimestamp("gdo") + ")");
            } else {
                log.info("Nessuna riga trovata: risultato atteso");
            }
            if (rs != null) {
                rs.close();
                rs = null;
            }
            if (stmtQuery != null) {
                stmtQuery.close();
                stmtQuery = null;
            }
            sqlQueryObject = (SQLQueryObjectCore)SQLObjectFactory.createSQLQueryObject(tipo);
            sqlQueryObject.addFromTable(table);
            sqlQueryObject.addSelectField("descrizione");
            sqlQueryObject.addSelectField("gdo");
            sqlQueryObject.setLimit(1);
            sqlQueryObject.addOrderBy("gdo");
            sqlQueryObject.setSortType(true);
            ricerca = caratteriStraniParte2;
            sqlQueryObject.addWhereLikeCondition("descrizione", ricerca, escape, contains, !caseInsensitive);
            test = sqlQueryObject.createSQLQuery();
            log.info("\ntest (Parte2)-" + table + " escapeLike:\n\t" + test);
            stmtQuery = con.createStatement();
            rs = stmtQuery.executeQuery(test);
            index = 0;
            if (!rs.next()) {
                throw new Exception("Test failed");
            }
            log.info("riga[" + index++ + "]=" + rs.getString("descrizione") + " (time:" + rs.getTimestamp("gdo") + ")");
            if (rs != null) {
                rs.close();
                rs = null;
            }
            if (stmtQuery != null) {
                stmtQuery.close();
                stmtQuery = null;
            }
            sqlQueryObject = (SQLQueryObjectCore)SQLObjectFactory.createSQLQueryObject(tipo);
            sqlQueryObject.addFromTable(table);
            sqlQueryObject.addSelectField("descrizione");
            sqlQueryObject.addSelectField("gdo");
            sqlQueryObject.setLimit(1);
            sqlQueryObject.addOrderBy("gdo");
            sqlQueryObject.setSortType(true);
            ricerca = caratteriStraniParte2.toLowerCase();
            sqlQueryObject.addWhereLikeCondition("descrizione", ricerca, escape, contains, !caseInsensitive);
            test = sqlQueryObject.createSQLQuery();
            log.info("\ntestLower (Parte2)-" + table + " escapeLike:\n\t" + test);
            stmtQuery = con.createStatement();
            rs = stmtQuery.executeQuery(test);
            index = 0;
            if (rs.next()) {
                if (!TipiDatabase.MYSQL.equals(tipo) && !TipiDatabase.SQLSERVER.equals(tipo)) throw new Exception("Atteso fallimento del test");
                log.info("riga[" + index++ + "]=" + rs.getString("descrizione") + " (time:" + rs.getTimestamp("gdo") + ")");
            } else {
                log.info("Nessuna riga trovata: risultato atteso");
            }
            if (rs != null) {
                rs.close();
                rs = null;
            }
            if (stmtQuery == null) return;
            stmtQuery.close();
            stmtQuery = null;
            return;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
            }
            catch (Exception exception) {}
            try {
                if (stmtQuery != null) {
                    stmtQuery.close();
                    stmtQuery = null;
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void test0_engine(TipiDatabase tipo, Connection con, boolean selectForUpdate) throws Exception {
        Statement stmtQuery = null;
        ResultSet rs = null;
        try {
            SQLQueryObjectCore sqlQueryObject = ClientTest.createSQLQueryObjectCore(tipo, false);
            sqlQueryObject.addFromTable("tracce");
            sqlQueryObject.addFromTable("msgdiagnostici", "aliasMSG");
            sqlQueryObject.setSelectDistinct(true);
            sqlQueryObject.addSelectCountField("aliasMSG", "id", "cont", true);
            sqlQueryObject.addSelectAvgField("aliasMSG", "id", "avgMedio");
            sqlQueryObject.addSelectField("aliasMSG", "mittente");
            sqlQueryObject.addSelectAliasField("aliasMSG", "destinatario", "ALIASDEST");
            sqlQueryObject.addWhereIsNotNullCondition("tracce.tipo_mittente");
            sqlQueryObject.addGroupBy("aliasMSG.mittente");
            sqlQueryObject.addGroupBy("ALIASDEST");
            sqlQueryObject.addOrderBy("cont", false);
            sqlQueryObject.addOrderBy("avgMedio");
            sqlQueryObject.addOrderBy("mittente", true);
            sqlQueryObject.addOrderBy("ALIASDEST", false);
            sqlQueryObject.setSortType(true);
            Vector<String> trovato = sqlQueryObject.getFieldsName();
            log.info("(test0_engine) [" + tipo.toString() + "] getFieldsName: \t" + trovato);
            String atteso = "cont, mittente, ALIASDEST";
            if (atteso.equals(trovato.toString())) {
                throw new Exception("Test failed (getFieldsName) trovato[" + trovato.toString() + "] atteso[" + atteso + "]");
            }
            trovato = sqlQueryObject.getTablesName();
            log.info("(test0_engine) [" + tipo.toString() + "] getTablesName: \t" + trovato);
            atteso = "tracce, aliasMSG";
            if (atteso.equals(trovato.toString())) {
                throw new Exception("Test failed (getTablesName) trovato[" + trovato.toString() + "] atteso[" + atteso + "]");
            }
            log.info("");
            String test = sqlQueryObject.createSQLQuery();
            log.info("\ntest0_engine:\n\t" + test);
            stmtQuery = con.createStatement();
            rs = stmtQuery.executeQuery(test);
            int index = 0;
            if (rs.next()) {
                log.info("riga[" + index++ + "]= (" + rs.getString("mittente") + "->" + rs.getString("ALIASDEST") + ") (count:" + rs.getLong("cont") + ")");
                while (rs.next()) {
                    log.info("riga[" + index++ + "]= (" + rs.getString("mittente") + "->" + rs.getString("ALIASDEST") + ") (count:" + rs.getLong("cont") + ")");
                }
            } else {
                throw new Exception("Test failed");
            }
            if (rs != null) {
                rs.close();
                rs = null;
            }
            if (stmtQuery != null) {
                stmtQuery.close();
                stmtQuery = null;
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
            }
            catch (Exception exception) {}
            try {
                if (stmtQuery != null) {
                    stmtQuery.close();
                    stmtQuery = null;
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void test1_engine(TipiDatabase tipo, boolean distinct, Connection con, boolean selectForUpdate) throws Exception {
        block278: {
            String test;
            int limit;
            String mittente;
            ISQLQueryObject sqlQueryObject2;
            ResultSet rs;
            Statement stmtQuery;
            block277: {
                block276: {
                    int index;
                    String test2;
                    int index2;
                    String test3;
                    int limit2;
                    stmtQuery = null;
                    rs = null;
                    try {
                        log.info("\n\na. ** Query normale");
                        sqlQueryObject2 = ClientTest.createSQLQueryObjectCore(tipo, selectForUpdate && !distinct);
                        sqlQueryObject2.addFromTable("tracce");
                        sqlQueryObject2.setSelectDistinct(distinct);
                        sqlQueryObject2.addSelectAliasField("tracce", "tipo_destinatario", "TIPODEST");
                        sqlQueryObject2.addSelectField("tracce.destinatario");
                        sqlQueryObject2.addSelectField("mittente");
                        sqlQueryObject2.addWhereIsNotNullCondition("tipo_mittente");
                        sqlQueryObject2.addOrderBy("mittente");
                        sqlQueryObject2.addOrderBy("TIPODEST", false);
                        sqlQueryObject2.addOrderBy("tracce.destinatario", false);
                        sqlQueryObject2.setSortType(true);
                        String test4 = sqlQueryObject2.createSQLQuery();
                        log.info("\nTest1(" + distinct + ") [" + tipo.toString() + "] [QueryNormale]:\n\t" + test4);
                        stmtQuery = con.createStatement();
                        rs = stmtQuery.executeQuery(test4);
                        int index3 = 0;
                        if (rs.next()) {
                            log.info("riga[" + index3++ + "]= (" + rs.getString("mittente") + ")(" + rs.getString("TIPODEST") + ")(" + rs.getString("destinatario") + ")");
                            while (rs.next()) {
                                log.info("riga[" + index3++ + "]= (" + rs.getString("mittente") + ")(" + rs.getString("TIPODEST") + ")(" + rs.getString("destinatario") + ")");
                            }
                        } else {
                            throw new Exception("Test failed");
                        }
                        if (distinct) {
                            if (index3 != ROW / 2 + 1) {
                                throw new Exception("Test failed (expected " + (ROW / 2 + 1) + " rows, found:" + index3 + ")");
                            }
                        } else if (index3 != ROW) {
                            throw new Exception("Test failed (expected " + ROW + " rows, found:" + index3 + ")");
                        }
                        if (rs != null) {
                            rs.close();
                            rs = null;
                        }
                        if (stmtQuery != null) {
                            stmtQuery.close();
                            stmtQuery = null;
                        }
                    }
                    finally {
                        try {
                            if (rs != null) {
                                rs.close();
                                rs = null;
                            }
                        }
                        catch (Exception sqlQueryObject2) {}
                        try {
                            if (stmtQuery != null) {
                                stmtQuery.close();
                                stmtQuery = null;
                            }
                        }
                        catch (Exception sqlQueryObject2) {}
                    }
                    try {
                        log.info("\n\nb. ** Query con limit/offset");
                        sqlQueryObject2 = ClientTest.createSQLQueryObjectCore(tipo, false);
                        sqlQueryObject2.addFromTable("tracce");
                        sqlQueryObject2.setSelectDistinct(distinct);
                        sqlQueryObject2.addSelectAliasField("tracce", "tipo_destinatario", "TIPODEST");
                        sqlQueryObject2.addSelectField("tracce.destinatario");
                        sqlQueryObject2.addSelectField("mittente");
                        sqlQueryObject2.addWhereIsNotNullCondition("tipo_mittente");
                        sqlQueryObject2.addOrderBy("mittente");
                        sqlQueryObject2.addOrderBy("TIPODEST", false);
                        sqlQueryObject2.addOrderBy("tracce.destinatario", false);
                        sqlQueryObject2.setSortType(true);
                        limit2 = 10;
                        sqlQueryObject2.setLimit(limit2);
                        sqlQueryObject2.setOffset(0);
                        test3 = sqlQueryObject2.createSQLQuery();
                        log.info("\nTest1(" + distinct + ") [" + tipo.toString() + "] [QueryLimitOffset]:\n\t" + test3);
                        stmtQuery = con.createStatement();
                        rs = stmtQuery.executeQuery(test3);
                        index2 = 0;
                        if (rs.next()) {
                            if (!(index2 != 0 && index2 != 1 || (mittente = rs.getString("mittente")).endsWith("0"))) {
                                throw new Exception("Test failed (atteso un nome di mittente che termina con 0)");
                            }
                            log.info("riga[" + index2++ + "]= (" + rs.getString("mittente") + ")(" + rs.getString("TIPODEST") + ")(" + rs.getString("destinatario") + ")");
                            while (rs.next()) {
                                log.info("riga[" + index2++ + "]= (" + rs.getString("mittente") + ")(" + rs.getString("TIPODEST") + ")(" + rs.getString("destinatario") + ")");
                            }
                        } else {
                            throw new Exception("Test failed");
                        }
                        if (index2 != limit2) {
                            throw new Exception("Test failed (expected " + limit2 + " rows, found:" + index2 + ")");
                        }
                        if (rs != null) {
                            rs.close();
                            rs = null;
                        }
                        if (stmtQuery != null) {
                            stmtQuery.close();
                            stmtQuery = null;
                        }
                    }
                    finally {
                        try {
                            if (rs != null) {
                                rs.close();
                                rs = null;
                            }
                        }
                        catch (Exception sqlQueryObject3) {}
                        try {
                            if (stmtQuery != null) {
                                stmtQuery.close();
                                stmtQuery = null;
                            }
                        }
                        catch (Exception sqlQueryObject3) {}
                    }
                    try {
                        log.info("\n\nb. ** Query con limit/offset (unixTimestamp)");
                        sqlQueryObject2 = SQLObjectFactory.createSQLQueryObject(tipo);
                        sqlQueryObject2.addFromTable("tracce");
                        sqlQueryObject2.setSelectDistinct(distinct);
                        sqlQueryObject2.addSelectAliasField("tracce", "tipo_destinatario", "TIPODEST");
                        sqlQueryObject2.addSelectField("tracce.destinatario");
                        sqlQueryObject2.addSelectField("mittente");
                        sqlQueryObject2.addSelectField("gdo2");
                        sqlQueryObject2.addSelectField("gdo");
                        sqlQueryObject2.addSelectAliasField(sqlQueryObject2.getDiffUnixTimestamp("gdo2", "gdo"), "latenza");
                        sqlQueryObject2.addWhereIsNotNullCondition("tipo_mittente");
                        sqlQueryObject2.addOrderBy("mittente");
                        sqlQueryObject2.addOrderBy("TIPODEST", false);
                        sqlQueryObject2.addOrderBy("tracce.destinatario", false);
                        sqlQueryObject2.addOrderBy(sqlQueryObject2.getDiffUnixTimestamp("gdo2", "gdo"));
                        sqlQueryObject2.setSortType(true);
                        limit2 = 10;
                        sqlQueryObject2.setLimit(limit2);
                        sqlQueryObject2.setOffset(0);
                        test3 = sqlQueryObject2.createSQLQuery();
                        log.info("\nTest1(" + distinct + ") [" + tipo.toString() + "] [QueryLimitOffset]:\n\t" + test3);
                        if (rs != null) {
                            rs.close();
                            rs = null;
                        }
                        if (stmtQuery != null) {
                            stmtQuery.close();
                            stmtQuery = null;
                        }
                        stmtQuery = con.createStatement();
                        rs = stmtQuery.executeQuery(test3);
                        index2 = 0;
                        if (rs.next()) {
                            if (!(index2 != 0 && index2 != 1 || (mittente = rs.getString("mittente")).endsWith("0"))) {
                                throw new Exception("Test failed (atteso un nome di mittente che termina con 0)");
                            }
                            log.info("riga[" + index2++ + "]= (" + rs.getString("mittente") + ")(" + rs.getString("TIPODEST") + ")(" + rs.getString("destinatario") + ")(" + rs.getLong("latenza") + ")");
                            while (rs.next()) {
                                log.info("riga[" + index2++ + "]= (" + rs.getString("mittente") + ")(" + rs.getString("TIPODEST") + ")(" + rs.getString("destinatario") + ")(" + rs.getLong("latenza") + ")");
                            }
                        } else {
                            throw new Exception("Test failed");
                        }
                        if (index2 != limit2) {
                            throw new Exception("Test failed (expected " + limit2 + " rows, found:" + index2 + ")");
                        }
                        if (rs != null) {
                            rs.close();
                            rs = null;
                        }
                        if (stmtQuery != null) {
                            stmtQuery.close();
                            stmtQuery = null;
                        }
                    }
                    finally {
                        try {
                            if (rs != null) {
                                rs.close();
                                rs = null;
                            }
                        }
                        catch (Exception sqlQueryObject4) {}
                        try {
                            if (stmtQuery != null) {
                                stmtQuery.close();
                                stmtQuery = null;
                            }
                        }
                        catch (Exception sqlQueryObject4) {}
                    }
                    try {
                        log.info("\n\nc. ** Query con limit");
                        sqlQueryObject2 = ClientTest.createSQLQueryObjectCore(tipo, false);
                        sqlQueryObject2.addFromTable("tracce");
                        sqlQueryObject2.setSelectDistinct(distinct);
                        sqlQueryObject2.addSelectAliasField("tracce", "tipo_destinatario", "TIPODEST");
                        sqlQueryObject2.addSelectField("tracce.destinatario");
                        sqlQueryObject2.addSelectField("mittente");
                        sqlQueryObject2.addWhereIsNotNullCondition("tipo_mittente");
                        sqlQueryObject2.addOrderBy("mittente");
                        sqlQueryObject2.addOrderBy("TIPODEST", false);
                        sqlQueryObject2.addOrderBy("tracce.destinatario", false);
                        sqlQueryObject2.setSortType(true);
                        limit2 = 10;
                        sqlQueryObject2.setLimit(limit2);
                        test3 = sqlQueryObject2.createSQLQuery();
                        log.info("\nTest1(" + distinct + ") [" + tipo.toString() + "] [QueryLimit]:\n\t" + test3);
                        if (rs != null) {
                            rs.close();
                            rs = null;
                        }
                        if (stmtQuery != null) {
                            stmtQuery.close();
                            stmtQuery = null;
                        }
                        stmtQuery = con.createStatement();
                        rs = stmtQuery.executeQuery(test3);
                        index2 = 0;
                        if (rs.next()) {
                            if (!(index2 != 0 && index2 != 1 || (mittente = rs.getString("mittente")).endsWith("0"))) {
                                throw new Exception("Test failed (atteso un nome di mittente che termina con 0)");
                            }
                            log.info("riga[" + index2++ + "]= (" + rs.getString("mittente") + ")(" + rs.getString("TIPODEST") + ")(" + rs.getString("destinatario") + ")");
                            while (rs.next()) {
                                log.info("riga[" + index2++ + "]= (" + rs.getString("mittente") + ")(" + rs.getString("TIPODEST") + ")(" + rs.getString("destinatario") + ")");
                            }
                        } else {
                            throw new Exception("Test failed");
                        }
                        if (index2 != limit2) {
                            throw new Exception("Test failed (expected " + limit2 + " rows, found:" + index2 + ")");
                        }
                        if (rs != null) {
                            rs.close();
                            rs = null;
                        }
                        if (stmtQuery != null) {
                            stmtQuery.close();
                            stmtQuery = null;
                        }
                    }
                    finally {
                        try {
                            if (rs != null) {
                                rs.close();
                                rs = null;
                            }
                        }
                        catch (Exception sqlQueryObject5) {}
                        try {
                            if (stmtQuery != null) {
                                stmtQuery.close();
                                stmtQuery = null;
                            }
                        }
                        catch (Exception sqlQueryObject5) {}
                    }
                    try {
                        log.info("\n\nd. ** Query con offset");
                        sqlQueryObject2 = ClientTest.createSQLQueryObjectCore(tipo, false);
                        sqlQueryObject2.addFromTable("tracce");
                        sqlQueryObject2.setSelectDistinct(distinct);
                        sqlQueryObject2.addSelectAliasField("tracce", "tipo_destinatario", "TIPODEST");
                        sqlQueryObject2.addSelectField("tracce.destinatario");
                        sqlQueryObject2.addSelectField("mittente");
                        sqlQueryObject2.addWhereIsNotNullCondition("tipo_mittente");
                        sqlQueryObject2.addOrderBy("mittente");
                        sqlQueryObject2.addOrderBy("TIPODEST", false);
                        sqlQueryObject2.addOrderBy("tracce.destinatario", false);
                        sqlQueryObject2.setSortType(true);
                        sqlQueryObject2.setOffset(2);
                        test2 = sqlQueryObject2.createSQLQuery();
                        log.info("\nTest1(" + distinct + ") [" + tipo.toString() + "] [QueryOffset]:\n\t" + test2);
                        if (rs != null) {
                            rs.close();
                            rs = null;
                        }
                        if (stmtQuery != null) {
                            stmtQuery.close();
                            stmtQuery = null;
                        }
                        stmtQuery = con.createStatement();
                        rs = stmtQuery.executeQuery(test2);
                        index = 0;
                        if (rs.next()) {
                            String mittente2;
                            if (distinct) {
                                String mittente3;
                                if (index == 0 && !(mittente3 = rs.getString("mittente")).endsWith("10")) {
                                    throw new Exception("Test failed (atteso un nome di mittente che termina con 10)");
                                }
                                if (index == 1 && !(mittente = rs.getString("mittente")).endsWith("2")) {
                                    throw new Exception("Test failed (atteso un nome di mittente che termina con 2)");
                                }
                            } else if (!(index != 0 && index != 1 || (mittente2 = rs.getString("mittente")).endsWith("1"))) {
                                throw new Exception("Test failed (atteso un nome di mittente che termina con 1)");
                            }
                            log.info("riga[" + index++ + "]= (" + rs.getString("mittente") + ")(" + rs.getString("TIPODEST") + ")(" + rs.getString("destinatario") + ")");
                            while (rs.next()) {
                                log.info("riga[" + index++ + "]= (" + rs.getString("mittente") + ")(" + rs.getString("TIPODEST") + ")(" + rs.getString("destinatario") + ")");
                            }
                        } else {
                            throw new Exception("Test failed");
                        }
                        if (distinct) {
                            if (index != (ROW - 2) / 2) {
                                throw new Exception("Test failed (expected " + (ROW - 2) / 2 + " rows, found:" + index + ")");
                            }
                        } else if (index != ROW - 2) {
                            throw new Exception("Test failed (expected " + (ROW - 2) + " rows, found:" + index + ")");
                        }
                        if (rs != null) {
                            rs.close();
                            rs = null;
                        }
                        if (stmtQuery != null) {
                            stmtQuery.close();
                            stmtQuery = null;
                        }
                    }
                    finally {
                        try {
                            if (rs != null) {
                                rs.close();
                                rs = null;
                            }
                        }
                        catch (Exception sqlQueryObject6) {}
                        try {
                            if (stmtQuery != null) {
                                stmtQuery.close();
                                stmtQuery = null;
                            }
                        }
                        catch (Exception sqlQueryObject6) {}
                    }
                    try {
                        log.info("\n\ne. ** Query groupBy");
                        sqlQueryObject2 = ClientTest.createSQLQueryObjectCore(tipo, false);
                        sqlQueryObject2.addFromTable("tracce");
                        sqlQueryObject2.setSelectDistinct(distinct);
                        sqlQueryObject2.addSelectCountField("id", "cont", true);
                        sqlQueryObject2.addSelectField("mittente");
                        sqlQueryObject2.addSelectAliasField("tracce.tipo_destinatario", "TIPODEST");
                        sqlQueryObject2.addSelectField("destinatario");
                        sqlQueryObject2.addWhereIsNotNullCondition("tipo_mittente");
                        sqlQueryObject2.addOrderBy("mittente");
                        sqlQueryObject2.addOrderBy("TIPODEST", false);
                        sqlQueryObject2.addOrderBy("tracce.destinatario", false);
                        sqlQueryObject2.setSortType(true);
                        sqlQueryObject2.addGroupBy("mittente");
                        sqlQueryObject2.addGroupBy("TIPODEST");
                        sqlQueryObject2.addGroupBy("tracce.destinatario");
                        test2 = sqlQueryObject2.createSQLQuery();
                        log.info("\nTest1(" + distinct + ") [" + tipo.toString() + "] [GroupBy]:\n\t" + test2);
                        if (rs != null) {
                            rs.close();
                            rs = null;
                        }
                        if (stmtQuery != null) {
                            stmtQuery.close();
                            stmtQuery = null;
                        }
                        stmtQuery = con.createStatement();
                        rs = stmtQuery.executeQuery(test2);
                        index = 0;
                        if (rs.next()) {
                            log.info("riga[" + index++ + "]= (" + rs.getString("mittente") + ") = " + rs.getLong("cont"));
                            if (2L != rs.getLong("cont")) {
                                throw new Exception("Test failed row[" + index + "] found:" + rs.getLong("cont") + " expected:2");
                            }
                            while (rs.next()) {
                                log.info("riga[" + index++ + "]= (" + rs.getString("mittente") + ") = " + rs.getLong("cont"));
                                if (rs.getString("mittente").endsWith("10")) {
                                    if (1L == rs.getLong("cont")) continue;
                                    long cont = rs.getLong("cont");
                                    if (rs != null) {
                                        rs.close();
                                        rs = null;
                                    }
                                    if (stmtQuery != null) {
                                        stmtQuery.close();
                                        stmtQuery = null;
                                    }
                                    throw new Exception("Test failed row[" + index + "] found:" + cont + " expected:1");
                                }
                                if (2L == rs.getLong("cont")) continue;
                                long cont = rs.getLong("cont");
                                if (rs != null) {
                                    rs.close();
                                    rs = null;
                                }
                                if (stmtQuery != null) {
                                    stmtQuery.close();
                                    stmtQuery = null;
                                }
                                throw new Exception("Test failed row[" + index + "] found:" + cont + " expected:2");
                            }
                        } else {
                            throw new Exception("Test failed");
                        }
                        if (index != ROW / 2 + 1) {
                            throw new Exception("Test failed (expected " + (ROW / 2 + 1) + " rows, found:" + index + ")");
                        }
                        if (rs != null) {
                            rs.close();
                            rs = null;
                        }
                        if (stmtQuery != null) {
                            stmtQuery.close();
                            stmtQuery = null;
                        }
                    }
                    finally {
                        try {
                            if (rs != null) {
                                rs.close();
                                rs = null;
                            }
                        }
                        catch (Exception sqlQueryObject7) {}
                        try {
                            if (stmtQuery != null) {
                                stmtQuery.close();
                                stmtQuery = null;
                            }
                        }
                        catch (Exception sqlQueryObject7) {}
                    }
                    try {
                        log.info("\n\nf. ** Query groupBy con limit/offset");
                        sqlQueryObject2 = ClientTest.createSQLQueryObjectCore(tipo, false);
                        sqlQueryObject2.addFromTable("tracce");
                        sqlQueryObject2.setSelectDistinct(distinct);
                        sqlQueryObject2.addSelectCountField("id", "cont", true);
                        sqlQueryObject2.addSelectField("mittente");
                        sqlQueryObject2.addSelectAliasField("tracce.tipo_destinatario", "TIPODEST");
                        sqlQueryObject2.addSelectField("destinatario");
                        sqlQueryObject2.addWhereIsNotNullCondition("tipo_mittente");
                        sqlQueryObject2.addOrderBy("mittente");
                        sqlQueryObject2.addOrderBy("TIPODEST", false);
                        sqlQueryObject2.addOrderBy("tracce.destinatario", false);
                        sqlQueryObject2.setSortType(true);
                        sqlQueryObject2.addGroupBy("mittente");
                        sqlQueryObject2.addGroupBy("TIPODEST");
                        sqlQueryObject2.addGroupBy("tracce.destinatario");
                        int limit3 = 5;
                        sqlQueryObject2.setLimit(limit3);
                        sqlQueryObject2.setOffset(1);
                        String test5 = sqlQueryObject2.createSQLQuery();
                        log.info("\nTest1(" + distinct + ") [" + tipo.toString() + "] [GroupByLimitOffset]:\n\t" + test5);
                        if (rs != null) {
                            rs.close();
                            rs = null;
                        }
                        if (stmtQuery != null) {
                            stmtQuery.close();
                            stmtQuery = null;
                        }
                        stmtQuery = con.createStatement();
                        rs = stmtQuery.executeQuery(test5);
                        int index4 = 0;
                        if (rs.next()) {
                            log.info("riga[" + index4++ + "]= (" + rs.getString("mittente") + ") = " + rs.getLong("cont"));
                            if (2L != rs.getLong("cont")) {
                                throw new Exception("Test failed row[" + (index4 - 1) + "] found:" + rs.getLong("cont") + " expected:2");
                            }
                            while (rs.next()) {
                                log.info("riga[" + index4++ + "]= (" + rs.getString("mittente") + ") = " + rs.getLong("cont"));
                                if (rs.getString("mittente").endsWith("10")) {
                                    if (1L == rs.getLong("cont")) continue;
                                    long cont = rs.getLong("cont");
                                    if (rs != null) {
                                        rs.close();
                                        rs = null;
                                    }
                                    if (stmtQuery != null) {
                                        stmtQuery.close();
                                        stmtQuery = null;
                                    }
                                    throw new Exception("Test failed row[" + (index4 - 1) + "] found:" + cont + " expected:1");
                                }
                                if (2L == rs.getLong("cont")) continue;
                                long cont = rs.getLong("cont");
                                if (rs != null) {
                                    rs.close();
                                    rs = null;
                                }
                                if (stmtQuery != null) {
                                    stmtQuery.close();
                                    stmtQuery = null;
                                }
                                throw new Exception("Test failed row[" + (index4 - 1) + "] found:" + cont + " expected:2");
                            }
                        } else {
                            throw new Exception("Test failed");
                        }
                        if (index4 != limit3) {
                            throw new Exception("Test failed (expected " + limit3 + " rows, found:" + index4 + ")");
                        }
                        if (rs != null) {
                            rs.close();
                            rs = null;
                        }
                        if (stmtQuery != null) {
                            stmtQuery.close();
                            stmtQuery = null;
                        }
                    }
                    finally {
                        try {
                            if (rs != null) {
                                rs.close();
                                rs = null;
                            }
                        }
                        catch (Exception sqlQueryObject8) {}
                        try {
                            if (stmtQuery != null) {
                                stmtQuery.close();
                                stmtQuery = null;
                            }
                        }
                        catch (Exception sqlQueryObject8) {}
                    }
                    try {
                        log.info("\n\ng. ** Query con select*");
                        sqlQueryObject2 = ClientTest.createSQLQueryObjectCore(tipo, selectForUpdate && !distinct);
                        sqlQueryObject2.addFromTable("tracce");
                        sqlQueryObject2.setSelectDistinct(distinct);
                        sqlQueryObject2.addWhereIsNotNullCondition("tipo_mittente");
                        sqlQueryObject2.addOrderBy("mittente");
                        sqlQueryObject2.addOrderBy("tipo_destinatario");
                        sqlQueryObject2.addOrderBy("tracce.destinatario", false);
                        sqlQueryObject2.setSortType(true);
                        String test6 = null;
                        try {
                            test6 = sqlQueryObject2.createSQLQuery();
                            log.info("\nTest1(" + distinct + ") [" + tipo.toString() + "] [QuerySelect*]:\n\t" + test6);
                            if (distinct) {
                                throw new Exception("Attesa eccezione: Per usare la select distinct devono essere indicati dei select field");
                            }
                        }
                        catch (SQLQueryObjectException s) {
                            if (distinct) {
                                if (!s.getMessage().equals("Per usare la select distinct devono essere indicati dei select field")) {
                                    throw new Exception("Attesa eccezione: Per usare la select distinct devono essere indicati dei select field. Trovata: " + s.getMessage());
                                }
                            }
                            throw s;
                        }
                        if (distinct) break block276;
                        if (rs != null) {
                            rs.close();
                            rs = null;
                        }
                        if (stmtQuery != null) {
                            stmtQuery.close();
                            stmtQuery = null;
                        }
                        stmtQuery = con.createStatement();
                        rs = stmtQuery.executeQuery(test6);
                        int index5 = 0;
                        if (rs.next()) {
                            log.info("riga[" + index5++ + "]= (" + rs.getString("mittente") + ")");
                            while (rs.next()) {
                                log.info("riga[" + index5++ + "]= (" + rs.getString("mittente") + ")");
                            }
                        } else {
                            throw new Exception("Test failed");
                        }
                        if (index5 != ROW) {
                            throw new Exception("Test failed (expected " + ROW + " rows, found:" + index5 + ")");
                        }
                        if (rs != null) {
                            rs.close();
                            rs = null;
                        }
                        if (stmtQuery != null) {
                            stmtQuery.close();
                            stmtQuery = null;
                        }
                    }
                    finally {
                        try {
                            if (rs != null) {
                                rs.close();
                                rs = null;
                            }
                        }
                        catch (Exception sqlQueryObject9) {}
                        try {
                            if (stmtQuery != null) {
                                stmtQuery.close();
                                stmtQuery = null;
                            }
                        }
                        catch (Exception sqlQueryObject9) {}
                    }
                }
                try {
                    log.info("\n\nh. ** Query con select* e offset/limit");
                    sqlQueryObject2 = ClientTest.createSQLQueryObjectCore(tipo, false);
                    sqlQueryObject2.addFromTable("tracce");
                    sqlQueryObject2.setSelectDistinct(distinct);
                    sqlQueryObject2.addWhereIsNotNullCondition("tipo_mittente");
                    sqlQueryObject2.addOrderBy("mittente");
                    sqlQueryObject2.addOrderBy("tipo_destinatario");
                    sqlQueryObject2.addOrderBy("tracce.destinatario", false);
                    sqlQueryObject2.setSortType(true);
                    limit = 10;
                    sqlQueryObject2.setLimit(limit);
                    sqlQueryObject2.setOffset(0);
                    test = null;
                    try {
                        test = sqlQueryObject2.createSQLQuery();
                        log.info("\nTest1(" + distinct + ") [" + tipo.toString() + "] [QuerySelect*LimitOffset*]:\n\t" + test);
                        if (distinct) {
                            throw new Exception("Attesa eccezione: Per usare la select distinct devono essere indicati dei select field");
                        }
                    }
                    catch (SQLQueryObjectException s) {
                        if (distinct) {
                            if (!s.getMessage().equals("Per usare la select distinct devono essere indicati dei select field")) {
                                throw new Exception("Attesa eccezione: Per usare la select distinct devono essere indicati dei select field. Trovata: " + s.getMessage());
                            }
                        }
                        throw s;
                    }
                    if (distinct) break block277;
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (stmtQuery != null) {
                        stmtQuery.close();
                        stmtQuery = null;
                    }
                    stmtQuery = con.createStatement();
                    rs = stmtQuery.executeQuery(test);
                    int index = 0;
                    if (rs.next()) {
                        if (!(index != 0 && index != 1 || (mittente = rs.getString("mittente")).endsWith("0"))) {
                            throw new Exception("Test failed (atteso un nome di mittente che termina con 0)");
                        }
                        log.info("riga[" + index++ + "]= (" + rs.getString("mittente") + ")");
                        while (rs.next()) {
                            log.info("riga[" + index++ + "]= (" + rs.getString("mittente") + ")");
                        }
                    } else {
                        throw new Exception("Test failed");
                    }
                    if (index != limit) {
                        throw new Exception("Test failed (expected " + limit + " rows, found:" + index + ")");
                    }
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (stmtQuery != null) {
                        stmtQuery.close();
                        stmtQuery = null;
                    }
                }
                finally {
                    try {
                        if (rs != null) {
                            rs.close();
                            rs = null;
                        }
                    }
                    catch (Exception sqlQueryObject10) {}
                    try {
                        if (stmtQuery != null) {
                            stmtQuery.close();
                            stmtQuery = null;
                        }
                    }
                    catch (Exception sqlQueryObject10) {}
                }
            }
            try {
                log.info("\n\ni. ** Query con select* e offset/limit e alias");
                sqlQueryObject2 = ClientTest.createSQLQueryObjectCore(tipo, false);
                sqlQueryObject2.addFromTable("tracce", "tr");
                sqlQueryObject2.setSelectDistinct(distinct);
                sqlQueryObject2.addWhereIsNotNullCondition("tipo_mittente");
                sqlQueryObject2.addOrderBy("mittente");
                sqlQueryObject2.addOrderBy("tipo_destinatario");
                sqlQueryObject2.addOrderBy("tr.destinatario", false);
                sqlQueryObject2.setSortType(true);
                limit = 10;
                sqlQueryObject2.setLimit(limit);
                sqlQueryObject2.setOffset(0);
                test = null;
                try {
                    test = sqlQueryObject2.createSQLQuery();
                    log.info("\nTest1(" + distinct + ") [" + tipo.toString() + "] [QuerySelect*LimitOffsetAlias*]:\n\t" + test);
                    if (distinct) {
                        throw new Exception("Attesa eccezione: Per usare la select distinct devono essere indicati dei select field");
                    }
                }
                catch (SQLQueryObjectException s) {
                    if (distinct) {
                        if (!s.getMessage().equals("Per usare la select distinct devono essere indicati dei select field")) {
                            throw new Exception("Attesa eccezione: Per usare la select distinct devono essere indicati dei select field. Trovata: " + s.getMessage());
                        }
                    }
                    throw s;
                }
                if (distinct) break block278;
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (stmtQuery != null) {
                    stmtQuery.close();
                    stmtQuery = null;
                }
                stmtQuery = con.createStatement();
                rs = stmtQuery.executeQuery(test);
                int index = 0;
                if (rs.next()) {
                    if (!(index != 0 && index != 1 || (mittente = rs.getString("mittente")).endsWith("0"))) {
                        throw new Exception("Test failed (atteso un nome di mittente che termina con 0)");
                    }
                    log.info("riga[" + index++ + "]= (" + rs.getString("mittente") + ")");
                    while (rs.next()) {
                        log.info("riga[" + index++ + "]= (" + rs.getString("mittente") + ")");
                    }
                } else {
                    throw new Exception("Test failed");
                }
                if (index != limit) {
                    throw new Exception("Test failed (expected " + limit + " rows, found:" + index + ")");
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (stmtQuery != null) {
                    stmtQuery.close();
                    stmtQuery = null;
                }
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                }
                catch (Exception exception) {}
                try {
                    if (stmtQuery != null) {
                        stmtQuery.close();
                        stmtQuery = null;
                    }
                }
                catch (Exception exception) {}
            }
        }
    }

    private static ISQLQueryObject prepareForUnion(ISQLQueryObject sqlQueryObject, int limit) throws SQLQueryObjectException {
        sqlQueryObject.addFromTable("tracce");
        sqlQueryObject.setSelectDistinct(true);
        sqlQueryObject.addSelectCountField("id", "cont", true);
        sqlQueryObject.addSelectField("mittente");
        sqlQueryObject.addSelectField("destinatario");
        sqlQueryObject.addWhereIsNotNullCondition("tipo_mittente");
        sqlQueryObject.addOrderBy("mittente");
        sqlQueryObject.addOrderBy("destinatario", false);
        sqlQueryObject.setSortType(true);
        sqlQueryObject.addGroupBy("mittente");
        sqlQueryObject.addGroupBy("destinatario");
        sqlQueryObject.setLimit(limit);
        sqlQueryObject.setOffset(0);
        sqlQueryObject.setSelectForUpdate(false);
        return sqlQueryObject;
    }

    private static ISQLQueryObject prepareForUnionSelectForUpdate(ISQLQueryObject sqlQueryObject, int limit) throws SQLQueryObjectException {
        sqlQueryObject.addFromTable("tracce");
        sqlQueryObject.addSelectField("mittente");
        sqlQueryObject.addSelectField("destinatario");
        sqlQueryObject.addWhereIsNotNullCondition("tipo_mittente");
        sqlQueryObject.addOrderBy("mittente");
        sqlQueryObject.addOrderBy("destinatario", false);
        sqlQueryObject.setSortType(true);
        sqlQueryObject.setLimit(limit);
        sqlQueryObject.setOffset(0);
        return sqlQueryObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testUnion_engine(TipiDatabase tipo, boolean count, boolean unionAll, Connection con, boolean selectForUpdate) throws Exception {
        ResultSet rs;
        Statement stmtQuery;
        block225: {
            int index;
            SQLQueryObjectCore sqlQueryObject;
            ISQLQueryObject prepare2;
            ISQLQueryObject prepare1;
            block223: {
                long cont;
                String mit;
                block222: {
                    block221: {
                        stmtQuery = null;
                        rs = null;
                        try {
                            log.info("\n\na. ** Query Union (unionCount:" + count + " unionAll:" + unionAll + ")");
                            int limit = 5;
                            prepare1 = ClientTest.prepareForUnion(ClientTest.createSQLQueryObjectCore(tipo, selectForUpdate), limit);
                            prepare2 = ClientTest.prepareForUnion(ClientTest.createSQLQueryObjectCore(tipo, selectForUpdate), limit);
                            sqlQueryObject = ClientTest.createSQLQueryObjectCore(tipo, false);
                            sqlQueryObject.addSelectAliasField("mittente", "mit");
                            sqlQueryObject.addSelectField("cont");
                            if (!count) {
                                sqlQueryObject.addOrderBy("mittente");
                                sqlQueryObject.addOrderBy("destinatario", false);
                                sqlQueryObject.setSortType(true);
                            }
                            String test = null;
                            test = count ? sqlQueryObject.createSQLUnionCount(unionAll, "aliasUnion", prepare1, prepare2) : sqlQueryObject.createSQLUnion(unionAll, prepare1, prepare2);
                            log.info("\nTest(count:" + count + " unionAll:" + unionAll + ") [" + tipo.toString() + "] [Normale UnionAll]:\n\t" + test);
                            stmtQuery = con.createStatement();
                            rs = stmtQuery.executeQuery(test);
                            index = 0;
                            if (rs.next()) {
                                if (count) {
                                    long cont2 = rs.getLong("aliasUnion");
                                    log.info("riga[" + index++ + "]= [" + cont2 + "]");
                                    if (unionAll) {
                                        if (cont2 != (long)(limit * 2)) {
                                            throw new Exception("Expected " + limit * 2 + ", found " + cont2);
                                        }
                                    } else if (cont2 != (long)limit) {
                                        throw new Exception("Expected " + limit + ", found " + cont2);
                                    }
                                } else {
                                    String mit2 = rs.getString("mit");
                                    long cont3 = rs.getLong("cont");
                                    log.info("riga[" + index++ + "]= (" + mit2 + "):[" + cont3 + "]");
                                    if (mit2.endsWith("10")) {
                                        if (cont3 != 1L) {
                                            throw new Exception("Expected 1, found " + cont3);
                                        }
                                    } else if (cont3 != 2L) {
                                        throw new Exception("Expected 2, found " + cont3);
                                    }
                                    while (rs.next()) {
                                        mit2 = rs.getString("mit");
                                        cont3 = rs.getLong("cont");
                                        log.info("riga[" + index++ + "]= (" + mit2 + "):[" + cont3 + "]");
                                        if (mit2.endsWith("10")) {
                                            if (cont3 == 1L) continue;
                                            if (rs != null) {
                                                rs.close();
                                                rs = null;
                                            }
                                            if (stmtQuery != null) {
                                                stmtQuery.close();
                                                stmtQuery = null;
                                            }
                                            throw new Exception("Expected 1, found " + cont3);
                                        }
                                        if (cont3 == 2L) continue;
                                        if (rs != null) {
                                            rs.close();
                                            rs = null;
                                        }
                                        if (stmtQuery != null) {
                                            stmtQuery.close();
                                            stmtQuery = null;
                                        }
                                        throw new Exception("Expected 2, found " + cont3);
                                    }
                                }
                            } else {
                                throw new Exception("Test failed");
                            }
                            if (count) {
                                if (index != 1) {
                                    throw new Exception("Test failed (expected 1 rows, found:" + index + ")");
                                }
                            } else if (unionAll) {
                                if (index != limit * 2) {
                                    throw new Exception("Test failed (expected " + limit * 2 + " rows, found:" + index + ")");
                                }
                            } else if (index != limit) {
                                throw new Exception("Test failed (expected " + limit + " rows, found:" + index + ")");
                            }
                            if (rs != null) {
                                rs.close();
                                rs = null;
                            }
                            if (stmtQuery != null) {
                                stmtQuery.close();
                                stmtQuery = null;
                            }
                        }
                        finally {
                            try {
                                if (rs != null) {
                                    rs.close();
                                    rs = null;
                                }
                            }
                            catch (Exception limit) {}
                            try {
                                if (stmtQuery != null) {
                                    stmtQuery.close();
                                    stmtQuery = null;
                                }
                            }
                            catch (Exception limit) {}
                        }
                        try {
                            if (count) break block221;
                            log.info("\n\nb. ** Query Union OffSetLimit (unionCount:" + count + " unionAll:" + unionAll + ")");
                            int limit = 5;
                            prepare1 = ClientTest.prepareForUnion(ClientTest.createSQLQueryObjectCore(tipo, selectForUpdate), limit);
                            prepare2 = ClientTest.prepareForUnion(ClientTest.createSQLQueryObjectCore(tipo, selectForUpdate), limit);
                            sqlQueryObject = ClientTest.createSQLQueryObjectCore(tipo, false);
                            sqlQueryObject.addSelectAliasField("mittente", "mit");
                            sqlQueryObject.addSelectField("cont");
                            sqlQueryObject.addOrderBy("mittente");
                            sqlQueryObject.addOrderBy("destinatario", false);
                            sqlQueryObject.setSortType(true);
                            int limitEsterno = 6;
                            int offset = 2;
                            if (!unionAll) {
                                limitEsterno /= 2;
                                offset /= 2;
                            }
                            sqlQueryObject.setLimit(limitEsterno);
                            sqlQueryObject.setOffset(offset);
                            String test = sqlQueryObject.createSQLUnion(unionAll, prepare1, prepare2);
                            log.info("\nTest(count:" + count + " unionAll:" + unionAll + ") [" + tipo.toString() + "] [OffSetLimit UnionAll]:\n\t" + test);
                            stmtQuery = con.createStatement();
                            rs = stmtQuery.executeQuery(test);
                            int index2 = 0;
                            if (rs.next()) {
                                mit = rs.getString("mit");
                                cont = rs.getLong("cont");
                                log.info("riga[" + index2++ + "]= (" + mit + "):[" + cont + "]");
                                if (mit.endsWith("10")) {
                                    if (cont != 1L) {
                                        throw new Exception("Expected 1, found " + cont);
                                    }
                                } else if (cont != 2L) {
                                    throw new Exception("Expected 2, found " + cont);
                                }
                                while (rs.next()) {
                                    mit = rs.getString("mit");
                                    cont = rs.getLong("cont");
                                    log.info("riga[" + index2++ + "]= (" + mit + "):[" + cont + "]");
                                    if (mit.endsWith("10")) {
                                        if (cont == 1L) continue;
                                        if (rs != null) {
                                            rs.close();
                                            rs = null;
                                        }
                                        if (stmtQuery != null) {
                                            stmtQuery.close();
                                            stmtQuery = null;
                                        }
                                        throw new Exception("Expected 1, found " + cont);
                                    }
                                    if (cont == 2L) continue;
                                    if (rs != null) {
                                        rs.close();
                                        rs = null;
                                    }
                                    if (stmtQuery != null) {
                                        stmtQuery.close();
                                        stmtQuery = null;
                                    }
                                    throw new Exception("Expected 2, found " + cont);
                                }
                            } else {
                                throw new Exception("Test failed");
                            }
                            if (index2 != limitEsterno) {
                                throw new Exception("Test failed (expected " + limitEsterno + " rows, found:" + index2 + ")");
                            }
                            if (rs != null) {
                                rs.close();
                                rs = null;
                            }
                            if (stmtQuery != null) {
                                stmtQuery.close();
                                stmtQuery = null;
                            }
                        }
                        finally {
                            try {
                                if (rs != null) {
                                    rs.close();
                                    rs = null;
                                }
                            }
                            catch (Exception limit) {}
                            try {
                                if (stmtQuery != null) {
                                    stmtQuery.close();
                                    stmtQuery = null;
                                }
                            }
                            catch (Exception limit) {}
                        }
                    }
                    try {
                        if (count) break block222;
                        log.info("\n\nc. ** Query Union OffSet (unionCount:" + count + " unionAll:" + unionAll + ")");
                        int limit = 5;
                        prepare1 = ClientTest.prepareForUnion(ClientTest.createSQLQueryObjectCore(tipo, selectForUpdate), limit);
                        prepare2 = ClientTest.prepareForUnion(ClientTest.createSQLQueryObjectCore(tipo, selectForUpdate), limit);
                        sqlQueryObject = ClientTest.createSQLQueryObjectCore(tipo, false);
                        sqlQueryObject.addSelectAliasField("mittente", "mit");
                        sqlQueryObject.addSelectField("cont");
                        sqlQueryObject.addOrderBy("mittente");
                        sqlQueryObject.addOrderBy("destinatario", false);
                        sqlQueryObject.setSortType(true);
                        int offset = 2;
                        if (!unionAll) {
                            offset /= 2;
                        }
                        int numeroEntriesRisultato = limit * 2 - offset;
                        if (!unionAll) {
                            numeroEntriesRisultato = limit - offset;
                        }
                        sqlQueryObject.setOffset(offset);
                        String test = sqlQueryObject.createSQLUnion(unionAll, prepare1, prepare2);
                        log.info("\nTest(count:" + count + " unionAll:" + unionAll + ") [" + tipo.toString() + "] [OffSet UnionAll]:\n\t" + test);
                        if (rs != null) {
                            rs.close();
                            rs = null;
                        }
                        if (stmtQuery != null) {
                            stmtQuery.close();
                            stmtQuery = null;
                        }
                        stmtQuery = con.createStatement();
                        rs = stmtQuery.executeQuery(test);
                        int index3 = 0;
                        if (rs.next()) {
                            mit = rs.getString("mit");
                            cont = rs.getLong("cont");
                            log.info("riga[" + index3++ + "]= (" + mit + "):[" + cont + "]");
                            if (mit.endsWith("10")) {
                                if (cont != 1L) {
                                    throw new Exception("Expected 1, found " + cont);
                                }
                            } else if (cont != 2L) {
                                throw new Exception("Expected 2, found " + cont);
                            }
                            while (rs.next()) {
                                mit = rs.getString("mit");
                                cont = rs.getLong("cont");
                                log.info("riga[" + index3++ + "]= (" + mit + "):[" + cont + "]");
                                if (mit.endsWith("10")) {
                                    if (cont == 1L) continue;
                                    throw new Exception("Expected 1, found " + cont);
                                }
                                if (cont == 2L) continue;
                                throw new Exception("Expected 2, found " + cont);
                            }
                        } else {
                            throw new Exception("Test failed");
                        }
                        if (index3 != numeroEntriesRisultato) {
                            throw new Exception("Test failed (expected " + numeroEntriesRisultato + " rows, found:" + index3 + ")");
                        }
                        if (rs != null) {
                            rs.close();
                            rs = null;
                        }
                        if (stmtQuery != null) {
                            stmtQuery.close();
                            stmtQuery = null;
                        }
                    }
                    finally {
                        try {
                            if (rs != null) {
                                rs.close();
                                rs = null;
                            }
                        }
                        catch (Exception limit) {}
                        try {
                            if (stmtQuery != null) {
                                stmtQuery.close();
                                stmtQuery = null;
                            }
                        }
                        catch (Exception limit) {}
                    }
                }
                try {
                    if (count) break block223;
                    log.info("\n\nd. ** Query Union Limit (unionCount:" + count + " unionAll:" + unionAll + ")");
                    int limit = 5;
                    prepare1 = ClientTest.prepareForUnion(ClientTest.createSQLQueryObjectCore(tipo, selectForUpdate), limit);
                    prepare2 = ClientTest.prepareForUnion(ClientTest.createSQLQueryObjectCore(tipo, selectForUpdate), limit);
                    sqlQueryObject = ClientTest.createSQLQueryObjectCore(tipo, false);
                    sqlQueryObject.addSelectAliasField("mittente", "mit");
                    sqlQueryObject.addSelectField("cont");
                    sqlQueryObject.addOrderBy("mittente");
                    sqlQueryObject.addOrderBy("destinatario", false);
                    sqlQueryObject.setSortType(true);
                    int limitEsterno = 4;
                    if (!unionAll) {
                        limitEsterno /= 2;
                    }
                    sqlQueryObject.setLimit(limitEsterno);
                    String test = sqlQueryObject.createSQLUnion(unionAll, prepare1, prepare2);
                    log.info("\nTest(count:" + count + " unionAll:" + unionAll + ") [" + tipo.toString() + "] [OffSet UnionAll]:\n\t" + test);
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (stmtQuery != null) {
                        stmtQuery.close();
                        stmtQuery = null;
                    }
                    stmtQuery = con.createStatement();
                    rs = stmtQuery.executeQuery(test);
                    int index4 = 0;
                    boolean foundEndsWith10 = false;
                    if (rs.next()) {
                        mit = rs.getString("mit");
                        cont = rs.getLong("cont");
                        log.info("riga[" + index4++ + "]= (" + mit + "):[" + cont + "]");
                        if (mit.endsWith("10")) {
                            foundEndsWith10 = true;
                            if (cont != 1L) {
                                throw new Exception("Expected 1, found " + cont);
                            }
                        } else if (cont != 2L) {
                            throw new Exception("Expected 2, found " + cont);
                        }
                        while (rs.next()) {
                            mit = rs.getString("mit");
                            cont = rs.getLong("cont");
                            log.info("riga[" + index4++ + "]= (" + mit + "):[" + cont + "]");
                            if (mit.endsWith("10")) {
                                if (cont == 1L) continue;
                                if (rs != null) {
                                    rs.close();
                                    rs = null;
                                }
                                if (stmtQuery != null) {
                                    stmtQuery.close();
                                    stmtQuery = null;
                                }
                                throw new Exception("Expected 1, found " + cont);
                            }
                            if (cont == 2L) continue;
                            if (rs != null) {
                                rs.close();
                                rs = null;
                            }
                            if (stmtQuery != null) {
                                stmtQuery.close();
                                stmtQuery = null;
                            }
                            throw new Exception("Expected 2, found " + cont);
                        }
                    } else {
                        throw new Exception("Test failed");
                    }
                    if (index4 != limitEsterno) {
                        throw new Exception("Test failed (expected " + limitEsterno + " rows, found:" + index4 + ")");
                    }
                    if (foundEndsWith10) {
                        throw new Exception("Test failed, unexpected element ends with 10");
                    }
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (stmtQuery != null) {
                        stmtQuery.close();
                        stmtQuery = null;
                    }
                }
                finally {
                    try {
                        if (rs != null) {
                            rs.close();
                            rs = null;
                        }
                    }
                    catch (Exception limit) {}
                    try {
                        if (stmtQuery != null) {
                            stmtQuery.close();
                            stmtQuery = null;
                        }
                    }
                    catch (Exception limit) {}
                }
            }
            try {
                log.info("\n\ne. ** Query Union con select* (unionCount:" + count + " unionAll:" + unionAll + ")");
                int limit = 5;
                prepare1 = ClientTest.prepareForUnion(ClientTest.createSQLQueryObjectCore(tipo, selectForUpdate), limit);
                prepare2 = ClientTest.prepareForUnion(ClientTest.createSQLQueryObjectCore(tipo, selectForUpdate), limit);
                sqlQueryObject = ClientTest.createSQLQueryObjectCore(tipo, false);
                if (!count) {
                    sqlQueryObject.addOrderBy("mittente");
                    sqlQueryObject.addOrderBy("destinatario", false);
                    sqlQueryObject.setSortType(true);
                }
                String test = null;
                test = count ? sqlQueryObject.createSQLUnionCount(unionAll, "aliasUnion", prepare1, prepare2) : sqlQueryObject.createSQLUnion(unionAll, prepare1, prepare2);
                log.info("\nTest(count:" + count + " unionAll:" + unionAll + ") [" + tipo.toString() + "] [Normale UnionAll]:\n\t" + test);
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (stmtQuery != null) {
                    stmtQuery.close();
                    stmtQuery = null;
                }
                stmtQuery = con.createStatement();
                rs = stmtQuery.executeQuery(test);
                index = 0;
                if (rs.next()) {
                    if (count) {
                        long cont = rs.getLong("aliasUnion");
                        log.info("riga[" + index++ + "]= [" + cont + "]");
                        if (unionAll) {
                            if (cont != (long)(limit * 2)) {
                                throw new Exception("Expected " + limit * 2 + ", found " + cont);
                            }
                        } else if (cont != (long)limit) {
                            throw new Exception("Expected " + limit + ", found " + cont);
                        }
                    } else {
                        String mit = rs.getString("mittente");
                        long cont = rs.getLong("cont");
                        log.info("riga[" + index++ + "]= (" + mit + "):[" + cont + "]");
                        if (mit.endsWith("10")) {
                            if (cont != 1L) {
                                throw new Exception("Expected 1, found " + cont);
                            }
                        } else if (cont != 2L) {
                            throw new Exception("Expected 2, found " + cont);
                        }
                        while (rs.next()) {
                            mit = rs.getString("mittente");
                            cont = rs.getLong("cont");
                            log.info("riga[" + index++ + "]= (" + mit + "):[" + cont + "]");
                            if (mit.endsWith("10")) {
                                if (cont == 1L) continue;
                                if (rs != null) {
                                    rs.close();
                                    rs = null;
                                }
                                if (stmtQuery != null) {
                                    stmtQuery.close();
                                    stmtQuery = null;
                                }
                                throw new Exception("Expected 1, found " + cont);
                            }
                            if (cont == 2L) continue;
                            if (rs != null) {
                                rs.close();
                                rs = null;
                            }
                            if (stmtQuery != null) {
                                stmtQuery.close();
                                stmtQuery = null;
                            }
                            throw new Exception("Expected 2, found " + cont);
                        }
                    }
                } else {
                    throw new Exception("Test failed");
                }
                if (count) {
                    if (index != 1) {
                        throw new Exception("Test failed (expected 1 rows, found:" + index + ")");
                    }
                } else if (unionAll) {
                    if (index != limit * 2) {
                        throw new Exception("Test failed (expected " + limit * 2 + " rows, found:" + index + ")");
                    }
                } else if (index != limit) {
                    throw new Exception("Test failed (expected " + limit + " rows, found:" + index + ")");
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (stmtQuery != null) {
                    stmtQuery.close();
                    stmtQuery = null;
                }
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                }
                catch (Exception limit) {}
                try {
                    if (stmtQuery != null) {
                        stmtQuery.close();
                        stmtQuery = null;
                    }
                }
                catch (Exception limit) {}
            }
            if (!count) {
                String msgOffset = "Non e' possibile usare offset se non e' stato indicato alcun field nella select piu' esterna della union";
                String msgLimit = "Non e' possibile usare limit se non e' stato indicato alcun field nella select piu' esterna della union";
                log.info("\n\nf. ** Query Union con select* e LimitOffset (unionCount:" + count + " unionAll:" + unionAll + ")");
                int limit = 5;
                ISQLQueryObject prepare12 = ClientTest.prepareForUnion(ClientTest.createSQLQueryObjectCore(tipo, selectForUpdate), limit);
                ISQLQueryObject prepare22 = ClientTest.prepareForUnion(ClientTest.createSQLQueryObjectCore(tipo, selectForUpdate), limit);
                SQLQueryObjectCore sqlQueryObject2 = ClientTest.createSQLQueryObjectCore(tipo, false);
                sqlQueryObject2.addOrderBy("mittente");
                sqlQueryObject2.addOrderBy("destinatario", false);
                sqlQueryObject2.setSortType(true);
                sqlQueryObject2.setLimit(10);
                sqlQueryObject2.setOffset(2);
                try {
                    if (count) {
                        log.info("[" + tipo.toString() + "] f. OffSetLimit *: \n\t" + sqlQueryObject2.createSQLUnionCount(unionAll, "aliasUnion", prepare12, prepare22));
                    } else {
                        log.info("[" + tipo.toString() + "] f. OffSetLimit *: \n\t" + sqlQueryObject2.createSQLUnion(unionAll, prepare12, prepare22));
                    }
                    throw new Exception("Attesa eccezione: Non e' possibile usare offset se non e' stato indicato alcun field nella select piu' esterna della union");
                }
                catch (SQLQueryObjectException s) {
                    if (!s.getMessage().equals(msgOffset)) {
                        throw new Exception("Attesa eccezione: [" + msgOffset + "]. Trovata: [" + s.getMessage() + "]");
                    }
                    log.info("\n\ng. ** Query Union con select* e Offset (unionCount:" + count + " unionAll:" + unionAll + ")");
                    sqlQueryObject2 = ClientTest.createSQLQueryObjectCore(tipo, false);
                    sqlQueryObject2.addOrderBy("mittente");
                    sqlQueryObject2.addOrderBy("destinatario", false);
                    sqlQueryObject2.setSortType(true);
                    sqlQueryObject2.setOffset(2);
                    try {
                        if (count) {
                            log.info("[" + tipo.toString() + "] g. OffSet *: \n\t" + sqlQueryObject2.createSQLUnionCount(unionAll, "aliasUnion", prepare12, prepare22));
                        } else {
                            log.info("[" + tipo.toString() + "] g. OffSet *: \n\t" + sqlQueryObject2.createSQLUnion(unionAll, prepare12, prepare22));
                        }
                        throw new Exception("Attesa eccezione: Non e' possibile usare offset se non e' stato indicato alcun field nella select piu' esterna della union");
                    }
                    catch (SQLQueryObjectException s2) {
                        if (!s2.getMessage().equals(msgOffset)) {
                            throw new Exception("Attesa eccezione: [" + msgOffset + "]. Trovata: [" + s2.getMessage() + "]");
                        }
                        log.info("\n\nh. ** Query Union con select* e Limit (unionCount:" + count + " unionAll:" + unionAll + ")");
                        sqlQueryObject2 = ClientTest.createSQLQueryObjectCore(tipo, false);
                        sqlQueryObject2.addOrderBy("mittente");
                        sqlQueryObject2.addOrderBy("destinatario", false);
                        sqlQueryObject2.setSortType(true);
                        sqlQueryObject2.setLimit(10);
                        try {
                            if (count) {
                                log.info("[" + tipo.toString() + "] h Limit *: \n\t" + sqlQueryObject2.createSQLUnionCount(unionAll, "aliasUnion", prepare12, prepare22));
                            } else {
                                log.info("[" + tipo.toString() + "] h Limit *: \n\t" + sqlQueryObject2.createSQLUnion(unionAll, prepare12, prepare22));
                            }
                            throw new Exception("Attesa eccezione: Non e' possibile usare limit se non e' stato indicato alcun field nella select piu' esterna della union");
                        }
                        catch (SQLQueryObjectException s3) {
                            if (s3.getMessage().equals(msgLimit) || s3.getMessage().equals(msgOffset)) break block225;
                            throw new Exception("Attesa eccezione: [" + msgLimit + "] oppure [" + msgOffset + "]. Trovata: [" + s3.getMessage() + "]");
                        }
                    }
                }
            }
        }
        if (selectForUpdate) {
            boolean findError = false;
            try {
                log.info("\n\ni. ** Query Union per test SelectForUpdate (unionCount:" + count + " unionAll:" + unionAll + ")");
                int limit = 5;
                ISQLQueryObject prepare1 = ClientTest.prepareForUnionSelectForUpdate(ClientTest.createSQLQueryObjectCore(tipo, selectForUpdate), limit);
                ISQLQueryObject prepare2 = ClientTest.prepareForUnionSelectForUpdate(ClientTest.createSQLQueryObjectCore(tipo, selectForUpdate), limit);
                SQLQueryObjectCore sqlQueryObject = ClientTest.createSQLQueryObjectCore(tipo, false);
                sqlQueryObject.addSelectAliasField("mittente", "mit");
                sqlQueryObject.addSelectAliasField("destinatario", "dest");
                if (!count) {
                    sqlQueryObject.addOrderBy("mittente");
                    sqlQueryObject.addOrderBy("destinatario", false);
                    sqlQueryObject.setSortType(true);
                }
                String test = null;
                test = count ? sqlQueryObject.createSQLUnionCount(unionAll, "aliasUnion", prepare1, prepare2) : sqlQueryObject.createSQLUnion(unionAll, prepare1, prepare2);
            }
            catch (Exception e) {
                findError = true;
                log.info("ERRORE ATTESO: " + e.getMessage());
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                }
                catch (Exception exception) {}
                try {
                    if (stmtQuery != null) {
                        stmtQuery.close();
                        stmtQuery = null;
                    }
                }
                catch (Exception exception) {}
            }
            if (!findError) {
                throw new Exception("Atteso errore utilizzo select for update non permesso in union");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testUnionWithGroupBy_engine(TipiDatabase tipo, boolean count, boolean unionAll, Connection con, boolean selectForUpdate) throws Exception {
        SQLQueryObjectCore sqlQueryObject;
        ISQLQueryObject prepare2;
        ISQLQueryObject prepare1;
        block194: {
            long cont;
            String mit;
            ResultSet rs;
            Statement stmtQuery;
            block193: {
                block192: {
                    stmtQuery = null;
                    rs = null;
                    try {
                        log.info("\n\na. ** Query UnionGroupBy (unionCount:" + count + " unionAll:" + unionAll + ")");
                        int limit = 5;
                        prepare1 = ClientTest.prepareForUnion(ClientTest.createSQLQueryObjectCore(tipo, selectForUpdate), limit);
                        prepare2 = ClientTest.prepareForUnion(ClientTest.createSQLQueryObjectCore(tipo, selectForUpdate), limit);
                        sqlQueryObject = ClientTest.createSQLQueryObjectCore(tipo, false);
                        sqlQueryObject.addSelectAliasField("mittente", "mit");
                        sqlQueryObject.addSelectSumField("cont", "contRisultatoGroupBy");
                        if (!count) {
                            sqlQueryObject.addOrderBy("mittente");
                            sqlQueryObject.addOrderBy("destinatario", false);
                            sqlQueryObject.setSortType(true);
                        }
                        sqlQueryObject.addGroupBy("mittente");
                        sqlQueryObject.addGroupBy("destinatario");
                        String test = null;
                        test = count ? sqlQueryObject.createSQLUnionCount(unionAll, "aliasUnion", prepare1, prepare2) : sqlQueryObject.createSQLUnion(unionAll, prepare1, prepare2);
                        log.info("\nTest(count:" + count + " unionAll:" + unionAll + ") [" + tipo.toString() + "] [Normale UnionAll]:\n\t" + test);
                        stmtQuery = con.createStatement();
                        rs = stmtQuery.executeQuery(test);
                        int index = 0;
                        if (rs.next()) {
                            if (count) {
                                long cont2 = rs.getLong("aliasUnion");
                                log.info("riga[" + index++ + "]= [" + cont2 + "]");
                                if (cont2 != (long)limit) {
                                    throw new Exception("Expected " + limit + ", found " + cont2);
                                }
                            } else {
                                String mit2 = rs.getString("mit");
                                long cont3 = rs.getLong("contRisultatoGroupBy");
                                log.info("riga[" + index++ + "]= (" + mit2 + "):[" + cont3 + "]");
                                if (mit2.endsWith("10")) {
                                    if (unionAll) {
                                        if (cont3 != 2L) {
                                            throw new Exception("Expected 2, found " + cont3);
                                        }
                                    } else if (cont3 != 1L) {
                                        throw new Exception("Expected 1, found " + cont3);
                                    }
                                } else if (unionAll) {
                                    if (cont3 != 4L) {
                                        throw new Exception("Expected 4, found " + cont3);
                                    }
                                } else if (cont3 != 2L) {
                                    throw new Exception("Expected 2, found " + cont3);
                                }
                                while (rs.next()) {
                                    mit2 = rs.getString("mit");
                                    cont3 = rs.getLong("contRisultatoGroupBy");
                                    log.info("riga[" + index++ + "]= (" + mit2 + "):[" + cont3 + "]");
                                    if (mit2.endsWith("10")) {
                                        if (unionAll) {
                                            if (cont3 == 2L) continue;
                                            if (rs != null) {
                                                rs.close();
                                                rs = null;
                                            }
                                            if (stmtQuery != null) {
                                                stmtQuery.close();
                                                stmtQuery = null;
                                            }
                                            throw new Exception("Expected 2, found " + cont3);
                                        }
                                        if (cont3 == 1L) continue;
                                        if (rs != null) {
                                            rs.close();
                                            rs = null;
                                        }
                                        if (stmtQuery != null) {
                                            stmtQuery.close();
                                            stmtQuery = null;
                                        }
                                        throw new Exception("Expected 1, found " + cont3);
                                    }
                                    if (unionAll) {
                                        if (cont3 == 4L) continue;
                                        if (rs != null) {
                                            rs.close();
                                            rs = null;
                                        }
                                        if (stmtQuery != null) {
                                            stmtQuery.close();
                                            stmtQuery = null;
                                        }
                                        throw new Exception("Expected 4, found " + cont3);
                                    }
                                    if (cont3 == 2L) continue;
                                    if (rs != null) {
                                        rs.close();
                                        rs = null;
                                    }
                                    if (stmtQuery != null) {
                                        stmtQuery.close();
                                        stmtQuery = null;
                                    }
                                    throw new Exception("Expected 2, found " + cont3);
                                }
                            }
                        } else {
                            throw new Exception("Test failed");
                        }
                        if (count) {
                            if (index != 1) {
                                throw new Exception("Test failed (expected 1 rows, found:" + index + ")");
                            }
                        } else if (index != limit) {
                            throw new Exception("Test failed (expected " + limit + " rows, found:" + index + ")");
                        }
                        if (rs != null) {
                            rs.close();
                            rs = null;
                        }
                        if (stmtQuery != null) {
                            stmtQuery.close();
                            stmtQuery = null;
                        }
                    }
                    finally {
                        try {
                            if (rs != null) {
                                rs.close();
                                rs = null;
                            }
                        }
                        catch (Exception limit) {}
                        try {
                            if (stmtQuery != null) {
                                stmtQuery.close();
                                stmtQuery = null;
                            }
                        }
                        catch (Exception limit) {}
                    }
                    try {
                        if (count) break block192;
                        log.info("\n\nb. ** Query UnionGroupBy OffSetLimit (unionCount:" + count + " unionAll:" + unionAll + ")");
                        int limit = 5;
                        prepare1 = ClientTest.prepareForUnion(ClientTest.createSQLQueryObjectCore(tipo, selectForUpdate), limit);
                        prepare2 = ClientTest.prepareForUnion(ClientTest.createSQLQueryObjectCore(tipo, selectForUpdate), limit);
                        sqlQueryObject = ClientTest.createSQLQueryObjectCore(tipo, false);
                        sqlQueryObject.addSelectAliasField("mittente", "mit");
                        sqlQueryObject.addSelectSumField("cont", "contRisultatoGroupBy");
                        sqlQueryObject.addOrderBy("mittente");
                        sqlQueryObject.addOrderBy("destinatario", false);
                        sqlQueryObject.setSortType(true);
                        sqlQueryObject.addGroupBy("mittente");
                        sqlQueryObject.addGroupBy("destinatario");
                        int limitEsterno = 6;
                        int offset = 2;
                        sqlQueryObject.setLimit(limitEsterno /= 2);
                        sqlQueryObject.setOffset(offset /= 2);
                        String test = sqlQueryObject.createSQLUnion(unionAll, prepare1, prepare2);
                        log.info("\nTest(count:" + count + " unionAll:" + unionAll + ") [" + tipo.toString() + "] [OffSetLimit UnionAll]:\n\t" + test);
                        stmtQuery = con.createStatement();
                        rs = stmtQuery.executeQuery(test);
                        int index = 0;
                        if (rs.next()) {
                            mit = rs.getString("mit");
                            cont = rs.getLong("contRisultatoGroupBy");
                            log.info("riga[" + index++ + "]= (" + mit + "):[" + cont + "]");
                            if (mit.endsWith("10")) {
                                if (unionAll) {
                                    if (cont != 2L) {
                                        throw new Exception("Expected 2, found " + cont);
                                    }
                                } else if (cont != 1L) {
                                    throw new Exception("Expected 1, found " + cont);
                                }
                            } else if (unionAll) {
                                if (cont != 4L) {
                                    throw new Exception("Expected 4, found " + cont);
                                }
                            } else if (cont != 2L) {
                                throw new Exception("Expected 2, found " + cont);
                            }
                            while (rs.next()) {
                                mit = rs.getString("mit");
                                cont = rs.getLong("contRisultatoGroupBy");
                                log.info("riga[" + index++ + "]= (" + mit + "):[" + cont + "]");
                                if (mit.endsWith("10")) {
                                    if (unionAll) {
                                        if (cont == 2L) continue;
                                        if (rs != null) {
                                            rs.close();
                                            rs = null;
                                        }
                                        if (stmtQuery != null) {
                                            stmtQuery.close();
                                            stmtQuery = null;
                                        }
                                        throw new Exception("Expected 2, found " + cont);
                                    }
                                    if (cont == 1L) continue;
                                    if (rs != null) {
                                        rs.close();
                                        rs = null;
                                    }
                                    if (stmtQuery != null) {
                                        stmtQuery.close();
                                        stmtQuery = null;
                                    }
                                    throw new Exception("Expected 1, found " + cont);
                                }
                                if (unionAll) {
                                    if (cont == 4L) continue;
                                    if (rs != null) {
                                        rs.close();
                                        rs = null;
                                    }
                                    if (stmtQuery != null) {
                                        stmtQuery.close();
                                        stmtQuery = null;
                                    }
                                    throw new Exception("Expected 4, found " + cont);
                                }
                                if (cont == 2L) continue;
                                if (rs != null) {
                                    rs.close();
                                    rs = null;
                                }
                                if (stmtQuery != null) {
                                    stmtQuery.close();
                                    stmtQuery = null;
                                }
                                throw new Exception("Expected 2, found " + cont);
                            }
                        } else {
                            throw new Exception("Test failed");
                        }
                        if (index != limitEsterno) {
                            throw new Exception("Test failed (expected " + limitEsterno + " rows, found:" + index + ")");
                        }
                        if (rs != null) {
                            rs.close();
                            rs = null;
                        }
                        if (stmtQuery != null) {
                            stmtQuery.close();
                            stmtQuery = null;
                        }
                    }
                    finally {
                        try {
                            if (rs != null) {
                                rs.close();
                                rs = null;
                            }
                        }
                        catch (Exception limit) {}
                        try {
                            if (stmtQuery != null) {
                                stmtQuery.close();
                                stmtQuery = null;
                            }
                        }
                        catch (Exception limit) {}
                    }
                }
                try {
                    if (count) break block193;
                    log.info("\n\nc. ** Query UnionGroupBy  OffSet (unionCount:" + count + " unionAll:" + unionAll + ")");
                    int limit = 5;
                    prepare1 = ClientTest.prepareForUnion(ClientTest.createSQLQueryObjectCore(tipo, selectForUpdate), limit);
                    prepare2 = ClientTest.prepareForUnion(ClientTest.createSQLQueryObjectCore(tipo, selectForUpdate), limit);
                    sqlQueryObject = ClientTest.createSQLQueryObjectCore(tipo, false);
                    sqlQueryObject.addSelectAliasField("mittente", "mit");
                    sqlQueryObject.addSelectSumField("cont", "contRisultatoGroupBy");
                    sqlQueryObject.addOrderBy("mittente");
                    sqlQueryObject.addOrderBy("destinatario", false);
                    sqlQueryObject.setSortType(true);
                    sqlQueryObject.addGroupBy("mittente");
                    sqlQueryObject.addGroupBy("destinatario");
                    int offset = 2;
                    int numeroEntriesRisultato = limit * 2 - (offset /= 2);
                    numeroEntriesRisultato = limit - offset;
                    sqlQueryObject.setOffset(offset);
                    String test = sqlQueryObject.createSQLUnion(unionAll, prepare1, prepare2);
                    log.info("\nTest(count:" + count + " unionAll:" + unionAll + ") [" + tipo.toString() + "] [OffSet UnionAll]:\n\t" + test);
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (stmtQuery != null) {
                        stmtQuery.close();
                        stmtQuery = null;
                    }
                    stmtQuery = con.createStatement();
                    rs = stmtQuery.executeQuery(test);
                    int index = 0;
                    if (rs.next()) {
                        mit = rs.getString("mit");
                        cont = rs.getLong("contRisultatoGroupBy");
                        log.info("riga[" + index++ + "]= (" + mit + "):[" + cont + "]");
                        if (mit.endsWith("10")) {
                            if (unionAll) {
                                if (cont != 2L) {
                                    throw new Exception("Expected 2, found " + cont);
                                }
                            } else if (cont != 1L) {
                                throw new Exception("Expected 1, found " + cont);
                            }
                        } else if (unionAll) {
                            if (cont != 4L) {
                                throw new Exception("Expected 4, found " + cont);
                            }
                        } else if (cont != 2L) {
                            throw new Exception("Expected 2, found " + cont);
                        }
                        while (rs.next()) {
                            mit = rs.getString("mit");
                            cont = rs.getLong("contRisultatoGroupBy");
                            log.info("riga[" + index++ + "]= (" + mit + "):[" + cont + "]");
                            if (mit.endsWith("10")) {
                                if (unionAll) {
                                    if (cont == 2L) continue;
                                    throw new Exception("Expected 2, found " + cont);
                                }
                                if (cont == 1L) continue;
                                throw new Exception("Expected 1, found " + cont);
                            }
                            if (unionAll) {
                                if (cont == 4L) continue;
                                throw new Exception("Expected 4, found " + cont);
                            }
                            if (cont == 2L) continue;
                            throw new Exception("Expected 2, found " + cont);
                        }
                    } else {
                        throw new Exception("Test failed");
                    }
                    if (index != numeroEntriesRisultato) {
                        throw new Exception("Test failed (expected " + numeroEntriesRisultato + " rows, found:" + index + ")");
                    }
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (stmtQuery != null) {
                        stmtQuery.close();
                        stmtQuery = null;
                    }
                }
                finally {
                    try {
                        if (rs != null) {
                            rs.close();
                            rs = null;
                        }
                    }
                    catch (Exception limit) {}
                    try {
                        if (stmtQuery != null) {
                            stmtQuery.close();
                            stmtQuery = null;
                        }
                    }
                    catch (Exception limit) {}
                }
            }
            try {
                if (count) break block194;
                log.info("\n\nd. ** Query UnionGroupBy Limit (unionCount:" + count + " unionAll:" + unionAll + ")");
                int limit = 5;
                prepare1 = ClientTest.prepareForUnion(ClientTest.createSQLQueryObjectCore(tipo, selectForUpdate), limit);
                prepare2 = ClientTest.prepareForUnion(ClientTest.createSQLQueryObjectCore(tipo, selectForUpdate), limit);
                sqlQueryObject = ClientTest.createSQLQueryObjectCore(tipo, false);
                sqlQueryObject.addSelectAliasField("mittente", "mit");
                sqlQueryObject.addSelectSumField("cont", "contRisultatoGroupBy");
                sqlQueryObject.addOrderBy("mittente");
                sqlQueryObject.addOrderBy("destinatario", false);
                sqlQueryObject.setSortType(true);
                sqlQueryObject.addGroupBy("mittente");
                sqlQueryObject.addGroupBy("destinatario");
                int limitEsterno = 4;
                sqlQueryObject.setLimit(limitEsterno /= 2);
                String test = sqlQueryObject.createSQLUnion(unionAll, prepare1, prepare2);
                log.info("\nTest(count:" + count + " unionAll:" + unionAll + ") [" + tipo.toString() + "] [OffSet UnionAll]:\n\t" + test);
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (stmtQuery != null) {
                    stmtQuery.close();
                    stmtQuery = null;
                }
                stmtQuery = con.createStatement();
                rs = stmtQuery.executeQuery(test);
                int index = 0;
                boolean foundEndsWith10 = false;
                if (rs.next()) {
                    mit = rs.getString("mit");
                    cont = rs.getLong("contRisultatoGroupBy");
                    log.info("riga[" + index++ + "]= (" + mit + "):[" + cont + "]");
                    if (mit.endsWith("10")) {
                        if (unionAll) {
                            if (cont != 2L) {
                                throw new Exception("Expected 2, found " + cont);
                            }
                        } else if (cont != 1L) {
                            throw new Exception("Expected 1, found " + cont);
                        }
                    } else if (unionAll) {
                        if (cont != 4L) {
                            throw new Exception("Expected 4, found " + cont);
                        }
                    } else if (cont != 2L) {
                        throw new Exception("Expected 2, found " + cont);
                    }
                    while (rs.next()) {
                        mit = rs.getString("mit");
                        cont = rs.getLong("contRisultatoGroupBy");
                        log.info("riga[" + index++ + "]= (" + mit + "):[" + cont + "]");
                        if (mit.endsWith("10")) {
                            if (unionAll) {
                                if (cont == 2L) continue;
                                if (rs != null) {
                                    rs.close();
                                    rs = null;
                                }
                                if (stmtQuery != null) {
                                    stmtQuery.close();
                                    stmtQuery = null;
                                }
                                throw new Exception("Expected 2, found " + cont);
                            }
                            if (cont == 1L) continue;
                            if (rs != null) {
                                rs.close();
                                rs = null;
                            }
                            if (stmtQuery != null) {
                                stmtQuery.close();
                                stmtQuery = null;
                            }
                            throw new Exception("Expected 1, found " + cont);
                        }
                        if (unionAll) {
                            if (cont == 4L) continue;
                            if (rs != null) {
                                rs.close();
                                rs = null;
                            }
                            if (stmtQuery != null) {
                                stmtQuery.close();
                                stmtQuery = null;
                            }
                            throw new Exception("Expected 4, found " + cont);
                        }
                        if (cont == 2L) continue;
                        if (rs != null) {
                            rs.close();
                            rs = null;
                        }
                        if (stmtQuery != null) {
                            stmtQuery.close();
                            stmtQuery = null;
                        }
                        throw new Exception("Expected 2, found " + cont);
                    }
                } else {
                    throw new Exception("Test failed");
                }
                if (index != limitEsterno) {
                    throw new Exception("Test failed (expected " + limitEsterno + " rows, found:" + index + ")");
                }
                if (foundEndsWith10) {
                    throw new Exception("Test failed, unexpected element ends with 10");
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (stmtQuery != null) {
                    stmtQuery.close();
                    stmtQuery = null;
                }
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                }
                catch (Exception limit) {}
                try {
                    if (stmtQuery != null) {
                        stmtQuery.close();
                        stmtQuery = null;
                    }
                }
                catch (Exception limit) {}
            }
        }
        try {
            log.info("\n\ne. ** Query UnionGroupBy con select* (unionCount:" + count + " unionAll:" + unionAll + ")");
            int limit = 5;
            prepare1 = ClientTest.prepareForUnion(ClientTest.createSQLQueryObjectCore(tipo, selectForUpdate), limit);
            prepare2 = ClientTest.prepareForUnion(ClientTest.createSQLQueryObjectCore(tipo, selectForUpdate), limit);
            sqlQueryObject = ClientTest.createSQLQueryObjectCore(tipo, false);
            if (!count) {
                sqlQueryObject.addOrderBy("mittente");
                sqlQueryObject.addOrderBy("destinatario", false);
                sqlQueryObject.setSortType(true);
            }
            sqlQueryObject.addGroupBy("mittente");
            sqlQueryObject.addGroupBy("destinatario");
            String test = null;
            test = count ? sqlQueryObject.createSQLUnionCount(unionAll, "aliasUnion", prepare1, prepare2) : sqlQueryObject.createSQLUnion(unionAll, prepare1, prepare2);
            log.info("\nTest(count:" + count + " unionAll:" + unionAll + ") [" + tipo.toString() + "] [Normale UnionAll]:\n\t" + test);
            throw new Exception("Attesa eccezione: Non e' possibile utilizzare condizioni di group by se non sono stati indicati select field");
        }
        catch (SQLQueryObjectException s) {
            block195: {
                if (!s.getMessage().equals("Non e' possibile utilizzare condizioni di group by se non sono stati indicati select field")) {
                    throw new Exception("Attesa eccezione: Non e' possibile utilizzare condizioni di group by se non sono stati indicati select field. Trovata: " + s.getMessage());
                }
                if (!count) {
                    String msgOffset = "Non e' possibile usare offset se non e' stato indicato alcun field nella select piu' esterna della union";
                    String msgLimit = "Non e' possibile usare limit se non e' stato indicato alcun field nella select piu' esterna della union";
                    log.info("\n\nf. ** Query UnionGroupBy con select* e LimitOffset (unionCount:" + count + " unionAll:" + unionAll + ")");
                    int limit = 5;
                    ISQLQueryObject prepare12 = ClientTest.prepareForUnion(ClientTest.createSQLQueryObjectCore(tipo, selectForUpdate), limit);
                    ISQLQueryObject prepare22 = ClientTest.prepareForUnion(ClientTest.createSQLQueryObjectCore(tipo, selectForUpdate), limit);
                    SQLQueryObjectCore sqlQueryObject2 = ClientTest.createSQLQueryObjectCore(tipo, false);
                    sqlQueryObject2.addOrderBy("mittente");
                    sqlQueryObject2.addOrderBy("destinatario", false);
                    sqlQueryObject2.setSortType(true);
                    sqlQueryObject2.setLimit(10);
                    sqlQueryObject2.setOffset(2);
                    sqlQueryObject2.addGroupBy("mittente");
                    sqlQueryObject2.addGroupBy("destinatario");
                    try {
                        if (count) {
                            log.info("[" + tipo.toString() + "] f. OffSetLimit *: \n\t" + sqlQueryObject2.createSQLUnionCount(unionAll, "aliasUnion", prepare12, prepare22));
                        } else {
                            log.info("[" + tipo.toString() + "] f. OffSetLimit *: \n\t" + sqlQueryObject2.createSQLUnion(unionAll, prepare12, prepare22));
                        }
                        throw new Exception("Attesa eccezione: Non e' possibile usare offset se non e' stato indicato alcun field nella select piu' esterna della union");
                    }
                    catch (SQLQueryObjectException s2) {
                        if (!s2.getMessage().equals(msgOffset)) {
                            throw new Exception("Attesa eccezione: [" + msgOffset + "]. Trovata: [" + s2.getMessage() + "]");
                        }
                        log.info("\n\ng. ** Query UnionGroupBy con select* e Offset (unionCount:" + count + " unionAll:" + unionAll + ")");
                        sqlQueryObject2 = ClientTest.createSQLQueryObjectCore(tipo, false);
                        sqlQueryObject2.addOrderBy("mittente");
                        sqlQueryObject2.addOrderBy("destinatario", false);
                        sqlQueryObject2.setSortType(true);
                        sqlQueryObject2.setOffset(2);
                        sqlQueryObject2.addGroupBy("mittente");
                        sqlQueryObject2.addGroupBy("destinatario");
                        try {
                            if (count) {
                                log.info("[" + tipo.toString() + "] g. OffSet *: \n\t" + sqlQueryObject2.createSQLUnionCount(unionAll, "aliasUnion", prepare12, prepare22));
                            } else {
                                log.info("[" + tipo.toString() + "] g. OffSet *: \n\t" + sqlQueryObject2.createSQLUnion(unionAll, prepare12, prepare22));
                            }
                            throw new Exception("Attesa eccezione: Non e' possibile usare offset se non e' stato indicato alcun field nella select piu' esterna della union");
                        }
                        catch (SQLQueryObjectException s3) {
                            if (!s3.getMessage().equals(msgOffset)) {
                                throw new Exception("Attesa eccezione: [" + msgOffset + "]. Trovata: [" + s3.getMessage() + "]");
                            }
                            log.info("\n\nh. ** Query UnionGroupBy con select* e Limit (unionCount:" + count + " unionAll:" + unionAll + ")");
                            sqlQueryObject2 = ClientTest.createSQLQueryObjectCore(tipo, false);
                            sqlQueryObject2.addOrderBy("mittente");
                            sqlQueryObject2.addOrderBy("destinatario", false);
                            sqlQueryObject2.setSortType(true);
                            sqlQueryObject2.setLimit(10);
                            sqlQueryObject2.addGroupBy("mittente");
                            sqlQueryObject2.addGroupBy("destinatario");
                            try {
                                if (count) {
                                    log.info("[" + tipo.toString() + "] h Limit *: \n\t" + sqlQueryObject2.createSQLUnionCount(unionAll, "aliasUnion", prepare12, prepare22));
                                } else {
                                    log.info("[" + tipo.toString() + "] h Limit *: \n\t" + sqlQueryObject2.createSQLUnion(unionAll, prepare12, prepare22));
                                }
                                throw new Exception("Attesa eccezione: Non e' possibile usare limit se non e' stato indicato alcun field nella select piu' esterna della union");
                            }
                            catch (SQLQueryObjectException s4) {
                                if (s4.getMessage().equals(msgLimit) || s4.getMessage().equals(msgOffset)) break block195;
                                throw new Exception("Attesa eccezione: [" + msgLimit + "] oppure [" + msgOffset + "]. Trovata: [" + s4.getMessage() + "]");
                            }
                        }
                    }
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testEmptyNull_engine(TipiDatabase tipo, String table, Connection con, boolean selectForUpdate) throws Exception {
        Statement stmtQuery = null;
        ResultSet rs = null;
        try {
            log.info("\n\nh. ** Test IS NULL / IS EMPTY");
            SQLQueryObjectCore sqlQueryObject = ClientTest.createSQLQueryObjectCore(tipo, selectForUpdate);
            sqlQueryObject.addFromTable(table);
            sqlQueryObject.addSelectField("campo_vuoto");
            sqlQueryObject.addSelectField("descrizione");
            sqlQueryObject.addSelectField("gdo");
            sqlQueryObject.addWhereIsNullCondition("campo_vuoto");
            sqlQueryObject.addOrderBy("gdo");
            sqlQueryObject.setSortType(true);
            String testIsNull = sqlQueryObject.createSQLQuery();
            log.info("\ntest1-" + table + " isNull:\n\t" + testIsNull);
            stmtQuery = con.prepareStatement(testIsNull);
            rs = stmtQuery.executeQuery();
            int index = 0;
            while (rs.next()) {
                log.info("riga[" + index++ + "]=" + rs.getString("descrizione") + " (time:" + rs.getTimestamp("gdo") + " campo_vuoto:(" + rs.getString("campo_vuoto") + ")");
            }
            if (rs != null) {
                rs.close();
                rs = null;
            }
            if (stmtQuery != null) {
                stmtQuery.close();
                stmtQuery = null;
            }
            int attesi = 10;
            if (TipiDatabase.ORACLE.equals(tipo)) {
                attesi = 19;
            }
            log.info("Attesi [" + attesi + "] trovati[" + index + "]");
            if (attesi != index) {
                throw new Exception("Attesi [" + attesi + "] trovati[" + index + "]");
            }
            sqlQueryObject = ClientTest.createSQLQueryObjectCore(tipo, selectForUpdate);
            sqlQueryObject.addFromTable(table);
            sqlQueryObject.addSelectField("campo_vuoto");
            sqlQueryObject.addSelectField("descrizione");
            sqlQueryObject.addSelectField("gdo");
            sqlQueryObject.addWhereIsNotNullCondition("campo_vuoto");
            sqlQueryObject.addOrderBy("gdo");
            sqlQueryObject.setSortType(true);
            String testIsNotNull = sqlQueryObject.createSQLQuery();
            log.info("\ntest2-" + table + " isNotNull:\n\t" + testIsNotNull);
            stmtQuery = con.prepareStatement(testIsNotNull);
            rs = stmtQuery.executeQuery();
            int index2 = 0;
            while (rs.next()) {
                log.info("riga[" + index2++ + "]=" + rs.getString("descrizione") + " (time:" + rs.getTimestamp("gdo") + " campo_vuoto:(" + rs.getString("campo_vuoto") + ")");
            }
            if (rs != null) {
                rs.close();
                rs = null;
            }
            if (stmtQuery != null) {
                stmtQuery.close();
                stmtQuery = null;
            }
            int attesi2 = 11;
            if (TipiDatabase.ORACLE.equals(tipo)) {
                attesi2 = 2;
            }
            log.info("Attesi [" + attesi2 + "] trovati[" + index2 + "]");
            if (attesi2 != index2) {
                throw new Exception("Attesi [" + attesi2 + "] trovati[" + index2 + "]");
            }
            sqlQueryObject = ClientTest.createSQLQueryObjectCore(tipo, selectForUpdate);
            sqlQueryObject.addFromTable(table);
            sqlQueryObject.addSelectField("campo_vuoto");
            sqlQueryObject.addSelectField("descrizione");
            sqlQueryObject.addSelectField("gdo");
            sqlQueryObject.addWhereIsEmptyCondition("campo_vuoto");
            sqlQueryObject.addOrderBy("gdo");
            sqlQueryObject.setSortType(true);
            String testIsEmpty = sqlQueryObject.createSQLQuery();
            log.info("\ntest3-" + table + " isEmpty:\n\t" + testIsEmpty);
            stmtQuery = con.prepareStatement(testIsEmpty);
            rs = stmtQuery.executeQuery();
            int index3 = 0;
            while (rs.next()) {
                log.info("riga[" + index3++ + "]=" + rs.getString("descrizione") + " (time:" + rs.getTimestamp("gdo") + " campo_vuoto:(" + rs.getString("campo_vuoto") + ")");
            }
            if (rs != null) {
                rs.close();
                rs = null;
            }
            if (stmtQuery != null) {
                stmtQuery.close();
                stmtQuery = null;
            }
            int attesi3 = 9;
            if (TipiDatabase.ORACLE.equals(tipo)) {
                attesi3 = 19;
            }
            log.info("Attesi [" + attesi3 + "] trovati[" + index3 + "]");
            if (attesi3 != index3) {
                throw new Exception("Attesi [" + attesi3 + "] trovati[" + index3 + "]");
            }
            sqlQueryObject = ClientTest.createSQLQueryObjectCore(tipo, selectForUpdate);
            sqlQueryObject.addFromTable(table);
            sqlQueryObject.addSelectField("campo_vuoto");
            sqlQueryObject.addSelectField("descrizione");
            sqlQueryObject.addSelectField("gdo");
            sqlQueryObject.addWhereIsNotEmptyCondition("campo_vuoto");
            sqlQueryObject.addOrderBy("gdo");
            sqlQueryObject.setSortType(true);
            String testIsNotEmpty = sqlQueryObject.createSQLQuery();
            log.info("\ntest4-" + table + " isNotEmpty:\n\t" + testIsNotEmpty);
            stmtQuery = con.prepareStatement(testIsNotEmpty);
            rs = stmtQuery.executeQuery();
            int index4 = 0;
            while (rs.next()) {
                log.info("riga[" + index4++ + "]=" + rs.getString("descrizione") + " (time:" + rs.getTimestamp("gdo") + " campo_vuoto:(" + rs.getString("campo_vuoto") + ")");
            }
            if (rs != null) {
                rs.close();
                rs = null;
            }
            if (stmtQuery != null) {
                stmtQuery.close();
                stmtQuery = null;
            }
            int attesi4 = 2;
            if (TipiDatabase.ORACLE.equals(tipo)) {
                attesi4 = 2;
            }
            log.info("Attesi [" + attesi4 + "] trovati[" + index4 + "]");
            if (attesi4 != index4) {
                throw new Exception("Attesi [" + attesi4 + "] trovati[" + index4 + "]");
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
            }
            catch (Exception exception) {}
            try {
                if (stmtQuery != null) {
                    stmtQuery.close();
                    stmtQuery = null;
                }
            }
            catch (Exception exception) {}
        }
    }
}

