/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.utils.sonde;

import it.link.pdd.tools.migrazione_govway.utils.TipiDatabase;
import it.link.pdd.tools.migrazione_govway.utils.Utilities;
import it.link.pdd.tools.migrazione_govway.utils.sonde.Sonda;
import it.link.pdd.tools.migrazione_govway.utils.sonde.SondaFactory;
import it.link.pdd.tools.migrazione_govway.utils.sonde.impl.SondaBatch;
import it.link.pdd.tools.migrazione_govway.utils.sonde.impl.SondaCoda;
import it.link.pdd.tools.migrazione_govway.utils.sonde.impl.SondaInvocazione;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.Date;
import java.util.Properties;

public class ClientTest2 {
    public static void main(String[] args) throws Exception {
        String sondaCodaNameCustom;
        String sondaBatchNameCustom;
        String passwordCustom;
        String usernameCustom;
        String urlCustom;
        TipiDatabase tipoDatabase = TipiDatabase.POSTGRESQL;
        if (args.length > 0 && !"${tipoDatabase}".equals(args[0].trim())) {
            tipoDatabase = TipiDatabase.toEnumConstant(args[0].trim());
        }
        String url = null;
        String driver = null;
        String userName = null;
        String password = null;
        String sondaBatchName = "check-batch-esito-app";
        String sondaCodaName = "check-cnt-flussi";
        String sondaInvocazioneName = "check-db";
        switch (tipoDatabase) {
            case POSTGRESQL: {
                url = "jdbc:postgresql://localhost/proxysiope";
                driver = "org.postgresql.Driver";
                userName = "openspcoop2";
                password = "openspcoop2";
                break;
            }
            case MYSQL: {
                url = "jdbc:mysql://localhost/prova";
                driver = "com.mysql.jdbc.Driver";
                userName = "openspcoop2";
                password = "openspcoop2";
                break;
            }
            case ORACLE: {
                url = "jdbc:oracle:thin:@localhost:1521:XE";
                driver = "oracle.jdbc.OracleDriver";
                userName = "prova";
                password = "prova";
                break;
            }
            case HSQL: {
                url = "jdbc:hsqldb:hsql://localhost:9001/";
                driver = "org.hsqldb.jdbcDriver";
                userName = "sa";
                password = "";
                break;
            }
            case SQLSERVER: {
                url = "jdbc:sqlserver://localhost:1433;databaseName=prova";
                driver = "com.microsoft.sqlserver.jdbc.SQLServerDriver";
                userName = "openspcoop2";
                password = "openspcoop2";
                break;
            }
            case DB2: {
                url = "jdbc:db2://127.0.0.1:50000/prova";
                driver = "com.ibm.db2.jcc.DB2Driver";
                userName = "openspcoop2";
                password = "openspcoop2";
                break;
            }
        }
        if (args.length > 1 && !"${url}".equals(urlCustom = args[1].trim())) {
            url = urlCustom;
        }
        if (args.length > 2 && !"${username}".equals(usernameCustom = args[2].trim())) {
            userName = usernameCustom;
        }
        if (args.length > 3 && !"${password}".equals(passwordCustom = args[3].trim())) {
            password = passwordCustom;
        }
        if (args.length > 4 && !"${sondaBatchName}".equals(sondaBatchNameCustom = args[4].trim())) {
            sondaBatchName = sondaBatchNameCustom;
        }
        if (args.length > 5 && !"${sondaCodaName}".equals(sondaCodaNameCustom = args[5].trim())) {
            sondaCodaName = sondaCodaNameCustom;
        }
        Class.forName(driver).getConstructor(new Class[0]).newInstance(new Object[0]);
        Connection con = null;
        try {
            con = DriverManager.getConnection(url, userName, password);
            ClientTest2.testSondaBatch(sondaBatchName, tipoDatabase, con);
            ClientTest2.testSondaCoda(sondaCodaName, tipoDatabase, con);
            ClientTest2.testSondaInvocazione(sondaInvocazioneName, tipoDatabase, con);
        }
        catch (Exception e) {
            System.err.println("Errore durante il TestSonda: " + e.getMessage());
            e.printStackTrace(System.err);
        }
    }

    private static void checkStato(String nome, int expected, Sonda.StatoSonda actualState) throws Exception {
        if (expected != actualState.getStato()) {
            throw new Exception("Stato della sonda " + nome + " errato. Expected: " + expected + ". Actual: " + actualState.getStato() + ". Descrizione: " + actualState.getDescrizione());
        }
    }

    public static void testSondaError(TipiDatabase tipoDatabase, Connection con) throws Exception {
        Sonda sonda = SondaFactory.get("inesistente", con, tipoDatabase);
        if (sonda != null) {
            throw new Exception("Sonda inesistente trovata sul DB");
        }
        System.out.println("Test sonda inesistente ok");
        try {
            SondaFactory.get("malconfigurata", con, tipoDatabase);
        }
        catch (Exception e) {
            System.out.println("Test sonda malconfigurata ok");
            try {
                SondaFactory.get("sondaclasseacaso", con, tipoDatabase);
            }
            catch (Exception e1) {
                System.out.println("Test sonda sondaclasseacaso ok");
                return;
            }
            throw new Exception("Sonda classeacaso dovrebbe dare problemi di inizializzazione");
        }
        throw new Exception("Sonda malconfigurata dovrebbe dare problemi di inizializzazione");
    }

    public static void testSondaBatch(String sondaName, TipiDatabase tipoDatabase, Connection con) throws Exception {
        SondaFactory.updateConfSonda(sondaName, 1000L, 2000L, con, tipoDatabase);
        SondaBatch batch = (SondaBatch)SondaFactory.get(sondaName, con, tipoDatabase);
        if (batch == null) {
            throw new Exception("Sonda [" + sondaName + "] non trovata sul db");
        }
        Sonda.StatoSonda stato = batch.aggiornaStatoSonda(true, null, new Date(), "OK", con, tipoDatabase);
        ClientTest2.checkStato(sondaName, 0, stato);
        System.out.println("Test 1 batch ok. Descrizione: " + stato.getDescrizione());
        Utilities.sleep(1200L);
        stato = batch.getStatoSonda();
        ClientTest2.checkStato(sondaName, 1, stato);
        System.out.println("Test 2 batch ok. Descrizione: " + stato.getDescrizione());
        Utilities.sleep(1200L);
        stato = batch.getStatoSonda();
        ClientTest2.checkStato(sondaName, 2, stato);
        System.out.println("Test 3 batch ok. Descrizione: " + stato.getDescrizione());
        stato = batch.aggiornaStatoSonda(true, null, new Date(), null, con, tipoDatabase);
        ClientTest2.checkStato(sondaName, 0, stato);
        System.out.println("Test 4 batch ok. Descrizione: " + stato.getDescrizione());
        stato = batch.aggiornaStatoSonda(false, null, new Date(), "Errore durante l'esecuzione del batch\n\nin due righe", con, tipoDatabase);
        ClientTest2.checkStato(sondaName, 2, stato);
        System.out.println("Test 5 batch ok. Descrizione: " + stato.getDescrizione());
        stato = batch.aggiornaStatoSonda(true, null, new Date(), null, con, tipoDatabase);
        ClientTest2.checkStato(sondaName, 0, stato);
        System.out.println("Test 6 batch ok. Descrizione: " + stato.getDescrizione());
    }

    public static void testSondaInvocazione(String sondaInvocazioneName, TipiDatabase tipoDatabase, Connection con) throws Exception {
        SondaInvocazione invocazione = (SondaInvocazione)SondaFactory.get(sondaInvocazioneName, con, tipoDatabase);
        if (invocazione == null) {
            throw new Exception("Sonda [" + sondaInvocazioneName + "] non trovata sul db");
        }
        Sonda.StatoSonda stato = invocazione.aggiornaStatoSonda(true, null, con, tipoDatabase);
        ClientTest2.checkStato(sondaInvocazioneName, 0, stato);
        System.out.println("Test 1 invocazione ok. Descrizione: " + stato.getDescrizione());
        stato = invocazione.aggiornaStatoSonda(false, null, con, tipoDatabase);
        ClientTest2.checkStato(sondaInvocazioneName, 2, stato);
        System.out.println("Test 2 invocazione ko. Descrizione: " + stato.getDescrizione());
        Properties props = new Properties();
        String key = "subCode";
        String value = "ERR_000\na";
        props.setProperty(key, value);
        Sonda.StatoSonda stato2 = invocazione.aggiornaStatoSonda(true, props, con, tipoDatabase);
        ClientTest2.checkStato(sondaInvocazioneName, 0, stato2);
        System.out.println("Test 3 invocazione ok. Descrizione: " + stato2.getDescrizione());
        SondaInvocazione invocazione2 = (SondaInvocazione)SondaFactory.get(sondaInvocazioneName, con, tipoDatabase);
        if (!invocazione2.getParam().getDatiCheck().containsKey(key)) {
            throw new Exception("Property [" + key + "] non correttamente salvata");
        }
        String property = invocazione2.getParam().getDatiCheck().getProperty(key);
        if (!property.equals(value)) {
            throw new Exception("Property [" + key + "] non correttamente salvata. Expected [" + value + "] found [" + property + "]");
        }
        System.out.println("Trovata property custom [" + key + "] [" + property + "]");
    }

    public static void testSondaCoda(String sondaCodaName, TipiDatabase tipoDatabase, Connection con) throws Exception {
        SondaCoda coda = (SondaCoda)SondaFactory.get(sondaCodaName, con, tipoDatabase);
        if (coda == null) {
            throw new Exception("Sonda [" + sondaCodaName + "] non trovata sul db");
        }
        Sonda.StatoSonda stato = coda.aggiornaStatoSonda(3L, null, con, tipoDatabase);
        ClientTest2.checkStato(sondaCodaName, 0, stato);
        System.out.println("Test 1 coda ok. Descrizione: " + stato.getDescrizione());
        stato = coda.aggiornaStatoSonda(11L, null, con, tipoDatabase);
        ClientTest2.checkStato(sondaCodaName, 1, stato);
        System.out.println("Test 2 coda ok. Descrizione: " + stato.getDescrizione());
        stato = coda.aggiornaStatoSonda(200L, null, con, tipoDatabase);
        ClientTest2.checkStato(sondaCodaName, 2, stato);
        System.out.println("Test 3 coda ok. Descrizione: " + stato.getDescrizione());
        stato = coda.aggiornaStatoSonda(3L, null, con, tipoDatabase);
        ClientTest2.checkStato(sondaCodaName, 0, stato);
        System.out.println("Test 4 coda ok. Descrizione: " + stato.getDescrizione());
    }
}

